#!/usr/bin/env php
<?php
/* Set the extpath and cconv binary. */
if(empty($argv[1])) die("Must give the module path.\n");
$basePath = $argv[1];

if(file_exists("{$basePath}/module"))
{
    foreach(glob("{$basePath}/module/*") as $moduleName)
    {
        $realModulePath  = realpath($moduleName);
        $moduleLangPath  = $realModulePath . '/lang/';
        $defaultLangFile = $moduleLangPath . 'zh-cn.php';
        $targetLangFile  = $moduleLangPath . 'zh-tw.php';
        if(file_exists($defaultLangFile))
        {
            system("cconv -f utf-8 -t UTF8-TW $defaultLangFile > $targetLangFile");
            $defaultLang = file_get_contents($targetLangFile);
            $targetLang  = str_replace('zh-cn', 'zh-tw', $defaultLang);
            file_put_contents($targetLangFile, $targetLang);
        }
    }
}

/* Convert the extened lang file. */
foreach(glob("$basePath/extension/*") as $extType)
{
    foreach(glob("$extType/*") as $moduleName)
    {
        /* Convert the main lang file. */
        $moduleLangPath  = realpath($moduleName) . '/lang/';
        $defaultLangFile = $moduleLangPath . 'zh-cn.php';
        $targetLangFile  = $moduleLangPath . 'zh-tw.php';
        if(file_exists($defaultLangFile)) system("cconv -f utf-8 -t UTF8-TW $defaultLangFile > $targetLangFile");

        foreach(glob("$moduleName/ext/lang/zh-cn/*.php") as $extLangFile)
        {
            $pathOfTW    = dirname(dirname($extLangFile)) . "/zh-tw";   // the path of the zh-tw extension.
            $extFileName = basename($extLangFile);                      // get the filename of lang extension file.
            if(!is_dir($pathOfTW)) mkdir($pathOfTW);
            system("cconv -f utf-8 -t UTF8-TW $extLangFile > $pathOfTW/$extFileName");
        }
    }
}
