<?php
error_reporting(0);
/**
 * This file is used to check the language items and actions.
 */
/* Define an emtpty control class as the base class of every module. */
class control {}
$config = new stdclass();
$config->global = new stdclass();
$config->global->flow = 'full';
$config->langs['en']    = 'en';
$config->langs['zh-cn'] = 'zh-cn';

/* set module root path and included the resource of group module. */
$moduleRoot = '../module/';
$lang = new stdclass();
$lang->resource = new stdclass();
foreach(glob($moduleRoot . '/group/ext/lang/zh-cn/*.php') as $resourceFile) include $resourceFile;

$lang->productCommon = '';
$lang->executionCommon = '';

$whiteList[] = 'bug-create';
$whiteList[] = 'doc-alllibs';
$whiteList[] = 'doc-sortbookorder';
$whiteList[] = 'feedback-products';
$whiteList[] = 'feedback-manageproduct';
$whiteList[] = 'file-download';
$whiteList[] = 'index-index';
$whiteList[] = 'my-effort';
$whiteList[] = 'my-todo';
$whiteList[] = 'story-create';
$whiteList[] = 'task-create';
$whiteList[] = 'todo-create';
$whiteList[] = 'tree-browse';
$whiteList[] = 'user-logout';

/* checking actions of every module. */
echo '-------------action checking-----------------' . "\n";
foreach(array($moduleRoot) as $subModuleRoot)
{
    foreach(glob($subModuleRoot . '*') as $modulePath)
    {
        $moduleName  = basename($modulePath);
        if(strpos('install|upgrade|convert|common|misc|editor', $moduleName) !== false) continue;
        $controlFile = $modulePath . '/control.php';
        if(file_exists($controlFile))
        {
            include $controlFile;
            if(class_exists($moduleName))
            {
                if($moduleName == 'block') continue;
                $class   = new ReflectionClass($moduleName);
                $methods = $class->getMethods();
                foreach($methods as $method)
                {
                    $methodRef = new ReflectionMethod($method->class, $method->name);
                    if($methodRef->isPublic() and strpos($method->name, '__') === false)
                    {
                        $methodName = $method->name;
                        if(in_array($moduleName . '-' . strtolower($method->name), $whiteList)) continue;
                        if(strpos($methodName, 'ajax') !== false) continue;

                        $exits = false;
                        if(isset($lang->resource->$moduleName))
                        {
                            foreach($lang->resource->$moduleName as $key => $label)
                            {
                                if(strtolower($methodName) == strtolower($key)) $exits = true;
                            }
                        }
                        if(!$exits) echo $moduleName . "\t" . $methodName . " not in the list. \n";
                    }
                }
            }
        }

        /* Checking extension files. */
        $extControlFiles = glob($modulePath . '/ext/control/*.php');
        if($extControlFiles)
        {
            foreach($extControlFiles as $extControlFile)
            {
                $methodFile = substr($extControlFile, strrpos($extControlFile, '/') + 1);
                $methodName = substr($methodFile, 0, strpos($methodFile, '.'));
                if(in_array($moduleName . '-' . strtolower($methodName), $whiteList)) continue;
                if(strpos($methodName, 'ajax') !== false) continue;

                $exits = false;
                foreach($lang->resource->$moduleName as $key => $label)
                {
                    if(strtolower($methodName) == strtolower($key)) $exits = true;
                }
                if(!$exits) echo $moduleName . "\t" . $methodName . " not in the list. \n";
            }
        }
    }
}

/* checking actions of every module. */
echo '-------------lang checking-----------------' . "\n";
foreach(glob($moduleRoot . '/common/ext/lang/zh-cn/*.php') as $resourceFile) include $resourceFile;
foreach(array($moduleRoot) as $subModuleRoot)
{
    foreach(glob($subModuleRoot . '*') as $modulePath)
    {
        unset($lang);
        $moduleName   = basename($modulePath);
        $mainLangFile = $modulePath . '/lang/zh-cn.php';
        if(file_exists($mainLangFile))
        {
            $mainLines = file($mainLangFile);
            foreach($config->langs as $langKey => $langName)
            {
                if($langKey == 'zh-cn' or $langKey == 'zh-tw') continue;
                $langFile = $modulePath . '/lang/' . $langKey . '.php';
                if(!file_exists($langFile)) continue;
                $lines = file($langFile);
                foreach($mainLines as $lineNO => $line)
                {
                    if(isset($lines[$lineNO]) and empty(trim($lines[$lineNO]))) continue;
                    if(empty(trim($line))) continue;
                    if(strpos($line, '$lang') === 0)
                    {
                        if(strpos($line, '=') !== false)
                        {
                            list($mainKey, $mainValue) = explode('=', $line);
                            list($key, $value) = explode('=', $lines[$lineNO]);
                        }
                        if((strpos($line, '=') === false and $line != $lines[$lineNO]) or trim($mainKey) != trim($key))
                        {
                            $key = trim($key);
                            $lineNO = $lineNO + 1;
                            echo "module $moduleName need checking, command is:";
                            echo " vim -O +$lineNO $modulePath/lang/zh-cn.php +$lineNO $modulePath/lang/en.php \n";
                            break;
                        }
                    }
                }
            }
        }

        foreach(glob($modulePath . '/ext/lang/zh-cn/*.php') as $extMainLangFile)
        {
            $extMainLines = file($extMainLangFile);
            $extLangFile  = basename($extMainLangFile);
            $extEnFile    = $modulePath . '/ext/lang/en/' . $extLangFile;
            $extLines     = file($extEnFile);
            foreach($extMainLines as $lineNO => $line)
            {
                if(strpos($line, '$lang') === false)
                {
                    //if($line != $lines[$lineNO]) echo $moduleName . ' ' . $langKey . ' ' . $lineNO . "\n";
                }
                else
                {
                    list($mainKey, $mainValue) = explode('=', $line);
                    list($key, $value) = explode('=', $extLines[$lineNO]);
                    if(trim($mainKey) != trim($key))
                    {
                        $key = trim($key);
                        $lineNO = $lineNO + 1;
                        echo "module $moduleName need checking, command is:";
                        echo " vim -O +$lineNO $modulePath/ext/lang/zh-cn/$extLangFile +$lineNO $modulePath/ext/lang/en/$extLangFile \n";
                        break;
                    }
                }
            }
        }
    }
}

echo '-------------php5.4 synatax checking-----------------' . "\n";
class app {function loadLang() {}}
$app = new app;
$lang = new stdclass();

error_reporting(E_WARNING | E_STRICT );
foreach(array($moduleRoot) as $subModuleRoot)
{
    foreach(glob($subModuleRoot . '*') as $modulePath)
    {
        $moduleName = basename($modulePath);
        $cnLangFile = $modulePath . '/lang/zh-cn.php';
        $enLangFile = $modulePath . '/lang/en.php';
        $configFile = $modulePath . '/config.php';

        if(!isset($lang->$moduleName)) $lang->$moduleName = new stdclass();
        if(!isset($config->$moduleName)) $config->$moduleName = new stdclass();
        if(file_exists($cnLangFile)) include $cnLangFile;
        if(file_exists($enLangFile)) include $enLangFile;
        if(file_exists($configFile)) include $configFile;
    }
}
