[English](README.md) | 中文

<p align="center"><a href="https://www.zentao.net" target="_blank" rel="noopener noreferrer"><img src="doc/img/zentao-cn.svg" width="300" alt="ZenTao Logo"></a></p>

<p align="center">
  <a href="https://www.php.net"><img src="https://img.shields.io/badge/php-%3E=5.6-brightgreen.svg?maxAge=2592000" alt="PHP Version"></a>
  <a href="https://github.com/easysoft/zentaopms/releases/latest"><img src="https://img.shields.io/github/release/easysoft/zentaopms.svg" alt="Latest Version"></a>
  <a href="mailto:chunsheng@easycorp.ltd"><img src="https://img.shields.io/badge/Email-chunsheng@easycorp.ltd-ea644a" alt="Email" /></a>
  <a href="https://github.com/easysoft/zentaopms/blob/master/COPYING"><img src="https://img.shields.io/badge/License-AGPL%20or%20ZPL-blue" alt="ZenTao License"></a>
  <a href="https://www.zentao.net"><img src="https://img.shields.io/badge/Website-www.zentao.net-blue" alt="ZenTao Website"></a>
</p>

# 介绍

禅道是第一款国产的开源项目管理软件。它集产品管理、项目管理、质量管理、文档管理、 组织管理和事务管理于一体，是一款专业的研发项目管理软件，完整地覆盖了项目管理的核心流程。

禅道管理思想注重实效，功能完备丰富，操作简洁高效，界面美观大方，搜索功能强大，统计报表丰富多样，软件架构合理，扩展灵活，有完善的 API 可以调用。

# 设计理念

禅和道是中国文化中极具代表意义的两个字，是中国传统文化的结晶。我们之所以选用“禅道”作为我们软件的名字，是希望通过这两个字来传达我们对管理的理解和思考。我们希望通过禅道来进行的管理，可以摒弃繁文缛节，还原管理的本质！

禅道项目管理软件的主要管理思想基于国际流行的`Scrum`模型、瀑布模型和看板模型三种项目管理方法：

- `Scrum`模型方法注重实效，操作性强，非常适合软件研发项目的快速迭代开发。

- 瀑布模型方法注重阶段清晰、流程严谨、范围可控，非常适合预先有明确定义且变动不大的产品研发管理。

- 看板模型方式注重价值流转和可视化，非常适合流程公开透明和信息高效传递的团队。

禅道首次创造性的将产品、项目、测试这三者的概念明确分开，产品人员、开发团队、测试人员，三者分立，互相配合，又互相制约，通过需求、任务、`BUG` 来进行交相互动，终通过项目拿到合格的产品。

在数据可视化、度量、`DevOps`、文档资产管理和自动化测试等模块的加持下，禅道软件形成了项目流程管理、`DevOps` 一体化、自动化测试等三大解决方案，完整的覆盖了产品研发的全生命周期管理，助力广大企业高效协作、降本提效。

# 官方网站

- [官网](https://www.zentao.net)
- [文档](https://www.zentao.net/book/zentaopms.html)
- [常见问题](https://www.zentao.net/faq.html)
- [插件库](https://www.zentao.net/extension-browse.html)

## Demo

- [开源版](https://www.zentao.net/demo/zentao.html)
- [企业版](https://www.zentao.net/demo/zentaobiz.html)
- [旗舰版](https://www.zentao.net/demo/zentaomax.html)

# 安全漏洞

如果您发现禅道项目管理软件中存在安全漏洞，请发送电子邮件至禅道官方团队，电子邮件地址为 chunsheng@easycorp.ltd ，所有安全漏洞都会被及时的解决。

# 开源协议

禅道是一个基于 [AGPL](https://www.gnu.org/licenses/agpl-3.0.en.html) 和 [ZPL](http://zpl.pub/page/zplv12.html) 双协议的开源项目管理软件。

---

也许您已经"众里寻她千百度"，那么让禅道带给您"蓦然回首，那人却在灯火阑珊处"的惊喜吧！

<details>
<summary><h1>增强版本<h1/></summary>

如果开源版的功能不能满足您的需要，可以考虑禅道[企业版](https://www.zentao.net/page/enterprise.html)、[旗舰版](https://www.zentao.net/page/max.html)或[云禅道](https://www.chandao.net)。

## 企业版

> 前往查看[企业版和开源版的对比](https://www.zentao.net/page/enterprise.html#diff)。

禅道企业版是在禅道开源版的基础上增加增强功能的版本，该版本也基于项目管理的流程做了横向拓展，覆盖了更多的角色。

一方面，企业版可以企业提供更完善的服务；增强功能更加适合企业的内部流程化管理。

另一方面，企业版还增加了运维管理、OA 办公管理、反馈管理，以及文档的版本管理及在线预览等功能，可以更有效地支持客户在研发管理流程之外的相关工作，为企业项目管理流程提供更全面的支撑。

## 旗舰版

> 前往查看[旗舰版功能对比](https://www.zentao.net/page/max.html#diff)。

旗舰版作为禅道最高的版本系列，可以完整覆盖项目管理的各个过程，帮助企业建立研发管理体系，提高企业管理流程的稳健性和项目管理成熟度，大大增加项目成功的概率。

旗舰版增强了流程控制、过程定义、项目度量、问题管理、风险管控、质量保证、项目报告等方面的功能，同时可以支持 CMMI 标准的落地实施，帮助企业通过 CMMI 评估，提升研发管理能力。

## 云禅道

> 前往了解和体验[云禅道](https://www.chandao.net)。

云禅道是禅道企业版和旗舰版的 SaaS 服务，使用便捷，一键即可开通，无需维护，禅道版本自动升级；资源与服务支持灵活扩容，资源按需购买；提供覆盖全国的 CDN 服务，访问更快；HTTPS 协议加密，更加安全；数据自动备份，随时下载备份至本地。

</details>
