<?php
/**
 * The tao file of product module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      chen.tao<chentao@easycorp.ltd>
 * @package     product
 * @link        https://www.zentao.net
 */

class fileTao extends fileModel
{
    /**
     * 保存一条文件数据。
     * Save one file data.
     *
     * @param  array     $file
     * @param  string    $strSkipFields
     * @access protected
     * @return int
     */
    protected function saveFile($file, $strSkipFields = '')
    {
        if(empty($file)) return false;

        $this->dao->insert(TABLE_FILE)->data($file, $strSkipFields)->exec();

        return $this->dao->lastInsertID();
    }
}
