<?php
define('JIRA_USER', '`app_user`');
define('JIRA_USERINFO', '`cwd_user`');
define('JIRA_PROJECT', '`project`');
define('JIRA_ISSUE', '`jiraissue`');
define('JIRA_ISSUETYPE', '`issuetype`');
define('JIRA_ISSUELINK', '`issuelink`');
define('JIRA_ISSUELINKTYPE', '`issuelinktype`');
define('JIRA_ISSUESTATUS', '`issuestatus`');
define('JIRA_RESOLUTION', '`resolution`');
define('JIRA_BUILD', '`projectversion`');
define('JIRA_ACTION', '`jiraaction`');
define('JIRA_NODEASSOCIATION', '`nodeassociation`');
define('JIRA_FILE', '`fileattachment`');
define('JIRA_FIXVERSION', '`fixversion`');
define('JIRA_AFFECTSVERSION', '`affectsversion`');
define('JIRA_PRIORITY', '`priority`');
define('JIRA_WORKFLOW', '`jiraworkflows`');
define('JIRA_WORKFLOWSCHEME', '`workflowscheme`');
define('JIRA_WORKLOG', '`worklog`');
define('JIRA_CHANGEITEM', '`changeitem`');
define('JIRA_CHANGEGROUP', '`changegroup`');
define('JIRA_AUDITLOG', '`audit_log`');
define('JIRA_MEMBERSHIP', '`cwd_membership`');
define('JIRA_PROJECTROLEACTOR', '`projectroleactor`');
define('JIRA_CUSTOMFIELD', '`customfield`');
define('JIRA_CUSTOMFIELDVALUE', '`customfieldvalue`');
define('JIRA_CUSTOMFIELDOPTION', '`customfieldoption`');
define('JIRA_OSPROPERTYENTRY', '`propertyentry`');
define('JIRA_OPTIONCONFIGURATION', '`optionconfiguration`');
define('JIRA_CONFIGURATIONCONTEXT', '`configurationcontext`');
define('JIRA_FIELDSCREENLAYOUTITEM', '`fieldscreenlayoutitem`');
define('JIRA_FIELDCONFIGSCHEME', '`fieldconfigscheme`');
define('JIRA_FIELDCONFIGSCHEMEISSUETYPE', '`fieldconfigschemeissuetype`');

$config->convert = new stdClass();
$config->convert->objectTables = array();
$config->convert->objectTables['user']                       = JIRA_USER;
$config->convert->objectTables['project']                    = JIRA_PROJECT;
$config->convert->objectTables['issue']                      = JIRA_ISSUE;
$config->convert->objectTables['build']                      = JIRA_BUILD;
$config->convert->objectTables['issuelink']                  = JIRA_ISSUELINK;
$config->convert->objectTables['issuetype']                  = JIRA_ISSUETYPE;
$config->convert->objectTables['issuelinktype']              = JIRA_ISSUELINKTYPE;
$config->convert->objectTables['resolution']                 = JIRA_RESOLUTION;
$config->convert->objectTables['nodeassociation']            = JIRA_NODEASSOCIATION;
$config->convert->objectTables['workflow']                   = JIRA_WORKFLOW;
$config->convert->objectTables['workflowscheme']             = JIRA_WORKFLOWSCHEME;
$config->convert->objectTables['worklog']                    = JIRA_WORKLOG;
$config->convert->objectTables['changeitem']                 = JIRA_CHANGEITEM;
$config->convert->objectTables['changegroup']                = JIRA_CHANGEGROUP;
$config->convert->objectTables['auditlog']                   = JIRA_AUDITLOG;
$config->convert->objectTables['status']                     = JIRA_ISSUESTATUS;
$config->convert->objectTables['action']                     = JIRA_ACTION;
$config->convert->objectTables['file']                       = JIRA_FILE;
$config->convert->objectTables['fixversion']                 = JIRA_FIXVERSION;
$config->convert->objectTables['affectsversion']             = JIRA_AFFECTSVERSION;
$config->convert->objectTables['priority']                   = JIRA_PRIORITY;
$config->convert->objectTables['membership']                 = JIRA_MEMBERSHIP;
$config->convert->objectTables['projectroleactor']           = JIRA_PROJECTROLEACTOR;
$config->convert->objectTables['customfield']                = JIRA_CUSTOMFIELD;
$config->convert->objectTables['customfieldvalue']           = JIRA_CUSTOMFIELDVALUE;
$config->convert->objectTables['customfieldoption']          = JIRA_CUSTOMFIELDOPTION;
$config->convert->objectTables['ospropertyentry']            = JIRA_OSPROPERTYENTRY;
$config->convert->objectTables['optionconfiguration']        = JIRA_OPTIONCONFIGURATION;
$config->convert->objectTables['configurationcontext']       = JIRA_CONFIGURATIONCONTEXT;
$config->convert->objectTables['fieldscreenlayoutitem']      = JIRA_FIELDSCREENLAYOUTITEM;
$config->convert->objectTables['fieldconfigscheme']          = JIRA_FIELDCONFIGSCHEME;
$config->convert->objectTables['fieldconfigschemeissuetype'] = JIRA_FIELDCONFIGSCHEMEISSUETYPE;

$config->convert->jiraFieldControl['com.atlassian.jira.plugin.system.customfieldtypes:textfield']       = array('control' => 'input',         'type' => 'varchar',  'length' => '255');
$config->convert->jiraFieldControl['com.atlassian.jira.plugin.system.customfieldtypes:labels']          = array('control' => 'input',         'type' => 'varchar',  'length' => '255');
$config->convert->jiraFieldControl['com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons']    = array('control' => 'radio',         'type' => 'varchar',  'length' => '255');
$config->convert->jiraFieldControl['com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes'] = array('control' => 'checkbox',      'type' => 'text',     'length' => '0');
$config->convert->jiraFieldControl['com.atlassian.jira.plugin.system.customfieldtypes:datetime']        = array('control' => 'datetime',      'type' => 'datetime', 'length' => '0');
$config->convert->jiraFieldControl['com.atlassian.jira.plugin.system.customfieldtypes:datepicker']      = array('control' => 'date',          'type' => 'date',     'length' => '0');
$config->convert->jiraFieldControl['com.atlassian.jira.plugin.system.customfieldtypes:textarea']        = array('control' => 'textarea',      'type' => 'text',     'length' => '0');
$config->convert->jiraFieldControl['com.atlassian.jira.plugin.system.customfieldtypes:float']           = array('control' => 'decimal',       'type' => 'decimal',  'length' => '0');
$config->convert->jiraFieldControl['com.atlassian.jira.plugin.system.customfieldtypes:multiselect']     = array('control' => 'multi-select',  'type' => 'text',     'length' => '0');
$config->convert->jiraFieldControl['com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect'] = array('control' => 'multi-select',  'type' => 'text',     'length' => '0');
$config->convert->jiraFieldControl['com.atlassian.jira.plugin.system.customfieldtypes:select']          = array('control' => 'select',        'type' => 'varchar',  'length' => '255');
$config->convert->jiraFieldControl['com.atlassian.jira.plugin.system.customfieldtypes:userpicker']      = array('control' => 'select',        'type' => 'varchar',  'length' => '255');
$config->convert->jiraFieldControl['com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker'] = array('control' => 'multi-select',  'type' => 'text',     'length' => '0');

$config->convert->objectFields['epic']        = array('module', 'source', 'sourceNote', 'keywords', 'mailto', 'estimate');
$config->convert->objectFields['requirement'] = $config->convert->objectFields['epic'];
$config->convert->objectFields['story']       = $config->convert->objectFields['epic'];
$config->convert->objectFields['bug']         = array('module', 'keywords', 'type', 'os', 'browser', 'hardware', 'feedbackBy', 'notifyEmail', 'deadline', 'resolvedBy', 'resolvedBuild', 'resolvedDate', 'mailto');
$config->convert->objectFields['task']        = array('module', 'type', 'estStarted', 'finishedBy', 'mailto');
$config->convert->objectFields['testcase']    = array('module', 'precondition', 'type', 'stage', 'scene', 'lastRunner', 'lastRunResult', 'keywords', 'mailto');
$config->convert->objectFields['feedback']    = array('module', 'type', 'solution', 'public', 'notify', 'notifyEmail', 'source', 'likes', 'processedBy', 'processedDate', 'feedbackBy', 'mailto');
$config->convert->objectFields['ticket']      = array('module', 'openedBuild', 'realStarted', 'startedBy', 'startedDate', 'deadline', 'resolvedBy', 'resolvedDate');

$config->convert->importDeafaultValue = array();
$config->convert->importDeafaultValue['zentaoObject']['Epic']      = 'requirement';
$config->convert->importDeafaultValue['zentaoObject']['长篇故事']  = 'requirement';
$config->convert->importDeafaultValue['zentaoObject']['Story']     = 'story';
$config->convert->importDeafaultValue['zentaoObject']['故事']      = 'story';
$config->convert->importDeafaultValue['zentaoObject']['需求']      = 'story';
$config->convert->importDeafaultValue['zentaoObject']['Sub-story'] = 'story';
$config->convert->importDeafaultValue['zentaoObject']['子需求']    = 'story';
$config->convert->importDeafaultValue['zentaoObject']['Task']      = 'task';
$config->convert->importDeafaultValue['zentaoObject']['任务']      = 'task';
$config->convert->importDeafaultValue['zentaoObject']['Sub-task']  = 'task';
$config->convert->importDeafaultValue['zentaoObject']['子任务']    = 'task';
$config->convert->importDeafaultValue['zentaoObject']['Bug']       = 'bug';
$config->convert->importDeafaultValue['zentaoObject']['测试']      = 'bug';
$config->convert->importDeafaultValue['zentaoObject']['故障']      = 'bug';
$config->convert->importDeafaultValue['zentaoObject']['Case']      = 'testcase';
$config->convert->importDeafaultValue['zentaoObject']['用例']      = 'testcase';

$config->convert->importDeafaultValue['bug']['status']['Open']        = 'active';
$config->convert->importDeafaultValue['bug']['status']['To Do']       = 'active';
$config->convert->importDeafaultValue['bug']['status']['In Progress'] = 'active';
$config->convert->importDeafaultValue['bug']['status']['Reopened']    = 'active';
$config->convert->importDeafaultValue['bug']['status']['In Review']   = 'active';
$config->convert->importDeafaultValue['bug']['status']['Resolved']    = 'resolved';
$config->convert->importDeafaultValue['bug']['status']['Done']        = 'closed';
$config->convert->importDeafaultValue['bug']['status']['Closed']      = 'closed';
$config->convert->importDeafaultValue['bug']['status']['待办']        = 'active';
$config->convert->importDeafaultValue['bug']['status']['进行中']      = 'active';
$config->convert->importDeafaultValue['bug']['status']['解决']        = 'resolved';
$config->convert->importDeafaultValue['bug']['status']['已完成']      = 'closed';

$config->convert->importDeafaultValue['task']['status']['Open']        = 'wait';
$config->convert->importDeafaultValue['task']['status']['To Do']       = 'wait';
$config->convert->importDeafaultValue['task']['status']['In Progress'] = 'doing';
$config->convert->importDeafaultValue['task']['status']['Reopened']    = 'doing';
$config->convert->importDeafaultValue['task']['status']['In Review']   = 'doing';
$config->convert->importDeafaultValue['task']['status']['Resolved']    = 'done';
$config->convert->importDeafaultValue['task']['status']['Done']        = 'closed';
$config->convert->importDeafaultValue['task']['status']['Closed']      = 'closed';
$config->convert->importDeafaultValue['task']['status']['待办']        = 'wait';
$config->convert->importDeafaultValue['task']['status']['进行中']      = 'doing';
$config->convert->importDeafaultValue['task']['status']['解决']        = 'done';
$config->convert->importDeafaultValue['task']['status']['已完成']      = 'closed';

$config->convert->importDeafaultValue['story']['status']['Open']        = 'draft';
$config->convert->importDeafaultValue['story']['status']['To Do']       = 'active';
$config->convert->importDeafaultValue['story']['status']['In Progress'] = 'active';
$config->convert->importDeafaultValue['story']['status']['Reopened']    = 'active';
$config->convert->importDeafaultValue['story']['status']['In Review']   = 'reviewing';
$config->convert->importDeafaultValue['story']['status']['Resolved']    = 'closed';
$config->convert->importDeafaultValue['story']['status']['Done']        = 'closed';
$config->convert->importDeafaultValue['story']['status']['Closed']      = 'closed';
$config->convert->importDeafaultValue['story']['status']['待办']        = 'draft';
$config->convert->importDeafaultValue['story']['status']['进行中']      = 'active';
$config->convert->importDeafaultValue['story']['status']['解决']        = 'closed';
$config->convert->importDeafaultValue['story']['status']['已完成']      = 'closed';

$config->convert->importDeafaultValue['bug']['action']['Create'] = 'create';
$config->convert->importDeafaultValue['task']['action']     = $config->convert->importDeafaultValue['bug']['action'];
$config->convert->importDeafaultValue['story']['action']    = $config->convert->importDeafaultValue['bug']['action'];
$config->convert->importDeafaultValue['testcase']['action'] = $config->convert->importDeafaultValue['bug']['action'];
$config->convert->importDeafaultValue['feedback']['action'] = $config->convert->importDeafaultValue['bug']['action'];
$config->convert->importDeafaultValue['ticket']['action']   = $config->convert->importDeafaultValue['bug']['action'];

$config->convert->importDeafaultValue['bug']['resolution']['Done']             = 'fixed';
$config->convert->importDeafaultValue['bug']['resolution']["Won't Do"]         = 'willnotfix';
$config->convert->importDeafaultValue['bug']['resolution']["Duplicate"]        = 'duplicate';
$config->convert->importDeafaultValue['bug']['resolution']["Cannot Reproduce"] = 'notrepro';
$config->convert->importDeafaultValue['bug']['resolution']["Declined"]         = 'willnotfix';
$config->convert->importDeafaultValue['bug']['resolution']['完成']             = 'fixed';
$config->convert->importDeafaultValue['bug']['resolution']["被否决"]           = 'willnotfix';
$config->convert->importDeafaultValue['bug']['resolution']["重复提交"]         = 'duplicate';
$config->convert->importDeafaultValue['bug']['resolution']["无法再次复现"]     = 'notrepro';
$config->convert->importDeafaultValue['bug']['resolution']["被拒绝"]           = 'willnotfix';

$config->convert->importDeafaultValue['task']['reason']['Done']             = 'done';
$config->convert->importDeafaultValue['task']['reason']["Won't Do"]         = 'cancel';
$config->convert->importDeafaultValue['task']['reason']["Duplicate"]        = 'cancel';
$config->convert->importDeafaultValue['task']['reason']["Cannot Reproduce"] = 'cancel';
$config->convert->importDeafaultValue['task']['reason']["Declined"]         = 'cancel';
$config->convert->importDeafaultValue['task']['reason']['完成']             = 'done';
$config->convert->importDeafaultValue['task']['reason']["被否决"]           = 'cancel';
$config->convert->importDeafaultValue['task']['reason']["重复提交"]         = 'cancel';
$config->convert->importDeafaultValue['task']['reason']["无法再次复现"]     = 'cancel';
$config->convert->importDeafaultValue['task']['reason']["被拒绝"]           = 'cancel';

$config->convert->importDeafaultValue['story']['reason']['Done']             = 'done';
$config->convert->importDeafaultValue['story']['reason']["Won't Do"]         = 'willnotdo';
$config->convert->importDeafaultValue['story']['reason']["Duplicate"]        = 'duplicate';
$config->convert->importDeafaultValue['story']['reason']["Cannot Reproduce"] = 'bydesign';
$config->convert->importDeafaultValue['story']['reason']["Declined"]         = 'cancel';
$config->convert->importDeafaultValue['story']['reason']['完成']             = 'done';
$config->convert->importDeafaultValue['story']['reason']["被否决"]           = 'willnotdo';
$config->convert->importDeafaultValue['story']['reason']["重复提交"]         = 'duplicate';
$config->convert->importDeafaultValue['story']['reason']["无法再次复现"]     = 'bydesign';
$config->convert->importDeafaultValue['story']['reason']["被拒绝"]           = 'cancel';

$config->convert->importDeafaultValue['feedback']['reason']['Done']             = 'commented';
$config->convert->importDeafaultValue['feedback']['reason']["Won't Do"]         = 'refuse';
$config->convert->importDeafaultValue['feedback']['reason']["Duplicate"]        = 'repeat';
$config->convert->importDeafaultValue['feedback']['reason']["Cannot Reproduce"] = 'refuse';
$config->convert->importDeafaultValue['feedback']['reason']["Declined"]         = 'refuse';
$config->convert->importDeafaultValue['feedback']['reason']['完成']             = 'commented';
$config->convert->importDeafaultValue['feedback']['reason']["被否决"]           = 'refuse';
$config->convert->importDeafaultValue['feedback']['reason']["重复提交"]         = 'repeat';
$config->convert->importDeafaultValue['feedback']['reason']["无法再次复现"]     = 'refuse';
$config->convert->importDeafaultValue['feedback']['reason']["被拒绝"]           = 'refuse';

$config->convert->importDeafaultValue['ticket']['reason'] = $config->convert->importDeafaultValue['feedback']['reason'];

$config->convert->importDeafaultValue['requirement'] = $config->convert->importDeafaultValue['story'];
$config->convert->importDeafaultValue['epic']        = $config->convert->importDeafaultValue['story'];
