<?php
if($config->db->driver == 'dm')
{
    $config->workflowfield->default->indexes = 'PRIMARY KEY (`id`)';
    $config->workflowfield->default->fields['id']           = 'mediumint(8) unsigned NOT NULL AUTO_INCREMENT';
    $config->workflowfield->default->fields['parent']       = "mediumint(8) unsigned NOT NULL DEFAULT '0'";
    $config->workflowfield->default->fields['assignedTo']   = "varchar(30) NOT NULL DEFAULT ''";
    $config->workflowfield->default->fields['status']       = "varchar(30) NOT NULL DEFAULT ''";
    $config->workflowfield->default->fields['createdBy']    = "varchar(30) NOT NULL DEFAULT ''";
    $config->workflowfield->default->fields['createdDate']  = "datetime NULL";
    $config->workflowfield->default->fields['editedBy']     = "varchar(30) NOT NULL DEFAULT ''";
    $config->workflowfield->default->fields['editedDate']   = "datetime NULL";
    $config->workflowfield->default->fields['assignedBy']   = "varchar(30) NOT NULL DEFAULT ''";
    $config->workflowfield->default->fields['assignedDate'] = "datetime NULL";
    $config->workflowfield->default->fields['mailto']       = "text NOT NULL DEFAULT ''";
    $config->workflowfield->default->fields['deleted']      = "enum('0', '1') NOT NULL DEFAULT '0'";
}

$config->workflowfield->buildin = new stdclass;
$config->workflowfield->buildin->fields['product']['id']             = array('type' => 'mediumint', 'length' => 8,  'control' => 'input',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['product']['name']           = array('type' => 'varchar',   'length' => 90, 'control' => 'input',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['product']['code']           = array('type' => 'varchar',   'length' => 45, 'control' => 'input',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['product']['line']           = array('type' => 'mediumint', 'length' => 8,  'control' => 'select',   'options' => 3,      'default' => '');
$config->workflowfield->buildin->fields['product']['type']           = array('type' => 'varchar',   'length' => 30, 'control' => 'select',   'options' => 13,     'default' => 'normal');
$config->workflowfield->buildin->fields['product']['status']         = array('type' => 'varchar',   'length' => 30, 'control' => 'select',   'options' => 14,     'default' => '', 'rules' => '1');
$config->workflowfield->buildin->fields['product']['desc']           = array('type' => 'text',      'length' => '', 'control' => 'input',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['product']['PO']             = array('type' => 'varchar',   'length' => 30, 'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['product']['QD']             = array('type' => 'varchar',   'length' => 30, 'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['product']['RD']             = array('type' => 'varchar',   'length' => 30, 'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['product']['feedback']       = array('type' => 'varchar',   'length' => 30, 'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['product']['acl']            = array('type' => 'enum',      'length' => '', 'control' => 'radio',    'options' => 15,     'default' => 'open');
$config->workflowfield->buildin->fields['product']['whitelist']      = array('type' => 'text',      'length' => '', 'control' => 'select',   'options' => 7,      'default' => '');
$config->workflowfield->buildin->fields['product']['createdBy']      = array('type' => 'varchar',   'length' => 30, 'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['product']['createdDate']    = array('type' => 'datetime',  'length' => '', 'control' => 'datetime', 'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['product']['deleted']        = array('type' => 'enum',      'length' => '', 'control' => 'radio',    'options' => $this->lang->workflowfield->default->options->deleted, 'default' => '0');

$config->workflowfield->buildin->fields['execution']['id']            = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',        'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['execution']['project']       = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',        'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['execution']['model']         = array('type' => 'char',      'length' => 30,  'control' => 'select',       'options' => 45, 'default' => '');
$config->workflowfield->buildin->fields['execution']['type']          = array('type' => 'char',      'length' => 30,  'control' => 'select',       'options' => 16, 'default' => 'sprint');
$config->workflowfield->buildin->fields['execution']['lifetime']      = array('type' => 'char',      'length' => 30,  'control' => 'select',       'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['execution']['budget']        = array('type' => 'varchar',   'length' => 30,  'control' => 'input',        'options' => '', 'default' => '0');
$config->workflowfield->buildin->fields['execution']['attribute']     = array('type' => 'varchar',   'length' => 30,  'control' => 'input',        'options' => '', 'default' => '0');
$config->workflowfield->buildin->fields['execution']['percent']       = array('type' => 'float',     'length' => '',  'control' => 'input',        'options' => '', 'default' => '0');
$config->workflowfield->buildin->fields['execution']['milestone']     = array('type' => 'enum',      'length' => '',  'control' => 'radio',        'options' => $this->lang->workflowfield->default->options->switch, 'default' => '0');
$config->workflowfield->buildin->fields['execution']['auth']          = array('type' => 'char',      'length' => 30,  'control' => 'select',       'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['execution']['parent']        = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',        'options' => '', 'default' => '0');
$config->workflowfield->buildin->fields['execution']['name']          = array('type' => 'varchar',   'length' => 90,  'control' => 'input',        'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['execution']['code']          = array('type' => 'varchar',   'length' => 45,  'control' => 'input',        'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['execution']['begin']         = array('type' => 'date',      'length' => '',  'control' => 'date',         'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['execution']['end']           = array('type' => 'date',      'length' => '',  'control' => 'date',         'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['execution']['realBegan']     = array('type' => 'date',      'length' => '',  'control' => 'date',         'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['execution']['realEnd']       = array('type' => 'date',      'length' => '',  'control' => 'date',         'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['execution']['days']          = array('type' => 'smallint',  'length' => 5,   'control' => 'integer',      'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['execution']['status']        = array('type' => 'varchar',   'length' => 10,  'control' => 'select',       'options' => 17, 'default' => '', 'rules' => '1');
$config->workflowfield->buildin->fields['execution']['pri']           = array('type' => 'enum',      'length' => '',  'control' => 'select',       'options' => '[1,2,3,4]', 'default' => '1');
$config->workflowfield->buildin->fields['execution']['desc']          = array('type' => 'text',      'length' => '',  'control' => 'richtext',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['execution']['planDuration']  = array('type' => 'int',       'length' => 11,  'control' => 'integer',      'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['execution']['realDuration']  = array('type' => 'int',       'length' => 11,  'control' => 'integer',      'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['execution']['openedBy']      = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['execution']['openedDate']    = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['execution']['lastEditedBy']  = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['execution']['lastEditedDate']= array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['execution']['closedBy']      = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['execution']['closedDate']    = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['execution']['canceledBy']    = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['execution']['canceledDate']  = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['execution']['suspendedDate'] = array('type' => 'date',      'length' => '',  'control' => 'date',         'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['execution']['PO']            = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['execution']['PM']            = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['execution']['QD']            = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['execution']['RD']            = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['execution']['acl']           = array('type' => 'char',      'length' => 30,  'control' => 'radio',        'options' => 18,     'default' => 'open');
$config->workflowfield->buildin->fields['execution']['whitelist']     = array('type' => 'text',      'length' => '',  'control' => 'multi-select', 'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['execution']['displayCards']  = array('type' => 'smallint',  'length' => 6,   'control' => 'input',        'options' => '',     'default' => '0');
$config->workflowfield->buildin->fields['execution']['fluidBoard']    = array('type' => 'enum',      'length' => '',  'control' => 'radio',        'options' => $this->lang->workflowfield->default->options->fluidBoardList,'default' => '0');
$config->workflowfield->buildin->fields['execution']['deleted']       = array('type' => 'enum',      'length' => '',  'control' => 'radio',        'options' => $this->lang->workflowfield->default->options->deleted, 'default' => '0');

$config->workflowfield->buildin->fields['program'] = $config->workflowfield->buildin->fields['execution'];
$config->workflowfield->buildin->fields['project'] = $config->workflowfield->buildin->fields['execution'];
$config->workflowfield->buildin->fields['program']['parent']['control']   = 'select';
$config->workflowfield->buildin->fields['program']['parent']['options']   = 51;
$config->workflowfield->buildin->fields['project']['parent']['control']   = 'select';
$config->workflowfield->buildin->fields['project']['parent']['options']   = 51;
$config->workflowfield->buildin->fields['execution']['parent']['control'] = 'select';
$config->workflowfield->buildin->fields['execution']['parent']['options'] = 2;
unset($config->workflowfield->buildin->fields['program']['code']);
unset($config->workflowfield->buildin->fields['program']['project']);
unset($config->workflowfield->buildin->fields['program']['model']);
unset($config->workflowfield->buildin->fields['program']['attribute']);
unset($config->workflowfield->buildin->fields['program']['percent']);
unset($config->workflowfield->buildin->fields['program']['milestone']);
unset($config->workflowfield->buildin->fields['program']['displayCards']);
unset($config->workflowfield->buildin->fields['program']['fluidBoard']);
unset($config->workflowfield->buildin->fields['project']['project']);
unset($config->workflowfield->buildin->fields['project']['attribute']);
unset($config->workflowfield->buildin->fields['project']['percent']);
unset($config->workflowfield->buildin->fields['project']['milestone']);
unset($config->workflowfield->buildin->fields['execution']['model']);
unset($config->workflowfield->buildin->fields['execution']['budget']);

$config->workflowfield->buildin->fields['productplan']['id']          = array('type' => 'mediumint', 'length' => 8,  'control' => 'input',    'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['productplan']['product']     = array('type' => 'mediumint', 'length' => 8,  'control' => 'select',   'options' => 1,  'default' => '');
$config->workflowfield->buildin->fields['productplan']['branch']      = array('type' => 'mediumint', 'length' => 8,  'control' => 'select',   'options' => 9,  'default' => '');
$config->workflowfield->buildin->fields['productplan']['parent']      = array('type' => 'mediumint', 'length' => 9,  'control' => 'select',   'options' => 12, 'default' => '0');
$config->workflowfield->buildin->fields['productplan']['title']       = array('type' => 'varchar',   'length' => 90, 'control' => 'input',    'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['productplan']['desc']        = array('type' => 'text',      'length' => '', 'control' => 'input',    'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['productplan']['begin']       = array('type' => 'date',      'length' => '', 'control' => 'date',     'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['productplan']['end']         = array('type' => 'date',      'length' => '', 'control' => 'date',     'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['productplan']['order']       = array('type' => 'text',      'length' => '', 'control' => 'input',    'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['productplan']['createdBy']   = array('type' => 'varchar',   'length' => 30, 'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['productplan']['createdDate'] = array('type' => 'datetime',  'length' => '', 'control' => 'datetime', 'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['productplan']['deleted']     = array('type' => 'enum',      'length' => '', 'control' => 'radio',    'options' => $this->lang->workflowfield->default->options->deleted, 'default' => '0');

$config->workflowfield->buildin->fields['release']['id']           = array('type' => 'mediumint', 'length' => 8,  'control' => 'input',    'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['release']['product']      = array('type' => 'mediumint', 'length' => 8,  'control' => 'select',   'options' => 1,  'default' => '0');
$config->workflowfield->buildin->fields['release']['branch']       = array('type' => 'mediumint', 'length' => 8,  'control' => 'select',   'options' => 9,  'default' => '0');
$config->workflowfield->buildin->fields['release']['build']        = array('type' => 'mediumint', 'length' => 8,  'control' => 'select',   'options' => 10, 'default' => '');
$config->workflowfield->buildin->fields['release']['name']         = array('type' => 'mediumint', 'length' => 8,  'control' => 'input',    'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['release']['marker']       = array('type' => 'enum',      'length' => '', 'control' => 'input',    'options' => '', 'default' => '0');
$config->workflowfield->buildin->fields['release']['date']         = array('type' => 'date',      'length' => '', 'control' => 'date',     'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['release']['stories']      = array('type' => 'text',      'length' => '', 'control' => 'input',    'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['release']['bugs']         = array('type' => 'text',      'length' => '', 'control' => 'input',    'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['release']['leftBugs']     = array('type' => 'text',      'length' => '', 'control' => 'input',    'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['release']['desc']         = array('type' => 'text',      'length' => '', 'control' => 'richtext', 'options' => '', 'default' => '');
$config->workflowfield->buildin->fields['release']['status']       = array('type' => 'varchar',   'length' => 20, 'control' => 'select',   'options' => 19, 'default' => 'noraml', 'rules' => '1');
$config->workflowfield->buildin->fields['release']['createdBy']    = array('type' => 'varchar',   'length' => 30, 'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['release']['createdDate']  = array('type' => 'datetime',  'length' => '', 'control' => 'datetime', 'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['release']['deleted']      = array('type' => 'enum',      'length' => '', 'control' => 'radio',    'options' => $this->lang->workflowfield->default->options->deleted, 'default' => '0');

$config->workflowfield->buildin->fields['build']['id']           = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['build']['product']      = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',   'options' => 1,      'default' => '0');
$config->workflowfield->buildin->fields['build']['branch']       = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',   'options' => 9,      'default' => '0');
$config->workflowfield->buildin->fields['build']['project']      = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',   'options' => 2,      'default' => '0');
$config->workflowfield->buildin->fields['build']['execution']    = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',   'options' => 44,     'default' => '0');
$config->workflowfield->buildin->fields['build']['name']         = array('type' => 'char',      'length' => 150, 'control' => 'input',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['build']['scmPath']      = array('type' => 'char',      'length' => 255, 'control' => 'input',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['build']['filePath']     = array('type' => 'char',      'length' => 255, 'control' => 'input',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['build']['date']         = array('type' => 'date',      'length' => '',  'control' => 'date',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['build']['stories']      = array('type' => 'text',      'length' => '',  'control' => 'input',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['build']['bugs']         = array('type' => 'text',      'length' => '',  'control' => 'input',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['build']['builder']      = array('type' => 'char',      'length' => 30,  'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['build']['desc']         = array('type' => 'text',      'length' => '',  'control' => 'richtext', 'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['build']['createdBy']    = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['build']['createdDate']  = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['build']['deleted']      = array('type' => 'enum',      'length' => '',  'control' => 'radio',    'options' => $this->lang->workflowfield->default->options->deleted, 'default' => '0');

$config->workflowfield->buildin->fields['story']['id']             = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['story']['product']        = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 1,      'default' => '0');
$config->workflowfield->buildin->fields['story']['branch']         = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 9,      'default' => '0');
$config->workflowfield->buildin->fields['story']['module']         = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 11,     'default' => '0');
$config->workflowfield->buildin->fields['story']['plan']           = array('type' => 'text',      'length' => '',  'control' => 'select',       'options' => 12,     'default' => '');
$config->workflowfield->buildin->fields['story']['source']         = array('type' => 'varchar',   'length' => 20,  'control' => 'select',       'options' => 20,     'default' => '');
$config->workflowfield->buildin->fields['story']['sourceNote']     = array('type' => 'varchar',   'length' => 255, 'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['story']['fromBug']        = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 6,      'default' => '0');
$config->workflowfield->buildin->fields['story']['feedback']       = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 73,     'default' => '0');
$config->workflowfield->buildin->fields['story']['title']          = array('type' => 'varchar',   'length' => 255, 'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['story']['keywords']       = array('type' => 'varchar',   'length' => 255, 'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['story']['type']           = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 43,     'default' => '');
$config->workflowfield->buildin->fields['story']['pri']            = array('type' => 'tinyint',   'length' => 3,   'control' => 'select',       'options' => 21,     'default' => '');
$config->workflowfield->buildin->fields['story']['estimate']       = array('type' => 'float',     'length' => '',  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['story']['status']         = array('type' => 'enum',      'length' => '',  'control' => 'select',       'options' => 22,     'default' => '', 'rules' => '1');
$config->workflowfield->buildin->fields['story']['color']          = array('type' => 'char',      'length' => 7,   'control' => 'select',       'options' => 82,     'default' => '');
$config->workflowfield->buildin->fields['story']['stage']          = array('type' => 'enum',      'length' => '',  'control' => 'select',       'options' => 23,     'default' => 'wait');
$config->workflowfield->buildin->fields['story']['stagedBy']       = array('type' => 'char',      'length' => 30,  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['story']['mailto']         = array('type' => 'text',      'length' => '',  'control' => 'multi-select', 'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['story']['openedBy']       = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['story']['openedDate']     = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['story']['assignedTo']     = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['story']['assignedDate']   = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['story']['lastEditedBy']   = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['story']['lastEditedDate'] = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['story']['reviewedBy']     = array('type' => 'varchar',   'length' => 255, 'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['story']['reviewedDate']   = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['story']['closedBy']       = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['story']['closedDate']     = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['story']['closedReason']   = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => '52',   'default' => '');
$config->workflowfield->buildin->fields['story']['toBug']          = array('type' => 'mediumint', 'length' => 9,   'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['story']['duplicateStory'] = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 4,      'default' => '0');
$config->workflowfield->buildin->fields['story']['version']        = array('type' => 'smallint',  'length' => 6,   'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['story']['deleted']        = array('type' => 'enum',      'length' => '',  'control' => 'radio',        'options' => $this->lang->workflowfield->default->options->deleted, 'default' => '0');

$config->workflowfield->buildin->fields['requirement'] = $config->workflowfield->buildin->fields['story'];
$config->workflowfield->buildin->fields['epic']        = $config->workflowfield->buildin->fields['story'];
unset($config->workflowfield->buildin->fields['requirement']['fromBug']);
unset($config->workflowfield->buildin->fields['requirement']['toBug']);
unset($config->workflowfield->buildin->fields['epic']['fromBug']);
unset($config->workflowfield->buildin->fields['epic']['toBug']);

$config->workflowfield->buildin->fields['bug']['id']              = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['project']         = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 2,      'default' => '0');
$config->workflowfield->buildin->fields['bug']['product']         = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 1,      'default' => '0');
$config->workflowfield->buildin->fields['bug']['branch']          = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 9,      'default' => '0');
$config->workflowfield->buildin->fields['bug']['module']          = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 11,     'default' => '0');
$config->workflowfield->buildin->fields['bug']['execution']       = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 44,     'default' => '0');
$config->workflowfield->buildin->fields['bug']['plan']            = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 12,     'default' => '0');
$config->workflowfield->buildin->fields['bug']['story']           = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 4,      'default' => '0');
$config->workflowfield->buildin->fields['bug']['task']            = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 5,      'default' => '0');
$config->workflowfield->buildin->fields['bug']['toTask']          = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 5,      'default' => '0');
$config->workflowfield->buildin->fields['bug']['toStory']         = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 4,      'default' => '0');
$config->workflowfield->buildin->fields['bug']['title']           = array('type' => 'varchar',   'length' => 255, 'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['keywords']        = array('type' => 'varchar',   'length' => 255, 'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['severity']        = array('type' => 'tinyint',   'length' => 4,   'control' => 'select',       'options' => 24,     'default' => '');
$config->workflowfield->buildin->fields['bug']['pri']             = array('type' => 'tinyint',   'length' => 3,   'control' => 'select',       'options' => 25,     'default' => '');
$config->workflowfield->buildin->fields['bug']['type']            = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 26,     'default' => '');
$config->workflowfield->buildin->fields['bug']['os']              = array('type' => 'varchar',   'length' => 30,  'control' => 'multi-select', 'options' => 27,     'default' => '');
$config->workflowfield->buildin->fields['bug']['browser']         = array('type' => 'varchar',   'length' => 30,  'control' => 'multi-select', 'options' => 28,     'default' => '');
$config->workflowfield->buildin->fields['bug']['hardware']        = array('type' => 'varchar',   'length' => 30,  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['found']           = array('type' => 'varchar',   'length' => 30,  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['steps']           = array('type' => 'mediumtext','length' => '',  'control' => 'richtext',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['status']          = array('type' => 'enum',      'length' => '',  'control' => 'select',       'options' => 29,     'default' => 'active', 'rules' => '1');
$config->workflowfield->buildin->fields['bug']['color']           = array('type' => 'char',      'length' => 7,   'control' => 'select',       'options' => 82,     'default' => '');
$config->workflowfield->buildin->fields['bug']['confirmed']       = array('type' => 'tinyint',   'length' => 1,   'control' => 'select',       'options' => $this->lang->workflowfield->default->options->switch, 'default' => '0');
$config->workflowfield->buildin->fields['bug']['activatedCount']  = array('type' => 'smallint',  'length' => 6,   'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['activatedDate']   = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['feedbackBy']      = array('type' => 'varchar',   'length' => 100, 'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['notifyEmail']     = array('type' => 'varchar',   'length' => 100, 'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['mailto']          = array('type' => 'text',      'length' => '',  'control' => 'multi-select', 'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['bug']['openedBy']        = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['bug']['openedDate']      = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['openedBuild']     = array('type' => 'varchar',   'length' => 255, 'control' => 'multi-select', 'options' => 10,     'default' => '');
$config->workflowfield->buildin->fields['bug']['assignedTo']      = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['bug']['assignedDate']    = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['deadline']        = array('type' => 'date',      'length' => '',  'control' => 'date',         'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['resolvedBy']      = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['bug']['resolution']      = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 40,     'default' => '');
$config->workflowfield->buildin->fields['bug']['resolvedBuild']   = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 10,     'default' => '');
$config->workflowfield->buildin->fields['bug']['resolvedDate']    = array('type' => 'datetime',  'length' => 30,  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['closedBy']        = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['bug']['closedDate']      = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['duplicateBug']    = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['linkBug']         = array('type' => 'varchar',   'length' => 255, 'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['case']            = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => '41',   'default' => '');
$config->workflowfield->buildin->fields['bug']['caseVersion']     = array('type' => 'smallint',  'length' => 6,   'control' => 'integer',      'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['result']          = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['repo']            = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['mr']              = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['entry']           = array('type' => 'text',      'length' => '',  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['lines']           = array('type' => 'varchar',   'length' => 10,  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['v1']              = array('type' => 'varchar',   'length' => 40,  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['v2']              = array('type' => 'varchar',   'length' => 40,  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['repoType']        = array('type' => 'varchar',   'length' => 30,  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['issueKey']        = array('type' => 'varchar',   'length' => 50,  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['testtask']        = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['lastEditedBy']    = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['bug']['lastEditedDate']  = array('type' => 'datetime',  'length' => 30,  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['bug']['deleted']         = array('type' => 'enum',      'length' => '',  'control' => 'radio',        'options' => $this->lang->workflowfield->default->options->deleted, 'default' => '0');

$config->workflowfield->buildin->fields['task']['id']             = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['project']        = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 2,      'default' => '0');
$config->workflowfield->buildin->fields['task']['parent']         = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 5,      'default' => '0');
$config->workflowfield->buildin->fields['task']['execution']      = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 44,     'default' => '0');
$config->workflowfield->buildin->fields['task']['module']         = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 11,     'default' => '0');
$config->workflowfield->buildin->fields['task']['story']          = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 4,      'default' => '0');
$config->workflowfield->buildin->fields['task']['fromBug']        = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 6,      'default' => '');
$config->workflowfield->buildin->fields['task']['name']           = array('type' => 'varchar',   'length' => 255, 'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['type']           = array('type' => 'varchar',   'length' => 20,  'control' => 'select',       'options' => 30,     'default' => '');
$config->workflowfield->buildin->fields['task']['pri']            = array('type' => 'tinyint',   'length' => 3,   'control' => 'select',       'options' => 31,     'default' => '');
$config->workflowfield->buildin->fields['task']['estimate']       = array('type' => 'float ',    'length' => '',  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['consumed']       = array('type' => 'float ',    'length' => '',  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['left']           = array('type' => 'float ',    'length' => '',  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['deadline']       = array('type' => 'date',      'length' => '',  'control' => 'date',         'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['status']         = array('type' => 'enum',      'length' => '',  'control' => 'select',       'options' => 32,     'default' => 'wait', 'rules' => '1');
$config->workflowfield->buildin->fields['task']['color']          = array('type' => 'char',      'length' => 7,   'control' => 'select',       'options' => 82,     'default' => '');
$config->workflowfield->buildin->fields['task']['mailto']         = array('type' => 'text',      'length' => '',  'control' => 'multi-select', 'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['task']['desc']           = array('type' => 'text',      'length' => '',  'control' => 'richtext',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['version']        = array('type' => 'smallint',  'length' => 6,   'control' => 'integer',      'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['openedBy']       = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['task']['openedDate']     = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['assignedTo']     = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['task']['assignedDate']   = array('type' => 'datetime',  'length' => 30,  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['estStarted']     = array('type' => 'date',      'length' => '',  'control' => 'date',         'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['realStarted']    = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['finishedBy']     = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['task']['finishedDate']   = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['finishedList']   = array('type' => 'text',      'length' => '',  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['canceledBy']     = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['task']['canceledDate']   = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['closedBy']       = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['task']['closedDate']     = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['planDuration']   = array('type' => 'int',       'length' => 11,  'control' => 'integer',      'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['realDuration']   = array('type' => 'int',       'length' => 11,  'control' => 'integer',      'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['closedReason']   = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 49,     'default' => '');
$config->workflowfield->buildin->fields['task']['lastEditedBy']   = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['task']['lastEditedDate'] = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['activatedDate']  = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['repo']           = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['mr']             = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['entry']          = array('type' => 'text',      'length' => '',  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['lines']          = array('type' => 'varchar',   'length' => 10,  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['task']['deleted']        = array('type' => 'enum',      'length' => '',  'control' => 'radio',        'options' => $this->lang->workflowfield->default->options->deleted, 'default' => '0');

$config->workflowfield->buildin->fields['testcase']['id']              = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testcase']['product']         = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 1,      'default' => '0');
$config->workflowfield->buildin->fields['testcase']['project']         = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 2,      'default' => '0');
$config->workflowfield->buildin->fields['testcase']['execution']       = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 44,     'default' => '0');
$config->workflowfield->buildin->fields['testcase']['branch']          = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 9,      'default' => '0');
$config->workflowfield->buildin->fields['testcase']['lib']             = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',        'options' => '',     'default' => '0');
$config->workflowfield->buildin->fields['testcase']['module']          = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 11,     'default' => '0');
$config->workflowfield->buildin->fields['testcase']['story']           = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 4,      'default' => '0');
$config->workflowfield->buildin->fields['testcase']['storyVersion']    = array('type' => 'smallint',  'length' => 6,   'control' => 'input',        'options' => '',     'default' => '1');
$config->workflowfield->buildin->fields['testcase']['title']           = array('type' => 'varchar',   'length' => 255, 'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testcase']['precondition']    = array('type' => 'text',      'length' => '',  'control' => 'textarea',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testcase']['keywords']        = array('type' => 'varchar',   'length' => 255, 'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testcase']['pri']             = array('type' => 'tinyint',   'length' => 3,   'control' => 'select',       'options' => 33,     'default' => '3');
$config->workflowfield->buildin->fields['testcase']['type']            = array('type' => 'char',      'length' => 30,  'control' => 'select',       'options' => 34,     'default' => '');
$config->workflowfield->buildin->fields['testcase']['auto']            = array('type' => 'varchar',   'length' => 10,  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testcase']['frame']           = array('type' => 'varchar',   'length' => 10,  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testcase']['stage']           = array('type' => 'varchar',   'length' => 255, 'control' => 'multi-select', 'options' => 35,     'default' => '');
$config->workflowfield->buildin->fields['testcase']['howRun']          = array('type' => 'varchar',   'length' => 30,  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testcase']['scriptedBy']      = array('type' => 'varchar',   'length' => 30,  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testcase']['scriptedDate']    = array('type' => 'date',      'length' => '',  'control' => 'date',         'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testcase']['scriptStatus']    = array('type' => 'varchar',   'length' => 30,  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testcase']['scriptLocation']  = array('type' => 'varchar',   'length' => 255, 'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testcase']['status']          = array('type' => 'char',      'length' => 30,  'control' => 'select',       'options' => 36,     'default' => '1', 'rules' => '1');
$config->workflowfield->buildin->fields['testcase']['color']           = array('type' => 'char',      'length' => 7,   'control' => 'select',       'options' => 82,     'default' => '');
$config->workflowfield->buildin->fields['testcase']['openedBy']        = array('type' => 'char',      'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['testcase']['openedDate']      = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testcase']['reviewedBy']      = array('type' => 'varchar',   'length' => 255, 'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['testcase']['reviewedDate']    = array('type' => 'datetime',  'length' => 255, 'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testcase']['lastEditedBy']    = array('type' => 'char',      'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['testcase']['lastEditedDate']  = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testcase']['version']         = array('type' => 'tinyint',   'length' => 3,   'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testcase']['linkCase']        = array('type' => 'varchar',   'length' => 255, 'control' => 'select',       'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testcase']['fromBug']         = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',       'options' => 6,      'default' => '');
$config->workflowfield->buildin->fields['testcase']['fromCaseID']      = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testcase']['fromCaseVersion'] = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testcase']['lastRunner']      = array('type' => 'varchar',   'length' => 30,  'control' => 'select',       'options' => 'user', 'default' => '0');
$config->workflowfield->buildin->fields['testcase']['lastRunDate']     = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',     'options' => '',     'default' => '0');
$config->workflowfield->buildin->fields['testcase']['lastRunResult']   = array('type' => 'char',      'length' => 30,  'control' => 'input',        'options' => '',     'default' => '0');
$config->workflowfield->buildin->fields['testcase']['deleted']         = array('type' => 'enum',      'length' => '',  'control' => 'select',       'options' => $this->lang->workflowfield->default->options->deleted, 'default' => '0');

$config->workflowfield->buildin->fields['testtask']['id']          = array('type' => 'mediumint', 'length' => 8,  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testtask']['name']        = array('type' => 'varchar',   'length' => 90, 'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testtask']['product']     = array('type' => 'mediumint', 'length' => 8,  'control' => 'select',       'options' => 1,      'default' => '');
$config->workflowfield->buildin->fields['testtask']['project']     = array('type' => 'mediumint', 'length' => 8,  'control' => 'select',       'options' => 2,      'default' => '');
$config->workflowfield->buildin->fields['testtask']['execution']   = array('type' => 'mediumint', 'length' => 8,  'control' => 'select',       'options' => 44,     'default' => '');
$config->workflowfield->buildin->fields['testtask']['build']       = array('type' => 'char',      'length' => 30, 'control' => 'select',       'options' => 10,     'default' => '');
$config->workflowfield->buildin->fields['testtask']['owner']       = array('type' => 'varchar',   'length' => 30, 'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['testtask']['pri']         = array('type' => 'tinyint',   'length' => 3,  'control' => 'select',       'options' => 37,     'default' => '');
$config->workflowfield->buildin->fields['testtask']['begin']       = array('type' => 'date',      'length' => '', 'control' => 'date',         'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testtask']['end']         = array('type' => 'date',      'length' => '', 'control' => 'date',         'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testtask']['mailto']      = array('type' => 'text',      'length' => '', 'control' => 'multi-select', 'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['testtask']['desc']        = array('type' => 'text',      'length' => '', 'control' => 'richtext',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testtask']['status']      = array('type' => 'enum',      'length' => '', 'control' => 'select',       'options' => 38,     'default' => 'wait', 'rules' => '1');
$config->workflowfield->buildin->fields['testtask']['createdBy']   = array('type' => 'varchar',   'length' => 30, 'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['testtask']['createdDate'] = array('type' => 'datetime',  'length' => '', 'control' => 'datetime',     'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testtask']['deleted']     = array('type' => 'enum',      'length' => '', 'control' => 'select',       'options' => $this->lang->workflowfield->default->options->deleted, 'default' => '0');

$config->workflowfield->buildin->fields['testsuite']['id']             = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testsuite']['product']        = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',   'options' => 1,      'default' => '');
$config->workflowfield->buildin->fields['testsuite']['name']           = array('type' => 'varchar',   'length' => 255, 'control' => 'input',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testsuite']['desc']           = array('type' => 'text',      'length' => '',  'control' => 'richtext', 'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testsuite']['type']           = array('type' => 'text',      'length' => '',  'control' => 'radio',    'options' => 50,     'default' => '');
$config->workflowfield->buildin->fields['testsuite']['addedBy']        = array('type' => 'char',      'length' => 30,  'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['testsuite']['addedDate']      = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testsuite']['lastEditedBy']   = array('type' => 'char',      'length' => 30,  'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['testsuite']['lastEditedDate'] = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['testsuite']['deleted']        = array('type' => 'enum',      'length' => '',  'control' => 'select',   'options' => $this->lang->workflowfield->default->options->deleted, 'default' => '');

$config->workflowfield->buildin->fields['caselib']['id']             = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['caselib']['product']        = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',   'options' => 1,      'default' => '');
$config->workflowfield->buildin->fields['caselib']['name']           = array('type' => 'varchar',   'length' => 255, 'control' => 'input',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['caselib']['desc']           = array('type' => 'text',      'length' => '',  'control' => 'richtext', 'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['caselib']['type']           = array('type' => 'text',      'length' => '',  'control' => 'input',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['caselib']['addedBy']        = array('type' => 'char',      'length' => 30,  'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['caselib']['addedDate']      = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['caselib']['lastEditedBy']   = array('type' => 'char',      'length' => 30,  'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['caselib']['lastEditedDate'] = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['caselib']['deleted']        = array('type' => 'enum',      'length' => '',  'control' => 'select',   'options' => $this->lang->workflowfield->default->options->deleted, 'default' => '');

$config->workflowfield->buildin->fields['feedback']['id']            = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',       'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['feedback']['product']       = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',      'options' => 1,      'default' => '');
$config->workflowfield->buildin->fields['feedback']['module']        = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',      'options' => 42,     'default' => '');
$config->workflowfield->buildin->fields['feedback']['title']         = array('type' => 'varchar',   'length' => 255, 'control' => 'input',       'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['feedback']['type']          = array('type' => 'char',      'length' => 30,  'control' => 'select',      'options' => 46,     'default' => '');
$config->workflowfield->buildin->fields['feedback']['solution']      = array('type' => 'char',      'length' => 30,  'control' => 'select',      'options' => 47,     'default' => '');
$config->workflowfield->buildin->fields['feedback']['desc']          = array('type' => 'text',      'length' => '',  'control' => 'richtext',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['feedback']['status']        = array('type' => 'varchar',   'length' => 30,  'control' => 'select',      'options' => 39,     'default' => '', 'rules' => '1');
$config->workflowfield->buildin->fields['feedback']['public']        = array('type' => 'enum',      'length' => '',  'control' => 'input',       'options' => '',     'default' => '0');
$config->workflowfield->buildin->fields['feedback']['notify']        = array('type' => 'enum',      'length' => '',  'control' => 'input',       'options' => '',     'default' => '0');
$config->workflowfield->buildin->fields['feedback']['notifyEmail']   = array('type' => 'varchar',   'length' => 100, 'control' => 'input',       'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['feedback']['source']        = array('type' => 'varchar',   'length' => 255, 'control' => 'input',       'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['feedback']['likes']         = array('type' => 'text',      'length' => '',  'control' => 'input',       'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['feedback']['result']        = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',       'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['feedback']['faq']           = array('type' => 'mediumint', 'length' => 8,   'control' => 'input',       'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['feedback']['openedBy']      = array('type' => 'char',      'length' => 30,  'control' => 'select',      'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['feedback']['openedDate']    = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['feedback']['reviewedBy']    = array('type' => 'varchar',   'length' => 255, 'control' => 'select',      'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['feedback']['reviewedDate']  = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['feedback']['processedBy']   = array('type' => 'char',      'length' => 30,  'control' => 'select',      'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['feedback']['processedDate'] = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['feedback']['closedBy']      = array('type' => 'char',      'length' => 30,  'control' => 'select',      'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['feedback']['closedDate']    = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['feedback']['closedReason']  = array('type' => 'varchar',   'length' => 30,  'control' => 'select',      'options' => 48,     'default' => '');
$config->workflowfield->buildin->fields['feedback']['editedBy']      = array('type' => 'char',      'length' => 30,  'control' => 'select',      'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['feedback']['editedDate']    = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['feedback']['assignedTo']    = array('type' => 'varchar',   'length' => 255, 'control' => 'select',      'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['feedback']['assignedDate']  = array('type' => 'datetime',  'length' => '',  'control' => 'datetime',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['feedback']['feedbackBy']    = array('type' => 'varchar',   'length' => 100, 'control' => 'select',      'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['feedback']['mailto']        = array('type' => 'text',      'length' => '',  'control' => 'multi-select','options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['feedback']['deleted']       = array('type' => 'enum',      'length' => '',  'control' => 'select',      'options' => $this->lang->workflowfield->default->options->deleted, 'default' => '0');

$config->workflowfield->buildin->fields['ticket']['id']             = array('type' => 'mediumint', 'length' => '8',   'control' => 'input',   'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['ticket']['product']        = array('type' => 'mediumint', 'length' => '8',   'control' => 'select',  'options' => 1,      'default' => '');
$config->workflowfield->buildin->fields['ticket']['module']         = array('type' => 'mediumint', 'length' => '8',   'control' => 'select',  'options' => 42,     'default' => '');
$config->workflowfield->buildin->fields['ticket']['title']          = array('type' => 'varchar',   'length' => '255', 'control' => 'input',   'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['ticket']['type']           = array('type' => 'varchar',   'length' => '30',  'control' => 'select',  'options' => 70,     'default' => '');
$config->workflowfield->buildin->fields['ticket']['desc']           = array('type' => 'text',      'length' => '',    'control' => 'input',   'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['ticket']['openedBuild']    = array('type' => 'varchar',   'length' => '255', 'control' => 'select',  'options' => 10,     'default' => '');
$config->workflowfield->buildin->fields['ticket']['feedback']       = array('type' => 'mediumint', 'length' => '8',   'control' => 'select',  'options' => 73,     'default' => '');
$config->workflowfield->buildin->fields['ticket']['assignedTo']     = array('type' => 'varchar',   'length' => '255', 'control' => 'select',  'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['ticket']['assignedDate']   = array('type' => 'datetime',  'length' => '',    'control' => 'input',   'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['ticket']['realStarted']    = array('type' => 'datetime',  'length' => '',    'control' => 'input',   'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['ticket']['startedBy']      = array('type' => 'varchar',   'length' => '255', 'control' => 'select',  'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['ticket']['startedDate']    = array('type' => 'datetime',  'length' => '',    'control' => 'input',   'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['ticket']['deadline']       = array('type' => 'datetime',  'length' => '',    'control' => 'input',   'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['ticket']['pri']            = array('type' => 'tinyint',   'length' => 3,     'control' => 'select',  'options' => 71,     'default' => '');
$config->workflowfield->buildin->fields['ticket']['estimate']       = array('type' => 'float',     'length' => '',    'control' => 'input',   'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['ticket']['left']           = array('type' => 'float',     'length' => '',    'control' => 'input',   'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['ticket']['consumed']       = array('type' => 'float',     'length' => '',    'control' => 'input',   'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['ticket']['status']         = array('type' => 'varchar',   'length' => 30,    'control' => 'select',  'options' => 72,     'default' => '');
$config->workflowfield->buildin->fields['ticket']['openedBy']       = array('type' => 'varchar',   'length' => '255', 'control' => 'select',  'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['ticket']['openedDate']     = array('type' => 'datetime',  'length' => '',    'control' => 'input',   'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['ticket']['activatedCount'] = array('type' => 'int',       'length' => 10,    'control' => 'input',   'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['ticket']['activatedBy']    = array('type' => 'varchar',   'length' => '255', 'control' => 'select',  'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['ticket']['activatedDate']  = array('type' => 'datetime',  'length' => '',    'control' => 'input',   'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['ticket']['closedBy']       = array('type' => 'varchar',   'length' => '255', 'control' => 'select',  'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['ticket']['closedDate']     = array('type' => 'datetime',  'length' => '',    'control' => 'input',   'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['ticket']['finishedBy']     = array('type' => 'varchar',   'length' => '255', 'control' => 'select',  'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['ticket']['finishedDate']   = array('type' => 'datetime',  'length' => '',    'control' => 'input',   'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['ticket']['editedBy']       = array('type' => 'varchar',   'length' => '255', 'control' => 'select',  'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['ticket']['editedDate']     = array('type' => 'datetime',  'length' => '',    'control' => 'input',   'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['ticket']['resolvedBy']     = array('type' => 'varchar',   'length' => '255', 'control' => 'select',  'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['ticket']['resolvedDate']   = array('type' => 'datetime',  'length' => '',    'control' => 'input',   'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['ticket']['deleted']        = array('type' => 'enum',      'length' => '',    'control' => 'input',   'options' => '',     'default' => '0');

$config->workflowfield->buildin->fields['demand']['id']              = array('type' => 'int',       'length' => '8',   'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['demand']['pool']            = array('type' => 'int',       'length' => '8',   'control' => 'select',       'options' => '',     'default' => '0');
$config->workflowfield->buildin->fields['demand']['module']          = array('type' => 'int',       'length' => '8',   'control' => 'select',       'options' => '',     'default' => '0');
$config->workflowfield->buildin->fields['demand']['product']         = array('type' => 'varchar',   'length' => '255', 'control' => 'multi-select', 'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['demand']['parent']          = array('type' => 'mediumint', 'length' => '8',   'control' => 'select',       'options' => '',     'default' => '0');
$config->workflowfield->buildin->fields['demand']['pri']             = array('type' => 'char',      'length' => '30',  'control' => 'select',       'options' => 74,     'default' => '');
$config->workflowfield->buildin->fields['demand']['category']        = array('type' => 'char',      'length' => '30',  'control' => 'select',       'options' => 75,     'default' => '');
$config->workflowfield->buildin->fields['demand']['source']          = array('type' => 'char',      'length' => '30',  'control' => 'select',       'options' => 76,     'default' => '');
$config->workflowfield->buildin->fields['demand']['sourceNote']      = array('type' => 'varchar',   'length' => '255', 'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['demand']['title']           = array('type' => 'varchar',   'length' => '255', 'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['demand']['feedbackedBy']    = array('type' => 'varchar',   'length' => '255', 'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['demand']['email']           = array('type' => 'varchar',   'length' => '255', 'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['demand']['assignedTo']      = array('type' => 'char',      'length' => '30',  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['demand']['assignedDate']    = array('type' => 'datetime',  'length' => '',    'control' => 'datetime',     'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['demand']['reviewedBy']      = array('type' => 'text',      'length' => '',    'control' => 'multi-select', 'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['demand']['reviewedDate']    = array('type' => 'datetime',  'length' => '',    'control' => 'datetime',     'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['demand']['status']          = array('type' => 'char',      'length' => '30',  'control' => 'select',       'options' => 77,     'default' => '');
$config->workflowfield->buildin->fields['demand']['duration']        = array('type' => 'char',      'length' => '30',  'control' => 'select',       'options' => 78,     'default' => '');
$config->workflowfield->buildin->fields['demand']['BSA']             = array('type' => 'char',      'length' => '30',  'control' => 'select',       'options' => 79,     'default' => '');
$config->workflowfield->buildin->fields['demand']['story']           = array('type' => 'mediumint', 'length' => '8',   'control' => 'select',       'options' => '',     'default' => '0');
$config->workflowfield->buildin->fields['demand']['roadmap']         = array('type' => 'mediumint', 'length' => '8',   'control' => 'select',       'options' => '',     'default' => '0');
$config->workflowfield->buildin->fields['demand']['createdBy']       = array('type' => 'char',      'length' => '30',  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['demand']['createdDate']     = array('type' => 'datetime',  'length' => '',    'control' => 'datetime',     'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['demand']['mailto']          = array('type' => 'text',      'length' => '',    'control' => 'multi-select', 'options' => 'user', 'default' => NULL);
$config->workflowfield->buildin->fields['demand']['duplicateDemand'] = array('type' => 'mediumint', 'length' => '8',   'control' => 'select',       'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['demand']['childDemands']    = array('type' => 'varchar',   'length' => '255', 'control' => 'multi-select', 'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['demand']['version']         = array('type' => 'varchar',   'length' => '255', 'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['demand']['changedBy']       = array('type' => 'char',      'length' => '30',  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['demand']['changedDate']     = array('type' => 'datetime',  'length' => '',    'control' => 'datetime',     'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['demand']['closedBy']        = array('type' => 'char',      'length' => '30',  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['demand']['closedDate']      = array('type' => 'datetime',  'length' => '',    'control' => 'datetime',     'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['demand']['closedReason']    = array('type' => 'varchar',   'length' => '30',  'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['demand']['submitedBy']      = array('type' => 'varchar',   'length' => '30',  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['demand']['lastEditedBy']    = array('type' => 'varchar',   'length' => '30',  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['demand']['lastEditedDate']  = array('type' => 'datetime',  'length' => '',    'control' => 'datetime',     'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['demand']['activatedDate']   = array('type' => 'datetime',  'length' => '',    'control' => 'datetime',     'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['demand']['distributedBy']   = array('type' => 'varchar',   'length' => '30',  'control' => 'select',       'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['demand']['distributedDate'] = array('type' => 'datetime',  'length' => '',    'control' => 'datetime',     'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['demand']['keywords']        = array('type' => 'varchar',   'length' => '255', 'control' => 'input',        'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['demand']['deleted']         = array('type' => 'enum',      'length' => '',    'control' => 'radio',        'options' => $this->lang->workflowfield->default->options->deleted, 'default' => '0');

$config->workflowfield->buildin->fields['charter']['id']                 = array('type' => 'int',        'length' => '8',   'control' => 'input',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['charter']['name']               = array('type' => 'varchar',    'length' => '255', 'control' => 'input',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['charter']['level']              = array('type' => 'int',        'length' => '8',   'control' => 'select',   'options' => '84',   'default' => '0');
$config->workflowfield->buildin->fields['charter']['category']           = array('type' => 'char',       'length' => '30',  'control' => 'select',   'options' => '85',   'default' => '');
$config->workflowfield->buildin->fields['charter']['market']             = array('type' => 'varchar',    'length' => '30',  'control' => 'select',   'options' => '86',   'default' => '');
$config->workflowfield->buildin->fields['charter']['check']              = array('type' => 'enum',       'length' => '',    'control' => 'radio',    'options' => '',     'default' => '0');
$config->workflowfield->buildin->fields['charter']['appliedBy']          = array('type' => 'char',       'length' => '30',  'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['charter']['appliedDate']        = array('type' => 'datetime',   'length' => '',    'control' => 'datetime', 'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['charter']['budget']             = array('type' => 'char',       'length' => '30',  'control' => 'input',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['charter']['budgetUnit']         = array('type' => 'char',       'length' => '30',  'control' => 'input',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['charter']['product']            = array('type' => 'text',       'length' => '',    'control' => 'input',    'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['charter']['roadmap']            = array('type' => 'text',       'length' => '',    'control' => 'input',    'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['charter']['plan']               = array('type' => 'text',       'length' => '',    'control' => 'input',    'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['charter']['spec']               = array('type' => 'mediumtext', 'length' => '',    'control' => 'richtext', 'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['charter']['status']             = array('type' => 'char',       'length' => '30',  'control' => 'select',   'options' => '87',   'default' => '');
$config->workflowfield->buildin->fields['charter']['createdBy']          = array('type' => 'char',       'length' => '30',  'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['charter']['createdDate']        = array('type' => 'datetime',   'length' => '',    'control' => 'datetime', 'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['charter']['charterFiles']       = array('type' => 'text',       'length' => '',    'control' => 'input',    'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['charter']['completionFiles']    = array('type' => 'text',       'length' => '',    'control' => 'input',    'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['charter']['canceledFiles']      = array('type' => 'text',       'length' => '',    'control' => 'input',    'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['charter']['prevCanceledStatus'] = array('type' => 'varchar',    'length' => '30',  'control' => 'input',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['charter']['closedBy']           = array('type' => 'char',       'length' => '30',  'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['charter']['closedDate']         = array('type' => 'datetime',   'length' => '',    'control' => 'datetime', 'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['charter']['closedReason']       = array('type' => 'varchar',    'length' => '255', 'control' => 'select',   'options' => '88',   'default' => '');
$config->workflowfield->buildin->fields['charter']['activatedBy']        = array('type' => 'char',       'length' => '30',  'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['charter']['activatedDate']      = array('type' => 'datetime',   'length' => '',    'control' => 'datetime', 'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['charter']['reviewedBy']         = array('type' => 'varchar',    'length' => '255', 'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->buildin->fields['charter']['reviewedResult']     = array('type' => 'char',       'length' => '30',  'control' => 'select',   'options' => '89',   'default' => '');
$config->workflowfield->buildin->fields['charter']['reviewedDate']       = array('type' => 'datetime',   'length' => '',    'control' => 'datetime', 'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['charter']['reviewStatus']       = array('type' => 'varchar',    'length' => '30',  'control' => 'select',   'options' => '90',   'default' => 'wait');
$config->workflowfield->buildin->fields['charter']['meetingDate']        = array('type' => 'date',       'length' => '',    'control' => 'date',     'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['charter']['meetingLocation']    = array('type' => 'varchar',    'length' => '255', 'control' => 'input',    'options' => '',     'default' => '');
$config->workflowfield->buildin->fields['charter']['meetingMinutes']     = array('type' => 'mediumtext', 'length' => '',    'control' => 'richtext', 'options' => '',     'default' => NULL);
$config->workflowfield->buildin->fields['charter']['deleted']            = array('type' => 'enum',       'length' => '',    'control' => 'radio',    'options' => $this->lang->workflowfield->default->options->deleted, 'default' => '0');

$config->workflowfield->upgrade = array();
$config->workflowfield->upgrade['biz7.4']['productplan']['createdBy']   = array('type' => 'varchar',   'length' => 30, 'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->upgrade['biz7.4']['productplan']['createdDate'] = array('type' => 'datetime',  'length' => '', 'control' => 'datetime', 'options' => '',     'default' => '');
$config->workflowfield->upgrade['biz7.4']['testtask']['createdBy']      = array('type' => 'varchar',   'length' => 30, 'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->upgrade['biz7.4']['testtask']['createdDate']    = array('type' => 'datetime',  'length' => '', 'control' => 'datetime', 'options' => '',     'default' => '');
$config->workflowfield->upgrade['biz7.4']['build']['createdBy']         = array('type' => 'varchar',   'length' => 30, 'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->upgrade['biz7.4']['build']['createdDate']       = array('type' => 'datetime',  'length' => '', 'control' => 'datetime', 'options' => '',     'default' => '');
$config->workflowfield->upgrade['biz7.4']['release']['createdBy']       = array('type' => 'varchar',   'length' => 30, 'control' => 'select',   'options' => 'user', 'default' => '');
$config->workflowfield->upgrade['biz7.4']['release']['createdDate']     = array('type' => 'datetime',  'length' => '', 'control' => 'datetime', 'options' => '',     'default' => '');
