$(document).ready(function() {
  checkAndUpdateSubmit();
  textareaFocusBlur();
  textareaInput();
});

// textarea 聚焦/失焦
function textareaFocusBlur() {
  $('textarea')
    .on('focus', function() {
      const name = $(this).attr('name');
      $(`#${name}-preview`).addClass('focus');
    })
    .on('blur', function() {
      const name = $(this).attr('name');
      $(`#${name}-preview`).removeClass('focus');
    });
}

// textarea 输入
function textareaInput() {
  $('textarea').on('input', function() {
    const name = $(this).attr('name');
    $(`#${name}-preview`).html($(this).val());

    checkAndUpdateSubmit();
  });
}

// 检查内容，更新提交按钮状态
function checkAndUpdateSubmit() {
  const purpose = $('textarea[name="purpose"]').val();

  if (purpose.length > 0) {
    $('#submit').prop('disabled', false);
  } else {
    $('#submit').prop('disabled', true);
  }
}
