<?php
namespace zin;

include './promptnav.html.php';

/* 构建输入框 */
function buildInputs($lang, $prompt)
{
    return array(
        formGroup(
            set::label($lang->ai->prompts->purpose),
            set::width('1/1'),
            set::required(true),
            textarea(
                set::name('purpose'),
                set::value($prompt->purpose),
                set::rows(6),
                set::placeholder($lang->ai->prompts->purposeTip),
                setClass('form-control')
            )
        ),
        formGroup(
            set::label($lang->ai->prompts->elaboration),
            set::width('1/1'),
            textarea(
                set::name('elaboration'),
                set::value($prompt->elaboration),
                set::rows(6),
                set::placeholder($lang->ai->prompts->elaborationTip),
                setClass('form-control')
            )
        )
    );
}

/* 构建预览列表 */
function buildPreviewList($lang, $prompt, $dataPreview)
{
    return ul(
        setClass('preview-list'),
        li(
            h5($lang->ai->prompts->dataPreview),
            p(
                setClass('pre'),
                $dataPreview
            )
        ),
        li(
            h5($lang->ai->prompts->rolePreview),
            p(
                $prompt->role
            ),
            p(
                $prompt->characterization
            )
        ),
        li(
            h5($lang->ai->prompts->promptPreview),
            p(
                set::id('purpose-preview'),
                $prompt->purpose
            ),
            p(
                set::id('elaboration-preview'),
                $prompt->elaboration
            )
        )
    );
}

div(
    setClass('prompt-set-purpose'),
    formPanel
    (
        set::id('mainForm'),
        set::actions(
            array(
                array('text' => $lang->ai->nextStep, 'class' => 'btn primary', 'id' => 'submit', 'btnType' => 'submit', 'name' => 'jumpToNext', 'value' => '1')
            )
        ),
        div(
            setClass('panel-container'),
            div(
                setClass('form-panel'),
                div(
                    setClass('section-header'),
                    h4(setClass('text-md'), $lang->ai->prompts->purpose)
                ),
                div(
                    setClass('section-content'),
                    ...buildInputs($lang, $prompt)
                )
            ),
            div(
                setClass('preview-panel'),
                div(
                    setClass('section-header'),
                    h4(setClass('text-md'), $lang->ai->prompts->inputPreview)
                ),
                div(
                    setClass('section-content'),
                    buildPreviewList($lang, $prompt, $dataPreview)
                )
            )
        ),
    )
);
