CREATE TABLE `zt_acl` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `objectType` char(30) NOT NULL DEFAULT '',
  `objectID` mediumint NOT NULL DEFAULT '0',
  `type` char(40) NOT NULL DEFAULT 'whitelist',
  `source` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_action` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` mediumint unsigned NOT NULL DEFAULT '0',
  `product` text,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `execution` mediumint unsigned NOT NULL DEFAULT '0',
  `actor` varchar(100) NOT NULL DEFAULT '',
  `action` varchar(80) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  `comment` text,
  `files` text,
  `extra` text,
  `read` enum('0','1') NOT NULL DEFAULT '0',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `efforted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `vision_date` (`vision`,`date`),
  KEY `actor` (`actor`),
  KEY `project` (`project`),
  KEY `execution` (`execution`),
  KEY `action` (`action`),
  KEY `objectID` (`objectID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_actionproduct` (
  `action` mediumint unsigned NOT NULL,
  `product` mediumint unsigned NOT NULL,
  KEY `action_product` (`action`,`product`),
  KEY `product` (`product`)
) ENGINE=InnoDB;
CREATE TABLE `zt_actionrecent` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` mediumint unsigned NOT NULL DEFAULT '0',
  `product` text,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `execution` mediumint unsigned NOT NULL DEFAULT '0',
  `actor` varchar(100) NOT NULL DEFAULT '',
  `action` varchar(80) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  `comment` text,
  `files` text,
  `extra` text,
  `read` enum('0','1') NOT NULL DEFAULT '0',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `efforted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `vision_date` (`vision`,`date`),
  KEY `actor` (`actor`),
  KEY `project` (`project`),
  KEY `execution` (`execution`),
  KEY `action` (`action`),
  KEY `objectID` (`objectID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_activity` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `process` mediumint NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `optional` varchar(255) NOT NULL DEFAULT '',
  `tailorNorm` varchar(255) NOT NULL DEFAULT '',
  `content` mediumtext,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `order` mediumint DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_assistant` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `modelId` mediumint unsigned NOT NULL,
  `desc` text NOT NULL,
  `systemMessage` text NOT NULL,
  `greetings` text NOT NULL,
  `icon` varchar(30) NOT NULL DEFAULT 'coding-1',
  `enabled` enum('0','1') NOT NULL DEFAULT '1',
  `createdDate` datetime NOT NULL,
  `publishedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_message` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `appID` mediumint unsigned NOT NULL,
  `user` mediumint unsigned NOT NULL,
  `type` enum('req','res','ntf') NOT NULL,
  `content` text NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_miniprogram` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `category` varchar(30) NOT NULL,
  `desc` text,
  `model` mediumint unsigned DEFAULT NULL,
  `icon` varchar(30) NOT NULL DEFAULT 'writinghand-7',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `published` enum('0','1') NOT NULL DEFAULT '0',
  `publishedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `prompt` text NOT NULL,
  `builtIn` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_miniprogramfield` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `appID` mediumint unsigned NOT NULL,
  `name` varchar(30) NOT NULL,
  `type` enum('radio','checkbox','text','textarea') DEFAULT 'text',
  `placeholder` text,
  `options` text,
  `required` enum('0','1') DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_miniprogramstar` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `appID` mediumint unsigned NOT NULL,
  `userID` mediumint unsigned NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `appID` (`appID`,`userID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_model` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `vendor` varchar(20) NOT NULL,
  `credentials` text NOT NULL,
  `proxy` text,
  `name` varchar(20) DEFAULT NULL,
  `desc` text,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) DEFAULT NULL,
  `editedDate` datetime DEFAULT NULL,
  `enabled` enum('0','1') NOT NULL DEFAULT '1',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_prompt` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `desc` text,
  `model` mediumint unsigned DEFAULT NULL,
  `module` varchar(30) DEFAULT NULL,
  `source` text,
  `targetForm` varchar(30) DEFAULT NULL,
  `purpose` text,
  `elaboration` text,
  `role` text,
  `characterization` text,
  `status` enum('draft','active') NOT NULL DEFAULT 'draft',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) DEFAULT NULL,
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_promptrole` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) DEFAULT NULL,
  `desc` text,
  `model` mediumint unsigned DEFAULT NULL,
  `role` text,
  `characterization` text,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_api` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `product` varchar(255) NOT NULL DEFAULT '',
  `lib` int unsigned NOT NULL DEFAULT '0',
  `module` int unsigned NOT NULL DEFAULT '0',
  `title` varchar(100) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `protocol` varchar(10) NOT NULL DEFAULT '',
  `method` varchar(10) NOT NULL DEFAULT '',
  `requestType` varchar(100) NOT NULL DEFAULT '',
  `responseType` varchar(100) NOT NULL DEFAULT '',
  `status` varchar(20) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '0',
  `desc` mediumtext,
  `version` smallint unsigned NOT NULL DEFAULT '0',
  `params` text,
  `paramsExample` text,
  `responseExample` text,
  `response` text,
  `commonParams` text,
  `addedBy` varchar(30) NOT NULL DEFAULT '0',
  `addedDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_api_lib_release` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `lib` int unsigned NOT NULL DEFAULT '0',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(255) NOT NULL DEFAULT '',
  `snap` mediumtext,
  `addedBy` varchar(30) NOT NULL DEFAULT '0',
  `addedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_apispec` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `doc` int unsigned NOT NULL DEFAULT '0',
  `module` int unsigned NOT NULL DEFAULT '0',
  `title` varchar(100) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `protocol` varchar(10) NOT NULL DEFAULT '',
  `method` varchar(10) NOT NULL DEFAULT '',
  `requestType` varchar(100) NOT NULL DEFAULT '',
  `responseType` varchar(100) NOT NULL DEFAULT '',
  `status` varchar(20) NOT NULL DEFAULT '',
  `owner` varchar(255) NOT NULL DEFAULT '0',
  `desc` mediumtext,
  `version` smallint unsigned NOT NULL DEFAULT '0',
  `params` text,
  `paramsExample` text,
  `responseExample` text,
  `response` text,
  `addedBy` varchar(30) NOT NULL DEFAULT '0',
  `addedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_apistruct` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `lib` int unsigned NOT NULL DEFAULT '0',
  `name` varchar(30) NOT NULL DEFAULT '',
  `type` varchar(50) NOT NULL DEFAULT '',
  `desc` mediumtext,
  `version` smallint unsigned NOT NULL DEFAULT '0',
  `attribute` text,
  `addedBy` varchar(30) NOT NULL DEFAULT '0',
  `addedDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_apistruct_spec` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(50) NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `attribute` text,
  `version` smallint unsigned NOT NULL DEFAULT '0',
  `addedBy` varchar(30) NOT NULL DEFAULT '0',
  `addedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_approval` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `flow` mediumint NOT NULL DEFAULT '0',
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` mediumint NOT NULL DEFAULT '0',
  `nodes` mediumtext,
  `version` mediumint NOT NULL DEFAULT '0',
  `status` varchar(20) NOT NULL DEFAULT 'doing',
  `result` varchar(20) NOT NULL DEFAULT '',
  `extra` text,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_approvalflow` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `code` varchar(100) NOT NULL DEFAULT '',
  `desc` mediumtext,
  `version` mediumint NOT NULL DEFAULT '1',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `workflow` varchar(30) NOT NULL DEFAULT '',
  `deleted` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_approvalflowobject` (
  `id` int NOT NULL AUTO_INCREMENT,
  `root` int NOT NULL DEFAULT '0',
  `flow` int NOT NULL DEFAULT '0',
  `objectType` char(30) NOT NULL DEFAULT '',
  `objectID` mediumint NOT NULL DEFAULT '0',
  `extra` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_approvalflowspec` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `flow` mediumint NOT NULL DEFAULT '0',
  `version` mediumint NOT NULL DEFAULT '0',
  `nodes` mediumtext,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_approvalnode` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `approval` mediumint NOT NULL DEFAULT '0',
  `type` enum('review','cc') NOT NULL DEFAULT 'review',
  `title` varchar(255) NOT NULL DEFAULT '',
  `account` char(30) NOT NULL DEFAULT '',
  `node` varchar(100) NOT NULL DEFAULT '',
  `reviewType` varchar(100) NOT NULL DEFAULT 'manual',
  `agentType` varchar(100) NOT NULL DEFAULT 'pass',
  `multipleType` enum('and','or') NOT NULL DEFAULT 'and',
  `percent` smallint NOT NULL DEFAULT '0',
  `needAll` enum('0','1') NOT NULL DEFAULT '0',
  `solicit` enum('0','1') NOT NULL DEFAULT '0',
  `prev` mediumtext,
  `next` mediumtext,
  `status` varchar(20) NOT NULL DEFAULT 'wait',
  `result` varchar(10) NOT NULL DEFAULT '',
  `date` date DEFAULT NULL,
  `opinion` mediumtext,
  `extra` mediumtext,
  `revertTo` char(30) NOT NULL DEFAULT '',
  `forwardBy` char(30) NOT NULL DEFAULT '',
  `reviewedBy` char(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_reviewed_date` (`reviewedDate`)
) ENGINE=InnoDB;
CREATE TABLE `zt_approvalobject` (
  `id` int NOT NULL AUTO_INCREMENT,
  `approval` int NOT NULL DEFAULT '0',
  `objectType` char(30) NOT NULL DEFAULT '',
  `objectID` mediumint NOT NULL DEFAULT '0',
  `reviewers` text,
  `opinion` text,
  `result` varchar(10) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `appliedBy` char(30) NOT NULL DEFAULT '',
  `appliedDate` datetime DEFAULT NULL,
  `desc` text,
  `extra` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_approvalrole` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` char(30) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` text,
  `users` longtext,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_artifactrepo` (
  `id` smallint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(45) NOT NULL DEFAULT '',
  `products` varchar(255) NOT NULL DEFAULT '',
  `serverID` smallint NOT NULL DEFAULT '0',
  `repoName` varchar(45) NOT NULL DEFAULT '',
  `format` varchar(10) NOT NULL DEFAULT '',
  `type` char(7) NOT NULL DEFAULT '',
  `status` varchar(10) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_assetlib` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext,
  `order` smallint unsigned NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_attend` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `date` date DEFAULT NULL,
  `signIn` time DEFAULT NULL,
  `signOut` time DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `ip` varchar(100) NOT NULL DEFAULT '',
  `device` varchar(30) NOT NULL DEFAULT '',
  `client` varchar(20) NOT NULL DEFAULT '',
  `manualIn` time DEFAULT NULL,
  `manualOut` time DEFAULT NULL,
  `reason` varchar(30) NOT NULL DEFAULT '',
  `desc` text,
  `reviewStatus` varchar(30) DEFAULT NULL,
  `reviewedBy` char(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `attend` (`date`,`account`),
  KEY `account` (`account`),
  KEY `date` (`date`),
  KEY `status` (`status`),
  KEY `reason` (`reason`),
  KEY `reviewStatus` (`reviewStatus`),
  KEY `reviewedBy` (`reviewedBy`)
) ENGINE=InnoDB;
CREATE TABLE `zt_attendstat` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `month` char(10) NOT NULL DEFAULT '',
  `normal` decimal(12,2) NOT NULL DEFAULT '0.00',
  `late` decimal(12,2) NOT NULL DEFAULT '0.00',
  `early` decimal(12,2) NOT NULL DEFAULT '0.00',
  `absent` decimal(12,2) NOT NULL DEFAULT '0.00',
  `trip` decimal(12,2) NOT NULL DEFAULT '0.00',
  `egress` decimal(12,2) NOT NULL DEFAULT '0.00',
  `lieu` decimal(12,2) NOT NULL DEFAULT '0.00',
  `paidLeave` decimal(12,2) NOT NULL DEFAULT '0.00',
  `unpaidLeave` decimal(12,2) NOT NULL DEFAULT '0.00',
  `timeOvertime` decimal(12,2) NOT NULL DEFAULT '0.00',
  `restOvertime` decimal(12,2) NOT NULL DEFAULT '0.00',
  `holidayOvertime` decimal(12,2) NOT NULL DEFAULT '0.00',
  `deserve` decimal(12,2) NOT NULL DEFAULT '0.00',
  `actual` decimal(12,2) NOT NULL DEFAULT '0.00',
  `status` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `attend` (`month`,`account`),
  KEY `account` (`account`),
  KEY `month` (`month`),
  KEY `status` (`status`)
) ENGINE=InnoDB;
CREATE TABLE `zt_auditcl` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `model` char(30) NOT NULL DEFAULT 'waterfall',
  `practiceArea` char(30) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `objectType` char(30) NOT NULL DEFAULT '',
  `objectID` int NOT NULL DEFAULT '0',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_auditplan` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `dateType` char(30) NOT NULL DEFAULT '',
  `config` text,
  `objectID` mediumint NOT NULL DEFAULT '0',
  `objectType` char(30) NOT NULL DEFAULT '',
  `process` mediumint NOT NULL DEFAULT '0',
  `processType` char(30) NOT NULL DEFAULT '',
  `checkDate` date DEFAULT NULL,
  `checkedBy` varchar(30) NOT NULL DEFAULT '',
  `realCheckDate` date DEFAULT NULL,
  `result` char(30) NOT NULL DEFAULT '',
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `execution` mediumint unsigned NOT NULL DEFAULT '0',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `checkBy` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_auditresult` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `auditplan` mediumint NOT NULL DEFAULT '0',
  `listID` mediumint NOT NULL DEFAULT '0',
  `result` char(30) NOT NULL DEFAULT '',
  `checkedBy` varchar(30) NOT NULL DEFAULT '',
  `checkedDate` date DEFAULT NULL,
  `comment` text,
  `severity` char(30) NOT NULL DEFAULT '',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_autocache` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(30) NOT NULL DEFAULT '',
  `fields` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `cache` (`code`,`fields`)
) ENGINE=InnoDB;
CREATE TABLE `zt_automation` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `node` int unsigned NOT NULL DEFAULT '0',
  `product` int unsigned NOT NULL DEFAULT '0',
  `scriptPath` varchar(255) NOT NULL DEFAULT '',
  `shell` mediumtext,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_basicmeas` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `purpose` varchar(50) NOT NULL DEFAULT '',
  `scope` char(30) NOT NULL DEFAULT '',
  `object` char(30) NOT NULL DEFAULT '',
  `name` varchar(90) NOT NULL DEFAULT '',
  `code` char(30) NOT NULL DEFAULT '',
  `unit` varchar(100) NOT NULL DEFAULT '',
  `configure` text,
  `params` text,
  `definition` text,
  `source` varchar(255) NOT NULL DEFAULT '',
  `collectType` varchar(30) NOT NULL DEFAULT '',
  `collectConf` text,
  `execTime` varchar(30) NOT NULL DEFAULT '',
  `collectedBy` varchar(10) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `order` mediumint unsigned NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB;
CREATE TABLE `zt_block` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `dashboard` varchar(20) NOT NULL DEFAULT '',
  `module` varchar(20) NOT NULL DEFAULT '',
  `title` varchar(100) NOT NULL DEFAULT '',
  `block` varchar(30) NOT NULL DEFAULT '',
  `code` varchar(30) NOT NULL DEFAULT '',
  `width` enum('1','2','3') NOT NULL DEFAULT '1',
  `height` smallint unsigned NOT NULL DEFAULT '3',
  `left` enum('0','1','2') NOT NULL DEFAULT '0',
  `top` smallint unsigned NOT NULL DEFAULT '0',
  `params` text,
  `hidden` tinyint unsigned NOT NULL DEFAULT '0',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  KEY `account` (`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_branch` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `default` enum('0','1') NOT NULL DEFAULT '0',
  `status` enum('active','closed') NOT NULL DEFAULT 'active',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `closedDate` date DEFAULT NULL,
  `order` smallint unsigned NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`)
) ENGINE=InnoDB;
CREATE TABLE `zt_budget` (
  `id` int NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `stage` char(30) NOT NULL DEFAULT '',
  `subject` mediumint NOT NULL DEFAULT '0',
  `amount` char(30) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_bug` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `injection` varchar(30) NOT NULL DEFAULT '',
  `identify` varchar(30) NOT NULL DEFAULT '',
  `branch` mediumint unsigned NOT NULL DEFAULT '0',
  `module` mediumint unsigned NOT NULL DEFAULT '0',
  `execution` mediumint unsigned NOT NULL DEFAULT '0',
  `plan` mediumint unsigned NOT NULL DEFAULT '0',
  `story` mediumint unsigned NOT NULL DEFAULT '0',
  `storyVersion` smallint NOT NULL DEFAULT '1',
  `task` mediumint unsigned NOT NULL DEFAULT '0',
  `toTask` mediumint unsigned NOT NULL DEFAULT '0',
  `toStory` mediumint NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `severity` tinyint NOT NULL DEFAULT '0',
  `pri` tinyint unsigned NOT NULL DEFAULT '0',
  `type` varchar(30) NOT NULL DEFAULT '',
  `os` varchar(255) NOT NULL DEFAULT '',
  `browser` varchar(255) NOT NULL DEFAULT '',
  `hardware` varchar(30) NOT NULL DEFAULT '',
  `found` varchar(30) NOT NULL DEFAULT '',
  `steps` mediumtext,
  `status` enum('active','resolved','closed') NOT NULL DEFAULT 'active',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `color` char(7) NOT NULL DEFAULT '',
  `confirmed` tinyint(1) NOT NULL DEFAULT '0',
  `activatedCount` smallint NOT NULL DEFAULT '0',
  `activatedDate` datetime DEFAULT NULL,
  `feedbackBy` varchar(100) NOT NULL DEFAULT '',
  `notifyEmail` varchar(100) NOT NULL DEFAULT '',
  `mailto` text,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `openedBuild` varchar(255) NOT NULL DEFAULT '',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `resolvedBy` varchar(30) NOT NULL DEFAULT '',
  `resolution` varchar(30) NOT NULL DEFAULT '',
  `resolvedBuild` varchar(30) NOT NULL DEFAULT '',
  `resolvedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `duplicateBug` mediumint unsigned NOT NULL DEFAULT '0',
  `relatedBug` varchar(255) NOT NULL DEFAULT '',
  `case` mediumint unsigned NOT NULL DEFAULT '0',
  `caseVersion` smallint NOT NULL DEFAULT '1',
  `feedback` mediumint unsigned NOT NULL DEFAULT '0',
  `result` mediumint unsigned NOT NULL DEFAULT '0',
  `repo` mediumint unsigned NOT NULL DEFAULT '0',
  `mr` mediumint unsigned NOT NULL DEFAULT '0',
  `entry` text,
  `lines` varchar(10) NOT NULL DEFAULT '',
  `v1` varchar(255) NOT NULL DEFAULT '',
  `v2` varchar(255) NOT NULL DEFAULT '',
  `repoType` varchar(30) NOT NULL DEFAULT '',
  `issueKey` varchar(50) NOT NULL DEFAULT '',
  `testtask` mediumint unsigned NOT NULL DEFAULT '0',
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`),
  KEY `status` (`status`),
  KEY `plan` (`plan`),
  KEY `story` (`story`),
  KEY `case` (`case`),
  KEY `toStory` (`toStory`),
  KEY `result` (`result`),
  KEY `assignedTo` (`assignedTo`),
  KEY `deleted` (`deleted`),
  KEY `project` (`project`),
  KEY `product_status_deleted` (`product`,`status`,`deleted`),
  KEY `idx_repo` (`repo`),
  KEY `feedback` (`feedback`)
) ENGINE=InnoDB;
CREATE TABLE `zt_build` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `branch` varchar(255) NOT NULL DEFAULT '0',
  `execution` mediumint unsigned NOT NULL DEFAULT '0',
  `builds` varchar(255) NOT NULL DEFAULT '',
  `name` char(150) NOT NULL DEFAULT '',
  `system` mediumint unsigned NOT NULL DEFAULT '0',
  `scmPath` char(255) NOT NULL DEFAULT '',
  `filePath` char(255) NOT NULL DEFAULT '',
  `date` date DEFAULT NULL,
  `stories` text,
  `bugs` text,
  `artifactRepoID` mediumint unsigned NOT NULL DEFAULT '0',
  `builder` char(30) NOT NULL DEFAULT '',
  `desc` mediumtext,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`),
  KEY `idx_system` (`system`)
) ENGINE=InnoDB;
CREATE TABLE `zt_burn` (
  `execution` mediumint unsigned NOT NULL DEFAULT '0',
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `task` mediumint unsigned NOT NULL DEFAULT '0',
  `date` date NOT NULL,
  `estimate` float NOT NULL DEFAULT '0',
  `left` float NOT NULL DEFAULT '0',
  `consumed` float NOT NULL DEFAULT '0',
  `storyPoint` float NOT NULL DEFAULT '0',
  UNIQUE KEY `execution_task` (`execution`,`date`,`task`)
) ENGINE=InnoDB;
CREATE TABLE `zt_case` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `execution` mediumint unsigned NOT NULL DEFAULT '0',
  `branch` mediumint unsigned NOT NULL DEFAULT '0',
  `lib` mediumint unsigned NOT NULL DEFAULT '0',
  `module` mediumint unsigned NOT NULL DEFAULT '0',
  `path` mediumint unsigned NOT NULL DEFAULT '0',
  `story` mediumint unsigned NOT NULL DEFAULT '0',
  `storyVersion` smallint NOT NULL DEFAULT '1',
  `title` varchar(255) NOT NULL DEFAULT '',
  `precondition` text,
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `pri` tinyint unsigned NOT NULL DEFAULT '3',
  `type` char(30) NOT NULL DEFAULT '1',
  `auto` varchar(10) NOT NULL DEFAULT 'no',
  `frame` varchar(10) NOT NULL DEFAULT '',
  `stage` varchar(255) NOT NULL DEFAULT '',
  `howRun` varchar(30) NOT NULL DEFAULT '',
  `script` longtext,
  `scriptedBy` varchar(30) NOT NULL DEFAULT '',
  `scriptedDate` date DEFAULT NULL,
  `scriptStatus` varchar(30) NOT NULL DEFAULT '',
  `scriptLocation` varchar(255) NOT NULL DEFAULT '',
  `status` char(30) NOT NULL DEFAULT '1',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `color` char(7) NOT NULL DEFAULT '',
  `frequency` enum('1','2','3') NOT NULL DEFAULT '1',
  `order` mediumint unsigned NOT NULL DEFAULT '0',
  `openedBy` char(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `reviewedBy` varchar(255) NOT NULL DEFAULT '',
  `reviewedDate` date DEFAULT NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `version` tinyint unsigned NOT NULL DEFAULT '0',
  `linkCase` varchar(255) NOT NULL DEFAULT '',
  `fromBug` mediumint unsigned NOT NULL DEFAULT '0',
  `fromCaseID` mediumint unsigned NOT NULL DEFAULT '0',
  `fromCaseVersion` mediumint unsigned NOT NULL DEFAULT '1',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `lastRunner` varchar(30) NOT NULL DEFAULT '',
  `lastRunDate` datetime DEFAULT NULL,
  `lastRunResult` char(30) NOT NULL DEFAULT '',
  `scene` int NOT NULL DEFAULT '0',
  `sort` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `story` (`story`),
  KEY `fromBug` (`fromBug`),
  KEY `module` (`module`),
  KEY `scene` (`scene`)
) ENGINE=InnoDB;
CREATE TABLE `zt_casespec` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `case` mediumint NOT NULL DEFAULT '0',
  `version` smallint NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `precondition` text,
  `files` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `case` (`case`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_casestep` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `parent` mediumint unsigned NOT NULL DEFAULT '0',
  `case` mediumint unsigned NOT NULL DEFAULT '0',
  `version` smallint unsigned NOT NULL DEFAULT '0',
  `type` varchar(10) NOT NULL DEFAULT 'step',
  `desc` text,
  `expect` text,
  PRIMARY KEY (`id`),
  KEY `case` (`case`),
  KEY `version` (`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_cfd` (
  `id` int NOT NULL AUTO_INCREMENT,
  `execution` int NOT NULL DEFAULT '0',
  `type` char(30) NOT NULL DEFAULT '',
  `name` char(30) NOT NULL DEFAULT '',
  `count` smallint NOT NULL DEFAULT '0',
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `execution_type_name_date` (`execution`,`type`,`name`,`date`)
) ENGINE=InnoDB;
CREATE TABLE `zt_chart` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `code` varchar(255) NOT NULL DEFAULT '',
  `driver` enum('mysql','duckdb') NOT NULL DEFAULT 'mysql',
  `mode` enum('text','builder') NOT NULL DEFAULT 'builder',
  `dimension` mediumint unsigned NOT NULL DEFAULT '0',
  `type` varchar(30) NOT NULL DEFAULT '',
  `group` varchar(255) NOT NULL DEFAULT '',
  `dataset` varchar(30) NOT NULL DEFAULT '0',
  `desc` text,
  `acl` enum('open','private') NOT NULL DEFAULT 'open',
  `whitelist` text,
  `settings` mediumtext,
  `filters` mediumtext,
  `step` tinyint unsigned NOT NULL DEFAULT '0',
  `fields` mediumtext,
  `langs` text,
  `sql` mediumtext,
  `version` varchar(10) NOT NULL DEFAULT '1',
  `stage` enum('draft','published') NOT NULL DEFAULT 'draft',
  `builtin` tinyint unsigned NOT NULL DEFAULT '0',
  `objects` mediumtext,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_charter` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `level` varchar(255) NOT NULL DEFAULT '',
  `category` char(30) NOT NULL DEFAULT '',
  `market` varchar(30) NOT NULL DEFAULT '',
  `check` enum('0','1') NOT NULL DEFAULT '0',
  `appliedBy` char(30) NOT NULL DEFAULT '',
  `appliedDate` datetime DEFAULT NULL,
  `appliedReviewer` text,
  `budget` char(30) NOT NULL DEFAULT '',
  `budgetUnit` char(30) NOT NULL DEFAULT '',
  `product` text,
  `roadmap` text,
  `plan` text,
  `type` varchar(30) NOT NULL DEFAULT 'roadmap',
  `filesConfig` text,
  `spec` mediumtext,
  `status` char(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `charterFiles` text,
  `completionFiles` text,
  `canceledFiles` text,
  `prevCanceledStatus` varchar(30) NOT NULL DEFAULT '',
  `closedBy` char(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `closedReason` varchar(255) NOT NULL DEFAULT '',
  `activatedBy` char(30) NOT NULL DEFAULT '',
  `activatedDate` datetime DEFAULT NULL,
  `activatedReviewer` text,
  `reviewedBy` varchar(255) NOT NULL DEFAULT '',
  `reviewedResult` char(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  `reviewStatus` varchar(30) NOT NULL DEFAULT 'wait',
  `completedBy` varchar(30) NOT NULL DEFAULT '',
  `completedDate` datetime DEFAULT NULL,
  `completedReviewer` text,
  `canceledBy` varchar(30) NOT NULL DEFAULT '',
  `canceledDate` datetime DEFAULT NULL,
  `canceledReviewer` text,
  `meetingDate` date DEFAULT NULL,
  `meetingLocation` varchar(255) NOT NULL DEFAULT '',
  `meetingMinutes` mediumtext,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_charterproduct` (
  `charter` mediumint unsigned NOT NULL DEFAULT '0',
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `branch` mediumint unsigned NOT NULL DEFAULT '0',
  `plan` varchar(255) NOT NULL DEFAULT '',
  `roadmap` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `charter_product` (`charter`,`product`,`branch`)
) ENGINE=InnoDB;
CREATE TABLE `zt_cmcl` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `type` char(30) NOT NULL DEFAULT '',
  `projectType` varchar(255) NOT NULL DEFAULT '',
  `title` int NOT NULL DEFAULT '0',
  `contents` text,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `order` int NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_company` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` char(120) DEFAULT NULL,
  `phone` char(20) DEFAULT NULL,
  `fax` char(20) DEFAULT NULL,
  `address` char(120) DEFAULT NULL,
  `zipcode` char(10) DEFAULT NULL,
  `website` char(120) DEFAULT NULL,
  `backyard` char(120) DEFAULT NULL,
  `guest` enum('1','0') NOT NULL DEFAULT '0',
  `admins` char(255) DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_compile` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `job` mediumint unsigned NOT NULL DEFAULT '0',
  `queue` mediumint NOT NULL DEFAULT '0',
  `status` varchar(100) NOT NULL DEFAULT '',
  `branch` varchar(255) NOT NULL DEFAULT '',
  `logs` longtext,
  `atTime` varchar(10) NOT NULL DEFAULT '',
  `testtask` mediumint unsigned NOT NULL DEFAULT '0',
  `tag` varchar(255) NOT NULL DEFAULT '',
  `times` tinyint unsigned NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `updateDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_created_status` (`createdDate`,`status`,`deleted`)
) ENGINE=InnoDB;
CREATE TABLE `zt_config` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `vision` varchar(10) NOT NULL DEFAULT '',
  `owner` char(30) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `section` char(30) NOT NULL DEFAULT '',
  `key` char(30) NOT NULL DEFAULT '',
  `value` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`vision`,`owner`,`module`,`section`,`key`),
  KEY `vision` (`vision`),
  KEY `owner` (`owner`),
  KEY `module` (`module`),
  KEY `key` (`key`)
) ENGINE=InnoDB;
CREATE TABLE `zt_cron` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `m` varchar(20) NOT NULL DEFAULT '',
  `h` varchar(20) NOT NULL DEFAULT '',
  `dom` varchar(20) NOT NULL DEFAULT '',
  `mon` varchar(20) NOT NULL DEFAULT '',
  `dow` varchar(20) NOT NULL DEFAULT '',
  `command` text,
  `remark` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT '',
  `buildin` tinyint(1) NOT NULL DEFAULT '0',
  `status` varchar(20) NOT NULL DEFAULT '',
  `lastTime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lastTime` (`lastTime`)
) ENGINE=InnoDB;
CREATE TABLE `zt_dashboard` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `dimension` int NOT NULL DEFAULT '0',
  `module` mediumint NOT NULL DEFAULT '0',
  `desc` mediumtext,
  `layout` mediumtext,
  `filters` mediumtext,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_dataset` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(155) NOT NULL DEFAULT '',
  `sql` text,
  `fields` mediumtext,
  `objects` mediumtext,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_dataview` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `group` mediumint unsigned NOT NULL DEFAULT '0',
  `name` varchar(155) NOT NULL DEFAULT '',
  `code` varchar(50) NOT NULL DEFAULT '',
  `mode` varchar(50) NOT NULL DEFAULT 'builder',
  `driver` enum('mysql','duckdb') NOT NULL DEFAULT 'mysql',
  `view` varchar(57) NOT NULL DEFAULT '',
  `sql` text,
  `fields` text,
  `langs` text,
  `objects` text,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_deliverable` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `module` varchar(30) DEFAULT NULL,
  `method` varchar(30) DEFAULT NULL,
  `model` text,
  `type` enum('doc','file') DEFAULT 'file',
  `desc` text,
  `files` varchar(255) DEFAULT NULL,
  `createdBy` varchar(30) DEFAULT NULL,
  `createdDate` date DEFAULT NULL,
  `lastEditedBy` varchar(30) DEFAULT NULL,
  `lastEditedDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_demand` (
  `id` int NOT NULL AUTO_INCREMENT,
  `pool` int NOT NULL DEFAULT '0',
  `module` int NOT NULL DEFAULT '0',
  `product` varchar(255) NOT NULL DEFAULT '',
  `parent` mediumint NOT NULL DEFAULT '0',
  `pri` char(30) NOT NULL DEFAULT '',
  `category` char(30) NOT NULL DEFAULT '',
  `source` char(30) NOT NULL DEFAULT '',
  `sourceNote` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `feedbackedBy` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `assignedTo` char(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `reviewedBy` text,
  `reviewedDate` datetime DEFAULT NULL,
  `status` char(30) NOT NULL DEFAULT '',
  `stage` enum('wait','distributed','inroadmap','incharter','developing','delivering','delivered','closed') NOT NULL DEFAULT 'wait',
  `duration` char(30) NOT NULL DEFAULT '',
  `BSA` char(30) NOT NULL DEFAULT '',
  `story` mediumint NOT NULL DEFAULT '0',
  `roadmap` mediumint NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `mailto` text,
  `duplicateDemand` mediumint DEFAULT NULL,
  `childDemands` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(255) NOT NULL DEFAULT '',
  `parentVersion` smallint NOT NULL DEFAULT '0',
  `vision` varchar(255) NOT NULL DEFAULT 'or',
  `color` varchar(255) NOT NULL DEFAULT '',
  `changedBy` char(30) NOT NULL DEFAULT '',
  `changedDate` datetime DEFAULT NULL,
  `closedBy` char(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `closedReason` varchar(30) NOT NULL DEFAULT '',
  `submitedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `activatedDate` datetime DEFAULT NULL,
  `distributedBy` varchar(30) NOT NULL DEFAULT '',
  `distributedDate` datetime DEFAULT NULL,
  `feedback` mediumint NOT NULL DEFAULT '0',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_demandpool` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext,
  `status` char(30) NOT NULL DEFAULT '',
  `products` varchar(255) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `owner` text,
  `reviewer` text,
  `acl` char(30) DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_demandreview` (
  `demand` mediumint NOT NULL DEFAULT '0',
  `version` smallint NOT NULL DEFAULT '0',
  `reviewer` varchar(30) NOT NULL DEFAULT '',
  `result` varchar(30) NOT NULL DEFAULT '',
  `reviewDate` datetime DEFAULT NULL,
  UNIQUE KEY `demand` (`demand`,`version`,`reviewer`)
) ENGINE=InnoDB;
CREATE TABLE `zt_demandspec` (
  `demand` mediumint NOT NULL DEFAULT '0',
  `version` smallint NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `spec` mediumtext,
  `verify` mediumtext,
  `files` text,
  UNIQUE KEY `demand` (`demand`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_deploy` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `begin` datetime DEFAULT NULL,
  `end` datetime DEFAULT NULL,
  `estimate` datetime DEFAULT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `host` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext,
  `status` varchar(20) NOT NULL DEFAULT '',
  `owner` char(30) NOT NULL DEFAULT '',
  `members` text,
  `notify` text,
  `cases` text,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `result` varchar(20) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_deployproduct` (
  `deploy` mediumint unsigned NOT NULL DEFAULT '0',
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `release` mediumint unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `deploy_product_release` (`deploy`,`product`,`release`)
) ENGINE=InnoDB;
CREATE TABLE `zt_deploystep` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `deploy` mediumint unsigned NOT NULL DEFAULT '0',
  `parent` mediumint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `stage` varchar(30) NOT NULL DEFAULT '',
  `content` text,
  `status` varchar(30) NOT NULL DEFAULT '',
  `assignedTo` char(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `finishedBy` char(30) NOT NULL DEFAULT '',
  `finishedDate` datetime DEFAULT NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_dept` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` char(60) NOT NULL DEFAULT '',
  `parent` mediumint unsigned NOT NULL DEFAULT '0',
  `path` char(255) NOT NULL DEFAULT '',
  `grade` tinyint unsigned NOT NULL DEFAULT '0',
  `order` smallint unsigned NOT NULL DEFAULT '0',
  `position` char(30) NOT NULL DEFAULT '',
  `function` char(255) NOT NULL DEFAULT '',
  `manager` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `path` (`path`)
) ENGINE=InnoDB;
CREATE TABLE `zt_design` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` varchar(255) NOT NULL DEFAULT '',
  `product` varchar(255) NOT NULL DEFAULT '',
  `commit` text,
  `commitedBy` varchar(30) NOT NULL DEFAULT '',
  `execution` mediumint unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `story` char(30) NOT NULL DEFAULT '',
  `storyVersion` smallint unsigned NOT NULL DEFAULT '1',
  `docs` text,
  `docVersions` text,
  `desc` mediumtext,
  `version` smallint NOT NULL DEFAULT '0',
  `type` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_designspec` (
  `design` mediumint NOT NULL DEFAULT '0',
  `version` smallint NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext,
  `files` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `design` (`design`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_dimension` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL DEFAULT '',
  `code` varchar(45) NOT NULL DEFAULT '',
  `desc` text,
  `acl` enum('open','private') NOT NULL DEFAULT 'open',
  `whitelist` text,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `code` (`code`)
) ENGINE=InnoDB;
CREATE TABLE `zt_doc` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `execution` mediumint unsigned NOT NULL DEFAULT '0',
  `lib` varchar(30) NOT NULL DEFAULT '',
  `template` varchar(30) NOT NULL DEFAULT '',
  `templateType` varchar(30) NOT NULL DEFAULT '',
  `templateDesc` text,
  `chapterType` varchar(30) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT 'normal',
  `parent` smallint unsigned NOT NULL DEFAULT '0',
  `path` char(255) NOT NULL DEFAULT '',
  `grade` tinyint unsigned NOT NULL DEFAULT '0',
  `order` smallint unsigned NOT NULL DEFAULT '0',
  `views` smallint unsigned NOT NULL DEFAULT '0',
  `assetLib` mediumint unsigned NOT NULL DEFAULT '0',
  `assetLibType` varchar(30) NOT NULL DEFAULT '',
  `from` mediumint unsigned NOT NULL DEFAULT '0',
  `fromVersion` smallint NOT NULL DEFAULT '1',
  `draft` longtext,
  `collects` smallint unsigned NOT NULL DEFAULT '0',
  `addedBy` varchar(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `approvedDate` date DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `editingDate` text,
  `editedList` text,
  `mailto` text,
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `groups` varchar(255) NOT NULL DEFAULT '',
  `users` text,
  `readGroups` varchar(255) NOT NULL DEFAULT '',
  `readUsers` text,
  `version` smallint unsigned NOT NULL DEFAULT '1',
  `builtIn` enum('0','1') NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`),
  KEY `lib` (`lib`)
) ENGINE=InnoDB;
CREATE TABLE `zt_docaction` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `doc` mediumint unsigned NOT NULL DEFAULT '0',
  `action` varchar(80) NOT NULL DEFAULT '',
  `actor` char(30) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `doc` (`doc`),
  KEY `actor` (`actor`)
) ENGINE=InnoDB;
CREATE TABLE `zt_docblock` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `doc` mediumint unsigned NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `settings` text,
  `content` mediumtext,
  `extra` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_doc` (`doc`)
) ENGINE=InnoDB;
CREATE TABLE `zt_doccontent` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `doc` mediumint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `digest` varchar(255) NOT NULL DEFAULT '',
  `content` longtext,
  `rawContent` longtext,
  `files` text,
  `type` varchar(10) NOT NULL DEFAULT '',
  `addedBy` varchar(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `version` smallint unsigned NOT NULL DEFAULT '0',
  `fromVersion` smallint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `doc_version` (`doc`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_doclib` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL DEFAULT '',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `parent` mediumint unsigned NOT NULL DEFAULT '0',
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `execution` mediumint unsigned NOT NULL DEFAULT '0',
  `name` varchar(60) NOT NULL DEFAULT '',
  `baseUrl` varchar(255) NOT NULL DEFAULT '',
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `groups` varchar(255) NOT NULL DEFAULT '',
  `users` text,
  `main` enum('0','1') NOT NULL DEFAULT '0',
  `collector` text,
  `desc` mediumtext,
  `order` mediumint unsigned NOT NULL DEFAULT '0',
  `addedBy` varchar(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `archived` enum('0','1') NOT NULL DEFAULT '0',
  `orderBy` varchar(30) NOT NULL DEFAULT 'id_asc',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`)
) ENGINE=InnoDB;
CREATE TABLE `zt_duckdbqueue` (
  `object` varchar(255) NOT NULL DEFAULT '',
  `updatedTime` datetime DEFAULT NULL,
  `syncTime` datetime DEFAULT NULL,
  UNIQUE KEY `object` (`object`)
) ENGINE=InnoDB;
CREATE TABLE `zt_durationestimation` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `stage` mediumint NOT NULL DEFAULT '0',
  `workload` varchar(255) NOT NULL DEFAULT '',
  `worktimeRate` varchar(255) NOT NULL DEFAULT '',
  `people` varchar(255) NOT NULL DEFAULT '',
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_effort` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` mediumint unsigned NOT NULL DEFAULT '0',
  `product` text,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `execution` mediumint unsigned NOT NULL DEFAULT '0',
  `account` varchar(30) NOT NULL DEFAULT '',
  `work` text,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `date` date DEFAULT NULL,
  `left` float NOT NULL DEFAULT '0',
  `consumed` float NOT NULL DEFAULT '0',
  `begin` smallint(4) unsigned zerofill NOT NULL DEFAULT '0000',
  `end` smallint(4) unsigned zerofill NOT NULL DEFAULT '0000',
  `extra` text,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `execution` (`execution`),
  KEY `objectID` (`objectID`),
  KEY `date` (`date`),
  KEY `account` (`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_entry` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `account` varchar(30) NOT NULL DEFAULT '',
  `code` varchar(20) NOT NULL DEFAULT '',
  `key` varchar(32) NOT NULL DEFAULT '',
  `freePasswd` enum('0','1') NOT NULL DEFAULT '0',
  `ip` varchar(100) NOT NULL DEFAULT '',
  `desc` mediumtext,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `calledTime` int unsigned NOT NULL DEFAULT '0',
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_expect` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `userID` mediumint NOT NULL DEFAULT '0',
  `project` mediumint NOT NULL DEFAULT '0',
  `expect` text,
  `progress` text,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_extension` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL DEFAULT '',
  `code` varchar(30) NOT NULL DEFAULT '',
  `version` varchar(50) NOT NULL DEFAULT '',
  `author` varchar(100) NOT NULL DEFAULT '',
  `desc` mediumtext,
  `license` text,
  `type` varchar(20) NOT NULL DEFAULT 'extension',
  `site` varchar(150) NOT NULL DEFAULT '',
  `zentaoCompatible` text,
  `installedTime` datetime DEFAULT NULL,
  `depends` varchar(100) NOT NULL DEFAULT '',
  `dirs` mediumtext,
  `files` mediumtext,
  `status` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `name` (`name`),
  KEY `installedTime` (`installedTime`)
) ENGINE=InnoDB;
CREATE TABLE `zt_extuser` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `account` char(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_faq` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `module` mediumint NOT NULL DEFAULT '0',
  `product` mediumint NOT NULL DEFAULT '0',
  `question` varchar(255) NOT NULL DEFAULT '',
  `answer` text,
  `addedtime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_feedback` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `module` mediumint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT '',
  `solution` char(30) NOT NULL DEFAULT '',
  `desc` text,
  `pri` tinyint unsigned NOT NULL DEFAULT '2',
  `status` varchar(30) NOT NULL DEFAULT '',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `prevStatus` varchar(30) NOT NULL DEFAULT '',
  `public` enum('0','1') NOT NULL DEFAULT '0',
  `notify` enum('0','1') NOT NULL DEFAULT '0',
  `notifyEmail` varchar(100) NOT NULL DEFAULT '',
  `source` varchar(255) NOT NULL DEFAULT '',
  `likes` text,
  `result` mediumint unsigned NOT NULL DEFAULT '0',
  `faq` mediumint unsigned NOT NULL DEFAULT '0',
  `openedBy` char(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `reviewedBy` varchar(255) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  `processedBy` char(30) NOT NULL DEFAULT '',
  `processedDate` datetime DEFAULT NULL,
  `closedBy` char(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `closedReason` varchar(30) NOT NULL DEFAULT '',
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedTo` varchar(255) NOT NULL DEFAULT '',
  `prevAssignedTo` varchar(255) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `activatedBy` varchar(30) NOT NULL DEFAULT '',
  `activatedDate` datetime DEFAULT NULL,
  `feedbackBy` varchar(100) NOT NULL DEFAULT '',
  `repeatFeedback` mediumint NOT NULL DEFAULT '0',
  `mailto` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_feedbackview` (
  `account` char(30) NOT NULL DEFAULT '',
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `account_product` (`account`,`product`)
) ENGINE=InnoDB;
CREATE TABLE `zt_file` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `pathname` char(100) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `extension` char(30) NOT NULL DEFAULT '',
  `size` int unsigned NOT NULL DEFAULT '0',
  `objectType` char(30) NOT NULL DEFAULT '',
  `objectID` mediumint NOT NULL DEFAULT '0',
  `gid` char(48) NOT NULL DEFAULT '',
  `addedBy` char(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  `downloads` mediumint unsigned NOT NULL DEFAULT '0',
  `extra` varchar(255) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `objectType` (`objectType`),
  KEY `objectID` (`objectID`),
  KEY `gid` (`gid`)
) ENGINE=InnoDB;
CREATE TABLE `zt_gapanalysis` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `account` varchar(30) NOT NULL DEFAULT '',
  `role` varchar(20) NOT NULL DEFAULT '',
  `analysis` mediumtext,
  `needTrain` enum('no','yes') NOT NULL DEFAULT 'no',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_account` (`project`,`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_group` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `name` char(30) NOT NULL DEFAULT '',
  `role` char(30) NOT NULL DEFAULT '',
  `desc` char(255) NOT NULL DEFAULT '',
  `acl` text,
  `developer` enum('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_grouppriv` (
  `group` mediumint unsigned NOT NULL DEFAULT '0',
  `module` char(30) NOT NULL DEFAULT '',
  `method` char(30) NOT NULL DEFAULT '',
  UNIQUE KEY `group` (`group`,`module`,`method`)
) ENGINE=InnoDB;
CREATE TABLE `zt_history` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `action` mediumint unsigned NOT NULL DEFAULT '0',
  `field` varchar(30) NOT NULL DEFAULT '',
  `old` longtext,
  `oldValue` text,
  `new` longtext,
  `newValue` text,
  `diff` mediumtext,
  PRIMARY KEY (`id`),
  KEY `action` (`action`)
) ENGINE=InnoDB;
CREATE TABLE `zt_holiday` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `type` enum('holiday','working') NOT NULL DEFAULT 'holiday',
  `desc` text,
  `year` char(4) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `name` (`name`)
) ENGINE=InnoDB;
CREATE TABLE `zt_host` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT 'normal',
  `hostType` varchar(30) NOT NULL DEFAULT '',
  `mac` varchar(128) NOT NULL DEFAULT '',
  `memory` varchar(30) NOT NULL DEFAULT '',
  `diskSize` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(50) NOT NULL DEFAULT '',
  `secret` varchar(50) NOT NULL DEFAULT '',
  `desc` text,
  `tokenSN` varchar(50) NOT NULL DEFAULT '',
  `tokenTime` datetime DEFAULT NULL,
  `oldTokenSN` varchar(50) NOT NULL DEFAULT '',
  `vsoft` varchar(30) NOT NULL DEFAULT '',
  `heartbeat` datetime DEFAULT NULL,
  `zap` varchar(10) NOT NULL DEFAULT '',
  `vnc` int NOT NULL DEFAULT '0',
  `ztf` int NOT NULL DEFAULT '0',
  `zd` int NOT NULL DEFAULT '0',
  `ssh` int NOT NULL DEFAULT '0',
  `parent` int unsigned NOT NULL DEFAULT '0',
  `image` int unsigned NOT NULL DEFAULT '0',
  `admin` smallint unsigned NOT NULL DEFAULT '0',
  `serverRoom` mediumint unsigned NOT NULL DEFAULT '0',
  `cpuNumber` varchar(16) NOT NULL DEFAULT '',
  `cpuCores` varchar(30) NOT NULL DEFAULT '',
  `intranet` varchar(128) NOT NULL DEFAULT '',
  `extranet` varchar(128) NOT NULL DEFAULT '',
  `osName` varchar(64) NOT NULL DEFAULT '',
  `osVersion` varchar(64) NOT NULL DEFAULT '',
  `group` varchar(128) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_image` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `host` int unsigned NOT NULL DEFAULT '0',
  `name` varchar(64) NOT NULL DEFAULT '',
  `localName` varchar(64) NOT NULL DEFAULT '',
  `address` varchar(64) NOT NULL DEFAULT '',
  `path` varchar(64) NOT NULL DEFAULT '',
  `status` varchar(20) NOT NULL DEFAULT '',
  `osName` varchar(32) NOT NULL DEFAULT '',
  `from` varchar(10) NOT NULL DEFAULT 'zentao',
  `memory` float unsigned NOT NULL DEFAULT '0',
  `disk` float unsigned NOT NULL DEFAULT '0',
  `fileSize` float unsigned NOT NULL DEFAULT '0',
  `md5` varchar(64) NOT NULL DEFAULT '',
  `desc` text,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `restoreDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_instance` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `space` mediumint unsigned NOT NULL DEFAULT '0',
  `solution` mediumint unsigned NOT NULL DEFAULT '0',
  `name` char(50) NOT NULL DEFAULT '',
  `appID` mediumint unsigned NOT NULL DEFAULT '0',
  `appName` char(50) NOT NULL DEFAULT '',
  `appVersion` char(20) NOT NULL DEFAULT '',
  `chart` char(50) NOT NULL DEFAULT '',
  `logo` varchar(255) NOT NULL DEFAULT '',
  `version` char(50) NOT NULL DEFAULT '',
  `desc` text,
  `introduction` text,
  `source` char(20) NOT NULL DEFAULT '',
  `channel` char(20) NOT NULL DEFAULT '',
  `k8name` char(64) NOT NULL DEFAULT '',
  `status` char(20) NOT NULL DEFAULT '',
  `pinned` enum('0','1') NOT NULL DEFAULT '0',
  `domain` char(255) NOT NULL DEFAULT '',
  `smtpSnippetName` char(30) NOT NULL DEFAULT '',
  `ldapSnippetName` char(30) NOT NULL DEFAULT '',
  `ldapSettings` text,
  `dbSettings` text,
  `autoBackup` tinyint(1) NOT NULL DEFAULT '0',
  `backupKeepDays` int unsigned NOT NULL DEFAULT '1',
  `autoRestore` tinyint(1) NOT NULL DEFAULT '0',
  `env` text,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdAt` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `space` (`space`),
  KEY `k8name` (`k8name`)
) ENGINE=InnoDB;
CREATE TABLE `zt_intervention` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `activity` mediumint NOT NULL DEFAULT '0',
  `status` char(30) NOT NULL DEFAULT '',
  `partake` text,
  `begin` date DEFAULT NULL,
  `realBegin` date DEFAULT NULL,
  `situation` varchar(255) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `project` (`project`,`activity`)
) ENGINE=InnoDB;
CREATE TABLE `zt_issue` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `resolvedBy` varchar(30) NOT NULL DEFAULT '',
  `project` varchar(255) NOT NULL DEFAULT '',
  `execution` mediumint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext,
  `pri` char(30) NOT NULL DEFAULT '',
  `severity` char(30) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT '',
  `activity` varchar(255) NOT NULL DEFAULT '',
  `deadline` date DEFAULT NULL,
  `resolution` char(30) NOT NULL DEFAULT '',
  `resolutionComment` text,
  `objectID` varchar(255) NOT NULL DEFAULT '',
  `resolvedDate` date DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `owner` varchar(255) NOT NULL DEFAULT '',
  `lib` mediumint unsigned NOT NULL DEFAULT '0',
  `from` mediumint unsigned NOT NULL DEFAULT '0',
  `version` smallint NOT NULL DEFAULT '1',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `activateBy` varchar(30) NOT NULL DEFAULT '',
  `activateDate` date DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` date DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `approvedDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_job` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `repo` mediumint unsigned NOT NULL DEFAULT '0',
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `frame` varchar(20) NOT NULL DEFAULT '',
  `engine` varchar(20) NOT NULL DEFAULT '',
  `autoRun` enum('0','1') NOT NULL DEFAULT '1',
  `server` mediumint unsigned NOT NULL DEFAULT '0',
  `pipeline` varchar(500) NOT NULL DEFAULT '',
  `triggerType` varchar(255) NOT NULL DEFAULT '',
  `sonarqubeServer` mediumint unsigned NOT NULL DEFAULT '0',
  `projectKey` varchar(255) NOT NULL DEFAULT '',
  `svnDir` varchar(255) NOT NULL DEFAULT '',
  `atDay` varchar(255) NOT NULL DEFAULT '',
  `atTime` varchar(10) NOT NULL DEFAULT '',
  `customParam` text,
  `comment` varchar(255) NOT NULL DEFAULT '',
  `triggerActions` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `lastExec` datetime DEFAULT NULL,
  `lastStatus` varchar(255) NOT NULL DEFAULT '',
  `lastTag` varchar(255) NOT NULL DEFAULT '',
  `lastSyncDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_repo_deleted` (`repo`,`deleted`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanban` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `space` mediumint unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `team` text,
  `desc` mediumtext,
  `acl` char(30) NOT NULL DEFAULT 'open',
  `whitelist` text,
  `archived` enum('0','1') NOT NULL DEFAULT '1',
  `performable` enum('0','1') NOT NULL DEFAULT '0',
  `status` enum('active','closed') NOT NULL DEFAULT 'active',
  `order` mediumint NOT NULL DEFAULT '0',
  `displayCards` smallint NOT NULL DEFAULT '0',
  `showWIP` enum('0','1') NOT NULL DEFAULT '1',
  `fluidBoard` enum('0','1') NOT NULL DEFAULT '0',
  `colWidth` smallint NOT NULL DEFAULT '264',
  `minColWidth` smallint NOT NULL DEFAULT '200',
  `maxColWidth` smallint NOT NULL DEFAULT '384',
  `object` varchar(255) NOT NULL DEFAULT '',
  `alignment` varchar(10) NOT NULL DEFAULT 'center',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `closedBy` char(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `activatedBy` char(30) NOT NULL DEFAULT '',
  `activatedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanbancard` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `kanban` mediumint unsigned NOT NULL DEFAULT '0',
  `region` mediumint unsigned NOT NULL DEFAULT '0',
  `group` mediumint unsigned NOT NULL DEFAULT '0',
  `fromID` mediumint unsigned NOT NULL DEFAULT '0',
  `fromType` varchar(30) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT 'doing',
  `pri` mediumint unsigned NOT NULL DEFAULT '0',
  `assignedTo` text,
  `desc` mediumtext,
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `estimate` float unsigned NOT NULL DEFAULT '0',
  `progress` float unsigned NOT NULL DEFAULT '0',
  `color` char(7) NOT NULL DEFAULT '',
  `acl` char(30) NOT NULL DEFAULT 'open',
  `whitelist` text,
  `order` mediumint NOT NULL DEFAULT '0',
  `archived` enum('0','1') NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `archivedBy` char(30) NOT NULL DEFAULT '',
  `archivedDate` datetime DEFAULT NULL,
  `assignedBy` char(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanbancell` (
  `id` int NOT NULL AUTO_INCREMENT,
  `kanban` mediumint NOT NULL DEFAULT '0',
  `lane` mediumint NOT NULL DEFAULT '0',
  `column` mediumint NOT NULL DEFAULT '0',
  `type` char(30) NOT NULL DEFAULT '',
  `cards` mediumtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `card_group` (`kanban`,`type`,`lane`,`column`),
  KEY `lane` (`lane`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanbancolumn` (
  `id` int NOT NULL AUTO_INCREMENT,
  `parent` mediumint NOT NULL DEFAULT '0',
  `type` char(30) NOT NULL DEFAULT '',
  `region` mediumint unsigned NOT NULL DEFAULT '0',
  `group` mediumint NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `color` char(30) NOT NULL DEFAULT '',
  `limit` smallint NOT NULL DEFAULT '-1',
  `order` mediumint NOT NULL DEFAULT '0',
  `archived` enum('0','1') NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `group` (`group`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanbangroup` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `kanban` mediumint unsigned NOT NULL DEFAULT '0',
  `region` mediumint unsigned NOT NULL DEFAULT '0',
  `order` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanbanlane` (
  `id` int NOT NULL AUTO_INCREMENT,
  `execution` mediumint NOT NULL DEFAULT '0',
  `type` char(30) NOT NULL DEFAULT '',
  `region` mediumint unsigned NOT NULL DEFAULT '0',
  `group` mediumint unsigned NOT NULL DEFAULT '0',
  `groupby` char(30) NOT NULL DEFAULT '',
  `extra` char(30) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `color` char(30) NOT NULL DEFAULT '',
  `order` smallint NOT NULL DEFAULT '0',
  `lastEditedTime` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `execution` (`execution`),
  KEY `group` (`group`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanbanregion` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `space` mediumint unsigned NOT NULL DEFAULT '0',
  `kanban` mediumint unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `order` mediumint NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanbanspace` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(50) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `team` text,
  `desc` mediumtext,
  `acl` char(30) NOT NULL DEFAULT 'open',
  `whitelist` text,
  `status` enum('active','closed') NOT NULL DEFAULT 'active',
  `order` mediumint NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `closedBy` char(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `activatedBy` char(30) NOT NULL DEFAULT '',
  `activatedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_lang` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `lang` varchar(30) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `section` varchar(50) NOT NULL DEFAULT '',
  `key` varchar(60) NOT NULL DEFAULT '',
  `value` text,
  `system` enum('0','1') NOT NULL DEFAULT '1',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  UNIQUE KEY `lang` (`lang`,`module`,`section`,`key`,`vision`)
) ENGINE=InnoDB;
CREATE TABLE `zt_leave` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `start` time DEFAULT NULL,
  `finish` time DEFAULT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT '0.0',
  `backDate` datetime DEFAULT NULL,
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text,
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `reviewedBy` char(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  `level` tinyint NOT NULL DEFAULT '0',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `reviewers` text,
  `backReviewers` text,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `type` (`type`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=InnoDB;
CREATE TABLE `zt_lieu` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `start` time DEFAULT NULL,
  `finish` time DEFAULT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT '0.0',
  `overtime` char(255) NOT NULL DEFAULT '',
  `trip` char(255) NOT NULL DEFAULT '',
  `desc` text,
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `reviewedBy` char(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  `level` tinyint NOT NULL DEFAULT '0',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `reviewers` text,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=InnoDB;
CREATE TABLE `zt_log` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` mediumint unsigned NOT NULL DEFAULT '0',
  `action` mediumint unsigned NOT NULL DEFAULT '0',
  `date` datetime DEFAULT NULL,
  `url` varchar(255) NOT NULL DEFAULT '',
  `contentType` varchar(30) NOT NULL DEFAULT '',
  `data` text,
  `result` text,
  PRIMARY KEY (`id`),
  KEY `objectType` (`objectType`),
  KEY `obejctID` (`objectID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_mark` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(50) NOT NULL DEFAULT '',
  `objectID` mediumint unsigned NOT NULL DEFAULT '0',
  `version` varchar(50) NOT NULL DEFAULT '',
  `account` char(30) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  `mark` varchar(50) NOT NULL DEFAULT '',
  `extra` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_object` (`objectType`,`objectID`),
  KEY `idx_account` (`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_market` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `industry` char(255) NOT NULL DEFAULT '',
  `scale` decimal(10,2) NOT NULL DEFAULT '0.00',
  `maturity` char(255) NOT NULL DEFAULT '',
  `speed` varchar(255) NOT NULL DEFAULT '',
  `competition` char(255) NOT NULL DEFAULT '',
  `strategy` varchar(255) NOT NULL DEFAULT '',
  `ppm` varchar(20) NOT NULL DEFAULT '',
  `desc` mediumtext,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_marketreport` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `market` mediumint NOT NULL DEFAULT '0',
  `research` mediumint NOT NULL DEFAULT '0',
  `maturity` varchar(30) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `participants` char(255) NOT NULL DEFAULT '',
  `source` varchar(30) NOT NULL DEFAULT '',
  `desc` mediumtext,
  `status` varchar(20) NOT NULL DEFAULT '',
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `publishedBy` varchar(30) NOT NULL DEFAULT '',
  `publishedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_measqueue` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL DEFAULT '',
  `mid` mediumint unsigned NOT NULL DEFAULT '0',
  `status` varchar(100) NOT NULL DEFAULT '',
  `logs` text,
  `execTime` varchar(10) NOT NULL DEFAULT '',
  `params` text,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `updateDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status_deleted` (`status`,`deleted`)
) ENGINE=InnoDB;
CREATE TABLE `zt_measrecords` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL DEFAULT '',
  `mid` mediumint NOT NULL DEFAULT '0',
  `measCode` char(50) NOT NULL DEFAULT '',
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `execution` mediumint unsigned NOT NULL DEFAULT '0',
  `params` text,
  `year` char(4) NOT NULL DEFAULT '',
  `month` char(6) NOT NULL DEFAULT '',
  `week` char(8) NOT NULL DEFAULT '',
  `day` char(8) NOT NULL DEFAULT '',
  `value` varchar(255) NOT NULL DEFAULT '',
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `time` (`year`,`month`,`day`,`week`),
  KEY `product` (`product`),
  KEY `project` (`project`)
) ENGINE=InnoDB;
CREATE TABLE `zt_meastemplate` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `model` char(30) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `content` mediumtext,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_meeting` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint NOT NULL DEFAULT '0',
  `execution` mediumint NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `begin` time DEFAULT NULL,
  `end` time DEFAULT NULL,
  `dept` mediumint NOT NULL DEFAULT '0',
  `mode` varchar(255) NOT NULL DEFAULT '',
  `host` varchar(30) NOT NULL DEFAULT '',
  `participant` text,
  `date` date DEFAULT NULL,
  `room` int NOT NULL DEFAULT '0',
  `minutes` text,
  `minutedBy` varchar(30) NOT NULL DEFAULT '',
  `minutedDate` datetime DEFAULT NULL,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` mediumint NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_meetingroom` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `position` varchar(30) NOT NULL DEFAULT '',
  `seats` int NOT NULL DEFAULT '0',
  `equipment` varchar(255) NOT NULL DEFAULT '',
  `openTime` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_metric` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `purpose` varchar(50) NOT NULL DEFAULT '',
  `scope` char(30) NOT NULL DEFAULT '',
  `object` char(30) NOT NULL DEFAULT '',
  `stage` enum('wait','released') DEFAULT 'wait',
  `type` enum('php','sql') DEFAULT 'php',
  `name` varchar(90) NOT NULL DEFAULT '',
  `alias` varchar(90) NOT NULL DEFAULT '',
  `code` varchar(90) NOT NULL DEFAULT '',
  `unit` varchar(10) NOT NULL DEFAULT '',
  `dateType` varchar(50) NOT NULL DEFAULT '',
  `collector` text,
  `desc` text,
  `definition` text,
  `when` varchar(30) NOT NULL DEFAULT '',
  `event` varchar(30) NOT NULL DEFAULT '',
  `cronCFG` varchar(30) NOT NULL DEFAULT '',
  `time` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `implementedBy` varchar(30) NOT NULL DEFAULT '',
  `implementedDate` datetime DEFAULT NULL,
  `delistedBy` varchar(30) NOT NULL DEFAULT '',
  `delistedDate` datetime DEFAULT NULL,
  `builtin` enum('0','1') NOT NULL DEFAULT '0',
  `fromID` mediumint unsigned NOT NULL DEFAULT '0',
  `order` mediumint unsigned NOT NULL DEFAULT '0',
  `lastCalcRows` int NOT NULL DEFAULT '0',
  `lastCalcTime` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_metriclib` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `metricID` int unsigned NOT NULL DEFAULT '0',
  `metricCode` varchar(100) NOT NULL DEFAULT '',
  `system` tinyint unsigned NOT NULL DEFAULT '0',
  `program` int unsigned NOT NULL DEFAULT '0',
  `project` int unsigned NOT NULL DEFAULT '0',
  `product` int unsigned NOT NULL DEFAULT '0',
  `execution` int unsigned NOT NULL DEFAULT '0',
  `code` char(30) NOT NULL DEFAULT '',
  `pipeline` char(30) NOT NULL DEFAULT '',
  `repo` char(30) NOT NULL DEFAULT '',
  `user` varchar(30) NOT NULL DEFAULT '',
  `dept` char(30) NOT NULL DEFAULT '',
  `year` char(4) NOT NULL DEFAULT '0',
  `month` char(2) NOT NULL DEFAULT '0',
  `week` char(2) NOT NULL DEFAULT '0',
  `day` char(2) NOT NULL DEFAULT '0',
  `value` varchar(100) NOT NULL DEFAULT '0',
  `calcType` enum('cron','inference') NOT NULL DEFAULT 'cron',
  `calculatedBy` varchar(30) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `metricCode_system_date` (`metricCode`,`system`,`date`),
  KEY `metricCode_program_date` (`metricCode`,`program`,`date`),
  KEY `metricCode_project_date` (`metricCode`,`project`,`date`),
  KEY `metricCode_product_date` (`metricCode`,`product`,`date`),
  KEY `metricCode_execution_date` (`metricCode`,`execution`,`date`),
  KEY `metricCode_user_date` (`metricCode`,`user`,`date`)
) ENGINE=InnoDB;
CREATE TABLE `zt_module` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `root` mediumint unsigned NOT NULL DEFAULT '0',
  `branch` mediumint unsigned NOT NULL DEFAULT '0',
  `name` char(60) NOT NULL DEFAULT '',
  `parent` mediumint unsigned NOT NULL DEFAULT '0',
  `path` char(255) NOT NULL DEFAULT '',
  `grade` tinyint unsigned NOT NULL DEFAULT '0',
  `order` smallint unsigned NOT NULL DEFAULT '0',
  `type` char(30) NOT NULL DEFAULT '',
  `from` mediumint unsigned NOT NULL DEFAULT '0',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `collector` text,
  `short` varchar(60) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `root` (`root`),
  KEY `type` (`type`),
  KEY `path` (`path`)
) ENGINE=InnoDB;
CREATE TABLE `zt_mr` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `hostID` mediumint unsigned NOT NULL DEFAULT '0',
  `sourceProject` varchar(50) NOT NULL DEFAULT '',
  `sourceBranch` varchar(100) NOT NULL DEFAULT '',
  `targetProject` varchar(50) NOT NULL DEFAULT '',
  `targetBranch` varchar(100) NOT NULL DEFAULT '',
  `mriid` int unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `assignee` varchar(255) NOT NULL DEFAULT '',
  `reviewer` varchar(255) NOT NULL DEFAULT '',
  `approver` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `status` char(30) NOT NULL DEFAULT '',
  `mergeStatus` char(30) NOT NULL DEFAULT '',
  `approvalStatus` char(30) NOT NULL DEFAULT '',
  `needApproved` enum('0','1') NOT NULL DEFAULT '0',
  `needCI` enum('0','1') NOT NULL DEFAULT '0',
  `repoID` mediumint unsigned NOT NULL DEFAULT '0',
  `jobID` mediumint unsigned NOT NULL DEFAULT '0',
  `executionID` mediumint unsigned NOT NULL DEFAULT '0',
  `compileID` mediumint unsigned NOT NULL DEFAULT '0',
  `compileStatus` char(30) NOT NULL DEFAULT '',
  `removeSourceBranch` enum('0','1') NOT NULL DEFAULT '0',
  `squash` enum('0','1') NOT NULL DEFAULT '0',
  `isFlow` enum('0','1') NOT NULL DEFAULT '0',
  `synced` enum('0','1') NOT NULL DEFAULT '1',
  `syncError` varchar(255) NOT NULL DEFAULT '',
  `hasNoConflict` enum('0','1') NOT NULL DEFAULT '0',
  `diffs` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_mrapproval` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `mrID` mediumint unsigned NOT NULL DEFAULT '0',
  `account` varchar(255) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  `action` char(30) NOT NULL DEFAULT '',
  `comment` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_nc` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `auditplan` mediumint NOT NULL DEFAULT '0',
  `listID` mediumint NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext,
  `type` char(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT 'active',
  `severity` char(30) NOT NULL DEFAULT '',
  `deadline` date DEFAULT NULL,
  `resolvedBy` varchar(30) NOT NULL DEFAULT '',
  `resolution` char(30) NOT NULL DEFAULT '',
  `resolvedDate` date DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` date DEFAULT NULL,
  `parent` mediumint unsigned NOT NULL DEFAULT '0',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` date DEFAULT NULL,
  `activateDate` date DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_notify` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(50) NOT NULL DEFAULT '',
  `objectID` mediumint unsigned NOT NULL DEFAULT '0',
  `action` mediumint NOT NULL DEFAULT '0',
  `toList` text,
  `ccList` text,
  `subject` text,
  `data` text,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `sendTime` datetime DEFAULT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `failReason` text,
  PRIMARY KEY (`id`),
  KEY `objectType` (`objectType`),
  KEY `status` (`status`)
) ENGINE=InnoDB;
CREATE TABLE `zt_oauth` (
  `account` varchar(30) NOT NULL DEFAULT '',
  `openID` varchar(100) NOT NULL DEFAULT '',
  `providerType` varchar(30) NOT NULL DEFAULT '',
  `providerID` mediumint unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `account_openID` (`account`,`openID`,`providerType`,`providerID`),
  KEY `account` (`account`),
  KEY `providerType` (`providerType`),
  KEY `providerID` (`providerID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_object` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `product` mediumint NOT NULL DEFAULT '0',
  `from` mediumint NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `category` char(30) NOT NULL DEFAULT '',
  `version` varchar(255) NOT NULL DEFAULT '',
  `type` enum('reviewed','taged') NOT NULL DEFAULT 'reviewed',
  `enabled` enum('0','1') NOT NULL DEFAULT '1',
  `range` text,
  `data` text,
  `storyEst` char(30) NOT NULL DEFAULT '',
  `taskEst` char(30) NOT NULL DEFAULT '',
  `requestEst` char(30) NOT NULL DEFAULT '',
  `testEst` char(30) NOT NULL DEFAULT '',
  `devEst` char(30) NOT NULL DEFAULT '',
  `designEst` char(30) NOT NULL DEFAULT '',
  `end` date DEFAULT NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_opportunity` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `execution` mediumint unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `source` char(30) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT '',
  `strategy` char(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT 'active',
  `impact` mediumint NOT NULL DEFAULT '0',
  `chance` mediumint NOT NULL DEFAULT '0',
  `ratio` mediumint NOT NULL DEFAULT '0',
  `pri` char(30) NOT NULL DEFAULT '',
  `identifiedDate` date DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` date DEFAULT NULL,
  `approvedDate` date DEFAULT NULL,
  `prevention` mediumtext,
  `plannedClosedDate` date DEFAULT NULL,
  `actualClosedDate` date DEFAULT NULL,
  `lib` mediumint unsigned NOT NULL DEFAULT '0',
  `from` mediumint unsigned NOT NULL DEFAULT '0',
  `desc` mediumtext,
  `version` smallint NOT NULL DEFAULT '1',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `activatedBy` varchar(30) NOT NULL DEFAULT '',
  `activatedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `canceledBy` varchar(30) NOT NULL DEFAULT '',
  `canceledDate` datetime DEFAULT NULL,
  `cancelReason` char(30) NOT NULL DEFAULT '',
  `hangupedBy` varchar(30) NOT NULL DEFAULT '',
  `hangupedDate` datetime DEFAULT NULL,
  `resolution` mediumtext,
  `resolvedBy` varchar(30) NOT NULL DEFAULT '',
  `resolvedDate` datetime DEFAULT NULL,
  `lastCheckedBy` varchar(30) NOT NULL DEFAULT '',
  `lastCheckedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_overtime` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `start` time DEFAULT NULL,
  `finish` time DEFAULT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT '0.0',
  `leave` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text,
  `status` varchar(30) NOT NULL DEFAULT '',
  `rejectReason` varchar(100) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `reviewedBy` char(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  `level` tinyint NOT NULL DEFAULT '0',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `reviewers` text,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `type` (`type`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=InnoDB;
CREATE TABLE `zt_pipeline` (
  `id` smallint unsigned NOT NULL AUTO_INCREMENT,
  `type` char(30) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `url` varchar(255) DEFAULT NULL,
  `account` varchar(30) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `token` varchar(255) DEFAULT NULL,
  `private` char(32) DEFAULT NULL,
  `instanceID` mediumint unsigned NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_pivot` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `dimension` mediumint unsigned NOT NULL DEFAULT '0',
  `group` varchar(255) NOT NULL DEFAULT '',
  `code` varchar(255) NOT NULL DEFAULT '',
  `driver` enum('mysql','duckdb') NOT NULL DEFAULT 'mysql',
  `mode` varchar(10) NOT NULL DEFAULT 'builder',
  `name` text,
  `desc` text,
  `acl` enum('open','private') NOT NULL DEFAULT 'open',
  `whitelist` text,
  `sql` text,
  `fields` text,
  `langs` text,
  `vars` text,
  `objects` text,
  `settings` text,
  `filters` text,
  `step` tinyint unsigned NOT NULL DEFAULT '0',
  `stage` enum('draft','published') NOT NULL DEFAULT 'draft',
  `builtin` enum('0','1') NOT NULL DEFAULT '0',
  `version` varchar(10) NOT NULL DEFAULT '1',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `dimension` (`dimension`),
  KEY `group` (`group`)
) ENGINE=InnoDB;
CREATE TABLE `zt_pivotdrill` (
  `pivot` mediumint NOT NULL,
  `version` varchar(10) NOT NULL DEFAULT '1',
  `field` varchar(255) NOT NULL,
  `object` varchar(40) NOT NULL,
  `whereSql` mediumtext NOT NULL,
  `condition` mediumtext NOT NULL,
  `status` enum('design','published') NOT NULL DEFAULT 'published',
  `account` varchar(30) NOT NULL DEFAULT '',
  `type` enum('auto','manual') NOT NULL DEFAULT 'manual'
) ENGINE=InnoDB;
CREATE TABLE `zt_pivotspec` (
  `pivot` mediumint NOT NULL,
  `version` varchar(10) NOT NULL,
  `driver` enum('mysql','duckdb') NOT NULL DEFAULT 'mysql',
  `mode` varchar(10) NOT NULL DEFAULT 'builder',
  `name` text,
  `desc` text,
  `sql` text,
  `fields` text,
  `langs` text,
  `vars` text,
  `objects` text,
  `settings` text,
  `filters` text,
  `createdDate` datetime DEFAULT NULL,
  UNIQUE KEY `idx_pivot_version` (`pivot`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_planstory` (
  `plan` mediumint unsigned NOT NULL DEFAULT '0',
  `story` mediumint unsigned NOT NULL DEFAULT '0',
  `order` mediumint NOT NULL DEFAULT '0',
  UNIQUE KEY `plan_story` (`plan`,`story`)
) ENGINE=InnoDB;
CREATE TABLE `zt_practice` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `module` mediumint unsigned NOT NULL DEFAULT '0',
  `code` char(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `labels` varchar(255) NOT NULL DEFAULT '',
  `summary` varchar(255) NOT NULL DEFAULT '',
  `content` text,
  `contributor` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB;
CREATE TABLE `zt_priv` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL DEFAULT '',
  `method` varchar(30) NOT NULL DEFAULT '',
  `parent` mediumint unsigned NOT NULL DEFAULT '0',
  `edition` varchar(30) NOT NULL DEFAULT ',open,biz,max,',
  `vision` varchar(30) NOT NULL DEFAULT ',rnd,',
  `system` enum('0','1') NOT NULL DEFAULT '0',
  `order` mediumint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `priv` (`module`,`method`)
) ENGINE=InnoDB;
CREATE TABLE `zt_privlang` (
  `objectID` mediumint unsigned NOT NULL DEFAULT '0',
  `objectType` enum('priv','manager') NOT NULL DEFAULT 'priv',
  `lang` varchar(30) NOT NULL DEFAULT '',
  `key` varchar(100) NOT NULL DEFAULT '',
  `value` varchar(255) NOT NULL DEFAULT '',
  `desc` text,
  UNIQUE KEY `objectlang` (`objectID`,`objectType`,`lang`)
) ENGINE=InnoDB;
CREATE TABLE `zt_privmanager` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `parent` mediumint unsigned NOT NULL DEFAULT '0',
  `code` varchar(100) NOT NULL DEFAULT '',
  `type` enum('view','module','package') NOT NULL DEFAULT 'package',
  `edition` varchar(30) NOT NULL DEFAULT ',open,biz,max,',
  `vision` varchar(30) NOT NULL DEFAULT ',rnd,',
  `order` mediumint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_privrelation` (
  `priv` varchar(100) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `relationPriv` varchar(100) NOT NULL DEFAULT '',
  UNIQUE KEY `privrelation` (`priv`,`type`,`relationPriv`)
) ENGINE=InnoDB;
CREATE TABLE `zt_process` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `model` char(30) NOT NULL DEFAULT 'waterfall',
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT '',
  `abbr` char(30) NOT NULL DEFAULT '',
  `desc` mediumtext,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `order` mediumint NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_product` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `program` mediumint unsigned NOT NULL DEFAULT '0',
  `name` varchar(110) NOT NULL DEFAULT '',
  `code` varchar(45) NOT NULL DEFAULT '',
  `shadow` tinyint unsigned NOT NULL DEFAULT '0',
  `bind` enum('0','1') NOT NULL DEFAULT '0',
  `line` mediumint NOT NULL DEFAULT '0',
  `type` varchar(30) NOT NULL DEFAULT 'normal',
  `status` varchar(30) NOT NULL DEFAULT '',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `desc` mediumtext,
  `PO` varchar(30) NOT NULL DEFAULT '',
  `QD` varchar(30) NOT NULL DEFAULT '',
  `RD` varchar(30) NOT NULL DEFAULT '',
  `feedback` varchar(30) NOT NULL DEFAULT '',
  `ticket` varchar(30) NOT NULL DEFAULT '',
  `workflowGroup` int NOT NULL DEFAULT '0',
  `acl` enum('open','private','custom') NOT NULL DEFAULT 'open',
  `groups` text,
  `whitelist` text,
  `reviewer` text,
  `PMT` text,
  `draftEpics` mediumint NOT NULL DEFAULT '0',
  `activeEpics` mediumint NOT NULL DEFAULT '0',
  `changingEpics` mediumint NOT NULL DEFAULT '0',
  `reviewingEpics` mediumint NOT NULL DEFAULT '0',
  `finishedEpics` mediumint NOT NULL DEFAULT '0',
  `closedEpics` mediumint NOT NULL DEFAULT '0',
  `totalEpics` mediumint NOT NULL DEFAULT '0',
  `draftRequirements` mediumint NOT NULL DEFAULT '0',
  `activeRequirements` mediumint NOT NULL DEFAULT '0',
  `changingRequirements` mediumint NOT NULL DEFAULT '0',
  `reviewingRequirements` mediumint NOT NULL DEFAULT '0',
  `finishedRequirements` mediumint NOT NULL DEFAULT '0',
  `closedRequirements` mediumint NOT NULL DEFAULT '0',
  `totalRequirements` mediumint NOT NULL DEFAULT '0',
  `draftStories` mediumint NOT NULL DEFAULT '0',
  `activeStories` mediumint NOT NULL DEFAULT '0',
  `changingStories` mediumint NOT NULL DEFAULT '0',
  `reviewingStories` mediumint NOT NULL DEFAULT '0',
  `finishedStories` mediumint NOT NULL DEFAULT '0',
  `closedStories` mediumint NOT NULL DEFAULT '0',
  `totalStories` mediumint NOT NULL DEFAULT '0',
  `unresolvedBugs` mediumint NOT NULL DEFAULT '0',
  `closedBugs` mediumint NOT NULL DEFAULT '0',
  `fixedBugs` mediumint NOT NULL DEFAULT '0',
  `totalBugs` mediumint NOT NULL DEFAULT '0',
  `plans` mediumint NOT NULL DEFAULT '0',
  `releases` mediumint NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `createdVersion` varchar(20) NOT NULL DEFAULT '',
  `closedDate` date DEFAULT NULL,
  `order` mediumint unsigned NOT NULL DEFAULT '0',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `acl` (`acl`),
  KEY `order` (`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_productplan` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `branch` varchar(255) NOT NULL DEFAULT '0',
  `parent` mediumint NOT NULL DEFAULT '0',
  `title` varchar(90) NOT NULL DEFAULT '',
  `status` enum('wait','doing','done','closed') NOT NULL DEFAULT 'wait',
  `desc` mediumtext,
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `finishedDate` datetime DEFAULT NULL,
  `closedDate` datetime DEFAULT NULL,
  `order` text,
  `closedReason` varchar(20) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `end` (`end`)
) ENGINE=InnoDB;
CREATE TABLE `zt_programactivity` (
  `id` int NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `execution` mediumint unsigned NOT NULL DEFAULT '0',
  `process` mediumint NOT NULL DEFAULT '0',
  `activity` mediumint NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `content` text,
  `reason` varchar(255) NOT NULL DEFAULT '',
  `result` char(30) NOT NULL DEFAULT '',
  `linkedBy` char(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_programoutput` (
  `id` int NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `execution` mediumint unsigned NOT NULL DEFAULT '0',
  `process` mediumint NOT NULL DEFAULT '0',
  `activity` mediumint NOT NULL DEFAULT '0',
  `output` mediumint NOT NULL DEFAULT '0',
  `content` text,
  `name` varchar(255) NOT NULL DEFAULT '',
  `reason` varchar(255) NOT NULL DEFAULT '',
  `result` char(30) NOT NULL DEFAULT '',
  `linkedBy` char(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_programprocess` (
  `id` int NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `process` mediumint NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT '',
  `abbr` char(30) NOT NULL DEFAULT '',
  `desc` text,
  `reason` varchar(255) NOT NULL DEFAULT '',
  `linkedBy` char(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_programreport` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `template` mediumint NOT NULL DEFAULT '0',
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `params` text,
  `content` text,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_project` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint NOT NULL DEFAULT '0',
  `isTpl` tinyint unsigned NOT NULL DEFAULT '0',
  `charter` mediumint NOT NULL DEFAULT '0',
  `model` char(30) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT 'sprint',
  `category` char(30) NOT NULL DEFAULT '',
  `lifetime` char(30) NOT NULL DEFAULT '',
  `budget` varchar(30) NOT NULL DEFAULT '0',
  `budgetUnit` char(30) NOT NULL DEFAULT 'CNY',
  `attribute` varchar(30) NOT NULL DEFAULT '',
  `percent` float unsigned NOT NULL DEFAULT '0',
  `milestone` enum('0','1') NOT NULL DEFAULT '0',
  `output` text,
  `auth` char(30) NOT NULL DEFAULT '',
  `storyType` char(30) NOT NULL DEFAULT '',
  `parent` mediumint unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `grade` tinyint unsigned NOT NULL DEFAULT '0',
  `name` varchar(90) NOT NULL DEFAULT '',
  `code` varchar(45) NOT NULL DEFAULT '',
  `hasProduct` tinyint unsigned NOT NULL DEFAULT '1',
  `workflowGroup` int NOT NULL DEFAULT '0',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `firstEnd` date DEFAULT NULL,
  `realBegan` date DEFAULT NULL,
  `realEnd` date DEFAULT NULL,
  `days` smallint unsigned NOT NULL DEFAULT '0',
  `status` varchar(10) NOT NULL DEFAULT '',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `pri` enum('1','2','3','4') NOT NULL DEFAULT '1',
  `desc` mediumtext,
  `version` smallint NOT NULL DEFAULT '0',
  `parentVersion` smallint NOT NULL DEFAULT '0',
  `planDuration` int NOT NULL DEFAULT '0',
  `realDuration` int NOT NULL DEFAULT '0',
  `progress` decimal(5,2) NOT NULL DEFAULT '0.00',
  `estimate` float NOT NULL DEFAULT '0',
  `left` float NOT NULL DEFAULT '0',
  `consumed` float NOT NULL DEFAULT '0',
  `teamCount` int NOT NULL DEFAULT '0',
  `market` mediumint NOT NULL DEFAULT '0',
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `openedVersion` varchar(20) NOT NULL DEFAULT '',
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `closedReason` varchar(20) NOT NULL DEFAULT '',
  `canceledBy` varchar(30) NOT NULL DEFAULT '',
  `canceledDate` datetime DEFAULT NULL,
  `suspendedDate` date DEFAULT NULL,
  `PO` varchar(30) NOT NULL DEFAULT '',
  `PM` varchar(30) NOT NULL DEFAULT '',
  `QD` varchar(30) NOT NULL DEFAULT '',
  `RD` varchar(30) NOT NULL DEFAULT '',
  `team` varchar(90) NOT NULL DEFAULT '',
  `acl` char(30) NOT NULL DEFAULT 'open',
  `whitelist` text,
  `tplAcl` char(30) NOT NULL DEFAULT 'open',
  `tplWhiteList` text,
  `order` mediumint unsigned NOT NULL DEFAULT '0',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `stageBy` enum('project','product') NOT NULL DEFAULT 'product',
  `displayCards` smallint NOT NULL DEFAULT '0',
  `fluidBoard` enum('0','1') NOT NULL DEFAULT '0',
  `multiple` enum('0','1') NOT NULL DEFAULT '1',
  `parallel` mediumint NOT NULL DEFAULT '0',
  `enabled` enum('on','off') NOT NULL DEFAULT 'on',
  `linkType` varchar(30) NOT NULL DEFAULT 'plan',
  `taskDateLimit` varchar(30) NOT NULL DEFAULT 'auto',
  `colWidth` smallint NOT NULL DEFAULT '264',
  `minColWidth` smallint NOT NULL DEFAULT '200',
  `maxColWidth` smallint NOT NULL DEFAULT '384',
  `deliverable` text,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `begin` (`begin`),
  KEY `end` (`end`),
  KEY `status` (`status`),
  KEY `acl` (`acl`),
  KEY `order` (`order`),
  KEY `project` (`project`),
  KEY `type_order` (`type`,`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_projectadmin` (
  `group` smallint NOT NULL DEFAULT '0',
  `account` char(30) NOT NULL DEFAULT '',
  `programs` text,
  `projects` text,
  `products` text,
  `executions` text,
  UNIQUE KEY `group_account` (`group`,`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_projectcase` (
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `case` mediumint unsigned NOT NULL DEFAULT '0',
  `count` mediumint unsigned NOT NULL DEFAULT '1',
  `version` smallint NOT NULL DEFAULT '1',
  `order` smallint unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `project` (`project`,`case`)
) ENGINE=InnoDB;
CREATE TABLE `zt_projectproduct` (
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `branch` mediumint unsigned NOT NULL DEFAULT '0',
  `plan` varchar(255) NOT NULL DEFAULT '',
  `roadmap` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `project_product` (`project`,`product`,`branch`)
) ENGINE=InnoDB;
CREATE TABLE `zt_projectspec` (
  `project` mediumint NOT NULL DEFAULT '0',
  `version` smallint NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `milestone` enum('0','1') NOT NULL DEFAULT '0',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  UNIQUE KEY `project` (`project`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_projectstory` (
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `branch` mediumint unsigned NOT NULL DEFAULT '0',
  `story` mediumint unsigned NOT NULL DEFAULT '0',
  `version` smallint NOT NULL DEFAULT '1',
  `order` smallint unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `project` (`project`,`story`),
  KEY `story` (`story`)
) ENGINE=InnoDB;
CREATE TABLE `zt_queue` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `cron` mediumint NOT NULL,
  `type` varchar(255) NOT NULL,
  `command` text NOT NULL,
  `status` enum('wait','doing','done') NOT NULL DEFAULT 'wait',
  `execId` int DEFAULT NULL,
  `createdDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status_createdDate` (`status`,`createdDate`),
  KEY `cron_createdDate` (`cron`,`createdDate`)
) ENGINE=InnoDB;
CREATE TABLE `zt_relation` (
  `id` int NOT NULL AUTO_INCREMENT,
  `project` mediumint NOT NULL DEFAULT '0',
  `product` mediumint NOT NULL DEFAULT '0',
  `execution` mediumint NOT NULL DEFAULT '0',
  `AType` char(30) NOT NULL DEFAULT '',
  `AID` mediumint NOT NULL DEFAULT '0',
  `AVersion` char(30) NOT NULL DEFAULT '',
  `relation` char(30) NOT NULL DEFAULT '',
  `BType` char(30) NOT NULL DEFAULT '',
  `BID` mediumint NOT NULL DEFAULT '0',
  `BVersion` char(30) NOT NULL DEFAULT '',
  `extra` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `relation` (`product`,`relation`,`AType`,`BType`,`AID`,`BID`),
  KEY `AID` (`AType`,`AID`),
  KEY `BID` (`BType`,`BID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_relationoftasks` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `execution` char(30) NOT NULL DEFAULT '',
  `pretask` mediumint unsigned NOT NULL,
  `condition` enum('begin','end') NOT NULL,
  `task` mediumint unsigned NOT NULL,
  `action` enum('begin','end') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `relationoftasks` (`execution`,`task`)
) ENGINE=InnoDB;
CREATE TABLE `zt_release` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` varchar(255) NOT NULL DEFAULT '0',
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `branch` varchar(255) NOT NULL DEFAULT '0',
  `shadow` mediumint unsigned NOT NULL DEFAULT '0',
  `build` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `system` mediumint unsigned NOT NULL DEFAULT '0',
  `releases` varchar(255) NOT NULL DEFAULT '',
  `marker` enum('0','1') NOT NULL DEFAULT '0',
  `date` date DEFAULT NULL,
  `releasedDate` date DEFAULT NULL,
  `stories` text,
  `bugs` text,
  `leftBugs` text,
  `desc` mediumtext,
  `mailto` text,
  `notify` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(20) NOT NULL DEFAULT 'normal',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `build` (`build`),
  KEY `idx_system` (`system`)
) ENGINE=InnoDB;
CREATE TABLE `zt_releaserelated` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `release` int unsigned NOT NULL,
  `objectID` int unsigned NOT NULL,
  `objectType` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`release`,`objectID`,`objectType`),
  KEY `objectID` (`objectID`),
  KEY `objectType` (`objectType`)
) ENGINE=InnoDB;
CREATE TABLE `zt_repo` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `product` varchar(255) NOT NULL DEFAULT '',
  `projects` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `prefix` varchar(100) NOT NULL DEFAULT '',
  `encoding` varchar(20) NOT NULL DEFAULT '',
  `SCM` varchar(10) NOT NULL DEFAULT '',
  `client` varchar(100) NOT NULL DEFAULT '',
  `serviceHost` varchar(50) NOT NULL DEFAULT '',
  `serviceProject` varchar(100) NOT NULL DEFAULT '',
  `commits` mediumint unsigned NOT NULL DEFAULT '0',
  `account` varchar(30) NOT NULL DEFAULT '',
  `password` varchar(30) NOT NULL DEFAULT '',
  `encrypt` varchar(30) NOT NULL DEFAULT 'plain',
  `acl` text,
  `synced` tinyint(1) NOT NULL DEFAULT '0',
  `lastSync` datetime DEFAULT NULL,
  `lastCommit` datetime DEFAULT NULL,
  `desc` text,
  `extra` char(30) NOT NULL DEFAULT '',
  `preMerge` enum('0','1') NOT NULL DEFAULT '0',
  `job` mediumint unsigned NOT NULL DEFAULT '0',
  `fileServerUrl` text,
  `fileServerAccount` varchar(40) NOT NULL DEFAULT '',
  `fileServerPassword` varchar(100) NOT NULL DEFAULT '',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_repobranch` (
  `repo` mediumint unsigned NOT NULL DEFAULT '0',
  `revision` mediumint unsigned NOT NULL DEFAULT '0',
  `branch` varchar(100) NOT NULL DEFAULT '',
  UNIQUE KEY `repo_revision_branch` (`repo`,`revision`,`branch`),
  KEY `branch` (`branch`),
  KEY `revision` (`revision`)
) ENGINE=InnoDB;
CREATE TABLE `zt_repofiles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `repo` mediumint unsigned NOT NULL DEFAULT '0',
  `revision` mediumint unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `oldPath` varchar(255) NOT NULL DEFAULT '',
  `parent` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT '',
  `action` char(1) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `path` (`path`),
  KEY `parent` (`parent`),
  KEY `repo` (`repo`),
  KEY `revision` (`revision`)
) ENGINE=InnoDB;
CREATE TABLE `zt_repohistory` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `repo` mediumint NOT NULL DEFAULT '0',
  `revision` varchar(40) NOT NULL DEFAULT '',
  `commit` mediumint unsigned NOT NULL DEFAULT '0',
  `comment` text,
  `committer` varchar(100) NOT NULL DEFAULT '',
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `repo` (`repo`),
  KEY `revision` (`revision`)
) ENGINE=InnoDB;
CREATE TABLE `zt_report` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `code` varchar(100) NOT NULL DEFAULT '',
  `name` text,
  `dimension` int NOT NULL DEFAULT '0',
  `module` varchar(100) NOT NULL DEFAULT '',
  `sql` text,
  `vars` text,
  `langs` text,
  `params` text,
  `step` tinyint(1) NOT NULL DEFAULT '2',
  `desc` text,
  `addedBy` char(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB;
CREATE TABLE `zt_researchplan` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `customer` varchar(255) NOT NULL DEFAULT '',
  `stakeholder` varchar(255) NOT NULL DEFAULT '',
  `objective` varchar(255) NOT NULL DEFAULT '',
  `begin` datetime DEFAULT NULL,
  `end` datetime DEFAULT NULL,
  `location` varchar(255) NOT NULL DEFAULT '',
  `team` varchar(255) NOT NULL DEFAULT '',
  `method` enum('','videoConference','interview','questionnaire','telephoneInterview') NOT NULL DEFAULT '',
  `outline` mediumtext,
  `schedule` mediumtext,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_researchreport` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `relatedPlan` mediumint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `author` varchar(30) NOT NULL DEFAULT '',
  `content` mediumtext,
  `customer` varchar(255) NOT NULL DEFAULT '',
  `researchObjects` varchar(255) NOT NULL DEFAULT '',
  `begin` datetime DEFAULT NULL,
  `end` datetime DEFAULT NULL,
  `location` varchar(255) NOT NULL DEFAULT '',
  `method` enum('','videoConference','interview','questionnaire','telephoneInterview') NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_review` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `object` mediumint NOT NULL DEFAULT '0',
  `template` mediumint NOT NULL DEFAULT '0',
  `doc` varchar(255) NOT NULL DEFAULT '',
  `docVersion` varchar(255) NOT NULL DEFAULT '',
  `status` char(30) NOT NULL DEFAULT '',
  `reviewedBy` varchar(255) NOT NULL DEFAULT '',
  `auditedBy` varchar(255) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `begin` date DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `lastReviewedBy` varchar(255) NOT NULL DEFAULT '',
  `lastReviewedDate` date DEFAULT NULL,
  `lastAuditedBy` varchar(255) NOT NULL DEFAULT '',
  `lastAuditedDate` date DEFAULT NULL,
  `toAuditBy` varchar(30) NOT NULL DEFAULT '',
  `toAuditDate` datetime DEFAULT NULL,
  `lastEditedBy` varchar(255) NOT NULL DEFAULT '',
  `lastEditedDate` date DEFAULT NULL,
  `result` char(30) NOT NULL DEFAULT '',
  `auditResult` char(30) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_reviewcl` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `object` char(30) NOT NULL DEFAULT '',
  `category` char(30) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `order` mediumint DEFAULT '0',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_reviewissue` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `review` mediumint NOT NULL DEFAULT '0',
  `approval` mediumint NOT NULL DEFAULT '0',
  `injection` mediumint NOT NULL DEFAULT '0',
  `identify` mediumint NOT NULL DEFAULT '0',
  `type` char(30) NOT NULL DEFAULT 'review',
  `listID` mediumint NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `opinion` mediumtext,
  `opinionDate` date DEFAULT NULL,
  `status` char(30) NOT NULL DEFAULT '',
  `resolution` char(30) NOT NULL DEFAULT '',
  `resolutionBy` char(30) NOT NULL DEFAULT '',
  `resolutionDate` date DEFAULT NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_reviewlist` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `object` char(30) NOT NULL DEFAULT '',
  `category` char(30) NOT NULL DEFAULT '',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_reviewresult` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `review` mediumint NOT NULL DEFAULT '0',
  `type` char(30) NOT NULL DEFAULT 'review',
  `result` char(30) NOT NULL DEFAULT '',
  `opinion` text,
  `reviewer` char(30) NOT NULL DEFAULT '',
  `remainIssue` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `consumed` float NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reviewer` (`review`,`reviewer`,`type`)
) ENGINE=InnoDB;
CREATE TABLE `zt_risk` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` varchar(255) NOT NULL DEFAULT '',
  `execution` mediumint unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `source` char(30) NOT NULL DEFAULT '',
  `category` char(30) NOT NULL DEFAULT '',
  `strategy` char(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT 'active',
  `impact` char(30) NOT NULL DEFAULT '',
  `probability` char(30) NOT NULL DEFAULT '',
  `rate` char(30) NOT NULL DEFAULT '',
  `pri` char(30) NOT NULL DEFAULT '',
  `identifiedDate` date DEFAULT NULL,
  `prevention` mediumtext,
  `remedy` mediumtext,
  `plannedClosedDate` date DEFAULT NULL,
  `actualClosedDate` date DEFAULT NULL,
  `lib` mediumint unsigned NOT NULL DEFAULT '0',
  `from` mediumint unsigned NOT NULL DEFAULT '0',
  `version` smallint NOT NULL DEFAULT '1',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `resolution` mediumtext,
  `resolvedBy` varchar(30) NOT NULL DEFAULT '',
  `activateBy` varchar(30) NOT NULL DEFAULT '',
  `activateDate` date DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` date DEFAULT NULL,
  `cancelBy` varchar(30) NOT NULL DEFAULT '',
  `cancelDate` date DEFAULT NULL,
  `cancelReason` char(30) NOT NULL DEFAULT '',
  `hangupBy` varchar(30) NOT NULL DEFAULT '',
  `hangupDate` date DEFAULT NULL,
  `trackedBy` varchar(30) NOT NULL DEFAULT '',
  `trackedDate` date DEFAULT NULL,
  `assignedDate` date DEFAULT NULL,
  `approvedDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_riskissue` (
  `risk` mediumint unsigned NOT NULL DEFAULT '0',
  `issue` mediumint unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `risk_issue` (`risk`,`issue`)
) ENGINE=InnoDB;
CREATE TABLE `zt_roadmap` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `product` mediumint NOT NULL DEFAULT '0',
  `branch` mediumint NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `status` char(30) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `desc` longtext,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `closedBy` char(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `closedReason` enum('done','canceled') DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_roadmapstory` (
  `roadmap` mediumint unsigned NOT NULL DEFAULT '0',
  `story` mediumint unsigned NOT NULL DEFAULT '0',
  `order` mediumint unsigned NOT NULL,
  UNIQUE KEY `roadmap_story` (`roadmap`,`story`)
) ENGINE=InnoDB;
CREATE TABLE `zt_scene` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `branch` mediumint unsigned NOT NULL DEFAULT '0',
  `module` mediumint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `sort` int unsigned NOT NULL DEFAULT '0',
  `openedBy` char(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `parent` int NOT NULL DEFAULT '0',
  `grade` tinyint NOT NULL DEFAULT '0',
  `path` varchar(1000) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_score` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(30) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `method` varchar(30) NOT NULL DEFAULT '',
  `desc` varchar(250) NOT NULL DEFAULT '',
  `before` int NOT NULL DEFAULT '0',
  `score` int NOT NULL DEFAULT '0',
  `after` int NOT NULL DEFAULT '0',
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `module` (`module`),
  KEY `method` (`method`)
) ENGINE=InnoDB;
CREATE TABLE `zt_screen` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `dimension` mediumint unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext,
  `acl` enum('open','private') NOT NULL DEFAULT 'open',
  `whitelist` text,
  `cover` mediumtext,
  `scheme` mediumtext,
  `status` enum('draft','published') NOT NULL DEFAULT 'draft',
  `builtin` enum('0','1') NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_searchdict` (
  `key` smallint unsigned NOT NULL DEFAULT '0',
  `value` char(3) NOT NULL DEFAULT '',
  UNIQUE KEY `key_value` (`key`,`value`)
) ENGINE=InnoDB;
CREATE TABLE `zt_searchindex` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `objectType` char(20) NOT NULL DEFAULT '',
  `objectID` mediumint NOT NULL DEFAULT '0',
  `title` text,
  `content` text,
  `addedDate` datetime DEFAULT NULL,
  `editedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`objectType`,`objectID`),
  KEY `addedDate` (`addedDate`),
  FULLTEXT KEY `title_content` (`title`,`content`)
) ENGINE=InnoDB;
CREATE TABLE `zt_serverroom` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL DEFAULT '',
  `city` varchar(128) NOT NULL DEFAULT '',
  `line` varchar(20) NOT NULL DEFAULT '',
  `bandwidth` varchar(128) NOT NULL DEFAULT '',
  `provider` varchar(128) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_session` (
  `id` varchar(32) NOT NULL,
  `data` mediumtext,
  `timestamp` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB;
CREATE TABLE `zt_solutions` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `execution` mediumint unsigned NOT NULL DEFAULT '0',
  `contents` text NOT NULL,
  `support` text NOT NULL,
  `measures` text NOT NULL,
  `type` char(30) NOT NULL DEFAULT '',
  `addedBy` varchar(30) NOT NULL DEFAULT '',
  `addedDate` date DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_space` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `k8space` char(64) NOT NULL,
  `owner` char(30) NOT NULL,
  `default` tinyint(1) NOT NULL DEFAULT '0',
  `createdAt` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=InnoDB;
CREATE TABLE `zt_sqlbuilder` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `objectID` mediumint NOT NULL,
  `objectType` varchar(50) NOT NULL,
  `sql` text,
  `setting` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_sqlview` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL DEFAULT '',
  `code` varchar(45) NOT NULL DEFAULT '',
  `sql` text,
  `desc` text,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_stage` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `percent` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `projectType` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_stakeholder` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `objectID` mediumint NOT NULL DEFAULT '0',
  `objectType` char(30) NOT NULL DEFAULT '',
  `user` char(30) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT '',
  `key` enum('0','1') NOT NULL DEFAULT '0',
  `from` char(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `objectID` (`objectID`),
  KEY `objectType` (`objectType`)
) ENGINE=InnoDB;
CREATE TABLE `zt_story` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `parent` mediumint NOT NULL DEFAULT '0',
  `isParent` enum('0','1') NOT NULL DEFAULT '0',
  `root` mediumint NOT NULL DEFAULT '0',
  `path` text,
  `grade` smallint NOT NULL DEFAULT '0',
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `branch` mediumint unsigned NOT NULL DEFAULT '0',
  `module` mediumint unsigned NOT NULL DEFAULT '0',
  `plan` text,
  `source` varchar(20) NOT NULL DEFAULT '',
  `sourceNote` varchar(255) NOT NULL DEFAULT '',
  `fromBug` mediumint unsigned NOT NULL DEFAULT '0',
  `feedback` mediumint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT 'story',
  `category` varchar(30) NOT NULL DEFAULT 'feature',
  `pri` tinyint unsigned NOT NULL DEFAULT '3',
  `estimate` float unsigned NOT NULL DEFAULT '0',
  `status` enum('','changing','active','draft','closed','reviewing','launched','developing') NOT NULL DEFAULT '',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `color` char(7) NOT NULL DEFAULT '',
  `stage` enum('','wait','inroadmap','incharter','planned','projected','designing','designed','developing','developed','testing','tested','verified','rejected','delivering','delivered','released','closed') NOT NULL DEFAULT 'wait',
  `stagedBy` char(30) NOT NULL DEFAULT '',
  `mailto` text,
  `lib` mediumint unsigned NOT NULL DEFAULT '0',
  `fromStory` mediumint unsigned NOT NULL DEFAULT '0',
  `fromVersion` smallint NOT NULL DEFAULT '1',
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `approvedDate` date DEFAULT NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `changedBy` varchar(30) NOT NULL DEFAULT '',
  `changedDate` datetime DEFAULT NULL,
  `reviewedBy` varchar(255) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  `releasedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `closedReason` varchar(30) NOT NULL DEFAULT '',
  `activatedDate` datetime DEFAULT NULL,
  `toBug` mediumint unsigned NOT NULL DEFAULT '0',
  `linkStories` varchar(255) NOT NULL DEFAULT '',
  `linkRequirements` varchar(255) NOT NULL DEFAULT '',
  `docs` text,
  `twins` varchar(255) NOT NULL DEFAULT '',
  `duplicateStory` mediumint unsigned NOT NULL DEFAULT '0',
  `version` smallint NOT NULL DEFAULT '1',
  `parentVersion` smallint NOT NULL DEFAULT '0',
  `demandVersion` smallint NOT NULL DEFAULT '0',
  `storyChanged` enum('0','1') NOT NULL DEFAULT '0',
  `feedbackBy` varchar(100) NOT NULL DEFAULT '',
  `notifyEmail` varchar(100) NOT NULL DEFAULT '',
  `BSA` char(30) NOT NULL DEFAULT '',
  `duration` char(30) NOT NULL DEFAULT '',
  `demand` mediumint NOT NULL DEFAULT '0',
  `submitedBy` varchar(30) NOT NULL DEFAULT '',
  `roadmap` varchar(255) NOT NULL DEFAULT '',
  `URChanged` enum('0','1') NOT NULL DEFAULT '0',
  `unlinkReason` enum('','omit','other') NOT NULL DEFAULT '',
  `retractedReason` enum('','omit','other') NOT NULL DEFAULT '',
  `retractedBy` varchar(30) NOT NULL DEFAULT '',
  `retractedDate` datetime DEFAULT NULL,
  `verifiedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `product` (`product`),
  KEY `root` (`root`),
  KEY `status` (`status`),
  KEY `assignedTo` (`assignedTo`),
  KEY `feedback` (`feedback`)
) ENGINE=InnoDB;
CREATE TABLE `zt_storyestimate` (
  `story` mediumint NOT NULL DEFAULT '0',
  `round` smallint NOT NULL DEFAULT '0',
  `estimate` text,
  `average` float NOT NULL DEFAULT '0',
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  UNIQUE KEY `story` (`story`,`round`)
) ENGINE=InnoDB;
CREATE TABLE `zt_storygrade` (
  `type` enum('story','requirement','epic') NOT NULL,
  `grade` smallint NOT NULL,
  `name` char(30) NOT NULL,
  `status` char(30) NOT NULL
) ENGINE=InnoDB;
CREATE TABLE `zt_storyreview` (
  `story` mediumint NOT NULL DEFAULT '0',
  `version` smallint NOT NULL DEFAULT '0',
  `reviewer` varchar(30) NOT NULL DEFAULT '',
  `result` varchar(30) NOT NULL DEFAULT '',
  `reviewDate` datetime DEFAULT NULL,
  UNIQUE KEY `story` (`story`,`version`,`reviewer`)
) ENGINE=InnoDB;
CREATE TABLE `zt_storyspec` (
  `story` mediumint NOT NULL DEFAULT '0',
  `version` smallint NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `spec` mediumtext,
  `verify` mediumtext,
  `files` text,
  `docs` text,
  `docVersions` text,
  UNIQUE KEY `story` (`story`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_storystage` (
  `story` mediumint unsigned NOT NULL DEFAULT '0',
  `branch` mediumint unsigned NOT NULL DEFAULT '0',
  `stage` varchar(50) NOT NULL DEFAULT '',
  `stagedBy` char(30) NOT NULL DEFAULT '',
  UNIQUE KEY `story_branch` (`story`,`branch`),
  KEY `story` (`story`)
) ENGINE=InnoDB;
CREATE TABLE `zt_suitecase` (
  `suite` mediumint unsigned NOT NULL DEFAULT '0',
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `case` mediumint unsigned NOT NULL DEFAULT '0',
  `version` smallint unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `suitecase` (`suite`,`case`)
) ENGINE=InnoDB;
CREATE TABLE `zt_system` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `integrated` enum('0','1') NOT NULL DEFAULT '0',
  `latestRelease` mediumint unsigned NOT NULL DEFAULT '0',
  `latestDate` datetime DEFAULT NULL,
  `children` varchar(255) NOT NULL DEFAULT '',
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `desc` mediumtext,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_product` (`product`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB;
CREATE TABLE `zt_task` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `parent` mediumint NOT NULL DEFAULT '0',
  `isParent` tinyint(1) NOT NULL DEFAULT '0',
  `isTpl` tinyint unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `execution` mediumint unsigned NOT NULL DEFAULT '0',
  `module` mediumint unsigned NOT NULL DEFAULT '0',
  `design` mediumint unsigned NOT NULL DEFAULT '0',
  `story` mediumint unsigned NOT NULL DEFAULT '0',
  `storyVersion` smallint NOT NULL DEFAULT '1',
  `designVersion` smallint unsigned NOT NULL DEFAULT '1',
  `fromBug` mediumint unsigned NOT NULL DEFAULT '0',
  `feedback` mediumint unsigned NOT NULL DEFAULT '0',
  `fromIssue` mediumint unsigned NOT NULL DEFAULT '0',
  `docs` text,
  `docVersions` text,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT '',
  `mode` varchar(10) NOT NULL DEFAULT '',
  `pri` tinyint unsigned NOT NULL DEFAULT '0',
  `estimate` float unsigned NOT NULL DEFAULT '0',
  `consumed` float unsigned NOT NULL DEFAULT '0',
  `left` float unsigned NOT NULL DEFAULT '0',
  `deadline` date DEFAULT NULL,
  `status` enum('wait','doing','done','pause','cancel','closed') NOT NULL DEFAULT 'wait',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `color` char(7) NOT NULL DEFAULT '',
  `mailto` text,
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext,
  `version` smallint NOT NULL DEFAULT '0',
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `estStarted` date DEFAULT NULL,
  `realStarted` datetime DEFAULT NULL,
  `finishedBy` varchar(30) NOT NULL DEFAULT '',
  `finishedDate` datetime DEFAULT NULL,
  `finishedList` text,
  `canceledBy` varchar(30) NOT NULL DEFAULT '',
  `canceledDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `planDuration` int NOT NULL DEFAULT '0',
  `realDuration` int NOT NULL DEFAULT '0',
  `closedReason` varchar(30) NOT NULL DEFAULT '',
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `activatedDate` datetime DEFAULT NULL,
  `order` mediumint unsigned NOT NULL DEFAULT '0',
  `repo` mediumint unsigned NOT NULL DEFAULT '0',
  `mr` mediumint unsigned NOT NULL DEFAULT '0',
  `entry` varchar(255) NOT NULL DEFAULT '',
  `lines` varchar(10) NOT NULL DEFAULT '',
  `v1` varchar(40) NOT NULL DEFAULT '',
  `v2` varchar(40) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  KEY `execution` (`execution`),
  KEY `story` (`story`),
  KEY `parent` (`parent`),
  KEY `path` (`path`),
  KEY `assignedTo` (`assignedTo`),
  KEY `order` (`order`),
  KEY `feedback` (`feedback`)
) ENGINE=InnoDB;
CREATE TABLE `zt_taskestimate` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `task` mediumint unsigned NOT NULL DEFAULT '0',
  `date` date DEFAULT NULL,
  `left` float unsigned NOT NULL DEFAULT '0',
  `consumed` float unsigned NOT NULL DEFAULT '0',
  `account` char(30) NOT NULL DEFAULT '',
  `work` text,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `task` (`task`)
) ENGINE=InnoDB;
CREATE TABLE `zt_taskspec` (
  `task` mediumint NOT NULL DEFAULT '0',
  `version` smallint NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `estStarted` date DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  UNIQUE KEY `task` (`task`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_taskteam` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `task` mediumint unsigned NOT NULL DEFAULT '0',
  `account` char(30) NOT NULL DEFAULT '',
  `estimate` decimal(12,2) NOT NULL DEFAULT '0.00',
  `consumed` decimal(12,2) NOT NULL DEFAULT '0.00',
  `left` decimal(12,2) NOT NULL DEFAULT '0.00',
  `transfer` char(30) NOT NULL DEFAULT '',
  `status` enum('wait','doing','done','cancel','closed') NOT NULL DEFAULT 'wait',
  `storyVersion` smallint NOT NULL DEFAULT '1',
  `order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `task` (`task`)
) ENGINE=InnoDB;
CREATE TABLE `zt_team` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `root` mediumint unsigned NOT NULL DEFAULT '0',
  `type` enum('project','task','execution') NOT NULL DEFAULT 'project',
  `account` char(30) NOT NULL DEFAULT '',
  `role` char(30) NOT NULL DEFAULT '',
  `position` varchar(30) NOT NULL DEFAULT '',
  `limited` char(8) NOT NULL DEFAULT 'no',
  `join` date DEFAULT NULL,
  `days` smallint unsigned NOT NULL DEFAULT '0',
  `hours` float(3,1) unsigned NOT NULL DEFAULT '0.0',
  `estimate` decimal(12,2) unsigned NOT NULL DEFAULT '0.00',
  `consumed` decimal(12,2) unsigned NOT NULL DEFAULT '0.00',
  `left` decimal(12,2) unsigned NOT NULL DEFAULT '0.00',
  `order` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `team` (`root`,`type`,`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_testreport` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `execution` mediumint unsigned NOT NULL DEFAULT '0',
  `tasks` varchar(255) NOT NULL DEFAULT '',
  `builds` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `owner` char(30) NOT NULL DEFAULT '',
  `members` text,
  `stories` text,
  `bugs` text,
  `cases` text,
  `report` text,
  `objectType` varchar(20) NOT NULL DEFAULT '',
  `objectID` mediumint unsigned NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_testresult` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `run` mediumint unsigned NOT NULL DEFAULT '0',
  `case` mediumint unsigned NOT NULL DEFAULT '0',
  `version` smallint unsigned NOT NULL DEFAULT '0',
  `job` mediumint unsigned NOT NULL DEFAULT '0',
  `compile` mediumint unsigned NOT NULL DEFAULT '0',
  `caseResult` char(30) NOT NULL DEFAULT '',
  `stepResults` text,
  `ZTFResult` text,
  `node` int unsigned NOT NULL DEFAULT '0',
  `lastRunner` varchar(30) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  `duration` float NOT NULL DEFAULT '0',
  `xml` text,
  `deploy` mediumint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `case` (`case`),
  KEY `version` (`version`),
  KEY `run` (`run`)
) ENGINE=InnoDB;
CREATE TABLE `zt_testrun` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `task` mediumint unsigned NOT NULL DEFAULT '0',
  `case` mediumint unsigned NOT NULL DEFAULT '0',
  `version` tinyint unsigned NOT NULL DEFAULT '0',
  `assignedTo` char(30) NOT NULL DEFAULT '',
  `lastRunner` varchar(30) NOT NULL DEFAULT '',
  `lastRunDate` datetime DEFAULT NULL,
  `lastRunResult` char(30) NOT NULL DEFAULT '',
  `status` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `task` (`task`,`case`)
) ENGINE=InnoDB;
CREATE TABLE `zt_testsuite` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext,
  `type` varchar(20) NOT NULL DEFAULT '',
  `order` smallint unsigned NOT NULL DEFAULT '0',
  `addedBy` char(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`)
) ENGINE=InnoDB;
CREATE TABLE `zt_testtask` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `name` char(90) NOT NULL DEFAULT '',
  `execution` mediumint unsigned NOT NULL DEFAULT '0',
  `build` char(30) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `pri` tinyint unsigned NOT NULL DEFAULT '0',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `realBegan` date DEFAULT NULL,
  `realFinishedDate` datetime DEFAULT NULL,
  `mailto` text,
  `desc` mediumtext,
  `report` text,
  `status` enum('blocked','doing','wait','done') NOT NULL DEFAULT 'wait',
  `testreport` mediumint unsigned NOT NULL DEFAULT '0',
  `auto` varchar(10) NOT NULL DEFAULT 'no',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `members` text,
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `build` (`build`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ticket` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint unsigned NOT NULL DEFAULT '0',
  `module` mediumint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text,
  `openedBuild` varchar(255) NOT NULL DEFAULT '',
  `feedback` mediumint NOT NULL DEFAULT '0',
  `assignedTo` varchar(255) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `realStarted` datetime DEFAULT NULL,
  `startedBy` varchar(255) NOT NULL DEFAULT '',
  `startedDate` datetime DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `pri` tinyint unsigned NOT NULL DEFAULT '0',
  `estimate` float unsigned NOT NULL DEFAULT '0',
  `left` float unsigned NOT NULL DEFAULT '0',
  `status` varchar(30) NOT NULL DEFAULT '',
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `activatedCount` int NOT NULL DEFAULT '0',
  `activatedBy` varchar(30) NOT NULL DEFAULT '',
  `activatedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `closedReason` varchar(30) NOT NULL DEFAULT '',
  `finishedBy` varchar(30) NOT NULL DEFAULT '',
  `finishedDate` datetime DEFAULT NULL,
  `resolvedBy` varchar(30) NOT NULL DEFAULT '',
  `resolvedDate` datetime DEFAULT NULL,
  `resolution` text,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `repeatTicket` mediumint NOT NULL DEFAULT '0',
  `mailto` varchar(255) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `feedback` (`feedback`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ticketrelation` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `ticketId` mediumint unsigned NOT NULL DEFAULT '0',
  `objectId` mediumint NOT NULL DEFAULT '0',
  `objectType` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `ticketId` (`ticketId`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ticketsource` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `ticketId` mediumint unsigned NOT NULL DEFAULT '0',
  `customer` varchar(100) NOT NULL DEFAULT '',
  `contact` varchar(100) NOT NULL DEFAULT '',
  `notifyEmail` varchar(100) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticketId` (`ticketId`)
) ENGINE=InnoDB;
CREATE TABLE `zt_todo` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `date` date DEFAULT NULL,
  `begin` smallint(4) unsigned zerofill NOT NULL DEFAULT '0000',
  `end` smallint(4) unsigned zerofill NOT NULL DEFAULT '0000',
  `feedback` mediumint unsigned NOT NULL DEFAULT '0',
  `type` char(15) NOT NULL DEFAULT '',
  `cycle` tinyint unsigned NOT NULL DEFAULT '0',
  `objectID` mediumint unsigned NOT NULL DEFAULT '0',
  `pri` tinyint unsigned NOT NULL DEFAULT '0',
  `name` char(150) NOT NULL DEFAULT '',
  `desc` mediumtext,
  `status` enum('wait','doing','done','closed') NOT NULL DEFAULT 'wait',
  `private` tinyint(1) NOT NULL DEFAULT '0',
  `config` varchar(1000) NOT NULL DEFAULT '',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `finishedBy` varchar(30) NOT NULL DEFAULT '',
  `finishedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `assignedTo` (`assignedTo`),
  KEY `finishedBy` (`finishedBy`),
  KEY `date` (`date`),
  KEY `feedback` (`feedback`)
) ENGINE=InnoDB;
CREATE TABLE `zt_traincategory` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` char(30) NOT NULL DEFAULT '',
  `parent` mediumint unsigned NOT NULL DEFAULT '0',
  `path` char(255) NOT NULL DEFAULT '',
  `grade` tinyint NOT NULL DEFAULT '0',
  `order` mediumint NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `path` (`path`)
) ENGINE=InnoDB;
CREATE TABLE `zt_traincontents` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(50) NOT NULL DEFAULT '',
  `course` mediumint unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `parent` mediumint unsigned NOT NULL DEFAULT '0',
  `path` char(255) NOT NULL DEFAULT '',
  `desc` text,
  `order` mediumint NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_traincourse` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL DEFAULT '',
  `category` mediumint NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(10) NOT NULL DEFAULT '',
  `teacher` varchar(30) NOT NULL DEFAULT '',
  `desc` mediumtext,
  `importedStatus` enum('','wait','doing','done') NOT NULL DEFAULT '',
  `lastUpdatedTime` int unsigned NOT NULL DEFAULT '0',
  `createdBy` varchar(255) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `editedBy` varchar(255) NOT NULL DEFAULT '',
  `editedDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_trainplan` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `place` varchar(255) NOT NULL DEFAULT '',
  `trainee` text,
  `lecturer` varchar(20) NOT NULL DEFAULT '',
  `type` enum('inside','outside') NOT NULL DEFAULT 'inside',
  `status` varchar(20) NOT NULL DEFAULT '',
  `summary` mediumtext,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_trainrecords` (
  `user` char(30) NOT NULL DEFAULT '',
  `objectId` mediumint unsigned NOT NULL DEFAULT '0',
  `objectType` varchar(10) NOT NULL DEFAULT '',
  `status` varchar(10) NOT NULL DEFAULT '',
  UNIQUE KEY `object` (`user`,`objectId`,`objectType`)
) ENGINE=InnoDB;
CREATE TABLE `zt_trip` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('trip','egress') NOT NULL DEFAULT 'trip',
  `customers` varchar(20) NOT NULL DEFAULT '',
  `name` char(30) NOT NULL DEFAULT '',
  `desc` text,
  `year` char(4) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `start` time DEFAULT NULL,
  `finish` time DEFAULT NULL,
  `from` char(50) NOT NULL DEFAULT '',
  `to` char(50) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `createdBy` (`createdBy`)
) ENGINE=InnoDB;
CREATE TABLE `zt_user` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `company` mediumint unsigned NOT NULL DEFAULT '0',
  `type` char(30) NOT NULL DEFAULT 'inside',
  `dept` mediumint unsigned NOT NULL DEFAULT '0',
  `account` char(30) NOT NULL DEFAULT '',
  `password` char(32) NOT NULL DEFAULT '',
  `role` char(10) NOT NULL DEFAULT '',
  `realname` varchar(100) NOT NULL DEFAULT '',
  `superior` char(30) DEFAULT '',
  `pinyin` varchar(255) NOT NULL DEFAULT '',
  `nickname` char(60) NOT NULL DEFAULT '',
  `commiter` varchar(100) NOT NULL DEFAULT '',
  `avatar` text,
  `birthday` date DEFAULT NULL,
  `gender` enum('f','m') NOT NULL DEFAULT 'f',
  `email` char(90) NOT NULL DEFAULT '',
  `skype` char(90) NOT NULL DEFAULT '',
  `qq` char(20) NOT NULL DEFAULT '',
  `mobile` char(11) NOT NULL DEFAULT '',
  `phone` char(20) NOT NULL DEFAULT '',
  `weixin` varchar(90) NOT NULL DEFAULT '',
  `dingding` varchar(90) NOT NULL DEFAULT '',
  `slack` varchar(90) NOT NULL DEFAULT '',
  `whatsapp` varchar(90) NOT NULL DEFAULT '',
  `address` char(120) NOT NULL DEFAULT '',
  `zipcode` char(10) NOT NULL DEFAULT '',
  `nature` text,
  `analysis` text,
  `strategy` text,
  `join` date DEFAULT NULL,
  `visits` mediumint unsigned NOT NULL DEFAULT '0',
  `visions` varchar(20) NOT NULL DEFAULT 'rnd,lite',
  `ip` varchar(255) NOT NULL DEFAULT '',
  `last` int unsigned NOT NULL DEFAULT '0',
  `fails` tinyint NOT NULL DEFAULT '0',
  `locked` datetime DEFAULT NULL,
  `feedback` enum('0','1') NOT NULL DEFAULT '0',
  `ranzhi` char(30) NOT NULL DEFAULT '',
  `ldap` char(30) NOT NULL DEFAULT '',
  `score` int NOT NULL DEFAULT '0',
  `scoreLevel` int NOT NULL DEFAULT '0',
  `resetToken` varchar(50) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `clientStatus` enum('online','away','busy','offline','meeting') NOT NULL DEFAULT 'offline',
  `clientLang` varchar(10) NOT NULL DEFAULT 'zh-cn',
  PRIMARY KEY (`id`),
  UNIQUE KEY `account` (`account`),
  KEY `dept` (`dept`),
  KEY `email` (`email`),
  KEY `commiter` (`commiter`),
  KEY `deleted` (`deleted`)
) ENGINE=InnoDB;
CREATE TABLE `zt_usercontact` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `listName` varchar(60) NOT NULL DEFAULT '',
  `userList` text,
  `public` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `account` (`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_usergroup` (
  `account` char(30) NOT NULL DEFAULT '',
  `group` mediumint unsigned NOT NULL DEFAULT '0',
  `project` text,
  UNIQUE KEY `account` (`account`,`group`)
) ENGINE=InnoDB;
CREATE TABLE `zt_userquery` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `title` varchar(90) NOT NULL DEFAULT '',
  `form` text,
  `sql` text,
  `shortcut` enum('0','1') NOT NULL DEFAULT '0',
  `common` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `module` (`module`)
) ENGINE=InnoDB;
CREATE TABLE `zt_usertpl` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT '',
  `title` varchar(150) NOT NULL DEFAULT '',
  `content` text,
  `public` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `account` (`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_userview` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `programs` mediumtext,
  `products` mediumtext,
  `projects` mediumtext,
  `sprints` mediumtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `account` (`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_webhook` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(15) NOT NULL DEFAULT 'default',
  `name` varchar(50) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `domain` varchar(255) NOT NULL DEFAULT '',
  `secret` varchar(255) NOT NULL DEFAULT '',
  `contentType` varchar(30) NOT NULL DEFAULT 'application/json',
  `sendType` enum('sync','async') NOT NULL DEFAULT 'sync',
  `products` text,
  `executions` text,
  `params` varchar(100) NOT NULL DEFAULT '',
  `actions` text,
  `desc` text,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_weeklyreport` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `weekStart` date DEFAULT NULL,
  `pv` float(9,2) NOT NULL DEFAULT '0.00',
  `ev` float(9,2) NOT NULL DEFAULT '0.00',
  `ac` float(9,2) NOT NULL DEFAULT '0.00',
  `sv` float(9,2) NOT NULL DEFAULT '0.00',
  `cv` float(9,2) NOT NULL DEFAULT '0.00',
  `staff` smallint unsigned NOT NULL DEFAULT '0',
  `progress` varchar(255) NOT NULL DEFAULT '',
  `workload` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `week` (`project`,`weekStart`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workestimation` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint unsigned NOT NULL DEFAULT '0',
  `scale` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `productivity` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `duration` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `unitLaborCost` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `totalLaborCost` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `dayHour` decimal(10,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflow` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `group` mediumint unsigned NOT NULL DEFAULT '0',
  `parent` varchar(30) NOT NULL DEFAULT '',
  `child` varchar(30) NOT NULL DEFAULT '',
  `type` varchar(10) NOT NULL DEFAULT 'flow',
  `navigator` varchar(10) NOT NULL DEFAULT '',
  `app` varchar(20) NOT NULL DEFAULT '',
  `position` varchar(30) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `table` varchar(50) NOT NULL DEFAULT '',
  `name` varchar(30) NOT NULL DEFAULT '',
  `icon` varchar(30) NOT NULL DEFAULT 'flow',
  `titleField` varchar(30) NOT NULL DEFAULT '',
  `contentField` text,
  `flowchart` text,
  `js` text,
  `css` text,
  `order` smallint unsigned NOT NULL DEFAULT '0',
  `buildin` tinyint unsigned NOT NULL DEFAULT '0',
  `role` varchar(10) NOT NULL DEFAULT 'buildin',
  `belong` varchar(50) NOT NULL DEFAULT '',
  `administrator` text,
  `desc` text,
  `version` varchar(10) NOT NULL DEFAULT '1.0',
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `approval` enum('enabled','disabled') NOT NULL DEFAULT 'disabled',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`group`,`app`,`module`,`vision`),
  KEY `type` (`type`),
  KEY `app` (`app`),
  KEY `module` (`module`),
  KEY `order` (`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowaction` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `group` mediumint unsigned NOT NULL DEFAULT '0',
  `module` varchar(30) NOT NULL DEFAULT '',
  `action` varchar(50) NOT NULL DEFAULT '',
  `method` varchar(50) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `type` enum('single','batch') NOT NULL DEFAULT 'single',
  `batchMode` enum('same','different') NOT NULL DEFAULT 'different',
  `extensionType` varchar(10) NOT NULL DEFAULT 'override',
  `open` varchar(20) NOT NULL DEFAULT '',
  `position` enum('menu','browseandview','browse','view') NOT NULL DEFAULT 'browseandview',
  `layout` char(20) NOT NULL DEFAULT '',
  `show` enum('dropdownlist','direct') NOT NULL DEFAULT 'dropdownlist',
  `order` smallint unsigned NOT NULL DEFAULT '0',
  `buildin` tinyint unsigned NOT NULL DEFAULT '0',
  `role` varchar(10) NOT NULL DEFAULT 'custom',
  `virtual` tinyint unsigned NOT NULL DEFAULT '0',
  `conditions` text,
  `verifications` text,
  `hooks` text,
  `linkages` text,
  `js` text,
  `css` text,
  `toList` char(255) NOT NULL DEFAULT '',
  `blocks` text,
  `desc` text,
  `status` varchar(10) NOT NULL DEFAULT 'enable',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`group`,`module`,`action`,`vision`),
  KEY `module` (`module`),
  KEY `action` (`action`),
  KEY `order` (`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowdatasource` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('system','sql','func','option','lang','category') NOT NULL DEFAULT 'option',
  `name` varchar(30) NOT NULL DEFAULT '',
  `code` varchar(30) NOT NULL DEFAULT '',
  `datasource` text,
  `view` varchar(20) NOT NULL DEFAULT '',
  `keyField` varchar(50) NOT NULL DEFAULT '',
  `valueField` varchar(50) NOT NULL DEFAULT '',
  `buildin` tinyint unsigned NOT NULL DEFAULT '0',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowfield` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `group` mediumint unsigned NOT NULL DEFAULT '0',
  `module` varchar(30) NOT NULL DEFAULT '',
  `field` varchar(50) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT 'varchar',
  `length` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `control` varchar(20) NOT NULL DEFAULT '',
  `expression` text,
  `options` text,
  `default` varchar(100) NOT NULL DEFAULT '',
  `rules` varchar(255) NOT NULL DEFAULT '',
  `placeholder` varchar(255) NOT NULL DEFAULT '',
  `order` smallint unsigned NOT NULL DEFAULT '0',
  `searchOrder` smallint unsigned NOT NULL DEFAULT '0',
  `exportOrder` smallint unsigned NOT NULL DEFAULT '0',
  `canExport` enum('0','1') NOT NULL DEFAULT '0',
  `canSearch` enum('0','1') NOT NULL DEFAULT '0',
  `isValue` enum('0','1') NOT NULL DEFAULT '0',
  `readonly` enum('0','1') NOT NULL DEFAULT '0',
  `buildin` tinyint unsigned NOT NULL DEFAULT '0',
  `role` varchar(10) NOT NULL DEFAULT 'custom',
  `desc` text,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`group`,`module`,`field`),
  KEY `module` (`module`),
  KEY `field` (`field`),
  KEY `order` (`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowgroup` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `objectID` mediumint unsigned NOT NULL DEFAULT '0',
  `type` varchar(10) NOT NULL DEFAULT '',
  `projectModel` varchar(10) NOT NULL DEFAULT '',
  `projectType` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `code` varchar(30) NOT NULL DEFAULT '',
  `desc` text,
  `disabledModules` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `main` enum('0','1') NOT NULL DEFAULT '0',
  `exclusive` enum('0','1') NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deliverable` text,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowlabel` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `group` mediumint unsigned NOT NULL DEFAULT '0',
  `module` varchar(30) NOT NULL DEFAULT '',
  `action` varchar(30) NOT NULL DEFAULT 'browse',
  `code` varchar(30) NOT NULL DEFAULT '',
  `label` varchar(255) NOT NULL DEFAULT '',
  `params` text,
  `orderBy` text,
  `order` tinyint NOT NULL DEFAULT '0',
  `buildin` tinyint unsigned NOT NULL DEFAULT '0',
  `role` varchar(10) NOT NULL DEFAULT 'custom',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`module`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowlayout` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `group` mediumint unsigned NOT NULL DEFAULT '0',
  `module` varchar(30) NOT NULL DEFAULT '',
  `action` varchar(50) NOT NULL DEFAULT '',
  `ui` mediumint NOT NULL DEFAULT '0',
  `field` varchar(50) NOT NULL DEFAULT '',
  `order` smallint unsigned NOT NULL DEFAULT '0',
  `width` varchar(50) NOT NULL DEFAULT '0',
  `position` text,
  `readonly` enum('0','1') NOT NULL DEFAULT '0',
  `mobileShow` enum('0','1') NOT NULL DEFAULT '1',
  `summary` varchar(20) NOT NULL DEFAULT '',
  `defaultValue` text,
  `layoutRules` varchar(255) NOT NULL DEFAULT '',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`group`,`module`,`action`,`ui`,`field`,`vision`),
  KEY `module` (`module`),
  KEY `action` (`action`),
  KEY `order` (`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowlinkdata` (
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` mediumint unsigned NOT NULL DEFAULT '0',
  `linkedType` varchar(30) NOT NULL DEFAULT '',
  `linkedID` mediumint unsigned NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  UNIQUE KEY `unique` (`objectType`,`objectID`,`linkedType`,`linkedID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowrelation` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `prev` varchar(30) NOT NULL DEFAULT '',
  `next` varchar(30) NOT NULL DEFAULT '',
  `field` varchar(50) NOT NULL DEFAULT '',
  `actions` varchar(20) NOT NULL DEFAULT '',
  `actionCodes` text,
  `buildin` enum('0','1') NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowrelationlayout` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `prev` varchar(30) NOT NULL DEFAULT '',
  `next` varchar(30) NOT NULL DEFAULT '',
  `action` varchar(50) NOT NULL DEFAULT '',
  `ui` mediumint NOT NULL DEFAULT '0',
  `field` varchar(50) NOT NULL DEFAULT '',
  `order` smallint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`prev`,`next`,`action`,`ui`,`field`),
  KEY `prev` (`prev`),
  KEY `next` (`next`),
  KEY `action` (`action`),
  KEY `order` (`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowreport` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `name` varchar(100) NOT NULL,
  `type` enum('pie','line','bar') NOT NULL DEFAULT 'pie',
  `countType` enum('sum','count') NOT NULL DEFAULT 'sum',
  `displayType` enum('value','percent') NOT NULL DEFAULT 'value',
  `dimension` varchar(130) NOT NULL,
  `fields` text NOT NULL,
  `order` smallint unsigned NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowrule` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('system','regex','func') NOT NULL DEFAULT 'regex',
  `name` varchar(30) NOT NULL DEFAULT '',
  `rule` text,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowsql` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL DEFAULT '',
  `field` varchar(50) NOT NULL DEFAULT '',
  `action` varchar(50) NOT NULL DEFAULT '',
  `sql` text,
  `vars` text,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`module`),
  KEY `field` (`field`),
  KEY `action` (`action`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowui` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `group` mediumint unsigned NOT NULL DEFAULT '0',
  `module` varchar(30) NOT NULL,
  `action` varchar(50) NOT NULL,
  `name` varchar(30) NOT NULL,
  `conditions` text,
  PRIMARY KEY (`id`),
  KEY `module` (`module`),
  KEY `action` (`action`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowversion` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL DEFAULT '',
  `version` varchar(10) NOT NULL DEFAULT '',
  `fields` text,
  `actions` text,
  `layouts` text,
  `sqls` text,
  `labels` text,
  `table` text,
  `datas` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `moduleversion` (`module`,`version`),
  KEY `module` (`module`),
  KEY `version` (`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_zoutput` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `activity` mediumint NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `content` mediumtext,
  `optional` char(20) NOT NULL DEFAULT '',
  `tailorNorm` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `order` mediumint DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
