<?php
class projectreleaseZen extends projectrelease
{
    /**
     * 获取当前项目的所有产品，当前产品，分支，项目
     * Get products of the project and current product, branch, project.
     *
     * @param  int    $projectID
     * @param  int    $productID
     * @param  string $branch
     * @access public
     * @return void
     */
    protected function commonAction($projectID = 0, $productID = 0, $branch = '')
    {
        /* 获取当前项目的所有产品。*/
        /* Get product list by project. */
        $this->products = $this->product->getProductPairsByProject($projectID);
        if(empty($this->products)) $this->locate($this->createLink('product', 'showErrorNone', 'moduleName=project&activeMenu=projectrelease&projectID=' . $projectID));

        /* 获取当前的产品。*/
        /*  Get current product. */
        if(!$productID) $productID = key($this->products);
        $this->loadModel('product')->checkAccess($productID, $this->products);
        $product = $this->product->getByID($productID);

        $this->view->products = $this->products;
        $this->view->product  = $product;
        $this->view->branches = (isset($product->type) and $product->type == 'normal') ? array() : $this->loadModel('branch')->getPairs($productID, 'active', $projectID);
        $this->view->branch   = $branch;
        $this->view->project  = $this->project->getByID($projectID);
    }
}
