<?php
/**
 * The browse view file of meeting module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Fangzhou Hu <hufangzhou@easycorp.ltd>
 * @package     meeting
 * @link        https://www.zentao.net
 */
namespace zin;

$cols = $this->loadModel('datatable')->getSetting('meeting');
$cols['project']['map']   = $projects;
$cols['execution']['map'] = $executions;
$cols['room']['map']      = $rooms;
$cols['dept']['map']      = $depts;

$cols['actions']['list']['edit']['url']['params'] = str_replace('{from}', $from, $cols['actions']['list']['edit']['url']['params']);

$meetings = initTableData($meetings, $cols, $this->meeting);

$linkParams = '';
foreach($app->rawParams as $key => $value) $linkParams = $key != 'orderBy' ? "{$linkParams}&{$key}={$value}" : "{$linkParams}&orderBy={name}_{sortType}";

$params = $app->tab == 'my' ? "browseType={key}&param=&orderBy={$orderBy}&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}" : "projectID={$projectID}&from={$from}&browseType={key}&param=&orderBy={$orderBy}&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}";
featureBar
(
    set::current($browseType),
    set::linkParams($params),
    li(searchToggle(set::open($browseType == 'bysearch'), set::module('meeting')))
);

toolbar
(
    (empty($project) || common::canModify('project', $project)) && hasPriv('meeting', 'create') ? btn
    (
        setClass('btn primary'),
        set::icon('plus'),
        set::url(createLink('meeting', 'create', "objectID={$projectID}&from={$from}")),
        $lang->meeting->create
    ) : null
);

dtable
(
    set::cols($cols),
    set::data($meetings),
    set::customCols(true),
    set::userMap($users),
    set::orderBy($orderBy),
    set::sortLink(createLink($app->rawModule, $app->rawMethod, $linkParams)),
    set::footPager(usePager())
);
