<?php
$config->ai->vendorList = array();
$config->ai->vendorList['openai']['credentials']           = array('key');
$config->ai->vendorList['azure']['credentials']            = array('key', 'resource', 'deployment');
$config->ai->vendorList['openaiCompatible']['credentials'] = array('key', 'base');
$config->ai->vendorList['baidu']['credentials']            = array('key', 'secret');

$config->ai->models = array('openai-gpt35' => 'openai', 'openai-gpt4' => 'openai', 'baidu-ernie' => 'ernie');

/* OpenAI GPT configurations. */
$config->ai->openai = new stdclass();
$config->ai->openai->api = new stdclass();
$config->ai->openai->api->vendor = array('openai', 'azure', 'openaiCompatible');
$config->ai->openai->api->openai = new stdclass();
$config->ai->openai->api->openai->version    = 'v1';                           // OpenAI API version, required.
$config->ai->openai->api->openai->format     = 'https://api.openai.com/%s/%s'; // OpenAI API format, args: API version, API name.
$config->ai->openai->api->openai->authFormat = 'Authorization: Bearer %s';     // OpenAI API auth header format.
$config->ai->openai->api->azure = new stdclass();
$config->ai->openai->api->azure->resource    = '';                             // Azure OpenAI resource name, required.
$config->ai->openai->api->azure->deployment  = '';                             // Azure OpenAI deployment name, required.
$config->ai->openai->api->azure->apiVersion  = '2023-07-01-preview';           // Azure OpenAI API version, required.
$config->ai->openai->api->azure->format      = 'https://%s.openai.azure.com/openai/deployments/%s/%s?api-version=%s'; // Azure API format, args: resource name, deployment name, API name, API version.
$config->ai->openai->api->azure->authFormat  = 'api-key: %s';                  // Azure API auth header format.
$config->ai->openai->api->openaiCompatible = new stdclass();
$config->ai->openai->api->openaiCompatible->format     = '%s/%s';                    // OpenAI API format, args: API base URL, API name.
$config->ai->openai->api->openaiCompatible->authFormat = 'Authorization: Bearer %s'; // OpenAI API auth header format.
$config->ai->openai->api->methods = array('function' => 'chat/completions', 'chat' => 'chat/completions', 'completion' => 'completions');

$config->ai->openai->params = new stdclass();
$config->ai->openai->params->chat       = new stdclass();
$config->ai->openai->params->function   = new stdclass();
$config->ai->openai->params->completion = new stdclass();
$config->ai->openai->params->chat->required       = array('messages');
$config->ai->openai->params->chat->optional       = array('max_tokens', 'temperature', 'top_p', 'n', 'stream', 'stop', 'presence_penalty', 'frequency_penalty', 'logit_bias', 'user');
$config->ai->openai->params->function->required   = array('messages', 'functions', 'function_call');
$config->ai->openai->params->function->optional   = array('max_tokens', 'temperature', 'top_p', 'n', 'stream', 'stop', 'presence_penalty', 'frequency_penalty', 'logit_bias', 'user');
$config->ai->openai->params->completion->required = array('prompt', 'max_tokens');
$config->ai->openai->params->completion->optional = array('suffix', 'temperature', 'top_p', 'n', 'stream', 'logprobs', 'echo', 'stop', 'presence_penalty', 'frequency_penalty', 'best_of', 'logit_bias', 'user');

$config->ai->openai->model = new stdclass();
$config->ai->openai->model->chat       = array('openai-gpt35' => 'gpt-3.5-turbo', 'openai-gpt4' => 'gpt-4-1106-preview');
$config->ai->openai->model->function   = array('openai-gpt35' => 'gpt-3.5-turbo', 'openai-gpt4' => 'gpt-4-1106-preview');
$config->ai->openai->model->completion = 'gpt-3.5-turbo-instruct';

$config->ai->openai->contentTypeMapping = array('Content-Type: application/json' => array('', 'function', 'chat', 'completion'), 'Content-Type: multipart/form-data' => array());
$config->ai->openai->contentType = array();
foreach($config->ai->openai->contentTypeMapping as $contentType => $apis)
{
    foreach($apis as $api) $config->ai->openai->contentType[$api] = $contentType;
}

/* Baidu ERNIE configurations. */
$config->ai->ernie = new stdclass();
$config->ai->ernie->api = new stdclass();
$config->ai->ernie->api->vendor = array('baidu');
$config->ai->ernie->api->baidu = new stdclass();
$config->ai->ernie->api->baidu->format = 'https://aip.baidubce.com/rpc/2.0/ai_custom/v1/wenxinworkshop/chat/completions?access_token=%s';        // ERNIE API format, arg: access_token (obtained from bce oauth).
$config->ai->ernie->api->baidu->auth   = 'https://aip.baidubce.com/oauth/2.0/token?grant_type=client_credentials&client_id=%s&client_secret=%s'; // BCE auth URL format, args: client_id, client_secret.

$config->ai->ernie->params = new stdclass();
$config->ai->ernie->params->chat     = new stdclass();
$config->ai->ernie->params->function = new stdclass();
$config->ai->ernie->params->chat->required     = array('messages');
$config->ai->ernie->params->chat->optional     = array('temperature', 'top_p', 'penalty_score', 'stream', 'system', 'user_id');
$config->ai->ernie->params->function->required = array('messages', 'functions');
$config->ai->ernie->params->function->optional = array('temperature', 'top_p', 'penalty_score', 'stream', 'system', 'user_id');

$config->ai->ernie->model = new stdclass();
$config->ai->ernie->model->chat     = 'ernie-bot-turbo';
$config->ai->ernie->model->function = 'ernie-bot-turbo';

$config->ai->ernie->contentTypeMapping = array('Content-Type: application/json' => array('', 'function', 'chat'), 'Content-Type: multipart/form-data' => array());
$config->ai->ernie->contentType = array();
foreach($config->ai->ernie->contentTypeMapping as $contentType => $apis)
{
    foreach($apis as $api) $config->ai->ernie->contentType[$api] = $contentType;
}

/* Required fields of forms. */
$config->ai->createprompt = new stdclass();
$config->ai->testPrompt   = new stdclass();
$config->ai->createprompt->requiredFields = 'name';
$config->ai->testPrompt->requiredFields   = 'name,module,source,purpose,targetForm';

/* Data source object props definations, commented out ones are not supported for now. */
$config->ai->dataSource = array();
// $config->ai->dataSource['my']['efforts']              = array('date', 'work', 'account', 'consumed', 'left', 'objectID', 'product', 'project', 'execution');
$config->ai->dataSource['product']['product']         = array('name', 'desc');
// $config->ai->dataSource['product']['modules']         = array('name', 'modules');
$config->ai->dataSource['project']['project']         = array('name', 'type', 'desc', 'begin', 'end', 'estimate');
$config->ai->dataSource['project']['programplans']    = array('name', 'desc', 'status', 'begin', 'end', 'realBegan', 'realEnd', 'planDuration', 'progress', 'estimate', 'consumed', 'left');
$config->ai->dataSource['project']['executions']      = array('name', 'desc', 'status', 'begin', 'end', 'realBegan', 'realEnd', 'estimate', 'consumed', 'progress');
$config->ai->dataSource['story']['story']             = array('title', 'spec', 'verify', 'product', 'module', 'pri', 'category', 'estimate');
$config->ai->dataSource['productplan']['productplan'] = array('title', 'desc', 'begin', 'end');
$config->ai->dataSource['productplan']['stories']     = array('title', 'module', 'pri', 'estimate', 'status', 'stage');
$config->ai->dataSource['productplan']['bugs']        = array('title', 'pri', 'status');
$config->ai->dataSource['release']['release']         = array('product', 'name', 'desc', 'date');
$config->ai->dataSource['release']['stories']         = array('title', 'estimate');
$config->ai->dataSource['release']['bugs']            = array('title');
$config->ai->dataSource['execution']['execution']     = array('name', 'desc', 'estimate');
$config->ai->dataSource['execution']['tasks']         = array('name', 'pri', 'status', 'estimate', 'consumed', 'left', 'progress', 'estStarted', 'realStarted', 'finishedDate', 'closedReason');
$config->ai->dataSource['task']['task']               = array('name', 'desc', 'pri', 'status', 'estimate', 'consumed', 'left', 'progress', 'estStarted', 'realStarted');
$config->ai->dataSource['case']['case']               = array('title', 'precondition', 'scene', 'product', 'module', 'pri', 'type', 'lastRunResult', 'status');
$config->ai->dataSource['case']['steps']              = array('desc', 'expect');
$config->ai->dataSource['bug']['bug']                 = array('title', 'steps', 'severity','pri', 'status', 'confirmed', 'type');
$config->ai->dataSource['doc']['doc']                 = array('title', 'addedBy', 'addedDate', 'editedBy', 'editedDate', 'content');

/* Available target form definations. Please also update `$lang->ai->targetForm` upon changes! Some are commented out, these need extra work. */
$config->ai->targetForm = array();
// $config->ai->targetForm['product']['tree/managechild']   = (object)array('m' => 'tree', 'f' => 'browse');
// $config->ai->targetForm['product']['doc/create']         = (object)array('m' => 'doc', 'f' => 'create');
$config->ai->targetForm['story']['create']               = (object)array('m' => 'story', 'f' => 'create');
$config->ai->targetForm['story']['batchcreate']          = (object)array('m' => 'story', 'f' => 'batchcreate');
$config->ai->targetForm['story']['change']               = (object)array('m' => 'story', 'f' => 'change');
$config->ai->targetForm['story']['totask']               = (object)array('m' => 'task', 'f' => 'batchcreate');
$config->ai->targetForm['story']['testcasecreate']       = (object)array('m' => 'testcase', 'f' => 'create');
$config->ai->targetForm['story']['subdivide']            = (object)array('m' => 'story', 'f' => 'batchcreate');
$config->ai->targetForm['productplan']['edit']           = (object)array('m' => 'productplan', 'f' => 'edit');
$config->ai->targetForm['productplan']['create']         = (object)array('m' => 'productplan', 'f' => 'create');
// $config->ai->targetForm['projectrelease']['doc/create']  = (object)array('m' => 'doc', 'f' => 'create');
// $config->ai->targetForm['project']['risk/create']        = (object)array('m' => 'risk', 'f' => 'create');
// $config->ai->targetForm['project']['issue/create']       = (object)array('m' => 'issue', 'f' => 'create');
// $config->ai->targetForm['project']['doc/create']         = (object)array('m' => 'doc', 'f' => 'create');
$config->ai->targetForm['project']['programplan/create'] = (object)array('m' => 'programplan', 'f' => 'create');
$config->ai->targetForm['execution']['batchcreatetask']  = (object)array('m' => 'task', 'f' => 'batchcreate');
// $config->ai->targetForm['execution']['createtestreport'] = (object)array('m' => 'execution', 'f' => 'testreport');
// $config->ai->targetForm['execution']['createqa']         = (object)array('m' => 'execution', 'f' => 'createQA');
// $config->ai->targetForm['execution']['createrisk']       = (object)array('m' => 'execution', 'f' => 'createRisk');
// $config->ai->targetForm['execution']['createissue']      = (object)array('m' => 'execution', 'f' => 'createIssue');
$config->ai->targetForm['task']['edit']                  = (object)array('m' => 'task', 'f' => 'edit');
$config->ai->targetForm['task']['batchcreate']           = (object)array('m' => 'task', 'f' => 'batchcreate');
$config->ai->targetForm['testcase']['edit']              = (object)array('m' => 'testcase', 'f' => 'edit');
// $config->ai->targetForm['testcase']['createscript']      = (object)array('m' => 'testcase', 'f' => 'createScript');
$config->ai->targetForm['bug']['edit']                   = (object)array('m' => 'bug', 'f' => 'edit');
$config->ai->targetForm['bug']['story/create']           = (object)array('m' => 'story', 'f' => 'create');
$config->ai->targetForm['bug']['testcase/create']        = (object)array('m' => 'testcase', 'f' => 'create');
// $config->ai->targetForm['doc']['create']                 = (object)array('m' => 'doc', 'f' => 'create');
$config->ai->targetForm['doc']['edit']                   = (object)array('m' => 'doc', 'f' => 'edit');

/* Used to check if form injection is available, generated from `$config->ai->targetForm`. */
$config->ai->availableForms = array();
foreach($config->ai->targetForm as $forms)
{
    foreach($forms as $form)
    {
        if(!empty($config->ai->availableForms[$form->m]) && in_array($form->f, $config->ai->availableForms[$form->m])) continue;
        $config->ai->availableForms[$form->m][] = $form->f;
    }
}

/**
 * Target form variables definations, defines format and arguments of target form redirection links,
 * useful when method requires additional arguments.
 *
 * Arg keys are names of objects, usually the same as object name. Arg values indicate if arg is required.
 * It will be used to get object ID and sprintf to format.
 */
$config->ai->targetFormVars = array();
$config->ai->targetFormVars['story']['create']         = (object)array('format' => 'product=%d', 'args' => array('product' => 1), 'app' => 'product');
$config->ai->targetFormVars['story']['batchcreate']    = (object)array('format' => 'productID=%d', 'args' => array('product' => 1), 'app' => 'product');
$config->ai->targetFormVars['story']['change']         = (object)array('format' => 'storyID=%d', 'args' => array('story' => 1), 'app' => 'product');
$config->ai->targetFormVars['productplan']['create']   = (object)array('format' => 'productID=%d&branch=%d&parent=%d', 'args' => array('product' => 1, 'branch' => 0, 'productplan' => 0), 'app' => 'product');
$config->ai->targetFormVars['productplan']['edit']     = (object)array('format' => 'planID=%d', 'args' => array('productplan' => 1), 'app' => 'product');
$config->ai->targetFormVars['task']['create']          = (object)array('format' => 'executionID=%d&storyID=%d', 'args' => array('execution' => 1, 'story' => 0), 'app' => 'execution');
$config->ai->targetFormVars['task']['batchcreate']     = (object)array('format' => 'executionID=%d&storyID=%d', 'args' => array('execution' => 1, 'story' => 0), 'app' => 'execution');
$config->ai->targetFormVars['task']['edit']            = (object)array('format' => 'taskID=%d', 'args' => array('task' => 1), 'app' => 'execution');
$config->ai->targetFormVars['bug']['create']           = (object)array('format' => 'productID=%d', 'args' => array('product' => 1), 'app' => 'qa');
$config->ai->targetFormVars['bug']['edit']             = (object)array('format' => 'bugID=%d', 'args' => array('bug' => 1), 'app' => 'qa');
$config->ai->targetFormVars['testcase']['create']      = (object)array('format' => 'productID=%d', 'args' => array('product' => 1), 'app' => 'qa');
$config->ai->targetFormVars['testcase']['edit']        = (object)array('format' => 'caseID=%d', 'args' => array('case' => 1), 'app' => 'qa');
$config->ai->targetFormVars['testreport']['create']    = (object)array('format' => 'productID=%d', 'args' => array('product' => 1), 'app' => 'qa');
$config->ai->targetFormVars['execution']['testreport'] = (object)array('format' => '', 'args' => array(), 'app' => 'execution');
// $config->ai->targetFormVars['tree']['browse']          = (object)array('format' => 'rootID=%d&view=%s', 'args' => array('root', 'view'), 'app' => 'product');
$config->ai->targetFormVars['programplan']['create']   = (object)array('format' => 'projectID=%d', 'args' => array('project' => 1), 'app' => 'project');
$config->ai->targetFormVars['doc']['edit']             = (object)array('format' => 'docID=%d', 'args' => array('doc' => 1), 'app' => 'doc');

/* Menu printing configurations. */
$config->ai->menuPrint = new stdclass();
/**
 * Menu location definations, defines acceptable module-methods and on page menu locations, etc.
 * Some are identical except for module name, reuse them as much as possible.
 *
 * @param string $module           prompt module name (actual module could differ from prompt module name)
 * @param string $targetContainer  injection target container selector
 * @param string $class            class of menu or dropdown button
 * @param string $buttonClass      specified class of action menu buttons
 * @param string $dropdownClass    specified class of dropdown menu button
 * @param string $objectVarName    object variable name of view
 * @param string $stylesheet       stylesheet to be injected
 * @param string $injectMethod     injection jQuery method, `append` by default
 * @see ./view/promptmenu.html.php
 */
$config->ai->menuPrint->locations = array();
$config->ai->menuPrint->locations['story']['view'] = (object)array(
    'module'          => 'story',
    'targetContainer' => '#mainContent .detail-body .detail-section:first-of-type > div:first-of-type',
    'stylesheet'      => '#mainContent .detail-body .detail-section:first-of-type > div:first-of-type {width: 100%; justify-content: space-between;}'
);
$config->ai->menuPrint->locations['task']['view']             = clone $config->ai->menuPrint->locations['story']['view'];
$config->ai->menuPrint->locations['task']['view']->module     = 'task';
$config->ai->menuPrint->locations['testcase']['view']         = clone $config->ai->menuPrint->locations['story']['view'];
$config->ai->menuPrint->locations['testcase']['view']->module = 'case';
$config->ai->menuPrint->locations['bug']['view']              = clone $config->ai->menuPrint->locations['story']['view'];
$config->ai->menuPrint->locations['bug']['view']->module      = 'bug';
$config->ai->menuPrint->locations['projectstory']['view']     = clone $config->ai->menuPrint->locations['story']['view'];
$config->ai->menuPrint->locations['execution']['storyView']   = $config->ai->menuPrint->locations['story']['view'];

$config->ai->menuPrint->locations['execution']['view'] = (object)array( // TODO: fix this.
    'module'          => 'execution',
    'injectMethod'    => 'prepend',
    'targetContainer' => '#mainContent.main-row > .col-4.side-col .detail:first-child  > .detail-title',
    'class'           => 'pull-right'
);

$config->ai->menuPrint->locations['project']['view']         = clone $config->ai->menuPrint->locations['execution']['view'];
$config->ai->menuPrint->locations['project']['view']->module = 'project';
$config->ai->menuPrint->locations['project']['view']         = clone $config->ai->menuPrint->locations['execution']['view'];
$config->ai->menuPrint->locations['project']['view']->module = 'project';

$config->ai->menuPrint->locations['product']['view'] = (object)array( // TODO: fix this.
    'module'          => 'product',
    'injectMethod'    => 'append',
    'targetContainer' => '#mainContent.main-row > .col-8.main-col .detail:first-child > .detail-title',
    'class'           => 'pull-right'
);

$config->ai->menuPrint->locations['productplan']['view'] = (object)array(
    'module'          => 'productplan',
    'injectMethod'    => 'prepend',
    'targetContainer' => '#mainContent .toolbar',
    'objectVarName'   => 'plan'
);
$config->ai->menuPrint->locations['projectplan']['view']                   = $config->ai->menuPrint->locations['productplan']['view'];
$config->ai->menuPrint->locations['release']['view']                       = clone $config->ai->menuPrint->locations['productplan']['view'];
$config->ai->menuPrint->locations['release']['view']->module               = 'release';
$config->ai->menuPrint->locations['release']['view']->objectVarName        = null;
$config->ai->menuPrint->locations['projectrelease']['view']                = clone $config->ai->menuPrint->locations['productplan']['view'];
$config->ai->menuPrint->locations['projectrelease']['view']->objectVarName = null;

$config->ai->menuPrint->locations['doc']['view'] = (object)array(
    'module'          => 'doc',
    'targetContainer' => '#docMoreActionsBtn',
    'injectMethod'    => 'before',
    'buttonPlacement' => 'bottom-end'
);

$config->ai->injectAuditButton = new stdclass();
$config->ai->injectAuditButton->locations = array();
$config->ai->injectAuditButton->locations['task']['edit'] = array(
    'toolbar' => (object)array(
        'targetContainer' => '#mainContent .detail-header, #mainContent .panel-heading, #mainContent form div',
        'injectMethod'    => 'append',
        'class'           => 'pull-right btn-toolbar',
    ),
    'action' => (object)array(
        'targetContainer' => '#mainContent > .panel > .panel-body .form-actions',
        'injectMethod'    => 'html',
    )
);

$config->ai->injectAuditButton->locations['bug']['create'] = array(
    'toolbar' => (object)array(
        'targetContainer' => '#mainContent .panel-heading',
        'injectMethod'    => 'append',
        'containerStyles' => '{"padding-right": "8px"}',
    ),
    'action' => (object)array(
        'targetContainer' => '#mainContent > .panel > .panel-body .form-actions',
        'injectMethod'    => 'html',
    )
);

$config->ai->injectAuditButton->locations['doc']['edit'] = array(
    'toolbar' => (object)array(
        'targetContainer' => '.titleBox',
        'injectMethod'    => 'append',
    ),
    'action' => (object)array(
        'targetContainer' => '.titleBox',
        'injectMethod'    => 'append',
    )
);

$config->ai->injectAuditButton->locations['productplan']['create'] = $config->ai->injectAuditButton->locations['task']['edit'];
$config->ai->injectAuditButton->locations['productplan']['edit']   = $config->ai->injectAuditButton->locations['task']['edit'];
$config->ai->injectAuditButton->locations['programplan']['create'] = $config->ai->injectAuditButton->locations['task']['edit'];
$config->ai->injectAuditButton->locations['bug']['edit']           = $config->ai->injectAuditButton->locations['task']['edit'];
$config->ai->injectAuditButton->locations['story']['change']       = $config->ai->injectAuditButton->locations['task']['edit'];
$config->ai->injectAuditButton->locations['testcase']['edit']      = $config->ai->injectAuditButton->locations['task']['edit'];
$config->ai->injectAuditButton->locations['testreport']['create']  = $config->ai->injectAuditButton->locations['task']['edit'];

$config->ai->injectAuditButton->locations['story']['create']      = $config->ai->injectAuditButton->locations['bug']['create'];
$config->ai->injectAuditButton->locations['task']['create']       = $config->ai->injectAuditButton->locations['bug']['create'];
$config->ai->injectAuditButton->locations['testcase']['create']   = $config->ai->injectAuditButton->locations['bug']['create'];

$config->ai->injectAuditButton->locations['story']['batchcreate'] = $config->ai->injectAuditButton->locations['bug']['create'];
$config->ai->injectAuditButton->locations['story']['batchcreate']['toolbar']->targetContainer = '#mainContent .panel-heading .panel-actions';
$config->ai->injectAuditButton->locations['task']['batchcreate']  = $config->ai->injectAuditButton->locations['story']['batchcreate'];

$config->ai->miniPrograms = new stdClass();
$config->ai->miniPrograms->iconList = array();
$config->ai->miniPrograms->iconList['writinghand']  = '<svg id="writinghand" width="24" height="26" viewBox="0 0 24 26" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_342_93810)"><path d="M4.21149 15.5588C4.15999 16.2068 4.42341 16.4007 4.83602 16.7085C5.24402 17.0128 7.72961 14.6937 8.5423 14.3409C9.35499 13.9881 16.9841 12.2684 16.6533 10.6984C16.3226 9.12838 14.0172 8.89647 12.2413 9.21693C10.4654 9.5374 7.06679 11.2002 6.07387 12.0976C5.08095 12.9944 4.21149 15.5588 4.21149 15.5588ZM9.9036 16.6109C9.9036 16.6109 7.55532 17.4226 7.55532 19.5309C7.55532 21.6392 8.12705 22.8283 8.39772 23.4053C8.66906 23.9816 9.51211 24.541 10.6787 24.0034C12.0334 23.3786 10.3545 19.7839 14.6398 21.434C16.6032 22.1895 18.6398 23.2106 20.6204 22.5079C22.4993 21.8409 23.2228 19.325 23.2228 17.9194C23.2228 15.0423 21.2423 15.8111 20.5821 16.5139C19.9219 17.2167 14.6404 18.6222 13.9802 18.6222C13.3201 18.6222 9.9036 16.6109 9.9036 16.6109Z" fill="#EF9645"/><path d="M12.8662 20.1599C12.8662 20.1599 12.787 19.2351 11.9584 19.1275C11.2778 19.0397 10.205 19.2814 9.64778 20.467C9.09058 21.6533 8.1003 21.4551 8.14189 22.4432C8.18283 23.4313 8.47199 24.2002 9.07012 24.3977C9.6689 24.5958 10.5146 24.2445 10.6176 23.1903C10.7206 22.1361 10.8447 21.1698 11.4838 20.7524C12.1241 20.3356 12.8662 20.1599 12.8662 20.1599Z" fill="#F9CA55"/><path d="M11.9998 18.6222C11.9998 18.6222 11.3396 17.9194 10.0192 17.9194C8.69883 17.9194 5.61972 19.4185 6.55322 22.3996C7.21341 24.508 9.09098 23.5199 9.35901 21.4333C9.62771 19.344 11.9998 18.6222 11.9998 18.6222Z" fill="#EF9645"/><path d="M11.3392 18.6222C11.3392 18.6222 10.679 17.9194 9.35861 17.9194C8.03824 17.9194 6.13361 18.9947 6.05769 22.1361C5.99563 24.7055 8.71889 23.5417 8.69843 21.4333C8.67796 19.325 11.3392 18.6222 11.3392 18.6222Z" fill="#F9CA55"/><path d="M3.41699 19.325C3.41699 21.6421 3.7187 23.0399 5.01992 22.8016C7.17807 22.4067 6.35878 19.559 8.24757 18.7579C9.61877 18.1767 11.6152 18.3151 13.5423 19.533C14.8118 20.3356 13.98 17.2167 12.6596 16.5139C11.3392 15.8111 7.3781 16.5139 6.71792 16.5139C6.05773 16.5139 3.41699 19.325 3.41699 19.325Z" fill="#EF9645"/><path d="M3.3133 19.4473C2.26294 21.3202 2.902 23.2564 4.73797 22.8389C6.51453 22.4355 5.6246 19.9786 7.37872 18.6222C8.36173 17.8618 10.4803 17.6067 11.8006 18.3095C13.121 19.0123 13.3204 17.2167 12 16.5139C10.6796 15.8111 6.36203 16.4963 5.70317 16.5399C4.44287 16.6235 3.3133 19.4473 3.3133 19.4473Z" fill="#F9CA55"/><path d="M6.33393 20.8107C5.88566 21.3574 5.10598 21.4144 4.5917 20.9372L4.4623 20.817C3.94802 20.3398 3.8952 19.5105 4.34347 18.9631L19.2128 0.819447C19.6611 0.272686 20.4408 0.215761 20.955 0.692947L21.0838 0.813122C21.5981 1.29031 21.6509 2.12029 21.2033 2.66705L6.33393 20.8107Z" fill="#3B88C3"/><path d="M7.04188 19.9477C5.48384 21.8487 1.55376 25.5762 1.05598 25.1145C0.558863 24.6528 3.49405 20.0018 5.05208 18.1001C6.61012 16.1984 6.14865 17.7192 6.69792 18.2301C7.2472 18.7403 8.59992 18.0474 7.04188 19.9477Z" fill="#3B88C3"/><path d="M4.52051 17.9377C4.52051 18.6405 6.11882 19.2835 6.779 18.5808C7.43919 17.878 8.98468 17.015 11.0167 17.9194C15.7727 20.0348 13.9796 17.2167 11.9991 16.5139C10.0185 15.8111 6.7176 16.5139 6.05742 16.5139C5.39723 16.5139 4.52051 17.9377 4.52051 17.9377Z" fill="#EF9645"/><path d="M4.20636 15.8413C3.97001 15.0591 5.65084 10.7257 6.41203 10.0546C7.37062 9.20985 11.0789 7.90198 12.3993 7.90198C13.7196 7.90198 23.223 12.9999 23.223 16.5138C23.223 20.0277 21.9026 20.4669 20.0046 21.0158C18.4868 21.455 15.3074 21.1859 13.9183 19.8077C12.701 18.6004 11.8553 17.7655 10.6795 17.2166C8.49954 16.199 7.04647 17.5146 6.38629 18.2174C5.06592 19.6229 2.57834 18.1056 4.6533 15.7014C6.13806 13.9803 7.44588 13.4441 8.69892 12.9999C12.66 11.5944 15.3008 11.5944 13.9804 10.1888C13.5136 9.69195 13.2595 10.432 12.6099 10.5578C11.3027 10.8108 10.2622 10.9808 8.53981 11.5923C7.94432 11.8031 5.12533 13.7168 4.20636 15.8413Z" fill="#FFDC5D"/><path d="M8.82806 11.7876C9.5305 11.515 12.5924 10.9218 14.1855 10.3343C15.4722 9.85921 16.6011 10.7813 14.1591 11.7595C11.8022 12.7033 9.35357 12.626 7.56777 13.3808C6.8924 13.6662 6.30681 12.7659 8.82806 11.7876Z" fill="#EF9645"/><path d="M14.9617 5.9884C14.9617 5.9884 11.0481 10.7638 9.38574 12.7779C10.8738 12.1272 12.2054 12.2509 13.4776 11.4539C14.7497 10.6577 15.33 9.808 17.2604 7.45159C17.9774 6.57733 14.9617 5.9884 14.9617 5.9884Z" fill="#3B88C3"/></g><defs><clipPath id="clip0_342_93810"><rect width="23.7667" height="25.3" fill="white" transform="translate(0.116211 0.349976)"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['notebook']     = '<svg id="notebook" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3650)"><path d="M32.0001 23.1111C32.0001 25.0747 30.4081 26.6667 28.4446 26.6667H7.11122C5.14766 26.6667 3.55566 25.0747 3.55566 23.1111V5.61156C3.55566 3.648 8.70322 0 10.6668 0H27.2223C29.9726 0 32.0001 2.05511 32.0001 4.77778V23.1111Z" fill="#F4900C"/><path d="M30.2224 26.6665C30.2224 28.6301 28.6304 30.2221 26.6668 30.2221H8.88905C6.9255 30.2221 5.3335 28.6301 5.3335 26.6665V5.33322C5.3335 1.67188 5.31483 1.77766 9.77794 1.77766H26.6668C28.6304 1.77766 30.2224 3.36966 30.2224 5.33322V26.6665Z" fill="#CCD6DD"/><path d="M28.4446 27.5557C28.4446 29.0286 27.2508 30.2223 25.7779 30.2223H6.22233C4.74944 30.2223 3.55566 29.0286 3.55566 27.5557V6.22233C3.55566 4.74944 4.74944 3.55566 6.22233 3.55566H25.7779C27.2508 3.55566 28.4446 4.74944 28.4446 6.22233V27.5557Z" fill="#E1E8ED"/><path d="M28.4443 28.4444C28.4443 30.4079 26.8523 31.9999 24.8888 31.9999H7.99989C6.03634 31.9999 4.44434 30.4079 4.44434 28.4444V8.88881C4.44434 6.92525 6.03634 5.33325 7.99989 5.33325H24.8888C26.8523 5.33325 28.4443 6.92525 28.4443 8.88881V28.4444Z" fill="#FFAC33"/><path d="M26.6666 28.4444C26.6666 30.408 25.0746 32 23.111 32H7.99989C6.03634 32 4.44434 30.408 4.44434 28.4444V10.6666C4.44434 8.70308 6.03634 7.11108 7.99989 7.11108H23.4088C25.3723 7.11108 26.6666 8.40531 26.6666 10.3689V28.4444Z" fill="#FFCC4D"/><path d="M8.00011 5.33333C6.49966 5.33333 6.46144 3.62489 7.11122 2.88889C7.85077 2.05244 9.00011 1.77778 11.0561 1.77778H12.4446V0H10.0277C6.49966 0 3.55566 2.22222 3.55566 4.77778V28.4444C3.55566 30.408 5.14766 32 7.11122 32H8.889V5.33333H8.00011Z" fill="#F4900C"/><path d="M7.59282 29.3146C7.59282 29.9386 6.99994 30.4444 6.26838 30.4444C5.53771 30.4444 4.94482 29.9386 4.94482 29.3146C4.94482 28.6915 5.53771 28.1848 6.26838 28.1848C6.99994 28.1848 7.59282 28.6906 7.59282 29.3146Z" fill="#662113"/><path d="M6.12795 28.6853C5.70129 28.7341 5.42395 29.0186 5.22395 29.3333C4.95106 29.7644 4.32884 30.2221 3.55551 30.2221C2.57417 30.2221 1.77773 29.6257 1.77773 28.8888C1.77773 28.1519 2.57417 27.5555 3.55551 27.5555V25.7812C1.62929 25.7999 0.0737305 27.1813 0.0737305 28.8888C0.0737305 30.6079 1.64884 31.9999 3.59195 31.9999C5.23995 31.9999 6.56706 31.071 7.05951 29.7164C7.30573 29.0417 6.64262 28.6284 6.12795 28.6853Z" fill="#66757F"/><path d="M7.59282 22.2035C7.59282 22.8275 6.99994 23.3333 6.26838 23.3333C5.53771 23.3333 4.94482 22.8275 4.94482 22.2035C4.94482 21.5804 5.53771 21.0737 6.26838 21.0737C6.99994 21.0737 7.59282 21.5795 7.59282 22.2035Z" fill="#662113"/><path d="M6.12795 21.5742C5.70129 21.6231 5.42395 21.9075 5.22395 22.2222C4.95106 22.6533 4.32884 23.1111 3.55551 23.1111C2.57417 23.1111 1.77773 22.5146 1.77773 21.7777C1.77773 21.0408 2.57417 20.4444 3.55551 20.4444V18.6702C1.62929 18.6888 0.0737305 20.0702 0.0737305 21.7777C0.0737305 23.4968 1.64884 24.8888 3.59195 24.8888C5.23995 24.8888 6.56706 23.9599 7.05951 22.6053C7.30573 21.9306 6.64262 21.5173 6.12795 21.5742Z" fill="#66757F"/><path d="M7.59282 15.0924C7.59282 15.7164 6.99994 16.2222 6.26838 16.2222C5.53771 16.2222 4.94482 15.7164 4.94482 15.0924C4.94482 14.4693 5.53771 13.9626 6.26838 13.9626C6.99994 13.9626 7.59282 14.4684 7.59282 15.0924Z" fill="#662113"/><path d="M6.12795 14.4631C5.70129 14.512 5.42395 14.7964 5.22395 15.1111C4.95106 15.5422 4.32884 16 3.55551 16C2.57417 16 1.77773 15.4035 1.77773 14.6666C1.77773 13.9297 2.57417 13.3333 3.55551 13.3333V11.5591C1.62929 11.5777 0.0737305 12.9591 0.0737305 14.6666C0.0737305 16.3857 1.64884 17.7777 3.59195 17.7777C5.23995 17.7777 6.56706 16.8489 7.05951 15.4942C7.30573 14.8195 6.64262 14.4062 6.12795 14.4631Z" fill="#66757F"/><path d="M7.59282 7.98134C7.59282 8.60534 6.99994 9.11112 6.26838 9.11112C5.53771 9.11112 4.94482 8.60534 4.94482 7.98134C4.94482 7.35823 5.53771 6.85156 6.26838 6.85156C6.99994 6.85156 7.59282 7.35734 7.59282 7.98134Z" fill="#662113"/><path d="M6.12795 7.352C5.70129 7.40089 5.42395 7.68533 5.22395 8C4.95106 8.43111 4.32884 8.88889 3.55551 8.88889C2.57417 8.88889 1.77773 8.29244 1.77773 7.55555C1.77773 6.81866 2.57417 6.22222 3.55551 6.22222V4.448C1.63017 4.46578 0.0737305 5.848 0.0737305 7.55555C0.0737305 9.27466 1.64884 10.6667 3.59195 10.6667C5.23995 10.6667 6.56706 9.73778 7.05951 8.38311C7.30573 7.70844 6.64262 7.29511 6.12795 7.352Z" fill="#66757F"/></g><defs><clipPath id="clip0_914_3650"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['pencil']       = '<svg id="pencil" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3666)"><path d="M31.3085 29.865C30.7334 27.9974 29.7929 24.4792 29.2418 23.1397C28.7965 22.0588 28.3805 20.9725 27.8694 20.4605C27.3583 19.9494 26.4889 19.9894 25.9645 20.5121C25.9645 20.5121 23.7698 22.001 22.9831 22.9859C21.9983 23.7699 20.5076 25.9699 20.5076 25.9699C19.9831 26.4943 19.9431 27.3628 20.4543 27.8748C20.9663 28.3859 22.0525 28.8019 23.1343 29.2472C24.4729 29.7983 27.992 30.737 29.8596 31.3139C30.1787 31.4117 31.4063 30.1841 31.3085 29.865Z" fill="#D99E82"/><path d="M12.1271 4.71816C13.1502 5.74127 13.1502 7.39905 12.1271 8.42216L8.42311 12.127C7.4 13.1493 5.74045 13.1493 4.71911 12.127L1.01423 8.42216C-0.00799698 7.39905 -0.00799698 5.74127 1.01423 4.71816L4.71823 1.01416C5.74045 -0.0089516 7.39912 -0.0089516 8.42223 1.01416L12.1271 4.71816Z" fill="#EA596E"/><path d="M27.8695 20.4603L24.1628 24.167L20.4624 27.8692L6.5708 13.9786L13.9797 6.57056L27.8695 20.4603Z" fill="#FFCC4D"/><path d="M28.5137 30.9005C28.5137 30.9005 30.9217 32.224 31.5723 31.5734C32.223 30.9227 30.8923 28.52 30.8923 28.52C30.8923 28.52 28.6114 28.5627 28.5137 30.9005Z" fill="#292F33"/><path d="M1.94043 9.34834L9.34932 1.93945L13.9787 6.56967L6.57065 13.9786L1.94043 9.34834Z" fill="#CCD6DD"/><path d="M2.8667 10.2737L10.2747 2.86572L11.2009 3.79194L3.79292 11.1999L2.8667 10.2737ZM4.71825 12.1279L12.1271 4.71906L13.0534 5.64528L5.64448 13.0533L4.71825 12.1279Z" fill="#99AAB5"/></g><defs><clipPath id="clip0_914_3666"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['calendar']     = '<svg id="calendar" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3674)"><path d="M32 28.4443C32 30.4079 30.408 31.9999 28.4444 31.9999H3.55556C1.592 31.9999 0 30.4079 0 28.4443V7.99989C0 6.03634 1.592 4.44434 3.55556 4.44434H28.4444C30.408 4.44434 32 6.03634 32 7.99989V28.4443Z" fill="#E0E7EC"/><path d="M21.0286 16.9955H15.8846C14.8001 16.9955 14.3975 16.2924 14.3975 15.6088C14.3975 14.9057 14.7788 14.2222 15.8846 14.2222H23.1592C24.185 14.2222 24.6063 15.1466 24.6063 15.6693C24.6063 16.0711 24.385 16.4933 24.1441 16.9955L19.1601 27.1244C18.5975 28.2497 18.3761 28.6506 17.4721 28.6506C16.3663 28.6506 15.8037 27.8071 15.8037 27.2239C15.8037 26.9831 15.8641 26.8026 16.0046 26.5208L21.0286 16.9955ZM9.67923 16.8888H9.23479C8.27034 16.8888 7.86768 16.2391 7.86768 15.5555C7.86768 14.8515 8.3699 14.2222 9.23479 14.2222H11.0259C11.8899 14.2222 12.3726 14.8453 12.3726 15.6488V27.0844C12.3726 28.0888 11.8766 28.6515 11.0126 28.6515C10.1486 28.6515 9.67923 28.0888 9.67923 27.0844V16.8888Z" fill="#66757F"/><path d="M30.2222 0H27.3093C27.4622 0.262222 27.5556 0.563556 27.5556 0.888889C27.5556 1.87022 26.7591 2.66667 25.7778 2.66667C24.7964 2.66667 24 1.87022 24 0.888889C24 0.563556 24.0933 0.262222 24.2462 0H7.75378C7.90667 0.262222 8 0.563556 8 0.888889C8 1.87022 7.20356 2.66667 6.22222 2.66667C5.24089 2.66667 4.44444 1.87022 4.44444 0.888889C4.44444 0.563556 4.53778 0.262222 4.69067 0H1.77778C0.796444 0 0 0.796445 0 1.77778V11.5556H32V1.77778C32 0.796445 31.2036 0 30.2222 0Z" fill="#DD2F45"/><path d="M11.7174 4.0925C11.7174 3.64806 12.0019 3.39917 12.3841 3.39917C12.7654 3.39917 13.0499 3.64806 13.0499 4.0925V8.55206H14.6312C15.0845 8.55206 15.2801 8.88984 15.2712 9.19206C15.2534 9.48539 15.0223 9.77784 14.6312 9.77784H12.4108C11.9752 9.77784 11.7174 9.49428 11.7174 9.04984V4.0925ZM5.57522 4.0925C5.57522 3.64806 5.85966 3.39917 6.24188 3.39917C6.62411 3.39917 6.90855 3.64806 6.90855 4.0925V7.19295C6.90855 8.01073 7.43211 8.65873 8.27655 8.65873C9.08455 8.65873 9.63566 7.97517 9.63566 7.19295V4.0925C9.63566 3.64806 9.91922 3.39917 10.3014 3.39917C10.6837 3.39917 10.9681 3.64806 10.9681 4.0925V7.26406C10.9681 8.7565 9.74144 9.88539 8.27655 9.88539C6.79299 9.88539 5.57522 8.77428 5.57522 7.26406V4.0925ZM4.88011 8.00095C4.88011 9.49339 3.92988 9.8845 3.12099 9.8845C2.50855 9.8845 1.48633 9.6445 1.48633 8.87117C1.48633 8.63206 1.69077 8.32984 1.98411 8.32984C2.33966 8.32984 2.65077 8.65873 3.04988 8.65873C3.54766 8.65873 3.54766 8.1965 3.54766 7.91206V4.0925C3.54766 3.64806 3.83211 3.39917 4.21344 3.39917C4.59655 3.39917 4.88011 3.64806 4.88011 4.0925V8.00095Z" fill="#F5F8FA"/><path d="M28.4443 8.88881C28.4443 9.37947 28.8417 9.7777 29.3332 9.7777C29.8248 9.7777 30.2221 9.37947 30.2221 8.88881C30.2221 8.39814 29.8248 7.99992 29.3332 7.99992C28.8417 7.99992 28.4443 8.39814 28.4443 8.88881ZM28.4443 6.22214C28.4443 6.71281 28.8417 7.11103 29.3332 7.11103C29.8248 7.11103 30.2221 6.71281 30.2221 6.22214C30.2221 5.73147 29.8248 5.33325 29.3332 5.33325C28.8417 5.33325 28.4443 5.73147 28.4443 6.22214ZM25.7777 8.88881C25.7777 9.37947 26.175 9.7777 26.6666 9.7777C27.1581 9.7777 27.5554 9.37947 27.5554 8.88881C27.5554 8.39814 27.1581 7.99992 26.6666 7.99992C26.175 7.99992 25.7777 8.39814 25.7777 8.88881ZM25.7777 6.22214C25.7777 6.71281 26.175 7.11103 26.6666 7.11103C27.1581 7.11103 27.5554 6.71281 27.5554 6.22214C27.5554 5.73147 27.1581 5.33325 26.6666 5.33325C26.175 5.33325 25.7777 5.73147 25.7777 6.22214ZM23.111 8.88881C23.111 9.37947 23.5083 9.7777 23.9999 9.7777C24.4914 9.7777 24.8888 9.37947 24.8888 8.88881C24.8888 8.39814 24.4914 7.99992 23.9999 7.99992C23.5083 7.99992 23.111 8.39814 23.111 8.88881ZM23.111 6.22214C23.111 6.71281 23.5083 7.11103 23.9999 7.11103C24.4914 7.11103 24.8888 6.71281 24.8888 6.22214C24.8888 5.73147 24.4914 5.33325 23.9999 5.33325C23.5083 5.33325 23.111 5.73147 23.111 6.22214ZM20.4443 6.22214C20.4443 6.71281 20.8417 7.11103 21.3332 7.11103C21.8248 7.11103 22.2221 6.71281 22.2221 6.22214C22.2221 5.73147 21.8248 5.33325 21.3332 5.33325C20.8417 5.33325 20.4443 5.73147 20.4443 6.22214ZM20.4443 8.88881C20.4443 9.37947 20.8417 9.7777 21.3332 9.7777C21.8248 9.7777 22.2221 9.37947 22.2221 8.88881C22.2221 8.39814 21.8248 7.99992 21.3332 7.99992C20.8417 7.99992 20.4443 8.39814 20.4443 8.88881Z" fill="#F4ABBA"/></g><defs><clipPath id="clip0_914_3674"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['lock']         = '<svg id="lock" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3553)"><path d="M11.5554 2.66675C6.64606 2.66675 2.6665 6.6463 2.6665 11.5556V20.4445H6.22206V11.5556C6.22206 8.61075 8.6105 6.2223 11.5554 6.2223C14.5003 6.2223 16.8887 8.61075 16.8887 11.5556V20.4445H20.4443V11.5556C20.4443 6.6463 16.4647 2.66675 11.5554 2.66675Z" fill="#AAB8C2"/><path d="M23.1111 28.4444C23.1111 30.4079 21.5191 31.9999 19.5556 31.9999H3.55556C1.592 31.9999 0 30.4079 0 28.4444V17.7777C0 15.8142 1.592 14.2222 3.55556 14.2222H19.5556C21.5191 14.2222 23.1111 15.8142 23.1111 17.7777V28.4444Z" fill="#FFAC33"/><path d="M31.1113 8C31.1113 3.58133 27.53 0 23.1113 0C18.6927 0 15.1113 3.58133 15.1113 8C15.1113 11.4818 17.3398 14.4356 20.4447 15.5351V29.7778C20.4447 31.0053 21.4393 32 22.6669 32C23.7451 32 24.6429 31.232 24.8447 30.2133C24.8607 30.2142 24.8731 30.2222 24.8891 30.2222C25.3807 30.2222 25.778 29.8249 25.778 29.3333V28.4444C25.778 27.9529 25.3807 27.5556 24.8891 27.5556V26.6667C25.3807 26.6667 25.778 26.2693 25.778 25.7778V24C25.778 23.5084 25.3807 23.1111 24.8891 23.1111V21.0871C25.4189 20.7787 25.778 20.2124 25.778 19.5556V15.5351C28.8829 14.4364 31.1113 11.4827 31.1113 8ZM23.1113 1.77778C24.0927 1.77778 24.8891 2.57422 24.8891 3.55556C24.8891 4.53689 24.0927 5.33333 23.1113 5.33333C22.13 5.33333 21.3336 4.53689 21.3336 3.55556C21.3336 2.57422 22.13 1.77778 23.1113 1.77778Z" fill="#C1694F"/></g><defs><clipPath id="clip0_914_3553"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['search']       = '<svg id="search" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3559)"><path d="M24.3449 21.9039L21.8312 24.4177L17.4312 20.0177L19.9449 17.5039L24.3449 21.9039Z" fill="#9AAAB4"/><path d="M30.8292 25.8756L25.6034 20.6498C24.9092 19.9556 23.7838 19.9556 23.0896 20.6498L20.5758 23.1636C19.8816 23.8578 19.8816 24.9831 20.5758 25.6774L25.8016 30.9031C27.1901 32.2925 29.4425 32.2925 30.831 30.9031C32.2176 29.5156 32.2167 27.264 30.8292 25.8756Z" fill="#66757F"/><path d="M12.0767 24.1501C18.7041 24.1501 24.0767 18.7776 24.0767 12.1501C24.0767 5.52273 18.7041 0.150146 12.0767 0.150146C5.44924 0.150146 0.0766602 5.52273 0.0766602 12.1501C0.0766602 18.7776 5.44924 24.1501 12.0767 24.1501Z" fill="#8899A6"/><path d="M12.0763 20.5947C16.74 20.5947 20.5207 16.814 20.5207 12.1503C20.5207 7.48652 16.74 3.70581 12.0763 3.70581C7.41254 3.70581 3.63184 7.48652 3.63184 12.1503C3.63184 16.814 7.41254 20.5947 12.0763 20.5947Z" fill="#BBDDF5"/></g><defs><clipPath id="clip0_914_3559"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['chart']        = '<svg id="chart" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3643)"><path d="M27.5556 1.77783H4.4445C2.97161 1.77783 1.77783 2.97161 1.77783 4.4445V27.5556C1.77783 29.0285 2.97161 30.2223 4.4445 30.2223H27.5556C29.0285 30.2223 30.2223 29.0285 30.2223 27.5556V4.4445C30.2223 2.97161 29.0285 1.77783 27.5556 1.77783Z" fill="#CCD6DD"/><path d="M27.5553 0.888916H4.44423C2.48067 0.888916 0.888672 2.48092 0.888672 4.44447V27.5556C0.888672 29.5191 2.48067 31.1111 4.44423 31.1111H27.5553C29.5189 31.1111 31.1109 29.5191 31.1109 27.5556V4.44447C31.1109 2.48092 29.5189 0.888916 27.5553 0.888916ZM27.5553 2.66669C28.5358 2.66669 29.3331 3.46403 29.3331 4.44447V8.00003H23.9998V2.66669H27.5553ZM23.9998 16.8889H29.3331V22.2222H23.9998V16.8889ZM23.9998 15.1111V9.7778H29.3331V15.1111H23.9998ZM22.222 2.66669V8.00003H16.8887V2.66669H22.222ZM16.8887 9.7778H22.222V15.1111H16.8887V9.7778ZM16.8887 16.8889H22.222V22.2222H16.8887V16.8889ZM15.1109 2.66669V8.00003H9.77756V2.66669H15.1109ZM9.77756 9.7778H15.1109V15.1111H9.77756V9.7778ZM9.77756 16.8889H15.1109V22.2222H9.77756V16.8889ZM2.66645 4.44447C2.66645 3.46403 3.46378 2.66669 4.44423 2.66669H7.99978V8.00003H2.66645V4.44447ZM2.66645 9.7778H7.99978V15.1111H2.66645V9.7778ZM2.66645 16.8889H7.99978V22.2222H2.66645V16.8889ZM4.44423 29.3334C3.46378 29.3334 2.66645 28.536 2.66645 27.5556V24H7.99978V29.3334H4.44423ZM9.77756 29.3334V24H15.1109V29.3334H9.77756ZM16.8887 29.3334V24H22.222V29.3334H16.8887ZM27.5553 29.3334H23.9998V24H29.3331V27.5556C29.3331 28.536 28.5358 29.3334 27.5553 29.3334Z" fill="#E1E8ED"/><path d="M11.5555 29.3332H6.22217V14.2221C6.22217 13.2408 7.01861 12.4443 7.99995 12.4443H9.77772C10.7591 12.4443 11.5555 13.2408 11.5555 14.2221V29.3332Z" fill="#5C913B"/><path d="M25.7777 29.3333H20.4443V7.99995C20.4443 7.01861 21.2408 6.22217 22.2221 6.22217H23.9999C24.9812 6.22217 25.7777 7.01861 25.7777 7.99995V29.3333Z" fill="#3B94D9"/><path d="M18.6668 29.3334H13.3335V20.4445C13.3335 19.4632 14.1299 18.6667 15.1113 18.6667H16.8891C17.8704 18.6667 18.6668 19.4632 18.6668 20.4445V29.3334Z" fill="#DD2E44"/></g><defs><clipPath id="clip0_914_3643"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['computer']     = '<svg id="computer" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M30.2222 25.863C29.8516 25.007 29.4258 24.0781 28.4444 24.0781H27.5556C28.5369 24.0781 29.3333 23.279 29.3333 22.2933V7.11814C29.3333 6.13236 28.5369 5.33325 27.5556 5.33325H4.44444C3.46311 5.33325 2.66667 6.13236 2.66667 7.11814V22.2933C2.66667 23.279 3.46311 24.0781 4.44444 24.0781H3.55556C2.57422 24.0781 2.07378 24.9706 1.77778 25.863L0 30.2141C0 31.2008 0.796444 31.9999 1.77778 31.9999H30.2222C31.2036 31.9999 32 31.2008 32 30.215L30.2222 25.863Z" fill="#CCD6DD"/><path d="M0.00732422 30.2888L0.0126576 30.3395L0.163769 30.9546C0.444658 31.5697 1.05977 31.9999 1.77799 31.9999H30.2224C31.1789 31.9999 31.9531 31.2399 31.9931 30.2888H0.00732422Z" fill="#9AAAB4"/><path d="M27.5554 21.4C27.5554 21.8934 27.1581 22.2925 26.6666 22.2925H5.33322C4.84256 22.2925 4.44434 21.8934 4.44434 21.4V8.01158C4.44434 7.51825 4.84256 7.11914 5.33322 7.11914H26.6666C27.1581 7.11914 27.5554 7.51914 27.5554 8.01158V21.4Z" fill="#5DADEC"/><path d="M29.2499 27.5929L28.5743 25.6595C28.3619 25.2506 28.0099 24.9155 27.5183 24.9155H4.54232C4.05165 24.9155 3.73699 25.2782 3.51476 25.8364L2.90321 27.5937C2.70854 28.1235 3.30143 28.4862 3.7921 28.4862H10.5281C10.5281 28.4862 11.361 28.4444 11.5085 27.9457C11.6792 27.3697 11.8774 26.5022 11.9201 26.3493C11.9859 26.1146 12.265 25.8773 12.681 25.8773H20.3059C20.7503 25.8773 20.969 26.1022 21.0268 26.3804C21.0641 26.5617 21.3041 27.3946 21.4161 27.9644C21.5148 28.472 22.5014 28.4853 22.5014 28.4853H28.3628C28.8525 28.4853 29.4445 28.0666 29.2499 27.5929Z" fill="#AEBBC1"/><path d="M19.8888 29.4338H12.9724C12.6391 29.4338 12.4942 29.1289 12.5422 28.8338C12.5902 28.5396 12.8613 27.2401 12.8826 27.0889C12.9031 26.9369 13.1262 26.7556 13.3484 26.7556H19.5839C19.8479 26.7556 20.0195 26.9005 20.0728 27.1903C20.1253 27.4809 20.3413 28.6489 20.3582 28.9156C20.3751 29.1832 20.2079 29.4338 19.8888 29.4338Z" fill="#9AAAB4"/></svg>';
$config->ai->miniPrograms->iconList['cactus']       = '<svg id="cactus" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3516)"><path d="M18.1483 20.2062C17.9617 20.1289 16.5697 19.5556 15.7403 19.5556C13.9626 19.5556 11.5803 16 10.111 16C7.74034 16 6.00434 20.6444 4.44434 21.3707C3.1599 21.9689 2.64345 23.7582 2.43545 25.1004C2.2959 26.0036 2.2959 26.704 2.2959 26.704L18.1483 26.6667V20.2062Z" fill="#FFAC33"/><path d="M7.33312 10.6667C9.78771 10.6667 11.7776 8.67688 11.7776 6.22228C11.7776 3.76768 9.78771 1.77783 7.33312 1.77783C4.87852 1.77783 2.88867 3.76768 2.88867 6.22228C2.88867 8.67688 4.87852 10.6667 7.33312 10.6667Z" fill="#FFCC4D"/><path d="M7.33339 9.77786C9.29707 9.77786 10.8889 8.18598 10.8889 6.2223C10.8889 4.25862 9.29707 2.66675 7.33339 2.66675C5.36971 2.66675 3.77783 4.25862 3.77783 6.2223C3.77783 8.18598 5.36971 9.77786 7.33339 9.77786Z" fill="#FFAC33"/><path d="M16 22.3823C3.056 22.3823 0 26.5281 0 28.4445C0 30.361 1.592 32.0001 3.55556 32.0001H28.4444C30.408 32.0001 32 30.3548 32 28.4445C32 26.5343 28.944 22.3823 16 22.3823Z" fill="#FFE8B6"/><path d="M8.94499 19.9137C8.48632 21.1644 9.43832 21.9964 9.43832 21.9964C9.43832 21.9964 9.48988 21.3777 9.53876 20.5715C9.58854 19.7439 10.3201 19.1821 10.3459 18.8861C10.4303 17.8977 9.58676 17.1697 9.63032 17.5164C9.72276 18.2399 9.31299 18.9101 8.94499 19.9137ZM5.67299 22.1964C5.33965 22.8515 5.38765 24.415 5.38765 24.415C5.38765 24.415 6.18765 23.9448 6.22321 23.4604C6.25876 22.9759 6.23565 22.719 6.34588 22.4381C6.65876 21.6381 7.34499 21.6897 7.76365 20.5821C7.9121 20.191 7.59121 19.5128 7.49699 19.7341C7.13254 20.5866 6.00721 21.5412 5.67299 22.1964ZM11.0463 21.8968C10.9432 21.6106 11.1565 19.783 11.3379 20.0301C11.5192 20.2772 11.3325 21.0621 11.9281 21.7066C12.6721 22.511 12.569 23.4675 12.3645 23.0381C12.1592 22.6079 11.1494 22.183 11.0463 21.8968Z" fill="#F4900C"/><path d="M18.1485 24.7954V22.4914C16.1369 22.151 7.90495 21.071 2.4365 25.1012C2.28273 25.215 2.27295 25.4594 2.27295 25.5377C2.27295 26.5261 5.61784 25.2337 9.65962 25.6959C11.6018 25.9181 13.7601 26.0754 14.3334 25.6497C14.5272 25.5057 14.0418 25.0034 13.1316 24.551C13.5876 24.4337 14.0605 24.3288 14.6018 24.335C16.3645 24.351 17.5352 24.6123 18.1485 24.7954Z" fill="#FFAC33"/><path d="M14.6977 10.8214C15.9404 10.8214 16.9199 11.8303 16.9199 13.0747V18.2143C16.9199 18.8258 17.8088 19.3174 17.8088 19.5929V10.1698C17.8088 8.30317 19.4977 6.79028 21.3644 6.79028C23.2311 6.79028 24.9199 8.30317 24.9199 10.1698V21.8774C25.8088 21.6098 25.8088 21.1049 25.8088 20.4667V17.5805C25.8088 16.3361 26.7875 15.3272 28.0311 15.3272C29.2746 15.3272 30.2533 16.3361 30.2533 17.5805V21.5227C30.2533 22.7663 29.4177 23.7049 28.5013 24.233C27.8017 24.6374 25.8088 25.1343 24.9199 25.1636V27.8516C24.9199 29.6294 17.8088 29.6294 17.8088 27.8516V22.9032C16.9199 22.8365 14.9777 22.3663 14.3093 21.9805C13.3937 21.4525 12.4746 20.5147 12.4746 19.2694V13.0738C12.4755 11.8303 13.4524 10.8214 14.6977 10.8214Z" fill="#77B255"/><path d="M28.8892 24.3395C29.2005 24.3395 29.4528 24.0872 29.4528 23.776C29.4528 23.4647 29.2005 23.2124 28.8892 23.2124C28.578 23.2124 28.3257 23.4647 28.3257 23.776C28.3257 24.0872 28.578 24.3395 28.8892 24.3395Z" fill="#3E721D"/><path d="M26.6368 20.3964C26.948 20.3964 27.2004 20.1441 27.2004 19.8328C27.2004 19.5216 26.948 19.2693 26.6368 19.2693C26.3256 19.2693 26.0732 19.5216 26.0732 19.8328C26.0732 20.1441 26.3256 20.3964 26.6368 20.3964Z" fill="#3E721D"/><path d="M30.5787 19.2702C30.8899 19.2702 31.1422 19.0179 31.1422 18.7066C31.1422 18.3954 30.8899 18.1431 30.5787 18.1431C30.2675 18.1431 30.0151 18.3954 30.0151 18.7066C30.0151 19.0179 30.2675 19.2702 30.5787 19.2702Z" fill="#3E721D"/><path d="M15.3717 22.6496C15.6829 22.6496 15.9352 22.3973 15.9352 22.086C15.9352 21.7748 15.6829 21.5225 15.3717 21.5225C15.0604 21.5225 14.8081 21.7748 14.8081 22.086C14.8081 22.3973 15.0604 22.6496 15.3717 22.6496Z" fill="#3E721D"/><path d="M13.6822 18.144C13.9935 18.144 14.2458 17.8916 14.2458 17.5804C14.2458 17.2692 13.9935 17.0168 13.6822 17.0168C13.371 17.0168 13.1187 17.2692 13.1187 17.5804C13.1187 17.8916 13.371 18.144 13.6822 18.144Z" fill="#3E721D"/><path d="M15.9351 15.3278C16.2464 15.3278 16.4987 15.0755 16.4987 14.7642C16.4987 14.453 16.2464 14.2007 15.9351 14.2007C15.6239 14.2007 15.3716 14.453 15.3716 14.7642C15.3716 15.0755 15.6239 15.3278 15.9351 15.3278Z" fill="#3E721D"/><path d="M12.5557 13.6381C12.867 13.6381 13.1193 13.3858 13.1193 13.0745C13.1193 12.7633 12.867 12.511 12.5557 12.511C12.2445 12.511 11.9922 12.7633 11.9922 13.0745C11.9922 13.3858 12.2445 13.6381 12.5557 13.6381Z" fill="#3E721D"/><path d="M19.314 26.9181C19.6253 26.9181 19.8776 26.6658 19.8776 26.3546C19.8776 26.0433 19.6253 25.791 19.314 25.791C19.0028 25.791 18.7505 26.0433 18.7505 26.3546C18.7505 26.6658 19.0028 26.9181 19.314 26.9181Z" fill="#3E721D"/><path d="M24.3824 23.7758C24.6936 23.7758 24.946 23.5235 24.946 23.2122C24.946 22.901 24.6936 22.6487 24.3824 22.6487C24.0712 22.6487 23.8188 22.901 23.8188 23.2122C23.8188 23.5235 24.0712 23.7758 24.3824 23.7758Z" fill="#3E721D"/><path d="M20.441 20.3964C20.7522 20.3964 21.0046 20.1441 21.0046 19.8328C21.0046 19.5216 20.7522 19.2693 20.441 19.2693C20.1298 19.2693 19.8774 19.5216 19.8774 19.8328C19.8774 20.1441 20.1298 20.3964 20.441 20.3964Z" fill="#3E721D"/><path d="M23.8204 18.144C24.1316 18.144 24.3839 17.8916 24.3839 17.5804C24.3839 17.2692 24.1316 17.0168 23.8204 17.0168C23.5091 17.0168 23.2568 17.2692 23.2568 17.5804C23.2568 17.8916 23.5091 18.144 23.8204 18.144Z" fill="#3E721D"/><path d="M19.8775 14.2016C20.1888 14.2016 20.4411 13.9493 20.4411 13.638C20.4411 13.3268 20.1888 13.0745 19.8775 13.0745C19.5663 13.0745 19.314 13.3268 19.314 13.638C19.314 13.9493 19.5663 14.2016 19.8775 14.2016Z" fill="#3E721D"/><path d="M24.9459 12.5119C25.2571 12.5119 25.5094 12.2596 25.5094 11.9483C25.5094 11.6371 25.2571 11.3848 24.9459 11.3848C24.6346 11.3848 24.3823 11.6371 24.3823 11.9483C24.3823 12.2596 24.6346 12.5119 24.9459 12.5119Z" fill="#3E721D"/><path d="M18.7506 9.04435C19.0618 9.04435 19.3141 8.79204 19.3141 8.48079C19.3141 8.16955 19.0618 7.91724 18.7506 7.91724C18.4393 7.91724 18.187 8.16955 18.187 8.48079C18.187 8.79204 18.4393 9.04435 18.7506 9.04435Z" fill="#3E721D"/><path d="M13.1211 24.5475C13.1211 24.5475 12.1185 24.2302 11.5353 24.1467C10.9522 24.0631 13.8358 23.9058 15.1851 24.3458C13.8358 24.3244 13.1211 24.5475 13.1211 24.5475Z" fill="#F4900C"/></g><defs><clipPath id="clip0_914_3516"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['palette']      = '<svg id="palette" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M16 2.7937C7.16356 2.7937 0 8.93414 0 16.5075C0 17.455 0.112 18.3804 0.326222 19.2737C1.90756 21.9946 3.00178 20.2773 8 17.7777C13.0907 15.2319 8 21.3333 6.22222 24.8888C5.67556 25.9821 5.97156 26.9075 6.72 27.6657C9.33867 29.2693 12.5369 30.2221 16 30.2221C24.8364 30.2221 32 24.0826 32 16.5075C32 8.93414 24.8364 2.7937 16 2.7937ZM18.5324 24.5244C18.1813 25.7208 16.3458 26.2346 14.432 25.6719C12.5182 25.1101 11.2516 23.6861 11.6027 22.4888C11.9538 21.2924 13.7893 20.7786 15.7031 21.3421C17.6169 21.903 18.8836 23.327 18.5324 24.5244Z" fill="#D99E82"/><path d="M8.88883 12.4444C10.3616 12.4444 11.5555 11.2505 11.5555 9.77775C11.5555 8.30499 10.3616 7.11108 8.88883 7.11108C7.41608 7.11108 6.22217 8.30499 6.22217 9.77775C6.22217 11.2505 7.41608 12.4444 8.88883 12.4444Z" fill="#5C913B"/><path d="M17.778 10.6666C19.2508 10.6666 20.4447 9.47268 20.4447 7.99992C20.4447 6.52716 19.2508 5.33325 17.778 5.33325C16.3052 5.33325 15.1113 6.52716 15.1113 7.99992C15.1113 9.47268 16.3052 10.6666 17.778 10.6666Z" fill="#226699"/><path d="M25.778 16.0001C27.2508 16.0001 28.4447 14.8062 28.4447 13.3334C28.4447 11.8607 27.2508 10.6667 25.778 10.6667C24.3052 10.6667 23.1113 11.8607 23.1113 13.3334C23.1113 14.8062 24.3052 16.0001 25.778 16.0001Z" fill="#DD2E44"/><path d="M24.8888 24.0001C26.3616 24.0001 27.5555 22.8062 27.5555 21.3334C27.5555 19.8607 26.3616 18.6667 24.8888 18.6667C23.4161 18.6667 22.2222 19.8607 22.2222 21.3334C22.2222 22.8062 23.4161 24.0001 24.8888 24.0001Z" fill="#FFCC4D"/></svg>';
$config->ai->miniPrograms->iconList['airplane']     = '<svg id="airplane" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3540)"><path d="M26.6665 21.1804C26.319 21.5288 25.7572 21.5288 25.4097 21.1804L24.1528 19.9235C23.8043 19.5759 23.8043 19.0133 24.1528 18.6666L26.6665 16.1528C27.0141 15.8053 27.5759 15.8053 27.9234 16.1528L29.1803 17.4097C29.5288 17.7573 29.5288 18.3199 29.1803 18.6666L26.6665 21.1804ZM13.3332 7.84706C12.9857 8.1955 12.4239 8.1955 12.0763 7.84706L10.8194 6.59017C10.471 6.24262 10.471 5.68084 10.8194 5.33328L13.3332 2.8195C13.6808 2.47195 14.2425 2.47195 14.5901 2.8195L15.847 4.07639C16.1954 4.42395 16.1954 4.98573 15.847 5.33328L13.3332 7.84706Z" fill="#66757F"/><path d="M1.77794 19.5555C3.55571 19.5555 11.5557 20.4444 11.5557 20.4444C11.5557 20.4444 12.4446 28.4444 12.4446 30.2222C12.4446 31.9999 10.6668 31.9999 9.77794 31.111C8.88905 30.2222 6.22238 25.7777 6.22238 25.7777C6.22238 25.7777 1.77794 23.111 0.889046 22.2222C0.000157356 21.3333 0.000157356 19.5555 1.77794 19.5555ZM3.55571 5.36793C6.22238 5.33326 25.7779 6.22215 25.7779 6.22215C25.7779 6.22215 26.5993 25.7777 26.633 28.4444C26.6668 31.111 24.177 32.0017 23.2002 28.4453C22.2233 24.8888 18.6668 13.3333 18.6668 13.3333C18.6668 13.3333 6.26238 9.40704 3.55127 8.79815C0.000157237 7.99993 0.888157 5.40171 3.55571 5.36793Z" fill="#55ACEE"/><path d="M23.9998 2.66678C25.7776 0.888999 30.222 0.000109673 31.1109 0.888999C31.9998 1.77789 31.1109 6.22233 29.3331 8.00011C27.5554 9.77789 12.4443 24.0001 12.4443 24.0001C12.4443 24.0001 6.66648 28.0001 5.33314 26.6668C3.99981 25.3334 7.99981 19.5557 7.99981 19.5557C7.99981 19.5557 22.222 4.44455 23.9998 2.66678Z" fill="#CCD6DD"/><path d="M12.4444 19.5556C12.4444 19.5556 12.8888 20.0001 8.88882 24.0001C4.88882 28.0001 4.44438 27.5556 4.44438 27.5556C4.44438 27.5556 3.99994 27.1112 7.99994 23.1112C11.9999 19.1112 12.4444 19.5556 12.4444 19.5556ZM25.7777 3.55564C27.2506 3.55564 28.4444 4.74941 28.4444 6.2223H29.1599C29.2613 5.9423 29.3333 5.64897 29.3333 5.33341C29.3333 3.86053 28.1395 2.66675 26.6666 2.66675C26.351 2.66675 26.0577 2.73875 25.7777 2.84008V3.55564Z" fill="#66757F"/></g><defs><clipPath id="clip0_914_3540"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['pushpin']      = '<svg id="pushpin" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3509)"><path d="M21.023 20.7084L11.2905 10.9759L19.6336 4.02393L27.9759 12.3661L21.023 20.7084Z" fill="#BE1931"/><path d="M30.7554 12.3662C29.2203 13.9031 26.7305 13.9031 25.1954 12.3662L19.6336 6.80531C18.0967 5.2702 18.0967 2.77864 19.6336 1.24264C21.1678 -0.292469 23.6585 -0.292469 25.1954 1.24264L30.7554 6.80531C32.2914 8.34042 32.2914 10.8311 30.7554 12.3662Z" fill="#DD2E44"/><path d="M12.4444 15.8428C12.4444 15.8428 -0.527182 31.137 0.16704 31.8339C0.862151 32.5299 16.1573 19.5557 16.1573 19.5557L12.4444 15.8428Z" fill="#99AAB5"/><path d="M22.4133 24.881C20.8791 26.4179 18.3884 26.4179 16.8507 24.881L7.11911 15.1476C5.584 13.6116 5.584 11.1227 7.11911 9.58675C8.65511 8.04986 11.1458 8.04986 12.6818 9.58675L22.4133 19.3192C23.9493 20.8561 23.9493 23.3441 22.4133 24.881Z" fill="#DD2E44"/></g><defs><clipPath id="clip0_914_3509"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['shoppingcart'] = '<svg id="shoppingcart" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M27.5556 19.5556H9.77778L8 8.88892H29.3333L27.5556 19.5556Z" fill="#CCD6DD"/><path d="M29.3192 24.0001H9.76361C8.79117 24.0001 8.00005 23.2081 8.00005 22.2365C8.00005 21.2649 8.80539 20.4445 9.77783 20.4445L9.78405 20.4436L9.79117 20.4445H27.5556C27.9903 20.4445 28.3609 20.1298 28.4321 19.7014L30.2098 9.03472C30.2534 8.77694 30.1805 8.51383 30.0107 8.31383C29.8427 8.11472 29.5947 8.00005 29.3334 8.00005H8.72628L7.80183 2.51917C7.73161 2.09872 7.37161 1.81517 6.9645 1.79561C6.95028 1.79294 6.9405 1.77783 6.92628 1.77783H2.66672C2.17605 1.77783 1.77783 2.17605 1.77783 2.66672C1.77783 3.15739 2.17605 3.55561 2.66672 3.55561H6.17428L8.75472 18.8587C7.29517 19.2969 6.22228 20.6365 6.22228 22.2365C6.22228 24.1894 7.81161 25.7778 9.76361 25.7778H29.3192C29.8107 25.7778 30.2081 25.3805 30.2081 24.8889C30.2081 24.3974 29.8107 24.0001 29.3192 24.0001ZM27.3956 15.1112H24.4561L24.6987 13.3334H27.6907L27.3956 15.1112ZM22.6614 15.1112H19.5556V13.3334H22.9041L22.6614 15.1112ZM17.7778 15.1112H14.6721L14.4294 13.3334H17.7778V15.1112ZM12.8783 15.1112H9.93872L9.64272 13.3334H12.6356L12.8783 15.1112ZM10.5307 18.6667L10.2347 16.8889H13.1209L13.3636 18.6667H10.5307ZM15.1583 18.6667L14.9156 16.8889H17.7778V18.6667H15.1583ZM19.5556 18.6667V16.8889H22.4178L22.1752 18.6667H19.5556ZM23.9707 18.6667L24.2134 16.8889H27.0996L26.8036 18.6667H23.9707ZM28.2836 9.77783L27.9876 11.5556H24.9423L25.1849 9.77783H28.2836ZM23.3903 9.77783L23.1476 11.5556H19.5556V9.77783H23.3903ZM17.7778 9.77783V11.5556H14.1858L13.9432 9.77783H17.7778ZM12.1485 9.77783L12.3912 11.5556H9.34494L9.04894 9.77783H12.1485Z" fill="#66757F"/><path d="M12.4445 30.2222C13.9173 30.2222 15.1112 29.0283 15.1112 27.5556C15.1112 26.0828 13.9173 24.8889 12.4445 24.8889C10.9717 24.8889 9.77783 26.0828 9.77783 27.5556C9.77783 29.0283 10.9717 30.2222 12.4445 30.2222Z" fill="#E1E8ED"/><path d="M12.4442 31.1111C10.4833 31.1111 8.88867 29.5164 8.88867 27.5556C8.88867 25.5947 10.4833 24 12.4442 24C14.4051 24 15.9998 25.5947 15.9998 27.5556C15.9998 29.5164 14.4051 31.1111 12.4442 31.1111ZM12.4442 25.7778C11.4638 25.7778 10.6664 26.5751 10.6664 27.5556C10.6664 28.536 11.4638 29.3333 12.4442 29.3333C13.4247 29.3333 14.222 28.536 14.222 27.5556C14.222 26.5751 13.4247 25.7778 12.4442 25.7778Z" fill="#292F33"/><path d="M24.8888 30.2222C26.3616 30.2222 27.5555 29.0283 27.5555 27.5556C27.5555 26.0828 26.3616 24.8889 24.8888 24.8889C23.4161 24.8889 22.2222 26.0828 22.2222 27.5556C22.2222 29.0283 23.4161 30.2222 24.8888 30.2222Z" fill="#E1E8ED"/><path d="M24.8891 31.1111C22.9282 31.1111 21.3335 29.5164 21.3335 27.5556C21.3335 25.5947 22.9282 24 24.8891 24C26.8499 24 28.4446 25.5947 28.4446 27.5556C28.4446 29.5164 26.8499 31.1111 24.8891 31.1111ZM24.8891 25.7778C23.9086 25.7778 23.1113 26.5751 23.1113 27.5556C23.1113 28.536 23.9086 29.3333 24.8891 29.3333C25.8695 29.3333 26.6668 28.536 26.6668 27.5556C26.6668 26.5751 25.8695 25.7778 24.8891 25.7778Z" fill="#292F33"/></svg>';
$config->ai->miniPrograms->iconList['gift']         = '<svg id="gift" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3496)"><path d="M29.3332 27.5556C29.3332 29.5111 27.7332 31.1111 25.7776 31.1111H6.22206C4.2665 31.1111 2.6665 29.5111 2.6665 27.5556V12.4445C2.6665 10.4889 4.2665 8.88892 6.22206 8.88892H25.7776C27.7332 8.88892 29.3332 10.4889 29.3332 12.4445V27.5556Z" fill="#FDD888"/><path d="M32 9.77772C32 11.7333 30.4 13.3333 28.4444 13.3333H3.55556C1.6 13.3333 0 11.7333 0 9.77772C0 7.82217 1.6 6.22217 3.55556 6.22217H28.4444C30.4 6.22217 32 7.82217 32 9.77772Z" fill="#FDD888"/><path d="M2.6665 13.3333H29.3332V15.111H2.6665V13.3333Z" fill="#FCAB40"/><path d="M16.8888 2.66675H15.111C13.6381 2.66675 12.4443 3.86053 12.4443 5.33341V31.1112H19.5554V5.33341C19.5554 3.86141 18.3617 2.66675 16.8888 2.66675Z" fill="#DA2F47"/><path d="M14.222 6.22228C15.1998 6.22228 15.3447 5.76362 14.5429 5.20273L8.56777 1.01962C7.766 0.458729 6.71444 0.694284 6.22911 1.54317L4.43711 4.67917C3.95177 5.52806 4.35533 6.22228 5.33311 6.22228H14.222ZM17.7776 6.22228C16.7998 6.22228 16.6549 5.76362 17.4567 5.20273L23.4327 1.01962C24.2336 0.458729 25.286 0.694284 25.7713 1.54317L27.5633 4.67828C28.0478 5.52806 27.6442 6.22228 26.6664 6.22228H17.7776Z" fill="#DA2F47"/></g><defs><clipPath id="clip0_914_3496"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['scientist']    = '<svg id="scientist" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3605)"><path d="M31.0589 32V28.0107C31.0589 25.0649 27.7833 23.1218 24.8366 23.1218H14.17C11.2251 23.1218 7.94775 25.0649 7.94775 28.0107V32H31.0589Z" fill="#CCD6DD"/><path d="M19.4552 3.62744C23.1032 3.62744 29.1859 5.45233 29.1859 13.3581C29.1859 21.2648 29.1859 23.0897 27.361 23.0897C25.5361 23.0897 23.1032 21.2648 19.4544 21.2648C15.8055 21.2648 13.4232 23.0897 11.5477 23.0897C9.5148 23.0897 9.7228 15.791 9.7228 13.3581C9.7228 5.45233 15.8055 3.62744 19.4552 3.62744Z" fill="#292F33"/><path d="M16.2402 25.3245C17.5433 26.2702 21.4545 26.2702 22.7576 25.3245V20.2898H16.2402V25.3245Z" fill="#F7DECE"/><path d="M16.2349 21.5021C17.1433 22.5297 18.2704 22.8079 19.4953 22.8079C20.7211 22.8079 21.8482 22.5306 22.7575 21.5021V18.8923H16.2349V21.5021Z" fill="#EEC2AD"/><path d="M12.1558 13.0925C12.1558 7.90668 15.4233 3.70312 19.4544 3.70312C23.4838 3.70312 26.7513 7.90757 26.7513 13.0925C26.7513 18.2773 23.4838 22.2338 19.4544 22.2338C15.4242 22.2347 12.1558 18.2773 12.1558 13.0925Z" fill="#F7DECE"/><path d="M19.4553 20.049C18.0277 20.049 17.2802 19.3423 17.2002 19.2623C16.9619 19.0241 16.9619 18.6392 17.2002 18.4028C17.4366 18.1663 17.8153 18.1646 18.0544 18.3957C18.0855 18.425 18.5441 18.833 19.4553 18.833C20.3779 18.833 20.8375 18.4126 20.8562 18.3957C21.0988 18.1681 21.481 18.1752 21.7122 18.4134C21.9433 18.6517 21.9433 19.0277 21.7086 19.2623C21.6286 19.3423 20.8819 20.049 19.4553 20.049Z" fill="#DF1F32"/><path d="M10.3706 16.0106C10.352 15.1217 10.3315 15.8115 10.3315 15.5973C10.3315 12.5555 12.1564 16.0364 12.1564 13.8702C12.1564 11.7022 13.3724 11.4853 14.5884 10.2693C15.1973 9.66128 16.4133 8.46839 16.4133 8.46839C16.4133 8.46839 19.4542 10.3057 21.8871 10.3057C24.3191 10.3057 26.7529 11.5279 26.7529 13.9608C26.7529 16.3928 28.5777 12.5528 28.5777 15.5937C28.5777 15.8106 28.5582 15.1217 28.5422 16.0106H29.1813C29.1866 14.2328 29.1866 14.3004 29.1866 13.1644C29.1866 5.25772 23.1049 2.31372 19.4551 2.31372C15.8071 2.31372 9.72441 5.20883 9.72441 13.1155C9.72441 13.8204 9.70664 14.2328 9.73152 16.0106H10.3706Z" fill="#292F33"/><path d="M13.6765 13.2861C13.6765 14.5733 13.024 15.6168 12.2196 15.6168C11.4151 15.6168 10.7627 14.5733 10.7627 13.2861C10.7627 11.999 11.4151 10.9546 12.2196 10.9546C13.024 10.9546 13.6765 11.999 13.6765 13.2861ZM28.2436 13.2861C28.2436 14.5733 27.592 15.6168 26.7867 15.6168C25.9823 15.6168 25.3298 14.5733 25.3298 13.2861C25.3298 11.999 25.9814 10.9546 26.7867 10.9546C27.592 10.9546 28.2436 11.999 28.2436 13.2861Z" fill="#F7DECE"/><path d="M16.4888 15.0204C16.0755 15.0204 15.7368 14.6817 15.7368 14.2675V13.5164C15.7368 13.1031 16.0755 12.7644 16.4888 12.7644C16.903 12.7644 17.2417 13.1031 17.2417 13.5164V14.2675C17.2408 14.6826 16.903 15.0204 16.4888 15.0204ZM22.5021 15.0204C22.0888 15.0204 21.7501 14.6817 21.7501 14.2675V13.5164C21.7501 13.1031 22.0888 12.7644 22.5021 12.7644C22.9155 12.7644 23.2541 13.1031 23.2541 13.5164V14.2675C23.2533 14.6826 22.9146 15.0204 22.5021 15.0204Z" fill="#662113"/><path d="M20.2464 17.344H18.7442C18.5371 17.344 18.3682 17.176 18.3682 16.9671V16.832C18.3682 16.624 18.5362 16.4551 18.7442 16.4551H20.2464C20.4535 16.4551 20.6233 16.624 20.6233 16.832V16.9671C20.6233 17.1751 20.4544 17.344 20.2464 17.344Z" fill="#C1694F"/><path d="M16.8891 32.0001L15.9478 23.8054C15.9478 23.8054 17.2011 25.2676 19.5033 25.2676C21.8055 25.2676 23.2535 23.8054 23.2535 23.8054L22.1673 32.0001H16.8891Z" fill="#66757F"/><path d="M15.9474 22.4443C16.4514 22.9474 18.5421 31.9999 18.5421 31.9999H15.7367L14.2221 29.7226L15.7367 27.2026L13.9438 26.639L14.1696 23.1217C14.1696 23.1217 15.7065 22.2034 15.9474 22.4443ZM23.0532 22.4443C22.5492 22.9474 20.4585 31.9999 20.4585 31.9999H23.2638L24.7785 29.7226L23.2638 27.2026L25.0567 26.639L24.831 23.1217C24.831 23.1217 23.2932 22.2034 23.0532 22.4443Z" fill="#F5F8FA"/><path opacity="0.4" d="M13.1138 11.3333H26.0027V15.9999H13.1138V11.3333Z" fill="white"/><path d="M25.7777 10.6667H13.3332C12.4443 10.6667 12.4443 11.5556 12.4443 11.5556V15.1112C12.4443 16.4099 14.5181 16.889 15.9999 16.889C17.4817 16.889 18.3101 16.0001 19.5554 16.0001C20.8008 16.0001 21.6292 16.889 23.111 16.889C24.5928 16.889 26.6666 16.4099 26.6666 15.1112V11.5556C26.6666 10.6659 25.7777 10.6667 25.7777 10.6667ZM25.7777 14.2223C25.7777 15.4001 25.0203 16.0001 23.111 16.0001C21.743 16.0001 20.6186 15.1112 19.5554 15.1112C18.4923 15.1112 17.3679 16.0001 15.9999 16.0001C14.0906 16.0001 13.3332 15.4001 13.3332 14.2223V11.5556H25.7777V14.2223Z" fill="#F5F8FA"/><path d="M6.22238 10.6667C6.7133 10.6667 7.11127 10.2687 7.11127 9.7778C7.11127 9.28689 6.7133 8.88892 6.22238 8.88892C5.73147 8.88892 5.3335 9.28689 5.3335 9.7778C5.3335 10.2687 5.73147 10.6667 6.22238 10.6667Z" fill="#9266CC"/><path d="M8.00022 15.111C8.49114 15.111 8.88911 14.7131 8.88911 14.2221C8.88911 13.7312 8.49114 13.3333 8.00022 13.3333C7.5093 13.3333 7.11133 13.7312 7.11133 14.2221C7.11133 14.7131 7.5093 15.111 8.00022 15.111Z" fill="#9266CC"/><path d="M4.889 14.2223C5.62538 14.2223 6.22233 13.6254 6.22233 12.889C6.22233 12.1526 5.62538 11.5557 4.889 11.5557C4.15262 11.5557 3.55566 12.1526 3.55566 12.889C3.55566 13.6254 4.15262 14.2223 4.889 14.2223Z" fill="#9266CC"/><path d="M8.88889 16H4.44444C4.44444 16 2.66667 16 2.66667 17.7778C2.66667 19.5556 4.44444 19.5556 4.44444 19.5556V24L0.888889 28.4444C0.104 29.4258 0 30.0631 0 30.2222C0 32 1.77778 32 1.77778 32H11.5556C11.5556 32 13.3333 32 13.3333 30.2222C13.3333 30.1031 13.4693 29.7253 12.4444 28.4444L8.88889 24V19.5556C8.88889 19.5556 10.6667 19.5556 10.6667 17.7778C10.6667 16 8.88889 16 8.88889 16Z" fill="#A8BCCC"/><path d="M8.00011 24.312V18.6667H8.889C9.28811 18.656 9.77789 18.4942 9.77789 17.7778C9.77789 17.064 9.29166 16.9005 8.88189 16.8889H4.44455C4.04455 16.8996 3.55566 17.0614 3.55566 17.7778C3.55566 18.4942 4.04455 18.656 4.45522 18.6667L5.32189 18.688L5.33344 24.312L3.64989 26.4169L6.66677 29.528L9.68366 26.4169L8.00011 24.312Z" fill="#E1E8ED"/><path d="M0.888184 30.2525C0.889072 30.9388 1.37796 31.1005 1.78863 31.1112H11.5557C11.9549 31.1005 12.4446 30.9388 12.4446 30.2223V30.1859L12.45 30.113C12.45 30.1103 12.4011 29.8134 11.7504 29.0001L9.68374 26.417H3.64996L1.58329 29.0001C0.944184 29.7992 0.888184 30.2481 0.888184 30.2525Z" fill="#9266CC"/></g><defs><clipPath id="clip0_914_3605"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['technologist'] = '<svg id="technologist" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3627)"><path d="M31.1111 32V25.7778C31.1111 22.8311 27.8356 20.8889 24.8889 20.8889H14.2222C11.2773 20.8889 8 22.8311 8 25.7778V32H31.1111Z" fill="#9266CC"/><path d="M19.5055 1.39478C23.1553 1.39478 29.2371 3.21966 29.2371 11.1263C29.2371 19.033 29.2371 20.8579 27.4122 20.8579C25.5864 20.8579 23.1544 19.033 19.5046 19.033C15.8558 19.033 13.4744 20.8579 11.598 20.8579C9.56509 20.8579 9.77309 13.5592 9.77309 11.1263C9.77487 3.21966 15.8566 1.39478 19.5055 1.39478Z" fill="#292F33"/><path d="M16.2915 20.9067C16.2915 22.2223 18.2222 22.6667 19.5555 22.6667C20.8888 22.6667 22.8088 22.2223 22.8088 20.9067V18.0579H16.2915V20.9067Z" fill="#F7DECE"/><path d="M16.2852 19.2702C17.1945 20.2968 18.3216 20.5751 19.5465 20.5751C20.7723 20.5751 21.8994 20.2977 22.8087 19.2702V16.6604H16.2852V19.2702Z" fill="#EEC2AD"/><path d="M12.208 10.8595C12.208 5.67377 15.4756 1.47021 19.5058 1.47021C23.536 1.47021 26.8045 5.67377 26.8045 10.8595C26.8045 16.0444 23.536 20.0027 19.5058 20.0027C15.4756 20.0027 12.208 16.0453 12.208 10.8595Z" fill="#F7DECE"/><path d="M19.5056 17.816C18.079 17.816 17.3314 17.1103 17.2514 17.0294C17.0132 16.792 17.0132 16.4072 17.2514 16.1698C17.4879 15.9343 17.8665 15.9325 18.1048 16.1636C18.1359 16.192 18.5963 16.6 19.5056 16.6C20.4292 16.6 20.8896 16.1796 20.9074 16.1627C21.1501 15.9352 21.5323 15.9423 21.7634 16.1805C21.9945 16.4196 21.9945 16.7947 21.7599 17.0294C21.6808 17.1103 20.9341 17.816 19.5056 17.816Z" fill="#DF1F32"/><path d="M10.4224 13.7777C10.4037 12.8888 10.3833 13.5786 10.3833 13.3644C10.3833 10.3226 12.2082 13.8035 12.2082 11.6373C12.2082 9.46926 13.4242 9.25237 14.6402 8.03637C15.2491 7.42748 16.4651 6.23548 16.4651 6.23548C16.4651 6.23548 19.5059 8.07281 21.9388 8.07281C24.3708 8.07281 26.8046 9.29503 26.8046 11.7279C26.8046 14.1608 28.6295 10.3199 28.6295 13.3608C28.6295 13.5777 28.6099 12.8888 28.5939 13.7777H29.2322C29.2384 11.9999 29.2384 12.0675 29.2384 10.9315C29.2384 3.02481 23.1557 0.0808105 19.5068 0.0808105C15.8579 0.0808105 9.77617 2.97592 9.77617 10.8826C9.77617 11.5875 9.75839 11.9999 9.78328 13.7777H10.4224Z" fill="#292F33"/><path d="M16.5406 12.7876C16.1272 12.7876 15.7886 12.4489 15.7886 12.0356V11.2845C15.7886 10.8711 16.1272 10.5325 16.5406 10.5325C16.9539 10.5325 17.2935 10.8711 17.2935 11.2845V12.0356C17.2935 12.4489 16.9539 12.7876 16.5406 12.7876ZM22.5539 12.7876C22.1406 12.7876 21.8019 12.4489 21.8019 12.0356V11.2845C21.8019 10.8711 22.1406 10.5325 22.5539 10.5325C22.9672 10.5325 23.3059 10.8711 23.3059 11.2845V12.0356C23.3059 12.4489 22.9672 12.7876 22.5539 12.7876Z" fill="#662113"/><path d="M20.2995 15.1111H18.7964C18.5893 15.1111 18.4204 14.9422 18.4204 14.7351V14.5991C18.4204 14.3919 18.5884 14.2222 18.7964 14.2222H20.2995C20.5057 14.2222 20.6755 14.3911 20.6755 14.5991V14.7351C20.6755 14.9422 20.5057 15.1111 20.2995 15.1111Z" fill="#C1694F"/><path d="M13.7282 11.9431C13.7282 13.2302 13.0758 14.2738 12.2713 14.2738C11.4669 14.2738 10.8145 13.2302 10.8145 11.9431C10.8145 10.656 11.4669 9.61157 12.2713 9.61157C13.0758 9.61068 13.7282 10.6551 13.7282 11.9431ZM28.2962 11.9431C28.2962 13.2302 27.6447 14.2738 26.8393 14.2738C26.0349 14.2738 25.3825 13.2302 25.3825 11.9431C25.3825 10.656 26.034 9.61157 26.8393 9.61157C27.6447 9.61068 28.2962 10.6551 28.2962 11.9431Z" fill="#F7DECE"/><path d="M29.3332 31.1111C29.3332 31.6026 28.9358 31.9999 28.4443 31.9999H19.5554C19.0638 31.9999 18.6665 31.6026 18.6665 31.1111C18.6665 30.6195 19.0638 30.2222 19.5554 30.2222H28.4443C28.9358 30.2222 29.3332 30.6195 29.3332 31.1111Z" fill="#E1E8ED"/><path d="M17.9909 19.5557H3.3411C1.98643 19.5557 0.249546 20.241 1.13843 22.6943L3.8691 30.2277C3.86999 30.2277 4.22199 32.0001 6.22199 32.0001H23.9998L20.4442 22.009C20.0549 20.8339 19.3464 19.5557 17.9909 19.5557Z" fill="#E1E8ED"/><path d="M17.1022 19.5557H2.45243C1.09776 19.5557 -0.639126 20.241 0.249763 22.6943L2.98043 30.2277C2.98132 30.2277 3.33332 32.0001 5.33332 32.0001H23.1111L19.5555 22.009C19.1662 20.8339 18.4578 19.5557 17.1022 19.5557Z" fill="#99AAB5"/><path d="M12.4613 26.0294C12.9271 27.4267 12.5502 28.8116 11.6178 29.1219C10.6871 29.433 9.55378 28.5521 9.088 27.1547C8.62222 25.7574 9 24.3725 9.93156 24.0623C10.8631 23.7521 11.9964 24.6321 12.4613 26.0294ZM16.8889 22.0001H2.66667C2.29867 22.0001 2 21.7014 2 21.3334C2 20.9654 2.29867 20.6667 2.66667 20.6667H16.8889C17.2569 20.6667 17.5556 20.9654 17.5556 21.3334C17.5556 21.7014 17.2569 22.0001 16.8889 22.0001Z" fill="#E1E8ED"/></g><defs><clipPath id="clip0_914_3627"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconCheck                = '<svg width="14" height="10" viewBox="0 0 14 10" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M5.613 9.4L1 4.92006L2.26167 3.69453L5.613 6.94985L11.7383 1L13 2.22553L5.613 9.4Z" fill="#22C98D" stroke="#22C98D" stroke-width="0.15"/></svg>';
$config->ai->miniPrograms->iconEdit                 = '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M5.78327 6.01523C5.78327 5.80353 5.95489 5.6319 6.1666 5.6319H11.3142C11.5259 5.6319 11.6976 5.46028 11.6976 5.24857C11.6976 5.03686 11.5259 4.86523 11.3142 4.86523H6.1666C5.53147 4.86523 5.0166 5.38011 5.0166 6.01523V13.6819C5.0166 14.317 5.53147 14.8319 6.1666 14.8319H13.8333C14.4684 14.8319 14.9833 14.317 14.9833 13.6819V8.53428C14.9833 8.32257 14.8116 8.15095 14.5999 8.15095C14.3882 8.15095 14.2166 8.32257 14.2166 8.53428V13.6819C14.2166 13.8936 14.045 14.0652 13.8333 14.0652H6.1666C5.95489 14.0652 5.78327 13.8936 5.78327 13.6819V6.01523Z" fill="#2E7FFF" /><path d="M14.9 5.55565C15.0515 5.40777 15.0545 5.16508 14.9066 5.01357C14.7587 4.86207 14.516 4.85912 14.3645 5.007L8.93315 10.3082C8.78165 10.456 8.7787 10.6987 8.92658 10.8502C9.07445 11.0018 9.31714 11.0047 9.46865 10.8568L14.9 5.55565Z" fill="#2E7FFF" /></svg>';

$config->ai->miniPrograms->themeList = array();
$config->ai->miniPrograms->themeList[] = array('#ffffff', '#e0e0e0');
$config->ai->miniPrograms->themeList[] = array('#e8e8e8', '#dedede');
$config->ai->miniPrograms->themeList[] = array('#e1d7f0', '#d1c1e8');
$config->ai->miniPrograms->themeList[] = array('#fbd8aa', '#f9c27b');
$config->ai->miniPrograms->themeList[] = array('#fee9e9', '#fcdddd');
$config->ai->miniPrograms->themeList[] = array('#edf3e8', '#d9eacb');
$config->ai->miniPrograms->themeList[] = array('#e9f1ff', '#dde9ff');
$config->ai->miniPrograms->themeList[] = array('#fff8df', '#fce8cf');

$config->ai->assistants = new stdclass();
$config->ai->assistants->iconList = array();
$config->ai->assistants->iconList['lifting'] = '<svg id="lifting" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 36"><path fill="#292F33" d="M18.528 3.81c-.731 0-1.421.173-2.037.472a2.975 2.975 0 0 0-3.488 2.928v5.1h.007c.078 2.748 2.326 4.954 5.093 4.954s5.015-2.206 5.093-4.954h.007V8.485a4.675 4.675 0 0 0-4.675-4.675"/><path fill="#F7DECE" d="M15.447 34.875h-1.02s-1.384-3.348-1.18-5.736l2.531.549c.56 1.564-.331 5.187-.331 5.187m4.885 0h1.02s1.384-3.348 1.18-5.736L20 29.688c-.559 1.564.332 5.187.332 5.187"/><path fill="#DD2E44" d="M13.452 35.149c.102-.243.316-.694.339-.955s.034-.354.238-.426c.345-.121 1.427-.087 1.613-.016s.188.263.214.424.113.424.226.64.406.697.26 1.034c-.061.14-.402.138-1.497.138s-1.408-.026-1.483-.118-.011-.477.09-.721m8.875 0c-.102-.243-.316-.694-.339-.955s-.034-.354-.238-.426c-.345-.121-1.427-.087-1.613-.016s-.188.263-.214.424-.113.424-.226.64-.406.697-.26 1.034c.061.14.402.138 1.497.138s1.408-.026 1.483-.118c.074-.092.011-.477-.09-.721"/><path fill="#F7DECE" d="M8.31 4.156c.011.127.814 1.525 1.266 2.625s.747 2.25.984 2.5c.476.499 1.926 1.474 2.911 2.937.985 1.464-1.977 2.58-2.611 1.588-.451-.706-1.309-2.368-2.097-3.759-.304-.54-.897-1.454-1.328-2.516-.406-1-.642-2.168-.702-2.312-.179-.425-.879-.977-.913-1.407 0 0 2.454-.084 2.49.344m19.159 0c-.011.127-.814 1.525-1.266 2.625s-.747 2.25-.984 2.5c-.476.499-1.926 1.474-2.911 2.937-.985 1.464 1.977 2.58 2.611 1.588.451-.706 1.309-2.368 2.097-3.759.304-.54.897-1.454 1.328-2.516.406-1 .642-2.168.702-2.312.178-.425.878-.977.912-1.406 0-.001-2.453-.085-2.489.343"/><path fill="#99AAB5" d="M36 3.5a.5.5 0 0 1-.5.5H.5a.5.5 0 0 1 0-1h35a.5.5 0 0 1 .5.5"/><path fill="#292F33" d="M34 0a1 1 0 0 0-1 1 1 1 0 1 0-2 0v5a1 1 0 1 0 2 0 1 1 0 1 0 2 0V1a1 1 0 0 0-1-1M4 0a1 1 0 0 0-1 1 1 1 0 1 0-2 0v5a1 1 0 1 0 2 0 1 1 0 1 0 2 0V1a1 1 0 0 0-1-1"/><path fill="#DD2E44" d="M24.918 13.806c-.625-.583-2.611-1.588-2.611-1.588-.709.401-1.237 1.188-1.465 1.571l-1.398.394h-2.89l-1.627-.406c-.231-.387-.755-1.162-1.458-1.559 0 0-1.986 1.004-2.611 1.588.406 1.039 1.543 2.428 1.543 2.428l.008-.001c.4.821.854 1.362.945 1.547.386.781.646 4.72.646 4.72l4 1.5 3.779-1.5s.26-3.939.643-4.719c.091-.185.545-.727.945-1.547l.008.001c0-.001 1.138-1.39 1.543-2.429"/><path fill="#F7DECE" d="M16.471 11.412v3.059a1.529 1.529 0 1 0 3.058 0v-3.059z"/><path fill="#292F33" d="M18.375 3.353c-.89 0-1.712.284-2.386.763a2.62 2.62 0 0 0-2.49 2.612c0 1.156.005 2.613 1.529 3.156a4.125 4.125 0 1 0 3.347-6.531"/><path fill="#F7DECE" d="M21.75 5.602h-7.5v4.5a3.75 3.75 0 1 0 7.5 0z"/><path fill="#292F33" d="m18 4-3.924 1.533v3.139c1.831 0 2.236-1.893 2.327-2.737.031.844.639 2.737 5.52 2.737V5.533z"/><path fill="#C1694F" d="M19.5 12.353h-3s0 .75 1.5.75 1.5-.75 1.5-.75"/><circle cx="16.125" cy="9.728" r=".375" fill="#662113"/><path fill="#662113" d="M20.25 9.728a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0"/><path fill="#C1694F" d="M17.25 10.853h1.5s0 .75-.75.75-.75-.75-.75-.75"/><g fill="#F7DECE"><path d="M27.096 4.363c-.33-.157-.476-.428-.377-.719l.003-.01c.099-.291.291-.346.738-.339 0 0 1.521.076 2.437.712 0 0-.199.304-.447.56l-.003.01c-.101.29-1.614.137-2.351-.214"/><path d="M27.843 3.47a.257.257 0 0 1-.188-.31l.087-.357c.033-.137.173-.221.31-.188s.221.173.188.31l-.087.357a.26.26 0 0 1-.31.188m-.445-.87a.315.315 0 0 0-.397.197l-.279.837c-.055.164.168-.068.332-.013a.314.314 0 0 0 .397-.196l.144-.427a.316.316 0 0 0-.197-.398"/><path d="M28.384 3.399a.257.257 0 0 1-.188-.31l.082-.334c.033-.137.173-.221.31-.188s.221.173.188.31l-.082.334a.26.26 0 0 1-.31.188"/><path d="M28.9 3.424a.257.257 0 0 1-.188-.31l.068-.277c.033-.137.173-.221.31-.188s.221.173.188.31l-.068.277a.26.26 0 0 1-.31.188"/><path d="M29.419 3.447a.257.257 0 0 1-.188-.31l.04-.162c.033-.137.173-.221.31-.188s.221.173.188.31l-.04.162a.257.257 0 0 1-.31.188"/></g><g fill="#F7DECE"><path d="M8.683 4.363c.33-.157.476-.428.377-.719l-.003-.01c-.1-.29-.292-.346-.738-.339 0 0-1.521.076-2.437.712 0 0 .199.304.447.56l.003.01c.1.29 1.614.137 2.351-.214"/><path d="M7.936 3.47a.257.257 0 0 0 .188-.31l-.088-.357a.257.257 0 0 0-.31-.188.257.257 0 0 0-.187.31l.087.357a.26.26 0 0 0 .31.188m.445-.87a.315.315 0 0 1 .397.197l.279.837c.055.164-.168-.068-.332-.013a.314.314 0 0 1-.397-.196l-.144-.427a.315.315 0 0 1 .197-.398"/><path d="M7.395 3.399a.257.257 0 0 0 .188-.31l-.082-.334a.257.257 0 0 0-.31-.188.26.26 0 0 0-.188.31l.082.334a.26.26 0 0 0 .31.188"/><path d="M6.879 3.424a.26.26 0 0 0 .188-.31l-.068-.277a.257.257 0 0 0-.309-.188.257.257 0 0 0-.188.31l.068.277a.256.256 0 0 0 .309.188"/><path d="M6.36 3.447a.257.257 0 0 0 .188-.31l-.04-.162a.257.257 0 0 0-.31-.188.26.26 0 0 0-.187.31l.04.162a.255.255 0 0 0 .309.188"/></g><path fill="#DD2E44" d="M21.779 24.5 18 23l-4 1.5s-.94 1.766-.94 5.188h2.719c.917-.979 1.25-3.604 1.25-3.604h1.721s.333 2.625 1.25 3.604h2.719c0-3.422-.94-5.188-.94-5.188"/><path fill="#C1694F" d="M14 22.5h7.779v2H14z"/><path fill="#14171A" d="M19 22.399h.65v2.209H19z"/><circle cx="18.5" cy="23.458" r=".167" fill="#14171A"/><path fill="#14171A" d="M18.021 23.458a.167.167 0 0 1-.334 0 .167.167 0 0 1 .334 0"/><circle cx="17.208" cy="23.458" r=".167" fill="#14171A"/><circle cx="16.562" cy="23.458" r=".167" fill="#14171A"/><circle cx="15.917" cy="23.458" r=".167" fill="#14171A"/><circle cx="15.271" cy="23.458" r=".167" fill="#14171A"/><circle cx="14.625" cy="23.458" r=".167" fill="#14171A"/><circle cx="17.208" cy="23.458" r=".167" fill="#14171A"/><circle cx="16.318" cy="23.458" r=".148" fill="#657786"/><circle cx="16.553" cy="23.458" r=".148" fill="#657786"/><path fill="#657786" d="M16.318 23.31h.235v.297h-.235z"/><path fill="#657786" d="M16.729 24.846h-.758v-2.698h.758v.35h-.408v1.998h.408z"/></svg>';
$config->ai->assistants->iconList['guard'] = '<svg id="guard" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 36"><path fill="#DD2E44" d="M29.192 36v-1a6 6 0 0 0-6-6H11.808a5 5 0 0 0-5 5v2z"/><path fill="#292F33" d="M9 18c0 4.971 4.029 5 9 5s9-.029 9-5c0-.153-4.563-.998-9-1-4.562-.002-9 .843-9 1"/><path fill="#F3D2A2" d="m14.587 29.169 3.414 1.493 3.415-1.493v-3.415h-6.829z"/><path fill="#E2C196" d="M14.587 27.558c1.038 1.173 2.011 1.467 3.411 1.467s2.379-.295 3.418-1.467v-3.414h-6.829z"/><path fill="#FFE51E" d="M20.76 9.97c-1.476-.478-4.95-.347-5.818.782-2.258.043-4.907 2.084-5.254 4.776-.344 2.665.422 3.902.695 5.905.309 2.27 1.585 2.996 2.605 3.3 1.468 1.939 3.028 1.856 5.648 1.856 5.116 0 7.553-3.423 7.769-9.238.13-3.517-1.934-6.18-5.645-7.381"/><path fill="#F3D2A2" d="M23.686 17.6c-.495-.685-1.129-1.237-2.518-1.433.521.239 1.02 1.064 1.086 1.52.065.456.13.825-.282.369-1.653-1.827-3.452-1.107-5.236-2.223-1.246-.779-1.625-1.641-1.625-1.641s-.152 1.151-2.041 2.323c-.548.34-1.201 1.097-1.563 2.214-.261.803-.18 1.52-.18 2.744 0 3.574 2.945 6.578 6.578 6.578s6.578-3.031 6.578-6.578c0-2.223-.233-3.092-.797-3.873"/><path fill="#C1694F" d="M18.636 23.3h-1.462a.364.364 0 1 1 0-.73h1.462a.364.364 0 1 1 0 .73"/><path fill="#662113" d="M14.981 20.742a.73.73 0 0 1-.731-.731v-.731a.73.73 0 1 1 1.462 0v.731a.73.73 0 0 1-.731.731m5.848 0a.73.73 0 0 1-.731-.731v-.731a.73.73 0 1 1 1.462 0v.731a.733.733 0 0 1-.731.731"/><path fill="#C1694F" d="M18.001 26.352c-2.112 0-2.76-.541-2.869-.65a.503.503 0 0 1 .692-.729c.04.028.553.374 2.177.374 1.687 0 2.175-.372 2.179-.376a.49.49 0 0 1 .7.011.514.514 0 0 1-.011.72c-.107.109-.756.65-2.868.65"/><path fill="#292F33" d="M27 18V6c0-3.3-2.7-6-6-6h-6c-3.3 0-6 2.7-6 6v12zM12.943 30.461l-4.34.737c-.253.043-.493-.144-.533-.416l-.146-.988c-.04-.272.134-.529.388-.572l4.34-.737c.253-.043.493.144.534.416l.146.988c.039.271-.135.529-.389.572m10.138 0 4.34.737c.253.043.493-.144.534-.416l.146-.988c.04-.272-.134-.529-.388-.572l-4.34-.737c-.253-.043-.493.144-.534.416l-.146.988c-.04.271.135.529.388.572"/><path fill="#99AAB5" d="M11.875 18s-.174 9.414 6.113 9.414S24.125 18 24.125 18H25s-.307 10.461-7 10.461S11 18 11 18z"/><path fill="#F5F8FA" d="M17.5 31h1v5h-1z"/><path fill="#292F33" d="M21.38 27.816C21.38 29.391 19.144 30 18 30s-3.38-.609-3.38-2.184c0 0-.62-.127-.62 1.184s1.888 3 4 3 4-1.689 4-3-.62-1.184-.62-1.184"/></svg>';
$config->ai->assistants->iconList['spy'] = '<svg id="spy" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 36"><path fill="#66757F" d="M33 36v-1a6 6 0 0 0-6-6H9a6 6 0 0 0-6 6v1z"/><path fill="#EF9645" d="M12 27.482C13.672 29.057 15.746 30 18 30s4.327-.944 6-2.518V26H12z"/><path fill="#66757F" d="M26.75 20.435c1.188.208 2.619.129 2.416.917-.479 1.854-2.604 1.167-2.979 1.188s.563-2.105.563-2.105"/><path fill="#292F33" d="M27.062 20.645c1.875.25 2.541.416 1.166.958-.772.305-2.243 4.803-3.331 4.118-1.087-.685 2.165-5.076 2.165-5.076"/><path fill="#66757F" d="M9.255 20.435c-1.188.208-2.619.129-2.416.917.479 1.854 2.604 1.167 2.979 1.188s-.563-2.105-.563-2.105"/><path fill="#292F33" d="M8.943 20.645c-1.875.25-2.541.416-1.166.958.772.305 2.243 4.803 3.331 4.118s-2.165-5.076-2.165-5.076m-.888-9.614c-1.953 0-2.305 3.164-.664 3.594 0 0-1.367 3.32 1.953 3.32-.547-1.68-1.562-4.414-.781-6.406m19.38-.508c1.953 0 2.305 3.164.664 3.594 0 0 1.367 3.32-1.953 3.32.547-1.68 1.562-4.414.781-6.406"/><ellipse cx="18" cy="15.5" fill="#F7DECE" rx="10" ry="12.5"/><path fill="#662113" d="M14 17a1 1 0 0 1-1-1v-1a1 1 0 0 1 2 0v1a1 1 0 0 1-1 1m8 0a1 1 0 0 1-1-1v-1a1 1 0 1 1 2 0v1a1 1 0 0 1-1 1"/><path fill="#C1694F" d="M19 20.5a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1 0-1h1a.5.5 0 0 1 .5.5"/><path fill="#292F33" fill-rule="evenodd" d="M7.657 14.788c.148.147.888.591 1.036 1.034s.445 2.954 1.333 3.693c.916.762 4.37.478 5.032.149 1.48-.738 1.662-2.798 1.924-3.842.148-.591 1.036-.591 1.036-.591s.888 0 1.036.591c.262 1.044.444 3.104 1.924 3.841.662.33 4.116.614 5.034-.147.887-.739 1.183-3.25 1.331-3.694.146-.443.888-.886 1.035-1.034.148-.148.148-.739 0-.887-.296-.295-3.788-.559-7.548-.148-.75.082-1.035.295-2.812.295s-2.062-.214-2.812-.295c-3.759-.411-7.252-.148-7.548.148-.149.148-.149.74-.001.887" clip-rule="evenodd"/><path fill="#66757F" d="M7.858 8.395S9.217-.506 13.79.023c3.512.406 4.89.825 7.833.097 1.947-.482 4.065 1.136 5.342 4.379a28 28 0 0 1 1.224 4.041s3.938-.385 4.165 1.732c.228 2.117-4.354 4.716-15.889 4.716C10 14.987 3.33 12.63 3.013 10.657s4.845-2.262 4.845-2.262"/><path fill="#292F33" d="M8.125 7.15s-.27 1.104-.406 1.871c-.136.768.226 1.296 2.705 1.824 3.287.7 10.679.692 15.058-.383 1.759-.432 2.886-.72 2.751-1.583-.167-1.068-.196-1.066-.541-2.208 0 0-1.477.502-3.427.96-2.66.624-9.964.911-13.481.144-1.874-.41-2.659-.625-2.659-.625m-.136 13.953c-.354.145 2.921 1.378 7.48 1.458 4.771.084 6.234.39 5.146 1.459-1.146 1.125-.852 2.894-.771 3.418s2.047 1.916 2.208 2.56-1.229 5.961-1.229 5.961l-8.729-.252c-2.565-8.844-2.883-8.501-4.105-13.604-.241-1.008 0-1 0-1"/><path fill="#66757F" d="M6.989 21.144c-.354.146 2.921 1.378 7.48 1.458 4.771.084 6.234.39 5.146 1.459-1.146 1.125-.664 2.894-.583 3.418s1.859 1.916 2.021 2.561c.16.644-1.231 5.96-1.231 5.96l-8.729-.252c-2.565-8.844-2.883-8.501-4.105-13.604-.24-1.008.001-1 .001-1"/><path fill="#292F33" d="M28.052 21.103c.354.145-2.921 1.378-7.479 1.458-4.771.084-6.234.39-5.146 1.459 1.146 1.125 2.976 2.892 2.896 3.416s-4.172 1.918-4.333 2.562c-.161.645 1.229 5.961 1.229 5.961l8.729-.252c2.565-8.844 2.883-8.501 4.104-13.604.241-1.008 0-1 0-1"/><path fill="#66757F" d="M28.958 21.103c.354.145-2.921 1.378-7.479 1.458-4.771.084-6.234.39-5.146 1.459 1.146 1.125 2.977 2.892 2.896 3.416s-4.172 1.918-4.333 2.562c-.161.645 1.229 5.961 1.229 5.961l8.657.01c2.565-8.844 2.955-8.763 4.177-13.866.24-1.008-.001-1-.001-1"/></svg>';
$config->ai->assistants->iconList['golfing'] = '<svg id="golfing" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 36"><path fill="#2A6797" d="M20.952 18.872c-.265 2.577-.003 7.809.241 8.497.247.686 2.206 3.499 2.674 4.202.407.61-2.035 2.397-2.526 1.87-.887-.95-3.271-4.407-3.466-4.959-.195-.554-.966-6.297-1.403-9.329z"/><path fill="#66757F" d="M12.115 3.532 9.502 2.113c-.449-.249.029-1.303.479-1.054l2.692 1.466z"/><path fill="#CCD6DD" d="M16.492 33.744c-.658-.864-4.719.256-6.118.957C9.44 35.17 9.717 36 9.717 36h7.033s.399-1.391-.258-2.256"/><path fill="#EEC2AD" d="M20.357 8.932c-2.148-1.12-5.023-2.745-7.273-5.713-.235-.31-2.122.944-1.969 1.156 2.125 2.938 4.438 5.5 11.075 7.398.069.02-.943-2.376-1.833-2.841"/><path fill="#4289C1" d="M22.66 30.437c.12-.038.249-.065.374-.097q-.287-.425-.588-.879-.176.054-.347.116a95 95 0 0 1-.802-1.253 7 7 0 0 1 .362-.093c-.23-.378-.403-.689-.466-.862-.004-.011-.008-.033-.012-.046-.112.03-.227.055-.335.09a15 15 0 0 1-.319-1.505c.152-.036.305-.072.464-.099a45 45 0 0 1-.065-.999 8 8 0 0 0-.544.106 25 25 0 0 1-.156-1.649q.31-.062.635-.096a55 55 0 0 1-.017-1.003c-.221.021-.44.045-.651.082-.001-.191.01-.466.021-.688.649-.842 1.058-1.939.713-3.468l-7.889.092s-1.107 9.026-1.107 9.857c0 .828.516 4.528.83 5.856.105.439 3.91.614 3.773-.354-.086-.599-.645-4.492-.554-4.948.086-.431.513-2.597 1.245-4.133l.064.448c.052-.059.108-.112.162-.168.055.507.123 1 .2 1.458q-.078.06-.153.123c.07.461.134.871.191 1.21.059-.066.124-.126.186-.189.124.529.481 1.331.553 1.45-.086.079-.166.165-.247.249.148.243.34.541.557.868q.113-.13.236-.251c.251.392.538.834.837 1.29-.073.07-.138.149-.207.222.199.282.4.562.596.827q.086-.096.177-.188c.427.649.831 1.259 1.131 1.71.237.051.611-.08.999-.304-.316-.475-.825-1.242-1.358-2.053q.273-.185.574-.338c.461.705.94 1.431 1.331 2.02.3-.234.561-.495.714-.733-.339-.509-.726-1.095-1.108-1.678m-4.093-4.858a26 26 0 0 1-.184-1.593c.27-.169.555-.319.86-.438.038.558.095 1.119.166 1.656a6.5 6.5 0 0 0-.842.375m.179 1.065c.256-.162.527-.308.817-.429.11.628.233 1.174.357 1.575a6 6 0 0 0-.695.393c-.041-.07-.347-.866-.479-1.539m1.851 3.684c-.304-.465-.593-.911-.84-1.297a6 6 0 0 1 .594-.337c.204.331.491.781.82 1.289q-.299.159-.574.345"/><path fill="#88C9F9" d="M19.198 22.592c.4-.332.798-.711 1.122-1.166-3.304.609-5.935-.062-7.598-.634l-.121 1.016c1.255.419 2.988.867 5.106.867.476-.001.977-.033 1.491-.083m-2.604 3.518c.104-.338.225-.678.354-1.01-1.907.06-3.494-.274-4.66-.605q-.06.523-.113 1.006c1.118.31 2.577.612 4.318.612zm-.61 2.984c-.016-.24-.02-.42-.005-.497.018-.091.055-.276.103-.5a15.4 15.4 0 0 1-4.128-.437 6 6 0 0 0-.024.383c0 .14.016.368.042.648.969.218 2.188.42 3.613.42.128-.001.268-.014.399-.017m-3.759 1.67c.048.343.1.69.152 1.028.628.08 1.348.144 2.162.144.548 0 1.138-.034 1.756-.104a99 99 0 0 1-.128-.994 15.5 15.5 0 0 1-3.942-.074"/><g fill="#55ACEE"><path d="M14.2 18.73c-.056.269-1.602 8.59-1.643 9.077a4 4 0 0 0-.018.431c.008.139.626 5.29.705 5.892.274.061.636.102 1.024.115-.075-.569-.72-5.897-.73-6.068q-.004-.076.004-.206c.025-.393 1.485-8.301 1.638-9.036z"/><path d="M16.691 18.454c-.001.014-.133 1.436-.312 2.322-.051.253-.123.534-.198.819a27 27 0 0 1-.28.972c-.25.814-.54 1.67-.815 2.472l-.001.004c-.124.361-.853 2.598-.889 3.001a2 2 0 0 0-.005.194c.011.176.641 5.411.719 6.004.363-.017.709-.062.99-.14-.075-.572-.7-5.734-.711-5.924-.001-.018.005-.052.007-.078.028-.313.895-2.911.924-2.997.276-.805.557-1.647.799-2.454q.153-.512.274-.989c.059-.234.122-.472.165-.686.188-.938.321-2.367.327-2.428zm2.706.599c0 .629-.265 1.913-.503 2.56-.045.121-.841 1.651-.985 1.979.359-.293.828-.617 1.298-1.008q.303-.25.59-.543c.065-.167.128-.359.187-.566.238-.832.413-1.886.413-2.422z"/></g><path fill="#F7DECE" d="M25.376 5.216a3.578 3.578 0 1 1-7.157.001 3.578 3.578 0 0 1 7.157-.001"/><path fill="#4289C1" d="M19.929 5.215c-1.71-1.278-2.587-3.85-1.95-4.525 1.196-1.268 3.688-.109 4.328.983.641 1.094-1.86 3.929-2.378 3.542"/><path fill="#77B255" d="M13.038 18.185s.196-6.405 3.264-8.772c2.289-1.768 6.143-.446 7.165 1.599 1.024 2.045-2.414 3.167-2.414 8.28 0 1.023-8.015.898-8.015-1.107"/><path fill="#F7DECE" d="M20.179 5.813c-.466 1.068-.788 1.977-.988 2.783.574.271 1.061 1.31 1.701 1.542 1.056.383 1.173-.277 1.197-.398.257-1.297.908-2.537 1.328-3.203.512-.809-2.646-2.084-3.238-.724"/><path fill="#50A5E6" d="M18.942 3.06c0 1.151 1.674 4.486 4.971 4.473 1.727-.007 2.037-1.91 2.028-3.172-.006-1.081-1.176-2.966-2.808-3.433s-4.191.679-4.191 2.132"/><path fill="#CCD6DD" d="M22.887 31.456c1.5-.255 1.286 1.386 1.247 1.974-.093 1.4-.37 2.57-1.362 2.57h-3.321s-.184-1.522 1.603-1.868c.353-.069-.312-2.312 1.833-2.676"/><path fill="#F7DECE" d="M13.63 8.191c-.717-.828-.977-1.983-.796-3.425a1.65 1.65 0 0 0 1.006-1.503c0-.913-.763-1.652-1.705-1.652-.94 0-1.704.739-1.704 1.652 0 .206.044.402.115.584-.005.007-.026.004-.028.014-.871 7.123 4.099 7.824 5.732 8.055.101.014 1.768-2.244 1.666-2.244-1.993 0-3.435-.498-4.286-1.481"/><path fill="#77B255" d="M14.445 8.385c-.384 1.283-1.605 2.723-1.605 2.723 1.765 1.579 3.844 1.719 3.844 1.719s1.818-2.049 2.159-3.28c-1.551.432-4.398-1.162-4.398-1.162"/><path fill="#66757F" d="M29.589 11.917c-.013-.006-.024-.007-.037-.012-.049-.036-.091-.076-.147-.107l-15.62-8.65c-.449-.249-.706.926-.257 1.175l14.883 8.24c-.436.748-.717 1.871-.827 2.339-.189.805 1.137 1.61 2.004 1.61.867.001 1.027-4.072.001-4.595"/></svg>';
$config->ai->assistants->iconList['astronaut'] = '<svg id="astronaut" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 36"><path fill="#E1E8ED" d="M36 36v-2a6 6 0 0 0-6-6H14a6 6 0 0 0-6 6v2z"/><path fill="#EA596E" d="M29.799 28.127c0 1.36-3.491 2.434-7.799 2.434s-7.799-1.06-7.799-2.42c0-.062.015-.141.029-.141h-.734l-.705.099.006 1.017c.114 2.405 4.186 3.392 9.203 3.392 4.996 0 9.054-1.009 9.2-3.414l.014-.974c0 .002-1.415-.055-1.415.007"/><ellipse cx="22" cy="28.07" fill="#BE1931" rx="9.214" ry="3.439"/><path fill="#292F33" d="M22 30.533c-4.307 0-7.799-1.103-7.799-2.463s3.492-2.463 7.799-2.463 7.799 1.103 7.799 2.463-3.492 2.463-7.799 2.463"/><path fill="#F7DECE" d="M17.64 27.937c1.744 1.267 2.848 1.511 4.36 1.511 1.511 0 2.616-.245 4.36-1.511v-3.811h-8.72z"/><path fill="#EEC2AD" d="M17.632 25.973c1.216 1.374 2.724 1.746 4.364 1.746s3.147-.372 4.364-1.746v-3.491h-8.728z"/><path fill="#292F33" d="M25.597 3.516c-1.925-.623-6.455-.453-7.588 1.019-2.944.057-6.398 2.718-6.851 6.228-.448 3.475.551 5.088.906 7.701.403 2.96 2.067 3.907 3.397 4.303 1.914 2.529 3.949 2.421 7.366 2.421 6.672 0 9.85-4.464 10.131-12.047.17-4.585-2.521-8.059-7.361-9.625"/><path fill="#F7DECE" d="M29.413 13.466c-.646-.894-1.472-1.614-3.284-1.868.68.311 1.331 1.387 1.416 1.982s.17 1.076-.368.481c-2.155-2.382-4.502-1.444-6.827-2.899-1.624-1.016-2.119-2.141-2.119-2.141s-.198 1.5-2.661 3.029c-.714.443-1.566 1.43-2.038 2.888-.34 1.048-.234 1.982-.234 3.578 0 4.66 3.841 8.578 8.578 8.578s8.578-3.953 8.578-8.578c-.001-2.898-.305-4.031-1.041-5.05"/><path fill="#C1694F" d="M22.827 20.9h-1.906a.477.477 0 1 1 0-.954h1.906a.477.477 0 1 1 0 .954"/><path fill="#662113" d="M18.062 17.564a.953.953 0 0 1-.953-.953v-.953a.953.953 0 0 1 1.906 0v.953a.953.953 0 0 1-.953.953m7.625 0a.953.953 0 0 1-.953-.953v-.953a.953.953 0 0 1 1.906 0v.953a.953.953 0 0 1-.953.953"/><path fill="#C1694F" d="M22 24.88c-2.754 0-3.6-.705-3.741-.848a.655.655 0 0 1 .902-.95c.052.037.721.487 2.839.487 2.2 0 2.836-.485 2.842-.49a.64.64 0 0 1 .913.015.67.67 0 0 1-.014.938c-.141.143-.987.848-3.741.848"/><path fill="#55ACEE" d="M33 33v3h3v-2c0-.341-.035-.674-.09-1z"/><path fill="#FFCC4D" d="M34 34h2v2h-2z"/><path fill="#E1E8ED" d="M24.004 36c-1.198-5.146-6.048-9-11.857-9S1.488 30.854.29 36z"/><path fill="#292F33" d="M22.669 36c-1.173-4.464-5.432-7.778-10.522-7.778S2.798 31.536 1.625 36z"/><path fill="#FFAC33" d="M21.637 36c-1.148-3.937-4.956-6.833-9.49-6.833S3.805 32.063 2.657 36z"/><path fill="#FFDC5D" d="m18.195 35.048.103-.063c.769-.468.928-1.538.301-2.182a8.4 8.4 0 0 0-1.566-1.267 8.2 8.2 0 0 0-1.785-.827c-.828-.273-1.711.233-1.866 1.091-.119.661.224 1.346.855 1.578a5.8 5.8 0 0 1 2.231 1.474c.443.472 1.174.533 1.727.196"/><path fill="#9266CC" d="m6.344 14.262-1.542-.571-.6-2.2a.667.667 0 0 0-1.286.001l-.6 2.2-1.542.571a.665.665 0 0 0 0 1.25l1.534.568.604 2.415a.667.667 0 0 0 1.294-.001l.604-2.415 1.534-.568a.665.665 0 0 0 0-1.25"/><path fill="#5DADEC" d="m11.28 4.634-2.61-.966-.966-2.61a1.104 1.104 0 0 0-2.07 0l-.966 2.61-2.61.966a1.104 1.104 0 0 0 0 2.07l2.61.966.966 2.61a1.103 1.103 0 0 0 2.07 0l.966-2.61 2.61-.966a1.104 1.104 0 0 0 0-2.07"/></svg>';
$config->ai->assistants->iconList['coding'] = '<svg id="coding" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 36"><path fill="#FA743E" d="M35 36v-5a6 6 0 0 0-6-6H13a6 6 0 0 0-6 6v5z"/><path fill="#F7DECE" d="M16.64 25.106c0 .894 2.36 1.993 4.36 1.993s4.359-1.099 4.359-1.992V21.29h-8.72z"/><path fill="#EEC2AD" d="M16.632 23.121c1.216 1.374 2.724 1.746 4.364 1.746s3.146-.373 4.363-1.746V19.63h-8.728v3.491z"/><path fill="#292F33" d="M24.731.531c-1.925-.623-6.455-.453-7.588 1.019-2.944.057-6.398 2.718-6.851 6.228-.448 3.475.551 5.088.906 7.701.403 2.96 2.067 3.907 3.397 4.303 1.914 2.529 3.949 2.421 7.366 2.421 6.672 0 9.85-4.464 10.131-12.047.17-4.585-2.521-8.059-7.361-9.625"/><path fill="#F7DECE" d="M28.547 10.481c-.646-.894-1.472-1.614-3.284-1.868.68.311 1.331 1.387 1.416 1.982s.17 1.076-.368.481c-2.155-2.382-4.502-1.444-6.827-2.899-1.624-1.016-2.119-2.141-2.119-2.141s-.198 1.5-2.661 3.029c-.714.443-1.566 1.43-2.038 2.888-.34 1.048-.234 1.982-.234 3.578 0 4.66 3.841 8.578 8.578 8.578s8.578-3.953 8.578-8.578c-.002-2.898-.305-4.031-1.041-5.05"/><path fill="#C1694F" d="M21.961 17.914h-1.906a.477.477 0 1 1 0-.954h1.906a.477.477 0 1 1 0 .954"/><path fill="#662113" d="M17.195 14.578a.953.953 0 0 1-.953-.953v-.953a.953.953 0 0 1 1.906 0v.953a.95.95 0 0 1-.953.953m7.626 0a.953.953 0 0 1-.953-.953v-.953a.953.953 0 0 1 1.906 0v.953a.953.953 0 0 1-.953.953"/><path fill="#C1694F" d="M21.134 21.894c-2.754 0-3.6-.705-3.741-.848a.655.655 0 0 1 .902-.95c.052.037.721.487 2.839.487 2.2 0 2.836-.485 2.842-.49a.64.64 0 0 1 .913.015.67.67 0 0 1-.014.938c-.142.143-.987.848-3.741.848"/><path fill="#E1E8ED" d="M33 35a1 1 0 0 1-1 1H22a1 1 0 1 1 0-2h10a1 1 0 0 1 1 1"/><path fill="#E1E8ED" d="M20.24 22H3.759c-1.524 0-3.478.771-2.478 3.531l3.072 8.475C4.354 34.006 4.75 36 7 36h20l-4-11.24c-.438-1.322-1.235-2.76-2.76-2.76"/><path fill="#99AAB5" d="M19.24 22H2.759c-1.524 0-3.478.771-2.478 3.531l3.072 8.475C3.354 34.006 3.75 36 6 36h20l-4-11.24c-.438-1.322-1.235-2.76-2.76-2.76"/><path fill="#E1E8ED" d="M14.019 29.283c.524 1.572.099 3.13-.949 3.479s-2.322-.641-2.846-2.213-.099-3.13.949-3.479 2.323.641 2.846 2.213M19 24.75H3a.75.75 0 0 1 0-1.5h16a.75.75 0 0 1 0 1.5"/></svg>';
$config->ai->assistants->iconList['surfing'] = '<svg id="surfing" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 36"><path fill="#4289C1" d="M36 5v27s0 4-4 4H4c-4 0-4-4-4-4v-5s25-2 36-22"/><path fill="#1C6399" d="M31.844 23.243s2.565-1.635 2.258-2.288c-.309-.654-11.778.99-17.528 2.954-8.627 2.947-13.144 7.522-12.526 8.828.617 1.306 7.602 1.953 16.228-.993 5.752-1.964 15.368-7.524 15.06-8.177-.309-.653-3.492-.324-3.492-.324"/><path fill="#A6D388" d="M31.474 22.747s2.65-1.619 2.349-2.291c-.303-.673-12.042.782-17.949 2.675C7.01 25.972 2.311 30.555 2.916 31.9s7.723 2.141 16.585-.699c5.91-1.893 15.833-7.383 15.532-8.055-.303-.673-3.559-.399-3.559-.399"/><path fill="#F5F8FA" d="M31.474 22.747s2.507-1.534 2.358-2.235L3.756 29.978c-.722.837-1.019 1.523-.84 1.922.156.348.755.657 1.7.878l30.395-9.566c.003-.02.029-.051.022-.066-.303-.673-3.559-.399-3.559-.399"/><path fill="#FFDC5D" d="M14.919 1.309c-1.46-.632-3.707.061-4.116 1.762-.572 2.374.726 4.444 2.239 4.331 1.586-.118 2.568-.436 3.263-2.042s.074-3.419-1.386-4.051"/><path fill="#FFDC5D" d="M15.871 5.765c2.237-2.457-2.957-2.383-2.957-2.383-.983.003-.362 1.661-.853 2.538-.337.607.985.979.985.979s.612.011.62.755v.007c.001.189-.026.413-.124.71-.489 1.472 1.477 2.449 1.965.975.193-.584.143-1.104.071-1.586l-.007-.043c-.109-.715-.253-1.344.3-1.952"/><path fill="#FFAC33" d="M16.763 1.884c-.697-1.012-3.117-1.965-4.713-.767-1.07-.222-1.517.787-1.445 1.379.057.473 1.209.633 1.469 1.535.209-.217.277-.674.242-.921.356.366.165 1.292 1.592 1.949 1.38.634 1.091 1.862 1.091 1.862s.749-.324 1.281-.9c1.019-1.101 1.251-3.022.483-4.137"/><path fill="#FFDC5D" d="M16.261 28.432c-.378-.1-.971-.58-1.154-.912-.661-1.197.171-3.476.19-4.777.005-.37-2.213-1.974-2.86-1.016s.991 4.719.812 6.193c-.04.326-.227.814-.126 1.015s.817.74 1.301.839c1.237.255 2.491-.342 2.644-.517.222-.254-.428-.725-.807-.825m7.51-3.222c-.334-.065-.85-.469-1.016-.753-.29-.498.157-3.642.127-4.946-.35-.234-2.393.926-2.393.926-.437 1.815.817 2.863.659 4.262-.032.284-.17.964-.071 1.132.099.169.752.594 1.178.652 1.088.148 2.141-.443 2.264-.604.178-.234-.414-.604-.748-.669m3.984-12.977c-.589-.235-1.348-.276-2.104-.386-1.198-.175-2.852-.765-3.529-1.086-.825-.495-2.577-1.661-3.012-1.948S18.093 8.128 17.375 8h-.156c.385.542.609 1.159.748 2.841 0 0 3.319 1.661 3.595 1.753 1.125.375 3.182.366 4.344.512.602.076 1.021-.014 1.499-.047.722-.049 1.38-.055 1.422-.371.05-.367-.595-.265-1.072-.455M10.999 8.402c-1.666.993-3.368 3.049-3.98 3.914-.36.283-.686.614-.897.736-.389.223-2.154 1.432-3.334 2.005-.354.166-1.458.438-1.992.781-.432.278-.845.262-.727.612.102.302.508.216 1.227.132s1.929-.289 2.325-.566c.8-.531 3.347-1.156 4.597-2.031.221-.155 2.385-2.163 2.781-2.741.543-1.515.282-2.556 0-2.842"/><path fill="#292F33" d="M23.042 19.417c-.229-.981-1.5-2.047-2.677-2.948s-2.375-1.438-2.375-1.438c.034-.487-.172-1.295-.089-2.016.099-.853.26-1.689.26-1.689s1.633.727 3.402 1.267c.302-.363.618-1.395.559-1.833-.903-.841-2.483-1.754-2.919-2.042s-.837-.637-1.828-.718h-1.639s-.099.856-.749.918S13.56 8 13.56 8l-1.748.167c-2.198.338-4 3.024-4.794 4.151-.36.283-.36.283-.526.447.927.602 2.128 1.035 2.128 1.035 1.188-1.024 2.078-1.535 2.474-2.113 0 0 .659 1.356.912 2.388S12.208 17 12.208 17s-.005 1.674.058 1.94c.088.372.353 1.449.353 1.884 0 0-.606 1.335-.302 2.484.403 1.529.885 3.468.927 4.008 1.412 0 1.667-.359 1.667-.359s.02-.839.134-1.778c.069-.572.269-1.544.269-2.393s.217-1.424.343-1.776.601-1.452.677-2.052c.02-.162.008-.374-.022-.6.534.292 1.493.792 2.084.954.849.232 1.494.595 1.718.79s.376.335.376.335-.201.557-.141 1.516c.055.877.693 1.658.8 2.703.893-.133 1.53-.499 1.53-.499s.079-1.336.098-1.916c.023-.706.412-2.193.265-2.824"/><path fill="#67757F" d="M7.192 13.168c.795-1.126 3.067-4.339 5.508-4.55 0 0 1.118 1.459 2.565 1.235s1.482-1.318 1.482-1.318l1.727.149a3.1 3.1 0 0 1 1.12.281 22 22 0 0 1-.391-.246c-.435-.287-.837-.638-1.828-.719h-1.639s-.309.699-.751.766S13.56 8 13.56 8l-1.748.167c-2.678.421-4.566 3.941-5.32 4.598.106.104.456.283.7.403"/><path fill="#67757F" d="M13.762 27.297c-.402-1.36-1.283-4.497-.45-6.056.075-.368-.23-1.357-.318-1.729-.063-.266-.103-2.438-.072-2.717 3.859-.123 5.068-1.763 5.068-1.763s-2.139 1.191-5.354.57c.174-1.719-1.134-4.337-1.134-4.337-.213-.025-.265.168-.408.424 0 0 .774 1.865.912 2.718.137.852.202 2.593.202 2.593s-.005 1.674.058 1.94c.088.372.353 1.449.353 1.884-.952 1.783-.099 2.98.625 6.492.169.008.336.008.518-.019m7.32-4.562c-.06-.958.024-1.639-.072-1.843s-.52-.455-.52-.455-.201.557-.141 1.516c.055.877.69 1.734.8 2.703.309-.046.406-.073.706-.161-.613-.261-.735-1.154-.773-1.76"/></svg>';
$config->ai->assistants->iconList['yoga'] = '<svg id="yoga" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 36"><path fill="#4289C1" d="M28.632 30.563c-.178-1.426-1.568-1.931-2.257-1.931-.884 0-2.992 1.106-3.375-.585l-.037-.183-9.91-.012-.053.184c-.375 1.708-2.492.596-3.378.596-.689 0-2.079.505-2.257 1.931C7.365 30.563 14.13 33 18 33c3.873 0 10.632-2.437 10.632-2.437"/><path fill="#F7DECE" d="M12.165 17.014a1 1 0 0 0-1.151.822l-.825 4.947q-.105.064-.217.135c-1.762 1.131-1.661 3.529-2.934 4.616-.171.146-.949.766-1.203 1.325-.336.738.22.444.045.695-.406.584-.414 1.478-.127 1.686l.373.1c.557.403 2.081-1.336 2.281-2.302.3-1.443 3.075-3.25 3.589-4.653.162-.444.224-.787.173-1.074l1.106-5.145c.091-.546-.566-1.062-1.11-1.152m17.922 12.598c-.175-.251.437-.016.101-.754-.255-.56-1.089-1.179-1.259-1.325-1.273-1.087-1.116-3.485-2.878-4.616a7 7 0 0 0-.243-.151l-.822-4.93a1 1 0 0 0-1.15-.822c-.545.091-1.235.606-1.145 1.151l1.151 5.222c-.028.272.036.592.184.998.513 1.402 3.289 3.209 3.589 4.653.201.967 1.725 2.706 2.281 2.302l.373-.1c.289-.21.225-1.044-.182-1.628"/><path fill="#F7DECE" d="M22.757 35.82c-1.04.089-2.02-.208-3 0-.475.03-.802 0-1.277-.416s-8.287-1.515-9.713-2.465c-.658-.439-1.662-1.54-1.396-2.465.263-.913 1.139-1.429 2.198-1.455 2.065-.051 6 2.941 8.851 4.04.518.2.948-.052 1.604.119.683.178 2.317-.555 3.149-.446 1.129.149 1.574.683 1.485 1.604-.094.974-.861 1.395-1.901 1.484"/><path fill="#EEC2AD" d="M22.757 35.82c-1.04.089-2.02-.208-3 0-.475.03-.802 0-1.277-.416s.889-2.399 1.545-2.228c.683.178 2.317-.555 3.149-.446 1.129.149 1.574.683 1.485 1.604-.095.976-.862 1.397-1.902 1.486m-11.561-2.614c.238-.624 1.188-.891 1.634-.95s1.188.208 1.693.416 1.118.234 1.504.085.668-.124.958 0c.078.033.423 0 .546-.067 0 0 1.79.616 1.136.824-.653.208-5.421.524-6.074.524s-1.397-.832-1.397-.832"/><path fill="#EEC2AD" d="M7.371 30.474c.006-.02.016-.037.022-.056.201.762.76 1.66 1.401 1.898.802.297 7.247 2.198 8.049 2.287s1.99.208 2.228.386.861.238 1.366.119 1.782.356 2.436.208 1.604-.445 1.782-1.247c.003-.015.007-.022.011-.034q.007.143-.007.302c-.094.975-.861 1.396-1.901 1.485s-2.02-.208-3 0c-.475.03-.802 0-1.277-.416s-8.287-1.515-9.713-2.465c-.659-.441-1.663-1.543-1.397-2.467"/><path fill="#F7DECE" d="M13.243 35.82c1.04.089 2.02-.208 3 0 .475.03.802 0 1.277-.416s8.287-1.515 9.713-2.465c.658-.439 1.662-1.54 1.396-2.465-.263-.913-1.139-1.429-2.198-1.455-2.065-.051-6 2.941-8.851 4.04-.518.2-.948-.052-1.604.119-.683.178-2.317-.555-3.149-.446-1.129.149-1.574.683-1.485 1.604.094.974.861 1.395 1.901 1.484"/><path fill="#292F33" d="M19 0a5.96 5.96 0 0 0-3.402 1.061C15.402 1.031 15.205 1 15 1a4 4 0 0 0-4 4v4a7 7 0 1 0 14 0V6.001A6 6 0 0 0 19 0"/><path fill="#9268CA" d="M22.543 15h-9.089c-2.562 0-2.912 4-2.912 4l2.458.632s.454 2.376.454 4.337S13 28 13 28s2.031.335 5 .335S23 28 23 28s-.487-2.071-.487-4.061.487-4.307.487-4.307L25.458 19s-.353-4-2.915-4"/><path fill="#F7DECE" d="M16 11v4a2 2 0 0 0 4 0v-4z"/><path fill="#EEC2AD" d="m20 11-4 .019V15s2 1 4 0z"/><path fill="#F7DECE" d="M16 3s-.011 3.285-3 3.894V9c0 2.762 2.238 5 5 5s5-2.237 5-5V6.968C16.019 6.644 16 3 16 3"/><path fill="#DF1F32" d="M20 12h-4s0 1 2 1 2-1 2-1"/><path fill="#C1694F" d="M16.25 8.75h-1.5c-.137 0-.25-.113-.25-.25s.113-.25.25-.25h1.5c.138 0 .25.113.25.25s-.112.25-.25.25m5 0h-1.5c-.138 0-.25-.113-.25-.25s.112-.25.25-.25h1.5c.138 0 .25.113.25.25s-.112.25-.25.25M17 10h2s0 1-1 1-1-1-1-1"/></svg>';
$config->ai->assistants->iconList['laborer'] = '<svg id="laborer" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 36"><path fill="#CE9E5D" d="M32 36v-2a6 6 0 0 0-6-6H10a6 6 0 0 0-6 6v2z"/><path fill="#FFF35F" d="M4.09 33c-.055.326-.09.659-.09 1v2h28v-2c0-.341-.035-.674-.09-1z"/><path fill="#CCD6DD" d="M4 34h28v1H4z"/><path fill="#A0041E" d="M32 13.656c0 3.59-6.268 6.5-14 6.5s-14-2.91-14-6.5 6.268-2.5 14-2.5 14-1.09 14 2.5"/><path fill="#292F33" d="M14 27h8s-1.018 7-4 7-4-7-4-7"/><path fill="#F7DECE" d="M13.64 28.101c1.744 1.267 2.848 1.962 4.36 1.962 1.511 0 2.616-.696 4.36-1.962V24.29h-8.72z"/><path fill="#EEC2AD" d="M13.632 25.973c1.216 1.374 2.724 1.746 4.364 1.746s3.147-.372 4.364-1.746v-3.491h-8.728z"/><path fill="#F7DECE" d="M11.444 15.935c0 1.448-.734 2.622-1.639 2.622s-1.639-1.174-1.639-2.622.734-2.623 1.639-2.623c.906.001 1.639 1.175 1.639 2.623m16.389 0c0 1.448-.734 2.622-1.639 2.622s-1.639-1.174-1.639-2.622.734-2.623 1.639-2.623c.906.001 1.639 1.175 1.639 2.623"/><path fill="#F7DECE" d="M9.478 16.96c0-5.589 3.816-10.121 8.522-10.121s8.522 4.531 8.522 10.121c0 5.589-3.816 10.12-8.522 10.12s-8.522-4.531-8.522-10.12"/><path fill="#C1694F" d="M18 23.802c-2.754 0-3.6-.706-3.741-.848a.655.655 0 0 1 .902-.951c.052.038.721.487 2.839.487 2.2 0 2.836-.485 2.842-.49a.64.64 0 0 1 .913.013.67.67 0 0 1-.014.94c-.141.143-.987.849-3.741.849"/><path fill="#292F33" d="M18 3.479c5.648 0 9.178 4.168 9.178 7.641s-.706 4.863-1.412 3.473l-1.412-2.778s-4.236 0-5.648-1.39c0 0 2.118 4.168-2.118 0 0 0 .706 2.779-3.53-.695 0 0-2.118 1.39-2.824 4.863-.196.963-1.412 0-1.412-3.473S11.646 3.479 18 3.479"/><path fill="#662113" d="M14 17c-.55 0-1-.45-1-1v-1c0-.55.45-1 1-1s1 .45 1 1v1c0 .55-.45 1-1 1m8 0c-.55 0-1-.45-1-1v-1c0-.55.45-1 1-1s1 .45 1 1v1c0 .55-.45 1-1 1"/><path fill="#C1694F" d="M18.75 19.75h-1.5c-.413 0-.75-.337-.75-.75s.337-.75.75-.75h1.5c.413 0 .75.337.75.75s-.337.75-.75.75"/><path fill="#292F33" d="M27 36v-9c0-.55-.45-1-1-1h-1c-.55 0-1 .45-1 1v9zm-15 0v-9c0-.55-.45-1-1-1h-1c-.55 0-1 .45-1 1v9z"/><path fill="#DF1F32" d="M28.853 10.857c-.86-.173-1.093-4.028-3.084-6.859C23.894 1.335 20.304 0 17.997 0S12.1 1.335 10.226 3.998c-1.992 2.831-2.224 6.686-3.084 6.859-3.317.665-3.161 2.386-3.14 2.782.123-.466.438-1.578 3.902-1.64 3.404-.06 6.58.806 10.094.806s6.69-.866 10.094-.806c3.464.061 3.778 1.173 3.902 1.64.02-.396.176-2.117-3.141-2.782"/><path fill="#EA596E" d="M18 0c-2.094 0-5 3.593-5 5.054V9s.109 1 .92 1h8.16c.811 0 .92-1 .92-1V5.054C23 3.593 20.094 0 18 0"/><path fill="#CE9E5D" d="M23.883 25c-.406-.378-2.474.364-3.019 1s-.638 1.737-1.01 3c-.318 1.079-1.572 3.958-1.931 4.775-.358-.817-1.605-3.696-1.923-4.775-.372-1.263-.455-2.364-1-3s-2.594-1.378-3-1 .015 1.463 0 2 0 9 0 9h12s.015-8.463 0-9 .289-1.622-.117-2"/></svg>';
$config->ai->assistants->iconList['running'] = '<svg id="running" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 36"><path fill="#F3D2A2" d="m15.087 24.856-1.728-3.593c-.428.233-2.257 1.253-3.35 2.237-.635.572-.549 1.002-.36 1.944l.017.085c.189.952 2.205 7.351 2.47 8.187l1.345-.334c.011-.446.057-2.767-.176-4.233-.073-.463-.147-1.025-.214-1.522a27 27 0 0 0-.18-1.248c-.064-.334.033-.53.337-.677a57 57 0 0 1 1.839-.846m8.721 1.817c-.546-.067-1.019-.126-1.258-.141-.339-.021-.504-.165-.57-.496a50 50 0 0 1-.356-1.993l-3.912.767c.118.473.644 2.5 1.322 3.806.393.757.831.782 1.79.838l.087.005c.975.057 7.669-.284 8.545-.329l.015-1.385c-.43-.124-2.663-.752-4.142-.896-.465-.045-1.026-.115-1.521-.176"/><path fill="#8899A6" d="m27.805 29.682-.178-.328a.1.1 0 0 1 .058-.132c.171-.059.518-.217.639-.281-.105.24-.225.624-.359.74-.052.043-.134.063-.16.001"/><path fill="#1C6399" d="M30.398 27.138c-.139-.111-.457-.166-.657-.185a7 7 0 0 0-.799-.008 2 2 0 0 0-.355.043.62.62 0 0 0-.332.198c-.057.069-.062.144-.049.181.052.153.304.418.414.67a.5.5 0 0 1 .05.243c-.027.276-.379.678-.643.976-.158.179-.285.32-.29.375a.27.27 0 0 0 .037.158v.002c.072.132.229.269.337.629.069.232.395 1.291.395 1.291.078.27.182.336.226.481.091.297.251 1.094.331 1.346s.271.36.418.381.232-.014.232-.014.345-.155.574-1.449c.165-.935.019-1.079-.105-2.483s.216-2.835.216-2.835"/><path fill="#3B94D9" d="M30.109 29.226c-.235-.096-.771-.45-.922-.831-.136-.344-.229-1.273-.246-1.449.288-.026.731-.007.873.007.188.018.404.033.534.143l.05.043c0-.001-.229 1.473-.289 2.087"/><path fill="#CCD6DD" d="M28.048 30.27a.19.19 0 0 1-.175-.111.193.193 0 0 1 .092-.258l.342-.162a.195.195 0 0 1 .259.092.193.193 0 0 1-.092.258l-.342.162a.2.2 0 0 1-.084.019m.218.625a.2.2 0 0 1-.185-.135.195.195 0 0 1 .126-.244l.38-.121a.194.194 0 0 1 .117.37l-.38.121a.2.2 0 0 1-.058.009m.184.637a.193.193 0 0 1-.038-.384l.356-.072a.19.19 0 0 1 .229.152.194.194 0 0 1-.152.229l-.356.072zm2.776-4.13c-.006-.028-.027-.137-.101-.27-.025-.045-.082-.059-.14-.066-.072-.009-.6-.085-.61.022 0 0-.003.159-.077.268-.075.109-.127.377-.146.577s-.105.951-.085 1.478c.02.528.183 1.482.19 1.8s0 .814-.068 1.18-.14.692-.196.893a1.9 1.9 0 0 1-.279.619s.417-.028.736-.645c.252-.487.393-.955.446-1.411.004-.035.113-1.252.165-1.86.038-.445.102-1.155.102-1.155.081-.841.1-1.269.063-1.43"/><path fill="#8899A6" d="m11.211 32.283.269-.259a.1.1 0 0 1 .143.021c.102.149.348.441.441.541-.26-.037-.661-.051-.809-.149-.056-.038-.096-.112-.044-.154"/><path fill="#1C6399" d="M14.355 34.104c.07-.163.038-.485.003-.683a7 7 0 0 0-.206-.772 2 2 0 0 0-.136-.33c-.108-.176-.212-.237-.28-.267-.082-.036-.155-.022-.188.001-.134.091-.322.405-.535.578a.5.5 0 0 1-.22.113c-.273.048-.755-.184-1.112-.359-.214-.105-.385-.189-.438-.18a.27.27 0 0 0-.143.078l-.002.001h.001c-.108.104-.199.293-.516.492-.206.128-1.14.724-1.14.724-.24.147-.275.265-.403.346-.262.167-.987.534-1.209.678a.523.523 0 0 0-.179.725s.242.291 1.549.166c.945-.09 1.045-.269 2.365-.763 1.32-.493 2.789-.548 2.789-.548"/><path fill="#3B94D9" d="M12.266 34.382c.03-.252.228-.863.555-1.11.295-.222 1.166-.56 1.331-.624.102.271.202.703.226.843.033.186.076.398.004.553l-.028.059c.001.001-1.481.173-2.088.279"/><path fill="#CCD6DD" d="M11.144 33.103a.2.2 0 0 1-.147-.067l-.247-.287a.195.195 0 0 1 .294-.254l.247.287a.195.195 0 0 1-.147.321m-.575.425a.2.2 0 0 1-.163-.088l-.218-.334a.195.195 0 0 1 .326-.213l.218.334a.195.195 0 0 1-.163.301m-.617.337a.2.2 0 0 1-.173-.106l-.165-.324a.194.194 0 1 1 .346-.176l.165.324a.195.195 0 0 1-.173.282m4.369 1.108c.026-.014.125-.062.234-.17.036-.036.035-.095.026-.153-.01-.072-.078-.601-.184-.582 0 0-.154.04-.279-.003s-.398-.021-.595.013c-.197.035-.944.152-1.447.312s-1.379.571-1.684.664c-.305.092-.784.217-1.156.249s-.705.05-.913.049a1.9 1.9 0 0 1-.671-.103s.138.394.818.537a4.1 4.1 0 0 0 1.479.053c.034-.005 1.237-.225 1.836-.337.439-.082 1.14-.21 1.14-.21.833-.146 1.25-.241 1.396-.319"/><path fill="#1C6399" d="M12.654 21.244c.751-.398 3.235-1.653 4.947-1.804a.35.35 0 0 1 .352.235l1.328 3.635a.345.345 0 0 1-.216.451c-.781.25-2.74.915-4.22 1.719a.34.34 0 0 1-.448-.106c-.456-.664-1.642-2.477-1.923-3.76a.34.34 0 0 1 .18-.37"/><path fill="#357BAA" d="M17.514 25.488c-.196-.827-.785-3.547-.501-5.242a.35.35 0 0 1 .316-.281l3.853-.37a.345.345 0 0 1 .382.323c.046.818.196 2.882.601 4.517a.34.34 0 0 1-.216.407c-.758.274-2.811.965-4.123.914a.34.34 0 0 1-.312-.268"/><path fill="#F3D2A2" d="M15.015 10.618c-.085.612.05 1.546 1.466 1.787s2.812.059 3.411-.108.569.884.747 1.872c.179.992.301 1.768.252 1.973-.082.347-.809 1.011-.517 1.612s.757 1.179 1.332.962 1.05-.475 1.203-.797-.525-1.295-.552-1.574c-.027-.278.227-3.888.194-4.298-.04-.501-.078-1.187-.896-1.47-.818-.284-4.094-.92-4.915-1.079-.942-.185-1.612.309-1.725 1.12"/><path fill="#F3D2A2" d="M16.217 6.241c.285-.396.498-.858.589-1.424.326-2.021-.9-3.9-2.738-4.196s-4.287 1.14-4.162 3.184c.125 2.029 1.356 4.986 3.04 4.423.444-.149.889-.311 1.31-.502.19.209.349 1.031.298 1.742-.131 1.81 2.363 1.913 2.492.1.104-1.435-.819-2.312-.829-3.327"/><path fill="#FFE51E" d="M10.637 1.206C13.067-.4 14.736-.192 16.151.88c1.405 1.065 1.526 3.148 1.178 4.485s-.736 1.275-.736 1.275-1.824.465-2.005-1.233c-.057-.537.534-.843-.138-1.615-.432-.497-1.358-.219-1.344.514.015.732-.363.605-.363.605l-1.153-1.91s-.951-.03-1.456.856c-.317.555-1.62-1.248.503-2.651"/><path fill="#4289C1" d="M19.459 10.057c-.77-1.644-1.984-2.479-3.384-1.957-4.381 1.635-2.36 5.68-.781 12.252 0 0 3.109.449 6.316.36 0 .001-.298-6.698-2.151-10.655"/><path fill="#F3D2A2" d="M16.94 10.268c-.577-.345-1.571-.605-2.413.712s-1.251 2.794-1.338 3.466-1.127.196-2.194-.045c-1.07-.242-2.429-.654-2.614-.79-.313-.229-.199-.874-.925-.837s-1.083-.047-1.11.622c-.026.669-.035 1.339.222 1.629.258.29 1.127.04 1.516.177.287.101 3.803 1.876 4.228 2.017.519.172 1.223.425 1.854-.275s2.658-3.714 3.167-4.47c.584-.867.373-1.748-.393-2.206"/></svg>';
$config->ai->assistants->iconList['judge'] = '<svg id="judge" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 36"><path fill="#292F33" d="M36 36v-2a6 6 0 0 0-6-6H14a6 6 0 0 0-6 6v2z"/><path fill="#E1E8ED" d="M17 28h9.929v8H17z"/><path fill="#F7DECE" d="M17.64 28.101c1.744 1.268 2.848 1.963 4.36 1.963s2.615-.696 4.359-1.963V24.29h-8.72z"/><path fill="#EEC2AD" d="M17.632 25.973c1.216 1.374 2.724 1.746 4.364 1.746s3.146-.373 4.363-1.746v-3.491h-8.728v3.491z"/><path fill="#6D6E71" d="M25.597 3.516c-1.925-.623-6.455-.453-7.588 1.019-2.944.057-6.398 2.718-6.851 6.228-.448 3.475.551 5.088.906 7.701.403 2.96 2.067 3.907 3.397 4.303 1.914 2.529 3.949 2.421 7.366 2.421 6.672 0 9.85-4.464 10.131-12.047.17-4.585-2.521-8.059-7.361-9.625"/><path fill="#F7DECE" d="M29.413 13.466c-.646-.894-1.472-1.614-3.284-1.868.68.311 1.331 1.387 1.416 1.982s.17 1.076-.368.481c-2.155-2.382-4.502-1.444-6.827-2.899-1.624-1.016-2.119-2.141-2.119-2.141s-.198 1.5-2.661 3.029c-.714.443-1.566 1.43-2.038 2.888-.34 1.048-.234 1.982-.234 3.578 0 4.66 3.841 8.578 8.578 8.578s8.578-3.953 8.578-8.578c-.001-2.898-.305-4.031-1.041-5.05"/><path fill="#C1694F" d="M22.827 20.9h-1.906a.477.477 0 1 1 0-.954h1.906a.477.477 0 1 1 0 .954"/><path fill="#662113" d="M18.062 17.564a.953.953 0 0 1-.953-.953v-.953a.953.953 0 0 1 1.906 0v.953a.953.953 0 0 1-.953.953m7.625 0a.953.953 0 0 1-.953-.953v-.953a.953.953 0 0 1 1.906 0v.953a.953.953 0 0 1-.953.953"/><path fill="#C1694F" d="M22 24.88c-2.754 0-3.6-.705-3.741-.848a.655.655 0 0 1 .902-.95c.052.037.721.487 2.839.487 2.2 0 2.836-.485 2.842-.49a.64.64 0 0 1 .913.015.67.67 0 0 1-.014.938c-.141.142-.987.848-3.741.848"/><path fill="#99AAB5" d="M22.001 30.878s3.381 2.494 4.093 2.778c.156.063-.366-3.656-.366-3.656h-7.454s-.523 3.781-.231 3.625c.638-.343 3.958-2.747 3.958-2.747"/><path fill="#F5F8FA" d="M17.292 26.625c.566.566 4.709 3.383 4.709 3.383s-2.126 1.242-4.084 3.534c-.197.23-1.542-4.625-1.583-5.709-.012-.303.687-1.479.958-1.208m9.438 0c-.566.566-4.709 3.383-4.709 3.383s2.126 1.242 4.084 3.534c.196.23 1.542-4.625 1.583-5.709.012-.303-.687-1.479-.958-1.208"/><path fill="#292F33" d="M27.62 28s-1.542 5.463-5.62 7.411C17.922 33.463 16.38 28 16.38 28H15v8h14v-8z"/><path fill="#66757F" d="M12.083 33.341c.251 0 .401 2.659.401 2.659h-.956s.193-2.659.555-2.659m3 0c.251 0 .401 2.659.401 2.659h-.956s.193-2.659.555-2.659m16.846 0c-.251 0-.401 2.659-.401 2.659h.956c-.001 0-.194-2.659-.555-2.659m-3 0c-.251 0-.401 2.659-.401 2.659h.956c-.001 0-.194-2.659-.555-2.659"/><path fill="#C1694F" d="M7.854 23.665c.468 1.24.178 2.498-.649 2.812-.826.311-1.876-.441-2.345-1.681-.468-1.239-.178-2.498.649-2.811.826-.312 1.876.44 2.345 1.68"/><path fill="#662113" d="m9.092 36-3.479-9.208.25-.094a2.14 2.14 0 0 0 1.242-2.75 2.14 2.14 0 0 0-2.75-1.241l-1.995.754a2.137 2.137 0 0 0-1.242 2.749 2.14 2.14 0 0 0 2.749 1.241l.25-.094L7.382 36z"/><path fill="#C1694F" d="M3.363 25.361c.468 1.24.178 2.498-.649 2.812-.826.312-1.876-.44-2.345-1.681-.468-1.239-.178-2.498.649-2.811s1.877.44 2.345 1.68"/><path fill="#F7DECE" d="m11.318 36-.466-1.588a2.353 2.353 0 0 0-2.911-1.592l-1.255.368A2.35 2.35 0 0 0 5.076 36z"/></svg>';
$config->ai->assistants->iconList['artist'] = '<svg id="artist" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 36"><path fill="#FA743E" d="M30 28h-3.641v-3.71h-8.72V28H14a6 6 0 0 0-6 6v2h28v-2c0-3.314-2.685-6-6-6"/><path fill="#EEC2AD" d="M17.632 25.973c1.216 1.374 2.724 1.746 4.364 1.746s3.147-.372 4.364-1.746v-3.491h-8.728z"/><path fill="#292F33" d="M25.152 3.3c-1.925-.623-5.876-.46-7.008 1.012-2.944.057-6.083 2.932-6.536 6.443-.448 3.475.235 4.874.591 7.486.403 2.96 2.067 3.907 3.397 4.303 1.914 2.529 3.949 2.421 7.366 2.421 6.672 0 9.271-4.458 9.552-12.04.169-4.585-2.522-8.059-7.362-9.625"/><path fill="#F7DECE" d="M29.547 13.243c-.646-.894-1.472-1.614-3.284-1.868.68.311 1.331 1.387 1.416 1.982s.17 1.076-.368.481c-2.155-2.382-4.502-1.444-6.827-2.899-1.624-1.016-2.119-2.141-2.119-2.141s-.198 1.5-2.661 3.029c-.714.443-1.566 1.43-2.038 2.888-.34 1.048-.234 1.982-.234 3.578 0 4.66 3.841 8.578 8.578 8.578s8.578-3.953 8.578-8.578c-.002-2.898-.305-4.03-1.041-5.05"/><path fill="#C1694F" d="M22.961 20.677h-1.906a.477.477 0 1 1 0-.954h1.906a.477.477 0 1 1 0 .954"/><path fill="#662113" d="M18.195 17.341a.953.953 0 0 1-.953-.953v-.953a.953.953 0 0 1 1.906 0v.953a.953.953 0 0 1-.953.953m7.626 0a.953.953 0 0 1-.953-.953v-.953a.953.953 0 0 1 1.906 0v.953a.953.953 0 0 1-.953.953"/><path fill="#C1694F" d="M22.134 24.657c-2.754 0-3.6-.705-3.741-.848a.655.655 0 0 1 .902-.95c.052.037.721.487 2.839.487 2.2 0 2.836-.485 2.842-.49a.64.64 0 0 1 .913.015.67.67 0 0 1-.014.939c-.142.142-.987.847-3.741.847"/><path fill="#66757F" d="M33.626 6.385c-.439-2.026-4.933-3.858-9.573-4.075.346-.222.672-.402.924-.48.72-.224-.218-.917-.917-.917 0 0-1.092.505-1.93 1.41-6.756.349-12.218 4.021-12.051 4.979.175 1.004 1.232-.01 1.273.845s.938.938.938.938 3.36-.401 8.87.051c5.51.451 9.114.507 10.53.888.872.235 1.006-1.106 1.006-1.106s1.441-.168.93-2.533"/><path fill="#D99E82" d="M27.47 36c-.279-3.867-4.091-7.954-9.64-9.879-6.703-2.325-13.384-.613-14.923 3.823-.672 1.936-.252 4.071.989 6.056z"/><ellipse cx="21.805" cy="32.083" fill="#5C913B" rx="1.654" ry="2.141" transform="rotate(-70.866 21.804 32.082)"/><ellipse cx="7.424" cy="33.703" fill="#269" rx="1.654" ry="2.141" transform="rotate(-70.866 7.424 33.701)"/><ellipse cx="9.272" cy="28.722" fill="#DD2E44" rx="1.654" ry="2.141" transform="rotate(-70.866 9.272 28.72)"/><ellipse cx="16.32" cy="28.642" fill="#FFCC4D" rx="1.654" ry="2.141" transform="rotate(-72.681 16.32 28.641)"/><path fill="#F7DECE" d="M1 30c.078-1.208 1.394-3.184 3-3 1.665.19.129 3.129 0 4s.144 2.938-1 3c-1.546.084-2.14-1.814-2-4"/></svg>';
$config->ai->assistants->iconList['analyst'] = '<svg id="analyst" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 36"><path fill="#CCD6DC" d="M30 26a4 4 0 0 1-4 4H4a4 4 0 0 1-4-4V4a4 4 0 0 1 4-4h22a4 4 0 0 1 4 4z"/><path fill="#F5F8FA" d="M28 26a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h22a2 2 0 0 1 2 2z"/><path fill="#50A5E6" d="M6 26a1 1 0 0 1-1-1V13a1 1 0 1 1 2 0v12a1 1 0 0 1-1 1"/><path fill="#77B255" d="M10 26a1 1 0 0 1-1-1V8a1 1 0 1 1 2 0v17a1 1 0 0 1-1 1"/><path fill="#DD2F45" d="M14 26a1 1 0 0 1-1-1v-7a1 1 0 1 1 2 0v7a1 1 0 0 1-1 1"/><path fill="#226798" d="M36 36v-2c0-3.314-2.685-6-6-6H14a6 6 0 0 0-6 6v2z"/><path fill="#3A87C2" d="M16.667 36H20.2L17 28h-2l-1 6 3 1zm10.666 0H23.8l3.2-8h2l1 6-3 1z"/><path fill="#CCD6DC" d="m24 36 3-6H17l3 6z"/><path fill="#F7DECE" d="M18.321 28.679c.681.649 1.419 1.529 2.055 2.344a2.065 2.065 0 0 0 3.26-.004c.632-.815 1.365-1.693 2.044-2.34.423-.403.68-.95.68-1.534v-.783a2.07 2.07 0 0 0-2.072-2.072h-4.576a2.07 2.07 0 0 0-2.072 2.072v.782c0 .585.257 1.132.681 1.535"/><path fill="#EEC2AD" d="M17.632 25.973c1.216 1.374 2.724 1.746 4.364 1.746s3.147-.373 4.363-1.746v-3.491h-8.728v3.491z"/><path fill="#292F33" d="M25.731 3.323c-1.925-.623-6.455-.453-7.588 1.019-2.944.057-6.398 2.718-6.851 6.228-.448 3.475.551 5.088.906 7.701.403 2.96 2.067 3.907 3.397 4.303 1.914 2.529 3.949 2.421 7.366 2.421 6.672 0 9.85-4.464 10.131-12.047.17-4.585-2.521-8.059-7.361-9.625"/><path fill="#F7DECE" d="M29.547 13.273c-.646-.894-1.472-1.614-3.284-1.868.68.311 1.331 1.387 1.416 1.982s.17 1.076-.368.481c-2.155-2.382-4.502-1.444-6.827-2.899-1.624-1.016-2.119-2.141-2.119-2.141s-.198 1.5-2.661 3.029c-.714.443-1.566 1.43-2.038 2.888-.34 1.048-.234 1.982-.234 3.578 0 4.66 3.841 8.578 8.578 8.578s8.578-3.953 8.578-8.578c-.002-2.898-.305-4.031-1.041-5.05"/><path fill="#C1694F" d="M22.961 20.707h-1.906a.477.477 0 1 1 0-.954h1.906a.477.477 0 1 1 0 .954"/><path fill="#662113" d="M18.195 17.37a.953.953 0 0 1-.953-.953v-.953a.953.953 0 0 1 1.906 0v.953a.95.95 0 0 1-.953.953m7.626 0a.953.953 0 0 1-.953-.953v-.953a.953.953 0 0 1 1.906 0v.953a.953.953 0 0 1-.953.953"/><path fill="#C1694F" d="M22.134 24.686c-2.754 0-3.6-.705-3.741-.848a.655.655 0 0 1 .902-.95c.052.037.721.487 2.839.487 2.2 0 2.836-.485 2.842-.49a.64.64 0 0 1 .913.015.67.67 0 0 1-.014.938c-.142.143-.987.848-3.741.848"/><path fill="#F4F7F9" d="M26.719 26.75c-.567.566-2.709 3.786-2.709 3.786s1.127.839 3.084 3.13c.197.23.543-4.625.584-5.709.011-.303-.688-1.478-.959-1.207m-9.418 0c.566.566 2.709 3.786 2.709 3.786s-1.127.839-3.084 3.13c-.197.23-.543-4.625-.584-5.709-.012-.303.687-1.478.959-1.207"/></svg>';
$config->ai->assistants->iconList['graduate'] = '<svg id="graduate" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 36"><path fill="#292F33" d="M26 28H10a6 6 0 0 0-6 6v2h28v-2c0-3.314-2.685-6-6-6"/><path fill="#66757F" d="M8.083 33.341c.251 0 .401 2.659.401 2.659h-.956s.193-2.659.555-2.659m3 0c.251 0 .401 2.659.401 2.659h-.957c.001 0 .194-2.659.556-2.659m13.846 0c-.251 0-.401 2.659-.401 2.659h.956c-.001 0-.194-2.659-.555-2.659m3 0c-.251 0-.401 2.659-.401 2.659h.956c-.001 0-.194-2.659-.555-2.659"/><path fill="#FA743E" d="M12.38 28s.24.838.77 1.971c.827 1.766 2.366 4.254 4.85 5.441 2.485-1.187 4.024-3.675 4.85-5.441.53-1.133.77-1.971.77-1.971z"/><path fill="#DD551F" d="M18 32c2.329 0 3.882-1.02 4.85-2.029.53-1.133.77-1.971.77-1.971H12.38s.24.838.77 1.971C14.118 30.98 15.671 32 18 32"/><path fill="#F7DECE" d="M13.64 28.106c0 .894 2.36 1.993 4.36 1.993s4.359-1.099 4.359-1.992V24.29h-8.72z"/><path fill="#EEC2AD" d="M13.632 25.973c1.216 1.374 2.724 1.746 4.364 1.746s3.146-.373 4.363-1.746v-3.491h-8.728v3.491z"/><path fill="#292F33" d="M21.152 3.3c-1.925-.623-5.876-.46-7.008 1.012-2.944.057-6.083 2.932-6.536 6.443-.448 3.475.235 4.874.591 7.486.403 2.96 2.067 3.907 3.397 4.303 1.914 2.529 3.949 2.421 7.366 2.421 6.672 0 9.271-4.458 9.552-12.04.169-4.585-2.522-8.059-7.362-9.625"/><path fill="#F7DECE" d="M25.547 13.244c-.646-.894-1.472-1.614-3.284-1.868.68.311 1.331 1.387 1.416 1.982s.17 1.076-.368.481c-2.155-2.382-4.502-1.444-6.827-2.899-1.624-1.016-2.119-2.141-2.119-2.141s-.198 1.5-2.661 3.029c-.714.443-1.566 1.43-2.038 2.888-.34 1.048-.234 1.982-.234 3.578 0 4.66 3.841 8.578 8.578 8.578s8.578-3.953 8.578-8.578c-.002-2.899-.305-4.031-1.041-5.05"/><path fill="#C1694F" d="M18.961 20.677h-1.906a.477.477 0 1 1 0-.954h1.906a.477.477 0 1 1 0 .954"/><path fill="#662113" d="M14.195 17.341a.953.953 0 0 1-.953-.953v-.953a.953.953 0 0 1 1.906 0v.953a.953.953 0 0 1-.953.953m7.626 0a.953.953 0 0 1-.953-.953v-.953a.953.953 0 0 1 1.906 0v.953a.953.953 0 0 1-.953.953"/><path fill="#C1694F" d="M18.134 24.657c-2.754 0-3.6-.705-3.741-.848a.655.655 0 0 1 .902-.95c.052.037.721.487 2.839.487 2.2 0 2.836-.485 2.842-.49a.64.64 0 0 1 .913.015.67.67 0 0 1-.014.939c-.142.142-.987.847-3.741.847"/><path fill="#292F33" d="m32.104 3.511-14-3a.5.5 0 0 0-.209 0l-14 3a.5.5 0 0 0-.032.97l4.944 1.413C8.615 6.489 8.5 7.176 8.5 8c0 2.29 3.285 3.5 9.5 3.5s9.5-1.21 9.5-3.5c0-.824-.115-1.511-.307-2.106l4.945-1.413a.5.5 0 0 0-.034-.97"/><path fill="#66757F" d="M32.48 3.863a.5.5 0 0 0-.618-.344L18 7.48 4.137 3.519a.5.5 0 1 0-.274.962l14 4a.5.5 0 0 0 .273 0l14-4a.5.5 0 0 0 .344-.618"/><path fill="#FFCC4D" d="m17.958 3.502-12 1c-.026.002-.458.057-.458.498v6.095c-.299.186-.5.74-.5 2.405 0 2.485.448 4.5 1 4.5s1-2.015 1-4.5c0-1.665-.201-2.219-.5-2.405V5.46l11.542-.962a.5.5 0 0 0-.084-.996"/></svg>';
$config->ai->assistants->iconList['math'] = '<svg id="math" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 36"><path fill="#D99E82" d="M30 26a4 4 0 0 1-4 4H4a4 4 0 0 1-4-4V4a4 4 0 0 1 4-4h22a4 4 0 0 1 4 4z"/><path fill="#5C913B" d="M28 26a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h22a2 2 0 0 1 2 2z"/><path fill="#FFF" d="M7.515 8.898c-.08.096-.184.24-.184.408 0 .368.272.528.624.528h2.67c.304 0 .576-.16.576-.528s-.271-.528-.624-.528H9.114c.679-.855 1.919-1.958 1.919-3.07 0-1.015-.792-1.663-1.775-1.663s-1.879.807-1.879 1.815c0 .311.2.583.584.583.768 0 .328-1.295 1.247-1.295.328 0 .576.288.576.616 0 .288-.136.536-.28.744-.608.879-1.327 1.599-1.991 2.39m-1.307 5.433H5.049v-1.16c0-.288-.184-.479-.48-.479-.295 0-.479.192-.479.479v1.16H2.931c-.296 0-.48.192-.48.479 0 .288.184.48.48.48H4.09v1.159c0 .288.184.479.479.479.296 0 .48-.191.48-.479V15.29h1.159c.296 0 .48-.192.48-.48 0-.287-.184-.479-.48-.479m4.369 1.447H9.113c.68-.855 1.919-1.958 1.919-3.07 0-1.015-.792-1.663-1.775-1.663s-1.879.808-1.879 1.815c0 .311.2.583.583.583.768 0 .328-1.295 1.248-1.295.328 0 .576.288.576.616 0 .288-.136.536-.28.744-.608.879-1.327 1.599-1.991 2.391-.08.096-.184.24-.184.408 0 .368.272.528.624.528h2.67c.304 0 .576-.16.576-.528 0-.369-.271-.529-.623-.529m.84 3.192H3.083a.5.5 0 0 1 0-1h8.333a.5.5 0 0 1 .001 1"/><path fill="#CCD6DD" d="M36 36v-2a6 6 0 0 0-6-6H14a6 6 0 0 0-6 6v2z"/><path fill="#99AAB5" d="M22.073 30.805s3.297.891 4.545 1.307c.16.053-.951-2.108-.951-2.108h-7.453s-.679 1.542-1.071 2.197c1.96-.624 4.798-1.485 4.798-1.485"/><path fill="#F7DECE" d="M17.64 28.101c.774.562 1.206 1.644 2.3 1.911.326.702.746 1.635 1.122 2.476.355.795 1.486.783 1.825-.02.355-.84.755-1.767 1.074-2.456 1.105-.446 1.611-1.339 2.399-1.911V24.29h-8.72z"/><path fill="#EEC2AD" d="M17.632 25.973c1.216 1.374 2.724 1.746 4.364 1.746s3.146-.373 4.363-1.746v-3.491h-8.728v3.491z"/><path fill="#292F33" d="M25.731 3.323c-1.925-.623-6.455-.453-7.588 1.019-2.944.057-6.398 2.718-6.851 6.228-.448 3.475.551 5.088.906 7.701.403 2.96 2.067 3.907 3.397 4.303 1.914 2.529 3.949 2.421 7.366 2.421 6.672 0 9.85-4.464 10.131-12.047.17-4.585-2.521-8.059-7.361-9.625"/><path fill="#F7DECE" d="M29.547 13.273c-.646-.894-1.472-1.614-3.284-1.868.68.311 1.331 1.387 1.416 1.982s.17 1.076-.368.481c-2.155-2.382-4.502-1.444-6.827-2.899-1.624-1.016-2.119-2.141-2.119-2.141s-.198 1.5-2.661 3.029c-.714.443-1.566 1.43-2.038 2.888-.34 1.048-.234 1.982-.234 3.578 0 4.66 3.841 8.578 8.578 8.578s8.578-3.953 8.578-8.578c-.002-2.898-.305-4.031-1.041-5.05"/><path fill="#C1694F" d="M22.961 20.707h-1.906a.477.477 0 1 1 0-.954h1.906a.477.477 0 1 1 0 .954"/><path fill="#662113" d="M18.195 17.37a.953.953 0 0 1-.953-.953v-.953a.953.953 0 0 1 1.906 0v.953a.95.95 0 0 1-.953.953m7.626 0a.953.953 0 0 1-.953-.953v-.953a.953.953 0 0 1 1.906 0v.953a.953.953 0 0 1-.953.953"/><path fill="#C1694F" d="M22.134 24.686c-2.754 0-3.6-.705-3.741-.848a.655.655 0 0 1 .902-.95c.052.037.721.487 2.839.487 2.2 0 2.836-.485 2.842-.49a.64.64 0 0 1 .913.015.67.67 0 0 1-.014.938c-.142.143-.987.848-3.741.848"/><path fill="#F5F8FA" d="M17.229 26.629c.565.566 2.71 3.383 2.71 3.383s-1.188.695-2.608 2.004c-.516.476-1.35.055-1.287-.644.121-1.349.249-2.909.225-3.534-.011-.303.69-1.481.96-1.209m9.433 0c-.565.566-2.71 3.383-2.71 3.383s1.188.695 2.608 2.004c.516.476 1.35.055 1.287-.644-.121-1.349-.249-2.909-.225-3.534.012-.303-.689-1.481-.96-1.209"/></svg>';
$config->ai->assistants->iconList['chemist'] = '<svg id="chemist" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 36"><path fill="#CCD6DD" d="M36 36v-4a6 6 0 0 0-6-6H14a6 6 0 0 0-6 6v4z"/><path fill="#F7DECE" d="m18 27 4 4 4-4v-5h-8z"/><path fill="#EEC2AD" d="M18 24c1.216 1.374 2.355 1.719 3.996 1.719 1.639 0 2.787-.346 4.004-1.719v-4h-8z"/><path fill="#292F33" d="M25.597 1.071C23.672.448 19.142.618 18.009 2.09c-2.944.057-6.398 2.718-6.851 6.228-.448 3.475.551 5.088.906 7.701.403 2.96 2.067 3.907 3.397 4.303 1.914 2.529 3.949 2.421 7.366 2.421 6.672 0 9.85-4.464 10.131-12.047.17-4.586-2.521-8.059-7.361-9.625"/><path fill="#F7DECE" d="M29.413 11.021c-.646-.894-1.472-1.614-3.284-1.868.68.311 1.331 1.387 1.416 1.982s.17 1.076-.368.481c-2.155-2.382-4.502-1.444-6.827-2.899-1.625-1.017-2.12-2.141-2.12-2.141s-.198 1.5-2.661 3.029c-.714.443-1.566 1.43-2.038 2.888-.34 1.048-.234 1.982-.234 3.578 0 4.66 3.841 8.578 8.578 8.578s8.578-3.953 8.578-8.578c0-2.899-.304-4.031-1.04-5.05"/><path fill="#C1694F" d="M22.827 18.454h-1.906a.477.477 0 1 1 0-.954h1.906a.477.477 0 1 1 0 .954"/><path fill="#662113" d="M18.062 15.118a.953.953 0 0 1-.953-.953v-.953a.953.953 0 0 1 1.906 0v.953a.953.953 0 0 1-.953.953m7.625 0a.953.953 0 0 1-.953-.953v-.953a.953.953 0 0 1 1.906 0v.953a.953.953 0 0 1-.953.953"/><path fill="#C1694F" d="M22 22.434c-2.754 0-3.6-.705-3.741-.848a.655.655 0 0 1 .902-.95c.052.037.721.487 2.839.487 2.2 0 2.836-.485 2.842-.49a.64.64 0 0 1 .913.015.67.67 0 0 1-.014.938c-.141.143-.987.848-3.741.848"/><path fill="#66757F" d="M19.059 36 18 26.781s1.41 1.645 4 1.645 4.219-1.645 4.219-1.645L24.996 36z"/><path fill="#F5F8FA" d="M18.081 25.25C18.647 25.816 21 36 21 36h-3.156l-1.704-2.562 1.704-2.835-2.017-.634.254-3.957s1.729-1.033 2-.762m7.838 0C25.353 25.816 23 36 23 36h3.156l1.704-2.562-1.704-2.835 2.017-.634-.254-3.957s-1.729-1.033-2-.762"/><path fill="#FFF" d="M14.753 10.75h14.5V16h-14.5z" opacity=".4"/><path fill="#F5F8FA" d="M29 10H15c-1 0-1 1-1 1v4c0 1.461 2.333 2 4 2s2.599-1 4-1 2.333 1 4 1 4-.539 4-2v-4c0-1-1-1-1-1m0 4c0 1.325-.852 2-3 2-1.539 0-2.804-1-4-1s-2.461 1-4 1c-2.148 0-3-.675-3-2v-3h14z"/><circle cx="7" cy="11" r="1" fill="#9266CC"/><circle cx="9" cy="16" r="1" fill="#9266CC"/><circle cx="5.5" cy="14.5" r="1.5" fill="#9266CC"/><path fill="#A8BCCC" d="M10 18H5s-2 0-2 2 2 2 2 2v5l-4 5c-.883 1.104-1 1.821-1 2 0 2 2 2 2 2h11s2 0 2-2c0-.134.153-.559-1-2l-4-5v-5s2 0 2-2-2-2-2-2"/><path fill="#E1E8ED" d="M9 27.351V21h1c.449-.012 1-.194 1-1 0-.803-.547-.987-1.008-1H5c-.45.012-1 .194-1 1s.55.988 1.012 1l.975.024L6 27.351l-1.894 2.368 3.394 3.5 3.394-3.5z"/><path fill="#9266CC" d="M.999 34.034c.001.772.551.954 1.013.966H13c.449-.012 1-.194 1-1v-.041l.006-.082c0-.003-.055-.337-.787-1.252l-2.325-2.906H4.106l-2.325 2.906c-.719.899-.782 1.404-.782 1.409"/></svg>';
