<?php
/**
 * The edit view file of service module of ZenTaoPMS.
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yanyi Cao <caoyanyi@easycorp.ltd>
 * @package     service
 * @link        https://www.zentao.net
 */
namespace zin;

if(empty($service->parent)) unset($lang->service->typeList['component']);
formPanel
(
    set::title($lang->service->edit),
    set::actionsClass('w-2/3'),
    formGroup
    (
        set::width('1/2'),
        set::label($lang->service->name),
        set::required(true),
        inputGroup
        (
            input
            (
                set::name('name'),
                set::value($service->name)
            ),
            span
            (
                setClass('input-group-addon'),
                $lang->service->version
            ),
            input
            (
                set::name('version'),
                set::value($service->version),
                setClass('w-1/3')
            )
        )
    ),
    formGroup
    (
        set::width('1/2'),
        set::label($lang->service->softName),
        set::required(true),
        inputGroup
        (
            input
            (
                set::name('softName'),
                set::value($service->softName)
            ),
            span
            (
                setClass('input-group-addon'),
                $lang->service->softVersion
            ),
            input
            (
                set::name('softVersion'),
                set::value($service->softVersion),
                setClass('w-1/3')
            )
        )
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('entry'),
        set::label($lang->service->entry),
        set::value($service->entry)
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('deploy'),
        set::label($lang->service->deploy),
        set::value($service->deploy)
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('port'),
        set::label($lang->service->port),
        set::value($service->port)
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('external'),
        set::label($lang->service->external),
        set::value($service->external),
        set::required(true),
        set::items($lang->service->externalList)
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('dept'),
        set::label($lang->service->dept),
        set::value($service->dept),
        set::items($depts)
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('devel'),
        set::label($lang->service->devel),
        set::value($service->devel),
        set::items($users)
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('qa'),
        set::label($lang->service->qa),
        set::value($service->qa),
        set::items($users)
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('ops'),
        set::label($lang->service->ops),
        set::value($service->ops),
        set::items($users)
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('type'),
        set::label($lang->service->type),
        set::value($service->type),
        set::control('radioListInline'),
        set::items($lang->service->typeList)
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('hosts[]'),
        set::label($lang->service->host),
        set::control(array('control' => 'picker','multiple' => true)),
        set::items($hosts),
        set::value($service->hosts)
    ),
    formGroup
    (
        set::width('2/3'),
        set::name('desc'),
        set::label($lang->service->desc),
        set::value($service->desc),
        set::control('editor')
    )
);
