<?php
namespace zin;

global $lang, $app;

$fromFeedback = data('fromType') == 'feedback';

$fields = defineFieldList('demand.create', 'demand');

$fields->field('pool')
    ->control('hidden')
    ->value(data('pool.id'));

$fields->field('product')
    ->control('inputGroup')
    ->checkbox(array('text' => $lang->demand->undetermined, 'name' => 'undetermined', 'checked' => false))
    ->itemBegin('product[]')->control('picker')->multiple()->menu(array('checkbox' => true))->items(data('products'))->itemEnd();

$fields->field('assignedTo')
    ->control('inputGroup')
    ->itemBegin('assignedTo')->control('picker')->items(data('users'))->itemEnd();

$fields->field('source')
    ->control('picker')
    ->items($lang->demand->sourceList);

$fields->field('sourceNote');

$fields->field('duration')
    ->control('picker')
    ->items($lang->demand->durationList);

$fields->field('BSA')
    ->control('picker')
    ->items($lang->demand->bsaList);

$fields->field('feedbackedBy')
    ->width('1/4')
    ->control('input');

$fields->field('email')
    ->width('1/4')
    ->control('input');

$fields->field('parent')
    ->control('picker')
    ->items(data('parents'))
    ->value(0);

$fields->field('reviewer')
    ->control('inputGroup')
    ->required(true)
    ->wrapAfter()
    ->itemBegin('reviewer[]')->control('picker')->multiple()->menu(array('checkbox' => true))->items(data('reviewers'))->itemEnd();

$fields->field('title')
    ->control('colorInput', array('colorValue' => data('demand.color')));

$fields->field('category')
    ->width('1/4')
    ->control('picker', array('required' => true))
    ->items($lang->demand->categoryList);

$fields->field('pri')
    ->width('1/4')
    ->control('priPicker', array('required' => true))
    ->items($lang->demand->priList);

$fields->field('spec')
    ->width('full')
    ->control('editor');

$fields->field('verify')
    ->width('full')
    ->control('editor');

$fields->field('files')
    ->width('full')
    ->control('fileSelector');

$fields->field('mailto')
    ->control('mailto');

$fields->field('keywords')
    ->control('input');

if($fromFeedback)
{
    $fields->field('feedback')
        ->control('hidden')
        ->value(data('fromID'));
}
