<?php
$config->ai->vendorList = array();
$config->ai->vendorList['openai']['credentials']           = array('key');
$config->ai->vendorList['azure']['credentials']            = array('key', 'resource', 'deployment');
$config->ai->vendorList['openaiCompatible']['credentials'] = array('key', 'base');
$config->ai->vendorList['baidu']['credentials']            = array('key', 'secret');

$config->ai->models = array('openai-gpt35' => 'openai', 'openai-gpt4' => 'openai', 'baidu-ernie' => 'ernie');

/* OpenAI GPT configurations. */
$config->ai->openai = new stdclass();
$config->ai->openai->api = new stdclass();
$config->ai->openai->api->vendor = array('openai', 'azure', 'openaiCompatible');
$config->ai->openai->api->openai = new stdclass();
$config->ai->openai->api->openai->version    = 'v1';                           // OpenAI API version, required.
$config->ai->openai->api->openai->format     = 'https://api.openai.com/%s/%s'; // OpenAI API format, args: API version, API name.
$config->ai->openai->api->openai->authFormat = 'Authorization: Bearer %s';     // OpenAI API auth header format.
$config->ai->openai->api->azure = new stdclass();
$config->ai->openai->api->azure->resource    = '';                             // Azure OpenAI resource name, required.
$config->ai->openai->api->azure->deployment  = '';                             // Azure OpenAI deployment name, required.
$config->ai->openai->api->azure->apiVersion  = '2023-07-01-preview';           // Azure OpenAI API version, required.
$config->ai->openai->api->azure->format      = 'https://%s.openai.azure.com/openai/deployments/%s/%s?api-version=%s'; // Azure API format, args: resource name, deployment name, API name, API version.
$config->ai->openai->api->azure->authFormat  = 'api-key: %s';                  // Azure API auth header format.
$config->ai->openai->api->openaiCompatible = new stdclass();
$config->ai->openai->api->openaiCompatible->format     = '%s/%s';                    // OpenAI API format, args: API base URL, API name.
$config->ai->openai->api->openaiCompatible->authFormat = 'Authorization: Bearer %s'; // OpenAI API auth header format.
$config->ai->openai->api->methods = array('function' => 'chat/completions', 'chat' => 'chat/completions', 'completion' => 'completions');

$config->ai->openai->params = new stdclass();
$config->ai->openai->params->chat       = new stdclass();
$config->ai->openai->params->function   = new stdclass();
$config->ai->openai->params->completion = new stdclass();
$config->ai->openai->params->chat->required       = array('messages');
$config->ai->openai->params->chat->optional       = array('max_tokens', 'temperature', 'top_p', 'n', 'stream', 'stop', 'presence_penalty', 'frequency_penalty', 'logit_bias', 'user');
$config->ai->openai->params->function->required   = array('messages', 'functions', 'function_call');
$config->ai->openai->params->function->optional   = array('max_tokens', 'temperature', 'top_p', 'n', 'stream', 'stop', 'presence_penalty', 'frequency_penalty', 'logit_bias', 'user');
$config->ai->openai->params->completion->required = array('prompt', 'max_tokens');
$config->ai->openai->params->completion->optional = array('suffix', 'temperature', 'top_p', 'n', 'stream', 'logprobs', 'echo', 'stop', 'presence_penalty', 'frequency_penalty', 'best_of', 'logit_bias', 'user');

$config->ai->openai->model = new stdclass();
$config->ai->openai->model->chat       = array('openai-gpt35' => 'gpt-3.5-turbo', 'openai-gpt4' => 'gpt-4-1106-preview');
$config->ai->openai->model->function   = array('openai-gpt35' => 'gpt-3.5-turbo', 'openai-gpt4' => 'gpt-4-1106-preview');
$config->ai->openai->model->completion = 'gpt-3.5-turbo-instruct';

$config->ai->openai->contentTypeMapping = array('Content-Type: application/json' => array('', 'function', 'chat', 'completion'), 'Content-Type: multipart/form-data' => array());
$config->ai->openai->contentType = array();
foreach($config->ai->openai->contentTypeMapping as $contentType => $apis)
{
    foreach($apis as $api) $config->ai->openai->contentType[$api] = $contentType;
}

/* Baidu ERNIE configurations. */
$config->ai->ernie = new stdclass();
$config->ai->ernie->api = new stdclass();
$config->ai->ernie->api->vendor = array('baidu');
$config->ai->ernie->api->baidu = new stdclass();
$config->ai->ernie->api->baidu->format = 'https://aip.baidubce.com/rpc/2.0/ai_custom/v1/wenxinworkshop/chat/completions?access_token=%s';        // ERNIE API format, arg: access_token (obtained from bce oauth).
$config->ai->ernie->api->baidu->auth   = 'https://aip.baidubce.com/oauth/2.0/token?grant_type=client_credentials&client_id=%s&client_secret=%s'; // BCE auth URL format, args: client_id, client_secret.

$config->ai->ernie->params = new stdclass();
$config->ai->ernie->params->chat     = new stdclass();
$config->ai->ernie->params->function = new stdclass();
$config->ai->ernie->params->chat->required     = array('messages');
$config->ai->ernie->params->chat->optional     = array('temperature', 'top_p', 'penalty_score', 'stream', 'system', 'user_id');
$config->ai->ernie->params->function->required = array('messages', 'functions');
$config->ai->ernie->params->function->optional = array('temperature', 'top_p', 'penalty_score', 'stream', 'system', 'user_id');

$config->ai->ernie->model = new stdclass();
$config->ai->ernie->model->chat     = 'ernie-bot-turbo';
$config->ai->ernie->model->function = 'ernie-bot-turbo';

$config->ai->ernie->contentTypeMapping = array('Content-Type: application/json' => array('', 'function', 'chat'), 'Content-Type: multipart/form-data' => array());
$config->ai->ernie->contentType = array();
foreach($config->ai->ernie->contentTypeMapping as $contentType => $apis)
{
    foreach($apis as $api) $config->ai->ernie->contentType[$api] = $contentType;
}

/* Required fields of forms. */
$config->ai->createprompt = new stdclass();
$config->ai->testPrompt   = new stdclass();
$config->ai->createprompt->requiredFields = 'name';
$config->ai->testPrompt->requiredFields   = 'name,module,source,purpose,targetForm';

/* Data source object props definations, commented out ones are not supported for now. */
$config->ai->dataSource = array();
// $config->ai->dataSource['my']['efforts']              = array('date', 'work', 'account', 'consumed', 'left', 'objectID', 'product', 'project', 'execution');
$config->ai->dataSource['product']['product']         = array('name', 'desc');
// $config->ai->dataSource['product']['modules']         = array('name', 'modules');
$config->ai->dataSource['project']['project']         = array('name', 'type', 'desc', 'begin', 'end', 'estimate');
$config->ai->dataSource['project']['programplans']    = array('name', 'desc', 'status', 'begin', 'end', 'realBegan', 'realEnd', 'planDuration', 'progress', 'estimate', 'consumed', 'left');
$config->ai->dataSource['project']['executions']      = array('name', 'desc', 'status', 'begin', 'end', 'realBegan', 'realEnd', 'estimate', 'consumed', 'progress');
$config->ai->dataSource['story']['story']             = array('title', 'spec', 'verify', 'product', 'module', 'pri', 'category', 'estimate');
$config->ai->dataSource['productplan']['productplan'] = array('title', 'desc', 'begin', 'end');
$config->ai->dataSource['productplan']['stories']     = array('title', 'module', 'pri', 'estimate', 'status', 'stage');
$config->ai->dataSource['productplan']['bugs']        = array('title', 'pri', 'status');
$config->ai->dataSource['release']['release']         = array('product', 'name', 'desc', 'date');
$config->ai->dataSource['release']['stories']         = array('title', 'estimate');
$config->ai->dataSource['release']['bugs']            = array('title');
$config->ai->dataSource['execution']['execution']     = array('name', 'desc', 'estimate');
$config->ai->dataSource['execution']['tasks']         = array('name', 'pri', 'status', 'estimate', 'consumed', 'left', 'progress', 'estStarted', 'realStarted', 'finishedDate', 'closedReason');
$config->ai->dataSource['task']['task']               = array('name', 'desc', 'pri', 'status', 'estimate', 'consumed', 'left', 'progress', 'estStarted', 'realStarted');
$config->ai->dataSource['case']['case']               = array('title', 'precondition', 'scene', 'product', 'module', 'pri', 'type', 'lastRunResult', 'status');
$config->ai->dataSource['case']['steps']              = array('desc', 'expect');
$config->ai->dataSource['bug']['bug']                 = array('title', 'steps', 'severity','pri', 'status', 'confirmed', 'type');
$config->ai->dataSource['doc']['doc']                 = array('title', 'addedBy', 'addedDate', 'editedBy', 'editedDate', 'content');

/* Available target form definations. Please also update `$lang->ai->targetForm` upon changes! Some are commented out, these need extra work. */
$config->ai->targetForm = array();
// $config->ai->targetForm['product']['tree/managechild']   = (object)array('m' => 'tree', 'f' => 'browse');
// $config->ai->targetForm['product']['doc/create']         = (object)array('m' => 'doc', 'f' => 'create');
$config->ai->targetForm['story']['create']               = (object)array('m' => 'story', 'f' => 'create');
$config->ai->targetForm['story']['batchcreate']          = (object)array('m' => 'story', 'f' => 'batchcreate');
$config->ai->targetForm['story']['change']               = (object)array('m' => 'story', 'f' => 'change');
$config->ai->targetForm['story']['totask']               = (object)array('m' => 'task', 'f' => 'batchcreate');
$config->ai->targetForm['story']['testcasecreate']       = (object)array('m' => 'testcase', 'f' => 'create');
$config->ai->targetForm['story']['subdivide']            = (object)array('m' => 'story', 'f' => 'batchcreate');
$config->ai->targetForm['productplan']['edit']           = (object)array('m' => 'productplan', 'f' => 'edit');
$config->ai->targetForm['productplan']['create']         = (object)array('m' => 'productplan', 'f' => 'create');
// $config->ai->targetForm['projectrelease']['doc/create']  = (object)array('m' => 'doc', 'f' => 'create');
// $config->ai->targetForm['project']['risk/create']        = (object)array('m' => 'risk', 'f' => 'create');
// $config->ai->targetForm['project']['issue/create']       = (object)array('m' => 'issue', 'f' => 'create');
// $config->ai->targetForm['project']['doc/create']         = (object)array('m' => 'doc', 'f' => 'create');
$config->ai->targetForm['project']['programplan/create'] = (object)array('m' => 'programplan', 'f' => 'create');
$config->ai->targetForm['execution']['batchcreatetask']  = (object)array('m' => 'task', 'f' => 'batchcreate');
// $config->ai->targetForm['execution']['createtestreport'] = (object)array('m' => 'execution', 'f' => 'testreport');
// $config->ai->targetForm['execution']['createqa']         = (object)array('m' => 'execution', 'f' => 'createQA');
// $config->ai->targetForm['execution']['createrisk']       = (object)array('m' => 'execution', 'f' => 'createRisk');
// $config->ai->targetForm['execution']['createissue']      = (object)array('m' => 'execution', 'f' => 'createIssue');
$config->ai->targetForm['task']['edit']                  = (object)array('m' => 'task', 'f' => 'edit');
$config->ai->targetForm['task']['batchcreate']           = (object)array('m' => 'task', 'f' => 'batchcreate');
$config->ai->targetForm['testcase']['edit']              = (object)array('m' => 'testcase', 'f' => 'edit');
// $config->ai->targetForm['testcase']['createscript']      = (object)array('m' => 'testcase', 'f' => 'createScript');
$config->ai->targetForm['bug']['edit']                   = (object)array('m' => 'bug', 'f' => 'edit');
$config->ai->targetForm['bug']['story/create']           = (object)array('m' => 'story', 'f' => 'create');
$config->ai->targetForm['bug']['testcase/create']        = (object)array('m' => 'testcase', 'f' => 'create');
// $config->ai->targetForm['doc']['create']                 = (object)array('m' => 'doc', 'f' => 'create');
$config->ai->targetForm['doc']['edit']                   = (object)array('m' => 'doc', 'f' => 'edit');

/* Used to check if form injection is available, generated from `$config->ai->targetForm`. */
$config->ai->availableForms = array();
foreach($config->ai->targetForm as $forms)
{
    foreach($forms as $form)
    {
        if(!empty($config->ai->availableForms[$form->m]) && in_array($form->f, $config->ai->availableForms[$form->m])) continue;
        $config->ai->availableForms[$form->m][] = $form->f;
    }
}

/**
 * Target form variables definations, defines format and arguments of target form redirection links,
 * useful when method requires additional arguments.
 *
 * Arg keys are names of objects, usually the same as object name. Arg values indicate if arg is required.
 * It will be used to get object ID and sprintf to format.
 */
$config->ai->targetFormVars = array();
$config->ai->targetFormVars['story']['create']         = (object)array('format' => 'product=%d', 'args' => array('product' => 1), 'app' => 'product');
$config->ai->targetFormVars['story']['batchcreate']    = (object)array('format' => 'productID=%d', 'args' => array('product' => 1), 'app' => 'product');
$config->ai->targetFormVars['story']['change']         = (object)array('format' => 'storyID=%d', 'args' => array('story' => 1), 'app' => 'product');
$config->ai->targetFormVars['productplan']['create']   = (object)array('format' => 'productID=%d&branch=%d&parent=%d', 'args' => array('product' => 1, 'branch' => 0, 'productplan' => 0), 'app' => 'product');
$config->ai->targetFormVars['productplan']['edit']     = (object)array('format' => 'planID=%d', 'args' => array('productplan' => 1), 'app' => 'product');
$config->ai->targetFormVars['task']['create']          = (object)array('format' => 'executionID=%d&storyID=%d', 'args' => array('execution' => 1, 'story' => 0), 'app' => 'execution');
$config->ai->targetFormVars['task']['batchcreate']     = (object)array('format' => 'executionID=%d&storyID=%d', 'args' => array('execution' => 1, 'story' => 0), 'app' => 'execution');
$config->ai->targetFormVars['task']['edit']            = (object)array('format' => 'taskID=%d', 'args' => array('task' => 1), 'app' => 'execution');
$config->ai->targetFormVars['bug']['create']           = (object)array('format' => 'productID=%d', 'args' => array('product' => 1), 'app' => 'qa');
$config->ai->targetFormVars['bug']['edit']             = (object)array('format' => 'bugID=%d', 'args' => array('bug' => 1), 'app' => 'qa');
$config->ai->targetFormVars['testcase']['create']      = (object)array('format' => 'productID=%d', 'args' => array('product' => 1), 'app' => 'qa');
$config->ai->targetFormVars['testcase']['edit']        = (object)array('format' => 'caseID=%d', 'args' => array('case' => 1), 'app' => 'qa');
$config->ai->targetFormVars['testreport']['create']    = (object)array('format' => 'productID=%d', 'args' => array('product' => 1), 'app' => 'qa');
$config->ai->targetFormVars['execution']['testreport'] = (object)array('format' => '', 'args' => array(), 'app' => 'execution');
// $config->ai->targetFormVars['tree']['browse']          = (object)array('format' => 'rootID=%d&view=%s', 'args' => array('root', 'view'), 'app' => 'product');
$config->ai->targetFormVars['programplan']['create']   = (object)array('format' => 'projectID=%d', 'args' => array('project' => 1), 'app' => 'project');
$config->ai->targetFormVars['doc']['edit']             = (object)array('format' => 'docID=%d', 'args' => array('doc' => 1), 'app' => 'doc');

/* Menu printing configurations. */
$config->ai->menuPrint = new stdclass();
/**
 * Menu location definations, defines acceptable module-methods and on page menu locations, etc.
 * Some are identical except for module name, reuse them as much as possible.
 *
 * @param string $module           prompt module name (actual module could differ from prompt module name)
 * @param string $targetContainer  injection target container selector
 * @param string $class            class of menu or dropdown button
 * @param string $buttonClass      specified class of action menu buttons
 * @param string $dropdownClass    specified class of dropdown menu button
 * @param string $objectVarName    object variable name of view
 * @param string $stylesheet       stylesheet to be injected
 * @param string $injectMethod     injection jQuery method, `append` by default
 * @see ./view/promptmenu.html.php
 */
$config->ai->menuPrint->locations = array();
$config->ai->menuPrint->locations['story']['view'] = (object)array(
    'module'          => 'story',
    'targetContainer' => '#mainContent .detail-body .detail-section:first-of-type > div:first-of-type',
    'stylesheet'      => '#mainContent .detail-body .detail-section:first-of-type > div:first-of-type {width: 100%; justify-content: space-between;}'
);
$config->ai->menuPrint->locations['task']['view']             = clone $config->ai->menuPrint->locations['story']['view'];
$config->ai->menuPrint->locations['task']['view']->module     = 'task';
$config->ai->menuPrint->locations['testcase']['view']         = clone $config->ai->menuPrint->locations['story']['view'];
$config->ai->menuPrint->locations['testcase']['view']->module = 'case';
$config->ai->menuPrint->locations['bug']['view']              = clone $config->ai->menuPrint->locations['story']['view'];
$config->ai->menuPrint->locations['bug']['view']->module      = 'bug';
$config->ai->menuPrint->locations['projectstory']['view']     = clone $config->ai->menuPrint->locations['story']['view'];
$config->ai->menuPrint->locations['execution']['storyView']   = $config->ai->menuPrint->locations['story']['view'];

$config->ai->menuPrint->locations['execution']['view'] = (object)array( // TODO: fix this.
    'module'          => 'execution',
    'injectMethod'    => 'prepend',
    'targetContainer' => '#mainContent.main-row > .col-4.side-col .detail:first-child  > .detail-title',
    'class'           => 'pull-right'
);

$config->ai->menuPrint->locations['project']['view']         = clone $config->ai->menuPrint->locations['execution']['view'];
$config->ai->menuPrint->locations['project']['view']->module = 'project';
$config->ai->menuPrint->locations['project']['view']         = clone $config->ai->menuPrint->locations['execution']['view'];
$config->ai->menuPrint->locations['project']['view']->module = 'project';

$config->ai->menuPrint->locations['product']['view'] = (object)array( // TODO: fix this.
    'module'          => 'product',
    'injectMethod'    => 'append',
    'targetContainer' => '#mainContent.main-row > .col-8.main-col .detail:first-child > .detail-title',
    'class'           => 'pull-right'
);

$config->ai->menuPrint->locations['productplan']['view'] = (object)array(
    'module'          => 'productplan',
    'injectMethod'    => 'prepend',
    'targetContainer' => '#mainContent .toolbar',
    'objectVarName'   => 'plan'
);
$config->ai->menuPrint->locations['projectplan']['view']                   = $config->ai->menuPrint->locations['productplan']['view'];
$config->ai->menuPrint->locations['release']['view']                       = clone $config->ai->menuPrint->locations['productplan']['view'];
$config->ai->menuPrint->locations['release']['view']->module               = 'release';
$config->ai->menuPrint->locations['release']['view']->objectVarName        = null;
$config->ai->menuPrint->locations['projectrelease']['view']                = clone $config->ai->menuPrint->locations['productplan']['view'];
$config->ai->menuPrint->locations['projectrelease']['view']->objectVarName = null;

$config->ai->menuPrint->locations['doc']['view'] = (object)array(
    'module'          => 'doc',
    'targetContainer' => '#docPanel > .panel-heading > .panel-actions > .toolbar',
);

$config->ai->injectAuditButton = new stdclass();
$config->ai->injectAuditButton->locations = array();
$config->ai->injectAuditButton->locations['task']['edit'] = array(
    'toolbar' => (object)array(
        'targetContainer' => '#mainContent .detail-header, #mainContent .panel-heading, #mainContent form div',
        'injectMethod'    => 'append',
        'class'           => 'pull-right btn-toolbar',
    ),
    'action' => (object)array(
        'targetContainer' => '#mainContent .form-actions',
        'injectMethod'    => 'html',
    )
);

$config->ai->injectAuditButton->locations['bug']['create'] = array(
    'toolbar' => (object)array(
        'targetContainer' => '#mainContent .panel-heading',
        'injectMethod'    => 'append',
        'containerStyles' => '{"padding-right": "8px"}',
    ),
    'action' => (object)array(
        'targetContainer' => '#mainContent .form-actions',
        'injectMethod'    => 'html',
    )
);

$config->ai->injectAuditButton->locations['doc']['edit'] = array(
    'toolbar' => (object)array(
        'targetContainer' => '.titleBox',
        'injectMethod'    => 'append',
    ),
    'action' => (object)array(
        'targetContainer' => '.titleBox',
        'injectMethod'    => 'append',
    )
);

$config->ai->injectAuditButton->locations['productplan']['create'] = $config->ai->injectAuditButton->locations['task']['edit'];
$config->ai->injectAuditButton->locations['productplan']['edit']   = $config->ai->injectAuditButton->locations['task']['edit'];
$config->ai->injectAuditButton->locations['programplan']['create'] = $config->ai->injectAuditButton->locations['task']['edit'];
$config->ai->injectAuditButton->locations['bug']['edit']           = $config->ai->injectAuditButton->locations['task']['edit'];
$config->ai->injectAuditButton->locations['story']['change']       = $config->ai->injectAuditButton->locations['task']['edit'];
$config->ai->injectAuditButton->locations['testcase']['edit']      = $config->ai->injectAuditButton->locations['task']['edit'];
$config->ai->injectAuditButton->locations['testreport']['create']  = $config->ai->injectAuditButton->locations['task']['edit'];

$config->ai->injectAuditButton->locations['story']['batchcreate'] = $config->ai->injectAuditButton->locations['bug']['create'];
$config->ai->injectAuditButton->locations['story']['create']      = $config->ai->injectAuditButton->locations['bug']['create'];
$config->ai->injectAuditButton->locations['task']['batchcreate']  = $config->ai->injectAuditButton->locations['bug']['create'];
$config->ai->injectAuditButton->locations['task']['create']       = $config->ai->injectAuditButton->locations['bug']['create'];
$config->ai->injectAuditButton->locations['testcase']['create']   = $config->ai->injectAuditButton->locations['bug']['create'];

$config->ai->miniPrograms = new stdClass();
$config->ai->miniPrograms->iconList = array();
$config->ai->miniPrograms->iconList['writinghand']  = '<svg id="writinghand" width="24" height="26" viewBox="0 0 24 26" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_342_93810)"><path d="M4.21149 15.5588C4.15999 16.2068 4.42341 16.4007 4.83602 16.7085C5.24402 17.0128 7.72961 14.6937 8.5423 14.3409C9.35499 13.9881 16.9841 12.2684 16.6533 10.6984C16.3226 9.12838 14.0172 8.89647 12.2413 9.21693C10.4654 9.5374 7.06679 11.2002 6.07387 12.0976C5.08095 12.9944 4.21149 15.5588 4.21149 15.5588ZM9.9036 16.6109C9.9036 16.6109 7.55532 17.4226 7.55532 19.5309C7.55532 21.6392 8.12705 22.8283 8.39772 23.4053C8.66906 23.9816 9.51211 24.541 10.6787 24.0034C12.0334 23.3786 10.3545 19.7839 14.6398 21.434C16.6032 22.1895 18.6398 23.2106 20.6204 22.5079C22.4993 21.8409 23.2228 19.325 23.2228 17.9194C23.2228 15.0423 21.2423 15.8111 20.5821 16.5139C19.9219 17.2167 14.6404 18.6222 13.9802 18.6222C13.3201 18.6222 9.9036 16.6109 9.9036 16.6109Z" fill="#EF9645"/><path d="M12.8662 20.1599C12.8662 20.1599 12.787 19.2351 11.9584 19.1275C11.2778 19.0397 10.205 19.2814 9.64778 20.467C9.09058 21.6533 8.1003 21.4551 8.14189 22.4432C8.18283 23.4313 8.47199 24.2002 9.07012 24.3977C9.6689 24.5958 10.5146 24.2445 10.6176 23.1903C10.7206 22.1361 10.8447 21.1698 11.4838 20.7524C12.1241 20.3356 12.8662 20.1599 12.8662 20.1599Z" fill="#F9CA55"/><path d="M11.9998 18.6222C11.9998 18.6222 11.3396 17.9194 10.0192 17.9194C8.69883 17.9194 5.61972 19.4185 6.55322 22.3996C7.21341 24.508 9.09098 23.5199 9.35901 21.4333C9.62771 19.344 11.9998 18.6222 11.9998 18.6222Z" fill="#EF9645"/><path d="M11.3392 18.6222C11.3392 18.6222 10.679 17.9194 9.35861 17.9194C8.03824 17.9194 6.13361 18.9947 6.05769 22.1361C5.99563 24.7055 8.71889 23.5417 8.69843 21.4333C8.67796 19.325 11.3392 18.6222 11.3392 18.6222Z" fill="#F9CA55"/><path d="M3.41699 19.325C3.41699 21.6421 3.7187 23.0399 5.01992 22.8016C7.17807 22.4067 6.35878 19.559 8.24757 18.7579C9.61877 18.1767 11.6152 18.3151 13.5423 19.533C14.8118 20.3356 13.98 17.2167 12.6596 16.5139C11.3392 15.8111 7.3781 16.5139 6.71792 16.5139C6.05773 16.5139 3.41699 19.325 3.41699 19.325Z" fill="#EF9645"/><path d="M3.3133 19.4473C2.26294 21.3202 2.902 23.2564 4.73797 22.8389C6.51453 22.4355 5.6246 19.9786 7.37872 18.6222C8.36173 17.8618 10.4803 17.6067 11.8006 18.3095C13.121 19.0123 13.3204 17.2167 12 16.5139C10.6796 15.8111 6.36203 16.4963 5.70317 16.5399C4.44287 16.6235 3.3133 19.4473 3.3133 19.4473Z" fill="#F9CA55"/><path d="M6.33393 20.8107C5.88566 21.3574 5.10598 21.4144 4.5917 20.9372L4.4623 20.817C3.94802 20.3398 3.8952 19.5105 4.34347 18.9631L19.2128 0.819447C19.6611 0.272686 20.4408 0.215761 20.955 0.692947L21.0838 0.813122C21.5981 1.29031 21.6509 2.12029 21.2033 2.66705L6.33393 20.8107Z" fill="#3B88C3"/><path d="M7.04188 19.9477C5.48384 21.8487 1.55376 25.5762 1.05598 25.1145C0.558863 24.6528 3.49405 20.0018 5.05208 18.1001C6.61012 16.1984 6.14865 17.7192 6.69792 18.2301C7.2472 18.7403 8.59992 18.0474 7.04188 19.9477Z" fill="#3B88C3"/><path d="M4.52051 17.9377C4.52051 18.6405 6.11882 19.2835 6.779 18.5808C7.43919 17.878 8.98468 17.015 11.0167 17.9194C15.7727 20.0348 13.9796 17.2167 11.9991 16.5139C10.0185 15.8111 6.7176 16.5139 6.05742 16.5139C5.39723 16.5139 4.52051 17.9377 4.52051 17.9377Z" fill="#EF9645"/><path d="M4.20636 15.8413C3.97001 15.0591 5.65084 10.7257 6.41203 10.0546C7.37062 9.20985 11.0789 7.90198 12.3993 7.90198C13.7196 7.90198 23.223 12.9999 23.223 16.5138C23.223 20.0277 21.9026 20.4669 20.0046 21.0158C18.4868 21.455 15.3074 21.1859 13.9183 19.8077C12.701 18.6004 11.8553 17.7655 10.6795 17.2166C8.49954 16.199 7.04647 17.5146 6.38629 18.2174C5.06592 19.6229 2.57834 18.1056 4.6533 15.7014C6.13806 13.9803 7.44588 13.4441 8.69892 12.9999C12.66 11.5944 15.3008 11.5944 13.9804 10.1888C13.5136 9.69195 13.2595 10.432 12.6099 10.5578C11.3027 10.8108 10.2622 10.9808 8.53981 11.5923C7.94432 11.8031 5.12533 13.7168 4.20636 15.8413Z" fill="#FFDC5D"/><path d="M8.82806 11.7876C9.5305 11.515 12.5924 10.9218 14.1855 10.3343C15.4722 9.85921 16.6011 10.7813 14.1591 11.7595C11.8022 12.7033 9.35357 12.626 7.56777 13.3808C6.8924 13.6662 6.30681 12.7659 8.82806 11.7876Z" fill="#EF9645"/><path d="M14.9617 5.9884C14.9617 5.9884 11.0481 10.7638 9.38574 12.7779C10.8738 12.1272 12.2054 12.2509 13.4776 11.4539C14.7497 10.6577 15.33 9.808 17.2604 7.45159C17.9774 6.57733 14.9617 5.9884 14.9617 5.9884Z" fill="#3B88C3"/></g><defs><clipPath id="clip0_342_93810"><rect width="23.7667" height="25.3" fill="white" transform="translate(0.116211 0.349976)"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['notebook']     = '<svg id="notebook" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3650)"><path d="M32.0001 23.1111C32.0001 25.0747 30.4081 26.6667 28.4446 26.6667H7.11122C5.14766 26.6667 3.55566 25.0747 3.55566 23.1111V5.61156C3.55566 3.648 8.70322 0 10.6668 0H27.2223C29.9726 0 32.0001 2.05511 32.0001 4.77778V23.1111Z" fill="#F4900C"/><path d="M30.2224 26.6665C30.2224 28.6301 28.6304 30.2221 26.6668 30.2221H8.88905C6.9255 30.2221 5.3335 28.6301 5.3335 26.6665V5.33322C5.3335 1.67188 5.31483 1.77766 9.77794 1.77766H26.6668C28.6304 1.77766 30.2224 3.36966 30.2224 5.33322V26.6665Z" fill="#CCD6DD"/><path d="M28.4446 27.5557C28.4446 29.0286 27.2508 30.2223 25.7779 30.2223H6.22233C4.74944 30.2223 3.55566 29.0286 3.55566 27.5557V6.22233C3.55566 4.74944 4.74944 3.55566 6.22233 3.55566H25.7779C27.2508 3.55566 28.4446 4.74944 28.4446 6.22233V27.5557Z" fill="#E1E8ED"/><path d="M28.4443 28.4444C28.4443 30.4079 26.8523 31.9999 24.8888 31.9999H7.99989C6.03634 31.9999 4.44434 30.4079 4.44434 28.4444V8.88881C4.44434 6.92525 6.03634 5.33325 7.99989 5.33325H24.8888C26.8523 5.33325 28.4443 6.92525 28.4443 8.88881V28.4444Z" fill="#FFAC33"/><path d="M26.6666 28.4444C26.6666 30.408 25.0746 32 23.111 32H7.99989C6.03634 32 4.44434 30.408 4.44434 28.4444V10.6666C4.44434 8.70308 6.03634 7.11108 7.99989 7.11108H23.4088C25.3723 7.11108 26.6666 8.40531 26.6666 10.3689V28.4444Z" fill="#FFCC4D"/><path d="M8.00011 5.33333C6.49966 5.33333 6.46144 3.62489 7.11122 2.88889C7.85077 2.05244 9.00011 1.77778 11.0561 1.77778H12.4446V0H10.0277C6.49966 0 3.55566 2.22222 3.55566 4.77778V28.4444C3.55566 30.408 5.14766 32 7.11122 32H8.889V5.33333H8.00011Z" fill="#F4900C"/><path d="M7.59282 29.3146C7.59282 29.9386 6.99994 30.4444 6.26838 30.4444C5.53771 30.4444 4.94482 29.9386 4.94482 29.3146C4.94482 28.6915 5.53771 28.1848 6.26838 28.1848C6.99994 28.1848 7.59282 28.6906 7.59282 29.3146Z" fill="#662113"/><path d="M6.12795 28.6853C5.70129 28.7341 5.42395 29.0186 5.22395 29.3333C4.95106 29.7644 4.32884 30.2221 3.55551 30.2221C2.57417 30.2221 1.77773 29.6257 1.77773 28.8888C1.77773 28.1519 2.57417 27.5555 3.55551 27.5555V25.7812C1.62929 25.7999 0.0737305 27.1813 0.0737305 28.8888C0.0737305 30.6079 1.64884 31.9999 3.59195 31.9999C5.23995 31.9999 6.56706 31.071 7.05951 29.7164C7.30573 29.0417 6.64262 28.6284 6.12795 28.6853Z" fill="#66757F"/><path d="M7.59282 22.2035C7.59282 22.8275 6.99994 23.3333 6.26838 23.3333C5.53771 23.3333 4.94482 22.8275 4.94482 22.2035C4.94482 21.5804 5.53771 21.0737 6.26838 21.0737C6.99994 21.0737 7.59282 21.5795 7.59282 22.2035Z" fill="#662113"/><path d="M6.12795 21.5742C5.70129 21.6231 5.42395 21.9075 5.22395 22.2222C4.95106 22.6533 4.32884 23.1111 3.55551 23.1111C2.57417 23.1111 1.77773 22.5146 1.77773 21.7777C1.77773 21.0408 2.57417 20.4444 3.55551 20.4444V18.6702C1.62929 18.6888 0.0737305 20.0702 0.0737305 21.7777C0.0737305 23.4968 1.64884 24.8888 3.59195 24.8888C5.23995 24.8888 6.56706 23.9599 7.05951 22.6053C7.30573 21.9306 6.64262 21.5173 6.12795 21.5742Z" fill="#66757F"/><path d="M7.59282 15.0924C7.59282 15.7164 6.99994 16.2222 6.26838 16.2222C5.53771 16.2222 4.94482 15.7164 4.94482 15.0924C4.94482 14.4693 5.53771 13.9626 6.26838 13.9626C6.99994 13.9626 7.59282 14.4684 7.59282 15.0924Z" fill="#662113"/><path d="M6.12795 14.4631C5.70129 14.512 5.42395 14.7964 5.22395 15.1111C4.95106 15.5422 4.32884 16 3.55551 16C2.57417 16 1.77773 15.4035 1.77773 14.6666C1.77773 13.9297 2.57417 13.3333 3.55551 13.3333V11.5591C1.62929 11.5777 0.0737305 12.9591 0.0737305 14.6666C0.0737305 16.3857 1.64884 17.7777 3.59195 17.7777C5.23995 17.7777 6.56706 16.8489 7.05951 15.4942C7.30573 14.8195 6.64262 14.4062 6.12795 14.4631Z" fill="#66757F"/><path d="M7.59282 7.98134C7.59282 8.60534 6.99994 9.11112 6.26838 9.11112C5.53771 9.11112 4.94482 8.60534 4.94482 7.98134C4.94482 7.35823 5.53771 6.85156 6.26838 6.85156C6.99994 6.85156 7.59282 7.35734 7.59282 7.98134Z" fill="#662113"/><path d="M6.12795 7.352C5.70129 7.40089 5.42395 7.68533 5.22395 8C4.95106 8.43111 4.32884 8.88889 3.55551 8.88889C2.57417 8.88889 1.77773 8.29244 1.77773 7.55555C1.77773 6.81866 2.57417 6.22222 3.55551 6.22222V4.448C1.63017 4.46578 0.0737305 5.848 0.0737305 7.55555C0.0737305 9.27466 1.64884 10.6667 3.59195 10.6667C5.23995 10.6667 6.56706 9.73778 7.05951 8.38311C7.30573 7.70844 6.64262 7.29511 6.12795 7.352Z" fill="#66757F"/></g><defs><clipPath id="clip0_914_3650"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['pencil']       = '<svg id="pencil" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3666)"><path d="M31.3085 29.865C30.7334 27.9974 29.7929 24.4792 29.2418 23.1397C28.7965 22.0588 28.3805 20.9725 27.8694 20.4605C27.3583 19.9494 26.4889 19.9894 25.9645 20.5121C25.9645 20.5121 23.7698 22.001 22.9831 22.9859C21.9983 23.7699 20.5076 25.9699 20.5076 25.9699C19.9831 26.4943 19.9431 27.3628 20.4543 27.8748C20.9663 28.3859 22.0525 28.8019 23.1343 29.2472C24.4729 29.7983 27.992 30.737 29.8596 31.3139C30.1787 31.4117 31.4063 30.1841 31.3085 29.865Z" fill="#D99E82"/><path d="M12.1271 4.71816C13.1502 5.74127 13.1502 7.39905 12.1271 8.42216L8.42311 12.127C7.4 13.1493 5.74045 13.1493 4.71911 12.127L1.01423 8.42216C-0.00799698 7.39905 -0.00799698 5.74127 1.01423 4.71816L4.71823 1.01416C5.74045 -0.0089516 7.39912 -0.0089516 8.42223 1.01416L12.1271 4.71816Z" fill="#EA596E"/><path d="M27.8695 20.4603L24.1628 24.167L20.4624 27.8692L6.5708 13.9786L13.9797 6.57056L27.8695 20.4603Z" fill="#FFCC4D"/><path d="M28.5137 30.9005C28.5137 30.9005 30.9217 32.224 31.5723 31.5734C32.223 30.9227 30.8923 28.52 30.8923 28.52C30.8923 28.52 28.6114 28.5627 28.5137 30.9005Z" fill="#292F33"/><path d="M1.94043 9.34834L9.34932 1.93945L13.9787 6.56967L6.57065 13.9786L1.94043 9.34834Z" fill="#CCD6DD"/><path d="M2.8667 10.2737L10.2747 2.86572L11.2009 3.79194L3.79292 11.1999L2.8667 10.2737ZM4.71825 12.1279L12.1271 4.71906L13.0534 5.64528L5.64448 13.0533L4.71825 12.1279Z" fill="#99AAB5"/></g><defs><clipPath id="clip0_914_3666"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['calendar']     = '<svg id="calendar" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3674)"><path d="M32 28.4443C32 30.4079 30.408 31.9999 28.4444 31.9999H3.55556C1.592 31.9999 0 30.4079 0 28.4443V7.99989C0 6.03634 1.592 4.44434 3.55556 4.44434H28.4444C30.408 4.44434 32 6.03634 32 7.99989V28.4443Z" fill="#E0E7EC"/><path d="M21.0286 16.9955H15.8846C14.8001 16.9955 14.3975 16.2924 14.3975 15.6088C14.3975 14.9057 14.7788 14.2222 15.8846 14.2222H23.1592C24.185 14.2222 24.6063 15.1466 24.6063 15.6693C24.6063 16.0711 24.385 16.4933 24.1441 16.9955L19.1601 27.1244C18.5975 28.2497 18.3761 28.6506 17.4721 28.6506C16.3663 28.6506 15.8037 27.8071 15.8037 27.2239C15.8037 26.9831 15.8641 26.8026 16.0046 26.5208L21.0286 16.9955ZM9.67923 16.8888H9.23479C8.27034 16.8888 7.86768 16.2391 7.86768 15.5555C7.86768 14.8515 8.3699 14.2222 9.23479 14.2222H11.0259C11.8899 14.2222 12.3726 14.8453 12.3726 15.6488V27.0844C12.3726 28.0888 11.8766 28.6515 11.0126 28.6515C10.1486 28.6515 9.67923 28.0888 9.67923 27.0844V16.8888Z" fill="#66757F"/><path d="M30.2222 0H27.3093C27.4622 0.262222 27.5556 0.563556 27.5556 0.888889C27.5556 1.87022 26.7591 2.66667 25.7778 2.66667C24.7964 2.66667 24 1.87022 24 0.888889C24 0.563556 24.0933 0.262222 24.2462 0H7.75378C7.90667 0.262222 8 0.563556 8 0.888889C8 1.87022 7.20356 2.66667 6.22222 2.66667C5.24089 2.66667 4.44444 1.87022 4.44444 0.888889C4.44444 0.563556 4.53778 0.262222 4.69067 0H1.77778C0.796444 0 0 0.796445 0 1.77778V11.5556H32V1.77778C32 0.796445 31.2036 0 30.2222 0Z" fill="#DD2F45"/><path d="M11.7174 4.0925C11.7174 3.64806 12.0019 3.39917 12.3841 3.39917C12.7654 3.39917 13.0499 3.64806 13.0499 4.0925V8.55206H14.6312C15.0845 8.55206 15.2801 8.88984 15.2712 9.19206C15.2534 9.48539 15.0223 9.77784 14.6312 9.77784H12.4108C11.9752 9.77784 11.7174 9.49428 11.7174 9.04984V4.0925ZM5.57522 4.0925C5.57522 3.64806 5.85966 3.39917 6.24188 3.39917C6.62411 3.39917 6.90855 3.64806 6.90855 4.0925V7.19295C6.90855 8.01073 7.43211 8.65873 8.27655 8.65873C9.08455 8.65873 9.63566 7.97517 9.63566 7.19295V4.0925C9.63566 3.64806 9.91922 3.39917 10.3014 3.39917C10.6837 3.39917 10.9681 3.64806 10.9681 4.0925V7.26406C10.9681 8.7565 9.74144 9.88539 8.27655 9.88539C6.79299 9.88539 5.57522 8.77428 5.57522 7.26406V4.0925ZM4.88011 8.00095C4.88011 9.49339 3.92988 9.8845 3.12099 9.8845C2.50855 9.8845 1.48633 9.6445 1.48633 8.87117C1.48633 8.63206 1.69077 8.32984 1.98411 8.32984C2.33966 8.32984 2.65077 8.65873 3.04988 8.65873C3.54766 8.65873 3.54766 8.1965 3.54766 7.91206V4.0925C3.54766 3.64806 3.83211 3.39917 4.21344 3.39917C4.59655 3.39917 4.88011 3.64806 4.88011 4.0925V8.00095Z" fill="#F5F8FA"/><path d="M28.4443 8.88881C28.4443 9.37947 28.8417 9.7777 29.3332 9.7777C29.8248 9.7777 30.2221 9.37947 30.2221 8.88881C30.2221 8.39814 29.8248 7.99992 29.3332 7.99992C28.8417 7.99992 28.4443 8.39814 28.4443 8.88881ZM28.4443 6.22214C28.4443 6.71281 28.8417 7.11103 29.3332 7.11103C29.8248 7.11103 30.2221 6.71281 30.2221 6.22214C30.2221 5.73147 29.8248 5.33325 29.3332 5.33325C28.8417 5.33325 28.4443 5.73147 28.4443 6.22214ZM25.7777 8.88881C25.7777 9.37947 26.175 9.7777 26.6666 9.7777C27.1581 9.7777 27.5554 9.37947 27.5554 8.88881C27.5554 8.39814 27.1581 7.99992 26.6666 7.99992C26.175 7.99992 25.7777 8.39814 25.7777 8.88881ZM25.7777 6.22214C25.7777 6.71281 26.175 7.11103 26.6666 7.11103C27.1581 7.11103 27.5554 6.71281 27.5554 6.22214C27.5554 5.73147 27.1581 5.33325 26.6666 5.33325C26.175 5.33325 25.7777 5.73147 25.7777 6.22214ZM23.111 8.88881C23.111 9.37947 23.5083 9.7777 23.9999 9.7777C24.4914 9.7777 24.8888 9.37947 24.8888 8.88881C24.8888 8.39814 24.4914 7.99992 23.9999 7.99992C23.5083 7.99992 23.111 8.39814 23.111 8.88881ZM23.111 6.22214C23.111 6.71281 23.5083 7.11103 23.9999 7.11103C24.4914 7.11103 24.8888 6.71281 24.8888 6.22214C24.8888 5.73147 24.4914 5.33325 23.9999 5.33325C23.5083 5.33325 23.111 5.73147 23.111 6.22214ZM20.4443 6.22214C20.4443 6.71281 20.8417 7.11103 21.3332 7.11103C21.8248 7.11103 22.2221 6.71281 22.2221 6.22214C22.2221 5.73147 21.8248 5.33325 21.3332 5.33325C20.8417 5.33325 20.4443 5.73147 20.4443 6.22214ZM20.4443 8.88881C20.4443 9.37947 20.8417 9.7777 21.3332 9.7777C21.8248 9.7777 22.2221 9.37947 22.2221 8.88881C22.2221 8.39814 21.8248 7.99992 21.3332 7.99992C20.8417 7.99992 20.4443 8.39814 20.4443 8.88881Z" fill="#F4ABBA"/></g><defs><clipPath id="clip0_914_3674"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['lock']         = '<svg id="lock" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3553)"><path d="M11.5554 2.66675C6.64606 2.66675 2.6665 6.6463 2.6665 11.5556V20.4445H6.22206V11.5556C6.22206 8.61075 8.6105 6.2223 11.5554 6.2223C14.5003 6.2223 16.8887 8.61075 16.8887 11.5556V20.4445H20.4443V11.5556C20.4443 6.6463 16.4647 2.66675 11.5554 2.66675Z" fill="#AAB8C2"/><path d="M23.1111 28.4444C23.1111 30.4079 21.5191 31.9999 19.5556 31.9999H3.55556C1.592 31.9999 0 30.4079 0 28.4444V17.7777C0 15.8142 1.592 14.2222 3.55556 14.2222H19.5556C21.5191 14.2222 23.1111 15.8142 23.1111 17.7777V28.4444Z" fill="#FFAC33"/><path d="M31.1113 8C31.1113 3.58133 27.53 0 23.1113 0C18.6927 0 15.1113 3.58133 15.1113 8C15.1113 11.4818 17.3398 14.4356 20.4447 15.5351V29.7778C20.4447 31.0053 21.4393 32 22.6669 32C23.7451 32 24.6429 31.232 24.8447 30.2133C24.8607 30.2142 24.8731 30.2222 24.8891 30.2222C25.3807 30.2222 25.778 29.8249 25.778 29.3333V28.4444C25.778 27.9529 25.3807 27.5556 24.8891 27.5556V26.6667C25.3807 26.6667 25.778 26.2693 25.778 25.7778V24C25.778 23.5084 25.3807 23.1111 24.8891 23.1111V21.0871C25.4189 20.7787 25.778 20.2124 25.778 19.5556V15.5351C28.8829 14.4364 31.1113 11.4827 31.1113 8ZM23.1113 1.77778C24.0927 1.77778 24.8891 2.57422 24.8891 3.55556C24.8891 4.53689 24.0927 5.33333 23.1113 5.33333C22.13 5.33333 21.3336 4.53689 21.3336 3.55556C21.3336 2.57422 22.13 1.77778 23.1113 1.77778Z" fill="#C1694F"/></g><defs><clipPath id="clip0_914_3553"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['search']       = '<svg id="search" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3559)"><path d="M24.3449 21.9039L21.8312 24.4177L17.4312 20.0177L19.9449 17.5039L24.3449 21.9039Z" fill="#9AAAB4"/><path d="M30.8292 25.8756L25.6034 20.6498C24.9092 19.9556 23.7838 19.9556 23.0896 20.6498L20.5758 23.1636C19.8816 23.8578 19.8816 24.9831 20.5758 25.6774L25.8016 30.9031C27.1901 32.2925 29.4425 32.2925 30.831 30.9031C32.2176 29.5156 32.2167 27.264 30.8292 25.8756Z" fill="#66757F"/><path d="M12.0767 24.1501C18.7041 24.1501 24.0767 18.7776 24.0767 12.1501C24.0767 5.52273 18.7041 0.150146 12.0767 0.150146C5.44924 0.150146 0.0766602 5.52273 0.0766602 12.1501C0.0766602 18.7776 5.44924 24.1501 12.0767 24.1501Z" fill="#8899A6"/><path d="M12.0763 20.5947C16.74 20.5947 20.5207 16.814 20.5207 12.1503C20.5207 7.48652 16.74 3.70581 12.0763 3.70581C7.41254 3.70581 3.63184 7.48652 3.63184 12.1503C3.63184 16.814 7.41254 20.5947 12.0763 20.5947Z" fill="#BBDDF5"/></g><defs><clipPath id="clip0_914_3559"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['chart']        = '<svg id="chart" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3643)"><path d="M27.5556 1.77783H4.4445C2.97161 1.77783 1.77783 2.97161 1.77783 4.4445V27.5556C1.77783 29.0285 2.97161 30.2223 4.4445 30.2223H27.5556C29.0285 30.2223 30.2223 29.0285 30.2223 27.5556V4.4445C30.2223 2.97161 29.0285 1.77783 27.5556 1.77783Z" fill="#CCD6DD"/><path d="M27.5553 0.888916H4.44423C2.48067 0.888916 0.888672 2.48092 0.888672 4.44447V27.5556C0.888672 29.5191 2.48067 31.1111 4.44423 31.1111H27.5553C29.5189 31.1111 31.1109 29.5191 31.1109 27.5556V4.44447C31.1109 2.48092 29.5189 0.888916 27.5553 0.888916ZM27.5553 2.66669C28.5358 2.66669 29.3331 3.46403 29.3331 4.44447V8.00003H23.9998V2.66669H27.5553ZM23.9998 16.8889H29.3331V22.2222H23.9998V16.8889ZM23.9998 15.1111V9.7778H29.3331V15.1111H23.9998ZM22.222 2.66669V8.00003H16.8887V2.66669H22.222ZM16.8887 9.7778H22.222V15.1111H16.8887V9.7778ZM16.8887 16.8889H22.222V22.2222H16.8887V16.8889ZM15.1109 2.66669V8.00003H9.77756V2.66669H15.1109ZM9.77756 9.7778H15.1109V15.1111H9.77756V9.7778ZM9.77756 16.8889H15.1109V22.2222H9.77756V16.8889ZM2.66645 4.44447C2.66645 3.46403 3.46378 2.66669 4.44423 2.66669H7.99978V8.00003H2.66645V4.44447ZM2.66645 9.7778H7.99978V15.1111H2.66645V9.7778ZM2.66645 16.8889H7.99978V22.2222H2.66645V16.8889ZM4.44423 29.3334C3.46378 29.3334 2.66645 28.536 2.66645 27.5556V24H7.99978V29.3334H4.44423ZM9.77756 29.3334V24H15.1109V29.3334H9.77756ZM16.8887 29.3334V24H22.222V29.3334H16.8887ZM27.5553 29.3334H23.9998V24H29.3331V27.5556C29.3331 28.536 28.5358 29.3334 27.5553 29.3334Z" fill="#E1E8ED"/><path d="M11.5555 29.3332H6.22217V14.2221C6.22217 13.2408 7.01861 12.4443 7.99995 12.4443H9.77772C10.7591 12.4443 11.5555 13.2408 11.5555 14.2221V29.3332Z" fill="#5C913B"/><path d="M25.7777 29.3333H20.4443V7.99995C20.4443 7.01861 21.2408 6.22217 22.2221 6.22217H23.9999C24.9812 6.22217 25.7777 7.01861 25.7777 7.99995V29.3333Z" fill="#3B94D9"/><path d="M18.6668 29.3334H13.3335V20.4445C13.3335 19.4632 14.1299 18.6667 15.1113 18.6667H16.8891C17.8704 18.6667 18.6668 19.4632 18.6668 20.4445V29.3334Z" fill="#DD2E44"/></g><defs><clipPath id="clip0_914_3643"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['computer']     = '<svg id="computer" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M30.2222 25.863C29.8516 25.007 29.4258 24.0781 28.4444 24.0781H27.5556C28.5369 24.0781 29.3333 23.279 29.3333 22.2933V7.11814C29.3333 6.13236 28.5369 5.33325 27.5556 5.33325H4.44444C3.46311 5.33325 2.66667 6.13236 2.66667 7.11814V22.2933C2.66667 23.279 3.46311 24.0781 4.44444 24.0781H3.55556C2.57422 24.0781 2.07378 24.9706 1.77778 25.863L0 30.2141C0 31.2008 0.796444 31.9999 1.77778 31.9999H30.2222C31.2036 31.9999 32 31.2008 32 30.215L30.2222 25.863Z" fill="#CCD6DD"/><path d="M0.00732422 30.2888L0.0126576 30.3395L0.163769 30.9546C0.444658 31.5697 1.05977 31.9999 1.77799 31.9999H30.2224C31.1789 31.9999 31.9531 31.2399 31.9931 30.2888H0.00732422Z" fill="#9AAAB4"/><path d="M27.5554 21.4C27.5554 21.8934 27.1581 22.2925 26.6666 22.2925H5.33322C4.84256 22.2925 4.44434 21.8934 4.44434 21.4V8.01158C4.44434 7.51825 4.84256 7.11914 5.33322 7.11914H26.6666C27.1581 7.11914 27.5554 7.51914 27.5554 8.01158V21.4Z" fill="#5DADEC"/><path d="M29.2499 27.5929L28.5743 25.6595C28.3619 25.2506 28.0099 24.9155 27.5183 24.9155H4.54232C4.05165 24.9155 3.73699 25.2782 3.51476 25.8364L2.90321 27.5937C2.70854 28.1235 3.30143 28.4862 3.7921 28.4862H10.5281C10.5281 28.4862 11.361 28.4444 11.5085 27.9457C11.6792 27.3697 11.8774 26.5022 11.9201 26.3493C11.9859 26.1146 12.265 25.8773 12.681 25.8773H20.3059C20.7503 25.8773 20.969 26.1022 21.0268 26.3804C21.0641 26.5617 21.3041 27.3946 21.4161 27.9644C21.5148 28.472 22.5014 28.4853 22.5014 28.4853H28.3628C28.8525 28.4853 29.4445 28.0666 29.2499 27.5929Z" fill="#AEBBC1"/><path d="M19.8888 29.4338H12.9724C12.6391 29.4338 12.4942 29.1289 12.5422 28.8338C12.5902 28.5396 12.8613 27.2401 12.8826 27.0889C12.9031 26.9369 13.1262 26.7556 13.3484 26.7556H19.5839C19.8479 26.7556 20.0195 26.9005 20.0728 27.1903C20.1253 27.4809 20.3413 28.6489 20.3582 28.9156C20.3751 29.1832 20.2079 29.4338 19.8888 29.4338Z" fill="#9AAAB4"/></svg>';
$config->ai->miniPrograms->iconList['cactus']       = '<svg id="cactus" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3516)"><path d="M18.1483 20.2062C17.9617 20.1289 16.5697 19.5556 15.7403 19.5556C13.9626 19.5556 11.5803 16 10.111 16C7.74034 16 6.00434 20.6444 4.44434 21.3707C3.1599 21.9689 2.64345 23.7582 2.43545 25.1004C2.2959 26.0036 2.2959 26.704 2.2959 26.704L18.1483 26.6667V20.2062Z" fill="#FFAC33"/><path d="M7.33312 10.6667C9.78771 10.6667 11.7776 8.67688 11.7776 6.22228C11.7776 3.76768 9.78771 1.77783 7.33312 1.77783C4.87852 1.77783 2.88867 3.76768 2.88867 6.22228C2.88867 8.67688 4.87852 10.6667 7.33312 10.6667Z" fill="#FFCC4D"/><path d="M7.33339 9.77786C9.29707 9.77786 10.8889 8.18598 10.8889 6.2223C10.8889 4.25862 9.29707 2.66675 7.33339 2.66675C5.36971 2.66675 3.77783 4.25862 3.77783 6.2223C3.77783 8.18598 5.36971 9.77786 7.33339 9.77786Z" fill="#FFAC33"/><path d="M16 22.3823C3.056 22.3823 0 26.5281 0 28.4445C0 30.361 1.592 32.0001 3.55556 32.0001H28.4444C30.408 32.0001 32 30.3548 32 28.4445C32 26.5343 28.944 22.3823 16 22.3823Z" fill="#FFE8B6"/><path d="M8.94499 19.9137C8.48632 21.1644 9.43832 21.9964 9.43832 21.9964C9.43832 21.9964 9.48988 21.3777 9.53876 20.5715C9.58854 19.7439 10.3201 19.1821 10.3459 18.8861C10.4303 17.8977 9.58676 17.1697 9.63032 17.5164C9.72276 18.2399 9.31299 18.9101 8.94499 19.9137ZM5.67299 22.1964C5.33965 22.8515 5.38765 24.415 5.38765 24.415C5.38765 24.415 6.18765 23.9448 6.22321 23.4604C6.25876 22.9759 6.23565 22.719 6.34588 22.4381C6.65876 21.6381 7.34499 21.6897 7.76365 20.5821C7.9121 20.191 7.59121 19.5128 7.49699 19.7341C7.13254 20.5866 6.00721 21.5412 5.67299 22.1964ZM11.0463 21.8968C10.9432 21.6106 11.1565 19.783 11.3379 20.0301C11.5192 20.2772 11.3325 21.0621 11.9281 21.7066C12.6721 22.511 12.569 23.4675 12.3645 23.0381C12.1592 22.6079 11.1494 22.183 11.0463 21.8968Z" fill="#F4900C"/><path d="M18.1485 24.7954V22.4914C16.1369 22.151 7.90495 21.071 2.4365 25.1012C2.28273 25.215 2.27295 25.4594 2.27295 25.5377C2.27295 26.5261 5.61784 25.2337 9.65962 25.6959C11.6018 25.9181 13.7601 26.0754 14.3334 25.6497C14.5272 25.5057 14.0418 25.0034 13.1316 24.551C13.5876 24.4337 14.0605 24.3288 14.6018 24.335C16.3645 24.351 17.5352 24.6123 18.1485 24.7954Z" fill="#FFAC33"/><path d="M14.6977 10.8214C15.9404 10.8214 16.9199 11.8303 16.9199 13.0747V18.2143C16.9199 18.8258 17.8088 19.3174 17.8088 19.5929V10.1698C17.8088 8.30317 19.4977 6.79028 21.3644 6.79028C23.2311 6.79028 24.9199 8.30317 24.9199 10.1698V21.8774C25.8088 21.6098 25.8088 21.1049 25.8088 20.4667V17.5805C25.8088 16.3361 26.7875 15.3272 28.0311 15.3272C29.2746 15.3272 30.2533 16.3361 30.2533 17.5805V21.5227C30.2533 22.7663 29.4177 23.7049 28.5013 24.233C27.8017 24.6374 25.8088 25.1343 24.9199 25.1636V27.8516C24.9199 29.6294 17.8088 29.6294 17.8088 27.8516V22.9032C16.9199 22.8365 14.9777 22.3663 14.3093 21.9805C13.3937 21.4525 12.4746 20.5147 12.4746 19.2694V13.0738C12.4755 11.8303 13.4524 10.8214 14.6977 10.8214Z" fill="#77B255"/><path d="M28.8892 24.3395C29.2005 24.3395 29.4528 24.0872 29.4528 23.776C29.4528 23.4647 29.2005 23.2124 28.8892 23.2124C28.578 23.2124 28.3257 23.4647 28.3257 23.776C28.3257 24.0872 28.578 24.3395 28.8892 24.3395Z" fill="#3E721D"/><path d="M26.6368 20.3964C26.948 20.3964 27.2004 20.1441 27.2004 19.8328C27.2004 19.5216 26.948 19.2693 26.6368 19.2693C26.3256 19.2693 26.0732 19.5216 26.0732 19.8328C26.0732 20.1441 26.3256 20.3964 26.6368 20.3964Z" fill="#3E721D"/><path d="M30.5787 19.2702C30.8899 19.2702 31.1422 19.0179 31.1422 18.7066C31.1422 18.3954 30.8899 18.1431 30.5787 18.1431C30.2675 18.1431 30.0151 18.3954 30.0151 18.7066C30.0151 19.0179 30.2675 19.2702 30.5787 19.2702Z" fill="#3E721D"/><path d="M15.3717 22.6496C15.6829 22.6496 15.9352 22.3973 15.9352 22.086C15.9352 21.7748 15.6829 21.5225 15.3717 21.5225C15.0604 21.5225 14.8081 21.7748 14.8081 22.086C14.8081 22.3973 15.0604 22.6496 15.3717 22.6496Z" fill="#3E721D"/><path d="M13.6822 18.144C13.9935 18.144 14.2458 17.8916 14.2458 17.5804C14.2458 17.2692 13.9935 17.0168 13.6822 17.0168C13.371 17.0168 13.1187 17.2692 13.1187 17.5804C13.1187 17.8916 13.371 18.144 13.6822 18.144Z" fill="#3E721D"/><path d="M15.9351 15.3278C16.2464 15.3278 16.4987 15.0755 16.4987 14.7642C16.4987 14.453 16.2464 14.2007 15.9351 14.2007C15.6239 14.2007 15.3716 14.453 15.3716 14.7642C15.3716 15.0755 15.6239 15.3278 15.9351 15.3278Z" fill="#3E721D"/><path d="M12.5557 13.6381C12.867 13.6381 13.1193 13.3858 13.1193 13.0745C13.1193 12.7633 12.867 12.511 12.5557 12.511C12.2445 12.511 11.9922 12.7633 11.9922 13.0745C11.9922 13.3858 12.2445 13.6381 12.5557 13.6381Z" fill="#3E721D"/><path d="M19.314 26.9181C19.6253 26.9181 19.8776 26.6658 19.8776 26.3546C19.8776 26.0433 19.6253 25.791 19.314 25.791C19.0028 25.791 18.7505 26.0433 18.7505 26.3546C18.7505 26.6658 19.0028 26.9181 19.314 26.9181Z" fill="#3E721D"/><path d="M24.3824 23.7758C24.6936 23.7758 24.946 23.5235 24.946 23.2122C24.946 22.901 24.6936 22.6487 24.3824 22.6487C24.0712 22.6487 23.8188 22.901 23.8188 23.2122C23.8188 23.5235 24.0712 23.7758 24.3824 23.7758Z" fill="#3E721D"/><path d="M20.441 20.3964C20.7522 20.3964 21.0046 20.1441 21.0046 19.8328C21.0046 19.5216 20.7522 19.2693 20.441 19.2693C20.1298 19.2693 19.8774 19.5216 19.8774 19.8328C19.8774 20.1441 20.1298 20.3964 20.441 20.3964Z" fill="#3E721D"/><path d="M23.8204 18.144C24.1316 18.144 24.3839 17.8916 24.3839 17.5804C24.3839 17.2692 24.1316 17.0168 23.8204 17.0168C23.5091 17.0168 23.2568 17.2692 23.2568 17.5804C23.2568 17.8916 23.5091 18.144 23.8204 18.144Z" fill="#3E721D"/><path d="M19.8775 14.2016C20.1888 14.2016 20.4411 13.9493 20.4411 13.638C20.4411 13.3268 20.1888 13.0745 19.8775 13.0745C19.5663 13.0745 19.314 13.3268 19.314 13.638C19.314 13.9493 19.5663 14.2016 19.8775 14.2016Z" fill="#3E721D"/><path d="M24.9459 12.5119C25.2571 12.5119 25.5094 12.2596 25.5094 11.9483C25.5094 11.6371 25.2571 11.3848 24.9459 11.3848C24.6346 11.3848 24.3823 11.6371 24.3823 11.9483C24.3823 12.2596 24.6346 12.5119 24.9459 12.5119Z" fill="#3E721D"/><path d="M18.7506 9.04435C19.0618 9.04435 19.3141 8.79204 19.3141 8.48079C19.3141 8.16955 19.0618 7.91724 18.7506 7.91724C18.4393 7.91724 18.187 8.16955 18.187 8.48079C18.187 8.79204 18.4393 9.04435 18.7506 9.04435Z" fill="#3E721D"/><path d="M13.1211 24.5475C13.1211 24.5475 12.1185 24.2302 11.5353 24.1467C10.9522 24.0631 13.8358 23.9058 15.1851 24.3458C13.8358 24.3244 13.1211 24.5475 13.1211 24.5475Z" fill="#F4900C"/></g><defs><clipPath id="clip0_914_3516"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['palette']      = '<svg id="palette" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M16 2.7937C7.16356 2.7937 0 8.93414 0 16.5075C0 17.455 0.112 18.3804 0.326222 19.2737C1.90756 21.9946 3.00178 20.2773 8 17.7777C13.0907 15.2319 8 21.3333 6.22222 24.8888C5.67556 25.9821 5.97156 26.9075 6.72 27.6657C9.33867 29.2693 12.5369 30.2221 16 30.2221C24.8364 30.2221 32 24.0826 32 16.5075C32 8.93414 24.8364 2.7937 16 2.7937ZM18.5324 24.5244C18.1813 25.7208 16.3458 26.2346 14.432 25.6719C12.5182 25.1101 11.2516 23.6861 11.6027 22.4888C11.9538 21.2924 13.7893 20.7786 15.7031 21.3421C17.6169 21.903 18.8836 23.327 18.5324 24.5244Z" fill="#D99E82"/><path d="M8.88883 12.4444C10.3616 12.4444 11.5555 11.2505 11.5555 9.77775C11.5555 8.30499 10.3616 7.11108 8.88883 7.11108C7.41608 7.11108 6.22217 8.30499 6.22217 9.77775C6.22217 11.2505 7.41608 12.4444 8.88883 12.4444Z" fill="#5C913B"/><path d="M17.778 10.6666C19.2508 10.6666 20.4447 9.47268 20.4447 7.99992C20.4447 6.52716 19.2508 5.33325 17.778 5.33325C16.3052 5.33325 15.1113 6.52716 15.1113 7.99992C15.1113 9.47268 16.3052 10.6666 17.778 10.6666Z" fill="#226699"/><path d="M25.778 16.0001C27.2508 16.0001 28.4447 14.8062 28.4447 13.3334C28.4447 11.8607 27.2508 10.6667 25.778 10.6667C24.3052 10.6667 23.1113 11.8607 23.1113 13.3334C23.1113 14.8062 24.3052 16.0001 25.778 16.0001Z" fill="#DD2E44"/><path d="M24.8888 24.0001C26.3616 24.0001 27.5555 22.8062 27.5555 21.3334C27.5555 19.8607 26.3616 18.6667 24.8888 18.6667C23.4161 18.6667 22.2222 19.8607 22.2222 21.3334C22.2222 22.8062 23.4161 24.0001 24.8888 24.0001Z" fill="#FFCC4D"/></svg>';
$config->ai->miniPrograms->iconList['airplane']     = '<svg id="airplane" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3540)"><path d="M26.6665 21.1804C26.319 21.5288 25.7572 21.5288 25.4097 21.1804L24.1528 19.9235C23.8043 19.5759 23.8043 19.0133 24.1528 18.6666L26.6665 16.1528C27.0141 15.8053 27.5759 15.8053 27.9234 16.1528L29.1803 17.4097C29.5288 17.7573 29.5288 18.3199 29.1803 18.6666L26.6665 21.1804ZM13.3332 7.84706C12.9857 8.1955 12.4239 8.1955 12.0763 7.84706L10.8194 6.59017C10.471 6.24262 10.471 5.68084 10.8194 5.33328L13.3332 2.8195C13.6808 2.47195 14.2425 2.47195 14.5901 2.8195L15.847 4.07639C16.1954 4.42395 16.1954 4.98573 15.847 5.33328L13.3332 7.84706Z" fill="#66757F"/><path d="M1.77794 19.5555C3.55571 19.5555 11.5557 20.4444 11.5557 20.4444C11.5557 20.4444 12.4446 28.4444 12.4446 30.2222C12.4446 31.9999 10.6668 31.9999 9.77794 31.111C8.88905 30.2222 6.22238 25.7777 6.22238 25.7777C6.22238 25.7777 1.77794 23.111 0.889046 22.2222C0.000157356 21.3333 0.000157356 19.5555 1.77794 19.5555ZM3.55571 5.36793C6.22238 5.33326 25.7779 6.22215 25.7779 6.22215C25.7779 6.22215 26.5993 25.7777 26.633 28.4444C26.6668 31.111 24.177 32.0017 23.2002 28.4453C22.2233 24.8888 18.6668 13.3333 18.6668 13.3333C18.6668 13.3333 6.26238 9.40704 3.55127 8.79815C0.000157237 7.99993 0.888157 5.40171 3.55571 5.36793Z" fill="#55ACEE"/><path d="M23.9998 2.66678C25.7776 0.888999 30.222 0.000109673 31.1109 0.888999C31.9998 1.77789 31.1109 6.22233 29.3331 8.00011C27.5554 9.77789 12.4443 24.0001 12.4443 24.0001C12.4443 24.0001 6.66648 28.0001 5.33314 26.6668C3.99981 25.3334 7.99981 19.5557 7.99981 19.5557C7.99981 19.5557 22.222 4.44455 23.9998 2.66678Z" fill="#CCD6DD"/><path d="M12.4444 19.5556C12.4444 19.5556 12.8888 20.0001 8.88882 24.0001C4.88882 28.0001 4.44438 27.5556 4.44438 27.5556C4.44438 27.5556 3.99994 27.1112 7.99994 23.1112C11.9999 19.1112 12.4444 19.5556 12.4444 19.5556ZM25.7777 3.55564C27.2506 3.55564 28.4444 4.74941 28.4444 6.2223H29.1599C29.2613 5.9423 29.3333 5.64897 29.3333 5.33341C29.3333 3.86053 28.1395 2.66675 26.6666 2.66675C26.351 2.66675 26.0577 2.73875 25.7777 2.84008V3.55564Z" fill="#66757F"/></g><defs><clipPath id="clip0_914_3540"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['pushpin']      = '<svg id="pushpin" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3509)"><path d="M21.023 20.7084L11.2905 10.9759L19.6336 4.02393L27.9759 12.3661L21.023 20.7084Z" fill="#BE1931"/><path d="M30.7554 12.3662C29.2203 13.9031 26.7305 13.9031 25.1954 12.3662L19.6336 6.80531C18.0967 5.2702 18.0967 2.77864 19.6336 1.24264C21.1678 -0.292469 23.6585 -0.292469 25.1954 1.24264L30.7554 6.80531C32.2914 8.34042 32.2914 10.8311 30.7554 12.3662Z" fill="#DD2E44"/><path d="M12.4444 15.8428C12.4444 15.8428 -0.527182 31.137 0.16704 31.8339C0.862151 32.5299 16.1573 19.5557 16.1573 19.5557L12.4444 15.8428Z" fill="#99AAB5"/><path d="M22.4133 24.881C20.8791 26.4179 18.3884 26.4179 16.8507 24.881L7.11911 15.1476C5.584 13.6116 5.584 11.1227 7.11911 9.58675C8.65511 8.04986 11.1458 8.04986 12.6818 9.58675L22.4133 19.3192C23.9493 20.8561 23.9493 23.3441 22.4133 24.881Z" fill="#DD2E44"/></g><defs><clipPath id="clip0_914_3509"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['shoppingcart'] = '<svg id="shoppingcart" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M27.5556 19.5556H9.77778L8 8.88892H29.3333L27.5556 19.5556Z" fill="#CCD6DD"/><path d="M29.3192 24.0001H9.76361C8.79117 24.0001 8.00005 23.2081 8.00005 22.2365C8.00005 21.2649 8.80539 20.4445 9.77783 20.4445L9.78405 20.4436L9.79117 20.4445H27.5556C27.9903 20.4445 28.3609 20.1298 28.4321 19.7014L30.2098 9.03472C30.2534 8.77694 30.1805 8.51383 30.0107 8.31383C29.8427 8.11472 29.5947 8.00005 29.3334 8.00005H8.72628L7.80183 2.51917C7.73161 2.09872 7.37161 1.81517 6.9645 1.79561C6.95028 1.79294 6.9405 1.77783 6.92628 1.77783H2.66672C2.17605 1.77783 1.77783 2.17605 1.77783 2.66672C1.77783 3.15739 2.17605 3.55561 2.66672 3.55561H6.17428L8.75472 18.8587C7.29517 19.2969 6.22228 20.6365 6.22228 22.2365C6.22228 24.1894 7.81161 25.7778 9.76361 25.7778H29.3192C29.8107 25.7778 30.2081 25.3805 30.2081 24.8889C30.2081 24.3974 29.8107 24.0001 29.3192 24.0001ZM27.3956 15.1112H24.4561L24.6987 13.3334H27.6907L27.3956 15.1112ZM22.6614 15.1112H19.5556V13.3334H22.9041L22.6614 15.1112ZM17.7778 15.1112H14.6721L14.4294 13.3334H17.7778V15.1112ZM12.8783 15.1112H9.93872L9.64272 13.3334H12.6356L12.8783 15.1112ZM10.5307 18.6667L10.2347 16.8889H13.1209L13.3636 18.6667H10.5307ZM15.1583 18.6667L14.9156 16.8889H17.7778V18.6667H15.1583ZM19.5556 18.6667V16.8889H22.4178L22.1752 18.6667H19.5556ZM23.9707 18.6667L24.2134 16.8889H27.0996L26.8036 18.6667H23.9707ZM28.2836 9.77783L27.9876 11.5556H24.9423L25.1849 9.77783H28.2836ZM23.3903 9.77783L23.1476 11.5556H19.5556V9.77783H23.3903ZM17.7778 9.77783V11.5556H14.1858L13.9432 9.77783H17.7778ZM12.1485 9.77783L12.3912 11.5556H9.34494L9.04894 9.77783H12.1485Z" fill="#66757F"/><path d="M12.4445 30.2222C13.9173 30.2222 15.1112 29.0283 15.1112 27.5556C15.1112 26.0828 13.9173 24.8889 12.4445 24.8889C10.9717 24.8889 9.77783 26.0828 9.77783 27.5556C9.77783 29.0283 10.9717 30.2222 12.4445 30.2222Z" fill="#E1E8ED"/><path d="M12.4442 31.1111C10.4833 31.1111 8.88867 29.5164 8.88867 27.5556C8.88867 25.5947 10.4833 24 12.4442 24C14.4051 24 15.9998 25.5947 15.9998 27.5556C15.9998 29.5164 14.4051 31.1111 12.4442 31.1111ZM12.4442 25.7778C11.4638 25.7778 10.6664 26.5751 10.6664 27.5556C10.6664 28.536 11.4638 29.3333 12.4442 29.3333C13.4247 29.3333 14.222 28.536 14.222 27.5556C14.222 26.5751 13.4247 25.7778 12.4442 25.7778Z" fill="#292F33"/><path d="M24.8888 30.2222C26.3616 30.2222 27.5555 29.0283 27.5555 27.5556C27.5555 26.0828 26.3616 24.8889 24.8888 24.8889C23.4161 24.8889 22.2222 26.0828 22.2222 27.5556C22.2222 29.0283 23.4161 30.2222 24.8888 30.2222Z" fill="#E1E8ED"/><path d="M24.8891 31.1111C22.9282 31.1111 21.3335 29.5164 21.3335 27.5556C21.3335 25.5947 22.9282 24 24.8891 24C26.8499 24 28.4446 25.5947 28.4446 27.5556C28.4446 29.5164 26.8499 31.1111 24.8891 31.1111ZM24.8891 25.7778C23.9086 25.7778 23.1113 26.5751 23.1113 27.5556C23.1113 28.536 23.9086 29.3333 24.8891 29.3333C25.8695 29.3333 26.6668 28.536 26.6668 27.5556C26.6668 26.5751 25.8695 25.7778 24.8891 25.7778Z" fill="#292F33"/></svg>';
$config->ai->miniPrograms->iconList['gift']         = '<svg id="gift" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3496)"><path d="M29.3332 27.5556C29.3332 29.5111 27.7332 31.1111 25.7776 31.1111H6.22206C4.2665 31.1111 2.6665 29.5111 2.6665 27.5556V12.4445C2.6665 10.4889 4.2665 8.88892 6.22206 8.88892H25.7776C27.7332 8.88892 29.3332 10.4889 29.3332 12.4445V27.5556Z" fill="#FDD888"/><path d="M32 9.77772C32 11.7333 30.4 13.3333 28.4444 13.3333H3.55556C1.6 13.3333 0 11.7333 0 9.77772C0 7.82217 1.6 6.22217 3.55556 6.22217H28.4444C30.4 6.22217 32 7.82217 32 9.77772Z" fill="#FDD888"/><path d="M2.6665 13.3333H29.3332V15.111H2.6665V13.3333Z" fill="#FCAB40"/><path d="M16.8888 2.66675H15.111C13.6381 2.66675 12.4443 3.86053 12.4443 5.33341V31.1112H19.5554V5.33341C19.5554 3.86141 18.3617 2.66675 16.8888 2.66675Z" fill="#DA2F47"/><path d="M14.222 6.22228C15.1998 6.22228 15.3447 5.76362 14.5429 5.20273L8.56777 1.01962C7.766 0.458729 6.71444 0.694284 6.22911 1.54317L4.43711 4.67917C3.95177 5.52806 4.35533 6.22228 5.33311 6.22228H14.222ZM17.7776 6.22228C16.7998 6.22228 16.6549 5.76362 17.4567 5.20273L23.4327 1.01962C24.2336 0.458729 25.286 0.694284 25.7713 1.54317L27.5633 4.67828C28.0478 5.52806 27.6442 6.22228 26.6664 6.22228H17.7776Z" fill="#DA2F47"/></g><defs><clipPath id="clip0_914_3496"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['scientist']    = '<svg id="scientist" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3605)"><path d="M31.0589 32V28.0107C31.0589 25.0649 27.7833 23.1218 24.8366 23.1218H14.17C11.2251 23.1218 7.94775 25.0649 7.94775 28.0107V32H31.0589Z" fill="#CCD6DD"/><path d="M19.4552 3.62744C23.1032 3.62744 29.1859 5.45233 29.1859 13.3581C29.1859 21.2648 29.1859 23.0897 27.361 23.0897C25.5361 23.0897 23.1032 21.2648 19.4544 21.2648C15.8055 21.2648 13.4232 23.0897 11.5477 23.0897C9.5148 23.0897 9.7228 15.791 9.7228 13.3581C9.7228 5.45233 15.8055 3.62744 19.4552 3.62744Z" fill="#292F33"/><path d="M16.2402 25.3245C17.5433 26.2702 21.4545 26.2702 22.7576 25.3245V20.2898H16.2402V25.3245Z" fill="#F7DECE"/><path d="M16.2349 21.5021C17.1433 22.5297 18.2704 22.8079 19.4953 22.8079C20.7211 22.8079 21.8482 22.5306 22.7575 21.5021V18.8923H16.2349V21.5021Z" fill="#EEC2AD"/><path d="M12.1558 13.0925C12.1558 7.90668 15.4233 3.70312 19.4544 3.70312C23.4838 3.70312 26.7513 7.90757 26.7513 13.0925C26.7513 18.2773 23.4838 22.2338 19.4544 22.2338C15.4242 22.2347 12.1558 18.2773 12.1558 13.0925Z" fill="#F7DECE"/><path d="M19.4553 20.049C18.0277 20.049 17.2802 19.3423 17.2002 19.2623C16.9619 19.0241 16.9619 18.6392 17.2002 18.4028C17.4366 18.1663 17.8153 18.1646 18.0544 18.3957C18.0855 18.425 18.5441 18.833 19.4553 18.833C20.3779 18.833 20.8375 18.4126 20.8562 18.3957C21.0988 18.1681 21.481 18.1752 21.7122 18.4134C21.9433 18.6517 21.9433 19.0277 21.7086 19.2623C21.6286 19.3423 20.8819 20.049 19.4553 20.049Z" fill="#DF1F32"/><path d="M10.3706 16.0106C10.352 15.1217 10.3315 15.8115 10.3315 15.5973C10.3315 12.5555 12.1564 16.0364 12.1564 13.8702C12.1564 11.7022 13.3724 11.4853 14.5884 10.2693C15.1973 9.66128 16.4133 8.46839 16.4133 8.46839C16.4133 8.46839 19.4542 10.3057 21.8871 10.3057C24.3191 10.3057 26.7529 11.5279 26.7529 13.9608C26.7529 16.3928 28.5777 12.5528 28.5777 15.5937C28.5777 15.8106 28.5582 15.1217 28.5422 16.0106H29.1813C29.1866 14.2328 29.1866 14.3004 29.1866 13.1644C29.1866 5.25772 23.1049 2.31372 19.4551 2.31372C15.8071 2.31372 9.72441 5.20883 9.72441 13.1155C9.72441 13.8204 9.70664 14.2328 9.73152 16.0106H10.3706Z" fill="#292F33"/><path d="M13.6765 13.2861C13.6765 14.5733 13.024 15.6168 12.2196 15.6168C11.4151 15.6168 10.7627 14.5733 10.7627 13.2861C10.7627 11.999 11.4151 10.9546 12.2196 10.9546C13.024 10.9546 13.6765 11.999 13.6765 13.2861ZM28.2436 13.2861C28.2436 14.5733 27.592 15.6168 26.7867 15.6168C25.9823 15.6168 25.3298 14.5733 25.3298 13.2861C25.3298 11.999 25.9814 10.9546 26.7867 10.9546C27.592 10.9546 28.2436 11.999 28.2436 13.2861Z" fill="#F7DECE"/><path d="M16.4888 15.0204C16.0755 15.0204 15.7368 14.6817 15.7368 14.2675V13.5164C15.7368 13.1031 16.0755 12.7644 16.4888 12.7644C16.903 12.7644 17.2417 13.1031 17.2417 13.5164V14.2675C17.2408 14.6826 16.903 15.0204 16.4888 15.0204ZM22.5021 15.0204C22.0888 15.0204 21.7501 14.6817 21.7501 14.2675V13.5164C21.7501 13.1031 22.0888 12.7644 22.5021 12.7644C22.9155 12.7644 23.2541 13.1031 23.2541 13.5164V14.2675C23.2533 14.6826 22.9146 15.0204 22.5021 15.0204Z" fill="#662113"/><path d="M20.2464 17.344H18.7442C18.5371 17.344 18.3682 17.176 18.3682 16.9671V16.832C18.3682 16.624 18.5362 16.4551 18.7442 16.4551H20.2464C20.4535 16.4551 20.6233 16.624 20.6233 16.832V16.9671C20.6233 17.1751 20.4544 17.344 20.2464 17.344Z" fill="#C1694F"/><path d="M16.8891 32.0001L15.9478 23.8054C15.9478 23.8054 17.2011 25.2676 19.5033 25.2676C21.8055 25.2676 23.2535 23.8054 23.2535 23.8054L22.1673 32.0001H16.8891Z" fill="#66757F"/><path d="M15.9474 22.4443C16.4514 22.9474 18.5421 31.9999 18.5421 31.9999H15.7367L14.2221 29.7226L15.7367 27.2026L13.9438 26.639L14.1696 23.1217C14.1696 23.1217 15.7065 22.2034 15.9474 22.4443ZM23.0532 22.4443C22.5492 22.9474 20.4585 31.9999 20.4585 31.9999H23.2638L24.7785 29.7226L23.2638 27.2026L25.0567 26.639L24.831 23.1217C24.831 23.1217 23.2932 22.2034 23.0532 22.4443Z" fill="#F5F8FA"/><path opacity="0.4" d="M13.1138 11.3333H26.0027V15.9999H13.1138V11.3333Z" fill="white"/><path d="M25.7777 10.6667H13.3332C12.4443 10.6667 12.4443 11.5556 12.4443 11.5556V15.1112C12.4443 16.4099 14.5181 16.889 15.9999 16.889C17.4817 16.889 18.3101 16.0001 19.5554 16.0001C20.8008 16.0001 21.6292 16.889 23.111 16.889C24.5928 16.889 26.6666 16.4099 26.6666 15.1112V11.5556C26.6666 10.6659 25.7777 10.6667 25.7777 10.6667ZM25.7777 14.2223C25.7777 15.4001 25.0203 16.0001 23.111 16.0001C21.743 16.0001 20.6186 15.1112 19.5554 15.1112C18.4923 15.1112 17.3679 16.0001 15.9999 16.0001C14.0906 16.0001 13.3332 15.4001 13.3332 14.2223V11.5556H25.7777V14.2223Z" fill="#F5F8FA"/><path d="M6.22238 10.6667C6.7133 10.6667 7.11127 10.2687 7.11127 9.7778C7.11127 9.28689 6.7133 8.88892 6.22238 8.88892C5.73147 8.88892 5.3335 9.28689 5.3335 9.7778C5.3335 10.2687 5.73147 10.6667 6.22238 10.6667Z" fill="#9266CC"/><path d="M8.00022 15.111C8.49114 15.111 8.88911 14.7131 8.88911 14.2221C8.88911 13.7312 8.49114 13.3333 8.00022 13.3333C7.5093 13.3333 7.11133 13.7312 7.11133 14.2221C7.11133 14.7131 7.5093 15.111 8.00022 15.111Z" fill="#9266CC"/><path d="M4.889 14.2223C5.62538 14.2223 6.22233 13.6254 6.22233 12.889C6.22233 12.1526 5.62538 11.5557 4.889 11.5557C4.15262 11.5557 3.55566 12.1526 3.55566 12.889C3.55566 13.6254 4.15262 14.2223 4.889 14.2223Z" fill="#9266CC"/><path d="M8.88889 16H4.44444C4.44444 16 2.66667 16 2.66667 17.7778C2.66667 19.5556 4.44444 19.5556 4.44444 19.5556V24L0.888889 28.4444C0.104 29.4258 0 30.0631 0 30.2222C0 32 1.77778 32 1.77778 32H11.5556C11.5556 32 13.3333 32 13.3333 30.2222C13.3333 30.1031 13.4693 29.7253 12.4444 28.4444L8.88889 24V19.5556C8.88889 19.5556 10.6667 19.5556 10.6667 17.7778C10.6667 16 8.88889 16 8.88889 16Z" fill="#A8BCCC"/><path d="M8.00011 24.312V18.6667H8.889C9.28811 18.656 9.77789 18.4942 9.77789 17.7778C9.77789 17.064 9.29166 16.9005 8.88189 16.8889H4.44455C4.04455 16.8996 3.55566 17.0614 3.55566 17.7778C3.55566 18.4942 4.04455 18.656 4.45522 18.6667L5.32189 18.688L5.33344 24.312L3.64989 26.4169L6.66677 29.528L9.68366 26.4169L8.00011 24.312Z" fill="#E1E8ED"/><path d="M0.888184 30.2525C0.889072 30.9388 1.37796 31.1005 1.78863 31.1112H11.5557C11.9549 31.1005 12.4446 30.9388 12.4446 30.2223V30.1859L12.45 30.113C12.45 30.1103 12.4011 29.8134 11.7504 29.0001L9.68374 26.417H3.64996L1.58329 29.0001C0.944184 29.7992 0.888184 30.2481 0.888184 30.2525Z" fill="#9266CC"/></g><defs><clipPath id="clip0_914_3605"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconList['technologist'] = '<svg id="technologist" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_914_3627)"><path d="M31.1111 32V25.7778C31.1111 22.8311 27.8356 20.8889 24.8889 20.8889H14.2222C11.2773 20.8889 8 22.8311 8 25.7778V32H31.1111Z" fill="#9266CC"/><path d="M19.5055 1.39478C23.1553 1.39478 29.2371 3.21966 29.2371 11.1263C29.2371 19.033 29.2371 20.8579 27.4122 20.8579C25.5864 20.8579 23.1544 19.033 19.5046 19.033C15.8558 19.033 13.4744 20.8579 11.598 20.8579C9.56509 20.8579 9.77309 13.5592 9.77309 11.1263C9.77487 3.21966 15.8566 1.39478 19.5055 1.39478Z" fill="#292F33"/><path d="M16.2915 20.9067C16.2915 22.2223 18.2222 22.6667 19.5555 22.6667C20.8888 22.6667 22.8088 22.2223 22.8088 20.9067V18.0579H16.2915V20.9067Z" fill="#F7DECE"/><path d="M16.2852 19.2702C17.1945 20.2968 18.3216 20.5751 19.5465 20.5751C20.7723 20.5751 21.8994 20.2977 22.8087 19.2702V16.6604H16.2852V19.2702Z" fill="#EEC2AD"/><path d="M12.208 10.8595C12.208 5.67377 15.4756 1.47021 19.5058 1.47021C23.536 1.47021 26.8045 5.67377 26.8045 10.8595C26.8045 16.0444 23.536 20.0027 19.5058 20.0027C15.4756 20.0027 12.208 16.0453 12.208 10.8595Z" fill="#F7DECE"/><path d="M19.5056 17.816C18.079 17.816 17.3314 17.1103 17.2514 17.0294C17.0132 16.792 17.0132 16.4072 17.2514 16.1698C17.4879 15.9343 17.8665 15.9325 18.1048 16.1636C18.1359 16.192 18.5963 16.6 19.5056 16.6C20.4292 16.6 20.8896 16.1796 20.9074 16.1627C21.1501 15.9352 21.5323 15.9423 21.7634 16.1805C21.9945 16.4196 21.9945 16.7947 21.7599 17.0294C21.6808 17.1103 20.9341 17.816 19.5056 17.816Z" fill="#DF1F32"/><path d="M10.4224 13.7777C10.4037 12.8888 10.3833 13.5786 10.3833 13.3644C10.3833 10.3226 12.2082 13.8035 12.2082 11.6373C12.2082 9.46926 13.4242 9.25237 14.6402 8.03637C15.2491 7.42748 16.4651 6.23548 16.4651 6.23548C16.4651 6.23548 19.5059 8.07281 21.9388 8.07281C24.3708 8.07281 26.8046 9.29503 26.8046 11.7279C26.8046 14.1608 28.6295 10.3199 28.6295 13.3608C28.6295 13.5777 28.6099 12.8888 28.5939 13.7777H29.2322C29.2384 11.9999 29.2384 12.0675 29.2384 10.9315C29.2384 3.02481 23.1557 0.0808105 19.5068 0.0808105C15.8579 0.0808105 9.77617 2.97592 9.77617 10.8826C9.77617 11.5875 9.75839 11.9999 9.78328 13.7777H10.4224Z" fill="#292F33"/><path d="M16.5406 12.7876C16.1272 12.7876 15.7886 12.4489 15.7886 12.0356V11.2845C15.7886 10.8711 16.1272 10.5325 16.5406 10.5325C16.9539 10.5325 17.2935 10.8711 17.2935 11.2845V12.0356C17.2935 12.4489 16.9539 12.7876 16.5406 12.7876ZM22.5539 12.7876C22.1406 12.7876 21.8019 12.4489 21.8019 12.0356V11.2845C21.8019 10.8711 22.1406 10.5325 22.5539 10.5325C22.9672 10.5325 23.3059 10.8711 23.3059 11.2845V12.0356C23.3059 12.4489 22.9672 12.7876 22.5539 12.7876Z" fill="#662113"/><path d="M20.2995 15.1111H18.7964C18.5893 15.1111 18.4204 14.9422 18.4204 14.7351V14.5991C18.4204 14.3919 18.5884 14.2222 18.7964 14.2222H20.2995C20.5057 14.2222 20.6755 14.3911 20.6755 14.5991V14.7351C20.6755 14.9422 20.5057 15.1111 20.2995 15.1111Z" fill="#C1694F"/><path d="M13.7282 11.9431C13.7282 13.2302 13.0758 14.2738 12.2713 14.2738C11.4669 14.2738 10.8145 13.2302 10.8145 11.9431C10.8145 10.656 11.4669 9.61157 12.2713 9.61157C13.0758 9.61068 13.7282 10.6551 13.7282 11.9431ZM28.2962 11.9431C28.2962 13.2302 27.6447 14.2738 26.8393 14.2738C26.0349 14.2738 25.3825 13.2302 25.3825 11.9431C25.3825 10.656 26.034 9.61157 26.8393 9.61157C27.6447 9.61068 28.2962 10.6551 28.2962 11.9431Z" fill="#F7DECE"/><path d="M29.3332 31.1111C29.3332 31.6026 28.9358 31.9999 28.4443 31.9999H19.5554C19.0638 31.9999 18.6665 31.6026 18.6665 31.1111C18.6665 30.6195 19.0638 30.2222 19.5554 30.2222H28.4443C28.9358 30.2222 29.3332 30.6195 29.3332 31.1111Z" fill="#E1E8ED"/><path d="M17.9909 19.5557H3.3411C1.98643 19.5557 0.249546 20.241 1.13843 22.6943L3.8691 30.2277C3.86999 30.2277 4.22199 32.0001 6.22199 32.0001H23.9998L20.4442 22.009C20.0549 20.8339 19.3464 19.5557 17.9909 19.5557Z" fill="#E1E8ED"/><path d="M17.1022 19.5557H2.45243C1.09776 19.5557 -0.639126 20.241 0.249763 22.6943L2.98043 30.2277C2.98132 30.2277 3.33332 32.0001 5.33332 32.0001H23.1111L19.5555 22.009C19.1662 20.8339 18.4578 19.5557 17.1022 19.5557Z" fill="#99AAB5"/><path d="M12.4613 26.0294C12.9271 27.4267 12.5502 28.8116 11.6178 29.1219C10.6871 29.433 9.55378 28.5521 9.088 27.1547C8.62222 25.7574 9 24.3725 9.93156 24.0623C10.8631 23.7521 11.9964 24.6321 12.4613 26.0294ZM16.8889 22.0001H2.66667C2.29867 22.0001 2 21.7014 2 21.3334C2 20.9654 2.29867 20.6667 2.66667 20.6667H16.8889C17.2569 20.6667 17.5556 20.9654 17.5556 21.3334C17.5556 21.7014 17.2569 22.0001 16.8889 22.0001Z" fill="#E1E8ED"/></g><defs><clipPath id="clip0_914_3627"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>';
$config->ai->miniPrograms->iconCheck                = '<svg width="14" height="10" viewBox="0 0 14 10" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M5.613 9.4L1 4.92006L2.26167 3.69453L5.613 6.94985L11.7383 1L13 2.22553L5.613 9.4Z" fill="#22C98D" stroke="#22C98D" stroke-width="0.15"/></svg>';


$config->ai->miniPrograms->themeList = array();
$config->ai->miniPrograms->themeList[] = array('#ffffff', '#e0e0e0');
$config->ai->miniPrograms->themeList[] = array('#e8e8e8', '#dedede');
$config->ai->miniPrograms->themeList[] = array('#e1d7f0', '#d1c1e8');
$config->ai->miniPrograms->themeList[] = array('#fbd8aa', '#f9c27b');
$config->ai->miniPrograms->themeList[] = array('#fee9e9', '#fcdddd');
$config->ai->miniPrograms->themeList[] = array('#edf3e8', '#d9eacb');
$config->ai->miniPrograms->themeList[] = array('#e9f1ff', '#dde9ff');
$config->ai->miniPrograms->themeList[] = array('#fff8df', '#fce8cf');
