<?php

namespace Spiral\Core\Internal\Factory;

/**
 * @template TClass of object
 */
final class Ctx
{
    /**
     * @readonly
     * @var string
     */
    public $alias;
    /**
     * @var class-string<TClass>
     */
    public $class;
    /**
     * @var string|null
     */
    public $parameter;
    /**
     * @var bool|null
     */
    public $singleton;
    /**
     * @var null|\ReflectionClass<TClass>
     */
    public $reflection;
    /**
     * @param class-string<TClass> $class
     * @param null|\ReflectionClass<TClass> $reflection
     */
    public function __construct(string $alias, string $class, ?string $parameter = null, ?bool $singleton = null, ?\ReflectionClass $reflection = null)
    {
        $this->alias = $alias;
        $this->class = $class;
        $this->parameter = $parameter;
        $this->singleton = $singleton;
        $this->reflection = $reflection;
    }
}
