<?php

namespace Spiral\Core\Exception\Scope;

use Spiral\Core\Exception\Container\ContainerException;

/**
 * @internal
 */
abstract class ScopeException extends ContainerException
{
    /**
     * @var string|null
     */
    protected $scope;
    public function __construct(?string $scope, string $message = '', int $code = 0, ?\Throwable $previous = null)
    {
        $this->scope = $scope;
        parent::__construct($message, $code, $previous);
    }
    public function getScope()
    {
        return $this->scope;
    }
}
