<?php

namespace Spiral\Core\Exception\Scope;

/**
 * @method string getScope()
 */
final class BadScopeException extends ScopeException
{
    /**
     * @var string
     */
    protected $className;
    public function __construct(string $scope, string $className)
    {
        $this->className = $className;
        parent::__construct($scope, \sprintf('Class `%s` can be resolved only in `%s` scope.', $className, $scope));
    }
}
