<?php
namespace zin;
$userCount = $userMaxCount = $liteCount = $liteMaxCount = 0;
if(data('properties.user'))
{
    $lang = data('lang');

    global $app;
    $userMaxCount = data('properties.user.value');
    $userCount    = $app->control->dao->select("COUNT('*') as count")->from(TABLE_USER)
        ->where('deleted')->eq(0)
        ->beginIF(data('config.edition') != 'open')->andWhere("visions")->ne('lite')->fi()
        ->fetch('count');

    if(data('config.edition') != 'open')
    {
        $liteCount    = $app->control->dao->select("COUNT('*') as count")->from(TABLE_USER)->where('deleted')->eq(0)->andWhere("visions")->eq('lite')->fetch('count');
        $liteMaxCount = data('properties.lite.value');
    }

    $checkWhenSubmit = jsCallback()
        ->const('userCount', $userCount)
        ->const('userMaxCount', $userMaxCount)
        ->const('noticeUserCreate', str_replace('%maxcount%', $userMaxCount, $lang->user->noticeUserCreate))
        ->const('liteCount', $liteCount)
        ->const('liteMaxCount', $liteMaxCount)
        ->const('noticeFeedbackCreate', str_replace('%maxcount%', $liteMaxCount, $lang->user->noticeFeedbackCreate))
        ->do(<<<'JS'
var allUserCount = parseInt(userCount);
var allLiteCount = parseInt(liteCount);

$('[data-name=account]').find('input').each(function(){
    if($(this).val().length > 0)
    {
        var visions = $(this).closest('tr').find('td[data-name=visions] .picker').zui('picker').$.value;
        if(visions.indexOf('rnd') != -1)  allUserCount += 1;
        if(visions.indexOf('lite') != -1) allLiteCount += 1;
    }
});

if(allUserCount > userMaxCount)
{
    zui.Modal.alert(noticeUserCreate.replace('%usercount%', allUserCount));
    return false;
}

if(allLiteCount > liteMaxCount)
{
    zui.Modal.alert(noticeFeedbackCreate.replace('%usercount%', allLiteCount));
    return false;
}
JS
);
    query('.form-actions .btn.primary')->on('click', $checkWhenSubmit);
    query('.form-actions .btn.primary')->append(''); // 删掉之后query->on('click')无法初始化，zui-init属性为空，不可删除
}
