<?php
/**
 * 获取代码库的提交列表。
 * Get commits.
 *
 * @param  object $repo
 * @param  string $entry
 * @param  string $revision
 * @param  string $type
 * @param  object $pager
 * @param  string $begin
 * @param  string $end
 * @access public
 * @return array
 */
public function getCommits($repo, $entry, $revision = 'HEAD', $type = 'dir', $pager = null, $begin = '', $end = '')
{
    $comments = parent::getCommits($repo, $entry, $revision, $type, $pager, $begin, $end);

    $designs = $this->dao->select("commit, name, id")->from(TABLE_DESIGN)
        ->where('deleted')->eq(0)
        ->andWhere('commit')->in(array_column($comments, 'revision'))
        ->fetchAll('commit');
    foreach($comments as $repoComment)
    {
        $design = zget($designs, $repoComment->revision, array());
        $repoComment->designName = zget($design, 'name', '');
        $repoComment->designID   = zget($design, 'id', '');
    }
    return $comments;
}
