<?php
/**
 * The admin view file of feedback module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yuting Wang <wangyuting@easycorp.ltd>
 * @package     feedback
 * @link        https://www.zentao.net
 */
namespace zin;

if($browseType == 'byProduct' || $browseType == 'byModule') $browseType = $this->session->feedbackBrowseType;
$productID   = $productID != 'all' ? $this->session->feedbackProduct : $productID;
$closeLink   = createLink('feedback', 'browse', "browseType=byProduct&param=all&orderBy=$orderBy&recTotal=0");

foreach($feedbacks as $feedback)
{
    $feedback->solution = zget($lang->feedback->solutionList, $feedback->solution, '');
}

foreach(array_keys($config->feedback->dtable->fieldList['actions']['list']) as $actionName)
{
    if(strpos(',edit,close,delete,', ",$actionName,") === false) unset($config->feedback->dtable->fieldList['actions']['list'][$actionName]);
}

$cols      = $this->loadModel('datatable')->getSetting('feedback');
$feedbacks = initTableData($feedbacks, $cols, $this->feedback);
if(!empty($cols['product'])) $cols['product']['map'] = $products;
if(!empty($cols['module']))  $cols['module']['map']  = $modules;
if(!empty($cols['dept']))    $cols['dept']['map']    = $depts;

jsVar('errorNoProject',   $lang->feedback->noProject);
jsVar('errorNoExecution', $lang->feedback->noExecution);

dropmenu(set::text($productID == 'all' ? $lang->product->allProduct : ''), set::tab('product'));

sidebar
(
    moduleMenu(set(array
    (
        'modules'     => $moduleTree,
        'activeKey'   => $this->session->objectID,
        'closeLink'   => $closeLink,
        'showDisplay' => false
    )))
);

featureBar
(
    set::current($browseType),
    set::linkParams("browseType={key}"),
    li(searchToggle())
);

toolbar(hasPriv('feedback', 'export') ? item(set(array
(
    'icon'  => 'export',
    'text'  => $lang->export,
    'class' => 'ghost',
    'url'   => inlink('export', "browseType=$browseType&orderBy=$orderBy"),
    'data-toggle' => 'modal'
))) : null, hasPriv('feedback', 'create') ? item(set(array
(
    'icon'  => 'plus',
    'text'  => $lang->feedback->create,
    'class' => 'primary',
    'url'   => inlink('create', "extras=moduleID=$moduleID,productID=$productID")
))) : null);

dtable
(
    set::cols(array_values($cols)),
    set::data(array_values($feedbacks)),
    set::userMap($users),
    set::orderBy($orderBy),
    set::customCols(true),
    set::sortLink(createLink('feedback', 'browse', "browseType={$browseType}&param={$param}&orderBy={name}_{sortType}&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}&pageID={$pager->pageID}")),
    set::fixedLeftWidth('0.44'),
    set::footPager(usePager())
);

render();
