window.changeCharter = function()
{
    $('#categoryHide').remove();

    const charterID      = $('[name=charter]').val();
    const categoryPicker = model == 'ipd' ? $("[name='category']").zui('picker') : {};
    if(charterID != '')
    {
        $('input[name=productName]').attr('disabled', 'disabled');
        $('.productsBox').addClass('hidden');

        $('.productsBox').find('.pick-value').each(function(){$(this).zui('picker').render({disabled: true});})

        $('#productRoadmap').removeClass('hidden');
        $('#productRoadmap').append("<input type='hidden' name='products[0]' value='0'/> <input type='hidden' name='branch[0]' value='0'/>");

        const link = $.createLink('charter', 'ajaxGetCharterInfo', 'id=' + charterID);
        $.get(link, function(data)
        {
            data = JSON.parse(data);
            if(!$('[name=name]').val()) $('[name=name]').val(data.name);

            if(model == 'ipd')
            {
                categoryPicker.$.setValue(data.category);
                categoryPicker.render({disabled: true});
                $('[name=category]').after("<input type='hidden' name='category' id='categoryHide' value='" + data.category + "'/>");
            }

            $('[name=budget]').val(data.budget);
            $('[name=budgetUnit]').val(data.budgetUnit);
            $('#productRoadmap #productName').val(data.productName);
            $('#roadmapName').val(data.roadmapName);
            $('#productRoadmap input[name^=products]').val(data.product);
            if(model == 'ipd') toggleHasProduct(data.category);
        })
    }
    else
    {
        $('input[name=productName]').removeAttr('disabled');
        $('.productsBox').removeClass('hidden');
        $('.productsBox').find('.pick-value').each(function(){$(this).zui('picker').render({disabled: false});})
        $('#productRoadmap').addClass('hidden');
        $('#productRoadmap').find('input.hidden').remove();

        if(typeof currentMethod !== 'undefined' && currentMethod != 'edit')
        {
            $('[name=name]').val('');
            $('[name=budget]').val('');
            $('[name=budgetUnit]').val('CNY');
        }

        if(model == 'ipd')
        {
            categoryPicker.$.setValue('IPD');
            categoryPicker.render({disabled: false});
        }
    }
}

window.changeCategory = function()
{
    const category = $("[name='category']").val();
    if(model == 'ipd') toggleHasProduct(category);
}

window.toggleHasProduct = function(category)
{
    const charterID = $('[name=charter]').val();
    if(category == 'CPD' && charterID == '')
    {
        $('.categoryBox .hasProduct').removeClass('hidden');
    }
    else
    {
        $('.categoryBox .hasProduct').find("input[name='hasProduct'][value='1']").prop('checked', true);
        $('.categoryBox .hasProduct').addClass('hidden');
        if(charterID == '')
        {
            $('input[name=productName]').removeAttr('disabled');
            $('.productsBox').removeClass('hidden');
            $('.productsBox').find('.pick-value').each(function(){$(this).zui('picker').render({disabled: false});})
        }
    }
}
