<?php
$config->project->categoryStages['IPD'] = array('concept', 'plan', 'develop', 'qualify', 'launch', 'lifecycle');
$config->project->categoryStages['TPD'] = array('concept', 'plan', 'develop', 'qualify');
$config->project->categoryStages['CBB'] = array('concept', 'plan', 'develop', 'qualify');
$config->project->categoryStages['CPD'] = array('plan', 'develop', 'qualify', 'launch');

$config->project->form->create['charter']  = array('type' => 'int',    'required' => false, 'default' => 0);
$config->project->form->create['category'] = array('type' => 'string', 'required' => false, 'default' => '');

$config->project->form->edit['charter']  = array('type' => 'int',    'required' => false, 'default' => 0);
$config->project->form->edit['category'] = array('type' => 'string', 'required' => false, 'default' => '');

$app->loadLang('review');
$app->loadLang('approval');

$config->projectExecution->dtable->fieldList['status']['statusMap'] = $lang->execution->statusList + $lang->task->statusList + $lang->review->statusList;

$config->projectExecution->dtable->fieldList['actions']['actionsMap']['createReview']['icon'] = 'play';
$config->projectExecution->dtable->fieldList['actions']['actionsMap']['createReview']['hint'] = $lang->review->submit;
$config->projectExecution->dtable->fieldList['actions']['actionsMap']['createReview']['url']  = helper::createLink('review', 'create', 'projectID={project}');

$config->projectExecution->dtable->fieldList['actions']['actionsMap']['submitReview']['icon']        = 'play';
$config->projectExecution->dtable->fieldList['actions']['actionsMap']['submitReview']['hint']        = $lang->review->submit;
$config->projectExecution->dtable->fieldList['actions']['actionsMap']['submitReview']['url']         = helper::createLink('review', 'submit', 'reviewID={review}', '', true);
$config->projectExecution->dtable->fieldList['actions']['actionsMap']['submitReview']['data-toggle'] = 'modal';
$config->projectExecution->dtable->fieldList['actions']['actionsMap']['submitReview']['data-type']   = 'iframe';

$config->projectExecution->dtable->fieldList['actions']['actionsMap']['recallReview']['icon']        = 'back';
$config->projectExecution->dtable->fieldList['actions']['actionsMap']['recallReview']['hint']        = $lang->review->recall;
$config->projectExecution->dtable->fieldList['actions']['actionsMap']['recallReview']['url']         = helper::createLink('review', 'recall', 'reviewID={review}', '', true);
$config->projectExecution->dtable->fieldList['actions']['actionsMap']['recallReview']['data-toggle'] = 'modal';
$config->projectExecution->dtable->fieldList['actions']['actionsMap']['recallReview']['data-type']   = 'iframe';

$config->projectExecution->dtable->fieldList['actions']['actionsMap']['assessReview']['icon'] = 'glasses';
$config->projectExecution->dtable->fieldList['actions']['actionsMap']['assessReview']['hint'] = $lang->review->assess;
$config->projectExecution->dtable->fieldList['actions']['actionsMap']['assessReview']['url']  = helper::createLink('review', 'assess', 'reviewID={review}');

$config->projectExecution->dtable->fieldList['actions']['actionsMap']['progressReview']['icon']        = 'list-alt';
$config->projectExecution->dtable->fieldList['actions']['actionsMap']['progressReview']['hint']        = $lang->approval->progress;
$config->projectExecution->dtable->fieldList['actions']['actionsMap']['progressReview']['url']         = helper::createLink('approval', 'progress', 'approvalID={approval}', '', true);
$config->projectExecution->dtable->fieldList['actions']['actionsMap']['progressReview']['data-toggle'] = 'modal';
$config->projectExecution->dtable->fieldList['actions']['actionsMap']['progressReview']['data-type']   = 'iframe';

$config->projectExecution->dtable->fieldList['actions']['actionsMap']['reportReview']['icon'] = 'bar-chart';
$config->projectExecution->dtable->fieldList['actions']['actionsMap']['reportReview']['hint'] = $lang->review->reviewReport;
$config->projectExecution->dtable->fieldList['actions']['actionsMap']['reportReview']['url']  = helper::createLink('review', 'report', 'reviewID={review}');

$config->projectExecution->dtable->fieldList['actions']['actionsMap']['editReview']['icon'] = 'edit';
$config->projectExecution->dtable->fieldList['actions']['actionsMap']['editReview']['hint'] = $lang->review->edit;
$config->projectExecution->dtable->fieldList['actions']['actionsMap']['editReview']['url']  = helper::createLink('review', 'edit', 'reviewID={review}');

$config->projectExecution->dtable->actionsRule['ipd']   = array('start', 'createTask', 'createChildStage', 'edit', 'close|activate', 'delete');
$config->projectExecution->dtable->actionsRule['point'] = array('createReview|submitReview', 'recallReview', 'assessReview', 'progressReview', 'reportReview', 'editReview');

$config->project->labelClass['ipd'] = 'primary-outline';
