<?php
/**
 * The edit view file of pivot module of ZenTaoPMS.
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Chenxuan Song <songchenxuan@easycorp.ltd>
 * @package     bug
 * @link        https://www.zentao.net
 */
namespace zin;

modalHeader();

$clientLang = $this->app->getClientLang();
$langs      = $config->langs;

$nameItems = array();
$descItems = array();
foreach($langs as $sysLang => $langName)
{
    $currentLang = $sysLang == $clientLang;

    $nameName   = "name[$sysLang]";
    $nameValue  = isset($pivot->names[$sysLang]) ? $pivot->names[$sysLang] : '';
    $descName   = "desc[$sysLang]";
    $descValue  = isset($pivot->descs[$sysLang]) ? $pivot->descs[$sysLang] : '';


    $nameItems[] = input(set::name($nameName), set::value($nameValue), set('data-lang', $sysLang), !$currentLang ? setClass('nameinputs hidden') : setClass('nameinputs'));
    $descItems[] = input(set::name($descName), set::value($descValue), set('data-lang', $sysLang), !$currentLang ? setClass('descinputs hidden') : setClass('descinputs'));
}

formPanel
(
    formGroup
    (
        set::label($lang->pivot->group),
        picker
        (
            set::name('group[]'),
            set::items($groups),
            set::multiple(true),
            set::value($pivot->group)
        )
    ),
    formRow(formGroup(set::label($lang->pivot->name), set::width('1/3'), picker
    (
        set::name('namelang'),
        set::items($langs),
        set::required(true),
        set::value($clientLang),
        on::change('showName')
    )), formGroup
    (
        $nameItems
    )),
    formRow(formGroup(set::label($lang->pivot->desc), set::width('1/3'), picker
    (
        set::name('desclang'),
        set::items($langs),
        set::required(true),
        set::value($clientLang),
        on::change('showDesc')
    )), formGroup
    (
        $descItems
    ))
);

render();

