<?php
/**
 * The admin view file of feedback module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yuting Wang <wangyuting@easycorp.ltd>
 * @package     feedback
 * @link        https://www.zentao.net
 */
namespace zin;

if($browseType == 'byProduct' || $browseType == 'byModule') $browseType = $this->session->feedbackBrowseType;
$productID   = $productID != 'all' ? $this->session->feedbackProduct : $productID;
$closeLink   = createLink('feedback', 'admin', "browseType=byProduct&param=all&orderBy=$orderBy&recTotal=0");
$settingLink = hasPriv('tree', 'browse') && $productID != 'all' ? createLink('tree', 'browse', "productID={$productID}&view=feedback") : '';

foreach($feedbacks as $feedback)
{
    $feedback->solution = zget($lang->feedback->solutionList, $feedback->solution, '');
}

$cols      = $this->loadModel('datatable')->getSetting('feedback');
$feedbacks = initTableData($feedbacks, $cols, $this->feedback);
if(!empty($cols['product'])) $cols['product']['map'] = $products;
if(!empty($cols['module']))  $cols['module']['map']  = $modules;
if(!empty($cols['dept']))    $cols['dept']['map']    = $depts;

$canBatchEdit     = common::hasPriv('feedback', 'batchEdit');
$canBatchClose    = common::hasPriv('feedback', 'batchClose');
$canBatchAssignTo = common::hasPriv('feedback', 'batchAssignTo');
$canBatchAction   = $canBatchEdit || $canBatchClose || $canBatchAssignTo;
if($browseType == 'review')
{
    $canBatchReview = common::hasPriv('feedback', 'batchReview');
    $canBatchAction = $canBatchAction || $canBatchReview;
}

$footToolbar     = array();
$reviewItems     = array();
$assignedToItems = array();
foreach($lang->feedback->reviewResultList as $key => $value)
{
    if($value) $reviewItems[] = array('text' => $value, 'innerClass' => 'batch-btn ajax-btn not-open-url', 'data-url' => helper::createLink('feedback', 'batchReview', "result=$key"));
}
foreach($users as $key => $value)
{
    if($value) $assignedToItems[] = array('text' => $value, 'innerClass' => 'batch-btn ajax-btn not-open-url', 'data-url' => helper::createLink('feedback', 'batchAssignTo', "assignedTo=$key"));
}

if($canBatchAction)
{
    $footToolbar['items'] = array();
    if($canBatchEdit)
    {
        $footToolbar['items'][] = array('text' => $lang->edit, 'className' => 'primary batch-btn not-open-url', 'data-url' => createLink('feedback', 'batchEdit', "browseType=$browseType"));
    }
    if($canBatchClose)
    {
        $footToolbar['items'][] = array('text' => $lang->close, 'className' => 'primary batch-btn not-open-url', 'data-url' => createLink('feedback', 'batchClose'));
    }
    if($browseType == 'review' && $canBatchReview)
    {
        $footToolbar['items'][] = array('caret' => 'up', 'text' => $lang->feedback->review, 'type' => 'dropdown', 'data-placement' => 'top-start', 'items' => $reviewItems);
    }
    if($canBatchAssignTo)
    {
        $footToolbar['items'][] = array('caret' => 'up', 'text' => $lang->feedback->assignedTo, 'type' => 'dropdown', 'data-placement' => 'top-start', 'items' => $assignedToItems, 'data-menu' => array('searchBox' => true));
    }
    $footToolbar['btnProps'] = array('size' => 'sm', 'btnType' => 'secondary');
}

jsVar('errorNoProject',   $lang->feedback->noProject);
jsVar('errorNoExecution', $lang->feedback->noExecution);

dropmenu(set::text($productID == 'all' ? $lang->product->allProduct : ''), set::tab('product'));

sidebar
(
    moduleMenu(set(array
    (
        'modules'     => $moduleTree,
        'activeKey'   => $this->session->objectID,
        'closeLink'   => $closeLink,
        'settingLink' => $settingLink,
        'settingApp'  => $app->tab
    )))
);

featureBar
(
    set::current($browseType),
    set::linkParams("browseType={key}"),
    li(searchToggle())
);

toolbar(hasPriv('feedback', 'export') ? item(set(array
(
    'icon'  => 'export',
    'text'  => $lang->export,
    'class' => 'ghost',
    'url'   => createLink('feedback', 'export', "browseType=$browseType&orderBy=$orderBy"),
    'data-toggle' => 'modal'
))) : null, hasPriv('feedback', 'create') ? item(set(array
(
    'icon'  => 'plus',
    'text'  => $lang->feedback->create,
    'class' => 'primary',
    'url'   => createLink('feedback', 'create', "extras=moduleID=$moduleID,productID=$productID")
))) : null);

dtable
(
    set::cols(array_values($cols)),
    set::data(array_values($feedbacks)),
    set::userMap($users),
    set::orderBy($orderBy),
    set::checkable($canBatchAction),
    set::customCols(true),
    set::sortLink(createLink('feedback', 'admin', "browseType={$browseType}&param={$param}&orderBy={name}_{sortType}&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}&pageID={$pager->pageID}")),
    set::fixedLeftWidth('0.44'),
    set::footToolbar($footToolbar),
    set::footPager(usePager())
);

modal
(
    setID('toTask'),
    set::modalProps(array('title' => $lang->feedback->selectProjects)),
    to::footer
    (
        div
        (
            setClass('toolbar gap-4 w-full justify-center'),
            btn($lang->bug->nextStep, setID('toTaskButton'), setClass('primary')),
            btn($lang->cancel, setID('cancelButton'), setData(array('dismiss' => 'modal')))
        )
    ),
    formPanel
    (
        on::change('#taskProjects', 'changeTaskProjects'),
        set::actions(''),
        formRow
        (
            formGroup(set::label($lang->feedback->project), set::required(true), set::control('picker'), set::name('taskProjects'), set::items($projects))
        ),
        formRow
        (
            formGroup
            (
                set::label($lang->feedback->execution),
                set::required(true),
                inputGroup
                (
                    setID('executionBox'),
                    picker
                    (
                        set::name('executions'),
                        set::items(array())
                    ),
                    input
                    (
                        setClass('hidden'),
                        set::name('feedbackID')
                    )
                )
            )
        )
    )
);

render();
