<?php
namespace zin;

global $lang;

jsVar('currentMethod', 'edit');

query('formGridPanel')->each(function($node) use($lang)
{
    $fields = $node->prop('fields');

    $fields->field('charter')
        ->class('charterBox')
        ->control('picker')
        ->items(data('charters'))
        ->value(data('project.charter'))
        ->disabled(data('disableModel'))
        ->moveBefore('parent');

    $fields->field('hasProduct')->hidden(data('model') == 'ipd');

    $fields->field('category')
        ->class('categoryBox')
        ->control('picker')
        ->items($lang->project->categoryList)
        ->value(data('project.category'))
        ->moveAfter('parent');

    $fields->field('budget')
        ->foldable(false)
        ->moveAfter('category');

    if(data('model') != 'ipd')
    {
        $fields->remove('category');
        $fields->orders('hasProduct,budget');
    }
    else
    {
        $fields->orders('category,budget');
    }

    $node->setProp('fields', $fields);
});

$productRoadmap = div
(
    setID('productRoadmap'),
    setClass('flex hidden'),
    formGroup
    (
        set::width('1/2'),
        set::label($lang->project->manageProducts),
        set::name('productName'),
        set::disabled(true),
        setClass('linkProduct'),
        formHidden("products[]", null),
        formHidden("branch[0][]", 0)
    ),
    formGroup
    (
        set::width('1/2'),
        set::label($lang->project->manageRoadmap),
        data('model') != 'kanban' ? set::checkbox(array('text' => $lang->project->linkStoryToProject, 'name' => 'isLinkStory', 'checked' => true)) : null,
        set::name('roadmapName'),
        set::disabled(true),
        setClass('linkRoadmap')
    )
);

query('.charterBox .picker-box')->on('change', jsCallback()->call('changeCharter'));
query('.categoryBox .picker-box')->on('change', jsCallback()->call('changeCategory'));
query('.productsBox')->after($productRoadmap);
