<?php
namespace zin;

$lang = data('lang');

$canExport          = hasPriv('feedback', 'export');
$canExportTemplate  = hasPriv('feedback', 'exportTemplate');
$exportItem         = array('text' => $lang->feedback->export,         'data-toggle' => 'modal', 'data-size' => 'sm','url' => createLink('feedback', 'export', 'browseType=' . data('browseType') . '&orderBy=' . data('orderBy')));
$exportTemplateItem = array('text' => $lang->feedback->exportTemplate, 'data-toggle' => 'modal', 'data-size' => 'sm','url' => createLink('feedback', 'exportTemplate'));

query('#actionBar')->replaceWith(
    toolbar
    (
        $canExport && $canExportTemplate ? dropdown(btn
        (
            setClass('btn ghost dropdown-toggle'),
            set::icon('export'),
            $lang->export
        ), set::items(array($exportItem, $exportTemplateItem)), set::placement('bottom-end')) : null,
        $canExport && !$canExportTemplate ? item(set($exportItem + array('class' => 'btn ghost', 'icon' => 'export'))) : null,
        $canExportTemplate && !$canExport ? item(set($exportTemplateItem + array('class' => 'btn ghost', 'icon' => 'export'))) : null,
        hasPriv('feedback', 'import') ? item
        (
            setClass('ghost'),
            set::icon('import'),
            set::url(createLink('feedback', 'import')),
            setData(array('toggle' => 'modal')),
            set::text($lang->feedback->import)
        ) : null,
        hasPriv('feedback', 'create') ? item
        (
            setClass('primary'),
            set::icon('plus'),
            set::url(createLink('feedback', 'create', 'extras=moduleID=' . data('moduleID') . ',productID=' . data('productID'))),                                                                                                                                                        
            setData(array('toggle' => 'modal')),
            set::text($lang->feedback->create)
        ) : null
    )
);
pageJS('$(function(){$("#mainMenu .toolbar").prop("id", "actionBar"); });');
