<?php
namespace zin;

jsVar('stepData', array_values($stepData));

$fields = array();
$fields['id']      = array('name' => 'id',  'label' => $lang->transfer->id, 'control' => 'input', 'required' => false, 'width' => '64px', 'hidden' => true);
$fields['idIndex'] = array('name' => 'id',  'label' => $lang->transfer->id, 'control' => 'index', 'required' => false, 'width' => '64px');
$fields['lib']     = array('name' => 'lib', 'label' => $lang->transfer->id, 'control' => 'input', 'required' => false, 'width' => '64px', 'hidden' => true);
$fields           += $datas->fields;
$fields['steps']['width']    = '300px';
$fields['stage']['multiple'] = true;
unset($fields['stepDesc'], $fields['stepExpect'], $fields['pri']['items'][0]);

$requiredFields = $datas->requiredFields;
$allCount       = $datas->allCount;
$allPager       = $datas->allPager;
$pagerID        = $datas->pagerID;
$isEndPage      = $datas->isEndPage;
$maxImport      = $datas->maxImport;
$dataInsert     = $datas->dataInsert;
$suhosinInfo    = $datas->suhosinInfo;
$module         = $datas->module;
$datas          = $datas->datas;

if(!empty($suhosinInfo))
{
    div(setClass('alert secondary'), $suhosinInfo);
}
elseif(empty($maxImport) and $allCount > $this->config->file->maxImport)
{
    panel
    (
        on::keyup('[name=maxImport]', 'recomputeTimes'),
        set::title($lang->transfer->import),
        html(sprintf($lang->file->importSummary, $allCount, html::input('maxImport', $config->file->maxImport, "style='width:50px'"), ceil($allCount / $config->file->maxImport))),
        btn(setID('import'), setClass('primary'), on::click('setMaxImport'), $lang->import)
    );
    pageJS(<<<JAVASCRIPT
window.recomputeTimes = function()
{
    if(parseInt(\$('#maxImport').val())) \$('#times').html(Math.ceil(parseInt({$allCount}) / parseInt(\$('#maxImport').val())));
};

window.setMaxImport = function()
{
    \$.cookie.set('maxImport', \$('#maxImport').val(), {expires:config.cookieLife, path:config.webRoot});
    loadCurrentPage();
};
JAVASCRIPT
);
}
else
{
    $submitText  = $isEndPage ? $lang->save : $lang->file->saveAndNext;
    $isStartPage = $pagerID == 1;

    formBatchPanel
    (
        set::title($lang->transfer->import),
        set::mode('edit'),
        set::items($fields),
        set::data(array_values($datas)),
        set::onRenderRowCol(jsRaw('window.renderRowCol')),
        set::actions(array()),
        div
        (
            setClass('toolbar form-actions form-group no-label'),
            $this->session->insert ? btn(set::btnType('submit'), setClass('primary btn-wide'), $submitText) : btn(set('data-toggle', 'modal'), set('data-target', '#importNoticeModal'), setClass('primary btn-wide'), $submitText),
            btn(set::url($backLink), setClass('btn-back btn-wide'), $lang->goback),
            $this->session->insert && $dataInsert != '' ? formHidden('insert', $dataInsert) : null,
            formHidden('isEndPage', $isEndPage ? 1 : 0),
            formHidden('pagerID', $pagerID),
            html(sprintf($lang->file->importPager, $allCount, $pagerID, $allPager))
        ),
        $this->session->insert ? null : modal
        (
            set::size('sm'),
            setID('importNoticeModal'),
            set::title($lang->importConfirm),
            formHidden('insert', 0),
            div
            (
                setClass('alert flex items-center'),
                icon(setClass('icon-2x alert-icon'), 'exclamation-sign'),
                div($lang->noticeImport)
            ),
            to::footer
            (
                btn(setClass('danger btn-wide'), set('onclick', 'submitForm("cover")'), $lang->importAndCover),
                btn(setClass('primary btn-wide'), set('onclick', 'submitForm("insert")'), $lang->importAndInsert)
            )
        )
    );
    pageJS(<<<JAVASCRIPT
window.submitForm = function(type)
{
    \$('#importNoticeModal [name=insert]').val(type == 'insert' ? 1 : 0);
    \$("button[data-target='#importNoticeModal']").closest('form')[0].submit();
};
window.renderRowCol = function(\$result, col, row)
{
    if(col.name == 'steps')
    {
        \$result.empty();
        const index     = \$result.closest('tr').attr('data-index');
        const stepsIndex = Object.keys(stepData[index]['desc']).sort();
        \$.each(stepsIndex, function(i, stepIndex){
            const desc = stepData[index]['desc'][stepIndex];
            \$result.append('<div class="input-group step-box mb-2 gap-x-2"><span class="w-8 flex-none">' + stepIndex + '</span></div>');
            \$result.find('.step-box').last().append('<input type="hidden" name="stepType[' + (parseInt(index) + 1) + '][' + stepIndex + ']" id="stepType' + index + stepIndex + '" value="' + desc.type + '"></input>');
            \$result.find('.step-box').last().append('<div class="input-group mb-2 gap-x-2 w-full"></div>');

            const \$currentInputGroup = \$result.find('.step-box').last().find('.input-group');

            \$currentInputGroup.last().append('<textarea name="desc[' + (parseInt(index) + 1) + '][' + stepIndex + ']" id="desc' + index + stepIndex + '" class="form-control w-1/2"></textarea>');
            \$currentInputGroup.last().find('textarea').val(desc.content);

            const expect = stepData[index]['expect'][stepIndex];
            if(expect.type != 'group')
            {
                \$currentInputGroup.append('<textarea name="expect[' + (parseInt(index) + 1) + '][' + stepIndex + ']" id="expect' + index + stepIndex + '" class="form-control w-1/2"></textarea>');
                \$currentInputGroup.find('textarea[name^=expect]').val(expect.content);
            }
            else
            {
                \$currentInputGroup.append('<div class="w-1/2"></div>');
            }
        });
    }
};
JAVASCRIPT
);
}
