<?php
/**
 * The view view file of testcase module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Mengyi Liu <liumengyi@easycorp.ltd>
 * @package     testcase
 * @link        https://www.zentao.net
 */
namespace zin;

include($this->app->getModuleRoot() . 'ai/ui/promptmenu.html.php');

jsVar('viewParams', "caseID={$case->id}&version={$version}&from={$from}&taskID={$taskID}&stepsType=");

$isInModal = isInModal();

/* 版本列表。Version list. */
$versions = array();
for($i = $case->version; $i >= 1; $i--)
{
    $versionItem = setting()
        ->text("#{$i}")
        ->url(inlink('view', "caseID={$case->id}&version={$i}&from={$from}&taskID={$taskID}&stepsType={$stepsType}"));

    if($isInModal)
    {
        $versionItem->set(array('data-load' => 'modal', 'data-target' => '.modal-content'));
    }

    $versionItem->selected($version == $i);
    $versions[] = $versionItem;
}
$versionBtn = count($versions) > 1 ? to::title(dropdown
(
    btn(set::type('ghost'), setClass('text-link font-normal text-base'), "#{$version}"),
    set::items($versions)
)) : null;

/* 初始化头部右上方工具栏。Init detail toolbar. */
$toolbar = array();
if(!$isInModal && hasPriv('testcase', 'create', $case))
{
    $toolbar[] = array
    (
        'icon' => 'plus',
        'type' => 'primary',
        'text' => $lang->case->create,
        'url'  => createLink('testcase', 'create', "productID={$case->product}&branch={$case->branch}&moduleID={$case->module}")
    );
}

/* 初始化底部操作栏。Init bottom actions. */
$actions = $this->loadModel('common')->buildOperateMenu($case);
$actions = array_merge($actions['mainActions'], !empty($actions['mainActions']) && !empty($actions['suffixActions']) ? array(array('type' => 'divider')) : array(), $actions['suffixActions']);
foreach($actions as $index => $action)
{
    if(!isset($action['url'])) continue;
    $actions[$index]['url'] = str_replace(array('%executionID%', '{runID}'), array((string)$this->session->execution, (string)$runID), $action['url']);

    if($isInModal && !isset($action['data-toggle']) && !isset($action['data-load']))
    {
        $actions[$index]['data-load'] = 'modal';
        $actions[$index]['data-size'] = 'lg';
    }
}

$steps = array();
if(!empty($case->steps) && $stepsType == 'table')
{
    foreach($case->steps as $step)
    {
        $stepClass = $step->type == 'step' ? 'step-group' : "step-{$step->type}";
        $stepClass .= count($steps) > 0 && $step->grade == 1 ? ' mt-2' : ' border-t-0';

        $steps[] = cell
        (
            setClass("step {$stepClass} border align-top flex"),
            cell
            (
                setClass('text-left flex border-r step-id'),
                width('1/2'),
                span
                (
                    setClass('nowrap pr-2 pl-' . (($step->grade - 1) * 2)),
                    $step->name
                ),
                html(nl2br(str_replace(' ', '&nbsp;', $step->desc)))
            ),
            cell
            (
                setClass('text-left flex'),
                width('1/2'),
                html(nl2br(str_replace(' ', '&nbsp;', $step->expect)))
            )
        );
    }
}
$stepsTable = !empty($case->steps) ? div
(
    $stepsType == 'table' ? div
    (
        setID('stepsTable'),
        div
        (
            setClass('steps-header'),
            div
            (
                setClass('text-left inline-block steps border'),
                width('1/2'),
                $lang->testcase->stepDesc
            ),
            div
            (
                setClass('text-left inline-block border border-l-0'),
                width('1/2'),
                $lang->testcase->stepExpect
            )
        ),
        div
        (
            setClass('steps-body'),
            $steps
        )
    ) : div
    (
        setID('stepsView'),
        setClass('relative'),
        mindmap
        (
            set::data($case->mindMapSteps),
            set::readonly(true)
        ),
        btn
        (
            setClass('ghost absolute z-1 top-1 right-1'),
            set::icon('fullscreen'),
            on::click()->call('zui.toggleFullscreen', '#stepsView')
        ),
        h::css('.is-in-fullscreen > .mindmap-iframe {height: 100%!important}')
    )
) : div
(
    setClass('canvas text-center py-2'),
    p
    (
        setClass('py-2 my-2'),
        span
        (
            setClass('text-gray'),
            $lang->noData
        )
    )
);

$stepsActions = array();
$stepsActions['items'][] = array('icon' => 'table-large', 'data-app' => $app->tab, 'size' => 'xs', 'type' => $stepsType == 'table'   ? 'primary' : 'ghost', 'class' => 'mr-2', 'url' => createLink('testcase', 'view', "caseID={$case->id}&version={$version}&from={$from}&taskID={$taskID}&stepsType=table"));
$stepsActions['items'][] = array('icon' => 'tree',        'data-app' => $app->tab, 'size' => 'xs', 'type' => $stepsType == 'mindmap' ? 'primary' : 'ghost', 'url' => createLink('testcase', 'view', "caseID={$case->id}&version={$version}&from={$from}&taskID={$taskID}&stepsType=mindmap"));

/* 初始化主栏内容。Init sections in main column. */
$sections = array();
$sections[] = setting()
    ->title($lang->testcase->precondition)
    ->control('html')
    ->content($case->precondition);

$sections[] = setting()
    ->title($lang->testcase->steps)
    ->titleActions($stepsActions)
    ->children(wg($stepsTable));

$sections[] = setting()
    ->control('fileList')
    ->files($case->files)
    ->showDelete(false)
    ->padding(false)
    ->object($case);

/* 初始化侧边栏标签页。Init sidebar tabs. */
$tabs = array();

$tabs[] = setting()
    ->group('basic')
    ->title($lang->testcase->legendBasicInfo)
    ->control('caseBasicInfo');

$tabs[] = setting()
    ->group('basic')
    ->title($lang->testcase->legendOpenAndEdit)
    ->control('caseTimeInfo');

$tabs[] = setting()
    ->group('relatives')
    ->title($lang->testcase->legendOther)
    ->control('caseRelatedList');

detail
(
    set::urlFormatter(array('{caseID}' => $case->caseID, '{version}' => $case->version, '{product}' => $case->product, '{branch}' => $case->branch, '{module}' => $case->module, '{id}' => $case->id, '{lib}' => $case->lib)),
    set::toolbar($toolbar),
    set::sections($sections),
    set::tabs($tabs),
    set::actions($actions),
    $versionBtn
);
