<?php
/**
 * Build operate menu.
 *
 * @param  object $story
 * @param  string $type
 * @param  object $execution
 * @param  string $storyType story|requirement
 * @access public
 * @return array
 */
public function buildOperateMenu($story, $type = 'view', $execution = null, $storyType = 'story')
{
    $this->lang->story->changeTip = $storyType == 'story' ? $this->lang->story->changeTip : $this->lang->story->URChangeTip;

    if($story->type != 'requirement' and !empty($story->confirmeObject))
    {
        $mothed = $story->confirmeObject['type'] == 'confirmedretract' ? 'confirmDemandRetract' : 'confirmDemandUnlink';
        return $this->buildMenu('story', $mothed, "objectID=$story->id&object=story&extra={$story->confirmeObject['id']}", $story, 'view', 'search', '', 'iframe', true);
    }

    return parent::buildOperateMenu($story, $type, $execution, $storyType);
}
