<?php
namespace zin;

global $lang;

jsVar('currentMethod', 'create');

if(data('model') != 'kanban')
{
    query('formGridPanel')->each(function($node) use($lang)
    {
        $fields = $node->prop('fields');

        $fields->field('charter')
            ->class('charterBox')
            ->control('picker')
            ->items(data('charters'))
            ->value('')
            ->moveBefore('parent');

        $fields->field('hasProduct')->hidden(data('model') == 'ipd');

        $fields->field('category')
            ->class('categoryBox')
            ->labelControl
            (
                setting()
                    ->control('radioList')
                    ->inline()
                    ->className('ml-4 hasProduct hidden')
                    ->addToList('items', array('name' => 'hasProduct', 'text' => $lang->project->projectTypeList[1], 'value' => '1'))
                    ->addToList('items', array('name' => 'hasProduct', 'text' => $lang->project->projectTypeList[0], 'value' => '0'))
            )
            ->control('picker')
            ->items($lang->project->categoryList)
            ->value('')
            ->moveAfter('parent');

        $fields->field('budget')
            ->foldable(false)
            ->moveAfter('category');

        if(data('model') != 'ipd')
        {
            $fields->remove('category');
            $fields->orders('hasProduct,budget');
        }
        else
        {
            $fields->orders('category,budget');
        }

        $node->setProp('fields', $fields);
    });

    $productRoadmap = div
    (
        setID('productRoadmap'),
        setClass('flex hidden'),
        formGroup
        (
            set::width('1/2'),
            set::label($lang->project->manageProducts),
            set::name('productName'),
            set::disabled(true),
            setClass('linkProduct')
        ),
        formGroup
        (
            set::width('1/2'),
            set::label($lang->project->manageRoadmap),
            data('model') != 'kanban' ? set::checkbox(array('text' => $lang->project->linkStoryToProject, 'name' => 'isLinkStory', 'checked' => true)) : null,
            set::name('roadmapName'),
            set::disabled(true),
            setClass('linkRoadmap')
        )
    );

    query('.charterBox .picker-box')->on('change', jsCallback()->call('changeCharter'));
    query('.categoryBox .picker-box')->on('change', jsCallback()->call('changeCategory'));
    query('.productsBox')->after($productRoadmap);
}
