DELETE FROM `zt_block` WHERE `type` IN ('news', 'patch', 'plugin', 'puglicclass');

ALTER TABLE `zt_block` ADD `dashboard` varchar(20) NOT NULL DEFAULT '' AFTER `account`;
ALTER TABLE `zt_block` CHANGE `block` `code` varchar(30) NOT NULL DEFAULT '' AFTER `module`;
ALTER TABLE `zt_block` ADD `width` enum ('1', '2', '3') NOT NULL DEFAULT '1' AFTER `code`;
ALTER TABLE `zt_block` MODIFY `height` smallint(5) UNSIGNED NOT NULL DEFAULT 3 AFTER `width`;
ALTER TABLE `zt_block` ADD `left` enum('', '0', '1', '2') NOT NULL DEFAULT '' AFTER `height`;
ALTER TABLE `zt_block` ADD `top` smallint(5) UNSIGNED NOT NULL DEFAULT 0 AFTER `left`;
ALTER TABLE `zt_block` MODIFY `vision` varchar(10) NOT NULL DEFAULT 'rnd' AFTER `hidden`;

DROP INDEX account_vision_module_type_order ON `zt_block`;
UPDATE `zt_block` SET `dashboard` = CONCAT(`module`, `type`);
UPDATE `zt_block` SET `module` = IF(`source` != '', `source`, `code`);
UPDATE `zt_block` SET `width` = IF(`grid` > 4, '2', '1');
UPDATE `zt_block` SET `params` = '{"count":"20"}' WHERE `module` = 'assigntome' AND `code` = 'assigntome';

ALTER TABLE `zt_block` DROP COLUMN `source`;
ALTER TABLE `zt_block` DROP COLUMN `type`;
ALTER TABLE `zt_block` DROP COLUMN `grid`;
ALTER TABLE `zt_block` DROP COLUMN `order`;

DELETE FROM `zt_block` where `module` = 'todo' and `code` = 'list';
DELETE FROM `zt_block` where `module` = 'contribute' and `code` = 'contribute';
DELETE FROM `zt_block` where `module` = 'project' and `code` = 'projectteam';
DELETE FROM `zt_block` where `module` = 'execution' and `code` = 'execution';

ALTER TABLE `zt_todo`  CHANGE `idvalue` `objectID` mediumint(8) unsigned default '0' NOT NULL AFTER `type`;
ALTER TABLE `zt_todo` CHANGE `config` `config` VARCHAR(1000) NOT NULL  DEFAULT '';

ALTER TABLE `zt_project` ADD `stageBy` enum('project', 'product') NOT NULL DEFAULT 'project' AFTER `division`;
UPDATE `zt_project` SET `stageBy` = 'project' WHERE `division` = '0';
UPDATE `zt_project` SET `stageBy` = 'product' WHERE `division` = '1';
ALTER TABLE `zt_project` DROP `division`;
ALTER TABLE `zt_project` CHANGE `minColWidth` `minColWidth` smallint NOT NULL DEFAULT '264' AFTER `colWidth`;

ALTER TABLE `zt_bug` CHANGE `linkBug` `relatedBug` varchar(255) NOT NULL DEFAULT '';

ALTER TABLE `zt_product` ADD COLUMN `groups` text NULL AFTER `acl`;

ALTER TABLE `zt_usercontact` ADD `public` tinyint(1) NOT NULL DEFAULT 0;
UPDATE `zt_usercontact` AS t1, `zt_config` AS t2 SET t1.public = 1 WHERE t2.module = 'my' AND t2.section = 'global' AND t2.key = 'globalContacts' AND FIND_IN_SET(t1.id, t2.value); -- Change it for compatible with dameng.
DELETE FROM `zt_config` WHERE `module` = 'my' AND `section` = 'global' AND `key` = 'globalContacts';

ALTER TABLE `zt_testtask` ADD `realBegan` date NULL AFTER `end`;

UPDATE `zt_config` SET `module` = 'bug', `section` = 'browse' WHERE `module` = 'datatable' AND `section` = 'bugBrowse' AND `key` = 'showModule';
UPDATE `zt_config` SET `module` = 'caselib', `section` = 'browse' WHERE `module` = 'datatable' AND `section` = 'caselibBrowse' AND `key` = 'showModule';
UPDATE `zt_config` SET `module` = 'execution', `section` = 'bug' WHERE `module` = 'datatable' AND `section` = 'executionBug' AND `key` = 'showModule';
UPDATE `zt_config` SET `module` = 'execution', `section` = 'story' WHERE `module` = 'datatable' AND `section` = 'executionStory' AND `key` = 'showModule';
UPDATE `zt_config` SET `module` = 'execution', `section` = 'task' WHERE `module` = 'datatable' AND `section` = 'executionTask' AND `key` = 'showModule';
UPDATE `zt_config` SET `module` = 'feedback', `section` = 'admin' WHERE `module` = 'datatable' AND `section` = 'feedbackAdmin' AND `key` = 'showModule';
UPDATE `zt_config` SET `module` = 'product', `section` = 'browse' WHERE `module` = 'datatable' AND `section` = 'productBrowse' AND `key` = 'showModule';
UPDATE `zt_config` SET `module` = 'project', `section` = 'bug' WHERE `module` = 'datatable' AND `section` = 'projectBug' AND `key` = 'showModule';
UPDATE `zt_config` SET `module` = 'testcase', `section` = 'browse' WHERE `module` = 'datatable' AND `section` = 'testcaseBrowse' AND `key` = 'showModule';

INSERT IGNORE INTO `zt_config` (`owner`, `module`, `key`, `value`) VALUES ('system', 'execution', 'defaultWorkhours', '7');

CREATE TABLE IF NOT EXISTS `zt_session` (
    `id` varchar(32) NOT NULL,
    `data` mediumtext,
    `timestamp` int(10) unsigned DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE `zt_action` MODIFY `id` int(11) unsigned NOT NULL AUTO_INCREMENT;
ALTER TABLE `zt_actionrecent` MODIFY `id` int(11) unsigned NOT NULL AUTO_INCREMENT;

ALTER TABLE `zt_history` CHANGE `old` `old` text NULL AFTER `field`;
ALTER TABLE `zt_history` CHANGE `new` `new` text NULL AFTER `old`;
ALTER TABLE `zt_history` CHANGE `diff` `diff` mediumtext NULL AFTER `new`;

ALTER TABLE `zt_task` ADD `keywords` varchar(255) NOT NULL DEFAULT '' AFTER `mailto`;

ALTER table `zt_metric` ADD `dateType` varchar(50) NOT NULL DEFAULT '';
ALTER table `zt_metric` ADD `lastCalcRows` int NOT NULL DEFAULT 0 AFTER `order`;
ALTER table `zt_metric` ADD `lastCalcTime` datetime DEFAULT NULL AFTER `lastCalcRows`;

UPDATE `zt_metric` SET `desc` = '按系统统计的年度关闭执行数是指在关闭时间在某年的执行数。该度量项可以反映团队或组织在某年的工作效率。较高的年度关闭执行数可能表示团队或组织在完成任务方面表现出较高的效率，反之则可能需要审查工作流程和资源分配情况，以提高执行效率。' WHERE `code` = 'count_of_annual_closed_execution';
UPDATE `zt_metric` SET `definition` = '所有的任务个数求和\r\n过滤已删除的任务\r\n过滤已删除项目的任务\r\n过滤已删除执行的任务' WHERE `code` = 'count_of_task';
UPDATE `zt_metric` SET `definition` = '所有的任务个数求和\r\n状态为已完成\r\n过滤已删除的任务\r\n过滤已删除项目的任务\r\n过滤已删除执行的任务' WHERE `code` = 'count_of_finished_task';
UPDATE `zt_metric` SET `definition` = '复用：\r\n按系统统计的任务总数\r\n按系统统计的已完成任务数\r\n公式：\r\n按系统统计的未完成任务数=按系统统计的任务总数-按系统统计的已完成任务数' WHERE `code` = 'count_of_unfinished_task';
UPDATE `zt_metric` SET `definition` = '所有的任务个数求和\r\n状态为已关闭\r\n过滤已删除的任务\r\n过滤已删除项目的任务\r\n过滤已删除执行的任务' WHERE `code` = 'count_of_closed_task';
UPDATE `zt_metric` SET `definition` = '所有的任务个数求和\r\n创建时间为某年\r\n过滤已删除的任务\r\n过滤已删除项目的任务\r\n过滤已删除执行的任务' WHERE `code` = 'count_of_annual_created_task';
UPDATE `zt_metric` SET `definition` = '所有的任务个数求和\r\n完成时间为某年\r\n过滤已删除的任务\r\n过滤已删除项目的任务\r\n过滤已删除执行的任务' WHERE `code` = 'count_of_annual_finished_task';
UPDATE `zt_metric` SET `definition` = '所有的任务个数求和\r\n创建时间为某年某月\r\n过滤已删除的任务\r\n过滤已删除项目的任务\r\n过滤已删除执行的任务' WHERE `code` = 'count_of_monthly_created_task';
UPDATE `zt_metric` SET `definition` = '所有的任务个数求和\r\n完成时间为某年某月\r\n过滤已删除的任务\r\n过滤已删除项目的任务\r\n过滤已删除执行的任务' WHERE `code` = 'count_of_monthly_finished_task';
UPDATE `zt_metric` SET `definition` = '所有的任务的预计工时数求和\r\n过滤父任务\r\n过滤已删除的任务\r\n过滤已删除项目的任务\r\n过滤已删除执行的任务' WHERE `code` = 'estimate_of_task';
UPDATE `zt_metric` SET `definition` = '所有的任务的消耗工时数求和\r\n过滤父任务\r\n过滤已删除的任务\r\n过滤已删除项目的任务\r\n过滤已删除执行的任务' WHERE `code` = 'consume_of_task';
UPDATE `zt_metric` SET `definition` = '所有的任务的剩余工时数求和\r\n过滤父任务\r\n过滤已删除的任务\r\n过滤已删除项目的任务\r\n过滤已删除执行的任务' WHERE `code` = 'left_of_task';
UPDATE `zt_metric` SET `definition` = '所有的任务个数求和\r\n完成时间为某日\r\n过滤已删除的任务\r\n过滤已删除项目的任务\r\n过滤已删除执行的任务' WHERE `code` = 'count_of_daily_finished_task';

DELETE FROM `zt_config` WHERE `module` = 'datatable' AND `key` in ('cols', 'tablecols');

UPDATE `zt_screen` SET `scheme` = '[{\"id\":\"5scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":0,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":1300,\"h\":120,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/screen_header.png\",\"borderRadius\":10}},{\"id\":\"2nws38440fq000\",\"isGroup\":false,\"attr\":{\"x\":400,\"y\":36,\"w\":500,\"h\":66,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"title\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\" \\u516c\\u53f8\\u5e74\\u5ea6\\u6c47\\u603b\\u6570\\u636e\\u5927\\u5c4f\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"5scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":300,\"h\":120,\"x\":0,\"y\":95,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"type\":\"year\",\"filterCharts\":[{\"chart\":1055,\"field\":\"t1.`year`\"},{\"chart\":1056,\"field\":\"t1.`year`\"},{\"chart\":1057,\"field\":\"t1.`year`\"},{\"chart\":1058,\"field\":\"t1.`year`\"},{\"chart\":1059,\"field\":\"t1.`year`\"},{\"chart\":1060,\"field\":\"t1.`year`\"},{\"chart\":1061,\"field\":\"t1.`year`\"},{\"chart\":1062,\"field\":\"t1.`year`\"},{\"chart\":1063,\"field\":\"t1.`year`\"},{\"chart\":1064,\"field\":\"t1.`year`\"},{\"chart\":1065,\"field\":\"t1.`year`\"},{\"chart\":1066,\"field\":\"t1.`year`\"},{\"chart\":1067,\"field\":\"t1.`year`\"},{\"chart\":1068,\"field\":\"t1.`year`\"},{\"chart\":1069,\"field\":\"t1.`year`\"},{\"chart\":1070,\"field\":\"t1.`year`\"},{\"chart\":1071,\"field\":\"t1.`year`\"},{\"chart\":1072,\"field\":\"t1.`year`\"},{\"chart\":1073,\"field\":\"t1.`year`\"},{\"chart\":1074,\"field\":\"t1.`year`\"},{\"chart\":1075,\"field\":\"t1.`year`\"},{\"chart\":1076,\"field\":\"t1.`year`\"},{\"chart\":1077,\"field\":\"t1.`year`\"},{\"chart\":1078,\"field\":\"t1.`year`\"},{\"chart\":1079,\"field\":\"t1.`year`\"},{\"chart\":1080,\"field\":\"t1.`year`\"},{\"chart\":1081,\"field\":\"t1.`year`\"},{\"chart\":1082,\"field\":\"t1.`year`\"},{\"chart\":1083,\"field\":\"t1.`year`\"}],\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":120,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Select\",\"chartConfig\":{\"key\":\"Select\",\"chartKey\":\"VSelect\",\"conKey\":\"VCSelect\",\"title\":\"\\u9009\\u62e9\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/select-c616737a.png\"},\"option\":{\"dataset\":[{\"label\":\"\\u8bf7\\u9009\\u62e9\",\"value\":\"\"},{\"label\":\"\\u6cb3\\u5317\",\"value\":\"18700\"},{\"label\":\"\\u5f90\\u5dde\",\"value\":\"17800\"}],\"value\":\"\",\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"background\":\"none\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"backgroundColor\":\"transparent\",\"fontSize\":20,\"onChange\":\"console.log(value)\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":149,\"w\":750,\"h\":300,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":750,\"h\":120,\"x\":0,\"y\":153,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":230,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u516c\\u53f8\\u5e74\\u5ea6\\u65b0\\u589e\\u6570\\u636e\\u6982\\u89c8\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":225,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":225,\"y\":32,\"w\":500,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":770,\"y\":149,\"w\":530,\"h\":300,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":820,\"h\":120,\"x\":770,\"y\":153,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":230,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u516c\\u53f8\\u5e74\\u5ea6\\u5b8c\\u6210\\u6570\\u636e\\u6982\\u89c8\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":220,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":220,\"y\":32,\"w\":290,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":25,\"y\":229,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1055,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":145,\"y\":229,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1056,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4ea7\\u54c1\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4ea7\\u54c1\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4ea7\\u54c1\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":265,\"y\":229,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1057,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9700\\u6c42\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9700\\u6c42\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9700\\u6c42\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":385,\"y\":229,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1058,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"Bug\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"Bug\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"Bug\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":505,\"y\":229,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1059,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u8ba1\\u5212\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u8ba1\\u5212\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u8ba1\\u5212\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":25,\"y\":339,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1060,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9879\\u76ee\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9879\\u76ee\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9879\\u76ee\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":145,\"y\":339,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1061,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6267\\u884c\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6267\\u884c\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u6267\\u884c\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":265,\"y\":339,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1062,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4efb\\u52a1\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4efb\\u52a1\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4efb\\u52a1\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":385,\"y\":339,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1063,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u53d1\\u5e03\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":505,\"y\":339,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1064,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u53d1\\u5e03\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u53d1\\u5e03\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u53d1\\u5e03\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":250,\"x\":625,\"y\":229,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":190,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1065,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":60,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u7528\\u6237\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":78,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u7528\\u6237\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u7528\\u6237\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":800,\"y\":229,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1066,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u5b8c\\u6210\\u9879\\u76ee\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u5b8c\\u6210\\u9879\\u76ee\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5b8c\\u6210\\u9879\\u76ee\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":920,\"y\":229,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1067,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u5b8c\\u6210\\u6267\\u884c\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5b8c\\u6210\\u6267\\u884c\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":1040,\"y\":229,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1068,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u5b8c\\u6210\\u53d1\\u5e03\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u5b8c\\u6210\\u53d1\\u5e03\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5b8c\\u6210\\u53d1\\u5e03\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":800,\"y\":339,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1069,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":920,\"y\":339,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1070,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u89e3\\u51b3Bug\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u89e3\\u51b3Bug\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u89e3\\u51b3Bug\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":1040,\"y\":339,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1071,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":200,\"x\":1160,\"y\":229,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":190,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1072,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":54,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6295\\u5165\\u5de5\\u65f6\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":78,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6295\\u5165\\u5de5\\u65f6\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u6295\\u5165\\u5de5\\u65f6\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":1260,\"y\":165,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u5b8c\\u6210\\u7684\\u9879\\u76ee\\u4e2a\\u6570=\\u5df2\\u5173\\u95ed\\u7684\\u9879\\u76ee\\u4e2a\\u6570\\uff1b\\n\\u5b8c\\u6210\\u6267\\u884c\\u6570=\\u5df2\\u5173\\u95ed\\u7684\\u6267\\u884c\\u6570\\uff1b\\n\\u5b8c\\u6210\\u53d1\\u5e03\\u6570=\\u5168\\u90e8\\u53d1\\u5e03\\u6570\\uff1b\\n\\u5b8c\\u6210\\u7684\\u9700\\u6c42\\u6570=\\u5173\\u95ed\\u539f\\u56e0\\u4e3a\\u5df2\\u5b8c\\u6210\\u7684\\u9700\\u6c42\\u4e2a\\u6570\\uff1b\\n\\u4fee\\u590d\\u7684Bug\\u6570=Bug\\u72b6\\u6001\\u4e3a\\u5df2\\u5173\\u95ed\\u4e14\\u89e3\\u51b3\\u65b9\\u6848\\u4e3a\\u5df2\\u89e3\\u51b3\\u7684Bug\\u4e2a\\u6570\\uff1b\\n\\u5b8c\\u6210\\u7684\\u4efb\\u52a1\\u6570=\\u4efb\\u52a1\\u72b6\\u6001\\u4e3a\\u5df2\\u5b8c\\u6210+\\u5173\\u95ed\\u539f\\u56e0\\u4e3a\\u5df2\\u5b8c\\u6210\\u7684\\u4efb\\u52a1\\u6570\\u3002\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":479,\"w\":1300,\"h\":525,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":479,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":277,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9879\\u76ee\\u96c6\\u5e74\\u5ea6\\u65b0\\u589e\\u6570\\u636e\\u6c47\\u603b\\u8868\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":260,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":260,\"y\":32,\"w\":1015,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"1zhfrmecpnxc00\",\"sourceID\":1073,\"isGroup\":false,\"attr\":{\"x\":25,\"y\":57,\"w\":1250,\"h\":446,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TableScrollBoard\",\"chartConfig\":{\"key\":\"TableScrollBoard\",\"chartKey\":\"VTableScrollBoard\",\"conKey\":\"VCTableScrollBoard\",\"title\":\"\\u8f6e\\u64ad\\u5217\\u8868\",\"category\":\"Tables\",\"categoryName\":\"\\u8868\\u683c\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/table_scrollboard-fb642e78.png\"},\"option\":{\"header\":[\"\\u52171\",\"\\u52172\",\"\\u52173\"],\"dataset\":[[\"\\u884c1\\u52171\",\"\\u884c1\\u52172\",\"\\u884c1\\u52173\"],[\"\\u884c2\\u52171\",\"\\u884c2\\u52172\",\"\\u884c2\\u52173\"],[\"\\u884c3\\u52171\",\"\\u884c3\\u52172\",\"\\u884c3\\u52173\"],[\"\\u884c4\\u52171\",\"\\u884c4\\u52172\",\"\\u884c4\\u52173\"],[\"\\u884c5\\u52171\",\"\\u884c5\\u52172\",\"\\u884c5\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"]],\"index\":false,\"columnWidth\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":8,\"waitTime\":3,\"headerHeight\":45,\"carousel\":\"single\",\"headerBGC\":\"#165896FF\",\"oddRowBGC\":\"#042b4dFF\",\"evenRowBGC\":\"#0a1c37FF\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":1029,\"w\":1300,\"h\":525,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":1029,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":277,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9879\\u76ee\\u96c6\\u5e74\\u5ea6\\u5b8c\\u6210\\u6570\\u636e\\u6982\\u89c8\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":245,\"y\":31,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":245,\"y\":33,\"w\":1035,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"1zhfrmecpnxc00\",\"sourceID\":1074,\"isGroup\":false,\"attr\":{\"x\":25,\"y\":57,\"w\":1250,\"h\":446,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TableScrollBoard\",\"chartConfig\":{\"key\":\"TableScrollBoard\",\"chartKey\":\"VTableScrollBoard\",\"conKey\":\"VCTableScrollBoard\",\"title\":\"\\u8f6e\\u64ad\\u5217\\u8868\",\"category\":\"Tables\",\"categoryName\":\"\\u8868\\u683c\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/table_scrollboard-fb642e78.png\"},\"option\":{\"header\":[\"\\u52171\",\"\\u52172\",\"\\u52173\"],\"dataset\":[[\"\\u884c1\\u52171\",\"\\u884c1\\u52172\",\"\\u884c1\\u52173\"],[\"\\u884c2\\u52171\",\"\\u884c2\\u52172\",\"\\u884c2\\u52173\"],[\"\\u884c3\\u52171\",\"\\u884c3\\u52172\",\"\\u884c3\\u52173\"],[\"\\u884c4\\u52171\",\"\\u884c4\\u52172\",\"\\u884c4\\u52173\"],[\"\\u884c5\\u52171\",\"\\u884c5\\u52172\",\"\\u884c5\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"]],\"index\":false,\"columnWidth\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":8,\"waitTime\":3,\"headerHeight\":45,\"carousel\":\"single\",\"headerBGC\":\"#165896FF\",\"oddRowBGC\":\"#042b4dFF\",\"evenRowBGC\":\"#0a1c37FF\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":1579,\"w\":640,\"h\":525,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":640,\"h\":120,\"x\":0,\"y\":1579,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":17,\"y\":0,\"w\":277,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4ea7\\u54c1\\u5e74\\u5ea6\\u65b0\\u589e\\u6570\\u636e\\u6c47\\u603b\\u8868\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":244,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":245,\"y\":32,\"w\":370,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"1zhfrmecpnxc00\",\"sourceID\":1075,\"isGroup\":false,\"attr\":{\"x\":20,\"y\":57,\"w\":600,\"h\":446,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TableScrollBoard\",\"chartConfig\":{\"key\":\"TableScrollBoard\",\"chartKey\":\"VTableScrollBoard\",\"conKey\":\"VCTableScrollBoard\",\"title\":\"\\u8f6e\\u64ad\\u5217\\u8868\",\"category\":\"Tables\",\"categoryName\":\"\\u8868\\u683c\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/table_scrollboard-fb642e78.png\"},\"option\":{\"header\":[\"\\u52171\",\"\\u52172\",\"\\u52173\"],\"dataset\":[[\"\\u884c1\\u52171\",\"\\u884c1\\u52172\",\"\\u884c1\\u52173\"],[\"\\u884c2\\u52171\",\"\\u884c2\\u52172\",\"\\u884c2\\u52173\"],[\"\\u884c3\\u52171\",\"\\u884c3\\u52172\",\"\\u884c3\\u52173\"],[\"\\u884c4\\u52171\",\"\\u884c4\\u52172\",\"\\u884c4\\u52173\"],[\"\\u884c5\\u52171\",\"\\u884c5\\u52172\",\"\\u884c5\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"]],\"index\":false,\"columnWidth\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":8,\"waitTime\":3,\"headerHeight\":45,\"carousel\":\"single\",\"headerBGC\":\"#165896FF\",\"oddRowBGC\":\"#042b4dFF\",\"evenRowBGC\":\"#0a1c37FF\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":660,\"y\":1579,\"w\":640,\"h\":525,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":640,\"h\":120,\"x\":660,\"y\":1579,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":17,\"y\":0,\"w\":277,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4ea7\\u54c1\\u5e74\\u5ea6\\u5b8c\\u6210\\u6570\\u636e\\u6c47\\u603b\\u8868\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":244,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":245,\"y\":32,\"w\":370,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"1zhfrmecpnxc00\",\"sourceID\":1076,\"isGroup\":false,\"attr\":{\"x\":20,\"y\":57,\"w\":600,\"h\":446,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TableScrollBoard\",\"chartConfig\":{\"key\":\"TableScrollBoard\",\"chartKey\":\"VTableScrollBoard\",\"conKey\":\"VCTableScrollBoard\",\"title\":\"\\u8f6e\\u64ad\\u5217\\u8868\",\"category\":\"Tables\",\"categoryName\":\"\\u8868\\u683c\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/table_scrollboard-fb642e78.png\"},\"option\":{\"header\":[\"\\u52171\",\"\\u52172\",\"\\u52173\"],\"dataset\":[[\"\\u884c1\\u52171\",\"\\u884c1\\u52172\",\"\\u884c1\\u52173\"],[\"\\u884c2\\u52171\",\"\\u884c2\\u52172\",\"\\u884c2\\u52173\"],[\"\\u884c3\\u52171\",\"\\u884c3\\u52172\",\"\\u884c3\\u52173\"],[\"\\u884c4\\u52171\",\"\\u884c4\\u52172\",\"\\u884c4\\u52173\"],[\"\\u884c5\\u52171\",\"\\u884c5\\u52172\",\"\\u884c5\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"]],\"index\":false,\"columnWidth\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":8,\"waitTime\":3,\"headerHeight\":45,\"carousel\":\"single\",\"headerBGC\":\"#165896FF\",\"oddRowBGC\":\"#042b4dFF\",\"evenRowBGC\":\"#0a1c37FF\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":640,\"h\":500,\"x\":0,\"y\":2129,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9700\\u6c42\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"image\":\"\"},\"groupList\":[{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":640,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9700\\u6c42\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1077,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":60,\"w\":600,\"h\":416,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"LineCommon\",\"chartConfig\":{\"key\":\"LineCommon\",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"\\u6298\\u7ebf\\u56fe\",\"category\":\"Lines\",\"categoryName\":\"\\u6298\\u7ebf\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/line.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"(\\u6708\\u4efd)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"(\\u4e2a\\u6570)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"30\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{\"dimensions\":[],\"source\":[]},\"series\":[{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}},{\"id\":\"2u3zlsz5kk4000\",\"isGroup\":false,\"attr\":{\"x\":17,\"y\":0,\"w\":250,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9700\\u6c42\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9700\\u6c42\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":259,\"y\":32,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":260,\"y\":34,\"w\":350,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":640,\"h\":500,\"x\":660,\"y\":2129,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"BUG\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u89e3\\u51b3\\u8d8b\\u52bf\\u56fe\",\"image\":\"\"},\"groupList\":[{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":640,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"BUG\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u89e3\\u51b3\\u8d8b\\u52bf\\u56fe\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1078,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":60,\"w\":600,\"h\":416,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"LineCommon\",\"chartConfig\":{\"key\":\"LineCommon\",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"\\u6298\\u7ebf\\u56fe\",\"category\":\"Lines\",\"categoryName\":\"\\u6298\\u7ebf\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/line.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"(\\u6708\\u4efd)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"(\\u4e2a\\u6570)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"30\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{\"dimensions\":[],\"source\":[]},\"series\":[{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}},{\"id\":\"2u3zlsz5kk4000\",\"isGroup\":false,\"attr\":{\"x\":10,\"y\":0,\"w\":277,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"BUG\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u89e3\\u51b3\\u8d8b\\u52bf\\u56fe\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"BUG\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u89e3\\u51b3\\u8d8b\\u52bf\\u56fe\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":269,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":270,\"y\":32,\"w\":340,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":640,\"h\":500,\"x\":0,\"y\":2654,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4efb\\u52a1\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"image\":\"\"},\"groupList\":[{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":640,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u4efb\\u52a1\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1079,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":60,\"w\":600,\"h\":416,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"LineCommon\",\"chartConfig\":{\"key\":\"LineCommon \",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"\\u6298\\u7ebf\\u56fe\",\"category\":\"Lines\",\"categoryName\":\"\\u6298\\u7ebf\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/line.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"(\\u6708\\u4efd)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"(\\u4e2a\\u6570)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"30\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{\"dimensions\":[],\"source\":[]},\"series\":[{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}},{\"id\":\"2u3zlsz5kk4000\",\"isGroup\":false,\"attr\":{\"x\":17,\"y\":0,\"w\":250,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4efb\\u52a1\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4efb\\u52a1\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":259,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":260,\"y\":32,\"w\":350,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":640,\"h\":500,\"x\":660,\"y\":2654,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"image\":\"\"},\"groupList\":[{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":640,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1080,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":60,\"w\":600,\"h\":416,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"LineCommon\",\"chartConfig\":{\"key\":\"LineCommon\",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"\\u6298\\u7ebf\\u56fe\",\"category\":\"Lines\",\"categoryName\":\"\\u6298\\u7ebf\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/line.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"(\\u6708\\u4efd)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"(\\u4e2a\\u6570)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"30\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{\"dimensions\":[],\"source\":[]},\"series\":[{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}},{\"id\":\"2u3zlsz5kk4000\",\"isGroup\":false,\"attr\":{\"x\":17,\"y\":0,\"w\":250,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9879\\u76ee\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9879\\u76ee\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":259,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":260,\"y\":32,\"w\":350,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":640,\"h\":500,\"x\":0,\"y\":3179,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6267\\u884c\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"image\":\"\"},\"groupList\":[{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":640,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u6267\\u884c\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1081,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":60,\"w\":600,\"h\":416,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"LineCommon\",\"chartConfig\":{\"key\":\"LineCommon\",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"\\u6298\\u7ebf\\u56fe\",\"category\":\"Lines\",\"categoryName\":\"\\u6298\\u7ebf\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/line.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"(\\u6708\\u4efd)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"(\\u4e2a\\u6570)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"30\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{\"dimensions\":[],\"source\":[]},\"series\":[{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}},{\"id\":\"2u3zlsz5kk4000\",\"isGroup\":false,\"attr\":{\"x\":17,\"y\":0,\"w\":250,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6267\\u884c\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u6267\\u884c\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":259,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":260,\"y\":32,\"w\":350,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":640,\"h\":500,\"x\":660,\"y\":3179,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4ea7\\u54c1\\u53d1\\u5e03\\u6b21\\u6570\\u5e74\\u5ea6\\u8d8b\\u52bf\\u56fe\",\"image\":\"\"},\"groupList\":[{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":640,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u4ea7\\u54c1\\u53d1\\u5e03\\u6b21\\u6570\\u5e74\\u5ea6\\u8d8b\\u52bf\\u56fe\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1082,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":60,\"w\":600,\"h\":416,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"LineCommon\",\"chartConfig\":{\"key\":\"LineCommon\",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"\\u6298\\u7ebf\\u56fe\",\"category\":\"Lines\",\"categoryName\":\"\\u6298\\u7ebf\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/line.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"(\\u6708\\u4efd)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"(\\u4e2a\\u6570)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"30\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{\"dimensions\":[],\"source\":[]},\"series\":[{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}},{\"id\":\"2u3zlsz5kk4000\",\"isGroup\":false,\"attr\":{\"x\":17,\"y\":0,\"w\":230,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4ea7\\u54c1\\u53d1\\u5e03\\u6b21\\u6570\\u5e74\\u5ea6\\u8d8b\\u52bf\\u56fe\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4ea7\\u54c1\\u53d1\\u5e03\\u6b21\\u6570\\u5e74\\u5ea6\\u8d8b\\u52bf\\u56fe\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":239,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":240,\"y\":32,\"w\":370,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":3709,\"w\":1300,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":500,\"x\":0,\"y\":3709,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u5e74\\u5ea6\\u6295\\u5165\\u4ea7\\u51fa\\u6bd4\",\"image\":\"\"},\"option\":{},\"groupList\":[{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":17,\"y\":0,\"w\":155,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u5e74\\u5ea6\\u6295\\u5165\\u4ea7\\u51fa\\u6bd4\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1083,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":60,\"w\":1300,\"h\":416,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"LineCommon\",\"chartConfig\":{\"key\":\"LineCommon\",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"\\u6298\\u7ebf\\u56fe\",\"category\":\"Lines\",\"categoryName\":\"\\u6298\\u7ebf\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/line.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":[{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"right\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"}],\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"20\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{\"dimensions\":[],\"source\":[]},\"series\":[{\"type\":\"line\",\"yAxisIndex\":1,\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"bar\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"bar\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}},{\"id\":\"2u3zlsz5kk4000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":155,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u5e74\\u5ea6\\u6295\\u5165\\u4ea7\\u51fa\\u6bd4\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5e74\\u5ea6\\u6295\\u5165\\u4ea7\\u51fa\\u6bd4\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":164,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":165,\"y\":32,\"w\":1080,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"contain\",\"borderRadius\":0}}],\"key\":\"group\"},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":1245,\"y\":3726,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"\\/static\\/png\\/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u6295\\u5165\\u4ea7\\u51fa\\u6bd4=\\u9700\\u6c42\\u4ea4\\u4ed8\\u6545\\u4e8b\\u70b9\\u6570\\/\\u5de5\\u65f6\\u6d88\\u8017\\uff1b\\n\\u9700\\u6c42\\u4ea4\\u4ed8\\u6545\\u4e8b\\u70b9\\u6570=\\u5173\\u95ed\\u539f\\u56e0\\u4e3a\\u5df2\\u5b8c\\u6210\\u7684\\u9700\\u6c42\\u7684\\u6545\\u4e8b\\u70b9\\u6570\\u003b\\n\\u5de5\\u65f6\\u6d88\\u8017=\\u4efb\\u52a1\\u6d88\\u8017\\u7684\\u5de5\\u65f6\\u3002\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}}]' WHERE `id` = 2;

UPDATE `zt_chart` SET `sql` = 'select tt.topProgram,tt.programID as id,tt.`year`,sum(tt.product) as product,sum(tt.plan) as plan,sum(tt.`release`) as `release`,sum(tt.story) as story,sum(tt.bug) as bug,sum(tt.doc) as doc\r\nfrom (\r\nselect t2.name as topProgram,t2.id as programID,t0.`year`,count(1) as product,0 as plan,0 as story,0 as bug,0 as `release`, 0 as doc\r\nfrom zt_product t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.createdDate) = t0.`year`\r\nleft join zt_project t2 on t1.program = t2.id\r\nwhere t1.deleted = \'0\' and t1.shadow = \'0\'\r\nand t2.type = \'program\' and t2.grade = 1 and t2.deleted = \'0\'\r\ngroup by t2.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as product,count(1) as plan,0 as story,0 as bug,0 as `release`, 0 as doc\r\nfrom zt_productplan t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.createdDate) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as product,0 as plan,0 as story,0 as bug,0 as `release`, count(1) as doc\r\nfrom zt_doc t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.addedDate) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as product,0 as plan,0 as story,0 as bug,0 as `release`, count(distinct t1.id) as doc\r\nfrom zt_doc t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.addedDate) = t0.`year`\r\nleft join zt_projectproduct t4 on t1.project = t4.project\r\nleft join zt_product t2 on t2.id = t4.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as product,0 as plan,0 as story,0 as bug,count(1) as `release`, 0 as doc\r\nfrom zt_release t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.date) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as product,0 as plan,count(1) as story,0 as bug,0 as `release`, 0 as doc\r\nfrom zt_story t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.openedDate) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as product,0 as plan,0 as story,count(1) as bug,0 as `release`, 0 as doc\r\nfrom zt_bug t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.openedDate) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\n) tt\r\ngroup by tt.programID, tt.`year`' WHERE `name` = '年度新增-项目集年度新增数据汇总表';
UPDATE `zt_chart` SET `sql` = 'select tt.topProgram,tt.programID as id,tt.`year`,sum(tt.projectA) as projectA,sum(tt.executionA) as executionA,sum(tt.releaseA) as `release`,sum(tt.storyA) as story,sum(tt.bugA) as bug \r\nfrom (\r\nselect t2.name as topProgram,t2.id as programID,t0.`year`,count(1) as projectA,0 as executionA,0 as releaseA,0 as storyA,0 as bugA\r\nfrom zt_project t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.closedDate) = t0.`year`\r\nleft join zt_project t2 on FIND_IN_SET(t2.id, t1.path)\r\nwhere t1.type = \'project\' and t1.deleted = \'0\'\r\nand t2.type = \'program\' and t2.grade = 1 and t2.deleted = \'0\'\r\nand t1.`status` = \'closed\'\r\ngroup by t2.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram, t3.id as programID,t0.`year`,0 as projectA,count(1) as executionA,0 as releaseA,0 as storyA,0 as bugA\r\nfrom zt_project t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.closedDate) = t0.`year`\r\nleft join zt_project t2 on t1.parent = t2.id\r\nleft join zt_project t3 on FIND_IN_SET(t3.id, t2.path)\r\nwhere t1.type in (\'sprint\', \'stage\', \'kanban\') and t1.deleted = \'0\'\r\nand t2.type = \'project\' and t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\nand t1.`status` = \'closed\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as projectA,0 as executionA,count(1) as releaseA,0 as storyA,0 as bugA\r\nfrom zt_release t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.date) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as projectA,0 as executionA,0 as releaseA,count(1) as storyA,0 as bugA\r\nfrom zt_story t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.closedDate) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\' and t1.closedReason = \'done\' and t1.status = \'closed\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as projectA,0 as executionA,0 as releaseA,0 as storyA,count(1) as bugA\r\nfrom zt_bug t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.resolvedDate) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\' and t1.resolution = \'fixed\' and t1.status = \'closed\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\n) tt\r\ngroup by tt.programID, tt.`year`' WHERE `name` = '年度新增-项目集年度完成数据概览';
UPDATE `zt_chart` SET `sql` = 'SELECT\r\n    t1.name,t1.id,t2.`year`,IF(YEAR(t1.createdDate) = t2.`year`, 1, 0) as newProduct,\r\n    SUM(IFNULL(t3.story, 0)) AS story,\r\n    SUM(IFNULL(t4.bug, 0)) AS bug,\r\n    SUM(IFNULL(t5.`plan`, 0)) AS \'plan\',\r\n    SUM(IFNULL(t6.`release`, 0)) AS \'release\'\r\nFROM zt_product AS t1\r\nLEFT JOIN (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) as t2 ON 1 = 1\r\nLEFT JOIN (SELECT COUNT(1) as \'story\', product, YEAR(openedDate) as `year` FROM zt_story WHERE deleted = \'0\' GROUP BY product, `year`) AS t3 on t1.id = t3.product AND t3.`year` = t2.`year`\r\nLEFT JOIN (SELECT COUNT(1) as \'bug\', product, YEAR(openedDate) as `year` FROM zt_bug WHERE deleted = \'0\' GROUP BY product, `year`) AS t4 on t1.id = t4.product AND t4.`year` = t2.`year`\r\nLEFT JOIN (SELECT COUNT(1) as \'plan\', product, YEAR(createdDate) AS \'year\' FROM zt_productplan WHERE deleted = \'0\' GROUP BY product,`year`) AS t5 on t1.id = t5.product AND t5.`year` = t2.`year`\r\nLEFT JOIN (SELECT COUNT(1) as \'release\', product, YEAR(`date`) as `year` FROM zt_release WHERE deleted = \'0\' GROUP BY product, `year`) AS t6 ON t1.id = t6.product AND t6.`year` = t2.`year`\r\nWHERE t1.deleted = \'0\' AND t1.status != \'closed\' AND t1.shadow = \'0\'\r\nGROUP BY t1.name,t1.id,t2.`year`,newProduct' WHERE `name` = '年度新增-产品年度新增数据汇总表';
