ALTER TABLE `zt_review` MODIFY `doc` varchar(255) DEFAULT '';
ALTER TABLE `zt_review` MODIFY `docVersion` varchar(255) DEFAULT '';
ALTER TABLE `zt_review` MODIFY `template` mediumint(8) NOT NULL DEFAULT '0';
ALTER TABLE `zt_review` MODIFY `createdDate` date NULL;
ALTER TABLE `zt_review` MODIFY `deadline` date NULL;
ALTER TABLE `zt_review` MODIFY `lastReviewedDate` date NULL;
ALTER TABLE `zt_review` MODIFY `lastAuditedDate` date NULL;
ALTER TABLE `zt_review` MODIFY `lastEditedDate` date NULL;

ALTER TABLE `zt_meeting` MODIFY `minutedDate` datetime NULL;
ALTER TABLE `zt_meeting` MODIFY `editedDate` datetime NULL;

ALTER TABLE `zt_story` MODIFY `submitedBy` varchar(30) DEFAULT '';
ALTER TABLE `zt_story` MODIFY `demand` mediumint(8) DEFAULT 0;
ALTER TABLE `zt_story` MODIFY `duration` char(30) DEFAULT '';
ALTER TABLE `zt_story` MODIFY `BSA` char(30) DEFAULT '';

CREATE INDEX `metricCode` ON zt_metriclib (metricCode) USING BTREE;
CREATE INDEX `metricID` ON zt_metriclib (metricID) USING BTREE;

ALTER TABLE `zt_feedback` ADD COLUMN `keywords` varchar(255) NOT NULL DEFAULT '';

DELETE FROM `zt_cron` WHERE command='moduleName=measurement&methodName=initCrontabQueue';
DELETE FROM `zt_cron` WHERE command='moduleName=measurement&methodName=execCrontabQueue';

ALTER TABLE `zt_burn` MODIFY `execution` mediumint(8) unsigned NOT NULL DEFAULT '0';
ALTER TABLE `zt_burn` MODIFY `estimate` float NOT NULL DEFAULT '0';
ALTER TABLE `zt_burn` MODIFY `left` float NOT NULL DEFAULT '0';
ALTER TABLE `zt_burn` MODIFY `consumed` float NOT NULL DEFAULT '0';

ALTER TABLE `zt_task` MODIFY `design` mediumint(8) unsigned NOT NULL DEFAULT '0';
ALTER TABLE `zt_task` MODIFY `designVersion` smallint(6) unsigned NOT NULL DEFAULT '1';
ALTER TABLE `zt_task` MODIFY `left` float unsigned NOT NULL DEFAULT '0';
ALTER TABLE `zt_task` MODIFY `subStatus` varchar(30) NOT NULL DEFAULT '';
ALTER TABLE `zt_task` MODIFY `color` char(7) NOT NULL DEFAULT '';
ALTER TABLE `zt_task` MODIFY `desc` mediumtext NULL;
ALTER TABLE `zt_task` MODIFY `version` smallint(6) NOT NULL DEFAULT '0';
ALTER TABLE `zt_task` MODIFY `assignedTo` varchar(30) NOT NULL DEFAULT '';
ALTER TABLE `zt_task` MODIFY `project` mediumint(8) unsigned NOT NULL DEFAULT '0';
ALTER TABLE `zt_task` MODIFY `execution` mediumint(8) unsigned NOT NULL DEFAULT '0';
ALTER TABLE `zt_task` MODIFY `consumed` float unsigned NOT NULL DEFAULT '0';
ALTER TABLE `zt_task` MODIFY `openedBy` varchar(30) NOT NULL DEFAULT '';

ALTER TABLE `zt_effort` MODIFY `extra` text NULL;

UPDATE `zt_chart` SET `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"YEARMONTH\",\"name\":\"YEARMONTH\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"newStory\",\"name\":\"\\u7ee7\\u7eed\\u6dfb\\u52a0\\u7814\\u53d1\\u9700\\u6c42\",\"valOrAgg\":\"sum\"},{\"field\":\"closedStory\",\"name\":\"\\u9700\\u6c42\\uff1a%s \\u5df2\\u5173\\u95ed\\uff0c\\u5c06\\u4e0d\\u4f1a\\u88ab\\u5173\\u95ed\\u3002\",\"valOrAgg\":\"sum\"}],\"rotateX\":\"notuse\"}]', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u5ea6\"}]', `fields` = '{\"YEARMONTH\":{\"name\":\"YEARMONTH\",\"object\":\"story\",\"field\":\"YEARMONTH\",\"type\":\"string\"},\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"story\",\"field\":\"month\",\"type\":\"number\"},\"newStory\":{\"name\":\"\\u7ee7\\u7eed\\u6dfb\\u52a0\\u7814\\u53d1\\u9700\\u6c42\",\"object\":\"story\",\"field\":\"newStory\",\"type\":\"string\"},\"closedStory\":{\"name\":\"\\u9700\\u6c42\\uff1a%s \\u5df2\\u5173\\u95ed\\uff0c\\u5c06\\u4e0d\\u4f1a\\u88ab\\u5173\\u95ed\\u3002\",\"object\":\"story\",\"field\":\"closedStory\",\"type\":\"string\"}}', `langs` = '{\"YEARMONTH\":{\"zh-cn\":\"YEARMONTH\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"year\":{\"zh-cn\":\"\\u5e74\\u5ea6\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"newStory\":{\"zh-cn\":\"\\u65b0\\u589e\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"closedStory\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT t1.YEARMONTH, t1.year, t1.month AS `month`, IFNULL(t2.story, 0) AS newStory, IFNULL(t3.story, 0) AS closedStory\nFROM (SELECT DISTINCT DATE_FORMAT(date, \'%Y-%m\') YEARMONTH, Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS story FROM zt_story WHERE deleted = \'0\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS story FROM zt_story WHERE deleted = \'0\' AND closedReason = \'done\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\nORDER BY `year`, t1.month' WHERE `name` = '年度新增-需求年度新增和完成趋势图';
UPDATE `zt_chart` SET `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"YEARMONTH\",\"name\":\"YEARMONTH\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"newBug\",\"name\":\"newBug\",\"valOrAgg\":\"sum\"},{\"field\":\"fixedBug\",\"name\":\"fixedBug\",\"valOrAgg\":\"sum\"}]}]', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u5ea6\"}]', `fields` = '{\"YEARMONTH\":{\"name\":\"YEARMONTH\",\"object\":\"bug\",\"field\":\"YEARMONTH\",\"type\":\"string\"},\"year\":{\"name\":\"year\",\"object\":\"bug\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"bug\",\"field\":\"month\",\"type\":\"number\"},\"newBug\":{\"name\":\"newBug\",\"object\":\"bug\",\"field\":\"newBug\",\"type\":\"string\"},\"fixedBug\":{\"name\":\"fixedBug\",\"object\":\"bug\",\"field\":\"fixedBug\",\"type\":\"string\"}}', `langs` = '{\"YEARMONTH\":{\"zh-cn\":\"\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"year\":{\"zh-cn\":\"\\u5e74\\u5ea6\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"newBug\":{\"zh-cn\":\"\\u65b0\\u589eBug\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"fixedBug\":{\"zh-cn\":\"\\u89e3\\u51b3Bug\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEARMONTH, t1.year, t1.month AS `month`, IFNULL(t2.bug, 0) AS newBug, IFNULL(t3.bug, 0) AS fixedBug\nFROM (SELECT DISTINCT DATE_FORMAT(date, \'%Y-%m\') YEARMONTH, Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS bug FROM zt_bug WHERE deleted = \'0\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS bug FROM zt_bug WHERE deleted = \'0\' AND resolution = \'fixed\' AND status = \'closed\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\nORDER BY `year`, t1.month' WHERE `name` = '年度新增-Bug年度新增和解决趋势图';
UPDATE `zt_chart` SET `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"YEARMONTH\",\"name\":\"YEARMONTH\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"newTask\",\"name\":\"newTask\",\"valOrAgg\":\"sum\"},{\"field\":\"closedTask\",\"name\":\"closedTask\",\"valOrAgg\":\"sum\"}]}]', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u5ea6\"}]', `fields` = '{\"YEARMONTH\":{\"name\":\"YEARMONTH\",\"object\":\"task\",\"field\":\"YEARMONTH\",\"type\":\"string\"},\"year\":{\"name\":\"year\",\"object\":\"task\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"task\",\"field\":\"month\",\"type\":\"string\"},\"newTask\":{\"name\":\"newTask\",\"object\":\"task\",\"field\":\"newTask\",\"type\":\"string\"},\"closedTask\":{\"name\":\"closedTask\",\"object\":\"task\",\"field\":\"closedTask\",\"type\":\"string\"}}', `langs` = '{\"YEARMONTH\":{\"zh-cn\":\"YEARMONTH\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"year\":{\"zh-cn\":\"\\u5e74\\u5ea6\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"newTask\":{\"zh-cn\":\"\\u65b0\\u589e\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"closedTask\":{\"zh-cn\":\"\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEARMONTH, t1.year, CONCAT(t1.month, \"月\") AS `month`, IFNULL(t2.task, 0) AS newTask, IFNULL(t3.task, 0) AS closedTask\nFROM (SELECT DISTINCT DATE_FORMAT(date, \'%Y-%m\') YEARMONTH, Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS task FROM zt_task WHERE deleted = \'0\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS task FROM zt_task WHERE deleted = \'0\' AND status = \'closed\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\nORDER BY `year`, t1.month' WHERE `name` = '年度新增-任务年度新增和完成趋势图';
UPDATE `zt_chart` SET `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"YEARMONTH\",\"name\":\"YEARMONTH\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"newProject\",\"name\":\"newProject\",\"valOrAgg\":\"sum\"},{\"field\":\"closedProject\",\"name\":\"\\u5df2\\u5173\\u95ed\\u7684\\u9879\\u76ee\",\"valOrAgg\":\"sum\"}]}]', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u5ea6\"}]', `fields` = '{\"YEARMONTH\":{\"name\":\"YEARMONTH\",\"object\":\"project\",\"field\":\"YEARMONTH\",\"type\":\"string\"},\"year\":{\"name\":\"year\",\"object\":\"project\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"project\",\"field\":\"month\",\"type\":\"string\"},\"newProject\":{\"name\":\"newProject\",\"object\":\"project\",\"field\":\"newProject\",\"type\":\"string\"},\"closedProject\":{\"name\":\"\\u5df2\\u5173\\u95ed\\u7684\\u9879\\u76ee\",\"object\":\"project\",\"field\":\"closedProject\",\"type\":\"string\"}}', `langs` = '{\"YEARMONTH\":{\"zh-cn\":\"YEARMONTH\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"year\":{\"zh-cn\":\"\\u5e74\\u5ea6\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"newProject\":{\"zh-cn\":\"\\u65b0\\u589e\\u9879\\u76ee\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"closedProject\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9879\\u76ee\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEARMONTH, t1.year, CONCAT(t1.month, \"月\") AS `month`, IFNULL(t2.project, 0) AS newProject, IFNULL(t3.project, 0) AS closedProject\nFROM (SELECT DISTINCT DATE_FORMAT(date, \'%Y-%m\') YEARMONTH, Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS project FROM zt_project WHERE deleted = \'0\' AND type = \'project\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS project FROM zt_project WHERE deleted = \'0\' AND type = \'project\' AND status = \'closed\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\nORDER BY `year`, t1.month' WHERE `name` = '年度新增-项目年度新增和完成趋势图';
UPDATE `zt_chart` SET `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"YEARMONTH\",\"name\":\"YEARMONTH\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"newExecution\",\"name\":\"newExecution\",\"valOrAgg\":\"sum\"},{\"field\":\"closedExecution\",\"name\":\"closedExecution\",\"valOrAgg\":\"sum\"}]}]', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u5ea6\"}]', `fields` = '{\"YEARMONTH\":{\"name\":\"YEARMONTH\",\"object\":\"project\",\"field\":\"YEARMONTH\",\"type\":\"string\"},\"year\":{\"name\":\"year\",\"object\":\"project\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"project\",\"field\":\"month\",\"type\":\"string\"},\"newExecution\":{\"name\":\"newExecution\",\"object\":\"project\",\"field\":\"newExecution\",\"type\":\"string\"},\"closedExecution\":{\"name\":\"closedExecution\",\"object\":\"project\",\"field\":\"closedExecution\",\"type\":\"string\"}}', `langs` = '{\"YEARMONTH\":{\"zh-cn\":\"YEARMONTH\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"year\":{\"zh-cn\":\"\\u5e74\\u5ea6\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"newExecution\":{\"zh-cn\":\"\\u65b0\\u589e\\u6267\\u884c\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"closedExecution\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6267\\u884c\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEARMONTH, t1.year, CONCAT(t1.month, \"月\") AS `month`, IFNULL(t2.execution, 0) AS newExecution, IFNULL(t3.execution, 0) AS closedExecution\nFROM (SELECT DISTINCT DATE_FORMAT(date, \'%Y-%m\') YEARMONTH,YEAR(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS execution FROM zt_project WHERE deleted = \'0\' AND type IN (\'sprint\', \'stage\', \'kanban\') AND multiple = \'1\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS execution FROM zt_project WHERE deleted = \'0\' AND type IN (\'sprint\', \'stage\', \'kanban\') AND status = \'closed\' AND multiple = \'1\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\nORDER BY `year`, t1.month' WHERE `name` = '年度新增-执行年度新增和完成趋势图';
UPDATE `zt_chart` SET `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"YEARMONTH\",\"name\":\"YEARMONTH\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"release\",\"name\":\"release\",\"valOrAgg\":\"sum\"}]}]', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u5ea6\"}]', `fields` = '{\"YEARMONTH\":{\"name\":\"YEARMONTH\",\"object\":\"release\",\"field\":\"YEARMONTH\",\"type\":\"string\"},\"year\":{\"name\":\"year\",\"object\":\"release\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"release\",\"field\":\"month\",\"type\":\"string\"},\"release\":{\"name\":\"release\",\"object\":\"release\",\"field\":\"release\",\"type\":\"string\"}}', `langs` = '{\"YEARMONTH\":{\"zh-cn\":\"YEARMONTH\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"year\":{\"zh-cn\":\"\\u5e74\\u5ea6\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"release\":{\"zh-cn\":\"\\u53d1\\u5e03\\u6b21\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEARMONTH, t1.year, CONCAT(t1.month, \"月\") AS `month`, IFNULL(t2.release, 0) AS `release`\nFROM (SELECT DISTINCT DATE_FORMAT(date, \'%Y-%m\') YEARMONTH,Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(createdDate) AS `year`, MONTH(createdDate) AS `month`, COUNT(1) AS `release` FROM zt_release WHERE deleted = \'0\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nORDER BY `year`, t1.month' WHERE `name` = '年度新增-产品发布次数年度趋势图';
UPDATE `zt_chart` SET `sql` = "SELECT id FROM (SELECT id,deleted FROM zt_task WHERE `status` NOT IN ('closed','cancel','done')) AS task WHERE task.deleted='0'" WHERE `id` = 1040;

UPDATE `zt_chart` SET `sql` = "SELECT t1.name,t1.id,t2.`year`,IF(YEAR(t1.createdDate) = t2.`year`, 1, 0) as newProduct, SUM(IFNULL(t3.story, 0)) AS story, SUM(IFNULL(t4.bug, 0)) AS bug, SUM(IFNULL(t5.`plan`, 0)) AS 'plan', SUM(IFNULL(t6.`release`, 0)) AS 'release' FROM zt_product AS t1 LEFT JOIN (SELECT DISTINCT YEAR(`date`) as 'year' FROM zt_action) as t2 ON 1 = 1 LEFT JOIN (SELECT COUNT(1) as 'story', product, YEAR(openedDate) as `year` FROM zt_story WHERE deleted = '0' GROUP BY product, `year`) AS t3 on t1.id = t3.product AND t3.`year` = t2.`year` LEFT JOIN (SELECT COUNT(1) as 'bug', product, YEAR(openedDate) as `year` FROM zt_bug WHERE deleted = '0' GROUP BY product, `year`) AS t4 on t1.id = t4.product AND t4.`year` = t2.`year` LEFT JOIN (SELECT COUNT(1) as 'plan', product, YEAR(createdDate) AS 'year' FROM zt_productplan WHERE deleted = '0' GROUP BY product,`year`) AS t5 on t1.id = t5.product AND t5.`year` = t2.`year` LEFT JOIN (SELECT COUNT(1) as 'release', product, YEAR(`date`) as `year` FROM zt_release WHERE deleted = '0' GROUP BY product, `year`) AS t6 ON t1.id = t6.product AND t6.`year` = t2.`year` WHERE t1.deleted = '0' AND t1.status != 'closed' AND t1.shadow = '0' GROUP BY t1.name,t1.id,t2.`year`,newProduct" WHERE `id` = 1075;

UPDATE `zt_cron` SET `h` = '1', `m` = '0' WHERE `command` = 'moduleName=metric&methodName=updateMetricLib';

UPDATE `zt_pivot` SET `fields` = '{\"account\":{\"object\":\"effort\",\"field\":\"account\",\"type\":\"user\",\"name\":\"account\"},\"consumed\":{\"object\":\"effort\",\"field\":\"consumed\",\"type\":\"object\",\"name\":\"consumed\"},\"date\":{\"object\":\"effort\",\"field\":\"date\",\"type\":\"object\",\"name\":\"date\"},\"dept\":{\"object\":\"user\",\"field\":\"dept\",\"type\":\"string\",\"name\":\"dept\"}}' WHERE `name` = '{\"zh-cn\":\"\\u65e5\\u5fd7\\u6c47\\u603b\\u8868\",\"zh-tw\":\"\\u65e5\\u8a8c\\u532f\\u7e3d\\u8868\",\"en\":\"Effort Summary\",\"de\":\"Effort Summary\",\"fr\":\"Effort Summary\"}';
UPDATE `zt_pivot` SET `sql` = 'SELECT\n    COALESCE(p.id, 0) AS projectID,\n    p.name AS projectName,\n    COALESCE(e.id, 0) AS executionID,\n    e.name AS executionName,\n    b.id,\n    b.resolution\nFROM zt_bug AS b\nLEFT JOIN zt_project AS p ON b.project = p.id\nLEFT JOIN zt_project AS e ON b.execution = e.id AND e.parent != 0\nWHERE p.id != 0 AND p.deleted = \'0\' AND b.deleted = \'0\' AND b.resolution != \'\' AND if($project=\'\',1,p.id=$project) AND if($execution=\'\',1,e.id=$execution)', `fields` = '{\"projectID\":{\"name\":\"projectID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"string\"},\"projectName\":{\"name\":\"projectName\",\"object\":\"project\",\"field\":\"name\",\"type\":\"object\"},\"executionID\":{\"name\":\"executionID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"string\"},\"executionName\":{\"name\":\"executionName\",\"object\":\"project\",\"field\":\"name\",\"type\":\"object\"},\"id\":{\"name\":\"Bug\\u7f16\\u53f7\",\"object\":\"bug\",\"field\":\"id\",\"type\":\"number\"},\"resolution\":{\"name\":\"resolution\",\"object\":\"bug\",\"field\":\"resolution\",\"type\":\"option\"}}', `langs` = '{\"projectID\":{\"zh-cn\":\"\\u9879\\u76eeID\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"projectName\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"executionID\":{\"zh-cn\":\"\\u6267\\u884cID\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"executionName\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"Bug\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"resolution\":{\"zh-cn\":\"\\u89e3\\u51b3\\u65b9\\u6848\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}}', `settings` = '{\"columns\":[{\"field\":\"resolution\",\"stat\":\"count\",\"slice\":\"resolution\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"sum\",\"showOrigin\":\"0\"}],\"filterType\":\"query\",\"columnTotal\":\"noShow\",\"group1\":\"projectName\",\"group2\":\"executionName\",\"lastStep\":\"4\"}', `filters` = '[{\"from\":\"query\",\"field\":\"project\",\"type\":\"select\",\"typeOption\":\"project\",\"name\":\"\\u9879\\u76ee\\u5217\\u8868\",\"default\":\"\"},{\"from\":\"query\",\"field\":\"execution\",\"type\":\"select\",\"typeOption\":\"execution\",\"name\":\"\\u6267\\u884c\\u5217\\u8868\",\"default\":\"\"}]' WHERE `name` = '{\"zh-cn\":\"\\u9879\\u76eeBug\\u89e3\\u51b3\\u65b9\\u6848\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76eeBug\\u89e3\\u6c7a\\u65b9\\u6848\\u5206\\u5e03\\u8868\",\"en\":\"Project Bug Resolution\",\"de\":\"Project Bug Resolution\",\"fr\":\"Project Bug Resolution\",\"vi\":\"Project Bug Resolution\",\"ja\":\"Project Bug Resolution\"}';

UPDATE `zt_chart` SET `sql` = 'select tt.topProgram,tt.programID as id,tt.`year`,sum(tt.product) as product,sum(tt.plan) as plan,sum(tt.`release`) as `release`,sum(tt.story) as story,sum(tt.bug) as bug,sum(tt.doc) as doc\r\nfrom (\r\nselect t2.name as topProgram,t2.id as programID,t0.`year`,count(1) as product,0 as plan,0 as story,0 as bug,0 as `release`, 0 as doc\r\nfrom zt_product t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.createdDate) = t0.`year`\r\nleft join zt_project t2 on t1.program = t2.id\r\nwhere t1.deleted = \'0\' and t1.shadow = \'0\'\r\nand t2.type = \'program\' and t2.grade = 1 and t2.deleted = \'0\'\r\ngroup by t2.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as product,count(1) as plan,0 as story,0 as bug,0 as `release`, 0 as doc\r\nfrom zt_productplan t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.createdDate) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as product,0 as plan,0 as story,0 as bug,0 as `release`, count(1) as doc\r\nfrom zt_doc t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.addedDate) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as product,0 as plan,0 as story,0 as bug,count(1) as `release`, 0 as doc\r\nfrom zt_release t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.date) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as product,0 as plan,count(1) as story,0 as bug,0 as `release`, 0 as doc\r\nfrom zt_story t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.openedDate) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as product,0 as plan,0 as story,count(1) as bug,0 as `release`, 0 as doc\r\nfrom zt_bug t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.openedDate) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\n) tt\r\ngroup by tt.programID, tt.`year`' WHERE `name` = '年度新增-项目集年度新增数据汇总表';
UPDATE `zt_chart` SET `sql` = 'select tt.topProgram,tt.programID as id,tt.`year`,sum(tt.projectA) as projectA,sum(tt.executionA) as executionA,sum(tt.releaseA) as `release`,sum(tt.storyA) as story,sum(tt.bugA) as bug \r\nfrom (\r\nselect t2.name as topProgram,t2.id as programID,t0.`year`,count(1) as projectA,0 as executionA,0 as releaseA,0 as storyA,0 as bugA\r\nfrom zt_project t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.closedDate) = t0.`year`\r\nleft join zt_project t2 on FIND_IN_SET(t2.id, t1.path)\r\nwhere t1.type = \'project\' and t1.deleted = \'0\'\r\nand t2.type = \'program\' and t2.grade = 1 and t2.deleted = \'0\'\r\nand t1.`status` = \'closed\'\r\ngroup by t2.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram, t3.id as programID,t0.`year`,0 as projectA,count(1) as executionA,0 as releaseA,0 as storyA,0 as bugA\r\nfrom zt_project t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.closedDate) = t0.`year`\r\nleft join zt_project t2 on t1.parent = t2.id\r\nleft join zt_project t3 on FIND_IN_SET(t3.id, t2.path)\r\nwhere t1.type in (\'sprint\', \'stage\', \'kanban\') and t1.deleted = \'0\'\r\nand t2.type = \'project\' and t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\nand t1.`status` = \'closed\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as projectA,0 as executionA,count(1) as releaseA,0 as storyA,0 as bugA\r\nfrom zt_release t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.date) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as projectA,0 as executionA,0 as releaseA,count(1) as storyA,0 as bugA\r\nfrom zt_story t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.closedDate) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\' and t1.closedReason = \'done\' and t1.status = \'closed\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as projectA,0 as executionA,0 as releaseA,0 as storyA,count(1) as bugA\r\nfrom zt_bug t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.resolvedDate) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\' and t1.resolution = \'fixed\' and t1.status = \'closed\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\n) tt\r\ngroup by tt.programID, tt.`year`' WHERE `name` = '年度新增-项目集年度完成数据概览';
UPDATE `zt_chart` SET `sql` = 'SELECT\r\n    t1.name,t1.id,t2.`year`,IF(YEAR(t1.createdDate) = t2.`year`, 1, 0) as newProduct,\r\n    SUM(IFNULL(t3.story, 0)) AS story,\r\n    SUM(IFNULL(t4.bug, 0)) AS bug,\r\n    SUM(IFNULL(t5.`plan`, 0)) AS \'plan\',\r\n    SUM(IFNULL(t6.`release`, 0)) AS \'release\'\r\nFROM zt_product AS t1\r\nLEFT JOIN (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) as t2 ON 1 = 1\r\nLEFT JOIN (SELECT COUNT(1) as \'story\', product, YEAR(openedDate) as `year` FROM zt_story WHERE deleted = \'0\' GROUP BY product, `year`) AS t3 on t1.id = t3.product AND t3.`year` = t2.`year`\r\nLEFT JOIN (SELECT COUNT(1) as \'bug\', product, YEAR(openedDate) as `year` FROM zt_bug WHERE deleted = \'0\' GROUP BY product, `year`) AS t4 on t1.id = t4.product AND t4.`year` = t2.`year`\r\nLEFT JOIN (SELECT COUNT(1) as \'plan\', product, YEAR(createdDate) AS \'year\' FROM zt_productplan WHERE deleted = \'0\' GROUP BY product,`year`) AS t5 on t1.id = t5.product AND t5.`year` = t2.`year`\r\nLEFT JOIN (SELECT COUNT(1) as \'release\', product, YEAR(`date`) as `year` FROM zt_release WHERE deleted = \'0\' GROUP BY product, `year`) AS t6 ON t1.id = t6.product AND t6.`year` = t2.`year`\r\nWHERE t1.deleted = \'0\' AND t1.status != \'closed\' AND t1.shadow = \'0\'\r\nGROUP BY t1.name,t1.id,t2.`year`,newProduct' WHERE `name` = '年度新增-产品年度新增数据汇总表';
