CREATE TABLE IF NOT EXISTS `zt_dimension` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `code` varchar(45) NOT NULL,
  `desc` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `zt_dataview` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `group` mediumint(8) unsigned NOT NULL,
  `name` varchar(155) NOT NULL,
  `code` varchar(50) NOT NULL,
  `view` varchar(57) NOT NULL,
  `sql` text NOT NULL,
  `fields` mediumtext NOT NULL,
  `objects` mediumtext NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `zt_screen` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `dimension` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `desc` mediumtext NOT NULL,
  `cover` mediumtext NOT NULL,
  `scheme` mediumtext NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE `zt_chart` ADD `dimension` mediumint(8) unsigned NOT NULL DEFAULT 0 AFTER `name`;
ALTER TABLE `zt_chart` ADD `group` mediumint(8) unsigned NOT NULL DEFAULT 0 AFTER `type`;
ALTER TABLE `zt_chart` ADD `fields` mediumtext NOT NULL AFTER `filters`;
ALTER TABLE `zt_chart` ADD `sql` text NOT NULL AFTER `fields`;
ALTER TABLE `zt_chart` ADD `builtin` tinyint(1) unsigned NOT NULL AFTER `sql`;
ALTER TABLE `zt_chart` ADD `objects` mediumtext NOT NULL AFTER `builtin`;
ALTER TABLE `zt_chart` ADD `editedBy` varchar(30) NOT NULL AFTER `createdDate`;
ALTER TABLE `zt_chart` ADD `editedDate` datetime NOT NULL AFTER `editedBy`;
ALTER TABLE `zt_chart` MODIFY COLUMN `desc` text NOT NULL;

ALTER TABLE `zt_dashboard` ADD `dimension` int(8) NOT NULL default 0 AFTER `name`;
ALTER TABLE `zt_report`    ADD `dimension` int(8) NOT NULL default 0 AFTER `name`;

UPDATE `zt_chart`     SET `dimension` = 1 WHERE `dimension` = 0;
UPDATE `zt_report`    SET `dimension` = 1 WHERE `dimension` = 0;
UPDATE `zt_dashboard` SET `dimension` = 1 WHERE `dimension` = 0;

UPDATE `zt_grouppriv` SET `module` = 'dataview' WHERE `module` = 'dataset' AND `method` in ('create', 'browse', 'edit', 'delete');
DELETE FROM `zt_grouppriv` WHERE `module` = 'dataset' AND `method` = 'view';

REPLACE INTO `zt_chart` (`id`, `name`, `dimension`, `type`, `group`, `dataset`, `desc`, `settings`, `filters`, `fields`, `sql`, `builtin`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES
(1001,'年度总结-登录次数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"login\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','SELECT sum(t2.login) AS login, `year`, account, realname\r\nFROM zt_user t1 \r\nLEFT JOIN (SELECT count(1) as login, actor, YEAR(`date`) as \'year\' FROM zt_action GROUP BY actor, `year`) t2 on t1.account = t2.actor \r\nWHERE t1.deleted = \'0\'\r\nGROUP BY `year`, account, realname',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1002,'年度总结-操作次数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"allAction\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','SELECT sum(t2.allAction) as allAction, `year` , account, realname\r\nFROM zt_user t1\r\nLEFT JOIN (SELECT count(1) as allAction, actor, YEAR(`date`) as \'year\' FROM zt_action GROUP BY actor, `year`) t2 on t1.account = t2.actor \r\nWHERE t1.deleted = \'0\'\r\nGROUP BY `year`, account, realname',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1003,'年度总结-消耗工时',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"consumed\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','SELECT ROUND(SUM(t2.consumed)) AS consumed, `year` , t1.account, realname\r\nFROM zt_user t1\r\nLEFT JOIN (SELECT sum(consumed) as consumed, account, YEAR(`date`) as \'year\' FROM zt_effort WHERE deleted = \'0\' GROUP BY account, `year` ) t2 on t1.account = t2.account \r\nWHERE t1.deleted = \'0\'\r\nGROUP BY `year`, t1.account, realname',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1004,'年度总结-待办数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"todo\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','SELECT sum(t2.todo) AS todo,sum(t2.undone) AS undone,sum(t2.done) AS done,t2.`year`, t1.account, realname, dept\r\nFROM zt_user t1\r\nLEFT JOIN (SELECT count(1) AS \'todo\', sum(if((`status` != \'done\'), 1, 0)) AS `undone`, sum(if((`status` = \'done\'), 1, 0)) AS `done`, account, YEAR(`date`) AS \'year\' FROM zt_todo WHERE deleted = \'0\' GROUP BY account, `year`) t2 on t1.account = t2.account \r\nWHERE t1.deleted = \'0\'\r\nGROUP BY t2.`year`, t1.account, realname, dept',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1005,'年度总结-贡献数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"num\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','select tt.year,tt.actor as account, count(1) as num from (\r\nSELECT YEAR(t1.date) as `year`, t1.actor, t1.objectType, t1.action\r\nfrom zt_action t1\r\nWHERE \r\n(\r\n(t1.objectType = \'bug\' AND t1.action in(\'resolved\',\'opened\',\'closed\',\'activated\') and (select deleted from zt_bug where id = t1.objectID) = \'0\')\r\nOR (t1.objectType = \'task\' AND t1.action in(\'finished\',\'opened\',\'closed\',\'activated\',\'assigned\') and (select deleted from zt_task where id = t1.objectID) = \'0\')\r\nOR (t1.objectType = \'story\' AND t1.action in(\'opened\',\'reviewed\',\'closed\') and (select deleted from zt_story where id = t1.objectID) = \'0\')\r\nOR (t1.objectType = \'execution\' AND t1.action in(\'opened\',\'edited\',\'started\',\'closed\') and (select deleted from zt_project where id = t1.objectID) = \'0\')\r\nOR (t1.objectType = \'product\' AND t1.action in(\'opened\',\'edited\',\'closed\') and (select deleted from zt_product where id = t1.objectID) = \'0\')\r\nOR (t1.objectType = \'case\' AND t1.action in(\'opened\',\'run\') and (select deleted from zt_case where id = t1.objectID) = \'0\')\r\nOR (t1.objectType = \'testtask\' AND t1.action in(\'opened\',\'edited\') and (select deleted from zt_testtask where id = t1.objectID) = \'0\')\r\nOR (t1.objectType = \'productplan\' AND t1.action in(\'opened\') and (select deleted from zt_productplan where id = t1.objectID) = \'0\')\r\nOR (t1.objectType = \'release\' AND t1.action in(\'opened\') and (select deleted from zt_release where id = t1.objectID) = \'0\')\r\nOR (t1.objectType = \'doc\' AND t1.action in(\'created\',\'edited\') and (select deleted from zt_doc where id = t1.objectID) = \'0\')\r\nOR (t1.objectType = \'build\' AND t1.action in(\'opened\') and (select deleted from zt_build where id = t1.objectID) = \'0\')\r\n)\r\nunion all\r\nSELECT YEAR(t1.date) as `year`, t1.actor, \'code\' as objectType, t1.action from zt_action t1\r\nwhere t1.action in (\'gitcommited\', \'svncommited\') and t1.objectType = \'task\'\r\n) tt group by actor',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1006,'年度总结-贡献数据',1,'bar',0,'','','{\r\n\"xaxis\":[{\"field\":\"objectType\",\"name\":\"对象类型\"}],\r\n\"yaxis\":[{\"type\":\"agg\",\"field\":\"create\",\"agg\":\"sum\",\"name\":\"创建\",\"valOrAgg\":\"sum\"},{\"type\":\"value\",\"field\":\"edit\",\"agg\":\"sum\",\"name\":\"编辑\",\"valOrAgg\":\"sum\"}]\r\n}','[]','','SELECT t2.year, t1.dept, t2.account, t2.objectType, t2.create, t2.edit\r\nFROM zt_user AS t1\r\nLEFT JOIN\r\n(SELECT \r\n  YEAR(t1.date) AS `year`, t1.actor AS account, \'产品\' AS objectType, \r\n  SUM(IF(t1.action = \'opened\', 1, 0)) AS `create`, \r\n  SUM(IF(t1.action = \'edited\', 1, 0)) AS `edit`\r\nFROM zt_action AS t1 \r\nLEFT JOIN zt_product AS t2 ON t1.objectID = t2.id\r\nWHERE t1.objectType = \'product\' AND t1.action IN (\'opened\', \'edited\') AND t2.deleted = \'0\'\r\nGROUP BY `year`, actor, objectType\r\nUNION ALL\r\nSELECT \r\n  YEAR(t1.date) AS `year`, t1.actor, \'需求\' AS objectType, \r\n  SUM(IF(t1.action = \'opened\', 1, 0)) AS `create`,  \r\n  SUM(IF(t1.action = \'edited\', 1, 0)) AS `edit`\r\nFROM zt_action AS t1 \r\nLEFT JOIN zt_story AS t2 ON t1.objectID = t2.id\r\nWHERE t1.objectType = \'story\' AND t1.action IN (\'opened\', \'edited\') AND t2.deleted = \'0\'\r\nGROUP BY `year`, actor, objectType\r\nUNION ALL\r\nSELECT \r\n  YEAR(t1.date) AS `year`, t1.actor, \'计划\' AS objectType, \r\n  SUM(IF(t1.action = \'opened\', 1, 0)) AS `create`,  \r\n  SUM(IF(t1.action = \'edited\', 1, 0)) AS `edit`\r\nFROM zt_action AS t1 \r\nLEFT JOIN zt_productplan AS t2 ON t1.objectID = t2.id\r\nWHERE t1.objectType = \'productplan\' AND t1.action IN (\'opened\', \'edited\') AND t2.deleted = \'0\'\r\nGROUP BY `year`, actor, objectType\r\nUNION ALL\r\nSELECT \r\n  YEAR(t1.date) AS `year`, t1.actor, \'发布\' AS objectType, \r\n  SUM(IF(t1.action = \'opened\', 1, 0)) AS `create`,  \r\n  SUM(IF(t1.action = \'edited\', 1, 0)) AS `edit`\r\nFROM zt_action AS t1 \r\nLEFT JOIN zt_release AS t2 ON t1.objectID = t2.id\r\nWHERE t1.objectType = \'release\' AND t1.action IN (\'opened\', \'edited\') AND t2.deleted = \'0\'\r\nGROUP BY `year`, actor, objectType\r\nUNION ALL\r\nSELECT \r\n  YEAR(t1.date) AS `year`, t1.actor, \'执行\' AS objectType, \r\n  SUM(IF(t1.action = \'opened\', 1, 0)) AS `create`, \r\n  SUM(IF(t1.action = \'edited\', 1, 0)) AS `edit`\r\nFROM zt_action AS t1 \r\nLEFT JOIN zt_project AS t2 ON t1.objectID = t2.id\r\nWHERE t1.objectType = \'execution\' AND t1.action IN (\'opened\', \'edited\') AND t2.deleted = \'0\' AND t2.type IN (\'sprint\', \'stage\', \'kanban\')\r\nGROUP BY `year`, actor, objectType\r\nUNION ALL\r\nSELECT \r\n  YEAR(t1.date) AS `year`, t1.actor, \'任务\' AS objectType, \r\n  SUM(IF(t1.action = \'opened\', 1, 0)) AS `create`,  \r\n  SUM(IF(t1.action = \'edited\', 1, 0)) AS `edit`\r\nFROM zt_action AS t1 \r\nLEFT JOIN zt_task AS t2 ON t1.objectID = t2.id\r\nWHERE t1.objectType = \'task\' AND t1.action IN (\'opened\', \'edited\') AND t2.deleted = \'0\'\r\nGROUP BY `year`, actor, objectType\r\nUNION ALL\r\nSELECT \r\n  YEAR(t1.date) AS `year`, t1.actor, \'Bug\' AS objectType, \r\n  SUM(IF(t1.action = \'opened\', 1, 0)) AS `create`,  \r\n  SUM(IF(t1.action = \'edited\', 1, 0)) AS `edit`\r\nFROM zt_action AS t1 \r\nLEFT JOIN zt_bug AS t2 ON t1.objectID = t2.id\r\nWHERE t1.objectType = \'bug\' AND t1.action IN (\'opened\', \'edited\') AND t2.deleted = \'0\'\r\nGROUP BY `year`, actor, objectType\r\nUNION ALL\r\nSELECT \r\n  YEAR(t1.date) AS `year`, t1.actor, \'版本\' AS objectType, \r\n  SUM(IF(t1.action = \'opened\', 1, 0)) AS `create`, \r\n  SUM(IF(t1.action = \'edited\', 1, 0)) AS `edit` \r\nFROM zt_action AS t1 \r\nLEFT JOIN zt_build AS t2 ON t1.objectID = t2.id\r\nWHERE t1.objectType = \'build\' AND t1.action IN (\'opened\', \'edited\') AND t2.deleted = \'0\'\r\nGROUP BY `year`, actor, objectType\r\nUNION ALL\r\nSELECT \r\n  YEAR(t1.date) AS `year`, t1.actor, \'用例\' AS objectType, \r\n  SUM(IF(t1.action = \'opened\', 1, 0)) AS `create`,   \r\n  SUM(IF(t1.action = \'edited\', 1, 0)) AS `edit`\r\nFROM zt_action AS t1 \r\nLEFT JOIN zt_case AS t2 ON t1.objectID = t2.id\r\nWHERE t1.objectType = \'case\' AND t1.action IN (\'opened\', \'edited\') AND t2.deleted = \'0\'\r\nGROUP BY `year`, actor, objectType\r\nUNION ALL\r\nSELECT \r\n  YEAR(t1.date) AS `year`, t1.actor, \'测试单\' AS objectType, \r\n  SUM(IF(t1.action = \'opened\', 1, 0)) AS `create`, \r\n  SUM(IF(t1.action = \'edited\', 1, 0)) AS `edit`\r\nFROM zt_action AS t1 \r\nLEFT JOIN zt_testtask AS t2 ON t1.objectID = t2.id\r\nWHERE t1.objectType = \'testtask\' AND t1.action IN (\'opened\', \'edited\') AND t2.deleted = \'0\'\r\nGROUP BY `year`, actor, objectType\r\nUNION ALL\r\nSELECT \r\n  YEAR(t1.date) AS `year`, t1.actor, \'文档\' AS objectType, \r\n  SUM(IF(t1.action = \'opened\', 1, 0)) AS `create`, \r\n  SUM(IF(t1.action = \'edited\', 1, 0)) AS `edit`\r\nFROM zt_action AS t1 \r\nLEFT JOIN zt_doc AS t2 ON t1.objectID = t2.id\r\nWHERE t1.objectType = \'doc\' AND t1.action IN (\'opened\', \'edited\') AND t2.deleted = \'0\'\r\nGROUP BY `year`, actor, objectType) AS t2 ON t1.account = t2.account\r\nWHERE t2.account IS NOT NULL',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1007,'年度总结-能力雷达图',1,'radar',0,'','','{\r\n\"group\":[{\"field\":\"dimension\",\"name\":\"维度\"}],\r\n\"metric\":[\r\n  {\"type\":\"value\",\"field\":\"num\",\"agg\":\"value\",\"name\": \"产品管理\", \"key\":\"product\",\"valOrAgg\":\"value\"},\r\n  {\"type\":\"value\",\"field\":\"num\",\"agg\":\"value\",\"name\": \"项目管理\", \"key\":\"project\",\"valOrAgg\":\"value\"},\r\n  {\"type\":\"value\",\"field\":\"num\",\"agg\":\"value\",\"name\": \"研发\", \"key\":\"dev\",\"valOrAgg\":\"value\"},\r\n  {\"type\":\"value\",\"field\":\"num\",\"agg\":\"value\",\"name\": \"测试\", \"key\":\"qa\",\"valOrAgg\":\"value\"},\r\n  {\"type\":\"value\",\"field\":\"num\",\"agg\":\"value\",\"name\": \"其他\", \"key\":\"other\",\"valOrAgg\":\"value\"}\r\n]}','[]','','select tt.year, tt.actor AS account,tt.dimension, count(1) as num from (\r\nSELECT YEAR(t1.date) as `year`, t1.actor, \'product\' as dimension\r\nfrom zt_action t1\r\nWHERE \r\n(\r\n(t1.objectType = \'product\' AND t1.action in(\'opened\',\'edited\') and (select deleted from zt_product where id = t1.objectID) = \'0\')\r\nOR (t1.objectType = \'story\' AND t1.action in(\'opened\',\'reviewed\',\'closed\') and (select deleted from zt_story where id = t1.objectID) = \'0\')\r\nOR (t1.objectType = \'productplan\' AND t1.action in(\'opened\') and (select deleted from zt_productplan where id = t1.objectID) = \'0\')\r\nOR (t1.objectType = \'release\' AND t1.action in(\'opened\') and (select deleted from zt_release where id = t1.objectID) = \'0\')\r\n)\r\nunion all\r\nSELECT YEAR(t1.date) as `year`, t1.actor, \'execution\' as dimension\r\nfrom zt_action t1\r\nWHERE \r\n(\r\n(t1.objectType = \'execution\' AND t1.action in(\'opened\',\'edited\',\'started\',\'closed\') and (select deleted from zt_project where id = t1.objectID) = \'0\')\r\nOR (t1.objectType = \'build\' AND t1.action in(\'opened\') and (select deleted from zt_build where id = t1.objectID) = \'0\')\r\nOR (t1.objectType = \'task\' AND t1.action in(\'opened\',\'closed\',\'activated\',\'assigned\') and (select deleted from zt_task where id = t1.objectID) = \'0\')\r\n)\r\nunion all\r\nSELECT YEAR(t1.date) as `year`, t1.actor, \'devel\' as dimension\r\nfrom zt_action t1\r\nWHERE \r\n(\r\n(t1.objectType = \'execution\' AND t1.action in(\'opened\',\'edited\',\'started\',\'closed\') and (select deleted from zt_project where id = t1.objectID) = \'0\')\r\nOR (t1.objectType = \'build\' AND t1.action in(\'opened\') and (select deleted from zt_build where id = t1.objectID) = \'0\')\r\nOR (t1.objectType = \'task\' AND t1.action in(\'opened\',\'closed\',\'assigned\') and (select deleted from zt_task where id = t1.objectID) = \'0\')\r\nOR (t1.objectType = \'task\' and t1.action in (\'gitcommited\', \'svncommited\'))\r\nOR (t1.objectType = \'bug\' AND t1.action in(\'resolved\') and (select deleted from zt_bug where id = t1.objectID) = \'0\')\r\n)\r\nunion all\r\nSELECT YEAR(t1.date) as `year`, t1.actor, \'qa\' as dimension\r\nfrom zt_action t1\r\nWHERE \r\n(\r\n(t1.objectType = \'bug\' AND t1.action in(\'opened\',\'closed\',\'activated\') and (select deleted from zt_bug where id = t1.objectID) = \'0\')\r\nOR (t1.objectType = \'case\' AND t1.action in(\'opened\',\'run\') and (select deleted from zt_case where id = t1.objectID) = \'0\')\r\nOR (t1.objectType = \'testtask\' AND t1.action in(\'opened\',\'edited\') and (select deleted from zt_testtask where id = t1.objectID) = \'0\')\r\n)\r\n) tt WHERE tt.year != \'0000\'\r\nGROUP BY tt.year, tt.dimension',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1008,'年度总结-迭代数据',1,'table',0,'','','{\"group\":[],\"column\":[\r\n{\"field\":\"name\",\"valOrAgg\":\"value\",\"name\":\"迭代名称\"},{\"field\":\"finishedStory\",\"valOrAgg\":\"value\",\"name\":\"完成需求数\"},\r\n{\"field\":\"finishedTask\",\"valOrAgg\":\"value\",\"name\":\"完成任务数\"},\r\n{\"field\":\"resolvedBug\",\"valOrAgg\":\"value\",\"name\":\"解决Bug数\"}\r\n],\"filter\":[]}','[]','','SELECT \r\ntt.id, \r\ntt.name, \r\ntt.year, \r\ntt.account,\r\ntt.finishedStory,\r\ntt.finishedTask,\r\ncount(t3.id) as resolvedBug\r\nfrom (\r\nSELECT \r\ntt.id, \r\nt2.name, \r\ntt.year, \r\ntt.account,\r\nSUM(if((t1.story != 0), 1 , 0)) as finishedStory,\r\ncount(t1.id) as finishedTask\r\nfrom (\r\nSELECT \r\n*\r\nfrom (\r\nSELECT id, YEAR(begin) as year, openedBy as account from zt_project\r\nWHERE deleted = \'0\' AND type = \'sprint\' and multiple = \'1\' and YEAR(begin) != \'0000\'\r\nunion all\r\nSELECT id, YEAR(begin) as year, PO as account from zt_project\r\nWHERE deleted = \'0\' AND type = \'sprint\' and multiple = \'1\' and YEAR(begin) != \'0000\'\r\nunion all\r\nSELECT id, YEAR(begin) as year, PM as account from zt_project\r\nWHERE deleted = \'0\' AND type = \'sprint\' and multiple = \'1\' and YEAR(begin) != \'0000\'\r\nunion all\r\nSELECT id, YEAR(begin) as year, QD as account from zt_project\r\nWHERE deleted = \'0\' AND type = \'sprint\' and multiple = \'1\' and YEAR(begin) != \'0000\'\r\nunion all\r\nSELECT id, YEAR(begin) as year, RD as account from zt_project\r\nWHERE deleted = \'0\' AND type = \'sprint\' and multiple = \'1\' and YEAR(begin) != \'0000\'\r\nunion all\r\nSELECT id, YEAR(end) as year, openedBy as account from zt_project\r\nWHERE deleted = \'0\' AND type = \'sprint\' and multiple = \'1\' and YEAR(end) != \'0000\'\r\nunion all\r\nSELECT id, YEAR(end) as year, PO as account from zt_project\r\nWHERE deleted = \'0\' AND type = \'sprint\' and multiple = \'1\' and YEAR(end) != \'0000\'\r\nunion all\r\nSELECT id, YEAR(end) as year, PM as account from zt_project\r\nWHERE deleted = \'0\' AND type = \'sprint\' and multiple = \'1\' and YEAR(end) != \'0000\'\r\nunion all\r\nSELECT id, YEAR(end) as year, QD as account from zt_project\r\nWHERE deleted = \'0\' AND type = \'sprint\' and multiple = \'1\' and YEAR(end) != \'0000\'\r\nunion all\r\nSELECT id, YEAR(end) as year, RD as account from zt_project\r\nWHERE deleted = \'0\' AND type = \'sprint\' and multiple = \'1\' and YEAR(end) != \'0000\'\r\nunion all\r\nSELECT t1.root as id, YEAR(t1.`join`) as year, t1.account from zt_team t1\r\nRIGHT JOIN zt_project t2 on t2.id = t1.root and t2.deleted = \'0\' and t2.type = \'sprint\'\r\nWHERE t1.type = \'execution\' and YEAR(t1.`join`) != \'0000\'\r\nunion all\r\nSELECT t1.execution as id, YEAR(t1.finishedDate) as year, t1.finishedBy as account from zt_task t1\r\nRIGHT JOIN zt_project t2 on t2.id = t1.execution and t2.deleted = \'0\' and t2.type = \'sprint\'\r\nWHERE t1.deleted = \'0\' and YEAR(t1.finishedDate) != \'0000\'\r\n) tt \r\nwhere tt.account != \'\'\r\nGROUP BY tt.id, tt.`year`, tt.account\r\n) tt\r\nLEFT JOIN zt_task t1 on t1.execution = tt.id and YEAR(t1.finishedDate) = tt.year and t1.deleted = \'0\' and t1.finishedBy = tt.account\r\nLEFT JOIN zt_project t2 on t2.id = tt.id\r\nGROUP BY tt.id, tt.`year`, tt.account\r\n) tt\r\nLEFT JOIN zt_bug t2 on t2.resolvedBy = tt.account and YEAR(t2.resolvedDate) = tt.year\r\nleft join zt_build t3 on t2.resolvedBuild = t3.id and t3.execution = tt.id\r\nWHERE t2.deleted = \'0\'\r\nGROUP BY tt.account, tt.`year`, tt.id',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1009,'年度总结-产品数据',1,'table',0,'','','{\"group\":[],\"column\":[\r\n{\"field\":\"name\",\"valOrAgg\":\"value\",\"name\":\"产品名称\"},{\"field\":\"plan\",\"valOrAgg\":\"value\",\"name\":\"计划数\"},\r\n{\"field\":\"requirement\",\"valOrAgg\":\"value\",\"name\":\"创建用户需求数\"},\r\n{\"field\":\"story\",\"valOrAgg\":\"value\",\"name\":\"创建需求数\"},\r\n{\"field\":\"closedStory\",\"valOrAgg\":\"value\",\"name\":\"关闭需求数\"}\r\n],\"filter\":[]}','[]','','select * from (\r\nselect tt.id, t2.name, tt.year, tt.account, tt.plans, tt.requirement, tt.story, count(t1.id) as closedStory\r\nfrom(\r\n  select tt.id, tt.year, tt.account, tt.plans,\r\nsum(if((type = \'requirement\'), 1, 0)) as requirement,\r\nsum(if((type = \'story\'), 1, 0)) as story\r\nfrom (\r\nselect tt.id, tt.year, tt.account,\r\ncount(t2.id) as plans\r\nfrom (\r\nselect * from (\r\nselect id, YEAR(createdDate) as `year`, createdBy as account from zt_product\r\nwhere deleted = \'0\' and shadow = \'0\'\r\nunion all\r\nselect id, YEAR(createdDate) as `year`, PO as account from zt_product\r\nwhere deleted = \'0\' and shadow = \'0\'\r\nunion all\r\nselect id, YEAR(createdDate) as `year`, QD as account from zt_product\r\nwhere deleted = \'0\' and shadow = \'0\'\r\nunion all\r\nselect id, YEAR(createdDate) as `year`, RD as account from zt_product\r\nwhere deleted = \'0\' and shadow = \'0\'\r\n) tt\r\nWHERE tt.account != \'\' and tt.year != \'0000\'\r\nGROUP BY tt.account, tt.year, tt.id\r\n) tt\r\nLEFT JOIN zt_productplan t1 on t1.product = tt.id\r\nLEFT JOIN zt_action t2 on t1.id = t2.objectID and YEAR(t2.date) = tt.year\r\nand t2.objectType = \'productplan\'\r\nand t1.deleted = \'0\'\r\nand t2.actor = tt.account\r\nand t2.action = \'opened\'\r\nGROUP BY tt.account, tt.year, tt.id) tt\r\nLEFT JOIN zt_story t1 on t1.product = tt.id and YEAR(t1.openedDate) = tt.year and t1.openedBy = tt.account and t1.deleted = \'0\'\r\nGROUP BY tt.account, tt.year, tt.id) tt\r\nLEFT JOIN zt_story t1 on t1.product = tt.id and YEAR(t1.closedDate) = tt.year and t1.closedBy = tt.account and t1.deleted = \'0\'\r\nLEFT JOIN zt_product t2 on t2.id = tt.id\r\nGROUP BY tt.account, tt.year, tt.id) tt\r\nWHERE tt.account = \'zhangpeng\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1010,'年度总结-任务状态分布',1,'pie',0,'','','{\"group\":[{\"field\":\"status\",\"name\":\"状态\"}],\"metric\":[{\"type\":\"agg\",\"field\":\"id\",\"agg\":\"count\",\"name\":\"任务数\",\"valOrAgg\":\"count\"}]}','[]','','SELECT\r\nYEAR(t1.date) AS `year`,\r\nt3.account,\r\nt3.realname,\r\nCASE t2.status\r\nWHEN \'wait\' THEN \'未开始\'\r\nWHEN \'doing\' THEN \'进行中\'\r\nWHEN \'done\' THEN \'已完成\'\r\nWHEN \'closed\' THEN \'已关闭\'\r\nELSE \'未设置\' END status,\r\nt1.id\r\nFROM zt_action t1\r\nLEFT JOIN zt_task t2 on t1.objectID=t2.id RIGHT JOIN zt_user t3 on t1.actor=t3.account\r\nWHERE t1.objectType = \'task\'\r\nand t2.deleted = \'0\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1011,'年度总结-每月任务操作情况',1,'bar',0,'','','{\n  \"xaxis\":[{\"field\":\"actionDate\",\"name\":\"日期\",\"group\":\"value\"}],\n  \"yaxis\":[{\"type\":\"agg\",\"field\":\"opened\",\"agg\":\"sum\",\"name\":\"创建\",\"valOrAgg\":\"sum\"},\n{\"type\":\"agg\",\"field\":\"started\",\"agg\":\"sum\",\"name\":\"开始\",\"valOrAgg\":\"sum\"},\n{\"type\":\"agg\",\"field\":\"finished\",\"agg\":\"sum\",\"name\":\"完成\",\"valOrAgg\":\"sum\"},\n{\"type\":\"agg\",\"field\":\"paused\",\"agg\":\"sum\",\"name\":\"暂停\",\"valOrAgg\":\"sum\"},\n{\"type\":\"agg\",\"field\":\"activated\",\"agg\":\"sum\",\"name\":\"激活\",\"valOrAgg\":\"sum\"},\n{\"type\":\"agg\",\"field\":\"canceled\",\"agg\":\"sum\",\"name\":\"取消\",\"valOrAgg\":\"sum\"},\n{\"type\":\"agg\",\"field\":\"closed\",\"agg\":\"sum\",\"name\":\"关闭\",\"valOrAgg\":\"sum\"}\n]}','[]','','SELECT t2.opened,t2.started,t2.finished,t2.paused,t2.activated,t2.canceled,t2.closed,t1.account,t2.actionDate,YEAR(CONCAT(t2.actionDate, \'-01\')) AS `year`,realname,t3.`name` AS deptName FROM zt_user AS t1\nLEFT JOIN (\n    SELECT t21.actor,LEFT(t21.`date`,7) AS actionDate,\n    SUM(if(t21.action = \'opened\', 1, 0)) as opened,\n    SUM(if(t21.action = \'started\', 1, 0)) as started,\n    SUM(if(t21.action = \'finished\', 1, 0)) as finished,\n    SUM(if(t21.action = \'paused\', 1, 0)) as paused,\n    SUM(if(t21.action = \'activated\', 1, 0)) as activated,\n    SUM(if(t21.action = \'canceled\', 1, 0)) as canceled,\n    SUM(if(t21.action = \'closed\', 1, 0)) as closed FROM zt_action AS t21\n    LEFT JOIN zt_story AS t22 ON t21.objectID=t22.id\n    WHERE t21.objectType=\'bug\'\n    AND t22.deleted=\'0\'\n    GROUP BY t21.actor,actionDate\n) AS t2 ON t1.account=t2.actor\nLEFT JOIN zt_dept AS t3 ON t1.dept=t3.id\nWHERE t1.deleted=\'0\'\nAND t2.actor IS NOT NULL\nGROUP BY t2.actionDate,deptName,t1.account,realname\n',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1012,'年度总结-需求状态分布',1,'pie',0,'','','{\"group\":[{\"field\":\"status\",\"name\":\"状态\"}],\"metric\":[{\"type\":\"agg\",\"field\":\"id\",\"agg\":\"count\",\"name\":\"需求数\",\"valOrAgg\":\"count\"}]}','[]','','SELECT\r\nYEAR(t1.date) AS `year`,\r\nt3.account,\r\nt3.realname,\r\nCASE t2.status\r\nWHEN \'wait\' THEN \'未开始\'\r\nWHEN \'doing\' THEN \'进行中\'\r\nWHEN \'done\' THEN \'已完成\'\r\nWHEN \'colsed\' THEN \'已关闭\'\r\nELSE \'未设置\'\r\nEND status,\r\nt1.id\r\nFROM zt_action t1\r\nLEFT JOIN zt_task t2 on t1.objectID=t2.id RIGHT JOIN zt_user t3 on t1.actor=t3.account\r\nWHERE t1.objectType = \'story\'\r\nand t2.deleted = \'0\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1013,'年度总结-每月需求操作情况',1,'bar',0,'','','{\n  \"xaxis\":[{\"field\":\"actionDate\",\"name\":\"日期\",\"group\":\"value\"}],\n  \"yaxis\":[{\"type\":\"value\",\"field\":\"opened\",\"agg\":\"value\",\"name\":\"创建\",\"valOrAgg\":\"value\"},\n{\"type\":\"value\",\"field\":\"activated\",\"agg\":\"value\",\"name\":\"激活\",\"valOrAgg\":\"value\"},\n{\"type\":\"value\",\"field\":\"changed\",\"agg\":\"value\",\"name\":\"变更\",\"valOrAgg\":\"value\"},\n{\"type\":\"value\",\"field\":\"closed\",\"agg\":\"value\",\"name\":\"关闭\",\"valOrAgg\":\"value\"}\n]}','[]','','SELECT t2.opened,t2.activated,t2.closed,t2.`changed`,t1.account,t2.actionDate,YEAR(CONCAT(t2.actionDate,\'-01\')) AS `year`,realname,t3.`name` AS deptName FROM zt_user AS t1\nLEFT JOIN (\n    SELECT t21.actor,LEFT(t21.`date`, 7) AS actionDate,\n    SUM(IF(t21.action=\'opened\',1,0)) AS opened,\n    SUM(IF(t21.action=\'activated\',1,0)) AS activated,\n    SUM(IF(t21.action=\'closed\',1,0)) AS closed,\n    SUM(IF(t21.action=\'changed\',1,0)) AS `changed` FROM zt_action AS t21\n    LEFT JOIN zt_story AS t22 ON t21.objectID=t22.id\n    WHERE t21.objectType=\'story\'\n    AND t22.deleted=\'0\'\n    GROUP BY t21.actor,actionDate\n) AS t2 ON t1.account=t2.actor\nLEFT JOIN zt_dept AS t3 ON t1.dept=t3.id\nWHERE t1.deleted=\'0\'\nAND t2.actor IS NOT NULL\nGROUP BY t2.actionDate,deptName,t1.account,realname\n',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1014,'年度总结-Bug状态分布',1,'pie',0,'','','{\"group\":[{\"field\":\"status\",\"name\":\"状态\"}],\"metric\":[{\"type\":\"agg\",\"field\":\"id\",\"agg\":\"count\",\"name\":\"Bug数\",\"valOrAgg\":\"count\"}]}','[]','','SELECT\r\nYEAR(t1.date) AS `year`, t3.account,\r\nt3.realname,\r\nCASE t2.status\r\nWHEN \'wait\' THEN \'未开始\'\r\nWHEN \'doing\' THEN \'进行中\'\r\nWHEN \'done\' THEN \'已完成\'\r\nWHEN \'closed\' THEN \'已关闭\'\r\nELSE \'未设置\'\r\nEND status,\r\nt1.id\r\nFROM zt_action t1\r\nLEFT JOIN zt_task t2 on t1.objectID=t2.id RIGHT JOIN zt_user t3 on t1.actor=t3.account\r\nWHERE t1.objectType = \'bug\'\r\nand t2.deleted = \'0\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1015,'年度总结-每月Bug操作情况',1,'bar',0,'','','{\n  \"xaxis\":[{\"field\":\"actionDate\",\"name\":\"日期\",\"group\":\"value\"}],\n  \"yaxis\":[{\"type\":\"value\",\"field\":\"opened\",\"agg\":\"value\",\"name\":\"创建\",\"valOrAgg\":\"value\"},\n{\"type\":\"value\",\"field\":\"bugconfirmed\",\"agg\":\"value\",\"name\":\"确认\",\"valOrAgg\":\"value\"},\n{\"type\":\"value\",\"field\":\"activated\",\"agg\":\"value\",\"name\":\"激活\",\"valOrAgg\":\"value\"},\n{\"type\":\"value\",\"field\":\"resolved\",\"agg\":\"value\",\"name\":\"解决\",\"valOrAgg\":\"value\"},\n{\"type\":\"value\",\"field\":\"closed\",\"agg\":\"value\",\"name\":\"关闭\",\"valOrAgg\":\"value\"}\n]}','[]','','SELECT t2.opened,t2.bugconfirmed,t2.activated,t2.resolved,t2.closed,t1.account,t2.actionDate,YEAR(CONCAT(t2.actionDate, \'-01\')) AS \n`year`,realname,t3.`name` AS deptName FROM zt_user AS t1\nLEFT JOIN (\n    SELECT t21.actor,LEFT(t21.`date`, 7) AS actionDate,\n    SUM(IF(t21.action=\'opened\',1,0)) AS opened,\n    SUM(IF(t21.action=\'bugconfirmed\',1,0)) AS bugconfirmed,\n    SUM(IF(t21.action=\'activated\',1,0)) AS activated,\n    SUM(IF(t21.action=\'resolved\',1,0)) AS resolved,\n    SUM(IF(t21.action=\'closed\',1,0)) AS closed FROM zt_action AS t21\n    LEFT JOIN zt_story AS t22 ON t21.objectID=t22.id\n    WHERE t21.objectType=\'bug\'\n    AND t22.deleted=\'0\'\n    GROUP BY t21.actor,actionDate\n) AS t2 ON t1.account=t2.actor\nLEFT JOIN zt_dept AS t3 ON t1.dept=t3.id\nWHERE t1.deleted=\'0\'\nAND t2.actor IS NOT NULL\nGROUP BY t2.actionDate,deptName,t1.account,realname',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1016,'年度总结-用例结果分布',1,'pie',0,'','','{\"group\":[{\"field\":\"status\",\"name\":\"状态\"}],\"metric\":[{\"type\":\"agg\",\"field\":\"id\",\"agg\":\"count\",\"name\":\"个数\",\"valOrAgg\":\"count\"}]}','[]','','SELECT count ,t2.caseResult as status,t2.`year`, t1.account, realname, dept\r\nFROM zt_user t1\r\nLEFT JOIN (\r\n    SELECT t21.lastRunner, YEAR(t21.`date`) as \'year\', t21.caseResult, count(distinct t21.`id`) as count\r\n    FROM zt_testresult t21 \r\n    LEFT JOIN zt_case t22 on t21.case = t22.id\r\n    WHERE t22.deleted = \'0\'\r\n    GROUP BY t21.lastRunner, `year`, t21.caseResult\r\n) t2 on t1.account = t2.lastRunner\r\nWHERE t1.deleted = \'0\'\r\nGROUP BY t2.caseResult,t2.`year`, t1.account, realname, dept',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1017,'年度总结-每月用例操作情况',1,'bar',0,'','','{\r\n  \"xaxis\":[{\"field\":\"actionDate\",\"name\":\"日期\",\"group\":\"value\"}],\r\n  \"yaxis\":[{\"type\":\"value\",\"field\":\"createdCases\",\"agg\":\"value\",\"name\":\"创建\",\"valOrAgg\":\"value\"},\r\n{\"type\":\"value\",\"field\":\"toBugCases\",\"agg\":\"value\",\"name\":\"转Bug\",\"valOrAgg\":\"value\"},\r\n{\"type\":\"value\",\"field\":\"runCases\",\"agg\":\"value\",\"name\":\"执行\",\"valOrAgg\":\"value\"}\r\n]}','[]','','SELECT SUM(createdCases) AS createdCases, SUM(toBugCases) AS toBugCases, SUM(runCases) AS runCases, YEAR(CONCAT(t2.actionDate, \'-01\')) AS `year`, t1.account, realname, dept\r\nFROM zt_user t1\r\nLEFT JOIN (\r\n    SELECT t21.actor, LEFT(t21.`date`, 7) as actionDate, \r\n    SUM(IF((t22.id IS NOT NULL AND t23.id IS NULL), 1, 0)) AS createdCases, \r\n    SUM(IF((t22.id IS NOT NULL AND t23.id IS NOT NULL), 1, 0)) AS toBugCases, \r\n    SUM(IF((t24.lastRunner = t21.actor AND t21.action = \'run\' AND t21.`date` = t24.`date`), 1, 0)) AS runCases\r\n    FROM zt_action t21 \r\n    LEFT JOIN zt_case t22 on t21.objectID = t22.id\r\n    LEFT JOIN zt_bug t23 on t22.id = t23.case\r\n    LEFT JOIN zt_testresult t24 on t22.id = t24.`case` AND t24.lastRunner = t21.actor AND t21.action = \'run\' AND t21.`date` = t24.`date`\r\n    WHERE t21.objectType = \'case\'\r\n    AND t21.action in (\'opened\', \'run\')\r\n    AND t22.deleted = \'0\'\r\n    AND (t23.deleted = \'0\' OR t23.id IS NULL)\r\n    GROUP BY t21.actor, actionDate\r\n) t2 on t1.account = t2.actor\r\nWHERE t1.deleted = \'0\'\r\nAND t2.actor is not null\r\nGROUP BY t2.actionDate, t1.account, realname, dept',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1018,'宏观数据-一级项目集个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','{}','SELECT id,name FROM zt_project WHERE type=\'program\' AND parent=0 AND deleted=\'0\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1019,'宏观数据-项目个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','SELECT id FROM zt_project WHERE type=\'project\' AND deleted=\'0\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1020,'宏观数据-产品个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','SELECT id FROM zt_product WHERE deleted=\'0\' AND shadow = \'0\' AND vision = \'rnd\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1021,'宏观数据-计划个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','SELECT id FROM zt_productplan WHERE deleted=\'0\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1022,'宏观数据-执行个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','SELECT id FROM zt_project WHERE type IN (\'sprint\',\'stage\',\'kanban\') AND deleted=\'0\' AND multiple = \'1\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1023,'宏观数据-发布个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\n\"type\": \"value\"\n}','[]','','SELECT id FROM zt_release WHERE deleted=\'0\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1024,'宏观数据-需求个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','SELECT id FROM zt_story WHERE deleted=\'0\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1025,'宏观数据-任务个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','SELECT id FROM zt_task WHERE deleted=\'0\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1026,'宏观数据-缺陷个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','SELECT id FROM zt_bug WHERE deleted=\'0\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1027,'宏观数据-文档个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','SELECT id FROM zt_doc WHERE deleted=\'0\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1028,'宏观数据-现有人员个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','SELECT id FROM zt_user WHERE deleted=\'0\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1029,'宏观数据-累计消耗工时',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"consumed\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','SELECT consumed FROM zt_effort WHERE deleted=\'0\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1030,'宏观数据-禅道使用时长',1,'card',0,'','','{\"value\": {\"type\": \"value\", \"field\": \"period\", \"agg\": \"value\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\n\"type\": \"value\"\n}','[]','','SELECT if(t2.`year` > 0, concat(t2.`year`, \'年\', t2.`day`, \'天\'), concat(t2.`day`, \'天\')) as period from (\nSELECT TIMESTAMPDIFF(YEAR,t1.firstDay,t1.today) AS `year`,DATEDIFF(DATE_SUB(t1.today,INTERVAL TIMESTAMPDIFF(YEAR,t1.firstDay,t1.today) YEAR), t1.firstDay) AS `day`  \nFROM (SELECT MIN(date) AS firstDay, now() AS today FROM zt_action WHERE date > \'1970-01-01\') AS t1\n) t2',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1031,'宏观数据-需求完成率',1,'piecircle',0,'','','{\"group\":[{\"field\":\"status\",\"name\":\"状态\"}],\"metric\":[{\"type\":\"agg\",\"field\":\"id\",\"agg\":\"count\",\"name\":\"需求数\",\"valOrAgg\":\"count\"}]}','[]','','SELECT id, IF(closedReason=\'done\', \'done\', \'undone\') AS status FROM zt_story WHERE deleted=\'0\' AND (status != \'closed\' OR closedReason=\'done\')',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1032,'宏观数据-Bug修复率',1,'piecircle',0,'','','{\"group\":[{\"field\":\"status\",\"name\":\"状态\"}],\"metric\":[{\"type\":\"agg\",\"field\":\"id\",\"agg\":\"count\",\"name\":\"Bug数\",\"valOrAgg\":\"count\"}]}','[]','','SELECT id, IF(`status`=\'closed\' AND resolution=\'fixed\', \'done\', \'undone\') AS status FROM zt_bug WHERE deleted=\'0\' AND (status = \'active\' OR resolution in (\'fixed\', \'postponed\'))',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1033,'宏观数据-未完成的一级项目集个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','SELECT id FROM zt_project WHERE type=\'program\' AND `status`!=\'closed\' AND deleted=\'0\' AND grade=\'1\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1034,'宏观数据-未完成的需求',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','SELECT id FROM zt_story WHERE `status`!=\'closed\' AND deleted=\'0\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1035,'宏观数据-未完成的产品',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\n\"type\": \"value\"\n}','[]','','SELECT id FROM zt_product WHERE `status`!=\'closed\' AND deleted=\'0\' AND shadow=\'0\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1036,'宏观数据-未完成的项目',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','SELECT id FROM zt_project WHERE type=\'project\' AND `status`!=\'closed\' AND deleted=\'0\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1037,'宏观数据-未完成的计划',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','SELECT id FROM (SELECT id,deleted FROM zt_productplan WHERE NOT ((`status`=\'closed\' AND closedReason=\'done\') OR `status`=\'done\')) AS plan WHERE plan.deleted=\'0\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1038,'宏观数据-未完成的执行',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','SELECT id FROM zt_project WHERE type IN (\'sprint\',\'stage\',\'kanban\') AND `status`!=\'closed\' AND deleted=\'0\' AND multiple = \'1\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1039,'宏观数据-未完成的缺陷',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','SELECT id FROM zt_bug WHERE `status`!=\'closed\' AND deleted=\'0\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1040,'宏观数据-未完成的任务',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','SELECT id FROM (SELECT id,deleted FROM zt_task WHERE NOT ((`status`=\'closed\' AND closedReason=\'cancel\') OR `status`=\'done\')) AS task WHERE task.deleted=\'0\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1041,'宏观数据-项目集数据概览',1,'table',0,'','','{\"group\":[],\"column\":[\n{\"field\":\"topProgram\",\"valOrAgg\":\"value\",\"name\":\"一级项目集\"},{\"field\":\"subProgram\",\"valOrAgg\":\"value\",\"name\":\"子项目集数\"},\n{\"field\":\"product\",\"valOrAgg\":\"value\",\"name\":\"产品数\"},\n{\"field\":\"story\",\"valOrAgg\":\"value\",\"name\":\"研发需求数\"},\n{\"field\":\"bug\",\"valOrAgg\":\"value\",\"name\":\"Bug数\"},\n{\"field\":\"release\",\"valOrAgg\":\"value\",\"name\":\"发布数\"},\n{\"field\":\"project\",\"valOrAgg\":\"value\",\"name\":\"项目数\"},\n{\"field\":\"task\",\"valOrAgg\":\"value\",\"name\":\"任务数\"}\n],\"filter\":[]}','[]','','SELECT\n  t1.name AS topProgram,\n  IFNULL(t2.subProgram, 0) AS subProgram,\n  COUNT(DISTINCT t3.id) AS product,\n  SUM(IFNULL(t4.story, 0)) AS story,\n  SUM(IFNULL(t5.`release`, 0)) AS \'release\',\n  SUM(IFNULL(t6.bug, 0)) AS bug,\n  IFNULL(t7.project, 0) AS project,\n  IFNULL(t7.task, 0) AS task\nFROM zt_project AS t1\nLEFT JOIN (SELECT SUBSTR(path, 2, POSITION(\',\' IN SUBSTR(path, 2)) -1) AS topProgram, COUNT(1) AS subProgram FROM zt_project WHERE deleted = \'0\' AND type = \'program\' AND grade > 1 GROUP BY topProgram) AS t2 ON t1.id = t2.topProgram\nLEFT JOIN zt_product AS t3 ON t1.id = t3.program AND t3.deleted = \'0\' AND t3.shadow = \'0\' AND t3.vision = \'rnd\'\nLEFT JOIN (SELECT product, COUNT(1) AS story FROM zt_story WHERE deleted = \'0\' GROUP BY product) AS t4 ON t3.id = t4.product\nLEFT JOIN (SELECT product, COUNT(1) AS \'release\' FROM zt_release WHERE deleted = \'0\' GROUP BY product) AS t5 ON t3.id = t5.product\nLEFT JOIN (SELECT product, COUNT(1) AS bug FROM zt_bug WHERE deleted = \'0\' GROUP BY product) AS t6 ON t3.id = t6.product\nLEFT JOIN (\n  SELECT t1.topProgram, COUNT(DISTINCT t1.project) AS project, COUNT(t2.id) AS task\n  FROM (SELECT SUBSTR(path, 2, POSITION(\',\' IN SUBSTR(path, 2)) -1) AS topProgram, id AS project FROM zt_project WHERE deleted = \'0\' AND type = \'project\') AS t1\n  LEFT JOIN zt_task AS t2 ON t1.project = t2.project AND t2.deleted = \'0\'\n  GROUP BY t1.topProgram\n) AS t7 ON t1.id = t7.topProgram\nWHERE t1.deleted = \'0\' AND t1.type = \'program\' AND t1.grade = 1\nGROUP BY t1.name',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1042,'宏观数据-项目集需求完成率与Bug修复率',1,'bar',0,'','','{\r\n\"xaxis\":[{\"field\":\"topProgram\",\"name\":\"项目集\"}],\r\n\"yaxis\":[\r\n    {\"type\":\"value\",\"field\":\"storyDoneRate\",\"agg\":\"value\",\"name\":\"需求完成率\",\"valOrAgg\":\"value\"},\r\n    {\"type\":\"value\",\"field\":\"bugSolvedRate\",\"agg\":\"value\",\"name\":\"Bug修复率\",\"valOrAgg\":\"value\"}\r\n]}','[]','','SELECT\r\n    t1.name AS topProgram,\r\n    SUM(IFNULL(t3.doneStory,0)) as doneStory,\r\n    SUM(IFNULL(t4.allStory,0)) as allStory,\r\n    CONVERT(IF(SUM(IFNULL(t4.allStory,0)) <= 0, 0, SUM(IFNULL(t3.doneStory,0)) / SUM(IFNULL(t4.allStory,0))*100), decimal(10,2)) as storyDoneRate,                                                                                                                                         \r\n    SUM(IFNULL(t5.solvedBug,0)) as solvedBug,\r\n    SUM(IFNULL(t6.allBug,0)) as allBug,\r\n    CONVERT(IF(SUM(IFNULL(t6.allBug,0)) <= 0, 0, SUM(IFNULL(t5.solvedBug,0)) / SUM(IFNULL(t6.allBug,0))*100), decimal(10,2)) as bugSolvedRate\r\nFROM zt_project AS t1\r\nLEFT JOIN zt_product AS t2 ON t1.id = t2.program\r\nLEFT JOIN (SELECT COUNT(1) as doneStory, product FROM zt_story WHERE deleted = \'0\' AND closedReason = \'done\' AND status = \'closed\' GROUP BY product) AS t3 ON t2.id = t3.product\r\nLEFT JOIN (SELECT COUNT(1) as allStory, product FROM zt_story WHERE deleted = \'0\' AND ((closedReason = \'done\' AND status = \'closed\') OR status != \'closed\') GROUP BY product) AS t4 ON t2.id = t4.product\r\nLEFT JOIN (SELECT COUNT(1) as solvedBug, product FROM zt_bug WHERE deleted = \'0\' AND resolution = \'fixed\' AND status = \'closed\' GROUP BY product) AS t5 ON t2.id = t5.product\r\nLEFT JOIN (SELECT COUNT(1) as allBug, product FROM zt_bug WHERE deleted = \'0\' AND (resolution in (\'fixed\', \'postponed\') OR status = \'active\') GROUP BY product) AS t6 ON t2.id = t6.product\r\nWHERE t1.type = \'program\' AND t1.grade = 1 AND t1.deleted = \'0\'\r\nAND t2.deleted = \'0\'\r\nGROUP BY t1.name\r\nORDER BY t1.`order` DESC',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1043,'宏观数据-公司项目集状态分布',1,'pie',0,'','','{\"group\":[{\"field\":\"status\",\"name\":\"状态\"}],\"metric\":[{\"type\":\"agg\",\"field\":\"id\",\"agg\":\"count\",\"name\":\"项目集数\",\"valOrAgg\":\"count\"}]}','[]','','SELECT id, CASE `status` WHEN \'wait\' then \'未开始\' WHEN \'doing\' THEN \'进行中\' WHEN \'suspended\' THEN \'已挂起\' ELSE \'已关闭\' END status FROM zt_project  WHERE type = \'program\' AND grade = 1 AND deleted = \'0\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1044,'宏观数据-公司项目状态分布',1,'pie',0,'','','{\"group\":[{\"field\":\"status\",\"name\":\"状态\"}],\"metric\":[{\"type\":\"agg\",\"field\":\"id\",\"agg\":\"count\",\"name\":\"项目数\",\"valOrAgg\":\"count\"}]}','[]','','SELECT id, CASE `status` WHEN \'wait\' then \'未开始\' WHEN \'doing\' THEN \'进行中\' WHEN \'suspended\' THEN \'已挂起\' ELSE \'已关闭\' END status FROM zt_project  WHERE type = \'project\' AND deleted = \'0\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1045,'宏观数据-产品数据概览',1,'table',0,'','','{\"group\":[],\"column\":[\r\n{\"field\":\"program\",\"valOrAgg\":\"value\",\"name\":\"一级项目集\"},{\"field\":\"productLine\",\"valOrAgg\":\"value\",\"name\":\"产品线\"},\r\n{\"field\":\"product\",\"valOrAgg\":\"value\",\"name\":\"产品\"},\r\n{\"field\":\"story\",\"valOrAgg\":\"value\",\"name\":\"需求数\"},\r\n{\"field\":\"bug\",\"valOrAgg\":\"value\",\"name\":\"Bug数\"},\r\n{\"field\":\"plan\",\"valOrAgg\":\"value\",\"name\":\"计划数\"},\r\n{\"field\":\"release\",\"valOrAgg\":\"value\",\"name\":\"发布数\"}],\"filter\":[]}','[]','','SELECT \r\n  t1.name AS product, \r\n  IFNULL(t2.name, \'/\') AS program, \r\n  IFNULL(t3.name, \'/\') AS productLine, \r\n  IFNULL(t4.plan, 0) AS plan, \r\n  IFNULL(t5.release, 0) AS `release`, \r\n  IFNULL(t6.story, 0) AS story, \r\n  IFNULL(t7.bug, 0) AS bug \r\nFROM \r\n  zt_product AS t1 \r\n  LEFT JOIN zt_project AS t2 ON t1.program = t2.id AND t2.type = \'program\' AND t2.grade = 1 \r\n  LEFT JOIN zt_module AS t3 ON t1.line = t3.id AND t3.type = \'line\' \r\n  LEFT JOIN (SELECT product, COUNT(1) AS plan FROM zt_productplan WHERE deleted = \'0\' GROUP BY product) AS t4 ON t1.id = t4.product \r\n  LEFT JOIN (SELECT product, COUNT(1) AS `release` FROM zt_release WHERE deleted = \'0\' GROUP BY product) AS t5 ON t1.id = t5.product \r\n  LEFT JOIN (SELECT product, COUNT(1) AS story FROM zt_story WHERE deleted = \'0\' GROUP BY product) AS t6 ON t1.id = t6.product \r\n  LEFT JOIN (SELECT product, COUNT(1) AS bug FROM zt_bug WHERE deleted = \'0\' GROUP BY product) AS t7 ON t1.id = t7.product \r\nWHERE t1.deleted = \'0\' AND t1.status != \'closed\' AND t1.shadow = \'0\'AND t1.vision = \'rnd\'\r\nORDER BY t1.order',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1046,'宏观数据-产品需求完成率',1,'bar',0,'','','{\r\n\"xaxis\":[{\"field\":\"product\",\"name\":\"产品\"}],\r\n\"yaxis\":[\r\n    {\"type\":\"value\",\"field\":\"closedRate\",\"agg\":\"value\",\"name\":\"需求完成率\",\"valOrAgg\":\"value\"}\r\n]}','[]','','SELECT\r\n  t1.name AS product,\r\n  IFNULL(t2.name, \'/\') AS program, \r\n  IFNULL(t3.name, \'/\') AS productLine,   \r\n  IFNULL(t4.story, 0) AS closedStory, \r\n  t5.story AS totalStory, \r\n  ROUND(IFNULL(t4.story, 0) / t5.story * 100, 2) AS closedRate \r\nFROM zt_product AS t1 \r\nLEFT JOIN zt_project AS t2 ON t1.program = t2.id AND t2.type = \'program\' AND t2.grade = 1 \r\nLEFT JOIN zt_module AS t3 ON t1.line = t3.id AND t3.type = \'line\' \r\nLEFT JOIN (SELECT product, COUNT(1) AS story FROM zt_story WHERE deleted = \'0\' AND closedReason = \'done\' GROUP BY product) AS t4 ON t1.id = t4.product \r\nLEFT JOIN (SELECT product, COUNT(1) AS story FROM zt_story WHERE deleted = \'0\' AND ( closedReason = \'done\' OR status != \'closed\') GROUP BY product) AS t5 ON t1.id = t5.product \r\nWHERE t1.deleted = \'0\' AND t1.status != \'closed\' AND t1.shadow = \'0\' AND t1.vision = \'rnd\' AND t5.story IS NOT NULL \r\nORDER BY t1.order DESC',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1047,'宏观数据-产品Bug修复率',1,'bar',0,'','','{\r\n\"xaxis\":[{\"field\":\"product\",\"name\":\"产品\"}],\r\n\"yaxis\":[\r\n    {\"type\":\"value\",\"field\":\"fixedRate\",\"agg\":\"value\",\"name\":\"Bug修复率\",\"valOrAgg\":\"value\"}\r\n]}','[]','','SELECT \r\n  t1.name AS product,\r\n  IFNULL(t2.name, \'/\') AS program,\r\n  IFNULL(t3.name, \'/\') AS productLine,\r\n  IFNULL(t4.bug, 0) AS fixedBug,\r\n  t5.bug AS totalBug,\r\n  ROUND(IFNULL(t4.bug, 0) / t5.bug * 100, 2) AS fixedRate\r\nFROM zt_product AS t1\r\nLEFT JOIN zt_project AS t2 ON t1.program = t2.id AND t2.type = \'program\' AND t2.grade = 1\r\nLEFT JOIN zt_module AS t3 ON t1.line = t3.id AND t3.type = \'line\'\r\nLEFT JOIN (SELECT product, COUNT(1) AS bug FROM zt_bug WHERE deleted = \'0\' AND resolution = \'fixed\' AND status = \'closed\' GROUP BY product) AS t4 ON t1.id = t4.product\r\nLEFT JOIN (SELECT product, COUNT(1) AS bug FROM zt_bug WHERE deleted = \'0\' AND (resolution = \'fixed\' OR resolution = \'postponed\' OR status = \'active\') GROUP BY product) AS t5 ON t1.id = t5.product\r\nWHERE t1.deleted = \'0\' AND t1.status != \'closed\' AND t1.shadow = \'0\' AND t1.vision = \'rnd\'  AND t5.bug IS NOT NULL\r\nORDER BY t1.order DESC',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1048,'宏观数据-公司组织结构图',1,'org',0,'','','','[]','','',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1049,'宏观数据-部门人员分布图',1,'bar',0,'','','{\r\n\"xaxis\":[{\"field\":\"deptName\",\"name\":\"部门\"}],\r\n\"yaxis\":[\r\n    {\"type\":\"value\",\"field\":\"count\",\"agg\":\"value\",\"name\":\"部门人数\",\"valOrAgg\":\"value\"}\r\n]}','[]','','SELECT IF(t3.id IS NOT NULL, t3.`name`, \'空\') AS deptName,count(1) as count, \r\nIF(t3.id IS NOT NULL, t3.`order`, 9999) AS deptOrder \r\nFROM `zt_user` AS t1 \r\nLEFT JOIN `zt_dept` AS t2 ON t1.dept = t2.id\r\nLEFT JOIN `zt_dept` AS t3 ON FIND_IN_SET(TRIM(\',\' FROM t3.path), TRIM(\',\' FROM t2.path)) AND t3.grade = \'1\'\r\nWHERE t1.deleted = \'0\'\r\nGROUP BY deptName, deptOrder \r\nORDER BY deptOrder  DESC',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1050,'宏观数据-公司角色分布图',1,'pie',0,'','','{\"group\":[{\"field\":\"role\",\"name\":\"类型\"}],\"metric\":[{\"type\":\"agg\",\"field\":\"account\",\"agg\":\"count\",\"name\":\"人数\",\"valOrAgg\":\"count\"}]}','[]','','SELECT\n	account,\nCASE\n		ROLE \n		WHEN \'dev\' THEN\n		\'研发\' \n		WHEN \'qa\' THEN\r\n		\'测试\'\r\n		WHEN \'pm\' THEN\r\n		\'项目经理\'\r\n		WHEN \'others\' THEN\r\n		\'其他\'\r\n		WHEN \'td\' THEN\r\n		\'研发主管\'\r\n		WHEN \'pd\' THEN\r\n		\'产品主管\'\r\n		WHEN \'po\' THEN\r\n		\'产品经理\'\r\n		WHEN \'qd\' THEN\r\n		\'测试主管\'\r\n		WHEN \'top\' THEN\r\n		\'高层管理\'\r\n		ELSE\r\n		\'未知\'\r\n		END\r\n		role\n	FROM\n		`zt_user` \n	WHERE\n		deleted = \'0\' ',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1051,'宏观数据-人员工龄分布图',1,'bar',0,'','','{\r\n\"xaxis\":[{\"field\":\"joinDate\",\"name\":\"工龄\"}],\r\n\"yaxis\":[\r\n    {\"type\":\"value\",\"field\":\"count\",\"agg\":\"value\",\"name\":\"人数\",\"valOrAgg\":\"value\"}\r\n]}','[]','','SELECT count(1) as count, \'0-1年\' as joinDate FROM `zt_user` WHERE deleted = \'0\' AND `join` > DATE_SUB(NOW(), INTERVAL 1 YEAR)\r\nunion\r\nSELECT count(1) as count, \'1-3年\' as joinDate FROM `zt_user` WHERE deleted = \'0\' AND `join` > DATE_SUB(NOW(), INTERVAL 3 YEAR) AND `join` <= DATE_SUB(NOW(), INTERVAL 1 YEAR)\r\nunion\r\nSELECT count(1) as count, \'3-5年\' as joinDate FROM `zt_user` WHERE deleted = \'0\' AND `join` > DATE_SUB(NOW(), INTERVAL 5 YEAR) AND `join` <= DATE_SUB(NOW(), INTERVAL 3 YEAR)\r\nunion\r\nSELECT count(1) as count, \'5-10年\' as joinDate FROM `zt_user` WHERE deleted = \'0\' AND `join` > DATE_SUB(NOW(), INTERVAL 10 YEAR) AND `join` <= DATE_SUB(NOW(), INTERVAL 5 YEAR)\r\nunion\r\nSELECT count(1) as count, \'10年以上\' as joinDate FROM `zt_user` WHERE deleted = \'0\' AND `join` < DATE_SUB(NOW(), INTERVAL 10 YEAR) AND LEFT(`join`, 4) != \'0000\'\r\nunion                                                                                                                                                                                                                                                          \r\nSELECT count(1) as count, \'未知\' as joinDate FROM `zt_user` WHERE deleted = \'0\' AND LEFT(`join`, 4) = \'0000\'',1,'admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1055,'年度新增-一级项目集个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\n\"type\": \"value\"\n}','',NULL,'SELECT\r\n	t1.`year`,\r\n	t2.id,\r\n	t2.name\r\nFROM\r\n	( SELECT DISTINCT YEAR ( `date` ) AS \'year\' FROM zt_action ) AS t1\r\n	LEFT JOIN (\r\n	SELECT\r\n		id, name,\r\n		YEAR ( openedDate ) AS `year` \r\n	FROM\r\n		zt_project \r\n	WHERE\r\n		`type` = \'program\' \r\n		AND deleted = \'0\' \r\n		AND grade = \'1\'  \r\n	) t2 ON t1.`year` = t2.`year`	\r\n WHERE t2.id IS NOT NULL',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1056,'年度新增-产品个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\n\"type\": \"value\"\n}','',NULL,'SELECT\r\n	t1.`year`,\r\n	t2.id,\r\n	t2.name\r\nFROM\r\n	( SELECT DISTINCT YEAR ( `date` ) AS \'year\' FROM zt_action ) AS t1\r\n	LEFT JOIN (\r\n	SELECT\r\n		id, name,\r\n		YEAR ( createdDate ) AS `year` \r\n	FROM\r\n		zt_product \r\n	WHERE\r\n		deleted = \'0\' \r\n		AND shadow = \'0\' \r\n	) t2 ON t1.`year` = t2.`year`	\r\n WHERE t2.id IS NOT NULL',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1057,'年度新增-需求个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\n\"type\": \"value\"\n}','',NULL,'SELECT\n	t1.`year`,\n	t2.id,\r\n	t2.title\nFROM\n	( SELECT DISTINCT YEAR ( `date` ) AS \'year\' FROM zt_action ) AS t1\n	LEFT JOIN ( SELECT id, title, YEAR ( openedDate ) AS `year` FROM zt_story WHERE deleted = \'0\' ) AS t2 ON t1.`year` = t2.`year`	\r\n WHERE t2.id IS NOT NULL',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1058,'年度新增-Bug个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\n\"type\": \"value\"\n}','',NULL,'SELECT\r\n	t1.`year`,\r\n	t2.id,\r\n	t2.title\r\nFROM\r\n	( SELECT DISTINCT YEAR ( `date` ) AS \'year\' FROM zt_action ) AS t1\r\n	LEFT JOIN ( SELECT id, title, YEAR ( openedDate ) AS `year` FROM zt_bug WHERE deleted = \'0\' ) AS t2 ON t1.`year` = t2.`year`	\r\n WHERE t2.id IS NOT NULL',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1059,'年度新增-计划个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\n\"type\": \"value\"\n}','',NULL,'SELECT\n	t1.`year`,\n	t2.id,\r\n	t2.title\nFROM\n	( SELECT DISTINCT YEAR ( `date` ) AS \'year\' FROM zt_action ) AS t1\n	LEFT JOIN ( SELECT id, title, YEAR ( createdDate ) AS `year` FROM zt_productplan WHERE deleted = \'0\') AS t2 ON t1.`year` = t2.`year`	\r\n WHERE t2.id IS NOT NULL',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1060,'年度新增-项目个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\n\"type\": \"value\"\n}','',NULL,'SELECT\r\n	t1.`year`,\r\n	t2.id,\r\n	t2.name\r\nFROM\r\n	( SELECT DISTINCT YEAR ( `date` ) AS \'year\' FROM zt_action ) AS t1\r\n	LEFT JOIN (\r\n	SELECT\r\n		id, name,\r\n		YEAR ( openedDate ) AS `year` \r\n	FROM\r\n		zt_project \r\n	WHERE\r\n		`type` = \'project\' \r\n		AND deleted = \'0\' \r\n	) t2 ON t1.`year` = t2.`year`	\r\n WHERE t2.id IS NOT NULL',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1061,'年度新增-执行个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','',NULL,'SELECT t1.`year`, t2.id, t2.name\r\nFROM (SELECT DISTINCT YEAR(`date`) AS \'year\' FROM zt_action) AS t1\r\nLEFT JOIN (SELECT id,name, YEAR(openedDate) AS `year` FROM zt_project WHERE `type` IN ( \'sprint\', \'stage\', \'kanban\' ) AND deleted = \'0\' AND multiple = \'1\') AS t2 ON t1.`year` = t2.`year` \r\nWHERE t2.id IS NOT NULL',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1062,'年度新增-任务数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','',NULL,'SELECT\r\n	t1.`year`,\r\n	t2.id,\r\n	t2.name\r\nFROM\r\n	( SELECT DISTINCT YEAR ( `date` ) AS \'year\' FROM zt_action ) AS t1\r\n	LEFT JOIN ( SELECT id, name, YEAR ( openedDate ) AS `year` FROM zt_task WHERE deleted = \'0\') AS t2 ON t1.`year` = t2.`year`	\r\n WHERE t2.id IS NOT NULL',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1063,'年度新增-文档个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\n\"type\": \"value\"\n}','',NULL,'SELECT\n	t1.`year`,\n	t2.id,\r\n	t2.title\nFROM\n	( SELECT DISTINCT YEAR ( `date` ) AS \'year\' FROM zt_action ) AS t1\n	LEFT JOIN ( SELECT id, title, YEAR ( addedDate ) AS `year` FROM zt_doc WHERE deleted = \'0\') AS t2 ON t1.`year` = t2.`year`	\r\n WHERE t2.id IS NOT NULL',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1064,'年度新增-发布个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','',NULL,'SELECT\r\n	t1.`year`,\r\n	t2.id,\r\n	t2.name\r\nFROM\r\n	( SELECT DISTINCT YEAR ( `date` ) AS \'year\' FROM zt_action ) AS t1\r\n	LEFT JOIN ( SELECT id, name, YEAR ( `date` ) AS `year` FROM zt_release WHERE deleted = \'0\') AS t2 ON t1.`year` = t2.`year`\r\nWHERE t2.id IS NOT NULL',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1065,'年度新增-人员个数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"account\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"realname\": \"\"},\n\"type\": \"value\"\n}','',NULL,'SELECT\n	t1.`year`,\r\n	t2.account,\r\n	t2.realname\nFROM\n	( SELECT DISTINCT YEAR ( `date` ) AS \'year\' FROM zt_action ) AS t1\n	LEFT JOIN (\n	SELECT\n		account, realname,\n		YEAR ( t112.`date` ) AS \'year\' \n	FROM\n		zt_user AS t111\n		LEFT JOIN zt_action t112 ON t111.id = t112.objectID \n		AND t112.objectType = \'user\' \n	WHERE\n		t111.deleted = \'0\' \n		AND t112.action = \'created\' \n	) AS t2 ON t1.`year` = t2.`year` 	\r\n WHERE t2.account IS NOT NULL',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1066,'年度新增-完成项目数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\n\"type\": \"value\"\n}','',NULL,'SELECT\r\n	t1.`year`,\r\n	t2.id,\r\n	t2.name\r\nFROM\r\n	( SELECT DISTINCT YEAR ( `date` ) AS \'year\' FROM zt_action ) AS t1\r\n	LEFT JOIN (\r\n	SELECT\r\n		id, name,\r\n		YEAR ( closedDate ) AS `year` \r\n	FROM\r\n		zt_project \r\n	WHERE\r\n		`type` = \'project\' \r\n		AND deleted = \'0\' \r\n		AND grade = \'1\'  \r\n	) t2 ON t1.`year` = t2.`year`	\r\n WHERE t2.id IS NOT NULL',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1067,'年度新增-完成执行数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','',NULL,'SELECT t1.`year`, t2.id, t2.name\r\nFROM (SELECT DISTINCT YEAR(date) AS \'year\' FROM zt_action) AS t1\r\nLEFT JOIN (SELECT id, name, YEAR(closedDate) AS `year` FROM zt_project WHERE `type` IN ( \'sprint\', \'stage\', \'kanban\' ) AND deleted = \'0\' AND multiple = \'1\' AND status = \'closed\') AS t2 ON t1.`year` = t2.`year` \r\nWHERE t2.id IS NOT NULL',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1068,'年度新增-完成发布数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\n\"type\": \"value\"\n}','',NULL,'SELECT\r\n	t1.`year`,\r\n	t2.id,\r\n	t2.name\r\nFROM\r\n	( SELECT DISTINCT YEAR ( `date` ) AS \'year\' FROM zt_action ) AS t1\r\n	LEFT JOIN ( SELECT id, name, YEAR ( `date` ) AS `year` FROM zt_release WHERE deleted = \'0\') AS t2 ON t1.`year` = t2.`year`	\r\n WHERE t2.id IS NOT NULL',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1069,'年度新增-完成需求数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\n\"type\": \"value\"\n}','',NULL,'SELECT\n	t1.`year`,\n	t2.id,\n	t2.title\nFROM\n	( SELECT DISTINCT YEAR ( `date` ) AS \'year\' FROM zt_action ) AS t1\n	LEFT JOIN (\n	SELECT\n		id, title,\n		YEAR ( closedDate ) AS `year` \n	FROM\n		zt_story \n	WHERE\n		deleted = \'0\' \n		AND closedReason = \'done\' \n		AND STATUS = \'closed\' \n	) AS t2 ON t1.`year` = t2.`year`	\n WHERE t2.id IS NOT NULL',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1070,'年度新增-解决Bug数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','',NULL,'SELECT\r\n	t1.`year`,\r\n	t2.id,\r\n	t2.title\r\nFROM\r\n	( SELECT DISTINCT YEAR ( `date` ) AS \'year\' FROM zt_action ) AS t1\r\n	LEFT JOIN (\r\n	SELECT\r\n		id, title,\r\n		YEAR ( closedDate ) AS `year` \r\n	FROM\r\n		zt_bug \r\n	WHERE\r\n		deleted = \'0\' \r\n		AND resolution = \'fixed\' \r\n		AND STATUS = \'closed\' \r\n	) AS t2 ON t1.`year` = t2.`year`	\r\n WHERE t2.id IS NOT NULL',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1071,'年度新增-完成任务数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','',NULL,'SELECT\r\n	t1.`year`,\r\n	t2.id,\r\n	t2.name\r\nFROM\r\n	( SELECT DISTINCT YEAR ( `date` ) AS \'year\' FROM zt_action ) AS t1\r\n	LEFT JOIN (\r\n	SELECT\r\n		id, name,\r\n		YEAR ( finishedDate ) AS `year` \r\n	FROM\r\n		zt_task \r\n	WHERE\r\n		deleted = \'0\' \r\n		AND STATUS = \'closed\' \r\n		AND closedReason = \'done\' \r\n	) AS t2 ON t1.`year` = t2.`year`	\r\n WHERE t2.id IS NOT NULL',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1072,'年度新增-投入工时数',1,'card',0,'','','{\"value\": {\"type\": \"value\", \"field\": \"consumed\", \"agg\": \"value\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','',NULL,'SELECT\r\n	t1.`year`,\r\n	IFNULL( t2.consumed, 0 ) AS consumed \r\nFROM\r\n	( SELECT DISTINCT YEAR ( `date` ) AS \'year\' FROM zt_action ) AS t1\r\n	LEFT JOIN ( SELECT ROUND( SUM( consumed )) AS consumed, YEAR ( `date` ) AS \'year\' FROM zt_effort WHERE deleted = \'0\' GROUP BY `year`) AS t2 ON t1.`year` = t2.`year` ',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1073,'年度新增-项目集年度新增数据汇总表',1,'table',0,'','','{\"group\":[],\"column\":[\r\n{\"field\":\"topProgram\",\"valOrAgg\":\"value\",\"name\":\"一级项目集\"},\r\n{\"field\":\"product\",\"valOrAgg\":\"value\",\"name\":\"产品数\"},\r\n{\"field\":\"plan\",\"valOrAgg\":\"value\",\"name\":\"计划数\"},\r\n{\"field\":\"story\",\"valOrAgg\":\"value\",\"name\":\"需求数\"},\r\n{\"field\":\"bug\",\"valOrAgg\":\"value\",\"name\":\"Bug数\"},\r\n{\"field\":\"release\",\"valOrAgg\":\"value\",\"name\":\"发布数\"},\r\n{\"field\":\"doc\",\"valOrAgg\":\"value\",\"name\":\"文档数\"}\r\n],\"filter\":[]}','',NULL,'SELECT\r\n    t1.name AS topProgram,t1.id, t2.`year`, (SELECT COUNT(1) as product FROM zt_product WHERE deleted = \'0\' AND shadow = \'0\' AND YEAR(createdDate) = t2.`year` AND program = t1.id) as product, SUM(IFNULL(t4.plan, 0)) AS plan, SUM(IFNULL(t5.story, 0)) AS story, SUM(IFNULL(t6.bug, 0)) AS bug, SUM(IFNULL(t7.`release`, 0)) AS \'release\', SUM(IFNULL(t8.doc, 0)) AS doc\r\nFROM zt_project AS t1\r\nLEFT JOIN (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) as t2 ON 1 = 1 LEFT JOIN (SELECT id, program FROM zt_product WHERE deleted = \'0\') AS t3 ON t1.id = t3.program\r\nLEFT JOIN (SELECT COUNT(1) as \'plan\', product, YEAR(createdDate) as \'year\' FROM zt_productplan WHERE deleted = \'0\' GROUP BY product,`year`) AS t4 on t3.id = t4.product AND t4.`year`= t2.`year` LEFT JOIN (SELECT COUNT(1) as \'story\', product, YEAR(openedDate) as \'year\' FROM zt_story WHERE deleted = \'0\' GROUP BY product,`year`) AS t5 on t3.id = t5.product AND t5.`year`= t2.`year` LEFT JOIN (SELECT COUNT(1) as \'bug\', product, YEAR(openedDate) as \'year\' FROM zt_bug WHERE deleted = \'0\' GROUP BY product,`year`) AS t6 on t3.id = t6.product AND t6.`year` = t2.`year` LEFT JOIN (SELECT COUNT(1) as \'release\', product, YEAR(`date`) as \'year\' FROM zt_release WHERE deleted = \'0\' GROUP BY product,`year`) AS t7 on t3.id = t7.product AND t7.`year` = t2.`year` LEFT JOIN (SELECT COUNT(1) as \'doc\', product, YEAR(addedDate) as \'year\' FROM zt_doc WHERE deleted = \'0\' GROUP BY product,`year`) AS t8 on t3.id = t8.product AND t8.`year` = t2.`year` WHERE t1.type = \'program\' AND t1.grade = 1 AND t1.deleted = \'0\'AND t1.status != \'closed\' GROUP BY topProgram,id,`year` ORDER BY `year`, topProgram',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1074,'年度新增-项目集年度完成数据概览',1,'table',0,'','','{\"group\":[],\"column\":[\r\n{\"field\":\"topProgram\",\"valOrAgg\":\"value\",\"name\":\"一级项目集\"},\r\n{\"field\":\"projectA\",\"valOrAgg\":\"value\",\"name\":\"项目数\"},\r\n{\"field\":\"executionA\",\"valOrAgg\":\"value\",\"name\":\"执行数\"},\r\n{\"field\":\"release\",\"valOrAgg\":\"value\",\"name\":\"发布数\"},\r\n{\"field\":\"story\",\"valOrAgg\":\"value\",\"name\":\"需求数\"},\r\n{\"field\":\"bug\",\"valOrAgg\":\"value\",\"name\":\"Bug数\"}\r\n],\"filter\":[]}','',NULL,'SELECT\r\n    t1.name AS topProgram,t1.id,t2.`year`,\r\n    SUM(IF((t3.`status` = \'closed\' AND YEAR(t3.closedDate) = t2.`year`), 1, 0)) as projectA,\r\n    COUNT(DISTINCT t4.id) as executionA,\r\n    SUM(IFNULL(t6.`release`, 0)) AS \'release\',\r\n    SUM(IFNULL(t7.story, 0)) AS story,\r\n    SUM(IFNULL(t8.bug, 0)) AS bug\r\nFROM zt_project AS t1\r\nLEFT JOIN (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) as t2 ON 1 = 1\r\nLEFT JOIN zt_project AS t3 ON FIND_IN_SET(t1.id, t3.path) and t3.type = \'project\'\r\nLEFT JOIN zt_project AS t4 ON t3.id = t4.parent and t4.type in (\'sprint\', \'stage\', \'kanban\') AND t4.`status` = \'closed\' AND YEAR(t4.closedDate) = t2.`year`\r\nLEFT JOIN (SELECT id,program FROM zt_product WHERE deleted = \'0\') AS t5 ON t1.id = t5.program\r\nLEFT JOIN (SELECT COUNT(1) as \'release\', product, YEAR(`date`) as `year` FROM zt_release WHERE deleted = \'0\' GROUP BY product, `year`) AS t6 ON t5.id = t6.product AND t6.`year` = t2.`year`\r\nLEFT JOIN (SELECT COUNT(1) as \'story\', product, YEAR(closedDate) as `year` FROM zt_story WHERE deleted = \'0\' AND closedReason = \'done\' AND status = \'closed\' GROUP BY product, `year`) AS t7 on t5.id = t7.product AND t7.`year` = t2.`year`\r\nLEFT JOIN (SELECT COUNT(1) as \'bug\', product, YEAR(resolvedDate) as `year` FROM zt_bug WHERE deleted = \'0\' AND resolution = \'fixed\' AND status = \'closed\' GROUP BY product, `year`) AS t8 on t5.id = t8.product AND t8.`year` = t2.`year`\r\nWHERE t1.type = \'program\' AND t1.grade = 1 AND t1.deleted = \'0\'\r\nGROUP BY t1.name,t1.id,t2.`year`',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1075,'年度新增-产品年度新增数据汇总表',1,'table',0,'','','{\"group\":[],\"column\":[\r\n{\"field\":\"name\",\"valOrAgg\":\"value\",\"name\":\"产品\"},\r\n{\"field\":\"story\",\"valOrAgg\":\"value\",\"name\":\"需求数\"},\r\n{\"field\":\"bug\",\"valOrAgg\":\"value\",\"name\":\"Bug数\"},\r\n{\"field\":\"plan\",\"valOrAgg\":\"value\",\"name\":\"计划数\"},\r\n{\"field\":\"release\",\"valOrAgg\":\"value\",\"name\":\"发布数\"}\r\n],\"filter\":[]}','',NULL,'SELECT\r\n    t1.name,t1.id,t2.`year`,IF(YEAR(t1.createdDate) = t2.`year`, 1, 0) as newProduct,\r\n    SUM(IFNULL(t3.story, 0)) AS story,\r\n    SUM(IFNULL(t4.bug, 0)) AS bug,\r\n    SUM(IFNULL(t5.`plan`, 0)) AS \'plan\',\r\n    SUM(IFNULL(t6.`release`, 0)) AS \'release\'\r\nFROM zt_product AS t1\r\nLEFT JOIN (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) as t2 ON 1 = 1\r\nLEFT JOIN (SELECT COUNT(1) as \'story\', product, YEAR(openedDate) as `year` FROM zt_story WHERE deleted = \'0\' AND closedReason = \'done\' AND status = \'closed\' GROUP BY product, `year`) AS t3 on t1.id = t3.product AND t3.`year` = t2.`year`\r\nLEFT JOIN (SELECT COUNT(1) as \'bug\', product, YEAR(openedDate) as `year` FROM zt_bug WHERE deleted = \'0\' AND resolution = \'fixed\' AND status = \'closed\' GROUP BY product, `year`) AS t4 on t1.id = t4.product AND t4.`year` = t2.`year`\r\nLEFT JOIN (SELECT COUNT(1) as \'plan\', product, YEAR(createdDate) AS \'year\' FROM zt_productplan WHERE deleted = \'0\' GROUP BY product,`year`) AS t5 on t1.id = t5.product AND t5.`year` = t2.`year`\r\nLEFT JOIN (SELECT COUNT(1) as \'release\', product, YEAR(`date`) as `year` FROM zt_release WHERE deleted = \'0\' GROUP BY product, `year`) AS t6 ON t1.id = t6.product AND t6.`year` = t2.`year`\r\nWHERE t1.deleted = \'0\' AND t1.status != \'closed\' AND t1.shadow = \'0\'\r\nAND t2.`year` = \'2022\'\r\nGROUP BY t1.name,t1.id,t2.`year`,newProduct',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1076,'年度新增-产品年度完成数据汇总表',1,'table',0,'','','{\"group\":[],\"column\":[\r\n{\"field\":\"name\",\"valOrAgg\":\"value\",\"name\":\"产品\"},\r\n{\"field\":\"story\",\"valOrAgg\":\"value\",\"name\":\"需求数\"},\r\n{\"field\":\"bug\",\"valOrAgg\":\"value\",\"name\":\"Bug数\"},\r\n{\"field\":\"plan\",\"valOrAgg\":\"value\",\"name\":\"计划数\"},\r\n{\"field\":\"release\",\"valOrAgg\":\"value\",\"name\":\"发布数\"}\r\n],\"filter\":[]}','',NULL,'SELECT\r\n    t1.name,t1.id,t2.`year`,IF(YEAR(t1.createdDate) = t2.`year`, 1, 0) as newProduct,\r\n    SUM(IFNULL(t3.story, 0)) AS story,\r\n    SUM(IFNULL(t4.bug, 0)) AS bug,\r\n    SUM(IFNULL(t5.`plan`, 0)) AS \'plan\',\r\n    SUM(IFNULL(t6.`release`, 0)) AS \'release\'\r\nFROM zt_product AS t1\r\nLEFT JOIN (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) as t2 ON 1 = 1\r\nLEFT JOIN (SELECT COUNT(1) as \'story\', product, YEAR(closedDate) as `year` FROM zt_story WHERE deleted = \'0\' AND closedReason = \'done\' AND status = \'closed\' GROUP BY product, `year`) AS t3 on t1.id = t3.product AND t3.`year` = t2.`year`\r\nLEFT JOIN (SELECT COUNT(1) as \'bug\', product, YEAR(resolvedDate) as `year` FROM zt_bug WHERE deleted = \'0\' AND resolution = \'fixed\' AND status = \'closed\' GROUP BY product, `year`) AS t4 on t1.id = t4.product AND t4.`year` = t2.`year`\r\nLEFT JOIN (\r\n    SELECT COUNT(DISTINCT t51.id) as \'plan\', t51.product, YEAR(t52.`date`) AS \'year\'\r\n    FROM zt_productplan AS t51\r\n    LEFT JOIN (SELECT objectID,objectType,action,MAX(`date`) as \'date\' FROM zt_action GROUP BY objectID,objectType, action) AS t52 ON t51.id = t52.objectID AND t52.objectType = \'productplan\'\r\n    WHERE t51.deleted = \'0\' AND t51.closedReason = \'done\' AND t51.status = \'closed\' \r\n    AND t52.action = \'closed\'\r\n    GROUP BY t51.product,`year`\r\n) AS t5 on t1.id = t5.product AND t5.`year` = t2.`year`\r\nLEFT JOIN (SELECT COUNT(1) as \'release\', product, YEAR(`date`) as `year` FROM zt_release WHERE deleted = \'0\' GROUP BY product, `year`) AS t6 ON t1.id = t6.product AND t6.`year` = t2.`year`\r\nWHERE t1.deleted = \'0\' AND t1.status != \'closed\' AND t1.shadow = \'0\'\r\nGROUP BY t1.name,t1.id,t2.`year`,newProduct',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1077,'年度新增-需求年度新增和完成趋势图',1,'line',0,'','','{\r\n  \"xaxis\":[{\"field\":\"month\",\"name\":\"月份\",\"group\":\"value\"}],\r\n  \"yaxis\":[{\"type\":\"value\",\"field\":\"newStory\",\"agg\":\"value\",\"name\":\"新增需求数\",\"valOrAgg\":\"value\"},\r\n             {\"type\":\"value\",\"field\":\"closedStory\",\"agg\":\"value\",\"name\":\"完成需求数\",\"valOrAgg\":\"value\"}\r\n]}','',NULL,'SELECT \r\n  t1.year, \r\n  t1.month, \r\n  IFNULL(t2.story, 0) AS newStory, \r\n  IFNULL(t3.story, 0) AS closedStory \r\nFROM \r\n  (\r\n    SELECT \r\n      DISTINCT Year(date) AS `year`, \r\n      MONTH(date) AS `month` \r\n    FROM \r\n      zt_action\r\n  ) AS t1 \r\n  LEFT JOIN (\r\n    SELECT \r\n      YEAR(openedDate) AS `year`, \r\n      MONTH(openedDate) AS `month`, \r\n      COUNT(1) AS story \r\n    FROM \r\n      zt_story \r\n    WHERE \r\n      deleted = \'0\' \r\n    GROUP BY \r\n      `year`, \r\n      `month`\r\n  ) AS t2 ON t1.year = t2.year \r\n  AND t1.month = t2.month \r\n  LEFT JOIN (\r\n    SELECT \r\n      YEAR(closedDate) AS `year`, \r\n      MONTH(closedDate) AS `month`, \r\n      COUNT(1) AS story \r\n    FROM \r\n      zt_story \r\n    WHERE \r\n      deleted = \'0\' \r\n      AND closedReason = \'done\' \r\n    GROUP BY \r\n      `year`, \r\n      `month`\r\n  ) AS t3 ON t1.year = t3.year \r\n  AND t1.month = t3.month \r\nORDER BY \r\n  `year`, \r\n  `month`',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1078,'年度新增-Bug年度新增和解决趋势图',1,'line',0,'','','{\r\n  \"xaxis\":[{\"field\":\"month\",\"name\":\"月份\",\"group\":\"value\"}],\r\n  \"yaxis\":[{\"type\":\"value\",\"field\":\"newBug\",\"agg\":\"value\",\"name\":\"新增Bug数\",\"valOrAgg\":\"value\"},\r\n             {\"type\":\"value\",\"field\":\"fixedBug\",\"agg\":\"value\",\"name\":\"解决Bug数\",\"valOrAgg\":\"value\"}\r\n]}','',NULL,'SELECT \r\n  t1.year, \r\n  t1.month, \r\n  IFNULL(t2.bug, 0) AS newBug, \r\n  IFNULL(t3.bug, 0) AS fixedBug \r\nFROM \r\n  (\r\n    SELECT \r\n      DISTINCT Year(date) AS `year`, \r\n      MONTH(date) AS `month` \r\n    FROM \r\n      zt_action\r\n  ) AS t1 \r\n  LEFT JOIN (\r\n    SELECT \r\n      YEAR(openedDate) AS `year`, \r\n      MONTH(openedDate) AS `month`, \r\n      COUNT(1) AS bug \r\n    FROM \r\n      zt_bug \r\n    WHERE \r\n      deleted = \'0\' \r\n    GROUP BY \r\n      `year`, \r\n      `month`\r\n  ) AS t2 ON t1.year = t2.year \r\n  AND t1.month = t2.month \r\n  LEFT JOIN (\r\n    SELECT \r\n      YEAR(closedDate) AS `year`, \r\n      MONTH(closedDate) AS `month`, \r\n      COUNT(1) AS bug \r\n    FROM \r\n      zt_bug \r\n    WHERE \r\n      deleted = \'0\' \r\n      AND resolution = \'fixed\' \r\n      AND status = \'closed\' \r\n    GROUP BY \r\n      `year`, \r\n      `month`\r\n  ) AS t3 ON t1.year = t3.year \r\n  AND t1.month = t3.month\r\nORDER BY \r\n  `year`, \r\n  `month`',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1079,'年度新增-任务年度新增和完成趋势图',1,'line',0,'','','{\r\n  \"xaxis\":[{\"field\":\"month\",\"name\":\"月份\",\"group\":\"value\"}],\r\n  \"yaxis\":[{\"type\":\"value\",\"field\":\"newTask\",\"agg\":\"value\",\"name\":\"新增任务数\",\"valOrAgg\":\"value\"},\r\n             {\"type\":\"value\",\"field\":\"closedTask\",\"agg\":\"value\",\"name\":\"完成任务数\",\"valOrAgg\":\"value\"}\r\n]}','',NULL,'SELECT \r\n  t1.year, \r\n  t1.month, \r\n  IFNULL(t2.task, 0) AS newTask, \r\n  IFNULL(t3.task, 0) AS closedTask \r\nFROM \r\n  (\r\n    SELECT \r\n      DISTINCT Year(date) AS `year`, \r\n      MONTH(date) AS `month` \r\n    FROM \r\n      zt_action\r\n  ) AS t1 \r\n  LEFT JOIN (\r\n    SELECT \r\n      YEAR(openedDate) AS `year`, \r\n      MONTH(openedDate) AS `month`, \r\n      COUNT(1) AS task \r\n    FROM \r\n      zt_task \r\n    WHERE \r\n      deleted = \'0\' \r\n    GROUP BY \r\n      `year`, \r\n      `month`\r\n  ) AS t2 ON t1.year = t2.year \r\n  AND t1.month = t2.month \r\n  LEFT JOIN (\r\n    SELECT \r\n      YEAR(closedDate) AS `year`, \r\n      MONTH(closedDate) AS `month`, \r\n      COUNT(1) AS task \r\n    FROM \r\n      zt_task \r\n    WHERE \r\n      deleted = \'0\' \r\n      AND status = \'closed\' \r\n    GROUP BY \r\n      `year`, \r\n      `month`\r\n  ) AS t3 ON t1.year = t3.year \r\n  AND t1.month = t3.month\r\nORDER BY \r\n  `year`, \r\n  `month`',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1080,'年度新增-项目年度新增和完成趋势图',1,'line',0,'','','{\r\n  \"xaxis\":[{\"field\":\"month\",\"name\":\"月份\",\"group\":\"value\"}],\r\n  \"yaxis\":[{\"type\":\"value\",\"field\":\"newProject\",\"agg\":\"value\",\"name\":\"新增项目数\",\"valOrAgg\":\"value\"},\r\n             {\"type\":\"value\",\"field\":\"closedProject\",\"agg\":\"value\",\"name\":\"完成项目数\",\"valOrAgg\":\"value\"}\r\n]}','',NULL,'SELECT \r\n  t1.year, \r\n  t1.month, \r\n  IFNULL(t2.project, 0) AS newProject, \r\n  IFNULL(t3.project, 0) AS closedProject \r\nFROM \r\n  (\r\n    SELECT \r\n      DISTINCT Year(date) AS `year`, \r\n      MONTH(date) AS `month` \r\n    FROM \r\n      zt_action\r\n  ) AS t1 \r\n  LEFT JOIN (\r\n    SELECT \r\n      YEAR(openedDate) AS `year`, \r\n      MONTH(openedDate) AS `month`, \r\n      COUNT(1) AS project \r\n    FROM \r\n      zt_project \r\n    WHERE \r\n      deleted = \'0\' \r\n      AND type = \'project\' \r\n    GROUP BY \r\n      `year`, \r\n      `month`\r\n  ) AS t2 ON t1.year = t2.year \r\n  AND t1.month = t2.month \r\n  LEFT JOIN (\r\n    SELECT \r\n      YEAR(closedDate) AS `year`, \r\n      MONTH(closedDate) AS `month`, \r\n      COUNT(1) AS project \r\n    FROM \r\n      zt_project \r\n    WHERE \r\n      deleted = \'0\' \r\n      AND type = \'project\' \r\n      AND status = \'closed\' \r\n    GROUP BY \r\n      `year`, \r\n      `month`\r\n  ) AS t3 ON t1.year = t3.year \r\n  AND t1.month = t3.month\r\nORDER BY \r\n  `year`, \r\n  `month`',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1081,'年度新增-执行年度新增和完成趋势图',1,'line',0,'','','{\r\n  \"xaxis\":[{\"field\":\"month\",\"name\":\"月份\",\"group\":\"value\"}],\r\n  \"yaxis\":[{\"type\":\"value\",\"field\":\"newExecution\",\"agg\":\"value\",\"name\":\"新增执行数\",\"valOrAgg\":\"value\"},\r\n             {\"type\":\"value\",\"field\":\"closedExecution\",\"agg\":\"value\",\"name\":\"完成执行数\",\"valOrAgg\":\"value\"}\r\n]}','',NULL,'SELECT t1.year, t1.month, IFNULL(t2.execution, 0) AS newExecution, IFNULL(t3.execution, 0) AS closedExecution\r\nFROM (SELECT DISTINCT YEAR(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1 \r\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS execution FROM zt_project WHERE deleted = \'0\' AND type IN (\'sprint\', \'stage\', \'kanban\') AND multiple = \'1\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month \r\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS execution FROM zt_project WHERE deleted = \'0\' AND type IN (\'sprint\', \'stage\', \'kanban\') AND status = \'closed\' AND multiple = \'1\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\r\nORDER BY `year`, `month`',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1082,'年度新增-产品发布次数年度趋势图',1,'line',0,'','','{\r\n  \"xaxis\":[{\"field\":\"month\",\"name\":\"月份\",\"group\":\"value\"}],\r\n  \"yaxis\":[{\"type\":\"value\",\"field\":\"release\",\"agg\":\"value\",\"name\":\"发布次数\",\"valOrAgg\":\"value\"}\r\n]}','',NULL,'SELECT \r\n  t1.year, \r\n  t1.month, \r\n  IFNULL(t2.release, 0) AS `release`\r\nFROM \r\n  (\r\n    SELECT \r\n      DISTINCT Year(date) AS `year`, \r\n      MONTH(date) AS `month` \r\n    FROM \r\n      zt_action\r\n  ) AS t1 \r\n  LEFT JOIN (\r\n    SELECT \r\n      YEAR(createdDate) AS `year`, \r\n      MONTH(createdDate) AS `month`, \r\n      COUNT(1) AS `release` \r\n    FROM \r\n      zt_release\r\n    WHERE \r\n      deleted = \'0\'\r\n    GROUP BY \r\n      `year`, \r\n      `month`\r\n  ) AS t2 ON t1.year = t2.year \r\n  AND t1.month = t2.month\r\nORDER BY \r\n  `year`, \r\n  `month`',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1083,'年度新增-年度投入产出比',1,'line',0,'','','{\r\n  \"xaxis\":[{\"field\":\"month\",\"name\":\"月份\",\"group\":\"value\"}],\r\n  \"yaxis\":[{\"type\":\"value\",\"field\":\"ratio\",\"agg\":\"value\",\"name\":\"投入产出比\",\"valOrAgg\":\"value\"},\r\n{\"type\":\"value\",\"field\":\"story\",\"agg\":\"value\",\"name\":\"需求交付\",\"valOrAgg\":\"value\"},\r\n{\"type\":\"value\",\"field\":\"consumed\",\"agg\":\"value\",\"name\":\"工时消耗\",\"valOrAgg\":\"value\"}\r\n]}','',NULL,'SELECT t1.`year`, t1.`month`, IFNULL(t2.story, 0) AS story, IFNULL(t3.consumed, 0) AS consumed, ROUND(IF(IFNULL(t3.consumed, 0) = 0, 0, IFNULL(t2.story, 0) / IFNULL(t3.consumed, 0)), 2) AS ratio\r\nFROM (SELECT YEAR(`date`) AS \'year\', MONTH(`date`) AS \'month\' FROM zt_action GROUP BY `year`,`month`) AS t1\r\nLEFT JOIN (SELECT ROUND(SUM(estimate)) AS story, YEAR(`closedDate`) AS \'year\', MONTH(`closedDate`) AS \'month\' FROM zt_story WHERE  deleted = \'0\' AND closedReason = \'done\' AND status = \'closed\' GROUP BY `year`,`month`) AS t2 ON t1.`year` = t2.`year` AND t1.`month` = t2.`month`\r\nLEFT JOIN (SELECT ROUND(SUM(consumed)) as consumed, YEAR(`date`) as \'year\', MONTH(`date`) AS \'month\' FROM zt_effort WHERE deleted = \'0\' GROUP BY `year`,`month`) AS t3 ON t1.`year` = t3.`year` AND t1.`month` = t3.`month`',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1085,'年度排行-项目集-预算投入榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"program\",\"name\":\"项目集\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"budget\",\"agg\":\"value\",\"name\":\"预算\",\"valOrAgg\":\"value\"}]}','',NULL,'SELECT \r\n  YEAR(t2.openedDate) AS `year`, \r\n  t1.id,\r\n  t1.name AS program, \r\n  ROUND(\r\n    SUM(\r\n      IFNULL(t2.budget, 0)\r\n    ) / 10000, \r\n    2\r\n  ) AS budget \r\nFROM \r\n  zt_project AS t1 \r\n  LEFT JOIN zt_project AS t2 ON FIND_IN_SET(t1.id, t2.path) \r\n  AND t2.deleted = \'0\' \r\n  AND t2.type = \'project\' \r\nWHERE \r\n  t1.deleted = \'0\' \r\n  AND t1.type = \'program\' \r\n  AND t1.grade = 1 \r\nGROUP BY \r\n  `year`, \r\n  id,\r\n  program \r\nORDER BY \r\n  `year`, \r\n  budget DESC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1086,'年度排行-项目集-人员投入榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"setName\",\"name\":\"项目集\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"number\",\"agg\":\"value\",\"name\":\"人数\",\"valOrAgg\":\"value\"}]}','','','SELECT tt.join as `year`, count(1) as number, tt.setName from (\r\nselect \r\nYEAR(t1.join) as `join`, t4.name as setName \r\nfrom zt_team t1 \r\nRIGHT JOIN zt_project t2 on t2.id = t1.root\r\nLEFT JOIN zt_project t4 on FIND_IN_SET(t4.id,t2.path) and t4.grade = 1\r\nRIGHT JOIN zt_user t3 on t3.account = t1.account\r\nWHERE t1.type = \'project\'\r\n) tt\r\nGROUP BY tt.setName, tt.join\r\nORDER BY tt.join, number desc, tt.setName',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1087,'年度排行-项目集-工时消耗榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"program\",\"name\":\"项目集\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"consumed\",\"agg\":\"value\",\"name\":\"消耗工时\",\"valOrAgg\":\"value\"}]}','',NULL,'SELECT \r\n  YEAR(t5.date) AS `year`, \r\n  t1.id,\r\n  t1.name AS program, \r\n  ROUND(\r\n    SUM(t5.consumed), \r\n    2\r\n  ) AS consumed \r\nFROM \r\n  zt_project AS t1 \r\n  LEFT JOIN zt_project AS t2 ON FIND_IN_SET(t1.id, t2.path) \r\n  AND t2.deleted = \'0\' \r\n  AND t2.type = \'project\' \r\n  LEFT JOIN zt_project AS t3 ON t2.id = t3.parent \r\n  AND t3.deleted = \'0\' \r\n  AND t3.type IN (\'sprint\', \'stage\', \'kanban\') \r\n  LEFT JOIN zt_task AS t4 ON t3.id = t4.execution \r\n  AND t4.deleted = \'0\' \r\n  AND t4.status != \'cancel\' \r\n  LEFT JOIN zt_effort AS t5 ON t4.id = t5.objectID \r\n  AND t5.deleted = \'0\' \r\n  AND t5.objectType = \'task\' \r\nWHERE \r\n  t1.deleted = \'0\' \r\n  AND t1.type = \'program\' \r\n  AND t1.grade = 1 \r\n  AND t5.id IS NOT NULL \r\nGROUP BY \r\n  `year`, \r\n  id,\r\n  program \r\nORDER BY \r\n  `year`, \r\n  consumed DESC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1088,'年度排行-项目集-新增需求条目榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"program\",\"name\":\"项目集\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"story\",\"agg\":\"value\",\"name\":\"新增需求条数\",\"valOrAgg\":\"value\"}]}','',NULL,'SELECT \r\n  YEAR(t3.openedDate) AS `year`,\r\n  t1.id, \r\n  t1.name AS program, \r\n  COUNT(1) AS story \r\nFROM \r\n  zt_project AS t1 \r\n  LEFT JOIN zt_product AS t2 ON t1.id = t2.program \r\n  AND t2.deleted = \'0\' \r\n  LEFT JOIN zt_story AS t3 ON t2.id = t3.product \r\n  AND t3.deleted = \'0\' \r\nWHERE \r\n  t1.deleted = \'0\' \r\n  AND t1.type = \'program\' \r\n  AND t1.grade = 1 \r\n  AND t3.id IS NOT NULL \r\nGROUP BY \r\n  `year`, \r\n  id,\r\n  program \r\nORDER BY \r\n  `year`, \r\n  story DESC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1089,'年度排行-项目集-新增需求规模榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"program\",\"name\":\"项目集\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"story\",\"agg\":\"value\",\"name\":\"新增需求规模\",\"valOrAgg\":\"value\"}]}','','','SELECT \r\n  YEAR(t3.openedDate) AS `year`, \r\n  t1.id,\r\n  t1.name AS program, \r\n  ROUND(\r\n    SUM(t3.estimate), \r\n    2\r\n  ) AS story \r\nFROM \r\n  zt_project AS t1 \r\n  LEFT JOIN zt_product AS t2 ON t1.id = t2.program \r\n  AND t2.deleted = \'0\' \r\n  LEFT JOIN zt_story AS t3 ON t2.id = t3.product \r\n  AND t3.deleted = \'0\' \r\nWHERE \r\n  t1.deleted = \'0\' \r\n  AND t1.type = \'program\' \r\n  AND t1.grade = 1 \r\n  AND t3.id IS NOT NULL \r\nGROUP BY \r\n  `year`,\r\n  id, \r\n  program \r\nORDER BY \r\n  `year`, \r\n  story DESC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1090,'年度排行-项目集-新增Bug条目榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"program\",\"name\":\"项目集\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"bug\",\"agg\":\"value\",\"name\":\"新增Bug条目\",\"valOrAgg\":\"value\"}]}','',NULL,'SELECT \r\n  YEAR(t3.openedDate) AS `year`,\r\n  t1.id, \r\n  t1.name AS program, \r\n  COUNT(1) AS bug \r\nFROM \r\n  zt_project AS t1 \r\n  LEFT JOIN zt_product AS t2 ON t1.id = t2.program \r\n  AND t2.deleted = \'0\' \r\n  LEFT JOIN zt_bug AS t3 ON t2.id = t3.product \r\n  AND t3.deleted = \'0\' \r\nWHERE \r\n  t1.deleted = \'0\' \r\n  AND t1.type = \'program\' \r\n  AND t1.grade = 1 \r\n  AND t3.id IS NOT NULL \r\nGROUP BY \r\n  `year`, \r\n  id,\r\n  program \r\nORDER BY \r\n  `year`, \r\n  bug DESC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1091,'年度排行-项目集-完成需求条目榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"program\",\"name\":\"项目集\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"story\",\"agg\":\"value\",\"name\":\"完成需求条目\",\"valOrAgg\":\"value\"}]}','',NULL,'SELECT \r\n  YEAR(t3.closedDate) AS `year`, \r\n  t1.id,\r\n  t1.name AS program, \r\n  COUNT(1) AS story \r\nFROM \r\n  zt_project AS t1 \r\n  LEFT JOIN zt_product AS t2 ON t1.id = t2.program \r\n  AND t2.deleted = \'0\' \r\n  LEFT JOIN zt_story AS t3 ON t2.id = t3.product \r\n  AND t3.deleted = \'0\' \r\n  AND t3.closedReason = \'done\' \r\nWHERE \r\n  t1.deleted = \'0\' \r\n  AND t1.type = \'program\' \r\n  AND t1.grade = 1 \r\n  AND t3.id IS NOT NULL \r\nGROUP BY \r\n  `year`,\r\n  id,  \r\n  program \r\nORDER BY \r\n  `year`, \r\n  story DESC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1092,'年度排行-项目集-完成需求规模榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"program\",\"name\":\"项目集\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"story\",\"agg\":\"value\",\"name\":\"完成需求规模\",\"valOrAgg\":\"value\"}]}','',NULL,'SELECT \r\n  YEAR(t3.closedDate) AS `year`, \r\n  t1.id,\r\n  t1.name AS program, \r\n  ROUND(\r\n    SUM(t3.estimate), \r\n    2\r\n  ) AS story \r\nFROM \r\n  zt_project AS t1 \r\n  LEFT JOIN zt_product AS t2 ON t1.id = t2.program \r\n  AND t2.deleted = \'0\' \r\n  LEFT JOIN zt_story AS t3 ON t2.id = t3.product \r\n  AND t3.deleted = \'0\' \r\n  AND t3.closedReason = \'done\' \r\nWHERE \r\n  t1.deleted = \'0\' \r\n  AND t1.type = \'program\' \r\n  AND t1.grade = 1 \r\n  AND t3.id IS NOT NULL \r\nGROUP BY \r\n  `year`, \r\n  id,\r\n  program \r\nORDER BY \r\n  `year`, \r\n  story DESC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1093,'年度排行-项目集-修复Bug条目榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"program\",\"name\":\"项目集\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"bug\",\"agg\":\"value\",\"name\":\"修复Bug条目\",\"valOrAgg\":\"value\"}]}','','','SELECT \r\n  YEAR(t3.closedDate) AS `year`,\r\n  t1.id,  \r\n  t1.name AS program, \r\n  COUNT(1) AS bug \r\nFROM \r\n  zt_project AS t1 \r\n  LEFT JOIN zt_product AS t2 ON t1.id = t2.program \r\n  AND t2.deleted = \'0\' \r\n  LEFT JOIN zt_bug AS t3 ON t2.id = t3.product \r\n  AND t3.deleted = \'0\' \r\n  AND t3.resolution = \'fixed\' \r\n  AND t3.status = \'closed\' \r\nWHERE \r\n  t1.deleted = \'0\' \r\n  AND t1.type = \'program\' \r\n  AND t1.grade = 1 \r\n  AND t3.id IS NOT NULL \r\nGROUP BY \r\n  `year`, \r\n  id,\r\n  program \r\nORDER BY \r\n  `year`, \r\n  bug DESC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1094,'年度排行-项目-工期榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"name\",\"name\":\"项目\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"duration\",\"agg\":\"value\",\"name\":\"工期\",\"valOrAgg\":\"value\"}]}','',NULL,'SELECT `year`, id,name,status,realBegan,realEnd,IF(status = \'closed\', DATEDIFF(realEnd, realBegan), DATEDIFF(NOW(),realBegan)) as duration\r\nFROM (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) AS t1\r\nLEFT JOIN zt_project AS t2 ON 1 = 1 WHERE deleted = \'0\' AND type = \'project\' AND YEAR(realBegan) <= `year` AND LEFT(realBegan, 4) != \'0000\' AND (status =\'doing\' OR (status = \'suspended\' AND YEAR(suspendedDate) >= `year`) OR (status = \'closed\' AND YEAR(realEnd) >= `year`)) HAVING 1=1 ORDER BY `year`, duration desc',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1096,'年度排行-项目-工期偏差榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"name\",\"name\":\"项目\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"duration\",\"agg\":\"value\",\"name\":\"工期\",\"valOrAgg\":\"value\"}]}','',NULL,'SELECT `year`, id,name,status,`begin`,`end`,realBegan,realEnd,\nROUND((IF(LEFT(realEnd,4) != \'0000\', DATEDIFF(realEnd, realBegan), DATEDIFF(NOW(),realBegan)) - DATEDIFF(`end`, `begin`)) / DATEDIFF(`end`,`begin`) * 100) as duration\nFROM (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) AS t1\nLEFT JOIN zt_project AS t2 ON 1 = 1 \nWHERE deleted = \'0\' AND type = \'project\'\nAND YEAR(realBegan) <= `year` AND LEFT(realBegan, 4) != \'0000\'\nAND (YEAR(realEnd) >= `year` OR LEFT(realEnd, 4) = \'0000\') AND YEAR(`end`) != \'2059\'\nHAVING 1=1\nORDER BY duration ASC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1097,'年度排行-项目-人员投入榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"name\",\"name\":\"项目\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"number\",\"agg\":\"value\",\"name\":\"人数\",\"valOrAgg\":\"value\"}]}','',NULL,'SELECT tt.join as `year`, count(1) as number, tt.name from (\r\nselect \r\nt2.name, YEAR(t1.join) as `join`\r\nfrom zt_team t1 \r\nRIGHT JOIN zt_project t2 on t2.id = t1.root\r\nRIGHT JOIN zt_user t3 on t3.account = t1.account\r\nWHERE t1.type = \'project\'\r\n) tt\r\nGROUP BY tt.`name`, tt.join\r\nORDER BY tt.join, number desc, tt.name',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1098,'年度排行-项目-工时消耗榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"project\",\"name\":\"项目\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"consumed\",\"agg\":\"value\",\"name\":\"消耗工时\",\"valOrAgg\":\"value\"}]}','',NULL,'SELECT \r\n  YEAR(t4.date) AS `year`,\r\n  t1.id,  \r\n  t1.name AS project, \r\n  ROUND(\r\n    SUM(t4.consumed), \r\n    2\r\n  ) AS consumed \r\nFROM \r\n  zt_project AS t1 \r\n  LEFT JOIN zt_project AS t2 ON t1.id = t2.parent \r\n  AND t2.deleted = \'0\' \r\n  AND t2.type IN (\'sprint\', \'stage\', \'kanban\') \r\n  LEFT JOIN zt_task AS t3 ON t2.id = t3.execution \r\n  AND t3.deleted = \'0\' \r\n  AND t3.status != \'cancel\' \r\n  LEFT JOIN zt_effort AS t4 ON t3.id = t4.objectID \r\n  AND t4.deleted = \'0\' \r\n  AND t4.objectType = \'task\' \r\nWHERE \r\n  t1.deleted = \'0\' \r\n  AND t1.type = \'project\' \r\n  AND t4.id IS NOT NULL \r\nGROUP BY \r\n  `year`, \r\n  id,\r\n  project \r\nORDER BY \r\n  `year`, \r\n  consumed DESC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1099,'年度排行-项目-完成需求条目榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"project\",\"name\":\"项目\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"story\",\"agg\":\"value\",\"name\":\"完成需求条目\",\"valOrAgg\":\"value\"}]}','',NULL,'SELECT \r\n  YEAR(t1.closedDate) AS `year`, \r\n  t1.id, \r\n  t1.project, \r\n  COUNT(1) AS story \r\nFROM \r\n  (\r\n    SELECT \r\n      DISTINCT t1.id, \r\n      t1.name AS project, \r\n      t4.id AS story, \r\n      t4.closedDate \r\n    FROM \r\n      zt_project AS t1 \r\n      LEFT JOIN zt_project AS t2 ON t1.id = t2.parent \r\n      AND t2.deleted = \'0\' \r\n      AND t2.type IN (\'sprint\', \'stage\', \'kanban\') \r\n      LEFT JOIN zt_projectstory AS t3 ON t2.id = t3.project \r\n      LEFT JOIN zt_story AS t4 ON t3.story = t4.id \r\n      AND t4.deleted = \'0\' \r\n      AND t4.closedReason = \'done\' \r\n    WHERE \r\n      t1.deleted = \'0\' \r\n      AND t1.type = \'project\' \r\n      AND t4.id IS NOT NULL\r\n  ) AS t1 \r\nGROUP BY \r\n  `year`, \r\n  id, \r\n  project \r\nORDER BY \r\n  `year`, \r\n  story DESC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1100,'年度排行-项目-完成需求规模榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"project\",\"name\":\"项目\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"story\",\"agg\":\"value\",\"name\":\"完成需求规模\",\"valOrAgg\":\"value\"}]}','',NULL,'SELECT \r\n  YEAR(t1.closedDate) AS `year`, \r\n  t1.id, \r\n  t1.project, \r\n  ROUND(\r\n    SUM(t1.estimate), \r\n    2\r\n  ) AS story \r\nFROM \r\n  (\r\n    SELECT \r\n      DISTINCT t1.id, \r\n      t1.name AS project, \r\n      t4.id AS story, \r\n      t4.estimate, \r\n      t4.closedDate \r\n    FROM \r\n      zt_project AS t1 \r\n      LEFT JOIN zt_project AS t2 ON t1.id = t2.parent \r\n      AND t2.deleted = \'0\' \r\n      AND t2.type IN (\'sprint\', \'stage\', \'kanban\') \r\n      LEFT JOIN zt_projectstory AS t3 ON t2.id = t3.project \r\n      LEFT JOIN zt_story AS t4 ON t3.story = t4.id \r\n      AND t4.deleted = \'0\' \r\n      AND t4.closedReason = \'done\' \r\n    WHERE \r\n      t1.deleted = \'0\' \r\n      AND t1.type = \'project\' \r\n      AND t4.id IS NOT NULL\r\n  ) AS t1 \r\nGROUP BY \r\n  `year`, \r\n  id, \r\n  project \r\nORDER BY \r\n  `year`, \r\n  story DESC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1101,'年度排行-产品-新增需求条目榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"product\",\"name\":\"产品\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"story\",\"agg\":\"value\",\"name\":\"新增需求条目\",\"valOrAgg\":\"value\"}]}','',NULL,'SELECT YEAR(t2.openedDate) AS `year`, t1.id,  t1.name AS product, COUNT(1) AS story\r\nFROM zt_product AS t1\r\nLEFT JOIN zt_story AS t2 ON t1.id = t2.product AND t2.deleted = \'0\'\r\nWHERE t1.deleted = \'0\' AND t1.shadow = \'0\' AND t1.vision = \'rnd\' AND t2.id IS NOT NULL\r\nGROUP BY `year`, id, product\r\nORDER BY `year`, story DESC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1102,'年度排行-产品-完成需求规模榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"product\",\"name\":\"产品\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"story\",\"agg\":\"value\",\"name\":\"完成需求规模\",\"valOrAgg\":\"value\"}]}','',NULL,'SELECT YEAR(t2.closedDate) AS `year`, t1.id, t1.name AS product, ROUND(SUM(t2.estimate), 1) AS story\r\nFROM zt_product AS t1\r\nLEFT JOIN zt_story AS t2 ON t1.id = t2.product AND t2.deleted = \'0\' AND t2.closedReason = \'done\'\r\nWHERE t1.deleted = \'0\' AND t1.shadow = \'0\' AND t1.vision = \'rnd\' AND t2.id IS NOT NULL\r\nGROUP BY `year`, id, product\r\nORDER BY `year`, story DESC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1103,'年度排行-产品-新增Bug条目榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"product\",\"name\":\"产品\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"bug\",\"agg\":\"value\",\"name\":\"新增Bug条目\",\"valOrAgg\":\"value\"}]}','',NULL,'SELECT YEAR(t2.openedDate) AS `year`, t1.id,  t1.name AS product, COUNT(1) AS bug\r\nFROM zt_product AS t1\r\nLEFT JOIN zt_bug AS t2 ON t1.id = t2.product AND t2.deleted = \'0\'\r\nWHERE t1.deleted = \'0\' AND t1.shadow = \'0\' AND t1.vision = \'rnd\' AND t2.id IS NOT NULL\r\nGROUP BY `year`, id, product\r\nORDER BY `year`, bug DESC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1104,'年度排行-产品-修复Bug条目榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"product\",\"name\":\"产品\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"bug\",\"agg\":\"value\",\"name\":\"修复Bug条目\",\"valOrAgg\":\"value\"}]}','',NULL,'SELECT YEAR(t2.closedDate) AS `year`, t1.id, t1.name AS product, COUNT(1) AS bug\r\nFROM zt_product AS t1\r\nLEFT JOIN zt_bug AS t2 ON t1.id = t2.product AND t2.deleted = \'0\' AND t2.resolution = \'fixed\' AND t2.status = \'closed\'\r\nWHERE t1.deleted = \'0\' AND t1.shadow = \'0\' AND t1.vision = \'rnd\' AND t2.id IS NOT NULL\r\nGROUP BY `year`, id, product\r\nORDER BY `year`, bug DESC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1105,'年度排行-个人-创建需求条目榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"realname\",\"name\":\"用户\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"count\",\"agg\":\"value\",\"name\":\"创建需求条目\",\"valOrAgg\":\"value\"}]}','',NULL,'SELECT \r\nYEAR(t3.openedDate) AS `year`,t2.realname,count(1) AS count\r\nFROM zt_action AS t1 RIGHT JOIN zt_user AS t2 ON t1.actor=t2.account LEFT JOIN zt_story AS t3 ON t1.objectID=t3.id\r\nWHERE t1.objectType=\'story\' AND t1.action=\'opened\' AND t3.deleted=\'0\'\r\nGROUP BY `year`,t2.account ORDER BY `year`,count DESC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1106,'年度排行-个人-创建用例条目榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"realname\",\"name\":\"用户\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"count\",\"agg\":\"value\",\"name\":\"创建需用例条目\",\"valOrAgg\":\"value\"}]}','','','SELECT \nYEAR(t3.openedDate) AS `year`,t2.realname,count(1) AS count\nFROM zt_action AS t1 RIGHT JOIN zt_user AS t2 ON t1.actor=t2.account LEFT JOIN zt_case AS t3 ON t1.objectID=t3.id\nWHERE t1.objectType=\'case\' AND t1.action=\'opened\' AND t3.deleted=\'0\'\nGROUP BY `year`,t2.account ORDER BY `year`,count DESC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1107,'年度排行-个人-创建Bug条目榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"realname\",\"name\":\"用户\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"count\",\"agg\":\"value\",\"name\":\"创建Bug条目\",\"valOrAgg\":\"value\"}]}','',NULL,'SELECT \nYEAR(t3.openedDate) AS `year`,t2.realname,count(1) AS count\nFROM zt_action AS t1 RIGHT JOIN zt_user AS t2 ON t1.actor=t2.account LEFT JOIN zt_bug AS t3 ON t1.objectID=t3.id\nWHERE t1.objectType=\'bug\' AND t1.action=\'opened\' AND t3.deleted=\'0\'\nGROUP BY `year`,t2.account ORDER BY `year`,count DESC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1108,'年度排行-个人-修复Bug条目榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"realname\",\"name\":\"用户\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"count\",\"agg\":\"value\",\"name\":\"修复Bug条目\",\"valOrAgg\":\"value\"}]}','',NULL,'SELECT \r\nYEAR(t3.openedDate) AS `year`,t2.realname,count(DISTINCT t3.id) AS count\r\nFROM zt_action AS t1 RIGHT JOIN zt_user AS t2 ON t1.actor=t2.account LEFT JOIN zt_bug AS t3 ON t1.objectID=t3.id\r\nWHERE t1.objectType=\'bug\' AND t1.action=\'resolved\' AND t3.deleted=\'0\'\r\nGROUP BY `year`,t2.account ORDER BY `year`,count DESC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1109,'年度排行-个人-工时消耗榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"realname\",\"name\":\"用户\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"consumed\",\"agg\":\"value\",\"name\":\"消耗工时\",\"valOrAgg\":\"value\"}]}','',NULL,'SELECT YEAR(t1.date) AS `year`, t2.realname, ROUND(SUM(t1.consumed),1) AS consumed\nFROM zt_effort AS t1 LEFT JOIN zt_user AS t2 ON t1.account = t2.account\nWHERE t1.deleted = \'0\' AND t2.deleted = \'0\'\nGROUP BY `year`, realname\nORDER BY `year`, consumed DESC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1110,'年度排行-个人-禅道操作次数榜',1,'bar',0,'','','{\"xaxis\":[{\"field\":\"realname\",\"name\":\"用户\"}],\"yaxis\":[{\"type\":\"value\",\"field\":\"count\",\"agg\":\"value\",\"name\":\"操作次数\",\"valOrAgg\":\"value\"}]}','',NULL,'SELECT YEAR(t1.date) AS `year`,IFNULL(t2.realname,t1.actor) AS realname,count(1) AS count\r\nFROM zt_action t1 LEFT JOIN zt_user AS t2 ON t1.actor=t2.account\r\nGROUP BY `year`,t1.actor\r\nORDER BY `year`, `count` DESC',1,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0);

REPLACE INTO `zt_screen` (`id`, `dimension`, `name`, `desc`, `cover`, `scheme`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES
(1,	1,	'宏观数据盘点大屏',	'从宏观的角度快速的了解公司的现状',	'static/images/screen1.png',	'[\n    {\n        \"id\": \"5scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 120, \"x\": 0, \"y\": 0, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 1300, \"h\": 120, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/screen_header.png\", \"borderRadius\": 10 }\n            },\n            {\n                \"id\": \"2nws38440fq000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 360, \"y\": 36, \"w\": 500, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"公司数据盘点大屏\", \"fontSize\": 20, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1cfwp95aiif400\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 0, \"y\": 171, \"w\": 1000, \"h\": 480, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 800, \"h\": 120, \"x\": 0, \"y\": 175, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"公司级数据概览\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 165, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 165, \"y\": 28, \"w\": 800, \"h\": 10, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 25, \"y\": 246, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"一级项目集个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1018,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"一级项目集个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"一级项目集个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"一级项目集个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 155, \"y\": 246, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1019,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"项目个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"项目个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"项目个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 285, \"y\": 246, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"产品个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1020,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"产品个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"产品个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"产品个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 25, \"y\": 346, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"计划个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1021,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"计划个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"计划个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"计划个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 155, \"y\": 346, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"执行个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1022,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"执行个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"执行个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"执行个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 285, \"y\": 346, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"发布个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1023,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"发布个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"发布个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"发布个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 25, \"y\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"需求个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1024,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"需求个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"需求个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"需求个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 155, \"y\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"任务个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1025,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"任务个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"任务个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"任务个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 285, \"y\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"缺陷个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1026,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"缺陷个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"缺陷个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"缺陷个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 25, \"y\": 546, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"文档个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1027,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"文档个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"文档个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"文档个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 155, \"y\": 546, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"现有人员个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1028,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"现有人员个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"现有人员个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"现有人员个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 285, \"y\": 546, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"累计消耗工时\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1029,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"累计消耗工时\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"累计消耗工时\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"累计消耗工时\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"3v5jz5hzz0c000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 211, \"h\": 150, \"x\": 500, \"y\": 180, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"使用时长\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1hxm2jtfh3y800\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 380, \"h\": 150, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"使用时长边框\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#6586ec00\", \"#2cf7fe00\" ], \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"3aekp6a7tag000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 60, \"y\": 25, \"w\": 200, \"h\": 150, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"使用时长\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"禅道使用时长：\", \"fontSize\": 19, \"fontColor\": \"#9abdcd\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"right\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"4u5rgs0pf34000\",\n                \"sourceID\": 1030,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 265, \"y\": 25, \"w\": 252, \"h\": 150, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"时长\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"\", \"fontSize\": 19, \"fontColor\": \"#9abdcd\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"fc4u6zmi58w00\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 963, \"y\": 186, \"w\": 20, \"h\": 20, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": 1 },\n        \"styles\": { \"filterShow\": false, \"hueRotate\": 0, \"saturate\": 1, \"contrast\": 1, \"brightness\": 1, \"opacity\": 1, \"rotateZ\": 0, \"rotateX\": 0, \"rotateY\": 0, \"skewX\": 0, \"skewY\": 0, \"blendMode\": \"normal\", \"animations\": [] },\n        \"status\": { \"lock\": false, \"hide\": false },\n        \"request\": { \"requestDataType\": 0, \"requestHttpType\": \"get\", \"requestUrl\": \"\", \"requestInterval\": null, \"requestIntervalUnit\": \"second\", \"requestContentType\": 0, \"requestParamsBodyType\": \"none\", \"requestSQLContent\": { \"sql\": \"select * from  where\" }, \"requestParams\": { \"Body\": { \"form-data\": {}, \"x-www-form-urlencoded\": {}, \"json\": \"\", \"xml\": \"\" }, \"Header\": {}, \"Params\": {} } },\n        \"filter\": null,\n        \"events\": { \"baseEvent\": { \"click\": null, \"dblclick\": null, \"mouseenter\": null, \"mouseleave\": null }, \"advancedEvents\": { \"vnodeMounted\": null, \"vnodeBeforeMount\": null } },\n        \"key\": \"Hint\",\n        \"chartConfig\": { \"key\": \"Hint\", \"chartKey\": \"VHint\", \"conKey\": \"VCHint\", \"title\": \"提示\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/hint-2cbf6381.png\" },\n        \"option\": { \"text\": \"\", \"icon\": \"\", \"textSize\": 15, \"textColor\": \"#ffffff\", \"textWeight\": \"bold\", \"placement\": \"left-top\", \"distance\": 8, \"hint\": \"需求完成率=关闭原因为已完成的需求个数/(关闭原因为已完成的需求个数+未关闭的需求个数)；\\nBug修复率=方案为已解决且状态为已关闭的Bug数/(方案为已解决的Bug数+方案为延期处理的Bug数+激活的Bug数)。\", \"width\": 0, \"height\": 0, \"paddingX\": 16, \"paddingY\": 8, \"borderWidth\": 1, \"borderStyle\": \"solid\", \"borderColor\": \"#1a77a5\", \"borderRadius\": 6, \"color\": \"#ffffff\", \"textAlign\": \"left\", \"fontWeight\": \"normal\", \"backgroundColor\": \"rgba(8, 40, 80, 0.9)\", \"fontSize\": 16 }\n    },\n    {\n        \"id\": \"17sqdjuu74ik00\",\n        \"sourceID\": 1031,\n        \"isGroup\": false,\n        \"attr\": { \"x\": 460, \"y\": 300, \"w\": 280, \"h\": 250, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"PieCircle\",\n        \"chartConfig\": { \"key\": \"PieCircle\", \"chartKey\": \"VPieCircle\", \"conKey\": \"VPieCircle\", \"title\": \"需求完成率\", \"category\": \"Pies\", \"categoryName\": \"饼图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/pie-circle-258fcce7.png\" },\n        \"option\": { \"legend\": { \"show\": true, \"top\": \"15%\", \"textStyle\": { \"color\": \"#B9B8CE\" } }, \"title\": {\"text\": \"30.00%\", \"x\": \"center\", \"y\": \"center\", \"textStyle\": {\"color\": \"#FFF\",\"fontSize\": 20}}, \"type\": \"nomal\", \"tooltip\": { \"show\": true, \"trigger\": \"item\", \"formatter\": \"{d}%\" }, \"dataset\": 0.25, \"series\": [ { \"type\": \"pie\", \"radius\": [ \"63%\", \"70%\" ], \"label\": { \"show\": false }, \"center\": [ \"50%\", \"50%\" ], \"data\": [ { \"value\": [ 30 ], \"itemStyle\": { \"color\": \"#03a9f4\", \"shadowBlur\": 10, \"shadowColor\": \"#97e2f5\" } }, { \"value\": [ 70 ], \"itemStyle\": { \"color\": \"#00bcd44a\", \"shadowBlur\": 0, \"shadowColor\": \"#00bcd44a\" } } ]} ] }\n    },\n    {\n        \"id\": \"4u5rgs0pf34000\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 475, \"y\": 535, \"w\": 250, \"h\": 50, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"TextCommon\",\n        \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"时长\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n        \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"需求完成率\", \"fontSize\": 15, \"fontColor\": \"#c6d3d9\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n    },\n    {\n        \"id\": \"4xgico362ww000\",\n        \"sourceID\": 1032,\n        \"isGroup\": false,\n        \"attr\": { \"x\": 720, \"y\": 300, \"w\": 280, \"h\": 250, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"PieCircle\",\n        \"chartConfig\": { \"key\": \"PieCircle\", \"chartKey\": \"VPieCircle\", \"conKey\": \"VPieCircle\", \"title\": \"Bug修复率\", \"category\": \"Pies\", \"categoryName\": \"饼图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/pie-circle-258fcce7.png\" },\n        \"option\": { \"legend\": { \"show\": true, \"top\": \"15%\", \"textStyle\": { \"color\": \"#B9B8CE\" } }, \"title\": {\"text\": \"30.00%\", \"x\": \"center\", \"y\": \"center\", \"textStyle\": {\"color\": \"#FFF\",\"fontSize\": 20}}, \"type\": \"nomal\", \"tooltip\": { \"show\": true, \"trigger\": \"item\", \"formatter\": \"{d}%\" }, \"dataset\": 0.25, \"series\": [ { \"type\": \"pie\", \"radius\": [ \"63%\", \"70%\" ], \"label\": { \"show\": false }, \"center\": [ \"50%\", \"50%\" ], \"data\": [ { \"value\": [ 30 ], \"itemStyle\": { \"color\": \"#C29160\", \"shadowBlur\": 10, \"shadowColor\": \"#eed045\" } }, { \"value\": [ 70 ], \"itemStyle\": { \"color\": \"#00bcd44a\", \"shadowBlur\": 0, \"shadowColor\": \"#00bcd44a\" } } ]} ] }\n    },\n    {\n        \"id\": \"4u5rgs0pf34000\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 735, \"y\": 535, \"w\": 250, \"h\": 50, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"TextCommon\",\n        \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"时长\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n        \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"Bug修复率\", \"fontSize\": 15, \"fontColor\": \"#c6d3d9\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n    },\n    {\n        \"id\": \"1cfwp95aiif400\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 1010, \"y\": 171, \"w\": 290, \"h\": 480, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 400, \"h\": 120, \"x\": 1010, \"y\": 175, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 400, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"公司级未完成数据概览\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 220, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 220, \"y\": 32, \"w\": 30, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 1035, \"y\": 246, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"一级项目集个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1033,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"一级项目集数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"一级项目集数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"一级项目集数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 1165, \"y\": 246, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1034,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"需求数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"需求数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"需求数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 1035, \"y\": 346, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"产品数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1035,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"产品数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"产品数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"产品数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 1165, \"y\": 346, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1036,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"项目数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"项目数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"项目数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 1035, \"y\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"计划数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1037,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"计划数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"计划数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"计划数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 1165, \"y\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"执行个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1038,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"执行数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"执行数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"执行数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 1035, \"y\": 546, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"Bug数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1039,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"Bug数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"Bug数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"Bug数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 1165, \"y\": 546, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"任务个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1040,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"任务数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"任务数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"任务数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"fc4u6zmi58w00\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 1260, \"y\": 186, \"w\": 20, \"h\": 20, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": 1 },\n        \"styles\": { \"filterShow\": false, \"hueRotate\": 0, \"saturate\": 1, \"contrast\": 1, \"brightness\": 1, \"opacity\": 1, \"rotateZ\": 0, \"rotateX\": 0, \"rotateY\": 0, \"skewX\": 0, \"skewY\": 0, \"blendMode\": \"normal\", \"animations\": [] },\n        \"status\": { \"lock\": false, \"hide\": false },\n        \"request\": { \"requestDataType\": 0, \"requestHttpType\": \"get\", \"requestUrl\": \"\", \"requestInterval\": null, \"requestIntervalUnit\": \"second\", \"requestContentType\": 0, \"requestParamsBodyType\": \"none\", \"requestSQLContent\": { \"sql\": \"select * from  where\" }, \"requestParams\": { \"Body\": { \"form-data\": {}, \"x-www-form-urlencoded\": {}, \"json\": \"\", \"xml\": \"\" }, \"Header\": {}, \"Params\": {} } },\n        \"filter\": null,\n        \"events\": { \"baseEvent\": { \"click\": null, \"dblclick\": null, \"mouseenter\": null, \"mouseleave\": null }, \"advancedEvents\": { \"vnodeMounted\": null, \"vnodeBeforeMount\": null } },\n        \"key\": \"Hint\",\n        \"chartConfig\": { \"key\": \"Hint\", \"chartKey\": \"VHint\", \"conKey\": \"VCHint\", \"title\": \"提示\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/hint-2cbf6381.png\" },\n        \"option\": { \"text\": \"\", \"icon\": \"\", \"textSize\": 15, \"textColor\": \"#ffffff\", \"textWeight\": \"bold\", \"placement\": \"left-top\", \"distance\": 8, \"hint\": \"未完成的一级项目集个数=未关闭的一级项目集个数；\\n未完成的需求个数=未关闭的需求个数；\\n未完成的产品个数=未关闭的产品个数；\\n未完成的项目个数=未关闭的项目个数；\\n未完成的计划个数=未完成的计划个数；\\n未完成的执行个数=未关闭的执行个数；\\n未完成的任务个数=未完成的任务个数；\\n未完成的Bug个数=未关闭的Bug个数。\", \"width\": 0, \"height\": 0, \"paddingX\": 16, \"paddingY\": 8, \"borderWidth\": 1, \"borderStyle\": \"solid\", \"borderColor\": \"#1a77a5\", \"borderRadius\": 6, \"color\": \"#ffffff\", \"textAlign\": \"left\", \"fontWeight\": \"normal\", \"backgroundColor\": \"rgba(8, 40, 80, 0.9)\", \"fontSize\": 16 }\n    },\n    {\n        \"id\": \"1cfwp95aiif400\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 0, \"y\": 665, \"w\": 1300, \"h\": 525, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 120, \"x\": 0, \"y\": 665, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"项目集数据概览\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 165, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 185, \"y\": 28, \"w\": 1090, \"h\": 10, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"1zhfrmecpnxc00\",\n                \"sourceID\": 1041,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 25, \"y\": 57, \"w\": 1250, \"h\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TableScrollBoard\",\n                \"chartConfig\": { \"key\": \"TableScrollBoard\", \"chartKey\": \"VTableScrollBoard\", \"conKey\": \"VCTableScrollBoard\", \"title\": \"轮播列表\", \"category\": \"Tables\", \"categoryName\": \"表格\", \"package\": \"Tables\", \"chartFrame\": \"common\", \"image\": \"static/png/table_scrollboard-fb642e78.png\" },\n                \"option\": { \"header\": [ \"列1\", \"列2\", \"列3\" ], \"dataset\": [ [ \"行1列1\", \"行1列2\", \"行1列3\" ], [ \"行2列1\", \"行2列2\", \"行2列3\" ], [ \"行3列1\", \"行3列2\", \"行3列3\" ], [ \"行4列1\", \"行4列2\", \"行4列3\" ], [ \"行5列1\", \"行5列2\", \"行5列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ] ], \"index\": false, \"columnWidth\": [], \"align\": [ \"center\", \"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"], \"rowNum\": 8, \"waitTime\": 3, \"headerHeight\": 45, \"carousel\": \"single\", \"headerBGC\": \"#165896FF\", \"oddRowBGC\": \"#042b4dFF\", \"evenRowBGC\": \"#0a1c37FF\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 0, \"y\": 1200, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1dlpgwe8wwe800\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1042,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 60, \"w\": 380, \"h\": 416, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": true,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}%\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}%\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } }, { \"type\": \"bar\", \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[2]}%\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 5,\n                        \"maxValueSpan\": 5,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"handleIcon\": \"path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5M36.9,35.8h-1.3z M27.8,35.8 h-1.3H27L27.8,35.8L27.8,35.8z\",\n                        \"handleSize\": \"100%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"borderCap\": \"round\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            },\n            {\n                \"id\": \"2u3zlsz5kk4000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 22, \"w\": 378, \"h\": 50, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"项目集需求完成率与Bug修复率\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1xih6tzmmssg00\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 437, \"y\": 1200, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"公司一级项目集状态分布\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2bnelf1diy8000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"公司一级项目集状态分布\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"1351cy224nb400\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 25, \"w\": 426, \"h\": 45, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"公司一级项目集状态分布\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"公司一级项目集状态分布\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"4ocyn7hip9k000\",\n                \"sourceID\": 1043,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 10, \"y\": 50, \"w\": 400, \"h\": 410, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"PieCommon\",\n                \"chartConfig\": { \"key\": \"PieCommon\", \"chartKey\": \"VPieCommon\", \"conKey\": \"VCPieCommon\", \"title\": \"饼图\", \"category\": \"Pies\", \"categoryName\": \"饼图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/pie-9620f191.png\" },\n                \"option\": { \"legend\": { \"show\": true, \"top\": \"5%\", \"textStyle\": { \"color\": \"#B9B8CE\" } }, \"type\": \"nomal\", \"tooltip\": { \"show\": true, \"trigger\": \"item\" }, \"dataset\": { \"dimensions\": [ \"product\", \"data1\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120 }, { \"product\": \"Tue\", \"data1\": 200 }, { \"product\": \"Wed\", \"data1\": 150 }, { \"product\": \"Thu\", \"data1\": 80 }, { \"product\": \"Fri\", \"data1\": 70 }, { \"product\": \"Sat\", \"data1\": 110 }, { \"product\": \"Sun\", \"data1\": 130 } ] }, \"series\": [ { \"type\": \"pie\", \"radius\": [ \"30%\", \"30%\" ], \"label\": { \"show\": true, \"width\": 120, \"formatter\": \"{b}\\n{d}%\", \"lineHeight\": 20, \"color\": \"#ffffff\", \"position\": \"outside\", \"position\": \"outside\", \"alignTo\": \"edge\", \"margin\": 5 }, \"center\": [ \"50%\", \"55%\" ], \"roseType\": false , \"emphasis\": { \"itemStyle\": { \"shadowBlur\": 20, \"shadowOffsetX\": 2, \"shadowColor\": \"rgba(0, 0, 0, 0)\" } }} ] }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"2js0ncv6kpc000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 865, \"x\": 874, \"y\": 1200, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"公司项目状态分布\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"4d4pumofn5g000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"公司项目状态分布\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"50qj95gt8fs000\",\n                \"sourceID\": 1044,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 10, \"y\": 60, \"w\": 400, \"h\": 400, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"PieCommon\",\n                \"chartConfig\": { \"key\": \"PieCommon\", \"chartKey\": \"VPieCommon\", \"conKey\": \"VCPieCommon\", \"title\": \"饼图\", \"category\": \"Pies\", \"categoryName\": \"饼图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/pie-9620f191.png\" },\n                \"option\": { \"legend\": { \"show\": true, \"top\": \"5%\", \"textStyle\": { \"color\": \"#B9B8CE\" } }, \"type\": \"nomal\", \"tooltip\": { \"show\": true, \"trigger\": \"item\" }, \"dataset\": { \"dimensions\": [ \"product\", \"data1\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120 }, { \"product\": \"Tue\", \"data1\": 200 }, { \"product\": \"Wed\", \"data1\": 150 }, { \"product\": \"Thu\", \"data1\": 80 }, { \"product\": \"Fri\", \"data1\": 70 }, { \"product\": \"Sat\", \"data1\": 110 }, { \"product\": \"Sun\", \"data1\": 130 } ] }, \"series\": [ { \"type\": \"pie\", \"radius\": [ \"30%\", \"30%\" ], \"label\": { \"show\": true, \"width\": 120, \"formatter\": \"{b}\\n{d}%\", \"lineHeight\": 20, \"color\": \"#ffffff\", \"position\": \"outside\", \"position\": \"outside\", \"alignTo\": \"edge\", \"margin\": 5 }, \"center\": [ \"50%\", \"55%\" ], \"roseType\": false , \"emphasis\": { \"itemStyle\": { \"shadowBlur\": 20, \"shadowOffsetX\": 2, \"shadowColor\": \"rgba(0, 0, 0, 0)\" } }} ] }\n            },\n            {\"id\": \"36zg35ree9q000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 400, \"h\": 85, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"公司项目状态分布\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"公司项目状态分布\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1cfwp95aiif400\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 0, \"y\": 1710, \"w\": 1300, \"h\": 525, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"vwvqtuc6lyo00\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 120, \"x\": 0, \"y\": 1710, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"5l0cps9x0z0000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"产品数据概览\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"3ajkrqyykr8000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 150, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"2z65lmxl328000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 170, \"y\": 28, \"w\": 1105, \"h\": 10, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"1zhfrmecpnxc00\",\n                \"sourceID\": 1045,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 25, \"y\": 57, \"w\": 1250, \"h\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TableScrollBoard\",\n                \"chartConfig\": { \"key\": \"TableScrollBoard\", \"chartKey\": \"VTableScrollBoard\", \"conKey\": \"VCTableScrollBoard\", \"title\": \"轮播列表\", \"category\": \"Tables\", \"categoryName\": \"表格\", \"package\": \"Tables\", \"chartFrame\": \"common\", \"image\": \"static/png/table_scrollboard-fb642e78.png\" },\n                \"option\": { \"header\": [ \"列1\", \"列2\", \"列3\" ], \"dataset\": [ [ \"行1列1\", \"行1列2\", \"行1列3\" ], [ \"行2列1\", \"行2列2\", \"行2列3\" ], [ \"行3列1\", \"行3列2\", \"行3列3\" ], [ \"行4列1\", \"行4列2\", \"行4列3\" ], [ \"行5列1\", \"行5列2\", \"行5列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ] ], \"index\": false, \"columnWidth\": [], \"align\": [ \"center\", \"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"], \"rowNum\": 8, \"waitTime\": 3, \"headerHeight\": 45, \"carousel\": \"single\", \"headerBGC\": \"#165896FF\", \"oddRowBGC\": \"#042b4dFF\", \"evenRowBGC\": \"#0a1c37FF\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"sl2d95i1hz400\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 640, \"h\": 500, \"x\": 0, \"y\": 2250, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"产品需求完成率\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57zre1am96c000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 640, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"产品需求完成率\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"42ae8w3dgeg000\",\n                \"sourceID\": 1046,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 60, \"w\": 530, \"h\": 416, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}%\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"15%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"item\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}%\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 6,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 6,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"handleIcon\": \"path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5M36.9,35.8h-1.3z M27.8,35.8 h-1.3H27L27.8,35.8L27.8,35.8z\",\n                        \"handleSize\": \"100%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"borderCap\": \"round\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n\n                }\n            },\n            {\n                \"id\": \"579jc04cfps000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 90, \"y\": 0, \"w\": 500, \"h\": 100, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"产品需求完成率\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"产品需求完成率\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"nr1mfqoyuwg00\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 645, \"h\": 500, \"x\": 655, \"y\": 2250, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2ta7xcd152i000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 645, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"产品Bug修复率\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"4o7ep6z91ii000\",\n                \"sourceID\": 1047,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 60, \"w\": 540, \"h\": 416, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}%\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"15%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}%\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 6,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 6,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"handleIcon\": \"path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5M36.9,35.8h-1.3z M27.8,35.8 h-1.3H27L27.8,35.8L27.8,35.8z\",\n                        \"handleSize\": \"100%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"borderCap\": \"round\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n\n                }\n            },\n            {\n                \"id\": \"4vcyxy305n6000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 90, \"y\": 0, \"w\": 500, \"h\": 100, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"产品Bug修复率\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"产品Bug修复率\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"45ao1xz9kzu000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 0, \"y\": 2770, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"部门人员分布图\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1ncdmrlvzjy800\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"部门人员分布图\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"v3d9spa59dc00\",\n                \"sourceID\": 1049,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 20, \"y\": 50, \"w\": 380, \"h\": 426, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"15%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 6,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"handleIcon\": \"path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5M36.9,35.8h-1.3z M27.8,35.8 h-1.3H27L27.8,35.8L27.8,35.8z\",\n                        \"handleSize\": \"100%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"borderCap\": \"round\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n\n                }\n            },\n            {\n                \"id\": \"wam6ydb8zqo00\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 378, \"h\": 100, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"部门人员分布图\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"部门人员分布图\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"2dg0t90atgg000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 437, \"y\": 2770, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"公司角色分布图\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"53ynqk2kzh8000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"公司角色分布图\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"1knkjcb65rwg00\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 25, \"w\": 426, \"h\": 45, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"公司角色分布图\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"公司角色分布图\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"mblj8ow100000\",\n                \"sourceID\": 1050,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 20, \"y\": 60, \"w\": 400, \"h\": 420, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"PieCommon\",\n                \"chartConfig\": { \"key\": \"PieCommon\", \"chartKey\": \"VPieCommon\", \"conKey\": \"VCPieCommon\", \"title\": \"需求完成率\", \"category\": \"Pies\", \"categoryName\": \"饼图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/pie-9620f191.png\" },\n                \"option\": { \"legend\": { \"show\": true, \"top\": \"0%\", \"textStyle\": { \"color\": \"#B9B8CE\" } }, \"type\": \"nomal\", \"tooltip\": { \"show\": true, \"trigger\": \"item\" }, \"dataset\": { \"dimensions\": [ \"product\", \"data1\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120 }, { \"product\": \"Tue\", \"data1\": 200 }, { \"product\": \"Wed\", \"data1\": 150 }, { \"product\": \"Thu\", \"data1\": 80 }, { \"product\": \"Fri\", \"data1\": 70 }, { \"product\": \"Sat\", \"data1\": 110 }, { \"product\": \"Sun\", \"data1\": 130 } ] }, \"series\": [ { \"type\": \"pie\", \"radius\": [ \"40%\", \"40%\" ], \"label\": { \"show\": true, \"width\": 120, \"formatter\": \"{b}\\n{d}%\", \"lineHeight\": 20, \"color\": \"#ffffff\", \"position\": \"outside\", \"alignTo\": \"edge\", \"margin\": 5 }, \"center\": [ \"50%\", \"65%\" ], \"roseType\": false , \"emphasis\": { \"itemStyle\": { \"shadowBlur\": 20, \"shadowOffsetX\": 2, \"shadowColor\": \"rgba(0, 0, 0, 0)\" } }} ] }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1j55da3c41vk00\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 874, \"y\": 2770, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"人员工龄分布图\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1xqnm37nva8w00\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"人员工龄分布图\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"5ll028fasrw000\",\n                \"sourceID\": 1051,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 20, \"y\": 50, \"w\": 380, \"h\": 426, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": { \"legend\": { \"show\": false, \"top\": \"5%\", \"textStyle\": { \"color\": \"#B9B8CE\" } }, \"xAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": false, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0 }, \"position\": \"bottom\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"value\" }, \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0 }, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" }, \"grid\": { \"show\": false, \"left\": \"20%\", \"top\": \"60\", \"right\": \"10%\", \"bottom\": \"60\" }, \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } }, \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] }, \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ], \"backgroundColor\": \"rgba(0,0,0,0)\" }\n            },\n            {\n                \"id\": \"4887ix47ule000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 378, \"h\": 100, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"人员工龄分布图\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"人员工龄分布图\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    }\n]\n',	'admin',	'2022-11-18 10:46:18',	'admin',	'2022-11-18 10:46:18',	'0'),
(2,	1,	'公司年度汇总数据大屏',	'从不同的年份了解公司汇总数据的情况',	'static/images/screen2.png',	'[\n    {\n        \"id\": \"5scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 120, \"x\": 0, \"y\": 0, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 1300, \"h\": 120, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/screen_header.png\", \"borderRadius\": 10 }\n            },\n            {\n                \"id\": \"2nws38440fq000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 360, \"y\": 36, \"w\": 500, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \" 公司年度汇总数据大屏\", \"fontSize\": 20, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"5scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 300, \"h\": 120, \"x\": 0, \"y\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"type\": \"year\",\n                \"filterCharts\": [\n                    {\"chart\": 1055, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1056, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1057, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1058, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1059, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1060, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1061, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1062, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1063, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1064, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1065, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1066, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1067, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1068, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1069, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1070, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1071, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1072, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1073, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1074, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1075, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1076, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1077, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1078, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1079, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1080, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1081, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1082, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1083, \"field\": \"t1.`year`\"}\n                ],\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 120, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Select\",\n                \"chartConfig\": { \"key\": \"Select\", \"chartKey\": \"VSelect\", \"conKey\": \"VCSelect\", \"title\": \"选择\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/select-c616737a.png\" },\n                \"option\": { \"dataset\": [ { \"label\": \"请选择\", \"value\": \"\" }, { \"label\": \"河北\", \"value\": \"18700\" }, { \"label\": \"徐州\", \"value\": \"17800\" } ], \"value\": \"\", \"borderWidth\": 1, \"borderStyle\": \"solid\", \"borderColor\": \"#1a77a5\", \"background\": \"none\", \"borderRadius\": 6, \"color\": \"#ffffff\", \"textAlign\": \"center\", \"fontWeight\": \"normal\", \"backgroundColor\": \"transparent\", \"fontSize\": 20, \"onChange\": \"console.log(value)\"}\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1cfwp95aiif400\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 0, \"y\": 171, \"w\": 750, \"h\": 300, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 750, \"h\": 120, \"x\": 0, \"y\": 175, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 230, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"公司年度新增数据概览\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 230, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 250, \"y\": 28, \"w\": 470, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1cfwp95aiif400\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 770, \"y\": 171, \"w\": 530, \"h\": 300, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 820, \"h\": 120, \"x\": 770, \"y\": 175, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 230, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"公司年度完成数据概览\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 220, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 240, \"y\": 28, \"w\": 255, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 100, \"h\": 100, \"x\": 25, \"y\": 250, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"文档个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1055,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 100, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"一级项目集个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 100, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"一级项目集个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"一级项目集个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 100, \"h\": 100, \"x\": 145, \"y\": 250, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"文档个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1056,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 100, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"产品个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 100, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"产品个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"产品个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 100, \"h\": 100, \"x\": 265, \"y\": 250, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"文档个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1057,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 100, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"需求个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 100, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"需求个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"需求个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 100, \"h\": 100, \"x\": 385, \"y\": 250, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"文档个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1058,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 100, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"Bug个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 100, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"Bug个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"Bug个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 100, \"h\": 100, \"x\": 505, \"y\": 250, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"文档个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1059,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 100, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"计划个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 100, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"计划个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"计划个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 100, \"h\": 100, \"x\": 25, \"y\": 360, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"文档个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1060,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 100, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"项目个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 100, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"项目个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"项目个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 100, \"h\": 100, \"x\": 145, \"y\": 360, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"文档个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1061,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 100, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"执行个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 100, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"执行个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"执行个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 100, \"h\": 100, \"x\": 265, \"y\": 360, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"文档个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1062,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 100, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"任务个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 100, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"任务个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"任务个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 100, \"h\": 100, \"x\": 385, \"y\": 360, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"文档个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1063,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 100, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"发布个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 100, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"文档个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"文档个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 100, \"h\": 100, \"x\": 505, \"y\": 360, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"文档个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1064,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 100, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"发布个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 100, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"发布个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"发布个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 100, \"h\": 250, \"x\": 625, \"y\": 250, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"文档个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 190, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1065,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 60, \"w\": 100, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"用户个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 78, \"w\": 100, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"用户个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"用户个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 100, \"h\": 100, \"x\": 800, \"y\": 250, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"文档个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1066,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 100, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"完成项目数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 100, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"完成项目数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"完成项目数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 100, \"h\": 100, \"x\": 920, \"y\": 250, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"文档个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1067,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 100, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"完成执行数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 100, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"文档个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"完成执行数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 100, \"h\": 100, \"x\": 1040, \"y\": 250, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"文档个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1068,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 100, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"完成发布数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 100, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"完成发布数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"完成发布数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 100, \"h\": 100, \"x\": 800, \"y\": 360, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"文档个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1069,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 100, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"完成需求数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 100, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"完成需求数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"完成需求数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 100, \"h\": 100, \"x\": 920, \"y\": 360, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"文档个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1070,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 100, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"解决Bug数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 100, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"解决Bug数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"解决Bug数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 100, \"h\": 100, \"x\": 1040, \"y\": 360, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"文档个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1071,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 100, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"完成任务数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 100, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"完成任务数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"完成任务数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 100, \"h\": 200, \"x\": 1160, \"y\": 250, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"文档个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 190, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1072,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 54, \"w\": 100, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"投入工时数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 78, \"w\": 100, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"投入工时数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"投入工时数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"fc4u6zmi58w00\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 1260, \"y\": 186, \"w\": 20, \"h\": 20, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": 1 },\n        \"styles\": { \"filterShow\": false, \"hueRotate\": 0, \"saturate\": 1, \"contrast\": 1, \"brightness\": 1, \"opacity\": 1, \"rotateZ\": 0, \"rotateX\": 0, \"rotateY\": 0, \"skewX\": 0, \"skewY\": 0, \"blendMode\": \"normal\", \"animations\": [] },\n        \"status\": { \"lock\": false, \"hide\": false },\n        \"request\": { \"requestDataType\": 0, \"requestHttpType\": \"get\", \"requestUrl\": \"\", \"requestInterval\": null, \"requestIntervalUnit\": \"second\", \"requestContentType\": 0, \"requestParamsBodyType\": \"none\", \"requestSQLContent\": { \"sql\": \"select * from  where\" }, \"requestParams\": { \"Body\": { \"form-data\": {}, \"x-www-form-urlencoded\": {}, \"json\": \"\", \"xml\": \"\" }, \"Header\": {}, \"Params\": {} } },\n        \"filter\": null,\n        \"events\": { \"baseEvent\": { \"click\": null, \"dblclick\": null, \"mouseenter\": null, \"mouseleave\": null }, \"advancedEvents\": { \"vnodeMounted\": null, \"vnodeBeforeMount\": null } },\n        \"key\": \"Hint\",\n        \"chartConfig\": { \"key\": \"Hint\", \"chartKey\": \"VHint\", \"conKey\": \"VCHint\", \"title\": \"提示\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/hint-2cbf6381.png\" },\n        \"option\": { \"text\": \"\", \"icon\": \"\", \"textSize\": 15, \"textColor\": \"#ffffff\", \"textWeight\": \"bold\", \"placement\": \"left-top\", \"distance\": 8, \"hint\": \"完成的项目个数=已关闭的项目个数；\\n完成执行数=已关闭的执行数；\\n完成发布数=全部发布数；\\n完成的需求数=关闭原因为已完成的需求个数；\\n修复的Bug数=Bug状态为已关闭且解决方案为已解决的Bug个数；\\n完成的任务数=任务状态为已完成+关闭原因为已完成的任务数。\", \"width\": 0, \"height\": 0, \"paddingX\": 16, \"paddingY\": 8, \"borderWidth\": 1, \"borderStyle\": \"solid\", \"borderColor\": \"#1a77a5\", \"borderRadius\": 6, \"color\": \"#ffffff\", \"textAlign\": \"left\", \"fontWeight\": \"normal\", \"backgroundColor\": \"rgba(8, 40, 80, 0.9)\", \"fontSize\": 16 }\n    },\n    {\n        \"id\": \"1cfwp95aiif400\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 0, \"y\": 500, \"w\": 1300, \"h\": 525, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 120, \"x\": 0, \"y\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 277, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"项目集年度新增数据汇总表\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 250, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 270, \"y\": 28, \"w\": 1000, \"h\": 10, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"1zhfrmecpnxc00\",\n                \"sourceID\": 1073,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 25, \"y\": 57, \"w\": 1250, \"h\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TableScrollBoard\",\n                \"chartConfig\": { \"key\": \"TableScrollBoard\", \"chartKey\": \"VTableScrollBoard\", \"conKey\": \"VCTableScrollBoard\", \"title\": \"轮播列表\", \"category\": \"Tables\", \"categoryName\": \"表格\", \"package\": \"Tables\", \"chartFrame\": \"common\", \"image\": \"static/png/table_scrollboard-fb642e78.png\" },\n                \"option\": { \"header\": [ \"列1\", \"列2\", \"列3\" ], \"dataset\": [ [ \"行1列1\", \"行1列2\", \"行1列3\" ], [ \"行2列1\", \"行2列2\", \"行2列3\" ], [ \"行3列1\", \"行3列2\", \"行3列3\" ], [ \"行4列1\", \"行4列2\", \"行4列3\" ], [ \"行5列1\", \"行5列2\", \"行5列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ] ], \"index\": false, \"columnWidth\": [], \"align\": [ \"center\", \"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"], \"rowNum\": 8, \"waitTime\": 3, \"headerHeight\": 45, \"carousel\": \"single\", \"headerBGC\": \"#165896FF\", \"oddRowBGC\": \"#042b4dFF\", \"evenRowBGC\": \"#0a1c37FF\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1cfwp95aiif400\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 0, \"y\": 1050, \"w\": 1300, \"h\": 525, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 120, \"x\": 0, \"y\": 1050, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 277, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"项目集年度完成数据概览\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 245, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 265, \"y\": 28, \"w\": 1000, \"h\": 10, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"1zhfrmecpnxc00\",\n                \"sourceID\": 1074,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 25, \"y\": 57, \"w\": 1250, \"h\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TableScrollBoard\",\n                \"chartConfig\": { \"key\": \"TableScrollBoard\", \"chartKey\": \"VTableScrollBoard\", \"conKey\": \"VCTableScrollBoard\", \"title\": \"轮播列表\", \"category\": \"Tables\", \"categoryName\": \"表格\", \"package\": \"Tables\", \"chartFrame\": \"common\", \"image\": \"static/png/table_scrollboard-fb642e78.png\" },\n                \"option\": { \"header\": [ \"列1\", \"列2\", \"列3\" ], \"dataset\": [ [ \"行1列1\", \"行1列2\", \"行1列3\" ], [ \"行2列1\", \"行2列2\", \"行2列3\" ], [ \"行3列1\", \"行3列2\", \"行3列3\" ], [ \"行4列1\", \"行4列2\", \"行4列3\" ], [ \"行5列1\", \"行5列2\", \"行5列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ] ], \"index\": false, \"columnWidth\": [], \"align\": [ \"center\", \"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"], \"rowNum\": 8, \"waitTime\": 3, \"headerHeight\": 45, \"carousel\": \"single\", \"headerBGC\": \"#165896FF\", \"oddRowBGC\": \"#042b4dFF\", \"evenRowBGC\": \"#0a1c37FF\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1cfwp95aiif400\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 0, \"y\": 1600, \"w\": 640, \"h\": 525, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 640, \"h\": 120, \"x\": 0, \"y\": 1600, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 277, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"产品年度新增数据汇总表\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 245, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 265, \"y\": 28, \"w\": 340, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"1zhfrmecpnxc00\",\n                \"sourceID\": 1075,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 20, \"y\": 57, \"w\": 600, \"h\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TableScrollBoard\",\n                \"chartConfig\": { \"key\": \"TableScrollBoard\", \"chartKey\": \"VTableScrollBoard\", \"conKey\": \"VCTableScrollBoard\", \"title\": \"轮播列表\", \"category\": \"Tables\", \"categoryName\": \"表格\", \"package\": \"Tables\", \"chartFrame\": \"common\", \"image\": \"static/png/table_scrollboard-fb642e78.png\" },\n                \"option\": { \"header\": [ \"列1\", \"列2\", \"列3\" ], \"dataset\": [ [ \"行1列1\", \"行1列2\", \"行1列3\" ], [ \"行2列1\", \"行2列2\", \"行2列3\" ], [ \"行3列1\", \"行3列2\", \"行3列3\" ], [ \"行4列1\", \"行4列2\", \"行4列3\" ], [ \"行5列1\", \"行5列2\", \"行5列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ] ], \"index\": false, \"columnWidth\": [], \"align\": [ \"center\", \"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"], \"rowNum\": 8, \"waitTime\": 3, \"headerHeight\": 45, \"carousel\": \"single\", \"headerBGC\": \"#165896FF\", \"oddRowBGC\": \"#042b4dFF\", \"evenRowBGC\": \"#0a1c37FF\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1cfwp95aiif400\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 660, \"y\": 1600, \"w\": 640, \"h\": 525, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 640, \"h\": 120, \"x\": 660, \"y\": 1600, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 277, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"产品年度完成数据汇总表\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 245, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 265, \"y\": 28, \"w\": 340, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"1zhfrmecpnxc00\",\n                \"sourceID\": 1076,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 20, \"y\": 57, \"w\": 600, \"h\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TableScrollBoard\",\n                \"chartConfig\": { \"key\": \"TableScrollBoard\", \"chartKey\": \"VTableScrollBoard\", \"conKey\": \"VCTableScrollBoard\", \"title\": \"轮播列表\", \"category\": \"Tables\", \"categoryName\": \"表格\", \"package\": \"Tables\", \"chartFrame\": \"common\", \"image\": \"static/png/table_scrollboard-fb642e78.png\" },\n                \"option\": { \"header\": [ \"列1\", \"列2\", \"列3\" ], \"dataset\": [ [ \"行1列1\", \"行1列2\", \"行1列3\" ], [ \"行2列1\", \"行2列2\", \"行2列3\" ], [ \"行3列1\", \"行3列2\", \"行3列3\" ], [ \"行4列1\", \"行4列2\", \"行4列3\" ], [ \"行5列1\", \"行5列2\", \"行5列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ] ], \"index\": false, \"columnWidth\": [], \"align\": [ \"center\", \"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"], \"rowNum\": 8, \"waitTime\": 3, \"headerHeight\": 45, \"carousel\": \"single\", \"headerBGC\": \"#165896FF\", \"oddRowBGC\": \"#042b4dFF\", \"evenRowBGC\": \"#0a1c37FF\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 640, \"h\": 500, \"x\": 0, \"y\": 2150, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"需求年度新增和完成趋势图\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1dlpgwe8wwe800\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 640, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"需求年度新增和完成趋势图\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1077,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 60, \"w\": 600, \"h\": 416, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"LineCommon\",\n                \"chartConfig\":{\"key\":\"LineCommon\",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"折线图\",\"category\":\"Lines\",\"categoryName\":\"折线图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static/png/line.png\"},\n                \"option\":{\"legend\":{\"show\":true,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"60\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}\n            },\n            {\n                \"id\": \"2u3zlsz5kk4000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 22, \"w\": 600, \"h\": 50, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"需求年度新增和完成趋势图\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"需求年度新增和完成趋势图\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 640, \"h\": 500, \"x\": 660, \"y\": 2150, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"BUG年度新增和解决趋势图\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1dlpgwe8wwe800\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 640, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"BUG年度新增和解决趋势图\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1078,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 60, \"w\": 600, \"h\": 416, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"LineCommon\",\n                \"chartConfig\":{\"key\":\"LineCommon\",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"折线图\",\"category\":\"Lines\",\"categoryName\":\"折线图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static/png/line.png\"},\n                \"option\":{\"legend\":{\"show\":true,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"60\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}\n            },\n            {\n                \"id\": \"2u3zlsz5kk4000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 22, \"w\": 600, \"h\": 50, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"BUG年度新增和解决趋势图\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"BUG年度新增和解决趋势图\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 640, \"h\": 500, \"x\": 0, \"y\": 2675, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"任务年度新增和完成趋势图\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1dlpgwe8wwe800\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 640, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"任务年度新增和完成趋势图\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1079,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 60, \"w\": 600, \"h\": 416, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"LineCommon\",\n                \"chartConfig\":{\"key\":\"LineCommon \",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"折线图\",\"category\":\"Lines\",\"categoryName\":\"折线图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static/png/line.png\"},\n                \"option\":{\"legend\":{\"show\":true,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"60\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}\n            },\n            {\n                \"id\": \"2u3zlsz5kk4000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 22, \"w\": 600, \"h\": 50, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"任务年度新增和完成趋势图\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"任务年度新增和完成趋势图\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 640, \"h\": 500, \"x\": 660, \"y\": 2675, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目年度新增和解决趋势图\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1dlpgwe8wwe800\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 640, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目年度新增和解决趋势图\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1080,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 60, \"w\": 600, \"h\": 416, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"LineCommon\",\n                \"chartConfig\":{\"key\":\"LineCommon\",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"折线图\",\"category\":\"Lines\",\"categoryName\":\"折线图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static/png/line.png\"},\n                \"option\":{\"legend\":{\"show\":true,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"60\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}\n            },\n            {\n                \"id\": \"2u3zlsz5kk4000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 22, \"w\": 600, \"h\": 50, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"项目年度新增和解决趋势图\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"项目年度新增和解决趋势图\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 640, \"h\": 500, \"x\": 0, \"y\": 3200, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"执行年度新增和完成趋势图\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1dlpgwe8wwe800\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 640, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"执行年度新增和完成趋势图\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1081,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 60, \"w\": 600, \"h\": 416, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"LineCommon\",\n                \"chartConfig\":{\"key\":\"LineCommon\",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"折线图\",\"category\":\"Lines\",\"categoryName\":\"折线图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static/png/line.png\"},\n                \"option\":{\"legend\":{\"show\":true,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"60\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}\n            },\n            {\n                \"id\": \"2u3zlsz5kk4000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 22, \"w\": 600, \"h\": 50, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"执行年度新增和完成趋势图\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"执行年度新增和完成趋势图\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 640, \"h\": 500, \"x\": 660, \"y\": 3200, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"产品发布次数年度趋势图\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1dlpgwe8wwe800\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 640, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"产品发布次数年度趋势图\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1082,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 60, \"w\": 600, \"h\": 416, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"LineCommon\",\n                \"chartConfig\":{\"key\":\"LineCommon\",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"折线图\",\"category\":\"Lines\",\"categoryName\":\"折线图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static/png/line.png\"},\n                \"option\":{\"legend\":{\"show\":true,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"60\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}\n            },\n            {\n                \"id\": \"2u3zlsz5kk4000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 22, \"w\": 600, \"h\": 50, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"产品发布次数年度趋势图\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"产品发布次数年度趋势图\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 500, \"x\": 0, \"y\": 3730, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"年度投入产出比\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1dlpgwe8wwe800\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 1300, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"年度投入产出比\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1083,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 60, \"w\": 1300, \"h\": 416, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"LineCommon\",\n                \"chartConfig\":{\"key\":\"LineCommon\",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"折线图\",\"category\":\"Lines\",\"categoryName\":\"折线图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static/png/line.png\"},\n                \"option\":{\n                    \"legend\":{\"show\":true,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\n                    \"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\n                    \"yAxis\":\n                    [\n                        {\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\n                        {\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"right\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"}\n                    ],\n                    \"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"60\",\"right\":\"10%\",\"bottom\":\"60\"},\n                    \"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\n                    \"dataset\":{\n                        \"dimensions\":[\"product\",\"data1\",\"data2\"],\n                        \"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\n                        \"series\":[{\"type\":\"line\",\"yAxisIndex\":1,\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"bar\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}, {\"type\":\"bar\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\n                        \"backgroundColor\":\"rgba(0,0,0,0)\"\n                }\n            },\n            {\n                \"id\": \"2u3zlsz5kk4000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 22, \"w\": 1300, \"h\": 50, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"年度投入产出比\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"年度投入产出比\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"fc4u6zmi58w00\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 732, \"y\": 3767, \"w\": 20, \"h\": 20, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": 1 },\n        \"styles\": { \"filterShow\": false, \"hueRotate\": 0, \"saturate\": 1, \"contrast\": 1, \"brightness\": 1, \"opacity\": 1, \"rotateZ\": 0, \"rotateX\": 0, \"rotateY\": 0, \"skewX\": 0, \"skewY\": 0, \"blendMode\": \"normal\", \"animations\": [] },\n        \"status\": { \"lock\": false, \"hide\": false },\n        \"request\": { \"requestDataType\": 0, \"requestHttpType\": \"get\", \"requestUrl\": \"\", \"requestInterval\": null, \"requestIntervalUnit\": \"second\", \"requestContentType\": 0, \"requestParamsBodyType\": \"none\", \"requestSQLContent\": { \"sql\": \"select * from  where\" }, \"requestParams\": { \"Body\": { \"form-data\": {}, \"x-www-form-urlencoded\": {}, \"json\": \"\", \"xml\": \"\" }, \"Header\": {}, \"Params\": {} } },\n        \"filter\": null,\n        \"events\": { \"baseEvent\": { \"click\": null, \"dblclick\": null, \"mouseenter\": null, \"mouseleave\": null }, \"advancedEvents\": { \"vnodeMounted\": null, \"vnodeBeforeMount\": null } },\n        \"key\": \"Hint\",\n        \"chartConfig\": { \"key\": \"Hint\", \"chartKey\": \"VHint\", \"conKey\": \"VCHint\", \"title\": \"提示\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/hint-2cbf6381.png\" },\n        \"option\": { \"text\": \"\", \"icon\": \"\", \"textSize\": 15, \"textColor\": \"#ffffff\", \"textWeight\": \"bold\", \"placement\": \"left-top\", \"distance\": 8, \"hint\": \"投入产出比=需求交付故事点数/工时消耗；\\n需求交付故事点数=关闭原因为已完成的需求的故事点数。\", \"width\": 0, \"height\": 0, \"paddingX\": 16, \"paddingY\": 8, \"borderWidth\": 1, \"borderStyle\": \"solid\", \"borderColor\": \"#1a77a5\", \"borderRadius\": 6, \"color\": \"#ffffff\", \"textAlign\": \"left\", \"fontWeight\": \"normal\", \"backgroundColor\": \"rgba(8, 40, 80, 0.9)\", \"fontSize\": 16 }\n    }\n]\n',	'admin',	'2022-11-18 10:46:18',	'admin',	'2022-11-18 10:46:18',	'0'),
(3,	1,	'年度总结大屏',	'从年份、部门、个人的角度快速了解年度工作总结的情况',	'static/images/screen3.png',	'[\n    {\n        \"id\": \"5scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 120, \"x\": 0, \"y\": 0, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 1300, \"h\": 120, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/screen_header.png\", \"borderRadius\": 10 }\n            },\n            {\n                \"id\": \"2nws38440fq000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 360, \"y\": 36, \"w\": 500, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"年度总结大屏\", \"fontSize\": 20, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"5scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 300, \"h\": 120, \"x\": 0, \"y\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"type\": \"year\",\n                \"filterCharts\": [\n                    {\"chart\": 1001, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1002, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1003, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1004, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1005, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1006, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1007, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1008, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1009, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1010, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1011, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1012, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1013, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1014, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1015, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1016, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1017, \"field\": \"t1.`year`\"}\n                ],\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 120, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Select\",\n                \"chartConfig\": { \"key\": \"Select\", \"chartKey\": \"VSelect\", \"conKey\": \"VCSelect\", \"title\": \"选择\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/select-c616737a.png\" },\n                \"option\": { \"dataset\": [ { \"label\": \"请选择\", \"value\": \"\" }, { \"label\": \"河北\", \"value\": \"18700\" }, { \"label\": \"徐州\", \"value\": \"17800\" } ], \"value\": \"\", \"borderWidth\": 1, \"borderStyle\": \"solid\", \"borderColor\": \"#1a77a5\", \"background\": \"none\", \"borderRadius\": 6, \"color\": \"#ffffff\", \"textAlign\": \"center\", \"fontWeight\": \"normal\", \"backgroundColor\": \"transparent\", \"fontSize\": 20, \"onChange\": \"console.log(value)\"}\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"type\": \"dept\",\n                \"filterCharts\": [\n                    {\"chart\": 1001, \"field\": \"\"},\n                    {\"chart\": 1002, \"field\": \"\"},\n                    {\"chart\": 1003, \"field\": \"\"},\n                    {\"chart\": 1004, \"field\": \"\"},\n                    {\"chart\": 1005, \"field\": \"\"},\n                    {\"chart\": 1006, \"field\": \"\"},\n                    {\"chart\": 1007, \"field\": \"\"},\n                    {\"chart\": 1008, \"field\": \"\"},\n                    {\"chart\": 1009, \"field\": \"\"},\n                    {\"chart\": 1010, \"field\": \"\"},\n                    {\"chart\": 1011, \"field\": \"\"},\n                    {\"chart\": 1012, \"field\": \"\"},\n                    {\"chart\": 1013, \"field\": \"\"},\n                    {\"chart\": 1014, \"field\": \"\"},\n                    {\"chart\": 1015, \"field\": \"\"},\n                    {\"chart\": 1016, \"field\": \"\"},\n                    {\"chart\": 1017, \"field\": \"\"}\n                ],\n                \"isGroup\": false,\n                \"attr\": { \"x\": 110, \"y\": 0, \"w\": 120, \"h\": 120, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Select\",\n                \"chartConfig\": { \"key\": \"Select\", \"chartKey\": \"VSelect\", \"conKey\": \"VCSelect\", \"title\": \"选择\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/select-c616737a.png\" },\n                \"option\": { \"dataset\": [ { \"label\": \"请选择\", \"value\": \"\" }, { \"label\": \"河北\", \"value\": \"18700\" }, { \"label\": \"徐州\", \"value\": \"17800\" } ], \"value\": \"\", \"borderWidth\": 1, \"borderStyle\": \"solid\", \"borderColor\": \"#1a77a5\", \"background\": \"none\", \"borderRadius\": 6, \"color\": \"#ffffff\", \"textAlign\": \"center\", \"fontWeight\": \"normal\", \"backgroundColor\": \"transparent\", \"fontSize\": 20, \"onChange\": \"console.log(value)\"}\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"type\": \"account\",\n                \"filterCharts\": [\n                    {\"chart\": 1001, \"field\": \"t1.account\"},\n                    {\"chart\": 1002, \"field\": \"t1.account\"},\n                    {\"chart\": 1003, \"field\": \"t1.account\"},\n                    {\"chart\": 1004, \"field\": \"t1.account\"},\n                    {\"chart\": 1005, \"field\": \"t1.account\"},\n                    {\"chart\": 1006, \"field\": \"t1.account\"},\n                    {\"chart\": 1007, \"field\": \"t1.account\"},\n                    {\"chart\": 1008, \"field\": \"t1.account\"},\n                    {\"chart\": 1009, \"field\": \"t1.account\"},\n                    {\"chart\": 1010, \"field\": \"t1.account\"},\n                    {\"chart\": 1011, \"field\": \"t1.account\"},\n                    {\"chart\": 1012, \"field\": \"t1.account\"},\n                    {\"chart\": 1013, \"field\": \"t1.account\"},\n                    {\"chart\": 1014, \"field\": \"t1.account\"},\n                    {\"chart\": 1015, \"field\": \"t1.account\"},\n                    {\"chart\": 1016, \"field\": \"t1.account\"},\n                    {\"chart\": 1017, \"field\": \"t1.account\"}\n                ],\n                \"isGroup\": false,\n                \"attr\": { \"x\": 240, \"y\": 0, \"w\": 120, \"h\": 120, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Select\",\n                \"chartConfig\": { \"key\": \"Select\", \"chartKey\": \"VSelect\", \"conKey\": \"VCSelect\", \"title\": \"选择\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/select-c616737a.png\" },\n                \"option\": { \"dataset\": [ { \"label\": \"请选择\", \"value\": \"\" }, { \"label\": \"河北\", \"value\": \"18700\" }, { \"label\": \"徐州\", \"value\": \"17800\" } ], \"value\": \"\", \"borderWidth\": 1, \"borderStyle\": \"solid\", \"borderColor\": \"#1a77a5\", \"background\": \"none\", \"borderRadius\": 6, \"color\": \"#ffffff\", \"textAlign\": \"center\", \"fontWeight\": \"normal\", \"backgroundColor\": \"transparent\", \"fontSize\": 20, \"onChange\": \"console.log(value)\"}\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 350, \"h\": 120, \"x\": 0, \"y\": 175, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1cfwp95aiif400\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 350, \"h\": 380, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 100, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"基础数据\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 115, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 115, \"y\": 30, \"w\": 200, \"h\": 8.5, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 350, \"h\": 120, \"x\": 0, \"y\": 195, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2nws38440fq000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 40, \"y\": 36, \"w\": 150, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"登录次数\", \"fontSize\": 12, \"fontColor\": \"#ebf3f6\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2nws38440fq000\",\n                \"sourceID\": 1001,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 200, \"y\": 34, \"w\": 110, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"right\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 350, \"h\": 120, \"x\": 0, \"y\": 245, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2nws38440fq000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 40, \"y\": 36, \"w\": 130, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"操作次数\", \"fontSize\": 12, \"fontColor\": \"#ebf3f6\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2nws38440fq000\",\n                \"sourceID\": 1002,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 200, \"y\": 34, \"w\": 110, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"right\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 350, \"h\": 120, \"x\": 0, \"y\": 295, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2nws38440fq000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 40, \"y\": 36, \"w\": 130, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"消耗工时\", \"fontSize\": 12, \"fontColor\": \"#ebf3f6\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2nws38440fq000\",\n                \"sourceID\": 1003,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 200, \"y\": 34, \"w\": 110, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"right\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 350, \"h\": 120, \"x\": 0, \"y\": 345, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2nws38440fq000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 40, \"y\": 36, \"w\": 130, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"待办数\", \"fontSize\": 12, \"fontColor\": \"#ebf3f6\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2nws38440fq000\",\n                \"sourceID\": 1004,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 200, \"y\": 34, \"w\": 110, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"right\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 350, \"h\": 120, \"x\": 0, \"y\": 395, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2nws38440fq000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 40, \"y\": 36, \"w\": 130, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"贡献数\", \"fontSize\": 12, \"fontColor\": \"#ebf3f6\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2nws38440fq000\",\n                \"sourceID\": 1005,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 200, \"y\": 34, \"w\": 110, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"right\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 560, \"h\": 120, \"x\": 370, \"y\": 175, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1cfwp95aiif400\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 560, \"h\": 380, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 100, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"贡献数据\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 115, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 115, \"y\": 30, \"w\": 410, \"h\": 8.5, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1006,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 10, \"w\": 500, \"h\": 400, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": { \"show\": false, \"top\": \"5%\", \"textStyle\": { \"color\": \"#B9B8CE\" } },\n                    \"xAxis\": {\n                        \"show\": false, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": false, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}%\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": false, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": false, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"8%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\", \"containLabel\": true },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [\n                        { \"type\": \"bar\", \"barWidth\": null, \"stack\": \"totoal\", \"emphasis\": {\"focus\": \"series\"}, \"label\": { \"show\": false, \"formatter\": \"{@[1]}\", \"position\": \"center\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } },\n                        { \"type\": \"bar\", \"barWidth\": null, \"stack\": \"totoal\", \"emphasis\": {\"focus\": \"series\"}, \"label\": { \"show\": false, \"formatter\": \"{@[2]}\", \"position\": \"center\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\"\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 350, \"h\": 120, \"x\": 950, \"y\": 175, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1cfwp95aiif400\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 350, \"h\": 380, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 100, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"贡献数据\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 115, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 115, \"y\": 30, \"w\": 200, \"h\": 8.5, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                  \"id\": \"5k6jxu8g200000\",\n                  \"sourceID\": 1007,\n                  \"isGroup\": false,\n                  \"attr\": { \"x\": 0, \"y\": 30, \"w\": 350, \"h\": 300, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                  \"key\": \"Radar\",\n                  \"chartConfig\": { \"key\": \"Radar\", \"chartKey\": \"VRadar\", \"conKey\": \"VCRadar\", \"title\": \"雷达图\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Charts\", \"chartFrame\": \"common\", \"image\": \"static/png/radar.png\" },\n                  \"option\": {\n                    \"legend\": { \"show\": false, \"top\": \"5%\", \"textStyle\": { \"color\": \"#B9B8CE\" }, \"data\": [ \"data1\" ] },\n                    \"tooltip\": { \"show\": true },\n                    \"dataset\": { \"radarIndicator\": [ { \"name\": \"数据1\", \"max\": 6500 }, { \"name\": \"数据2\", \"max\": 16000 }, { \"name\": \"数据3\", \"max\": 30000 }, { \"name\": \"数据4\", \"max\": 38000 }, { \"name\": \"数据5\", \"max\": 52000 }, { \"name\": \"数据6\", \"max\": 25000 } ], \"seriesData\": [ { \"name\": \"data1\", \"value\": [ 4200, 3000, 20000, 35000, 50000, 18000 ] } ] },\n                    \"radar\": { \"shape\": \"polygon\", \"radius\": [ \"0%\", \"60%\" ], \"center\": [ \"50%\", \"55%\" ], \"splitArea\": { \"show\": true }, \"splitLine\": { \"show\": true }, \"axisName\": { \"show\": true, \"color\": \"#eee\", \"fontSize\": 12 }, \"axisLine\": { \"show\": true }, \"axisTick\": { \"show\": true }, \"indicator\": [ { \"name\": \"数据1\", \"max\": 6500 }, { \"name\": \"数据2\", \"max\": 16000 }, { \"name\": \"数据3\", \"max\": 30000 }, { \"name\": \"数据4\", \"max\": 38000 }, { \"name\": \"数据5\", \"max\": 52000 }, { \"name\": \"数据6\", \"max\": 25000 } ] },\n                    \"series\": [ { \"name\": \"radar\", \"type\": \"radar\", \"areaStyle\": { \"opacity\": 0.1 }, \"data\": [ { \"name\": \"data1\", \"value\": [ 4200, 3000, 20000, 35000, 50000, 18000 ] } ] } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\"\n                  }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 640, \"h\": 120, \"x\": 0, \"y\": 570, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1cfwp95aiif400\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 640, \"h\": 525, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"迭代数据\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 31, \"w\": 495, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"1zhfrmecpnxc00\",\n                \"sourceID\": 1008,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 25, \"y\": 57, \"w\": 590, \"h\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TableScrollBoard\",\n                \"chartConfig\": { \"key\": \"TableScrollBoard\", \"chartKey\": \"VTableScrollBoard\", \"conKey\": \"VCTableScrollBoard\", \"title\": \"轮播列表\", \"category\": \"Tables\", \"categoryName\": \"表格\", \"package\": \"Tables\", \"chartFrame\": \"common\", \"image\": \"static/png/table_scrollboard-fb642e78.png\" },\n                \"option\": { \"header\": [ \"列1\", \"列2\", \"列3\" ], \"dataset\": [ [ \"行1列1\", \"行1列2\", \"行1列3\" ], [ \"行2列1\", \"行2列2\", \"行2列3\" ], [ \"行3列1\", \"行3列2\", \"行3列3\" ], [ \"行4列1\", \"行4列2\", \"行4列3\" ], [ \"行5列1\", \"行5列2\", \"行5列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ] ], \"index\": false, \"columnWidth\": [], \"align\": [ \"center\", \"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"], \"rowNum\": 8, \"waitTime\": 3, \"headerHeight\": 45, \"carousel\": \"single\", \"headerBGC\": \"#165896FF\", \"oddRowBGC\": \"#042b4dFF\", \"evenRowBGC\": \"#0a1c37FF\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 640, \"h\": 120, \"x\": 660, \"y\": 570, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1cfwp95aiif400\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 640, \"h\": 525, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"产品数据\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 31, \"w\": 495, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"1zhfrmecpnxc00\",\n                \"sourceID\": 1009,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 25, \"y\": 57, \"w\": 590, \"h\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TableScrollBoard\",\n                \"chartConfig\": { \"key\": \"TableScrollBoard\", \"chartKey\": \"VTableScrollBoard\", \"conKey\": \"VCTableScrollBoard\", \"title\": \"轮播列表\", \"category\": \"Tables\", \"categoryName\": \"表格\", \"package\": \"Tables\", \"chartFrame\": \"common\", \"image\": \"static/png/table_scrollboard-fb642e78.png\" },\n                \"option\": { \"header\": [ \"列1\", \"列2\", \"列3\" ], \"dataset\": [ [ \"行1列1\", \"行1列2\", \"行1列3\" ], [ \"行2列1\", \"行2列2\", \"行2列3\" ], [ \"行3列1\", \"行3列2\", \"行3列3\" ], [ \"行4列1\", \"行4列2\", \"行4列3\" ], [ \"行5列1\", \"行5列2\", \"行5列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ] ], \"index\": false, \"columnWidth\": [], \"align\": [ \"center\", \"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"], \"rowNum\": 8, \"waitTime\": 3, \"headerHeight\": 45, \"carousel\": \"single\", \"headerBGC\": \"#165896FF\", \"oddRowBGC\": \"#042b4dFF\", \"evenRowBGC\": \"#0a1c37FF\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 400, \"x\": 0, \"y\": 1110, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1cfwp95aiif400\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 1300, \"h\": 400, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"任务数据\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 30, \"w\": 1150, \"h\": 9, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 57, \"y\": 38, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"任务状态分布\", \"fontSize\": 12, \"fontColor\": \"#d7e0e4\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2mxz8pdw932000\",\n                \"sourceID\": 1010,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 60, \"y\": 70, \"w\": 380, \"h\": 280, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"PieCommon\",\n                \"chartConfig\": { \"key\": \"PieCommon\", \"chartKey\": \"VPieCommon\", \"conKey\": \"VCPieCommon\", \"title\": \"需求完成率\", \"category\": \"Pies\", \"categoryName\": \"饼图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/pie-9620f191.png\" },\n                \"option\": { \"legend\": { \"show\": false, \"top\": \"5%\", \"textStyle\": { \"color\": \"#B9B8CE\" } }, \"type\": \"nomal\", \"tooltip\": { \"show\": true, \"trigger\": \"item\" }, \"dataset\": { \"dimensions\": [ \"product\", \"data1\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120 }, { \"product\": \"Tue\", \"data1\": 200 }, { \"product\": \"Wed\", \"data1\": 150 }, { \"product\": \"Thu\", \"data1\": 80 }, { \"product\": \"Fri\", \"data1\": 70 }, { \"product\": \"Sat\", \"data1\": 110 }, { \"product\": \"Sun\", \"data1\": 130 } ] }, \"series\": [ { \"type\": \"pie\", \"radius\": [ \"40%\", \"65%\" ], \"label\": { \"show\": true, \"width\": 120, \"formatter\": \"{b}\\n{d}%\", \"lineHeight\": 20, \"color\": \"#ffffff\", \"position\": \"outside\" }, \"center\": [ \"50%\", \"60%\" ], \"roseType\": false , \"emphasis\": { \"itemStyle\": { \"shadowBlur\": 20, \"shadowOffsetX\": 2, \"shadowColor\": \"rgba(0, 0, 0, 0)\" } }} ] }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 520, \"y\": 38, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"每月任务操作情况\", \"fontSize\": 12, \"fontColor\": \"#d7e0e4\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2mxz8pdw932000\",\n                \"sourceID\": 1011,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 520, \"y\": 70, \"w\": 780, \"h\": 350, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCommon\",\n                \"chartConfig\": { \"key\": \"BarCommon\", \"chartKey\": \"VBarCommon\", \"conKey\": \"VCBarCommon\", \"title\": \"柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_x.png\" },\n                \"option\": {\n                    \"legend\": { \"show\": true, \"top\": \"5%\", \"left\": 5, \"textStyle\": { \"color\": \"#B9B8CE\" } },\n                    \"xAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": false, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0 }, \"position\": \"bottom\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": true, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": false, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0 }, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"value\" },\n                    \"grid\": { \"show\": false, \"left\": \"5%\", \"top\": \"60\", \"right\": \"10%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": {\n                        \"dimensions\": [ \"product\", \"data1\", \"data2\" ],\n                        \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\"\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 400, \"x\": 0, \"y\": 1525, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1cfwp95aiif400\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 1300, \"h\": 400, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"需求数据\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 30, \"w\": 1150, \"h\": 9, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 57, \"y\": 38, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"需求状态分布\", \"fontSize\": 12, \"fontColor\": \"#d7e0e4\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2mxz8pdw932000\",\n                \"sourceID\": 1012,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 60, \"y\": 70, \"w\": 380, \"h\": 280, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"PieCommon\",\n                \"chartConfig\": { \"key\": \"PieCommon\", \"chartKey\": \"VPieCommon\", \"conKey\": \"VCPieCommon\", \"title\": \"需求完成率\", \"category\": \"Pies\", \"categoryName\": \"饼图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/pie-9620f191.png\" },\n                \"option\": { \"legend\": { \"show\": false, \"top\": \"5%\", \"textStyle\": { \"color\": \"#B9B8CE\" } }, \"type\": \"nomal\", \"tooltip\": { \"show\": true, \"trigger\": \"item\" }, \"dataset\": { \"dimensions\": [ \"product\", \"data1\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120 }, { \"product\": \"Tue\", \"data1\": 200 }, { \"product\": \"Wed\", \"data1\": 150 }, { \"product\": \"Thu\", \"data1\": 80 }, { \"product\": \"Fri\", \"data1\": 70 }, { \"product\": \"Sat\", \"data1\": 110 }, { \"product\": \"Sun\", \"data1\": 130 } ] }, \"series\": [ { \"type\": \"pie\", \"radius\": [ \"40%\", \"65%\" ], \"label\": { \"show\": true, \"width\": 120, \"formatter\": \"{b}\\n{d}%\", \"lineHeight\": 20, \"color\": \"#ffffff\", \"position\": \"outside\" }, \"center\": [ \"50%\", \"60%\" ], \"roseType\": false , \"emphasis\": { \"itemStyle\": { \"shadowBlur\": 20, \"shadowOffsetX\": 2, \"shadowColor\": \"rgba(0, 0, 0, 0)\" } }} ] }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 520, \"y\": 38, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"每月需求操作情况\", \"fontSize\": 12, \"fontColor\": \"#d7e0e4\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2mxz8pdw932000\",\n                \"sourceID\": 1013,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 520, \"y\": 70, \"w\": 780, \"h\": 350, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCommon\",\n                \"chartConfig\": { \"key\": \"BarCommon\", \"chartKey\": \"VBarCommon\", \"conKey\": \"VCBarCommon\", \"title\": \"柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_x.png\" },\n                \"option\": {\n                    \"legend\": { \"show\": true, \"top\": \"5%\", \"left\": 5, \"textStyle\": { \"color\": \"#B9B8CE\" } },\n                    \"xAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": false, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0 }, \"position\": \"bottom\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": true, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": false, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0 }, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"value\" },\n                    \"grid\": { \"show\": false, \"left\": \"5%\", \"top\": \"60\", \"right\": \"10%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": {\n                        \"dimensions\": [ \"product\", \"data1\", \"data2\" ],\n                        \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\"\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 400, \"x\": 0, \"y\": 1935, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1cfwp95aiif400\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 1300, \"h\": 400, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"Bug数据\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 30, \"w\": 1150, \"h\": 9, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 57, \"y\": 38, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"Bug状态分布\", \"fontSize\": 12, \"fontColor\": \"#d7e0e4\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2mxz8pdw932000\",\n                \"sourceID\": 1014,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 60, \"y\": 70, \"w\": 380, \"h\": 280, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"PieCommon\",\n                \"chartConfig\": { \"key\": \"PieCommon\", \"chartKey\": \"VPieCommon\", \"conKey\": \"VCPieCommon\", \"title\": \"需求完成率\", \"category\": \"Pies\", \"categoryName\": \"饼图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/pie-9620f191.png\" },\n                \"option\": { \"legend\": { \"show\": false, \"top\": \"5%\", \"textStyle\": { \"color\": \"#B9B8CE\" } }, \"type\": \"nomal\", \"tooltip\": { \"show\": true, \"trigger\": \"item\" }, \"dataset\": { \"dimensions\": [ \"product\", \"data1\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120 }, { \"product\": \"Tue\", \"data1\": 200 }, { \"product\": \"Wed\", \"data1\": 150 }, { \"product\": \"Thu\", \"data1\": 80 }, { \"product\": \"Fri\", \"data1\": 70 }, { \"product\": \"Sat\", \"data1\": 110 }, { \"product\": \"Sun\", \"data1\": 130 } ] }, \"series\": [ { \"type\": \"pie\", \"radius\": [ \"40%\", \"65%\" ], \"label\": { \"show\": true, \"width\": 120, \"formatter\": \"{b}\\n{d}%\", \"lineHeight\": 20, \"color\": \"#ffffff\", \"position\": \"outside\" }, \"center\": [ \"50%\", \"60%\" ], \"roseType\": false , \"emphasis\": { \"itemStyle\": { \"shadowBlur\": 20, \"shadowOffsetX\": 2, \"shadowColor\": \"rgba(0, 0, 0, 0)\" } }} ] }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 520, \"y\": 38, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"每月Bug操作情况\", \"fontSize\": 12, \"fontColor\": \"#d7e0e4\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2mxz8pdw932000\",\n                \"sourceID\": 1015,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 520, \"y\": 70, \"w\": 780, \"h\": 350, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCommon\",\n                \"chartConfig\": { \"key\": \"BarCommon\", \"chartKey\": \"VBarCommon\", \"conKey\": \"VCBarCommon\", \"title\": \"柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_x.png\" },\n                \"option\": {\n                    \"legend\": { \"show\": true, \"top\": \"5%\", \"left\": 5, \"textStyle\": { \"color\": \"#B9B8CE\" } },\n                    \"xAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": false, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0 }, \"position\": \"bottom\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": true, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": false, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0 }, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"value\" },\n                    \"grid\": { \"show\": false, \"left\": \"5%\", \"top\": \"60\", \"right\": \"10%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": {\n                        \"dimensions\": [ \"product\", \"data1\", \"data2\" ],\n                        \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\"\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 400, \"x\": 0, \"y\": 2350, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1cfwp95aiif400\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 1300, \"h\": 400, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"用例数据\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 30, \"w\": 1150, \"h\": 9, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 57, \"y\": 38, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"用例结果分布\", \"fontSize\": 12, \"fontColor\": \"#d7e0e4\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2mxz8pdw932000\",\n                \"sourceID\": 1016,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 60, \"y\": 70, \"w\": 380, \"h\": 280, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"PieCommon\",\n                \"chartConfig\": { \"key\": \"PieCommon\", \"chartKey\": \"VPieCommon\", \"conKey\": \"VCPieCommon\", \"title\": \"需求完成率\", \"category\": \"Pies\", \"categoryName\": \"饼图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/pie-9620f191.png\" },\n                \"option\": { \"legend\": { \"show\": false, \"top\": \"5%\", \"textStyle\": { \"color\": \"#B9B8CE\" } }, \"type\": \"nomal\", \"tooltip\": { \"show\": true, \"trigger\": \"item\" }, \"dataset\": { \"dimensions\": [ \"product\", \"data1\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120 }, { \"product\": \"Tue\", \"data1\": 200 }, { \"product\": \"Wed\", \"data1\": 150 }, { \"product\": \"Thu\", \"data1\": 80 }, { \"product\": \"Fri\", \"data1\": 70 }, { \"product\": \"Sat\", \"data1\": 110 }, { \"product\": \"Sun\", \"data1\": 130 } ] }, \"series\": [ { \"type\": \"pie\", \"radius\": [ \"40%\", \"65%\" ], \"label\": { \"show\": true, \"width\": 120, \"formatter\": \"{b}\\n{d}%\", \"lineHeight\": 20, \"color\": \"#ffffff\", \"position\": \"outside\" }, \"center\": [ \"50%\", \"60%\" ], \"roseType\": false , \"emphasis\": { \"itemStyle\": { \"shadowBlur\": 20, \"shadowOffsetX\": 2, \"shadowColor\": \"rgba(0, 0, 0, 0)\" } }} ] }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 520, \"y\": 38, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"每月用例操作情况\", \"fontSize\": 12, \"fontColor\": \"#d7e0e4\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2mxz8pdw932000\",\n                \"sourceID\": 1017,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 520, \"y\": 70, \"w\": 780, \"h\": 350, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCommon\",\n                \"chartConfig\": { \"key\": \"BarCommon\", \"chartKey\": \"VBarCommon\", \"conKey\": \"VCBarCommon\", \"title\": \"柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_x.png\" },\n                \"option\": {\n                    \"legend\": { \"show\": true, \"top\": \"5%\", \"left\": 5, \"textStyle\": { \"color\": \"#B9B8CE\" } },\n                    \"xAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": false, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0 }, \"position\": \"bottom\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": true, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": false, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0 }, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"value\" },\n                    \"grid\": { \"show\": false, \"left\": \"5%\", \"top\": \"60\", \"right\": \"10%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": {\n                        \"dimensions\": [ \"product\", \"data1\", \"data2\" ],\n                        \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\"\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    }\n]\n',	'admin',	'2022-11-18 10:46:18',	'admin',	'2022-11-18 10:46:18',	'0'),
(4,	1,	'年度排行榜大屏',	'从项目集、项目、产品、个人的角度快速了解进度、投入、产出的排行榜',	'static/images/screen4.png',	'[\n    {\n        \"id\": \"5scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 120, \"x\": 0, \"y\": 0, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 1300, \"h\": 120, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/screen_header.png\", \"borderRadius\": 10 }\n            },\n            {\n                \"id\": \"2nws38440fq000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 360, \"y\": 36, \"w\": 500, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"年度排行榜大屏\", \"fontSize\": 20, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"5scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 300, \"h\": 120, \"x\": 0, \"y\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"type\": \"year\",\n                \"filterCharts\": [\n                    {\"chart\": 1085, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1086, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1087, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1088, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1089, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1090, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1091, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1092, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1093, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1094, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1096, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1097, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1098, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1099, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1100, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1101, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1102, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1103, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1104, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1105, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1106, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1107, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1108, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1109, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1110, \"field\": \"t1.`year`\"}\n                ],\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 120, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Select\",\n                \"chartConfig\": { \"key\": \"Select\", \"chartKey\": \"VSelect\", \"conKey\": \"VCSelect\", \"title\": \"选择\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/select-c616737a.png\" },\n                \"option\": { \"dataset\": [ { \"label\": \"请选择\", \"value\": \"\" }, { \"label\": \"河北\", \"value\": \"18700\" }, { \"label\": \"徐州\", \"value\": \"17800\" } ], \"value\": \"\", \"borderWidth\": 1, \"borderStyle\": \"solid\", \"borderColor\": \"#1a77a5\", \"background\": \"none\", \"borderRadius\": 6, \"color\": \"#ffffff\", \"textAlign\": \"center\", \"fontWeight\": \"normal\", \"backgroundColor\": \"transparent\", \"fontSize\": 20, \"onChange\": \"console.log(value)\"}\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"5scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 120, \"x\": 0, \"y\": 100, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2nws38440fq000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 410, \"y\": 36, \"w\": 500, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"项目集\", \"fontSize\": 20, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 0, \"y\": 220, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 0, \"y\": 220, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"预算投入榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 140, \"y\": 430, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"预算投入(万元)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 135, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 155, \"y\": 28, \"w\": 250, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1085,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 380, \"h\": 440, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 6,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 6,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 437, \"y\": 220, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 437, \"y\": 220, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"人员投入榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 155, \"y\": 430, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"人员投入(人)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 135, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 155, \"y\": 28, \"w\": 250, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1086,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 380, \"h\": 440, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 6,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 6,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"fc4u6zmi58w00\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 835, \"y\": 230, \"w\": 20, \"h\": 20, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": 1 },\n        \"styles\": { \"filterShow\": false, \"hueRotate\": 0, \"saturate\": 1, \"contrast\": 1, \"brightness\": 1, \"opacity\": 1, \"rotateZ\": 0, \"rotateX\": 0, \"rotateY\": 0, \"skewX\": 0, \"skewY\": 0, \"blendMode\": \"normal\", \"animations\": [] },\n        \"status\": { \"lock\": false, \"hide\": false },\n        \"request\": { \"requestDataType\": 0, \"requestHttpType\": \"get\", \"requestUrl\": \"\", \"requestInterval\": null, \"requestIntervalUnit\": \"second\", \"requestContentType\": 0, \"requestParamsBodyType\": \"none\", \"requestSQLContent\": { \"sql\": \"select * from  where\" }, \"requestParams\": { \"Body\": { \"form-data\": {}, \"x-www-form-urlencoded\": {}, \"json\": \"\", \"xml\": \"\" }, \"Header\": {}, \"Params\": {} } },\n        \"filter\": null,\n        \"events\": { \"baseEvent\": { \"click\": null, \"dblclick\": null, \"mouseenter\": null, \"mouseleave\": null }, \"advancedEvents\": { \"vnodeMounted\": null, \"vnodeBeforeMount\": null } },\n        \"key\": \"Hint\",\n        \"chartConfig\": { \"key\": \"Hint\", \"chartKey\": \"VHint\", \"conKey\": \"VCHint\", \"title\": \"提示\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/hint-2cbf6381.png\" },\n        \"option\": { \"text\": \"\", \"icon\": \"\", \"textSize\": 15, \"textColor\": \"#ffffff\", \"textWeight\": \"bold\", \"placement\": \"left-top\", \"distance\": 8, \"hint\": \"某项目集某年的人员投入=某年内某项目集中进行过的项目，其团队成员加盟日期为某年的最后一天以及最后一天之前的成员人数之和。\", \"width\": 0, \"height\": 0, \"paddingX\": 16, \"paddingY\": 8, \"borderWidth\": 1, \"borderStyle\": \"solid\", \"borderColor\": \"#1a77a5\", \"borderRadius\": 6, \"color\": \"#ffffff\", \"textAlign\": \"left\", \"fontWeight\": \"normal\", \"backgroundColor\": \"rgba(8, 40, 80, 0.9)\", \"fontSize\": 16 }\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 874, \"y\": 220, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 874, \"y\": 220, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"工时消耗榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 155, \"y\": 430, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"工时消耗(h)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 135, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 155, \"y\": 28, \"w\": 250, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1087,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 380, \"h\": 440, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 6,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 6,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"fc4u6zmi58w00\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 1272, \"y\": 230, \"w\": 20, \"h\": 20, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": 1 },\n        \"styles\": { \"filterShow\": false, \"hueRotate\": 0, \"saturate\": 1, \"contrast\": 1, \"brightness\": 1, \"opacity\": 1, \"rotateZ\": 0, \"rotateX\": 0, \"rotateY\": 0, \"skewX\": 0, \"skewY\": 0, \"blendMode\": \"normal\", \"animations\": [] },\n        \"status\": { \"lock\": false, \"hide\": false },\n        \"request\": { \"requestDataType\": 0, \"requestHttpType\": \"get\", \"requestUrl\": \"\", \"requestInterval\": null, \"requestIntervalUnit\": \"second\", \"requestContentType\": 0, \"requestParamsBodyType\": \"none\", \"requestSQLContent\": { \"sql\": \"select * from  where\" }, \"requestParams\": { \"Body\": { \"form-data\": {}, \"x-www-form-urlencoded\": {}, \"json\": \"\", \"xml\": \"\" }, \"Header\": {}, \"Params\": {} } },\n        \"filter\": null,\n        \"events\": { \"baseEvent\": { \"click\": null, \"dblclick\": null, \"mouseenter\": null, \"mouseleave\": null }, \"advancedEvents\": { \"vnodeMounted\": null, \"vnodeBeforeMount\": null } },\n        \"key\": \"Hint\",\n        \"chartConfig\": { \"key\": \"Hint\", \"chartKey\": \"VHint\", \"conKey\": \"VCHint\", \"title\": \"提示\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/hint-2cbf6381.png\" },\n        \"option\": { \"text\": \"\", \"icon\": \"\", \"textSize\": 15, \"textColor\": \"#ffffff\", \"textWeight\": \"bold\", \"placement\": \"left-top\", \"distance\": 8, \"hint\": \"某项目集年度工时消耗=某年某项目集中进行过的项目的累计工时\", \"width\": 0, \"height\": 0, \"paddingX\": 16, \"paddingY\": 8, \"borderWidth\": 1, \"borderStyle\": \"solid\", \"borderColor\": \"#1a77a5\", \"borderRadius\": 6, \"color\": \"#ffffff\", \"textAlign\": \"left\", \"fontWeight\": \"normal\", \"backgroundColor\": \"rgba(8, 40, 80, 0.9)\", \"fontSize\": 16 }\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 0, \"y\": 740, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 0, \"y\": 740, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"新增需求条目榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 153, \"y\": 430, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"需求条目(个)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 175, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 195, \"y\": 28, \"w\": 210, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1088,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 380, \"h\": 440, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 437, \"y\": 740, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 437, \"y\": 740, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"新增需求规模榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 150, \"y\": 430, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"需求规模(sp)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 175, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 195, \"y\": 28, \"w\": 210, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1089,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 380, \"h\": 440, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 874, \"y\": 740, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 874, \"y\": 740, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"新增Bug条目榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 150, \"y\": 430, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"Bug条目(个)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 177, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 197, \"y\": 28, \"w\": 208, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1090,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 380, \"h\": 440, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 0, \"y\": 1260, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 0, \"y\": 1260, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"完成需求条目榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 170, \"y\": 430, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"工期(天)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 175, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 195, \"y\": 28, \"w\": 210, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1091,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 380, \"h\": 440, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 437, \"y\": 1260, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 437, \"y\": 1260, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \" 完成需求规模榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 150, \"y\": 430, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"需求规模(sp)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 175, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 195, \"y\": 28, \"w\": 210, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1092,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 380, \"h\": 440, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 874, \"y\": 1260, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 874, \"y\": 1260, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"修复Bug条目榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 150, \"y\": 430, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"Bug条目(个)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 177, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 197, \"y\": 28, \"w\": 208, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1093,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 380, \"h\": 440, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"5scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 120, \"x\": 0, \"y\": 1750, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2nws38440fq000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 410, \"y\": 36, \"w\": 500, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"项目\", \"fontSize\": 20, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 0, \"y\": 1870, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 0, \"y\": 1870, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"工期榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 170, \"y\": 430, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"工期(天)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 95, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 115, \"y\": 28, \"w\": 290, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1094,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 380, \"h\": 440, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"fc4u6zmi58w00\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 395, \"y\": 1883, \"w\": 20, \"h\": 20, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": 1 },\n        \"styles\": { \"filterShow\": false, \"hueRotate\": 0, \"saturate\": 1, \"contrast\": 1, \"brightness\": 1, \"opacity\": 1, \"rotateZ\": 0, \"rotateX\": 0, \"rotateY\": 0, \"skewX\": 0, \"skewY\": 0, \"blendMode\": \"normal\", \"animations\": [] },\n        \"status\": { \"lock\": false, \"hide\": false },\n        \"request\": { \"requestDataType\": 0, \"requestHttpType\": \"get\", \"requestUrl\": \"\", \"requestInterval\": null, \"requestIntervalUnit\": \"second\", \"requestContentType\": 0, \"requestParamsBodyType\": \"none\", \"requestSQLContent\": { \"sql\": \"select * from  where\" }, \"requestParams\": { \"Body\": { \"form-data\": {}, \"x-www-form-urlencoded\": {}, \"json\": \"\", \"xml\": \"\" }, \"Header\": {}, \"Params\": {} } },\n        \"filter\": null,\n        \"events\": { \"baseEvent\": { \"click\": null, \"dblclick\": null, \"mouseenter\": null, \"mouseleave\": null }, \"advancedEvents\": { \"vnodeMounted\": null, \"vnodeBeforeMount\": null } },\n        \"key\": \"Hint\",\n        \"chartConfig\": { \"key\": \"Hint\", \"chartKey\": \"VHint\", \"conKey\": \"VCHint\", \"title\": \"提示\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/hint-2cbf6381.png\" },\n        \"option\": { \"text\": \"\", \"icon\": \"\", \"textSize\": 15, \"textColor\": \"#ffffff\", \"textWeight\": \"bold\", \"placement\": \"left-top\", \"distance\": 8, \"hint\": \"未结束项目的工期=当前日期-实际开始日期；\\n已结束项目的工期=实际结束日期-实际开始日期。\", \"width\": 0, \"height\": 0, \"paddingX\": 16, \"paddingY\": 8, \"borderWidth\": 1, \"borderStyle\": \"solid\", \"borderColor\": \"#1a77a5\", \"borderRadius\": 6, \"color\": \"#ffffff\", \"textAlign\": \"left\", \"fontWeight\": \"normal\", \"backgroundColor\": \"rgba(8, 40, 80, 0.9)\", \"fontSize\": 16 }\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 437, \"y\": 1870, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 437, \"y\": 1870, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"工期偏差榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 135, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 155, \"y\": 28, \"w\": 250, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1096,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 380, \"h\": 440, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}%\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"fc4u6zmi58w00\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 835, \"y\": 1883, \"w\": 20, \"h\": 20, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": 1 },\n        \"styles\": { \"filterShow\": false, \"hueRotate\": 0, \"saturate\": 1, \"contrast\": 1, \"brightness\": 1, \"opacity\": 1, \"rotateZ\": 0, \"rotateX\": 0, \"rotateY\": 0, \"skewX\": 0, \"skewY\": 0, \"blendMode\": \"normal\", \"animations\": [] },\n        \"status\": { \"lock\": false, \"hide\": false },\n        \"request\": { \"requestDataType\": 0, \"requestHttpType\": \"get\", \"requestUrl\": \"\", \"requestInterval\": null, \"requestIntervalUnit\": \"second\", \"requestContentType\": 0, \"requestParamsBodyType\": \"none\", \"requestSQLContent\": { \"sql\": \"select * from  where\" }, \"requestParams\": { \"Body\": { \"form-data\": {}, \"x-www-form-urlencoded\": {}, \"json\": \"\", \"xml\": \"\" }, \"Header\": {}, \"Params\": {} } },\n        \"filter\": null,\n        \"events\": { \"baseEvent\": { \"click\": null, \"dblclick\": null, \"mouseenter\": null, \"mouseleave\": null }, \"advancedEvents\": { \"vnodeMounted\": null, \"vnodeBeforeMount\": null } },\n        \"key\": \"Hint\",\n        \"chartConfig\": { \"key\": \"Hint\", \"chartKey\": \"VHint\", \"conKey\": \"VCHint\", \"title\": \"提示\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/hint-2cbf6381.png\" },\n        \"option\": { \"text\": \"\", \"icon\": \"\", \"textSize\": 15, \"textColor\": \"#ffffff\", \"textWeight\": \"bold\", \"placement\": \"left-top\", \"distance\": 8, \"hint\": \"已完成项目的工期偏差率=（实际工期-计划工期）/计划工期*100%；\\n已超期项目的工期偏差率=（（当前日期-实际开始日期）-计划工期）/计划工期*100%。\", \"width\": 0, \"height\": 0, \"paddingX\": 16, \"paddingY\": 8, \"borderWidth\": 1, \"borderStyle\": \"solid\", \"borderColor\": \"#1a77a5\", \"borderRadius\": 6, \"color\": \"#ffffff\", \"textAlign\": \"left\", \"fontWeight\": \"normal\", \"backgroundColor\": \"rgba(8, 40, 80, 0.9)\", \"fontSize\": 16 }\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 874, \"y\": 1870, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 874, \"y\": 1870, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"人员投入榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 155, \"y\": 430, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"人员投入(人)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 135, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 155, \"y\": 28, \"w\": 250, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1097,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 380, \"h\": 440, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 6,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 6,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"fc4u6zmi58w00\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 1272, \"y\": 1883, \"w\": 20, \"h\": 20, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": 1 },\n        \"styles\": { \"filterShow\": false, \"hueRotate\": 0, \"saturate\": 1, \"contrast\": 1, \"brightness\": 1, \"opacity\": 1, \"rotateZ\": 0, \"rotateX\": 0, \"rotateY\": 0, \"skewX\": 0, \"skewY\": 0, \"blendMode\": \"normal\", \"animations\": [] },\n        \"status\": { \"lock\": false, \"hide\": false },\n        \"request\": { \"requestDataType\": 0, \"requestHttpType\": \"get\", \"requestUrl\": \"\", \"requestInterval\": null, \"requestIntervalUnit\": \"second\", \"requestContentType\": 0, \"requestParamsBodyType\": \"none\", \"requestSQLContent\": { \"sql\": \"select * from  where\" }, \"requestParams\": { \"Body\": { \"form-data\": {}, \"x-www-form-urlencoded\": {}, \"json\": \"\", \"xml\": \"\" }, \"Header\": {}, \"Params\": {} } },\n        \"filter\": null,\n        \"events\": { \"baseEvent\": { \"click\": null, \"dblclick\": null, \"mouseenter\": null, \"mouseleave\": null }, \"advancedEvents\": { \"vnodeMounted\": null, \"vnodeBeforeMount\": null } },\n        \"key\": \"Hint\",\n        \"chartConfig\": { \"key\": \"Hint\", \"chartKey\": \"VHint\", \"conKey\": \"VCHint\", \"title\": \"提示\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/hint-2cbf6381.png\" },\n        \"option\": { \"text\": \"\", \"icon\": \"\", \"textSize\": 15, \"textColor\": \"#ffffff\", \"textWeight\": \"bold\", \"placement\": \"left-top\", \"distance\": 8, \"hint\": \"某项目某年的人员投入=某年进行过的项目，其团队成员加盟日期为某年的最后一天以及最后一天之前的成员人数之和。\", \"width\": 0, \"height\": 0, \"paddingX\": 16, \"paddingY\": 8, \"borderWidth\": 1, \"borderStyle\": \"solid\", \"borderColor\": \"#1a77a5\", \"borderRadius\": 6, \"color\": \"#ffffff\", \"textAlign\": \"left\", \"fontWeight\": \"normal\", \"backgroundColor\": \"rgba(8, 40, 80, 0.9)\", \"fontSize\": 16 }\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 0, \"y\": 2390, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 0, \"y\": 2390, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"工时消耗榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 155, \"y\": 430, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"工时消耗(h)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 135, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 155, \"y\": 28, \"w\": 250, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1098,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 380, \"h\": 440, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 437, \"y\": 2390, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 437, \"y\": 2390, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"完成需求条目榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 153, \"y\": 430, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"需求条目(个)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 175, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 195, \"y\": 28, \"w\": 210, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1099,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 380, \"h\": 440, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 874, \"y\": 2390, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 874, \"y\": 2390, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"完成需求规模榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 150, \"y\": 430, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"需求规模(sp)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 175, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 195, \"y\": 28, \"w\": 210, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1100,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 380, \"h\": 440, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"5scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 120, \"x\": 0, \"y\": 2880, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2nws38440fq000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 410, \"y\": 36, \"w\": 500, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"产品\", \"fontSize\": 20, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 0, \"y\": 3000, \"w\": 630, \"h\": 580, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 600, \"h\": 500, \"x\": 0, \"y\": 3000, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"新增需求条目榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 250, \"y\": 515, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"需求条目(个)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 175, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 195, \"y\": 28, \"w\": 400, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1101,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 530, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 670, \"y\": 3000, \"w\": 630, \"h\": 580, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 600, \"h\": 580, \"x\": 670, \"y\": 3000, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"完成需求规模榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 230, \"y\": 515, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"需求规模(sp)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 175, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 195, \"y\": 28, \"w\": 400, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1102,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 530, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 0, \"y\": 3600, \"w\": 630, \"h\": 580, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 600, \"h\": 500, \"x\": 0, \"y\": 3600, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"新增Bug条目榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 250, \"y\": 515, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"Bug条目(个)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 177, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 197, \"y\": 28, \"w\": 400, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1103,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 530, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 670, \"y\": 3600, \"w\": 630, \"h\": 580, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 600, \"h\": 580, \"x\": 670, \"y\": 3600, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"修复Bug条目榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 250, \"y\": 515, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"Bug条目(个)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 175, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 195, \"y\": 28, \"w\": 400, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1104,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 530, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"5scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 120, \"x\": 0, \"y\": 4170, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2nws38440fq000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 410, \"y\": 36, \"w\": 500, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"个人\", \"fontSize\": 20, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 0, \"y\": 4290, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 0, \"y\": 4290, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"创建需求条目榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 153, \"y\": 430, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"需求条目(个)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 175, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 195, \"y\": 28, \"w\": 210, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1105,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 380, \"h\": 440, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 437, \"y\": 4290, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 437, \"y\": 4290, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"创建用例条目榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 153, \"y\": 430, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"用例条目(个)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 175, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 195, \"y\": 28, \"w\": 210, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1106,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 380, \"h\": 440, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 874, \"y\": 4290, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 874, \"y\": 4290, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"创建Bug条目榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 150, \"y\": 430, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"Bug条目(个)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 177, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 197, \"y\": 28, \"w\": 208, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1107,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 380, \"h\": 440, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 0, \"y\": 4810, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 0, \"y\": 4810, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"修复Bug条目榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 150, \"y\": 430, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"Bug条目(个)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 175, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 195, \"y\": 28, \"w\": 210, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1108,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 380, \"h\": 440, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 437, \"y\": 4810, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 437, \"y\": 4810, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"工时消耗榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 155, \"y\": 430, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"工时消耗(h)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 135, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 155, \"y\": 28, \"w\": 250, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1109,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 380, \"h\": 440, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1dlpgwe8wwe800\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 874, \"y\": 4810, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 874, \"y\": 4810, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"禅道操作次数榜\", \"fontSize\": 16, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 153, \"y\": 430, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"操作次数(次)\", \"fontSize\": 10, \"fontColor\": \"#fafafb\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 175, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 195, \"y\": 28, \"w\": 210, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1110,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 40, \"w\": 380, \"h\": 440, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    }\n]\n',	'admin',	'2022-11-18 10:46:18',	'admin',	'2022-11-18 10:46:18',	'0'),
(5,	1,	'迭代燃尽图大屏',	'快速查看公司全部未关闭迭代的燃尽图',	'static/images/screen5.png',	'',	'admin',	'2022-11-18 10:46:18',	'admin',	'2022-11-18 10:46:18',	'0');
