<?php include $app->getModuleRoot() . 'common/view/header.html.php';?>
<?php if(isset($suhosinInfo)):?>
<div class='alert alert-info'><?php echo $suhosinInfo?></div>
<?php elseif(empty($maxImport) and $allCount > $this->config->file->maxImport):?>
<div id="mainContent" class="main-content">
  <div class="main-header">
    <h2><?php echo $lang->bug->import;?></h2>
  </div>
  <p><?php echo sprintf($lang->file->importSummary, $allCount, html::input('maxImport', $config->file->maxImport, "style='width:50px'"), ceil($allCount / $config->file->maxImport));?></p>
  <p><?php echo html::commonButton($lang->import, "id='import'", 'btn btn-primary');?></p>
</div>
<script>
$(function()
{
    $('#maxImport').keyup(function()
    {
        if(parseInt($('#maxImport').val())) $('#times').html(Math.ceil(parseInt($('#allCount').html()) / parseInt($('#maxImport').val())));
    });
    $('#import').click(function(){location.href = createLink('bug', 'showImport', "productID=<?php echo $productID;?>&branch=<?php echo $branch?>&pageID=1&maxImport=" + $('#maxImport').val())})
});
</script>
<?php else:?>
<?php js::set('requiredFields', $requiredFields);?>
<?php js::set('page', 'showImport');?>
<div id="mainContent" class="main-content">
  <div class="main-header clearfix">
    <h2><?php echo $lang->bug->import;?></h2>
  </div>
  <form class='main-form' target='hiddenwin' method='post'>
    <table class='table table-form' id='showData'>
      <thead>
        <tr>
          <th class='w-50px'><?php echo $lang->idAB?></th>
          <th class='w-80px' id='title'><?php echo $lang->bug->title?></th>
          <?php if(!empty($branches)):?>
          <th class='w-100px'><?php echo $lang->bug->branch?></th>
          <?php endif;?>
          <th class='w-80px'  id='module'>     <?php echo $lang->bug->module?></th>
          <th class='w-70px'  id='pri'>        <?php echo $lang->bug->pri?></th>
          <th class='w-70px'  id='keywords'>   <?php echo $lang->bug->keywords?></th>
          <th class='w-120px' id='openedBuild'><?php echo $lang->bug->openedBuild?></th>
          <th class='w-100px' id='deadline'>   <?php echo $lang->bug->deadline?></th>
          <th class='w-100px' id='steps'>      <?php echo $lang->bug->steps?></th>
          <th class='w-220px' id='execution'>  <?php echo $lang->bug->execStory?></th>
          <th class='w-160px <?php echo ((strpos($requiredFields, 'type') !== FALSE) or (strpos($requiredFields, 'severity') !== FALSE)) ? 'required' : ''?>'><?php echo $lang->bug->lblTypeAndSeverity?></th>
          <th class='w-160px <?php echo ((strpos($requiredFields, 'os')   !== FALSE) or (strpos($requiredFields, 'browser')  !== FALSE)) ? 'required' : ''?>'><?php echo $lang->bug->lblSystemBrowserAndHardware?></th>
          <th class='w-140px' id='feedbackBy'><?php echo $lang->bug->feedbackBy?></th>
          <th class='w-140px' id='notifyEmail'><?php echo $lang->bug->notifyEmail?></th>
          <?php
          if(!empty($appendFields))
          {
              foreach($appendFields as $field)
              {
                  if(!$field->show) continue;

                  $width    = ($field->width && $field->width != 'auto' ? $field->width . 'px' : 'auto');
                  $required = strpos(",$field->rules,", ",$notEmptyRule->id,") !== false ? 'required' : '';
                  echo "<th class='$required' style='width: $width'>$field->name</th>";
              }
          }
          ?>
        </tr>
      </thead>
      <tbody>
        <?php
        $insert = true;
        $addID  = 1;
        ?>
        <?php foreach($bugData as $key => $bug):?>
        <tr class='text-top'>
          <td>
            <?php
            if(!empty($bug->id))
            {
                echo '#' . $bug->id . html::hidden("id[$key]", $bug->id);
                $insert = false;
            }
            else
            {
                echo $addID++ . " <sub style='vertical-align:sub;color:gray'>{$lang->bug->new}</sub>";
            }
            echo html::hidden("product[$key]", $productID)
            ?>
          </td>
          <td><?php echo html::input("title[$key]", htmlspecialchars($bug->title, ENT_QUOTES), "class='form-control'")?></td>
          <?php if(!empty($branches)):?>
          <td style='overflow:visible'><?php echo html::select("branch[$key]", $branches, !empty($bug->branch) ? $bug->branch : ((!empty($bug->id) and isset($bugs[$bug->id])) ? $bugs[$bug->id]->branch : ''), "class='form-control chosen' onchange='setImportBranchRelated(this.value, $productID, $key)'")?></td>
          <?php endif;?>
          <td style='overflow:visible'><?php echo html::select("module[$key]", $modules[$key], !empty($bug->module) ? $bug->module : '', "class='form-control chosen'")?></td>
          <td><?php echo html::select("pri[$key]", $lang->bug->priList, !empty($bug->pri) ? $bug->pri : ((!empty($bug->id) and isset($bugs[$bug->id])) ? $bugs[$bug->id]->pri : ''), "class='form-control'")?></td>
          <td><?php echo html::input("keywords[$key]", $bug->keywords, "class='form-control'")?></td>
          <?php
          if(!empty($bug->openedBuild) and !array_key_exists($bug->openedBuild, $builds[$key]))
          {
              $openedBuilds     = explode(';', $bug->openedBuild);
              $bug->openedBuild = array();
              foreach($openedBuilds as $openedBuild)
              {
                  $openedBuild = trim($openedBuild);
                  if($openedBuild == 'trunk')
                  {
                      $bug->openedBuild[] = $openedBuild;
                      continue;
                  }
                  if(isset($flipBuilds[$key][$openedBuild])) $bug->openedBuild[] = $flipBuilds[$key][$openedBuild];
              }
              $bug->openedBuild = join(',', $bug->openedBuild);
          }
          ?>
          <td style='overflow:visible'>
            <div id="openedBuildBox<?php echo $key; ?>"><?php echo html::select("openedBuild[$key][]", $builds[$key], !empty($bug->openedBuild) ? $bug->openedBuild : key($builds[$key]), "multiple=multiple class='form-control chosen'");?></div>
          </td>
          <td><?php echo html::input("deadline[$key]", preg_match('/[1-9]\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])/', $bug->deadline) ? $bug->deadline : '', "class='form-control form-date'");?></td>
          <td><?php echo html::textarea("steps[$key]", $bug->steps, "class='form-control bug-area'")?></td>
          <?php if($config->systemMode == 'new') echo html::hidden("project[$key]", $bug->project);?>
          <td style='overflow:visible'>
            <div class='input-group' id='executionBox'>
              <?php
              $bug->execution = !empty($bug->execution) ? $bug->execution : ((!empty($bug->id) and isset($bugs[$bug->id])) ? $bugs[$bug->id]->execution : $bug->execution);
              echo html::select("execution[$key]", $executions[$key], in_array($bug->execution, $executions[$key]) ? $flipExecutions[$key][$bug->execution] : $bug->execution, "class='form-control chosen' onchange='loadImportExecutionRelated(this.value, {$key}, {$bug->story})'");
              ?>
              <div id="storyIdBox<?php echo $key; ?>"><?php echo html::select("story[$key]", zget($stories, $key, array()), !empty($bug->story) ? $bug->story : '', "class='form-control chosen'")?></div>
            </div>
          </td>
          <td>
            <div class='input-group'>
              <?php echo html::select("type[$key]", $lang->bug->typeList, $bug->type, "class='form-control'");?>
              <span class='input-group-addon'></span>
              <?php
              $severityList = array();
              foreach($lang->bug->severityList as $severKey => $severity) $severityList[$severity] = $lang->bug->severityList[$severKey];
              echo html::select("severity[$key]", $severityList, htmlspecialchars($bug->severity), "class='form-control'");
              ?>
            </div>
          </td>
          <td>
            <div class='input-group'>
              <?php echo html::select("os[$key]", $lang->bug->osList, $bug->os, "class='form-control'");?>
              <span class='input-group-addon'></span>
              <?php echo html::select("browser[$key]", $lang->bug->browserList, $bug->browser, "class='form-control'");?>
            </div>
          </td>
          <td><?php echo html::input("feedbackBy[$key]", $bug->feedbackBy, "class='form-control'")?></td>
          <td><?php echo html::input("notifyEmail[$key]", $bug->notifyEmail, "class='form-control'")?></td>
          <?php
          if(!empty($appendFields))
          {
              $this->loadModel('flow');
              foreach($appendFields as $field)
              {
                  if(!$field->show) continue;
                  $value = $field->defaultValue ? $field->defaultValue : zget($bug, $field->field, '');
                  echo '<td>' . $this->flow->buildControl($field, $value, "$field->field[$key]", true) . '</td>';
              }
          }
          ?>
        </tr>
        <?php endforeach;?>
      </tbody>
      <tfoot>
        <tr>
          <td colspan='<?php echo !empty($branches) ? 12 : 11;?>' class='text-center form-actions'>
            <?php
            $submitText = $isEndPage ? $this->lang->save : $this->lang->file->saveAndNext;
            if(!$insert and $dataInsert === '')
            {
                echo "<button type='button' data-toggle='modal' data-target='#importNoticeModal' class='btn btn-primary btn-wide'>{$submitText}</button>";
            }
            else
            {
                echo html::submitButton($submitText);
                if($dataInsert !== '') echo html::hidden('insert', $dataInsert);
            }
            echo html::hidden('isEndPage', $isEndPage ? 1 : 0);
            echo html::hidden('pagerID', $pagerID);
            echo html::a(inlink('browse', 'productID=' . $productID), $lang->goback, '', "class='btn btn-back btn-wide'");
            echo ' &nbsp; ' . sprintf($lang->file->importPager, $allCount, $pagerID, $allPager);
            ?>
          </td>
        </tr>
      </tfoot>
    </table>
    <?php if(!$insert and $dataInsert === '') include $app->getModuleRoot() . 'common/view/noticeimport.html.php';?>
  </form>
</div>
<?php endif;?>
<script>
$(function()
{
    $.fixedTableHead('#showData');
    $("#showData th").each(function()
    {
        if(requiredFields.indexOf(this.id) !== -1) $("#" + this.id).addClass('required');
    });
});
</script>
<?php include $app->getModuleRoot() . 'common/view/footer.html.php';?>
