<?php
$config->workflowfield->optionControls = array('select', 'multi-select', 'checkbox', 'radio');

$config->workflowfield->require = new stdclass();
$config->workflowfield->require->create = 'name, field, module, control';
$config->workflowfield->require->edit   = 'name, field, control';

$config->workflowfield->disabledFields['subTables'] = 'status,assignedTo,editedBy,editedDate,assignedBy,assignedDate,mailto,deleted';

$config->workflowfield->typeList['integer']['tinyint']   = 'tinyint';
$config->workflowfield->typeList['integer']['smallint']  = 'smallint';
$config->workflowfield->typeList['integer']['mediumint'] = 'mediumint';
$config->workflowfield->typeList['integer']['int']       = 'int';

$config->workflowfield->typeList['decimal']['decimal'] = 'decimal';

$config->workflowfield->typeList['date']['date'] = 'date';

$config->workflowfield->typeList['time']['datetime'] = 'datetime';

$config->workflowfield->typeList['varchar']['char']    = 'char';
$config->workflowfield->typeList['varchar']['varchar'] = 'varchar';

$config->workflowfield->typeList['text']['text'] = 'text';

$config->workflowfield->lengthList[10]  = ',date,';
$config->workflowfield->lengthList[19]  = ',datetime,';
$config->workflowfield->lengthList[200] = ',input,select,radio,checkbox,';

$config->workflowfield->numberTypes = array_merge(array_keys($config->workflowfield->typeList['integer']), array_keys($config->workflowfield->typeList['decimal']));

$config->workflowfield->default = new stdclass();
$config->workflowfield->default->fields = array();
$config->workflowfield->default->fields['id']           = 'mediumint(8) unsigned NOT NULL AUTO_INCREMENT';
$config->workflowfield->default->fields['parent']       = 'mediumint(8) unsigned NOT NULL';
$config->workflowfield->default->fields['assignedTo']   = 'varchar(30) NOT NULL';
$config->workflowfield->default->fields['status']       = 'varchar(30) NOT NULL';
$config->workflowfield->default->fields['createdBy']    = 'varchar(30) NOT NULL';
$config->workflowfield->default->fields['createdDate']  = 'datetime NOT NULL';
$config->workflowfield->default->fields['editedBy']     = 'varchar(30) NOT NULL';
$config->workflowfield->default->fields['editedDate']   = 'datetime NOT NULL';
$config->workflowfield->default->fields['assignedBy']   = 'varchar(30) NOT NULL';
$config->workflowfield->default->fields['assignedDate'] = 'datetime NOT NULL';
$config->workflowfield->default->fields['mailto']       = 'text NOT NULL';
$config->workflowfield->default->fields['deleted']      = "enum('0', '1') NOT NULL DEFAULT '0'";

$config->workflowfield->default->fieldTypes = array();
$config->workflowfield->default->fieldTypes['id']           = 'mediumint';
$config->workflowfield->default->fieldTypes['parent']       = 'mediumint';
$config->workflowfield->default->fieldTypes['createdDate']  = 'datetime';
$config->workflowfield->default->fieldTypes['editedDate']   = 'datetime';
$config->workflowfield->default->fieldTypes['assignedDate'] = 'datetime';
$config->workflowfield->default->fieldTypes['mailto']       = 'text';

$config->workflowfield->default->fieldLength = array();
$config->workflowfield->default->fieldLength['id']           = '8';
$config->workflowfield->default->fieldLength['parent']       = '8';
$config->workflowfield->default->fieldLength['assignedTo']   = '30';
$config->workflowfield->default->fieldLength['status']       = '30';
$config->workflowfield->default->fieldLength['createdBy']    = '30';
$config->workflowfield->default->fieldLength['createdDate']  = '';
$config->workflowfield->default->fieldLength['editedBy']     = '30';
$config->workflowfield->default->fieldLength['editedDate']   = '';
$config->workflowfield->default->fieldLength['assignedBy']   = '30';
$config->workflowfield->default->fieldLength['assignedDate'] = '';
$config->workflowfield->default->fieldLength['mailto']       = '';
$config->workflowfield->default->fieldLength['deleted']      = '10';

$config->workflowfield->default->controls = array();
$config->workflowfield->default->controls['id']           = 'label';
$config->workflowfield->default->controls['parent']       = 'label';
$config->workflowfield->default->controls['assignedTo']   = 'select';
$config->workflowfield->default->controls['status']       = 'select';
$config->workflowfield->default->controls['createdBy']    = 'select';
$config->workflowfield->default->controls['createdDate']  = 'datetime';
$config->workflowfield->default->controls['editedBy']     = 'select';
$config->workflowfield->default->controls['editedDate']   = 'datetime';
$config->workflowfield->default->controls['assignedBy']   = 'select';
$config->workflowfield->default->controls['assignedDate'] = 'datetime';
$config->workflowfield->default->controls['mailto']       = 'multi-select';
$config->workflowfield->default->controls['deleted']      = 'radio';

$config->workflowfield->default->options = array();
$config->workflowfield->default->options['assignedTo'] = 'user';
$config->workflowfield->default->options['createdBy']  = 'user';
$config->workflowfield->default->options['editedBy']   = 'user';
$config->workflowfield->default->options['assignedBy'] = 'user';
$config->workflowfield->default->options['mailto']     = 'user';
$config->workflowfield->default->options['deleted']    = $this->lang->workflowfield->default->options->deleted;

$config->workflowfield->default->values = array();
$config->workflowfield->default->values['parent']  = '0';
$config->workflowfield->default->values['deleted'] = '0';

$config->workflowfield->default->rules = array();
$config->workflowfield->default->rules['id'] = 'unique';

$config->workflowfield->default->readonly = array();
$config->workflowfield->default->readonly['status'] = '0';

$config->workflowfield->default->buildin = array();

$config->workflowfield->default->indexes = 'PRIMARY KEY `id` (`id`)';

$config->workflowfield->default->type          = 'varchar';
$config->workflowfield->default->optionClass   = 'varchar';
$config->workflowfield->default->charLength    = 50;
$config->workflowfield->default->varcharLength = 255;
$config->workflowfield->default->integerDigits = 10;
$config->workflowfield->default->decimalDigits = 2;
$config->workflowfield->default->maxInt        = 2147483647;
$config->workflowfield->default->minInt        = -2147483648;

$config->workflowfield->approval = new stdclass();
$config->workflowfield->approval->fields = array();
$config->workflowfield->approval->fields['reviewers']     = 'text NOT NULL';
$config->workflowfield->approval->fields['reviewOpinion'] = 'text NOT NULL';
$config->workflowfield->approval->fields['reviewStatus']  = "varchar(10) NOT NULL DEFAULT 'wait'";
$config->workflowfield->approval->fields['reviewResult']  = 'varchar(10) NOT NULL';
$config->workflowfield->approval->fields['approval']      = 'mediumint(8) unsigned NOT NULL';

$config->workflowfield->approval->fieldTypes = array();
$config->workflowfield->approval->fieldTypes['reviewers']     = 'text';
$config->workflowfield->approval->fieldTypes['reviewOpinion'] = 'text';
$config->workflowfield->approval->fieldTypes['approval']      = 'mediumint';

$config->workflowfield->approval->fieldLength = array();
$config->workflowfield->approval->fieldLength['reviewers']     = '';
$config->workflowfield->approval->fieldLength['reviewOpinion'] = '';
$config->workflowfield->approval->fieldLength['reviewStatus']  = '10';
$config->workflowfield->approval->fieldLength['reviewResult']  = '10';
$config->workflowfield->approval->fieldLength['approval']      = '8';

$config->workflowfield->approval->controls = array();
$config->workflowfield->approval->controls['reviewers']     = 'multi-select';
$config->workflowfield->approval->controls['reviewOpinion'] = 'textarea';
$config->workflowfield->approval->controls['reviewStatus']  = 'select';
$config->workflowfield->approval->controls['reviewResult']  = 'radio';
$config->workflowfield->approval->controls['approval']      = 'label';

$config->workflowfield->approval->options = array();
$config->workflowfield->approval->options['reviewers']    = 'user';
$config->workflowfield->approval->options['reviewStatus'] = $this->lang->workflowfield->approval->options->reviewStatus;
$config->workflowfield->approval->options['reviewResult'] = $this->lang->workflowfield->approval->options->reviewResult;

$config->workflowfield->approval->values   = array();
$config->workflowfield->approval->rules    = array();
$config->workflowfield->approval->readonly = array();
$config->workflowfield->approval->buildin  = array();

$config->workflowfield->remainFields  = array_merge(array('file', 'actions'), array_keys($config->workflowfield->approval->fields));                             // The system remain fields.
$config->workflowfield->defaultFields = array_merge(array_keys($config->workflowfield->default->fields), array_keys($config->workflowfield->approval->fields));  // The system default fields.

$config->workflowfield->max = new stdclass();
$config->workflowfield->max->charLength    = 255;
$config->workflowfield->max->varcharLength = 1000;
$config->workflowfield->max->integerDigits = 12;
$config->workflowfield->max->decimalDigits = 5;
$config->workflowfield->max->tinyint       = pow(2, 7) - 1;
$config->workflowfield->max->smallint      = pow(2, 15) - 1;
$config->workflowfield->max->mediumint     = pow(2, 23) - 1;
$config->workflowfield->max->int           = pow(2, 31) - 1;

$config->workflowfield->min = new stdclass();
$config->workflowfield->min->charLength    = 1;
$config->workflowfield->min->varcharLength = 1;
$config->workflowfield->min->integerDigits = 1;
$config->workflowfield->min->decimalDigits = 1;
$config->workflowfield->min->tinyint       = -pow(2, 7);
$config->workflowfield->min->smallint      = -pow(2, 15);
$config->workflowfield->min->mediumint     = -pow(2, 23);
$config->workflowfield->min->int           = -pow(2, 31);

$config->workflowfield->formula = new stdclass();
$config->workflowfield->formula->operators['+'] = '＋';
$config->workflowfield->formula->operators['-'] = '－';
$config->workflowfield->formula->operators['*'] = '×';
$config->workflowfield->formula->operators['/'] = '÷';
$config->workflowfield->formula->operators['('] = '(';
$config->workflowfield->formula->operators[')'] = ')';

$config->workflowfield->formula->numbers = array(1, 2, 3, 4, 5, 6, 7, 8, 9, 0, '.');

$config->workflowfield->excel = new stdclass();
$config->workflowfield->excel->templateFields = array('name', 'field', 'control', 'datasource', 'options', 'sql', 'defaultValue');
$config->workflowfield->excel->customWidth    = array('name' => 15, 'field' => 15, 'control' => 15, 'datasource' => 15, 'options' => 20, 'sql' => 20, 'defaultValue' => 15);
$config->workflowfield->excel->listFields     = array('control', 'datasource');

$config->workflowfield->buildin = new stdclass;
$config->workflowfield->buildin->fields['crm']['order']['id']            = array('type' => 'mediumint', 'length' => 8,      'control' => 'integer',      'options' => '',            'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['product']       = array('type' => 'char',      'length' => 255,    'control' => 'multi-select', 'options' => 'product',     'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['customer']      = array('type' => 'mediumint', 'length' => 8,      'control' => 'select',       'options' => 'customer',    'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['quotation']     = array('type' => 'mediumint', 'length' => 8,      'control' => 'select',       'options' => '',            'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['plan']          = array('type' => 'decimal',   'length' => '12,2', 'control' => 'decimal',      'options' => '',            'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['real']          = array('type' => 'decimal',   'length' => '12,2', 'control' => 'decimal',      'options' => '',            'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['currency']      = array('type' => 'varchar',   'length' => 20,     'control' => 'select',       'options' => 'currency',    'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['status']        = array('type' => 'enum',      'length' => '',     'control' => 'select',       'options' => 'orderStatus', 'default' => 'normal');
$config->workflowfield->buildin->fields['crm']['order']['createdBy']     = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',        'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['createdDate']   = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',            'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['editedBy']      = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',        'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['editedDate']    = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',            'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['assignedTo']    = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',        'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['assignedBy']    = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',        'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['assignedDate']  = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',            'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['signedBy']      = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',        'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['signedDate']    = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',            'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['closedBy']      = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',        'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['closedDate']    = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',            'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['closedReason']  = array('type' => 'varchar',   'length' => 10,     'control' => 'select',       'options' => 'orderReason', 'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['activatedBy']   = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',        'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['activatedDate'] = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',            'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['contactedBy']   = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',        'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['contactedDate'] = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',            'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['nextDate']      = array('type' => 'date',      'length' => '',     'control' => 'date',         'options' => '',            'default' => '');
$config->workflowfield->buildin->fields['crm']['order']['deleted']       = array('type' => 'enum',      'length' => '',     'control' => 'select',       'options' => 'deleted',     'default' => '0');

$config->workflowfield->buildin->fields['crm']['contract']['id']            = array('type' => 'mediumint', 'length' => 8,      'control' => 'integer',      'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['type']          = array('type' => 'enum',      'length' => '',     'control' => 'select',       'options' => 'contractType',     'default' => 'sale');
$config->workflowfield->buildin->fields['crm']['contract']['company']       = array('type' => 'mediumint', 'length' => 8,      'control' => 'select',       'options' => 'company',          'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['customer']      = array('type' => 'mediumint', 'length' => 8,      'control' => 'select',       'options' => 'customer',         'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['name']          = array('type' => 'char',      'length' => 100,    'control' => 'input',        'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['code']          = array('type' => 'char',      'length' => 30,     'control' => 'input',        'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['product']       = array('type' => 'char',      'length' => 255,    'control' => 'multi-select', 'options' => 'product',          'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['amount']        = array('type' => 'decimal',   'length' => '12,2', 'control' => 'decimal',      'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['items']         = array('type' => 'text',      'length' => '',     'control' => 'richtext',     'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['begin']         = array('type' => 'date',      'length' => '',     'control' => 'date',         'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['end']           = array('type' => 'date',      'length' => '',     'control' => 'date',         'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['delivery']      = array('type' => 'char',      'length' => 30,     'control' => 'select',       'options' => 'contractDelivery', 'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['return']        = array('type' => 'char',      'length' => 30,     'control' => 'select',       'options' => 'contractReturn',   'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['currency']      = array('type' => 'varchar',   'length' => 20,     'control' => 'select',       'options' => 'currency',         'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['status']        = array('type' => 'enum',      'length' => '',     'control' => 'select',       'options' => 'contractStatus',   'default' => 'normal');
$config->workflowfield->buildin->fields['crm']['contract']['contact']       = array('type' => 'mediumint', 'length' => 8,      'control' => 'select',       'options' => 'contact',          'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['address']       = array('type' => 'mediumint', 'length' => 8,      'control' => 'select',       'options' => 'contractAddress',  'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['handlers']      = array('type' => 'varchar',   'length' => 255,    'control' => 'multi-select', 'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['signedBy']      = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['signedDate']    = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['deliveredBy']   = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['deliveredDate'] = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['returnedBy']    = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['returnedDate']  = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['finishedBy']    = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['finishedDate']  = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['canceledBy']    = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['canceledDate']  = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['createdBy']     = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['createdDate']   = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['editedBy']      = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['editedDate']    = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['contactedBy']   = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['contactedDate'] = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['nextDate']      = array('type' => 'date',      'length' => '',     'control' => 'date',         'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['contract']['deleted']       = array('type' => 'enum',      'length' => '',     'control' => 'select',       'options' => 'deleted',          'default' => '0');

$config->workflowfield->buildin->fields['crm']['purchasecontract']['id']            = array('type' => 'mediumint', 'length' => 8,      'control' => 'integer',      'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['type']          = array('type' => 'enum',      'length' => '',     'control' => 'select',       'options' => 'contractType',     'default' => 'sale');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['company']       = array('type' => 'mediumint', 'length' => 8,      'control' => 'select',       'options' => 'company',          'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['customer']      = array('type' => 'mediumint', 'length' => 8,      'control' => 'select',       'options' => 'provider',         'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['name']          = array('type' => 'char',      'length' => 100,    'control' => 'input',        'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['code']          = array('type' => 'char',      'length' => 30,     'control' => 'input',        'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['product']       = array('type' => 'char',      'length' => 255,    'control' => 'multi-select', 'options' => 'product',          'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['amount']        = array('type' => 'decimal',   'length' => '12,2', 'control' => 'decimal',      'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['items']         = array('type' => 'text',      'length' => '',     'control' => 'richtext',     'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['begin']         = array('type' => 'date',      'length' => '',     'control' => 'date',         'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['end']           = array('type' => 'date',      'length' => '',     'control' => 'date',         'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['delivery']      = array('type' => 'char',      'length' => 30,     'control' => 'select',       'options' => 'contractDelivery', 'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['return']        = array('type' => 'char',      'length' => 30,     'control' => 'select',       'options' => 'contractPay',      'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['currency']      = array('type' => 'varchar',   'length' => 20,     'control' => 'select',       'options' => 'currency',         'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['status']        = array('type' => 'enum',      'length' => '',     'control' => 'select',       'options' => 'contractStatus',   'default' => 'normal');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['contact']       = array('type' => 'mediumint', 'length' => 8,      'control' => 'select',       'options' => 'contact',          'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['address']       = array('type' => 'mediumint', 'length' => 8,      'control' => 'select',       'options' => 'contractAddress',  'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['handlers']      = array('type' => 'varchar',   'length' => 255,    'control' => 'multi-select', 'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['signedBy']      = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['signedDate']    = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['deliveredBy']   = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['deliveredDate'] = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['returnedBy']    = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['returnedDate']  = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['finishedBy']    = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['finishedDate']  = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['canceledBy']    = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['canceledDate']  = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['createdBy']     = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['createdDate']   = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['editedBy']      = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['editedDate']    = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['contactedBy']   = array('type' => 'varchar',   'length' => 30,     'control' => 'select',       'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['contactedDate'] = array('type' => 'datetime',  'length' => '',     'control' => 'datetime',     'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['nextDate']      = array('type' => 'date',      'length' => '',     'control' => 'date',         'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['purchasecontract']['deleted']       = array('type' => 'enum',      'length' => '',     'control' => 'select',       'options' => 'deleted',          'default' => '0');

$config->workflowfield->buildin->fields['crm']['customer']['id']            = array('type' => 'mediumint', 'length' => 8,   'control' => 'integer',  'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['name']          = array('type' => 'char',      'length' => 100, 'control' => 'input',    'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['type']          = array('type' => 'char',      'length' => 30,  'control' => 'select',   'options' => 'customerType',     'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['relation']      = array('type' => 'enum',      'length' => '',  'control' => 'select',   'options' => 'customerRelation', 'default' => 'client');
$config->workflowfield->buildin->fields['crm']['customer']['source']        = array('type' => 'varchar',   'length' => 20,  'control' => 'select',   'options' => 'customerSource',   'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['sourceNote']    = array('type' => 'varchar',   'length' => 255, 'control' => 'input',    'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['size']          = array('type' => 'tinyint',   'length' => 3,   'control' => 'select',   'options' => 'customerSize',     'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['industry']      = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',   'options' => 'industryCategory', 'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['area']          = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',   'options' => 'areaCategory',     'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['status']        = array('type' => 'char',      'length' => 30,  'control' => 'select',   'options' => 'customerStatus',   'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['level']         = array('type' => 'char',      'length' => 10,  'control' => 'select',   'options' => 'customerLevel',    'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['intension']     = array('type' => 'text',      'length' => '',  'control' => 'textarea', 'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['site']          = array('type' => 'varchar',   'length' => 100, 'control' => 'input',    'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['weibo']         = array('type' => 'char',      'length' => 50,  'control' => 'input',    'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['weixin']        = array('type' => 'char',      'length' => 50,  'control' => 'input',    'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['category']      = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',   'options' => 'customerCategory', 'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['desc']          = array('type' => 'text',      'length' => '',  'control' => 'richtext', 'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['depositor']     = array('type' => 'varchar',   'length' => 100, 'control' => 'input',    'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['public']        = array('type' => 'enum',      'length' => '',  'control' => 'select',   'options' => 'public',           'default' => '0');
$config->workflowfield->buildin->fields['crm']['customer']['createdBy']     = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['createdDate']   = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['editedBy']      = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['editedDate']    = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['assignedTo']    = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['assignedBy']    = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['assignedDate']  = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['contactedBy']   = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['contactedDate'] = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['nextDate']      = array('type' => 'date',      'length' => '',  'control' => 'date',     'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['customer']['deleted']       = array('type' => 'enum',      'length' => '',  'control' => 'select',   'options' => 'deleted',          'default' => '0');

$config->workflowfield->buildin->fields['crm']['provider']['id']            = array('type' => 'mediumint', 'length' => 8,   'control' => 'integer',  'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['name']          = array('type' => 'char',      'length' => 100, 'control' => 'input',    'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['type']          = array('type' => 'char',      'length' => 30,  'control' => 'select',   'options' => 'customerType',     'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['relation']      = array('type' => 'enum',      'length' => '',  'control' => 'select',   'options' => 'customerRelation', 'default' => 'provider');
$config->workflowfield->buildin->fields['crm']['provider']['source']        = array('type' => 'varchar',   'length' => 20,  'control' => 'select',   'options' => 'customerSource',   'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['sourceNote']    = array('type' => 'varchar',   'length' => 255, 'control' => 'input',    'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['size']          = array('type' => 'tinyint',   'length' => 3,   'control' => 'select',   'options' => 'customerSize',     'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['industry']      = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',   'options' => 'industryCategory', 'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['area']          = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',   'options' => 'areaCategory',     'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['status']        = array('type' => 'char',      'length' => 30,  'control' => 'select',   'options' => 'customerStatus',   'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['level']         = array('type' => 'char',      'length' => 10,  'control' => 'select',   'options' => 'customerLevel',    'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['intension']     = array('type' => 'text',      'length' => '',  'control' => 'textarea', 'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['site']          = array('type' => 'varchar',   'length' => 100, 'control' => 'input',    'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['weibo']         = array('type' => 'char',      'length' => 50,  'control' => 'input',    'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['weixin']        = array('type' => 'char',      'length' => 50,  'control' => 'input',    'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['category']      = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',   'options' => 'providerCategory', 'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['desc']          = array('type' => 'text',      'length' => '',  'control' => 'richtext', 'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['depositor']     = array('type' => 'varchar',   'length' => 100, 'control' => 'input',    'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['public']        = array('type' => 'enum',      'length' => '',  'control' => 'select',   'options' => 'public',           'default' => '0');
$config->workflowfield->buildin->fields['crm']['provider']['createdBy']     = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['createdDate']   = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['assignedTo']    = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['assignedBy']    = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['assignedDate']  = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['editedBy']      = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['editedDate']    = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['contactedBy']   = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['contactedDate'] = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['nextDate']      = array('type' => 'date',      'length' => '',  'control' => 'date',     'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['provider']['deleted']       = array('type' => 'enum',      'length' => '',  'control' => 'select',   'options' => 'deleted',          'default' => '0');

$config->workflowfield->buildin->fields['crm']['contact']['id']            = array('type' => 'mediumint', 'length' => 8,   'control' => 'integer',  'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['realname']      = array('type' => 'char',      'length' => 30,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['nickname']      = array('type' => 'char',      'length' => 30,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['resume']        = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',   'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['origin']        = array('type' => 'varchar',   'length' => 150, 'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['originAccount'] = array('type' => 'varchar',   'length' => 255, 'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['status']        = array('type' => 'enum',      'length' => '',  'control' => 'select',   'options' => 'contactStatus', 'default' => 'normal');
$config->workflowfield->buildin->fields['crm']['contact']['avatar']        = array('type' => 'varchar',   'length' => 255, 'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['birthday']      = array('type' => 'date',      'length' => '',  'control' => 'date',     'options' => '',              'default' => '0000-00-00');
$config->workflowfield->buildin->fields['crm']['contact']['gender']        = array('type' => 'enum',      'length' => '',  'control' => 'select',   'options' => 'gender',        'default' => 'u');
$config->workflowfield->buildin->fields['crm']['contact']['email']         = array('type' => 'char',      'length' => 50,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['skype']         = array('type' => 'char',      'length' => 50,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['qq']            = array('type' => 'char',      'length' => 20,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['yahoo']         = array('type' => 'char',      'length' => 50,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['gtalk']         = array('type' => 'char',      'length' => 50,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['wangwang']      = array('type' => 'char',      'length' => 50,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['site']          = array('type' => 'varchar',   'length' => 100, 'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['mobile']        = array('type' => 'char',      'length' => 11,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['phone']         = array('type' => 'char',      'length' => 20,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['company']       = array('type' => 'varchar',   'length' => 255, 'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['fax']           = array('type' => 'char',      'length' => 20,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['weibo']         = array('type' => 'char',      'length' => 50,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['weixin']        = array('type' => 'char',      'length' => 50,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['register']      = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['last']          = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['visits']        = array('type' => 'mediumint', 'length' => 8,   'control' => 'integer',  'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['ip']            = array('type' => 'char',      'length' => 50,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['desc']          = array('type' => 'text',      'length' => '',  'control' => 'textarea', 'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['createdBy']     = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',          'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['createdDate']   = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['assignedTo']    = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',          'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['assignedBy']    = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',          'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['assignedDate']  = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['editedBy']      = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',          'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['editedDate']    = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['contactedBy']   = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',          'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['contactedDate'] = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['ignoredBy']     = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',          'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['ignoredDate']   = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['nextDate']      = array('type' => 'date',      'length' => '',  'control' => 'date',     'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['contact']['deleted']       = array('type' => 'enum',      'length' => '',  'control' => 'select',   'options' => 'deleted',       'default' => '0');

$config->workflowfield->buildin->fields['crm']['leads']['id']            = array('type' => 'mediumint', 'length' => 8,   'control' => 'integer',  'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['realname']      = array('type' => 'char',      'length' => 30,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['nickname']      = array('type' => 'char',      'length' => 30,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['resume']        = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',   'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['origin']        = array('type' => 'varchar',   'length' => 150, 'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['originAccount'] = array('type' => 'varchar',   'length' => 255, 'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['status']        = array('type' => 'enum',      'length' => '',  'control' => 'select',   'options' => 'leadsStatus',   'default' => 'normal');
$config->workflowfield->buildin->fields['crm']['leads']['avatar']        = array('type' => 'varchar',   'length' => 255, 'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['birthday']      = array('type' => 'date',      'length' => '',  'control' => 'date',     'options' => '',              'default' => '0000-00-00');
$config->workflowfield->buildin->fields['crm']['leads']['gender']        = array('type' => 'enum',      'length' => '',  'control' => 'select',   'options' => 'gender',        'default' => 'u');
$config->workflowfield->buildin->fields['crm']['leads']['email']         = array('type' => 'char',      'length' => 50,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['skype']         = array('type' => 'char',      'length' => 50,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['qq']            = array('type' => 'char',      'length' => 20,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['yahoo']         = array('type' => 'char',      'length' => 50,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['gtalk']         = array('type' => 'char',      'length' => 50,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['wangwang']      = array('type' => 'char',      'length' => 50,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['site']          = array('type' => 'varchar',   'length' => 100, 'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['mobile']        = array('type' => 'char',      'length' => 11,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['phone']         = array('type' => 'char',      'length' => 20,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['company']       = array('type' => 'varchar',   'length' => 255, 'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['fax']           = array('type' => 'char',      'length' => 20,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['weibo']         = array('type' => 'char',      'length' => 50,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['weixin']        = array('type' => 'char',      'length' => 50,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['register']      = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['last']          = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['visits']        = array('type' => 'mediumint', 'length' => 8,   'control' => 'integer',  'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['ip']            = array('type' => 'char',      'length' => 50,  'control' => 'input',    'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['desc']          = array('type' => 'text',      'length' => '',  'control' => 'textarea', 'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['createdBy']     = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',          'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['createdDate']   = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['assignedTo']    = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',          'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['assignedBy']    = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',          'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['assignedDate']  = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['editedBy']      = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',          'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['editedDate']    = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['contactedBy']   = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',          'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['contactedDate'] = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['ignoredBy']     = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',          'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['ignoredDate']   = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['nextDate']      = array('type' => 'date',      'length' => '',  'control' => 'date',     'options' => '',              'default' => '');
$config->workflowfield->buildin->fields['crm']['leads']['deleted']       = array('type' => 'enum',      'length' => '',  'control' => 'select',   'options' => 'deleted',       'default' => '0');

$config->workflowfield->buildin->fields['crm']['product']['id']          = array('type' => 'mediumint', 'length' => 8,      'control' => 'integer',  'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['product']['name']        = array('type' => 'varchar',   'length' => 150,    'control' => 'input',    'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['product']['code']        = array('type' => 'varchar',   'length' => 20,     'control' => 'input',    'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['product']['type']        = array('type' => 'varchar',   'length' => 10,     'control' => 'select',   'options' => 'productType',     'default' => '');
$config->workflowfield->buildin->fields['crm']['product']['category']    = array('type' => 'mediumint', 'length' => 8,      'control' => 'select',   'options' => 'productCategory', 'default' => '');
$config->workflowfield->buildin->fields['crm']['product']['subject']     = array('type' => 'mediumint', 'length' => 8,      'control' => 'select',   'options' => 'productSubject',  'default' => '');
$config->workflowfield->buildin->fields['crm']['product']['order']       = array('type' => 'smallint',  'length' => 5,      'control' => 'integer',  'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['product']['pinyin']      = array('type' => 'char',      'length' => 200,    'control' => 'input',    'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['product']['model']       = array('type' => 'mediumint', 'length' => 8,      'control' => 'select',   'options' => 'productModel',    'default' => '');
$config->workflowfield->buildin->fields['crm']['product']['unit']        = array('type' => 'mediumint', 'length' => 8,      'control' => 'select',   'options' => 'productUnit',     'default' => '');
$config->workflowfield->buildin->fields['crm']['product']['barcode']     = array('type' => 'char',      'length' => 30,     'control' => 'input',    'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['product']['brand']       = array('type' => 'varchar',   'length' => 100,    'control' => 'input',    'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['product']['store']       = array('type' => 'smallint',  'length' => 5,      'control' => 'select',   'options' => 'store',           'default' => '');
$config->workflowfield->buildin->fields['crm']['product']['price']       = array('type' => 'decimal',   'length' => '12,2', 'control' => 'decimal',  'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['product']['amount']      = array('type' => 'decimal',   'length' => '12,2', 'control' => 'decimal',  'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['product']['status']      = array('type' => 'varchar',   'length' => 10,     'control' => 'select',   'options' => 'productStatus',   'default' => '');
$config->workflowfield->buildin->fields['crm']['product']['desc']        = array('type' => 'text',      'length' => '',     'control' => 'textarea', 'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['product']['createdBy']   = array('type' => 'varchar',   'length' => 30,     'control' => 'select',   'options' => 'user',            'default' => '');
$config->workflowfield->buildin->fields['crm']['product']['createdDate'] = array('type' => 'datetime',  'length' => '',     'control' => 'datetime', 'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['product']['editedBy']    = array('type' => 'varchar',   'length' => 30,     'control' => 'select',   'options' => 'user',            'default' => '');
$config->workflowfield->buildin->fields['crm']['product']['editedDate']  = array('type' => 'datetime',  'length' => '',     'control' => 'datetime', 'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['product']['deleted']     = array('type' => 'enum',      'length' => '',     'control' => 'select',   'options' => 'deleted',         'default' => '0');

$config->workflowfield->buildin->fields['crm']['invoice']['id']              = array('type' => 'mediumint', 'length' => 8,      'control' => 'integer',  'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['sn']              = array('type' => 'varchar',   'length' => 20,     'control' => 'input',    'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['company']         = array('type' => 'mediumint', 'length' => 8,      'control' => 'select',   'options' => 'company',         'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['customer']        = array('type' => 'mediumint', 'length' => 8,      'control' => 'select',   'options' => 'allCustomer',     'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['contract']        = array('type' => 'mediumint', 'length' => 8,      'control' => 'select',   'options' => 'allContract',     'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['contact']         = array('type' => 'mediumint', 'length' => 8,      'control' => 'select',   'options' => 'contact',         'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['address']         = array('type' => 'mediumint', 'length' => 8,      'control' => 'select',   'options' => 'customerAddress', 'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['money']           = array('type' => 'decimal',   'length' => '12,2', 'control' => 'decimal',  'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['kind']            = array('type' => 'enum',      'length' => '',     'control' => 'select',   'options' => 'invoiceKind',     'default' => 'sale');
$config->workflowfield->buildin->fields['crm']['invoice']['type']            = array('type' => 'varchar',   'length' => 30,     'control' => 'select',   'options' => 'invoiceType',     'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['saleType']        = array('type' => 'varchar',   'length' => 30,     'control' => 'select',   'options' => 'invoiceSaleType', 'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['taxRate']         = array('type' => 'tinyint',   'length' => 3,      'control' => 'integer',  'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['invoiceTitle']    = array('type' => 'varchar',   'length' => 100,    'control' => 'input',    'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['taxNumber']       = array('type' => 'varchar',   'length' => 20,     'control' => 'input',    'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['registedAddress'] = array('type' => 'varchar',   'length' => 90,     'control' => 'input',    'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['phone']           = array('type' => 'varchar',   'length' => 50,     'control' => 'input',    'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['bankName']        = array('type' => 'varchar',   'length' => 100,    'control' => 'input',    'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['bankAccount']     = array('type' => 'varchar',   'length' => 30,     'control' => 'input',    'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['express']         = array('type' => 'varchar',   'length' => 30,     'control' => 'input',    'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['waybill']         = array('type' => 'varchar',   'length' => 30,     'control' => 'input',    'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['sendway']         = array('type' => 'varchar',   'length' => 30,     'control' => 'select',   'options' => 'invoiceSendway',  'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['sendAccount']     = array('type' => 'varchar',   'length' => 100,    'control' => 'input',    'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['status']          = array('type' => 'varchar',   'length' => 30,     'control' => 'select',   'options' => 'invoiceStatus',   'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['desc']            = array('type' => 'text',      'length' => '',     'control' => 'textarea', 'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['createdBy']       = array('type' => 'varchar',   'length' => 30,     'control' => 'select',   'options' => 'user',            'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['createdDate']     = array('type' => 'datetime',  'length' => '',     'control' => 'datetime', 'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['editedBy']        = array('type' => 'varchar',   'length' => 30,     'control' => 'select',   'options' => 'user',            'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['editedDate']      = array('type' => 'datetime',  'length' => '',     'control' => 'datetime', 'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['receivedBy']      = array('type' => 'varchar',   'length' => 30,     'control' => 'select',   'options' => 'user',            'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['receivedDate']    = array('type' => 'datetime',  'length' => '',     'control' => 'datetime', 'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['checkedBy']       = array('type' => 'varchar',   'length' => 30,     'control' => 'select',   'options' => 'user',            'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['checkedDate']     = array('type' => 'datetime',  'length' => '',     'control' => 'datetime', 'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['drawnBy']         = array('type' => 'varchar',   'length' => 30,     'control' => 'select',   'options' => 'user',            'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['drawnDate']       = array('type' => 'datetime',  'length' => '',     'control' => 'datetime', 'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['expressedBy']     = array('type' => 'varchar',   'length' => 30,     'control' => 'select',   'options' => 'user',            'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['expressedDate']   = array('type' => 'datetime',  'length' => '',     'control' => 'datetime', 'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['taxRefundedBy']   = array('type' => 'varchar',   'length' => 30,     'control' => 'select',   'options' => 'user',            'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['taxRefundedDate'] = array('type' => 'datetime',  'length' => '',     'control' => 'datetime', 'options' => '',                'default' => '');
$config->workflowfield->buildin->fields['crm']['invoice']['deleted']         = array('type' => 'enum',      'length' => '',     'control' => 'select',   'options' => 'deleted',         'default' => '0');

$config->workflowfield->buildin->fields['crm']['feedback']['id']             = array('type' => 'mediumint', 'length' => 8,   'control' => 'integer',  'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['product']        = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',   'options' => 'product',          'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['category']       = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',   'options' => 'feedbackCategory', 'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['customer']       = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',   'options' => 'allCustomer',         'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['contact']        = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',   'options' => 'contact',          'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['pri']            = array('type' => 'tinyint',   'length' => 3,   'control' => 'select',   'options' => 'feedbackPri',      'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['title']          = array('type' => 'varchar',   'length' => 255, 'control' => 'input',    'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['desc']           = array('type' => 'text',      'length' => '',  'control' => 'textarea', 'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['type']           = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'feedbackType',     'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['status']         = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'feedbackStatus',   'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['createdBy']      = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['createdDate']    = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['viewedDate']     = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['assignedTo']     = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['assignedBy']     = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['assignedDate']   = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['repliedBy']      = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['repliedDate']    = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['transferedBy']   = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['transferedDate'] = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['editedBy']       = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['editedDate']     = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['closedBy']       = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['closedDate']     = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['closedReason']   = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'feedbackReason',   'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['activatedBy']    = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => 'user',             'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['activatedDate']  = array('type' => 'datetime',  'length' => '',  'control' => 'datetime', 'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['toObjectType']   = array('type' => 'varchar',   'length' => 30,  'control' => 'select',   'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['toObjectID']     = array('type' => 'mediumint', 'length' => 8,   'control' => 'select',   'options' => '',                 'default' => '');
$config->workflowfield->buildin->fields['crm']['feedback']['deleted']        = array('type' => 'enum',      'length' => '',  'control' => 'select',   'options' => 'deleted',          'default' => '0');
