$(function()
{
    $('[name^=story]').each(function()
    {
        var width = $(this).parents('td').width();
        $(this).next('.chosen-container').find('.chosen-single').css('min-width', width / 2);
    });

    $("[name^='product']").each(function()
    {
        var id = $(this).attr('id');
        $(this).attr('id', 'product' + id.match(/\d+/));
    });

    $("[name^='project']").each(function()
    {
        var id = $(this).attr('id');
        $(this).attr('id', 'project' + id.match(/\d+/));
    });

    $("[name^='branch']").each(function()
    {
        var id = $(this).attr('id');
        $(this).attr('id', 'branch' + id.match(/\d+/));
    });
})

/**
 * Load import execution related tasks and build.
 *
 * @param  int    executionID
 * @param  int    num
 * @param  int    storyID
 * @access public
 * @return void
 */
function loadImportExecutionRelated(executionID, num, storyID)
{
    oldStoryID  = storyID;
    executionID = parseInt(executionID);
    loadExecutionStories(executionID, num);
    loadExecutionBuilds(executionID, num);
}

/**
 * Set import branch related.
 *
 * @param  int     branchID
 * @param  int     productID
 * @param  int     num
 * @access public
 * @return void
 */
function setImportBranchRelated(branchID, productID, num)
{
    var projectID       = $('#project' + num).val();
    var currentModuleID = config.currentMethod == 'batchedit' ? $('#module' + num).val() : 0;
    var moduleLink      = createLink('tree', 'ajaxGetModules', 'productID=' + productID + '&viewType=bug&branch=' + branchID + '&num=' + num + '&currentModuleID=' + currentModuleID + '&from=showImport');
    $.get(moduleLink, function(module)
    {
        if(!module) module = '<select id="module' + num + '" name="module[' + num + ']" class="form-control chosen"></select>';
        $('#module' + num).replaceWith(module);
        $("#module" + num + "_chosen").remove();
        $("#module" + num).next('.picker').remove();
        $("#module" + num).chosen();
    });

    var executionLink = createLink('product', 'ajaxGetExecutions', 'productID=' + productID + '&projectID=' + projectID + '&branch=' + branchID + '&num=' + num + '&executionID=0&from=showImport');
    $.get(executionLink, function(execution)
    {
        if(!execution) execution = '<select id="execution' + num + '" name="execution[' + num + ']" class="form-control chosen"></select>';
        $('#execution' + num).replaceWith(execution);
        $("#execution" + num + "_chosen").remove();
        $("#execution" + num).next('.picker').remove();
        $("#execution" + num).chosen();
    });
}
