<?php
/**
 * 此文件包括ZenTaoPHP框架的三个类：router, config, lang。
 * The router, config and lang class file of ZenTaoPHP framework.
 *
 * The author disclaims copyright to this source code. In place of
 * a legal notice, here is a blessing:
 *
 *  May you do good and not evil.
 *  May you find forgiveness for yourself and forgive others.
 *  May you share freely, never taking more than you give.
 */

/**
 * router类。
 * The router class.
 *
 * @package framework
 */
include dirname(__FILE__) . '/base/router.class.php';
class router extends baseRouter
{
    /**
     * 请求的原始参数。
     * The requested params parsed from a URL.
     *
     * @var array
     * @access public
     */
    public $rawParams;

    /**
     * 原始URI
     *
     * @var string
     * @access public
     */
    public $rawURI;

    /**
     * 标记是否是工作流
     * Whether the tag is a workflow
     *
     * @var bool
     * @access public
     */
    public $isFlow = false;

    /**
     * Get the $moduleRoot var.
     *
     * @param  string $appName
     * @access public
     * @return string
     */
    public function getModuleRoot($appName = '')
    {
        return $this->moduleRoot;
    }

    /**
     * Merge system and translated langs.
     *
     * @param   string $lang  zh-cn|zh-tw|en
     * @access  public
     * @return  void
     */
    public function setClientLang($lang = '')
    {
        if($this->dbh)
        {
            $langs = $this->dbh->query('SELECT value FROM' . TABLE_CONFIG . "WHERE `owner`='system' AND `module`='common' AND `section`='global' AND `key`='langs'")->fetch();
            $langs = empty($langs) ? array() : json_decode($langs->value, true);
            foreach($langs as $langKey => $langData) $this->config->langs[$langKey] = $langData['name'];
        }
        return parent::setClientLang($lang);
    }

    /**
     * 企业版部分功能是从然之合并过来的。然之代码中调用loadLang方法时传递了一个非空的appName，在禅道中会导致错误。
     * 把appName设置为空来避免这个错误。
     * Some codes merged from ranzhi called the function loadLang with a non-empty appName which causes an error in zentao.
     * Set the value of appName to empty to avoid this error.
     *
     * @param   string $moduleName  the module name
     * @param   string $appName     the app name
     * @access  public
     * @return  bool|object the lang object or false.
     */
    public function loadLang($moduleName, $appName = '')
    {
        global $lang;
        if(!is_object($lang)) $lang = new language();

        $appName = '';

        /* Set productCommon and projectCommon for flow. */
        if($moduleName == 'common') $this->setCommonLang();

        parent::loadLang($moduleName, $appName);

        /* Merge from the db lang. */
        if($moduleName != 'common' and isset($lang->db->custom[$moduleName]))
        {
            foreach($lang->db->custom[$moduleName] as $section => $fields)
            {
                if(isset($lang->{$moduleName}->{$section}['']))
                {
                    $nullKey   = '';
                    $nullValue = $lang->{$moduleName}->{$section}[$nullKey];
                }
                elseif(isset($lang->{$moduleName}->{$section}[0]))
                {
                    $nullKey   = 0;
                    $nullValue = $lang->{$moduleName}->{$section}[0];
                }
                unset($lang->{$moduleName}->{$section});

                if(isset($nullKey))$lang->{$moduleName}->{$section}[$nullKey] = $nullValue;
                foreach($fields as $key => $value)
                {
                    if(!isset($lang->{$moduleName})) $lang->{$moduleName} = new stdclass();
                    if(!isset($lang->{$moduleName}->{$section})) $lang->{$moduleName}->{$section} = array();
                    $lang->{$moduleName}->{$section}[$key] = $value;
                }
                unset($nullKey);
                unset($nullValue);
            }
        }

        return $lang;
    }

    /**
     * Set common lang.
     *
     * @access public
     * @return void
     */
    public function setCommonLang()
    {
        if(defined('COMMONLANGSETTED')) return true;
        define('COMMONLANGSETTED', true);

        if(!defined('ITERATION_KEY'))     define('ITERATION_KEY', 0);
        if(!defined('SPRINT_KEY'))        define('SPRINT_KEY', 1);
        if(!defined('PRODUCT_KEY'))       define('PRODUCT_KEY', 0);
        if(!defined('PROJECT_KEY'))       define('PROJECT_KEY', 0);
        if(!defined('STORYPOINT_KEY'))    define('STORYPOINT_KEY', 1);
        if(!defined('FUNCTIONPOINT_KEY')) define('FUNCTIONPOINT_KEY', 2);

        global $lang, $app, $config;
        $sprintConcept  = $hourPoint = false;
        $commonSettings = array();
        /* Get config from DB. */
        if($this->dbh and !empty($this->config->db->name))
        {
            if(!isset($config->global)) $config->global = new stdclass();
            $config->global->flow = 'full';

            try
            {
                $commonSettings = $this->dbh->query('SELECT section, `key`, value FROM' . TABLE_CONFIG . "WHERE `owner`='system' AND (`module`='custom' or `module`='common') and `key` in ('sprintConcept', 'hourPoint', 'URSR', 'mode', 'URAndSR', 'scoreStatus')")->fetchAll();
            }
            catch (PDOException $exception)
            {
                helper::checkDB2Repair($exception);
            }
        }

        $hourKey = $planKey = $URSR = $URAndSR = 0;

        $mode       = 'new';
        $score      = '0';
        $projectKey = ITERATION_KEY;

        foreach($commonSettings as $setting)
        {
            if($setting->key == 'sprintConcept') $projectKey = $setting->value;
            if($setting->key == 'hourPoint')     $hourKey    = $setting->value;
            if($setting->key == 'URSR')          $URSR       = $setting->value;
            if($setting->key == 'URAndSR')       $URAndSR    = $setting->value;
            if($setting->key == 'mode' and $setting->section == 'global') $mode = $setting->value;
            if($setting->key == 'scoreStatus' and $setting->section == 'global') $score = $setting->value;
        }

        /* Lite Version is compatible with classic modes */
        if($config->vision == 'lite') $mode = 'new';

        /* Record system mode. */
        $config->systemMode = $mode;
        if($config->systemMode == 'classic') $this->config->executionCommonList = $this->config->projectCommonList;

        /* Record system score.*/
        $config->systemScore = $score;

        /* Record hour unit. */
        $config->hourUnit = 'h';
        if($hourKey == STORYPOINT_KEY)    $config->hourUnit = 'sp';
        if($hourKey == FUNCTIONPOINT_KEY) $config->hourUnit = 'fp';

        $iterationKey = $projectKey;

        /* Set productCommon, projectCommon and hourCommon. Default english lang. */
        $lang->productCommon   = $this->config->productCommonList[$this->clientLang][PRODUCT_KEY];
        $lang->projectCommon   = $this->config->projectCommonList[$this->clientLang][PROJECT_KEY];
        $lang->iterationCommon = isset($this->config->executionCommonList[$this->clientLang][(int)$iterationKey]) ? $this->config->executionCommonList[$this->clientLang][(int)$iterationKey] : $this->config->executionCommonList['en'][(int)$iterationKey];
        $lang->executionCommon = isset($this->config->executionCommonList[$this->clientLang][(int)$projectKey]) ? $this->config->executionCommonList[$this->clientLang][(int)$projectKey] : $this->config->executionCommonList['en'][(int)$projectKey];
        $lang->hourCommon      = isset($this->config->hourPointCommonList[$this->clientLang][(int)$hourKey]) ? $this->config->hourPointCommonList[$this->clientLang][(int)$hourKey] : $this->config->hourPointCommonList['en'][(int)$hourKey];

        /* User preference init. */
        $config->URSR          = $URSR;
        $config->URAndSR       = $URAndSR;
        $config->programLink   = 'program-browse';
        $config->productLink   = 'product-all';
        $config->projectLink   = 'project-browse';
        $config->executionLink = 'execution-task';

        /* Get user preference. */
        $account     = isset($this->session->user->account) ? $this->session->user->account : '';
        $userSetting = array();
        if($this->dbh and !empty($this->config->db->name)) $userSetting = $this->dbh->query('SELECT `key`, value FROM' . TABLE_CONFIG . "WHERE `owner`='{$account}' AND `module`='common' and `key` in ('programLink', 'productLink', 'projectLink', 'executionLink', 'URSR')")->fetchAll();
        foreach($userSetting as $setting)
        {
             if($setting->key == 'URSR')          $config->URSR          = $setting->value;
             if($setting->key == 'programLink')   $config->programLink   = $setting->value;
             if($setting->key == 'productLink')   $config->productLink   = $setting->value;
             if($setting->key == 'projectLink')   $config->projectLink   = $setting->value;
             if($setting->key == 'executionLink') $config->executionLink = $setting->value;
        }

        $lang->URCommon = '';
        $lang->SRCommon = '';
        if($this->dbh and !empty($this->config->db->name))
        {
            $productProject = $this->dbh->query('SELECT value FROM' . TABLE_CONFIG . "WHERE `owner`='system' AND `module`='custom' AND `key`='productProject'")->fetch();
            if($productProject)
            {
                $productProject = $productProject->value;
                list($productCommon, $projectCommon) = explode('_', $productProject);
                $lang->productCommon = isset($this->config->productCommonList[$this->clientLang][(int)$productCommon]) ? $this->config->productCommonList[$this->clientLang][(int)$productCommon] : $this->config->productCommonList['en'][0];
                $lang->projectCommon = isset($this->config->projectCommonList[$this->clientLang][(int)$projectCommon]) ? $this->config->projectCommonList[$this->clientLang][(int)$projectCommon] : $this->config->projectCommonList['en'][0];
            }
            if(!defined('IN_UPGRADE'))
            {
                /* Get story concept in project and product. */
                $clientLang = $this->clientLang == 'zh-tw' ? 'zh-cn' : $this->clientLang;
                $URSRList   = $this->dbh->query('SELECT `key`, `value` FROM' . TABLE_LANG . "WHERE module = 'custom' and section = 'URSRList' and `lang` = \"{$clientLang}\"")->fetchAll();
                if(empty($URSRList)) $URSRList = $this->dbh->query('SELECT `key`, `value` FROM' . TABLE_LANG . "WHERE module = 'custom' and section = 'URSRList' and `key` = \"{$config->URSR}\"")->fetchAll();

                /* Get UR pairs and SR pairs. */
                $URPairs  = array();
                $SRPairs  = array();
                foreach($URSRList as $id => $value)
                {
                    $URSR = json_decode($value->value);
                    $URPairs[$value->key] = $URSR->URName;
                    $SRPairs[$value->key] = $URSR->SRName;
                }

                /* Set default story concept and init UR and SR concept. */
                $lang->URCommon = isset($URPairs[$config->URSR]) ? $URPairs[$config->URSR] : reset($URPairs);
                $lang->SRCommon = isset($SRPairs[$config->URSR]) ? $SRPairs[$config->URSR] : reset($SRPairs);
            }
        }
    }

    /**
     * Save error info.
     *
     * @param  int    $level
     * @param  string $message
     * @param  string $file
     * @param  int    $line
     * @access public
     * @return void
     */
    public function saveError($level, $message, $file, $line)
    {
        $fatalLevel[E_ERROR]      = E_ERROR;
        $fatalLevel[E_PARSE]      = E_PARSE;
        $fatalLevel[E_CORE_ERROR] = E_CORE_ERROR;
        $fatalLevel[E_USER_ERROR] = E_USER_ERROR;
        if(isset($fatalLevel[$level])) $this->config->debug = true;
        parent::saveError($level, $message, $file, $line);
    }

    /**
     * 企业版部分功能是从然之合并过来的。然之代码中调用loadModuleConfig方法时传递了一个非空的appName，在禅道中会导致错误。
     * 把appName设置为空来避免这个错误。
     * Some codes merged from ranzhi called the function loadModuleConfig with a non-empty appName which causes an error in zentao.
     * Set the value of appName to empty to avoid this error.
     *
     * @param   string $moduleName     module name
     * @param   string $appName        app name
     * @param   bool   $exitIfNone     exit or not
     * @access  public
     * @return  object|bool the config object or false.
     */
    public function loadModuleConfig($moduleName, $appName = '')
    {
        global $config;

        $appName = '';

        if($config and (!isset($config->$moduleName) or !is_object($config->$moduleName))) $config->$moduleName = new stdclass();

        /* 初始化数组。Init the variables. */
        $extConfigFiles       = array();
        $commonExtConfigFiles = array();
        $visionExtConfigFiles = array();
        $siteExtConfigFiles   = array();

        /* 先获得模块的主配置文件。Get the main config file for current module first. */
        $mainConfigFile = $this->getModulePath($appName, $moduleName) . 'config.php';

        /* 查找扩展配置文件。Get extension config files. */
        if($config->framework->extensionLevel > 0) $extConfigPath = $this->getModuleExtPath($appName, $moduleName, 'config');
        if($config->framework->extensionLevel >= 1)
        {
            if(!empty($extConfigPath['common'])) $commonExtConfigFiles = helper::ls($extConfigPath['common'], '.php');
            if(!empty($extConfigPath['xuan']))   $commonExtConfigFiles = array_merge($commonExtConfigFiles, helper::ls($extConfigPath['xuan'], '.php'));
            if(!empty($extConfigPath['vision'])) $commonExtConfigFiles = array_merge($commonExtConfigFiles, helper::ls($extConfigPath['vision'], '.php'));
            if(!empty($extConfigPath['custom'])) $commonExtConfigFiles = array_merge($commonExtConfigFiles, helper::ls($extConfigPath['custom'], '.php'));
        }
        if($config->framework->extensionLevel == 2 and !empty($extConfigPath['site'])) $siteExtConfigFiles = helper::ls($extConfigPath['site'], '.php');
        $extConfigFiles = array_merge($commonExtConfigFiles, $siteExtConfigFiles);

        /* 将主配置文件和扩展配置文件合并在一起。Put the main config file and extension config files together. */
        $configFiles = array_merge(array($mainConfigFile), $extConfigFiles);

        /* 加载每一个配置文件。Load every config file. */
        static $loadedConfigs = array();
        foreach($configFiles as $configFile)
        {
            if(in_array($configFile, $loadedConfigs)) continue;
            if(file_exists($configFile)) include $configFile;
            $loadedConfigs[] = $configFile;
        }

        /* 加载数据库中与本模块相关的配置项。Merge from the db configs. */
        if($moduleName != 'common')
        {
            if(isset($config->system->$moduleName))   $this->mergeConfig($config->system->$moduleName, $moduleName);
            if(isset($config->personal->$moduleName)) $this->mergeConfig($config->personal->$moduleName, $moduleName);
        }
    }

    /**
     * The alias for loadModuleConfig.
     *
     * @param  string $moduleName
     * @param  string $appName
     * @access public
     * @return void
     */
    public function loadConfig($moduleName, $appName = '')
    {
        return parent::loadModuleConfig($moduleName);
    }

    /**
     * Export config.
     *
     * @access public
     * @return void
     */
    public function exportConfig()
    {
        ob_start();
        parent::exportConfig();
        $view = ob_get_contents();
        ob_end_clean();

        $view = json_decode($view);
        $view->rand = $this->session->random;
        $this->session->set('rand', $this->session->random);

        echo json_encode($view);
    }

    /**
     * 检查请求的模块和方法是否应该调用工作流引擎进行处理。
     * Check if the requested module and method should call the workflow engine for processing.
     *
     * 处理逻辑：
     * Processing logic:
     * 1、如果当前版本不是企业版，或者当前请求处于安装模式或升级模式，调用父类方法并返回。
     * 1. If the current version is not the enterprise version, or if the current request is in install mode or upgrade mode, call the parent class method and return.
     *
     * 2、如果当前请求的模块在TABLE_WORKFLOW表中不存在，调用父类方法并返回。
     * 2. If the currently requested module does not exist in the TABLE_WORKFLOW table, call the parent class method and return.
     *
     * 3、如果当前请求的模块在TABLE_WORKFLOW表中存在并且是内置模块，并且请求的方法名是browselabel，则修改请求的模块名为flow，修改请求的方法名为browse，重新设置URI参数，调用父类方法并返回。
     * 3. If the currently requested module exists in the TABLE_WORKFLOW table and is a built-in module, and the requested method name is
     * browselabel, rename the module of the request to flow and the method of the request to browse, and reset the URI, call the parent class method and return.
     *
     * 4、如果不满足3中的条件但当前请求的方法在TABLE_WORKFLOWACTION表中存在，且方法扩展类型为重写，则修改请求的模块名为flow，方法名根据5中的规则修改，重新设置URI参数，调用父类方法并返回。
     * 4. If the condition of 3 is not satisfied but the currently requested method exists in the TABLE_WORKFLOWACTION table, and the method
     * extension type is overwrite, rename the module of the request to flow, and rename the method of the request according to the rule in 5.
     * Then reset the URI, call the parent class method and return.
     *
     * 5、如果当前请求的方法名为browse、create、edit、view、delete、export中任意一个，则方法名不变，否则方法名改为operate。
     * 5. If the currently requested method is named any one of browse, create, edit, view, delete, or export, the method name is unchanged, otherwise the method name is changed to operate.
     *
     * @param   bool    $exitIfNone     没有找到该控制器文件的情况：如果该参数为true，则终止程序；如果为false，则打印错误日志
     *                                  The controller file was not found: if the parameter is true, the program is terminated;
     *                                                                     if false, the error log is printed.
     * @access  public
     * @return  bool
     */
    public function setControlFile($exitIfNone = true)
    {
        /* Set raw module and method name for fetch control. */
        if(empty($this->rawModule)) $this->rawModule = $this->moduleName;
        if(empty($this->rawMethod)) $this->rawMethod = $this->methodName;

        /* If is not a biz version or is in install mode or in in upgrade mode, call parent method. */
        if(!isset($this->config->bizVersion) or defined('IN_INSTALL') or defined('IN_UPGRADE')) return parent::setControlFile($exitIfNone);

        /* Check if the requested module is defined in workflow. */
        $flow = $this->dbh->query("SELECT * FROM " . TABLE_WORKFLOW . " WHERE `module` = '$this->moduleName'")->fetch();
        if(!$flow) return parent::setControlFile($exitIfNone);
        if($flow->status != 'normal') die("<html><head><meta charset='utf-8'></head><body>{$this->lang->flowNotRelease}</body></html>");

        /**
         * 工作流中配置的标签应该请求browse方法，而某些内置流程本身包含browse方法。在这里处理请求的时候会无法区分是内置的browse方法还是工作
         * 流标签的browse方法，为了避免此类冲突，在工作流中配置出的标签请求的方法改为browseLabel，在设置控制器文件时需要将其重设为browse。
         * Tags configured in the workflow should request the browse method, and some built-in processes themselves contain the browse
         * method. When processing a request here, it is impossible to distinguish between the built-in browse method and the browse
         * method of the workflow tag. In order to avoid such conflicts, the method of configuring the label request in the workflow
         * is changed to browseLabel, which needs to be reset to browse when setting the controller file.
         */
        if($flow->buildin && $this->methodName == 'browselabel')
        {
            $this->rawModule = $this->moduleName;
            $this->rawMethod = 'browse';
            $this->isFlow    = true;

            $moduleName = 'flow';
            $methodName = 'browse';

            $this->setFlowURI($moduleName, $methodName);
        }
        else
        {
            $action = $this->dbh->query("SELECT * FROM " . TABLE_WORKFLOWACTION . " WHERE `module` = '$this->moduleName' AND `action` = '$this->methodName' AND `vision` = '{$this->config->vision}'")->fetch();
            if(zget($action, 'extensionType') == 'override')
            {
                $this->rawModule = $this->moduleName;
                $this->rawMethod = $this->methodName;
                $this->isFlow    = true;

                $this->loadModuleConfig('workflowaction');

                $moduleName = 'flow';
                $methodName = $this->methodName;
                /*
                 * 工作流中除了内置方法外的方法，如果是批量操作调用batchOperate方法，其它操作调用operate方法来执行。
                 * In addition to the built-in methods in the workflow, if the batch operation calls the batchOperate method, other operations call the operate method to execute.
                 */
                if(!in_array($this->methodName, $this->config->workflowaction->default->actions))
                {
                    if($action->type == 'single') $methodName = 'operate';
                    if($action->type == 'batch')  $methodName = 'batchOperate';
                }

                $this->setFlowURI($moduleName, $methodName);
            }
        }

        /* Call method of parent. */
        return parent::setControlFile($exitIfNone);
    }

    /**
     * 把请求的URI重设成工作流引擎可以解析的URI。
     * Reset the requested URI to a URI that the workflow engine can resolve.
     *
     * e.g. /$module-browse-search-1.html   =>  /flow-browse-$module-search-1.html
     *      /$module-create.html            =>  /flow-create-$module.html
     *      /$module-edit-1.html            =>  /flow-edit-$module-1.html
     *      /$module-view-1.html            =>  /flow-view-$module-1.html
     *      /$module-delete-1.html          =>  /flow-delete-$module-1.html
     *      /$module-close-1.html           =>  /flow-operate-$module-close-1.html
     *
     *      /index.php?m=$module&f=browse&mode=search&label=1   =>  /index.php?m=flow&f=browse&module=$module&mode=search&label=1
     *      /index.php?m=$module&f=create&id=1                  =>  /index.php?m=flow&f=create&module=$module&$id=1
     *      /index.php?m=$module&f=edit&id=1                    =>  /index.php?m=flow&f=edit&module=$module&$id=1
     *      /index.php?m=$module&f=view&id=1                    =>  /index.php?m=flow&f=view&module=$module&$id=1
     *      /index.php?m=$module&f=delete&id=1                  =>  /index.php?m=flow&f=delete&module=$module&$id=1
     *      /index.php?m=$module&f=close&id=1                   =>  /index.php?m=flow&f=operate&module=$module&action=close&$id=1
     *
     * @param  string $moduleName
     * @param  string $methodName
     * @access public
     * @return void
     */
    public function setFlowURI($moduleName, $methodName)
    {
        $this->rawURI = $this->URI;

        $this->setModuleName($moduleName);
        $this->setMethodName($methodName);

        if($this->config->requestType != 'GET')
        {
            /* e.g. $this->URI = /$module-close-1.html. */
            $params = explode($this->config->requestFix, $this->URI); // $params = array($module, 'close', 1);

            /* Remove module and method. */
            $params = array_slice($params, 2); // $params = array(1);

            /* Prepend other params. */
            if($methodName == 'operate')      array_unshift($params, $this->rawMethod); // $params = array('close', 1);
            if($methodName == 'batchOperate') array_unshift($params, $this->rawMethod); // $params = array('close', 1);
            if($methodName == 'browse')
            {
                if(!(isset($params[0]) and $params[0] == 'bysearch')) array_unshift($params, 'browse');
            }

            array_unshift($params, $this->rawModule);                                   // $params = array($module, 'close', 1);
            array_unshift($params, $methodName);                                        // $params = array('operate', $module, 'close', 1);
            array_unshift($params, $moduleName);                                        // $params = array('flow', 'operate', $module, 'close', 1);

            $this->URI = implode($this->config->requestFix, $params);                   // $this->URI = flow-operate-$module-close-1.html;
        }
        else
        {
            /* Extract $path and $query from $params. */
            /* e.g. $tshi->URI = /index.php?m=$module&f=browse&mode=search&label=1. */
            $params = parse_url($this->URI);    // $params = array('path' => '/index.php', 'query' => m=$module&f=browse&mode=search&label=1;
            extract($params);                   // $path = '/index.php'; $query = 'm=$module&f=browse&mode=search&label=1';
            parse_str($query, $params);         // $params = array('m' => $module, 'f' => 'browse', 'mode' = 'search', 'label' => 1);

            $params = array_reverse($params);           // $params = array('label' => 1, 'mode' => 'search');
            if($methodName == 'operate')      $params['action'] = $params[$this->config->methodVar];
            if($methodName == 'batchOperate') $params['action'] = $params[$this->config->methodVar];

            /* Remove module and method. */
            unset($params[$this->config->moduleVar]);   // $params = array('f' => 'browse', 'mode' => 'search', 'label' => 1);
            unset($params[$this->config->methodVar]);   // $params = array('mode' => 'search', 'label' => 1);

            /* Prepend other params. */
            if($methodName == 'browse')
            {
                if(!(isset($params['mode']) and $params['mode'] == 'bysearch')) $params['mode'] = 'browse';
            }

            $params['module']                 = $this->rawModule;   // $param = array('label' => 1, 'mode' => 'search', 'module' => $module);
            $params[$this->config->methodVar] = $methodName;        // $param = array('label' => 1, 'mode' => 'search', 'module' => $module, 'f' => 'browse');
            $params[$this->config->moduleVar] = $moduleName;        // $param = array('label' => 1, 'mode' => 'search', 'module' => $module, 'f' => 'browse', 'm' => 'flow');

            $params = array_reverse($params);   // $params = array('m' => 'flow', 'f' => 'browse', 'module' => $module, 'mode' => 'search', 'label' => 1);

            /* Reset $_GET for setParamsByGET. */
            $get = $params;
            foreach($_GET as $key => $value)
            {
                if(!isset($get[$key])) $get[$key] = $value;
            }
            $_GET = $get;

            $this->URI = $path . '?' . http_build_query($params);   // $this->URI = '/index.php?m=flow&f=browse&module=$module&mode=search&label=1';
        }
    }

    /**
     * PATH_INFO方式解析，获取$URI和$viewType。
     * Parse PATH_INFO, get the $URI and $viewType.
     *
     * @access public
     * @return void
     */
    public function parsePathInfo()
    {
        parent::parsePathInfo();

        if($this->get->display == 'card') $this->viewType = 'xhtml';
    }

    /**
     * GET请求方式解析，获取$URI和$viewType。
     * Parse GET, get $URI and $viewType.
     *
     * @access public
     * @return void
     */
    public function parseGET()
    {
        parent::parseGET();

        if($this->get->display == 'card') $this->viewType = 'xhtml';
    }

    /**
     * 获取$URL。
     * Get the $URL.
     *
     * @param  bool $full  true, the URI contains the webRoot, else only hte URI.
     * @access public
     * @return string
     */
    public function getURI($full = false)
    {
        $URI = !empty($this->rawURI) ? $this->rawURI : $this->URI;
        if($full and $this->config->requestType == 'PATH_INFO')
        {
            if($URI) return $this->config->webRoot . $URI . '.' . $this->viewType;
            return $this->config->webRoot;
        }
        return $URI;
    }

    /**
     * 如果$this->isFlow的值为true，说明这个请求需要工作流引擎来处理，则要根据工作流引擎的需要重新设置参数。
     * If the values of $this->isFlow is true, indicating that the request needs to be processed
     * by the workflow engine, the parameters are reset according to the needs of the workflow engine.
     *
     * @param   array $defaultParams     the default params defined by the method.
     * @param   array $passedParams      the params passed in through url.
     * @access  public
     * @return  array the merged params.
     */
    public function mergeParams($defaultParams, $passedParams)
    {
        if(isset($_GET['project'])) $this->session->set('project', $_GET['project']);
        /* If the isFlow is true, reset the passed params. */
        if($this->isFlow)
        {
            $passedParams = array_reverse($passedParams);

            /* 如果请求的方法名不是browse、create、edit、view、delete、export中的任何一个，则需要添加action参数来传递请求的方法名。 */
            /* If the requested method name is not any of browse, create, edit, view, delete, or export, you need to add an action parameter to pass the requested method name. */
            if(isset($this->config->workflowaction->default->actions) and !in_array($this->rawMethod, $this->config->workflowaction->default->actions)) $passedParams['action'] = $this->rawMethod;

            /* 添加module参数来传递请求的模块名。 */
            /* Add the module parameter to pass the requested module name. */
            $passedParams['module'] = $this->rawModule;

            $passedParams = array_reverse($passedParams);
        }

        /* display参数用来标记请求是否来自禅道客户端的卡片展示页面，此处应该删掉以避免对方法调用产生影响。 */
        /* The display parameter is used to mark whether the request comes from the card display page of the ZenTao client. It should be deleted here to avoid affecting the method call. */
        unset($passedParams['display']);

        $this->rawParams = parent::mergeParams($defaultParams, $passedParams);
        return $this->rawParams;
    }
}
