<?php
/**
 * The action module zh-tw file of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2015 青島易軟天創網絡科技有限公司(QingDao Nature Easy Soft Network Technology Co,LTD, www.cnezsoft.com)
 * @license     ZPL (http://zpl.pub/page/zplv12.html)
 * @author      Chunsheng Wang <chunsheng@cnezsoft.com>
 * @package     action
 * @version     $Id: zh-tw.php 4955 2013-07-02 01:47:21Z chencongzhi520@gmail.com $
 * @link        http://www.zentao.net
 */
global $config;

$lang->action->common        = '系統日誌';
$lang->action->id            = '編號';
$lang->action->product       = $lang->productCommon;
$lang->action->project       = '項目';
$lang->action->execution     = $lang->execution->common;
$lang->action->objectType    = '對象類型';
$lang->action->objectID      = '對象ID';
$lang->action->objectName    = '對象名稱';
$lang->action->actor         = '操作者';
$lang->action->action        = '動作';
$lang->action->actionID      = '記錄ID';
$lang->action->date          = '日期';
$lang->action->extra         = '附加值';
$lang->action->system        = '系統';
$lang->action->url           = '網址';
$lang->action->contentType   = '內容類型';
$lang->action->data          = '數據';
$lang->action->result        = '結果';
$lang->action->modified      = '修改了';
$lang->action->old           = '舊值為';
$lang->action->new           = '新值為';
$lang->action->to            = '到';
$lang->action->superReviewer = '超級評審人';

$lang->action->trash       = '資源回收筒';
$lang->action->undelete    = '還原';
$lang->action->hideOne     = '隱藏';
$lang->action->hideAll     = '全部隱藏';
$lang->action->editComment = '修改備註';
$lang->action->create      = '添加備註';
$lang->action->comment     = '備註';

$lang->action->undeleteAction = '還原數據';
$lang->action->hideOneAction  = '隱藏數據';

$lang->action->trashTips      = '提示：為了保證系統的完整性，禪道系統的刪除都是標記刪除。';
$lang->action->textDiff       = '文本格式';
$lang->action->original       = '原始格式';
$lang->action->confirmHideAll = '您確定要全部隱藏這些記錄嗎？';
$lang->action->needEdit       = '要還原%s的名稱或代號已經存在，請編輯更改。';
$lang->action->historyEdit    = '歷史記錄編輯不能為空。';
$lang->action->noDynamic      = '暫時沒有動態。';
$lang->action->undeletedTips  = '該數據在版本升級過程中未參與數據歸併流程，不支持還原。';

$lang->action->history = new stdclass();
$lang->action->history->action = '關聯日誌';
$lang->action->history->field  = '欄位';
$lang->action->history->old    = '舊值';
$lang->action->history->new    = '新值';
$lang->action->history->diff   = '不同';

$lang->action->dynamic = new stdclass();
$lang->action->dynamic->today      = '今天';
$lang->action->dynamic->yesterday  = '昨天';
$lang->action->dynamic->twoDaysAgo = '前天';
$lang->action->dynamic->thisWeek   = '本週';
$lang->action->dynamic->lastWeek   = '上周';
$lang->action->dynamic->thisMonth  = '本月';
$lang->action->dynamic->lastMonth  = '上月';
$lang->action->dynamic->all        = '所有';
$lang->action->dynamic->hidden     = '已隱藏';
$lang->action->dynamic->search     = '搜索';

$lang->action->periods['all']       = $lang->action->dynamic->all;
$lang->action->periods['today']     = $lang->action->dynamic->today;
$lang->action->periods['yesterday'] = $lang->action->dynamic->yesterday;
$lang->action->periods['thisweek']  = $lang->action->dynamic->thisWeek;
$lang->action->periods['lastweek']  = $lang->action->dynamic->lastWeek;
$lang->action->periods['thismonth'] = $lang->action->dynamic->thisMonth;
$lang->action->periods['lastmonth'] = $lang->action->dynamic->lastMonth;

$lang->action->objectTypes['product']          = $lang->productCommon;
$lang->action->objectTypes['branch']           = '分支';
$lang->action->objectTypes['story']            = $lang->SRCommon;
$lang->action->objectTypes['design']           = '設計';
$lang->action->objectTypes['productplan']      = '計劃';
$lang->action->objectTypes['release']          = '發佈';
$lang->action->objectTypes['program']          = '項目集';
$lang->action->objectTypes['project']          = '項目';
$lang->action->objectTypes['execution']        = $config->systemMode == 'new' ? '執行' : $lang->executionCommon;
$lang->action->objectTypes['task']             = '任務';
$lang->action->objectTypes['build']            = '版本';
$lang->action->objectTypes['job']              = '構建';
$lang->action->objectTypes['bug']              = 'Bug';
$lang->action->objectTypes['case']             = '用例';
$lang->action->objectTypes['caseresult']       = '用例結果';
$lang->action->objectTypes['stepresult']       = '用例步驟';
$lang->action->objectTypes['caselib']          = '用例庫';
$lang->action->objectTypes['testsuite']        = '套件';
$lang->action->objectTypes['testtask']         = '測試單';
$lang->action->objectTypes['testreport']       = '報告';
$lang->action->objectTypes['doc']              = '文檔';
$lang->action->objectTypes['api']              = '介面';
$lang->action->objectTypes['doclib']           = '文檔庫';
$lang->action->objectTypes['apistruct']        = '資料結構';
$lang->action->objectTypes['todo']             = '待辦';
$lang->action->objectTypes['risk']             = '風險';
$lang->action->objectTypes['issue']            = '問題';
$lang->action->objectTypes['module']           = '模組';
$lang->action->objectTypes['user']             = '用戶';
$lang->action->objectTypes['stakeholder']      = '干係人';
$lang->action->objectTypes['budget']           = '費用估算';
$lang->action->objectTypes['entry']            = '應用';
$lang->action->objectTypes['webhook']          = 'Webhook';
$lang->action->objectTypes['team']             = '團隊';
$lang->action->objectTypes['whitelist']        = '白名單';
$lang->action->objectTypes['pipeline']         = 'GitLab';
$lang->action->objectTypes['gitlab']           = 'GitLab';
$lang->action->objectTypes['jenkins']          = 'Jenkins';
$lang->action->objectTypes['mr']               = '合併請求';
$lang->action->objectTypes['gitlabproject']    = 'GitLab項目';
$lang->action->objectTypes['gitlabuser']       = 'GitLab用戶';
$lang->action->objectTypes['gitlabgroup']      = 'GitLab群組';
$lang->action->objectTypes['gitlabbranch']     = 'GitLab分支';
$lang->action->objectTypes['gitlabbranchpriv'] = 'GitLab保護分支';
$lang->action->objectTypes['gitlabtag']        = 'GitLab標籤';
$lang->action->objectTypes['gitlabtagpriv']    = 'GitLab標籤保護';
$lang->action->objectTypes['kanbanspace']      = '看板空間';
$lang->action->objectTypes['kanban']           = '看板';
$lang->action->objectTypes['kanbanregion']     = '看板區域';
$lang->action->objectTypes['kanbanlane']       = '看板泳道';
$lang->action->objectTypes['kanbancolumn']     = '看板列';
$lang->action->objectTypes['kanbancard']       = '看板卡片';
$lang->action->objectTypes['sonarqube']        = 'SonarQube伺服器';
$lang->action->objectTypes['sonarqubeproject'] = 'SonarQube項目';

/* 用來描述操作歷史記錄。*/
$lang->action->desc = new stdclass();
$lang->action->desc->common               = '$date, <strong>$action</strong> by <strong>$actor</strong>。' . "\n";
$lang->action->desc->extra                = '$date, <strong>$action</strong> as <strong>$extra</strong> by <strong>$actor</strong>。' . "\n";
$lang->action->desc->opened               = '$date, 由 <strong>$actor</strong> 創建。' . "\n";
$lang->action->desc->openedbysystem       = '$date, 由系統創建。' . "\n";
$lang->action->desc->created              = '$date, 由 <strong>$actor</strong> 創建。' . "\n";
$lang->action->desc->added                = '$date, 由 <strong>$actor</strong> 添加。' . "\n";
$lang->action->desc->changed              = '$date, 由 <strong>$actor</strong> 變更。' . "\n";
$lang->action->desc->edited               = '$date, 由 <strong>$actor</strong> 編輯。' . "\n";
$lang->action->desc->assigned             = '$date, 由 <strong>$actor</strong> 指派給 <strong>$extra</strong>。' . "\n";
$lang->action->desc->closed               = '$date, 由 <strong>$actor</strong> 關閉。' . "\n";
$lang->action->desc->closedbysystem       = '$date, 由系統關閉。' . "\n";
$lang->action->desc->deleted              = '$date, 由 <strong>$actor</strong> 刪除。' . "\n";
$lang->action->desc->deletedfile          = '$date, 由 <strong>$actor</strong> 刪除了附件：<strong><i>$extra</i></strong>。' . "\n";
$lang->action->desc->editfile             = '$date, 由 <strong>$actor</strong> 編輯了附件：<strong><i>$extra</i></strong>。' . "\n";
$lang->action->desc->erased               = '$date, 由 <strong>$actor</strong> 刪除。' . "\n";
$lang->action->desc->undeleted            = '$date, 由 <strong>$actor</strong> 還原。' . "\n";
$lang->action->desc->hidden               = '$date, 由 <strong>$actor</strong> 隱藏。' . "\n";
$lang->action->desc->commented            = '$date, 由 <strong>$actor</strong> 添加備註。' . "\n";
$lang->action->desc->activated            = '$date, 由 <strong>$actor</strong> 激活。' . "\n";
$lang->action->desc->blocked              = '$date, 由 <strong>$actor</strong> 阻塞。' . "\n";
$lang->action->desc->moved                = '$date, 由 <strong>$actor</strong> 移動，之前為 "$extra"。' . "\n";
$lang->action->desc->confirmed            = '$date, 由 <strong>$actor</strong> 確認' . $lang->SRCommon . '變動，最新版本為<strong>#$extra</strong>。' . "\n";
$lang->action->desc->caseconfirmed        = '$date, 由 <strong>$actor</strong> 確認用例變動，最新版本為<strong>#$extra</strong>。' . "\n";
$lang->action->desc->bugconfirmed         = '$date, 由 <strong>$actor</strong> 確認Bug。' . "\n";
$lang->action->desc->frombug              = '$date, 由 <strong>$actor</strong> Bug轉化而來，Bug編號為 <strong>$extra</strong>。';
$lang->action->desc->started              = '$date, 由 <strong>$actor</strong> 啟動。' . "\n";
$lang->action->desc->restarted            = '$date, 由 <strong>$actor</strong> 繼續。' . "\n";
$lang->action->desc->delayed              = '$date, 由 <strong>$actor</strong> 延期。' . "\n";
$lang->action->desc->suspended            = '$date, 由 <strong>$actor</strong> 掛起。' . "\n";
$lang->action->desc->recordestimate       = '$date, 由 <strong>$actor</strong> 記錄工時，消耗 <strong>$extra</strong> 小時。';
$lang->action->desc->editestimate         = '$date, 由 <strong>$actor</strong> 編輯工時。';
$lang->action->desc->deleteestimate       = '$date, 由 <strong>$actor</strong> 刪除工時。';
$lang->action->desc->canceled             = '$date, 由 <strong>$actor</strong> 取消。' . "\n";
$lang->action->desc->svncommited          = '$date, 由 <strong>$actor</strong> 提交代碼，版本為<strong>#$extra</strong>。' . "\n";
$lang->action->desc->gitcommited          = '$date, 由 <strong>$actor</strong> 提交代碼，版本為<strong>#$extra</strong>。' . "\n";
$lang->action->desc->finished             = '$date, 由 <strong>$actor</strong> 完成。' . "\n";
$lang->action->desc->paused               = '$date, 由 <strong>$actor</strong> 暫停。' . "\n";
$lang->action->desc->verified             = '$date, 由 <strong>$actor</strong> 驗收。' . "\n";
$lang->action->desc->diff1                = '修改了 <strong><i>%s</i></strong>，舊值為 "%s"，新值為 "%s"。<br />' . "\n";
$lang->action->desc->diff2                = '修改了 <strong><i>%s</i></strong>，區別為：' . "\n" . "<blockquote class='textdiff'>%s</blockquote>" . "\n<blockquote class='original'>%s</blockquote>";
$lang->action->desc->diff3                = '將檔案名 %s 改為 %s 。' . "\n";
$lang->action->desc->linked2bug           = '$date 由 <strong>$actor</strong> 關聯到版本 <strong>$extra</strong>';
$lang->action->desc->linked2testtask      = '$date 由 <strong>$actor</strong> 關聯到測試單 <strong>$extra</strong>';
$lang->action->desc->unlinkedfromtesttask = '$date 由 <strong>$actor</strong> 從測試單 <strong>$extra</strong> 中移除';
$lang->action->desc->resolved             = '$date, 由 <strong>$actor</strong> 解決。' . "\n";
$lang->action->desc->managed              = '$date, 由 <strong>$actor</strong> 維護。' . "\n";
$lang->action->desc->estimated            = '$date, 由 <strong>$actor</strong> 估算。' . "\n";
$lang->action->desc->run                  = '$date, 由 <strong>$actor</strong> 執行。' . "\n";
$lang->action->desc->syncprogram          = '$date, 由 <strong>$actor</strong> 啟動(因項目開始而啟動項目集)。' . "\n";
$lang->action->desc->syncproject          = '$date, 系統判斷由於執行開始，將項目狀態置為進行中。' . "\n";
$lang->action->desc->syncexecution        = '$date, 系統判斷由於任務開始，將執行狀態置為進行中。' . "\n";
$lang->action->desc->importfromgitlab     = '$date, 由 <strong>$actor</strong> 從Gitlab的Issue關聯創建。' . "\n";
$lang->action->desc->archived             = '$date, 由 <strong>$actor</strong> 歸檔。' . "\n";
$lang->action->desc->restore              = '$date, 由 <strong>$actor</strong> 還原。' . "\n";
$lang->action->desc->importedcard         = '$date, 由 <strong>$actor</strong> 從看板 <strong>$extra</strong> 導入。' . "\n";
$lang->action->desc->importedproductplan  = '$date, 由 <strong>$actor</strong> 從產品計劃 <strong>$extra</strong> 導入。' . "\n";
$lang->action->desc->importedrelease      = '$date, 由 <strong>$actor</strong> 從產品發佈 <strong>$extra</strong> 導入。' . "\n";
$lang->action->desc->importedexecution    = '$date, 由 <strong>$actor</strong> 從項目執行 <strong>$extra</strong> 導入。' . "\n";
$lang->action->desc->importedbuild        = '$date, 由 <strong>$actor</strong> 從項目版本 <strong>$extra</strong> 導入。' . "\n";
$lang->action->desc->fromsonarqube        = '$date, 由 <strong>$actor</strong> 從<strong>SonarQube問題</strong>轉化而來。' . "\n";

/* 用來描述和父子任務相關的操作歷史記錄。*/
$lang->action->desc->createchildren     = '$date, 由 <strong>$actor</strong> 創建子任務 <strong>$extra</strong>。' . "\n";
$lang->action->desc->linkchildtask      = '$date, 由 <strong>$actor</strong> 關聯子任務 <strong>$extra</strong>。' . "\n";
$lang->action->desc->unlinkchildrentask = '$date, 由 <strong>$actor</strong> 移除子任務 <strong>$extra</strong>。' . "\n";
$lang->action->desc->linkparenttask     = '$date, 由 <strong>$actor</strong> 關聯到父任務 <strong>$extra</strong>。' . "\n";
$lang->action->desc->unlinkparenttask   = '$date, 由 <strong>$actor</strong> 從父任務<strong>$extra</strong>取消關聯。' . "\n";
$lang->action->desc->deletechildrentask = '$date, 由 <strong>$actor</strong> 刪除子任務<strong>$extra</strong>。' . "\n";

/* 用來描述和父子需求相關的操作歷史記錄。*/
$lang->action->desc->createchildrenstory = '$date, 由 <strong>$actor</strong> 創建子需求 <strong>$extra</strong>。' . "\n";
$lang->action->desc->linkchildstory      = '$date, 由 <strong>$actor</strong> 關聯子需求 <strong>$extra</strong>。' . "\n";
$lang->action->desc->unlinkchildrenstory = '$date, 由 <strong>$actor</strong> 移除子需求 <strong>$extra</strong>。' . "\n";
$lang->action->desc->linkparentstory     = '$date, 由 <strong>$actor</strong> 關聯到父需求 <strong>$extra</strong>。' . "\n";
$lang->action->desc->unlinkparentstory   = '$date, 由 <strong>$actor</strong> 從父需求<strong>$extra</strong>取消關聯。' . "\n";
$lang->action->desc->deletechildrenstory = '$date, 由 <strong>$actor</strong> 刪除子需求<strong>$extra</strong>。' . "\n";

/* 關聯用例和移除用例時的歷史操作記錄。*/
$lang->action->desc->linkrelatedcase   = '$date, 由 <strong>$actor</strong> 關聯相關用例 <strong>$extra</strong>。' . "\n";
$lang->action->desc->unlinkrelatedcase = '$date, 由 <strong>$actor</strong> 移除相關用例 <strong>$extra</strong>。' . "\n";

/* 用來顯示動態信息。*/
$lang->action->label                        = new stdclass();
$lang->action->label->created               = '創建';
$lang->action->label->opened                = '創建';
$lang->action->label->openedbysystem        = '系統創建';
$lang->action->label->closedbysystem        = '系統關閉';
$lang->action->label->added                 = '添加';
$lang->action->label->changed               = '變更了';
$lang->action->label->edited                = '編輯了';
$lang->action->label->assigned              = '指派了';
$lang->action->label->closed                = '關閉了';
$lang->action->label->deleted               = '刪除了';
$lang->action->label->deletedfile           = '刪除附件';
$lang->action->label->editfile              = '編輯附件';
$lang->action->label->erased                = '刪除了';
$lang->action->label->undeleted             = '還原了';
$lang->action->label->hidden                = '隱藏了';
$lang->action->label->commented             = '評論了';
$lang->action->label->communicated          = '溝通了';
$lang->action->label->activated             = '激活了';
$lang->action->label->blocked               = '阻塞了';
$lang->action->label->resolved              = '解決了';
$lang->action->label->reviewed              = '評審了';
$lang->action->label->recalled              = '撤銷評審';
$lang->action->label->moved                 = '移動了';
$lang->action->label->confirmed             = "確認了{$lang->SRCommon}";
$lang->action->label->bugconfirmed          = '確認了';
$lang->action->label->tostory               = "轉{$lang->SRCommon}";
$lang->action->label->frombug               = "轉{$lang->SRCommon}";
$lang->action->label->fromlib               = '從用例庫導入';
$lang->action->label->totask                = '轉任務';
$lang->action->label->svncommited           = '提交代碼';
$lang->action->label->gitcommited           = '提交代碼';
$lang->action->label->linked2plan           = "關聯計劃";
$lang->action->label->unlinkedfromplan      = "移除計劃";
$lang->action->label->changestatus          = '修改狀態';
$lang->action->label->marked                = '編輯了';
$lang->action->label->linked2execution      = "關聯{$lang->executionCommon}";
$lang->action->label->unlinkedfromexecution = "移除{$lang->executionCommon}";
$lang->action->label->linked2project        = "關聯項目";
$lang->action->label->unlinkedfromproject   = "移除項目";
$lang->action->label->unlinkedfrombuild     = "移除版本";
$lang->action->label->linked2release        = "關聯發佈";
$lang->action->label->unlinkedfromrelease   = "移除發佈";
$lang->action->label->linkrelatedbug        = "關聯了相關Bug";
$lang->action->label->unlinkrelatedbug      = "移除了相關Bug";
$lang->action->label->linkrelatedcase       = "關聯了相關用例";
$lang->action->label->unlinkrelatedcase     = "移除了相關用例";
$lang->action->label->linkrelatedstory      = "關聯了相關{$lang->SRCommon}";
$lang->action->label->unlinkrelatedstory    = "移除了相關{$lang->SRCommon}";
$lang->action->label->subdividestory        = "細分了{$lang->SRCommon}";
$lang->action->label->unlinkchildstory      = "移除了細分{$lang->SRCommon}";
$lang->action->label->started               = '開始了';
$lang->action->label->restarted             = '繼續了';
$lang->action->label->recordestimate        = '記錄了工時';
$lang->action->label->editestimate          = '編輯了工時';
$lang->action->label->canceled              = '取消了';
$lang->action->label->finished              = '完成了';
$lang->action->label->paused                = '暫停了';
$lang->action->label->verified              = '驗收了';
$lang->action->label->delayed               = '延期';
$lang->action->label->suspended             = '掛起';
$lang->action->label->login                 = '登錄系統';
$lang->action->label->logout                = "退出登錄";
$lang->action->label->notified              = "通知了";
$lang->action->label->deleteestimate        = "刪除了工時";
$lang->action->label->linked2build          = "關聯了";
$lang->action->label->linked2bug            = "關聯了";
$lang->action->label->linked2testtask       = "關聯了";
$lang->action->label->unlinkedfromtesttask  = "移除了";
$lang->action->label->linkchildtask         = "關聯子任務";
$lang->action->label->unlinkchildrentask    = "取消關聯子任務";
$lang->action->label->linkparenttask        = "關聯到父任務";
$lang->action->label->unlinkparenttask      = "從父任務取消關聯";
$lang->action->label->batchcreate           = "批量創建任務";
$lang->action->label->createchildren        = "創建子任務";
$lang->action->label->managed               = "維護";
$lang->action->label->managedteam           = "維護了";
$lang->action->label->managedwhitelist      = "維護了";
$lang->action->label->deletechildrentask    = "刪除子任務";
$lang->action->label->createchildrenstory   = "創建子需求";
$lang->action->label->linkchildstory        = "關聯子需求";
$lang->action->label->unlinkchildrenstory   = "取消關聯子需求";
$lang->action->label->linkparentstory       = "關聯到父需求";
$lang->action->label->unlinkparentstory     = "從父需求取消關聯";
$lang->action->label->deletechildrenstory   = "刪除子需求";
$lang->action->label->tracked               = '跟蹤了';
$lang->action->label->hangup                = '掛起了';
$lang->action->label->run                   = '執行了';
$lang->action->label->estimated             = '估算了';
$lang->action->label->reviewpassed          = '確認通過';
$lang->action->label->reviewrejected        = '拒絶';
$lang->action->label->reviewclarified       = '有待明確';
$lang->action->label->commitsummary         = '提交培訓總結';
$lang->action->label->updatetrainee         = '更新培訓人員';
$lang->action->label->setdefaultbranch      = '設置了預設分支';
$lang->action->label->syncprogram           = '開始了';
$lang->action->label->syncproject           = '開始了';
$lang->action->label->syncexecution         = '開始了';
$lang->action->label->startProgram          = '（因項目開始而啟動項目集）';
$lang->action->label->createmr              = '合併請求關聯了';
$lang->action->label->deletemr              = '合併請求取消了';
$lang->action->label->mergedmr              = '合併請求合併了';
$lang->action->label->compilepass           = '構建成功';
$lang->action->label->compilefail           = '構建失敗';
$lang->action->label->reopen                = '重新打開';
$lang->action->label->approve               = '通過了';
$lang->action->label->reject                = '拒絶了';
$lang->action->label->importfromgitlab      = '從Gitlab關聯創建了';
$lang->action->label->archived              = '歸檔了';
$lang->action->label->restore               = '還原了';
$lang->action->label->mergedbranch          = '合併分支';
$lang->action->label->startedbychild        = '開始了';
$lang->action->label->finishedbychild       = '完成了';
$lang->action->label->closedbychild         = '關閉了';
$lang->action->label->activatedbychild      = '激活了';
$lang->action->label->createchild           = '激活了';
$lang->action->label->executed              = '執行了';
$lang->action->label->importedcard          = '導入了';
$lang->action->label->importedproductplan   = '導入了';
$lang->action->label->importedrelease       = '導入了';
$lang->action->label->importedexecution     = '導入了';
$lang->action->label->importedbuild         = '導入了';
$lang->action->label->fromsonarqube         = '由SonarQube問題創建';

/* 動態信息按照對象分組 */
$lang->action->dynamicAction                    = new stdclass();
$lang->action->dynamicAction->todo['opened']    = '創建待辦';
$lang->action->dynamicAction->todo['edited']    = '編輯待辦';
$lang->action->dynamicAction->todo['erased']    = '刪除待辦';
$lang->action->dynamicAction->todo['finished']  = '完成待辦';
$lang->action->dynamicAction->todo['activated'] = '激活待辦';
$lang->action->dynamicAction->todo['closed']    = '關閉待辦';
$lang->action->dynamicAction->todo['assigned']  = '指派待辦';
$lang->action->dynamicAction->todo['undeleted'] = '還原待辦';
$lang->action->dynamicAction->todo['hidden']    = '隱藏待辦';

$lang->action->dynamicAction->program['opened']    = '創建項目集';
$lang->action->dynamicAction->program['edited']    = '編輯項目集';
$lang->action->dynamicAction->program['activated'] = '激活項目集';
$lang->action->dynamicAction->program['deleted']   = '刪除項目集';
$lang->action->dynamicAction->program['closed']    = '關閉項目集';

$lang->action->dynamicAction->project['opened']    = '創建項目';
$lang->action->dynamicAction->project['edited']    = '編輯項目';
$lang->action->dynamicAction->project['started']   = '開始項目';
$lang->action->dynamicAction->project['suspended'] = '延期項目';
$lang->action->dynamicAction->project['activated'] = '激活項目';
$lang->action->dynamicAction->project['closed']    = '關閉項目';

$lang->action->dynamicAction->product['opened']    = '創建' . $lang->productCommon;
$lang->action->dynamicAction->product['edited']    = '編輯' . $lang->productCommon;
$lang->action->dynamicAction->product['deleted']   = '刪除' . $lang->productCommon;
$lang->action->dynamicAction->product['closed']    = '關閉' . $lang->productCommon;
$lang->action->dynamicAction->product['undeleted'] = '還原' . $lang->productCommon;
$lang->action->dynamicAction->product['hidden']    = '隱藏' . $lang->productCommon;

$lang->action->dynamicAction->branch['opened']           = '創建分支';
$lang->action->dynamicAction->branch['edited']           = '編輯分支';
$lang->action->dynamicAction->branch['closed']           = '關閉分支';
$lang->action->dynamicAction->branch['activated']        = '激活分支';
$lang->action->dynamicAction->branch['setdefaultbranch'] = '設置預設分支';
$lang->action->dynamicAction->branch['mergebranch']      = '合併分支';

$lang->action->dynamicAction->productplan['opened']    = "創建計劃";
$lang->action->dynamicAction->productplan['edited']    = "編輯計劃";
$lang->action->dynamicAction->productplan['started']   = "開始計劃";
$lang->action->dynamicAction->productplan['finished']  = "完成計劃";
$lang->action->dynamicAction->productplan['closed']    = "關閉計劃";
$lang->action->dynamicAction->productplan['activated'] = "激活計劃";

$lang->action->dynamicAction->release['opened']       = '創建發佈';
$lang->action->dynamicAction->release['edited']       = '編輯發佈';
$lang->action->dynamicAction->release['changestatus'] = '修改發佈狀態';
$lang->action->dynamicAction->release['undeleted']    = '還原發佈';
$lang->action->dynamicAction->release['notified']     = '通知發佈';
$lang->action->dynamicAction->release['hidden']       = '隱藏發佈';

$lang->action->dynamicAction->story['opened']                = "創建{$lang->SRCommon}";
$lang->action->dynamicAction->story['importfromgitlab']      = "從Gitlab關聯創建{$lang->SRCommon}";
$lang->action->dynamicAction->story['edited']                = "編輯{$lang->SRCommon}";
$lang->action->dynamicAction->story['activated']             = "激活{$lang->SRCommon}";
$lang->action->dynamicAction->story['reviewed']              = "評審{$lang->SRCommon}";
$lang->action->dynamicAction->story['recalled']              = "撤銷評審";
$lang->action->dynamicAction->story['closed']                = "關閉{$lang->SRCommon}";
$lang->action->dynamicAction->story['assigned']              = "指派{$lang->SRCommon}";
$lang->action->dynamicAction->story['changed']               = "變更{$lang->SRCommon}";
$lang->action->dynamicAction->story['linked2plan']           = "{$lang->SRCommon}關聯計劃";
$lang->action->dynamicAction->story['unlinkedfromplan']      = "計劃移除{$lang->SRCommon}";
$lang->action->dynamicAction->story['linked2release']        = "{$lang->SRCommon}關聯發佈";
$lang->action->dynamicAction->story['unlinkedfromrelease']   = "發佈移除{$lang->SRCommon}";
$lang->action->dynamicAction->story['linked2build']          = "{$lang->SRCommon}關聯版本";
$lang->action->dynamicAction->story['unlinkedfrombuild']     = "版本移除{$lang->SRCommon}";
$lang->action->dynamicAction->story['unlinkedfromproject']   = '移除項目';
$lang->action->dynamicAction->story['undeleted']             = "還原{$lang->SRCommon}";
$lang->action->dynamicAction->story['hidden']                = "隱藏{$lang->SRCommon}";
$lang->action->dynamicAction->story['linked2execution']      = "關聯$lang->SRCommon";
$lang->action->dynamicAction->story['unlinkedfromexecution'] = "移除$lang->SRCommon";
$lang->action->dynamicAction->story['estimated']             = "估算$lang->SRCommon";

$lang->action->dynamicAction->execution['opened']    = '創建' . $lang->executionCommon;
$lang->action->dynamicAction->execution['edited']    = '編輯' . $lang->executionCommon;
$lang->action->dynamicAction->execution['deleted']   = '刪除' . $lang->executionCommon;
$lang->action->dynamicAction->execution['started']   = '開始' . $lang->executionCommon;
$lang->action->dynamicAction->execution['delayed']   = '延期' . $lang->executionCommon;
$lang->action->dynamicAction->execution['suspended'] = '掛起' . $lang->executionCommon;
$lang->action->dynamicAction->execution['activated'] = '激活' . $lang->executionCommon;
$lang->action->dynamicAction->execution['closed']    = '關閉' . $lang->executionCommon;
$lang->action->dynamicAction->execution['managed']   = '維護' . $lang->executionCommon;
$lang->action->dynamicAction->execution['undeleted'] = '還原' . $lang->executionCommon;
$lang->action->dynamicAction->execution['hidden']    = '隱藏' . $lang->executionCommon;
$lang->action->dynamicAction->execution['moved']     = '導入任務';

$lang->action->dynamicAction->kanban['created']  = '創建看板';
$lang->action->dynamicAction->kanban['edited']   = '設置看板';
$lang->action->dynamicAction->kanban['closed']   = '關閉看板';
$lang->action->dynamicAction->kanban['deleted']  = '刪除看板';

$lang->action->dynamicAction->kanbanspace['created'] = '創建看板空間';
$lang->action->dynamicAction->kanbanspace['edited']  = '設置看板空間';
$lang->action->dynamicAction->kanbanspace['closed']  = '關閉看板空間';
$lang->action->dynamicAction->kanbanspace['deleted'] = '刪除看板空間';

$lang->action->dynamicAction->kanbanregion['created'] = '創建看板區域';
$lang->action->dynamicAction->kanbanregion['edited']  = '編輯看板區域';
$lang->action->dynamicAction->kanbanregion['deleted'] = '刪除看板區域';

$lang->action->dynamicAction->kanbancolumn['created']  = '創建看板列';
$lang->action->dynamicAction->kanbancolumn['edited']   = '設置看板列';
$lang->action->dynamicAction->kanbancolumn['archived'] = '歸檔看板列';
$lang->action->dynamicAction->kanbancolumn['restore']  = '還原看板列';
$lang->action->dynamicAction->kanbancolumn['deleted']  = '刪除看板列';

$lang->action->dynamicAction->kanbanlane['created'] = '創建泳道';
$lang->action->dynamicAction->kanbanlane['edited']  = '設置泳道';
$lang->action->dynamicAction->kanbanlane['moved']   = '移動泳道';
$lang->action->dynamicAction->kanbanlane['deleted'] = '刪除泳道';

$lang->action->dynamicAction->kanbancard['created']   = '創建看板卡片';
$lang->action->dynamicAction->kanbancard['edited']    = '編輯看板卡片';
$lang->action->dynamicAction->kanbancard['commented'] = '備註看板卡片';
$lang->action->dynamicAction->kanbancard['archived']  = '歸檔看板卡片';
$lang->action->dynamicAction->kanbancard['restore']   = '還原看板卡片';
$lang->action->dynamicAction->kanbancard['deleted']   = '刪除看板卡片';

$lang->action->dynamicAction->team['managedTeam'] = '維護團隊';

$lang->action->dynamicAction->task['opened']              = '創建任務';
$lang->action->dynamicAction->task['importfromgitlab']    = "從Gitlab關聯創建任務";
$lang->action->dynamicAction->task['edited']              = '編輯任務';
$lang->action->dynamicAction->task['commented']           = '備註任務';
$lang->action->dynamicAction->task['assigned']            = '指派任務';
$lang->action->dynamicAction->task['confirmed']           = "確認{$lang->SRCommon}變更";
$lang->action->dynamicAction->task['started']             = '開始任務';
$lang->action->dynamicAction->task['finished']            = '完成任務';
$lang->action->dynamicAction->task['recordestimate']      = '記錄工時';
$lang->action->dynamicAction->task['editestimate']        = '編輯工時';
$lang->action->dynamicAction->task['deleteestimate']      = '刪除工時';
$lang->action->dynamicAction->task['paused']              = '暫停任務';
$lang->action->dynamicAction->task['closed']              = '關閉任務';
$lang->action->dynamicAction->task['canceled']            = '取消任務';
$lang->action->dynamicAction->task['activated']           = '激活任務';
$lang->action->dynamicAction->task['createchildren']      = '創建子任務';
$lang->action->dynamicAction->task['unlinkparenttask']    = '從父任務取消關聯';
$lang->action->dynamicAction->task['deletechildrentask']  = '刪除子任務';
$lang->action->dynamicAction->task['linkparenttask']      = '關聯到父任務';
$lang->action->dynamicAction->task['linkchildtask']       = '關聯子任務';
$lang->action->dynamicAction->task['createchildrenstory'] = '創建子需求';
$lang->action->dynamicAction->task['unlinkparentstory']   = '從父需求取消關聯';
$lang->action->dynamicAction->task['deletechildrenstory'] = '刪除子需求';
$lang->action->dynamicAction->task['linkparentstory']     = '關聯到父需求';
$lang->action->dynamicAction->task['linkchildstory']      = '關聯子需求';
$lang->action->dynamicAction->task['undeleted']           = '還原任務';
$lang->action->dynamicAction->task['hidden']              = '隱藏任務';
$lang->action->dynamicAction->task['svncommited']         = 'SVN提交';
$lang->action->dynamicAction->task['gitcommited']         = 'GIT提交';

$lang->action->dynamicAction->build['opened']  = '創建版本';
$lang->action->dynamicAction->build['edited']  = '編輯版本';
$lang->action->dynamicAction->build['deleted'] = '刪除版本';

$lang->action->dynamicAction->bug['opened']              = '創建Bug';
$lang->action->dynamicAction->bug['importfromgitlab']    = "從Gitlab關聯創建Bug";
$lang->action->dynamicAction->bug['edited']              = '編輯Bug';
$lang->action->dynamicAction->bug['activated']           = '激活Bug';
$lang->action->dynamicAction->bug['assigned']            = '指派Bug';
$lang->action->dynamicAction->bug['closed']              = '關閉Bug';
$lang->action->dynamicAction->bug['bugconfirmed']        = '確認Bug';
$lang->action->dynamicAction->bug['resolved']            = '解決Bug';
$lang->action->dynamicAction->bug['undeleted']           = '還原Bug';
$lang->action->dynamicAction->bug['hidden']              = '隱藏Bug';
$lang->action->dynamicAction->bug['deleted']             = '刪除Bug';
$lang->action->dynamicAction->bug['confirmed']           = "確認{$lang->SRCommon}變更";
$lang->action->dynamicAction->bug['tostory']             = "轉{$lang->SRCommon}";
$lang->action->dynamicAction->bug['totask']              = '轉任務';
$lang->action->dynamicAction->bug['linked2plan']         = "Bug關聯計劃";
$lang->action->dynamicAction->bug['unlinkedfromplan']    = "計劃移除Bug";
$lang->action->dynamicAction->bug['linked2release']      = 'Bug關聯發佈';
$lang->action->dynamicAction->bug['unlinkedfromrelease'] = '發佈移除Bug';
$lang->action->dynamicAction->bug['linked2bug']          = 'Bug關聯版本';
$lang->action->dynamicAction->bug['unlinkedfrombuild']   = '版本移除Bug';
$lang->action->dynamicAction->bug['fromsonarqube']       = '由SonarQube問題創建';

$lang->action->dynamicAction->testtask['opened']    = '創建測試單';
$lang->action->dynamicAction->testtask['edited']    = '編輯測試單';
$lang->action->dynamicAction->testtask['started']   = '啟動測試單';
$lang->action->dynamicAction->testtask['activated'] = '激活測試單';
$lang->action->dynamicAction->testtask['closed']    = '完成測試單';
$lang->action->dynamicAction->testtask['blocked']   = '阻塞測試單';

$lang->action->dynamicAction->case['opened']    = '創建用例';
$lang->action->dynamicAction->case['edited']    = '編輯用例';
$lang->action->dynamicAction->case['deleted']   = '刪除用例';
$lang->action->dynamicAction->case['undeleted'] = '還原用例';
$lang->action->dynamicAction->case['hidden']    = '隱藏用例';
$lang->action->dynamicAction->case['reviewed']  = '評審用例';
$lang->action->dynamicAction->case['confirmed'] = "確認{$lang->SRCommon}變更";
$lang->action->dynamicAction->case['fromlib']   = '從用例庫導入';

$lang->action->dynamicAction->testreport['opened']    = '創建測試報告';
$lang->action->dynamicAction->testreport['edited']    = '編輯測試報告';
$lang->action->dynamicAction->testreport['deleted']   = '刪除測試報告';
$lang->action->dynamicAction->testreport['undeleted'] = '還原測試報告';
$lang->action->dynamicAction->testreport['hidden']    = '隱藏測試報告';

$lang->action->dynamicAction->testsuite['opened']    = '創建測試套件';
$lang->action->dynamicAction->testsuite['edited']    = '編輯測試套件';
$lang->action->dynamicAction->testsuite['deleted']   = '刪除測試套件';
$lang->action->dynamicAction->testsuite['undeleted'] = '還原測試套件';
$lang->action->dynamicAction->testsuite['hidden']    = '隱藏測試套件';

$lang->action->dynamicAction->caselib['opened']    = '創建用例庫';
$lang->action->dynamicAction->caselib['edited']    = '編輯用例庫';
$lang->action->dynamicAction->caselib['deleted']   = '刪除用例庫';
$lang->action->dynamicAction->caselib['undeleted'] = '還原用例庫';
$lang->action->dynamicAction->caselib['hidden']    = '隱藏用例庫';

$lang->action->dynamicAction->doclib['created'] = '創建文檔庫';
$lang->action->dynamicAction->doclib['edited']  = '編輯文檔庫';
$lang->action->dynamicAction->doclib['deleted'] = '刪除文檔庫';

$lang->action->dynamicAction->doc['created']   = '創建文檔';
$lang->action->dynamicAction->doc['edited']    = '編輯文檔';
$lang->action->dynamicAction->doc['commented'] = '備註文檔';
$lang->action->dynamicAction->doc['deleted']   = '刪除文檔';
$lang->action->dynamicAction->doc['undeleted'] = '還原文檔';
$lang->action->dynamicAction->doc['hidden']    = '隱藏文檔';

$lang->action->dynamicAction->api['created'] = '創建介面';
$lang->action->dynamicAction->api['edited']  = '編輯介面';
$lang->action->dynamicAction->api['deleted'] = '刪除介面';

$lang->action->dynamicAction->user['created']       = '創建用戶';
$lang->action->dynamicAction->user['edited']        = '編輯用戶';
$lang->action->dynamicAction->user['deleted']       = '刪除用戶';
$lang->action->dynamicAction->user['login']         = '用戶登錄';
$lang->action->dynamicAction->user['logout']        = '用戶退出';
$lang->action->dynamicAction->user['undeleted']     = '還原用戶';
$lang->action->dynamicAction->user['hidden']        = '隱藏用戶';
$lang->action->dynamicAction->user['loginxuanxuan'] = '登錄客戶端';

$lang->action->dynamicAction->entry['created'] = '添加應用';
$lang->action->dynamicAction->entry['edited']  = '編輯應用';

$lang->action->dynamicAction->job['created']   = '創建構建任務';
$lang->action->dynamicAction->job['edited']    = '編輯構建任務';
$lang->action->dynamicAction->job['executed']  = '執行構建任務';
$lang->action->dynamicAction->job['deleted']   = '刪除構建任務';
$lang->action->dynamicAction->job['undeleted'] = '還原構建任務';

$lang->action->dynamicAction->sonarqube['created'] = '創建SonarQube伺服器';
$lang->action->dynamicAction->sonarqube['edited']  = '設置SonarQube伺服器';
$lang->action->dynamicAction->sonarqube['deleted'] = '刪除SonarQube伺服器';

$lang->action->dynamicAction->sonarqubeproject['deleted'] = '刪除SonarQube項目';

$lang->action->dynamicAction->gitlab['created'] = '創建GitLab伺服器';
$lang->action->dynamicAction->gitlab['edited']  = '設置GitLab伺服器';
$lang->action->dynamicAction->gitlab['deleted'] = '刪除GitLab伺服器';

/* 用來生成相應對象的連結。*/
$lang->action->label->product     = $lang->productCommon . '|product|view|productID=%s';
$lang->action->label->productplan = "計劃|productplan|view|productID=%s";
$lang->action->label->release     = '發佈|release|view|productID=%s';
$lang->action->label->story       = "{$lang->SRCommon}|story|view|storyID=%s";
$lang->action->label->program     = "項目集|program|product|programID=%s";
$lang->action->label->project     = "項目|project|index|projectID=%s";
if($config->systemMode == 'new')
{
    $lang->action->label->execution = "執行|execution|task|executionID=%s";
}
else
{
    $lang->action->label->execution = "$lang->executionCommon|execution|task|executionID=%s";
}
$lang->action->label->task         = '任務|task|view|taskID=%s';
$lang->action->label->build        = '版本|build|view|buildID=%s';
$lang->action->label->bug          = 'Bug|bug|view|bugID=%s';
$lang->action->label->case         = '用例|testcase|view|caseID=%s';
$lang->action->label->testtask     = '測試單|testtask|view|caseID=%s';
$lang->action->label->testsuite    = '測試套件|testsuite|view|suiteID=%s';
$lang->action->label->caselib      = '用例庫|caselib|view|libID=%s';
$lang->action->label->todo         = '待辦|todo|view|todoID=%s';
$lang->action->label->doclib       = '文檔庫|doc|tablecontents|type=%s&objectID=%s&libID=%s';
$lang->action->label->doc          = '文檔|doc|view|docID=%s';
$lang->action->label->user         = '用戶|user|view|account=%s';
$lang->action->label->testreport   = '報告|testreport|view|report=%s';
$lang->action->label->entry        = '應用|entry|browse|';
$lang->action->label->webhook      = 'Webhook|webhook|browse|';
$lang->action->label->space        = ' ';
$lang->action->label->risk         = '風險|risk|view|riskID=%s';
$lang->action->label->issue        = '問題|issue|view|issueID=%s';
$lang->action->label->design       = '設計|design|view|designID=%s';
$lang->action->label->stakeholder  = '干係人|stakeholder|view|userID=%s';
$lang->action->label->api          = '介面|api|index|libID=%s&moduleID=%s&apiID=%s';
$lang->action->label->kanbanspace  = '看板空間|kanban|space|browseType=%s';
$lang->action->label->kanbanregion = '看板區域|kanban|view|kanbanID=%s';
$lang->action->label->kanban       = '看板|kanban|view|kanbanID=%s';
$lang->action->label->kanbancolumn = '看板列|execution|kanban|execution=%s';
$lang->action->label->kanbanlane   = '看板泳道|execution|kanban|execution=%s&type=all';
$lang->action->label->kanbancard   = '看板卡片|kanban|view|kanbanID=%s';
$lang->action->label->mr           = '合併請求|mr|view|id=%s';

/* Object type. */
$lang->action->search = new stdclass();
$lang->action->search->objectTypeList['']            = '';
$lang->action->search->objectTypeList['product']     = $lang->productCommon;
$lang->action->search->objectTypeList['program']     = '項目集';
$lang->action->search->objectTypeList['project']     = '項目';
$lang->action->search->objectTypeList['execution']   = '執行';
$lang->action->search->objectTypeList['bug']         = 'Bug';
$lang->action->search->objectTypeList['case']        = '用例';
$lang->action->search->objectTypeList['caseresult']  = '用例結果';
$lang->action->search->objectTypeList['stepresult']  = '用例步驟';
$lang->action->search->objectTypeList['story']       = "$lang->SRCommon/$lang->URCommon";
$lang->action->search->objectTypeList['task']        = '任務';
$lang->action->search->objectTypeList['testtask']    = '測試單';
$lang->action->search->objectTypeList['user']        = '用戶';
$lang->action->search->objectTypeList['doc']         = '文檔';
$lang->action->search->objectTypeList['doclib']      = '文檔庫';
$lang->action->search->objectTypeList['todo']        = '待辦';
$lang->action->search->objectTypeList['build']       = '版本';
$lang->action->search->objectTypeList['release']     = '發佈';
$lang->action->search->objectTypeList['productplan'] = '計劃';
$lang->action->search->objectTypeList['branch']      = '分支';
$lang->action->search->objectTypeList['testsuite']   = '套件';
$lang->action->search->objectTypeList['caselib']     = '公共庫';
$lang->action->search->objectTypeList['testreport']  = '報告';

/* 用來在動態顯示中顯示動作 */
$lang->action->search->label['']                      = '';
$lang->action->search->label['created']               = $lang->action->label->created;
$lang->action->search->label['opened']                = $lang->action->label->opened;
$lang->action->search->label['changed']               = $lang->action->label->changed;
$lang->action->search->label['edited']                = $lang->action->label->edited;
$lang->action->search->label['assigned']              = $lang->action->label->assigned;
$lang->action->search->label['closed']                = $lang->action->label->closed;
$lang->action->search->label['deleted']               = $lang->action->label->deleted;
$lang->action->search->label['deletedfile']           = $lang->action->label->deletedfile;
$lang->action->search->label['editfile']              = $lang->action->label->editfile;
$lang->action->search->label['erased']                = $lang->action->label->erased;
$lang->action->search->label['undeleted']             = $lang->action->label->undeleted;
$lang->action->search->label['hidden']                = $lang->action->label->hidden;
$lang->action->search->label['commented']             = $lang->action->label->commented;
$lang->action->search->label['activated']             = $lang->action->label->activated;
$lang->action->search->label['blocked']               = $lang->action->label->blocked;
$lang->action->search->label['resolved']              = $lang->action->label->resolved;
$lang->action->search->label['reviewed']              = $lang->action->label->reviewed;
$lang->action->search->label['moved']                 = $lang->action->label->moved;
$lang->action->search->label['confirmed']             = $lang->action->label->confirmed;
$lang->action->search->label['bugconfirmed']          = $lang->action->label->bugconfirmed;
$lang->action->search->label['tostory']               = $lang->action->label->tostory;
$lang->action->search->label['frombug']               = $lang->action->label->frombug;
$lang->action->search->label['totask']                = $lang->action->label->totask;
$lang->action->search->label['svncommited']           = $lang->action->label->svncommited;
$lang->action->search->label['gitcommited']           = $lang->action->label->gitcommited;
$lang->action->search->label['linked2plan']           = $lang->action->label->linked2plan;
$lang->action->search->label['unlinkedfromplan']      = $lang->action->label->unlinkedfromplan;
$lang->action->search->label['changestatus']          = $lang->action->label->changestatus;
$lang->action->search->label['marked']                = $lang->action->label->marked;
$lang->action->search->label['linked2project']        = $lang->action->label->linked2project;
$lang->action->search->label['unlinkedfromproject']   = $lang->action->label->unlinkedfromproject;
$lang->action->search->label['linked2execution']      = $lang->action->label->linked2execution;
$lang->action->search->label['unlinkedfromexecution'] = $lang->action->label->unlinkedfromexecution;
$lang->action->search->label['started']               = $lang->action->label->started;
$lang->action->search->label['restarted']             = $lang->action->label->restarted;
$lang->action->search->label['recordestimate']        = $lang->action->label->recordestimate;
$lang->action->search->label['editestimate']          = $lang->action->label->editestimate;
$lang->action->search->label['canceled']              = $lang->action->label->canceled;
$lang->action->search->label['finished']              = $lang->action->label->finished;
$lang->action->search->label['paused']                = $lang->action->label->paused;
$lang->action->search->label['verified']              = $lang->action->label->verified;
$lang->action->search->label['importfromgitlab']      = $lang->action->label->importfromgitlab;
$lang->action->search->label['login']                 = $lang->action->label->login;
$lang->action->search->label['logout']                = $lang->action->label->logout;

/* Action language config for API(JIHU) */
$lang->action->apiTitle = new stdclass();
$lang->action->apiTitle->opened                = '首次創建。';
$lang->action->apiTitle->created               = '首次創建。';
$lang->action->apiTitle->added                 = '添加成功。';
$lang->action->apiTitle->changed               = '進行了需求變更。';
$lang->action->apiTitle->edited                = '編輯操作。';
$lang->action->apiTitle->assigned              = '指派給 <strong>%s</strong>。';
$lang->action->apiTitle->closed                = '執行了關閉操作。';
$lang->action->apiTitle->deleted               = '執行刪除操作。';
$lang->action->apiTitle->deletedfile           = '刪除了附件：<strong><i>%s</i></strong>。';
$lang->action->apiTitle->editfile              = '編輯了附件：<strong><i>%s</i></strong>。';
$lang->action->apiTitle->erased                = '執行了刪除操作。';
$lang->action->apiTitle->undeleted             = '執行還原操作。';
$lang->action->apiTitle->hidden                = '進行隱藏操作。';
$lang->action->apiTitle->commented             = '添加了備註';
$lang->action->apiTitle->activated             = '執行激活操作。';
$lang->action->apiTitle->confirmed             = '確認' . $lang->SRCommon . '變動，最新版本為<strong>#%s</strong>。';
$lang->action->apiTitle->caseconfirmed         = '確認用例變動，最新版本為<strong>#%s</strong>。';
$lang->action->apiTitle->bugconfirmed          = '確認了Bug。';
$lang->action->apiTitle->frombug               = 'Bug轉化而來，Bug編號為 <strong>%s</strong>。';
$lang->action->apiTitle->started               = '啟動。';
$lang->action->apiTitle->restarted             = '繼續。';
$lang->action->apiTitle->delayed               = '執行了延期操作。';
$lang->action->apiTitle->suspended             = '掛起。';
$lang->action->apiTitle->recordestimate        = '記錄工時，消耗 <strong>%s</strong> 小時。';
$lang->action->apiTitle->editestimate          = '編輯了工時。';
$lang->action->apiTitle->deleteestimate        = '刪除工時。';
$lang->action->apiTitle->canceled              = '執行取消操作。';
$lang->action->apiTitle->svncommited           = '提交代碼，版本為<strong>#%s</strong>。';
$lang->action->apiTitle->gitcommited           = '提交代碼，版本為<strong>#%s</strong>。';
$lang->action->apiTitle->finished              = '完成。';
$lang->action->apiTitle->paused                = '暫停。';
$lang->action->apiTitle->linked2bug            = '關聯到版本 <strong>%s</strong>';
$lang->action->apiTitle->linked2testtask       = '關聯到測試單 <strong>%s</strong>';
$lang->action->apiTitle->resolved              = '解決。';
$lang->action->apiTitle->managed               = '維護。';
$lang->action->apiTitle->estimated             = '估算。';
$lang->action->apiTitle->run                   = '執行。';
$lang->action->apiTitle->tostory               = "轉{$lang->SRCommon}";
$lang->action->apiTitle->createchildren        = '創建子任務 <strong>%s</strong>。';
$lang->action->apiTitle->linkchildtask         = '關聯子任務 <strong>%s</strong>。';
$lang->action->apiTitle->unlinkchildrentask    = '移除子任務 <strong>%s</strong>。';
$lang->action->apiTitle->linkparenttask        = '關聯到父任務 <strong>%s</strong>。';
$lang->action->apiTitle->unlinkparenttask      = '從父任務<strong>%s</strong>取消關聯。';
$lang->action->apiTitle->deletechildrentask    = '刪除子任務<strong>%s</strong>。';
$lang->action->apiTitle->createchildrenstory   = '創建子需求 <strong>%s</strong>。';
$lang->action->apiTitle->linkchildstory        = '關聯子需求 <strong>%s</strong>。';
$lang->action->apiTitle->unlinkchildrenstory   = '移除子需求 <strong>%s</strong>。';
$lang->action->apiTitle->linkparentstory       = '關聯到父需求 <strong>%s</strong>。';
$lang->action->apiTitle->unlinkparentstory     = '從父需求<strong>%s</strong>取消關聯。';
$lang->action->apiTitle->deletechildrenstory   = '刪除子需求<strong>%s</strong>。';
$lang->action->apiTitle->linkrelatedcase       = '關聯相關用例 <strong>%s</strong>。';
$lang->action->apiTitle->unlinkrelatedcase     = '移除相關用例 <strong>%s</strong>。';
$lang->action->apiTitle->openedbysystem        = '系統創建';
$lang->action->apiTitle->closedbysystem        = '系統關閉';
$lang->action->apiTitle->communicated          = '溝通';
$lang->action->apiTitle->blocked               = '阻塞';
$lang->action->apiTitle->reviewed              = '評審';
$lang->action->apiTitle->recalled              = '撤銷評審';
$lang->action->apiTitle->moved                 = '移動';
$lang->action->apiTitle->fromlib               = '從用例庫導入';
$lang->action->apiTitle->totask                = '轉任務';
$lang->action->apiTitle->linked2plan           = "關聯計劃";
$lang->action->apiTitle->unlinkedfromplan      = "移除計劃";
$lang->action->apiTitle->changestatus          = '修改狀態';
$lang->action->apiTitle->marked                = '編輯';
$lang->action->apiTitle->linked2execution      = "關聯{$lang->executionCommon}";
$lang->action->apiTitle->unlinkedfromexecution = "移除{$lang->executionCommon}";
$lang->action->apiTitle->linked2project        = "關聯項目";
$lang->action->apiTitle->unlinkedfromproject   = "移除項目";
$lang->action->apiTitle->unlinkedfrombuild     = "移除版本";
$lang->action->apiTitle->linked2release        = "關聯發佈";
$lang->action->apiTitle->unlinkedfromrelease   = "移除發佈";
$lang->action->apiTitle->linkrelatedbug        = "關聯了相關Bug";
$lang->action->apiTitle->unlinkrelatedbug      = "移除了相關Bug";
$lang->action->apiTitle->linkrelatedstory      = "關聯了相關{$lang->SRCommon}";
$lang->action->apiTitle->unlinkrelatedstory    = "移除了相關{$lang->SRCommon}";
$lang->action->apiTitle->subdividestory        = "細分了{$lang->SRCommon}";
$lang->action->apiTitle->unlinkchildstory      = "移除了細分{$lang->SRCommon}";
$lang->action->apiTitle->verified              = '驗收';
$lang->action->apiTitle->login                 = '登錄系統';
$lang->action->apiTitle->logout                = "退出登錄";
$lang->action->apiTitle->linked2build          = "關聯";
$lang->action->apiTitle->unlinkedfromtesttask  = "移除";
$lang->action->apiTitle->batchcreate           = "批量創建任務";
$lang->action->apiTitle->managedteam           = "維護";
$lang->action->apiTitle->managedwhitelist      = "維護";
$lang->action->apiTitle->tracked               = '跟蹤';
$lang->action->apiTitle->hangup                = '掛起';
$lang->action->apiTitle->reviewpassed          = '確認通過';
$lang->action->apiTitle->reviewrejected        = '拒絶';
$lang->action->apiTitle->reviewclarified       = '有待明確';
$lang->action->apiTitle->commitsummary         = '提交培訓總結';
$lang->action->apiTitle->updatetrainee         = '更新培訓人員';

/* Code Review in Repo or Merge Request module. */
$lang->action->desc->repocreated                  = '$date, 由 <strong>$actor</strong> 評審創建：$extra。' . "\n";
$lang->action->label->repocreated                 = "創建評審";
$lang->action->dynamicAction->task['gitcommited'] = 'git提交';
$lang->action->dynamicAction->bug['repocreated']  = '創建代碼評審';
$lang->action->desc->createmr                     = '$extra';
$lang->action->desc->mergedmr                     = '$date, 由 <strong>$actor</strong> 合併了 <a href="$extra">代碼</a>。';
$lang->action->desc->approve                      = '$date, 由 <strong>$actor</strong> 審核通過。';
$lang->action->desc->reject                       = '$date, 由 <strong>$actor</strong> 拒絶。';
