-- DROP TABLE IF EXISTS `zt_acl`;
CREATE TABLE IF NOT EXISTS `zt_acl` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `objectType` char(30) NOT NULL,
  `objectID` mediumint(9) NOT NULL DEFAULT '0',
  `type` char(40) NOT NULL DEFAULT 'whitelist',
  `source` char(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_action`;
CREATE TABLE IF NOT EXISTS `zt_action` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `objectType` varchar(30) NOT NULL default '',
  `objectID` mediumint(8) unsigned NOT NULL default '0',
  `product` varchar(255) NOT NULL,
  `project` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `actor` varchar(100) NOT NULL default '',
  `action` varchar(30) NOT NULL default '',
  `date` datetime NOT NULL,
  `comment` text NOT NULL,
  `extra` text NOT NULL,
  `read` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `date` (`date`),
  KEY `actor` (`actor`),
  KEY `project` (`project`),
  KEY `action` (`action`),
  KEY `objectID` (`objectID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_api_lib_release`;
CREATE TABLE `zt_api_lib_release`
(
    `id`        int UNSIGNED NOT NULL AUTO_INCREMENT,
    `lib`    int UNSIGNED NOT NULL DEFAULT 0,
    `desc`      varchar(255) NOT NULL DEFAULT '',
    `version`   varchar(255) NOT NULL DEFAULT '',
    `snap`      mediumtext   NOT NULL,
    `addedBy`   varchar(30)  NOT NULL DEFAULT 0,
    `addedDate` datetime     NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_api`;
CREATE TABLE `zt_api`
(
    `id`              int UNSIGNED NOT NULL AUTO_INCREMENT,
    `product`         varchar(255) NOT NULL DEFAULT '',
    `lib`             int UNSIGNED NOT NULL DEFAULT 0,
    `module`          int UNSIGNED NOT NULL DEFAULT 0,
    `title`           varchar(100) NOT NULL DEFAULT '',
    `path`            varchar(255) NOT NULL DEFAULT '',
    `protocol`        varchar(10)  NOT NULL DEFAULT '',
    `method`          varchar(10)  NOT NULL DEFAULT '',
    `requestType`     varchar(100) NOT NULL DEFAULT '',
    `responseType`    varchar(100) NOT NULL DEFAULT '',
    `status`          varchar(20)  NOT NULL DEFAULT '',
    `owner`           varchar(30)  NOT NULl DEFAULT 0,
    `desc`            text NULL,
    `version`         smallint UNSIGNED NOT NULL DEFAULT 0,
    `params`          text NULL,
    `paramsExample`   text NUll,
    `responseExample` text NUll,
    `response`        text NULL,
    `commonParams`    text NULL,
    `addedBy`         varchar(30)  NOT NULL DEFAULT 0,
    `addedDate`       datetime     NOT NULL,
    `editedBy`        varchar(30)  NOT NULL DEFAULT 0,
    `editedDate`      datetime     NOT NULL,
    `deleted`         enum ('0', '1') NOT NULL DEFAULT '0',
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_apispec`;
CREATE TABLE `zt_apispec`
(
    `id`              int UNSIGNED NOT NULL AUTO_INCREMENT,
    `doc`             int UNSIGNED NOT NULL DEFAULT 0,
    `module`          int UNSIGNED NOT NULL DEFAULT 0,
    `title`           varchar(100) NOT NULL DEFAULT '',
    `path`            varchar(255) NOT NULL DEFAULT '',
    `protocol`        varchar(10)  NOT NULL DEFAULT '',
    `method`          varchar(10)  NOT NULL DEFAULT '',
    `requestType`     varchar(100) NOT NULL DEFAULT '',
    `responseType`    varchar(100) NOT NULL DEFAULT '',
    `status`          varchar(20)  NOT NULL DEFAULT '',
    `owner`           varchar(255) NOT NULl DEFAULT 0,
    `desc`            text NULL,
    `version`         smallint UNSIGNED NOT NULL DEFAULT 0,
    `params`          text NULL,
    `paramsExample`   text NUll,
    `responseExample` text NUll,
    `response`        text NULL,
    `addedBy`         varchar(30)  NOT NULL DEFAULT 0,
    `addedDate`       datetime NULL,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_apistruct`;
CREATE TABLE `zt_apistruct`
(
    `id`         int unsigned NOT NULL AUTO_INCREMENT,
    `lib`        int UNSIGNED NOT NULL DEFAULT 0,
    `name`       varchar(30)  NOT NULL DEFAULT '',
    `type`       varchar(50)  NOT NULL DEFAULT '',
    `desc`       text NOT NULL DEFAULT '',
    `version`    smallint unsigned NOT NULL DEFAULT 0,
    `attribute`  text NULL,
    `addedBy`    varchar(30)  NOT NULL DEFAULT 0,
    `addedDate`  datetime     NOT NULL,
    `editEdBy`   varchar(30)  NOT NULL DEFAULT 0,
    `editedDate` datetime     NOT NULL,
    `deleted`    enum ('0', '1') NOT NULL DEFAULT '0',
    primary key (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_apistruct_spec`;
CREATE TABLE `zt_apistruct_spec`
(
    `id`        int UNSIGNED NOT NULL AUTO_INCREMENT,
    `name`      varchar(255) NOT NULL DEFAULT '',
    `type`      varchar(50)  NOT NULL DEFAULT '',
    `desc`      varchar(255) NOT NULL DEFAULT '',
    `attribute` text NULL,
    `version`   smallint unsigned NOT NULL DEFAULT 0,
    `addedBy`   varchar(30)  NOT NULL DEFAULT 0,
    `addedDate` datetime     NOT NULL,
    primary key (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_block`;
CREATE TABLE IF NOT EXISTS `zt_block` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `module` varchar(20) NOT NULL,
  `type` char(30) NOT NULL,
  `title` varchar(100) NOT NULL,
  `source` varchar(20) NOT NULL,
  `block` varchar(20) NOT NULL,
  `params` text NOT NULL,
  `order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `grid` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `height` smallint(5) unsigned NOT NULL DEFAULT '0',
  `hidden` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `account_module_type_order` (`account`,`module`,`type`,`order`),
  KEY `account` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_branch`;
CREATE TABLE IF NOT EXISTS `zt_branch` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `order` smallint unsigned NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY  (`id`),
  KEY `product` (`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_bug`;
CREATE TABLE IF NOT EXISTS `zt_bug` (
  `id` mediumint(8) NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `execution` mediumint(8) unsigned NOT NULL default '0',
  `plan` mediumint(8) unsigned NOT NULL default '0',
  `story` mediumint(8) unsigned NOT NULL default '0',
  `storyVersion` smallint(6) NOT NULL default '1',
  `task` mediumint(8) unsigned NOT NULL default '0',
  `toTask` mediumint(8) unsigned NOT NULL default '0',
  `toStory` mediumint(8) NOT NULL default '0',
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `severity` tinyint(4) NOT NULL default '0',
  `pri` tinyint(3) unsigned NOT NULL,
  `type` varchar(30) NOT NULL default '',
  `os` varchar(30) NOT NULL default '',
  `browser` varchar(30) NOT NULL default '',
  `hardware` varchar(30) NOT NULL,
  `found` varchar(30) NOT NULL default '',
  `steps` text NOT NULL,
  `status` enum('active','resolved','closed') NOT NULL default 'active',
  `subStatus` varchar(30) NOT NULL default '',
  `color` char(7) NOT NULL,
  `confirmed` tinyint(1) NOT NULL default '0',
  `activatedCount` smallint(6) NOT NULL,
  `activatedDate` datetime NOT NULL,
  `mailto` text,
  `openedBy` varchar(30) NOT NULL default '',
  `openedDate` datetime NOT NULL,
  `openedBuild` varchar(255) NOT NULL,
  `assignedTo` varchar(30) NOT NULL default '',
  `assignedDate` datetime NOT NULL,
  `deadline` date NOT NULL,
  `resolvedBy` varchar(30) NOT NULL default '',
  `resolution` varchar(30) NOT NULL default '',
  `resolvedBuild` varchar(30) NOT NULL default '',
  `resolvedDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL default '',
  `closedDate` datetime NOT NULL,
  `duplicateBug` mediumint(8) unsigned NOT NULL,
  `linkBug` varchar(255) NOT NULL,
  `case` mediumint(8) unsigned NOT NULL,
  `caseVersion` smallint(6) NOT NULL DEFAULT '1',
  `result` mediumint(8) unsigned NOT NULL,
  `repo` mediumint(8) unsigned NOT NULL,
  `entry` varchar(255) NOT NULL,
  `lines` varchar(10) NOT NULL,
  `v1` varchar(40) NOT NULL,
  `v2` varchar(40) NOT NULL,
  `repoType` varchar(30) NOT NULL DEFAULT '',
  `testtask` mediumint(8) unsigned NOT NULL,
  `lastEditedBy` varchar(30) NOT NULL default '',
  `lastEditedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`),
  KEY `status` (`status`),
  KEY `plan` (`plan`),
  KEY `story` (`story`),
  KEY `case` (`case`),
  KEY `toStory` (`toStory`),
  KEY `result` (`result`),
  KEY `assignedTo` (`assignedTo`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_build`;
CREATE TABLE IF NOT EXISTS `zt_build` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `execution` mediumint(8) unsigned NOT NULL default '0',
  `name` char(150) NOT NULL,
  `scmPath` char(255) NOT NULL,
  `filePath` char(255) NOT NULL,
  `date` date NOT NULL,
  `stories` text NOT NULL,
  `bugs` text NOT NULL,
  `builder` char(30) NOT NULL default '',
  `desc` text NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_burn`;
CREATE TABLE IF NOT EXISTS `zt_burn` (
  `execution` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `task` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `date` date NOT NULL,
  `estimate` float NOT NULL,
  `left` float NOT NULL,
  `consumed` float NOT NULL,
  `storyPoint` float NOT NULL,
  PRIMARY KEY  (`execution`,`date`,`task`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_case`;
CREATE TABLE IF NOT EXISTS `zt_case` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `execution` mediumint(8) unsigned NOT NULL,
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `lib` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `path` mediumint(8) unsigned NOT NULL default '0',
  `story` mediumint(30) unsigned NOT NULL default '0',
  `storyVersion` smallint(6) NOT NULL default '1',
  `title` varchar(255) NOT NULL,
  `precondition` text NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `pri` tinyint(3) unsigned NOT NULL default '3',
  `type` char(30) NOT NULL default '1',
  `auto` varchar(10) NOT NULL default 'no',
  `frame` varchar(10) NOT NULL,
  `stage` varchar(255) NOT NULL,
  `howRun` varchar(30) NOT NULL,
  `scriptedBy` varchar(30) NOT NULL,
  `scriptedDate` date NOT NULL,
  `scriptStatus` varchar(30) NOT NULL,
  `scriptLocation` varchar(255) NOT NULL,
  `status` char(30) NOT NULL default '1',
  `subStatus` varchar(30) NOT NULL default '',
  `color` char(7) NOT NULL,
  `frequency` enum('1','2','3') NOT NULL default '1',
  `order` tinyint(30) unsigned NOT NULL default '0',
  `openedBy` char(30) NOT NULL default '',
  `openedDate` datetime NOT NULL,
  `reviewedBy` varchar(255) NOT NULL,
  `reviewedDate` date NOT NULL,
  `lastEditedBy` char(30) NOT NULL default '',
  `lastEditedDate` datetime NOT NULL,
  `version` tinyint(3) unsigned NOT NULL default '0',
  `linkCase` varchar(255) NOT NULL,
  `fromBug` mediumint(8) unsigned NOT NULL,
  `fromCaseID` mediumint(8) unsigned NOT NULL,
  `fromCaseVersion` mediumint(8) unsigned NOT NULL default '1',
  `deleted` enum('0','1') NOT NULL default '0',
  `lastRunner` varchar(30) NOT NULL,
  `lastRunDate` datetime NOT NULL,
  `lastRunResult` char(30) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `story` (`story`),
  KEY `fromBug` (`fromBug`),
  KEY `module` (`module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_casestep`;
CREATE TABLE IF NOT EXISTS `zt_casestep` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `case` mediumint(8) unsigned NOT NULL default '0',
  `version` smallint(3) unsigned NOT NULL default '0',
  `type` varchar(10) NOT NULL DEFAULT 'step',
  `desc` text NOT NULL,
  `expect` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `case` (`case`),
  KEY `version` (`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_company`;
CREATE TABLE IF NOT EXISTS `zt_company` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` char(120) default NULL,
  `phone` char(20) default NULL,
  `fax` char(20) default NULL,
  `address` char(120) default NULL,
  `zipcode` char(10) default NULL,
  `website` char(120) default NULL,
  `backyard` char(120) default NULL,
  `guest` enum('1','0') NOT NULL default '0',
  `admins` char(255) default NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_compile`;
CREATE TABLE IF NOT EXISTS `zt_compile` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `job` mediumint(8) unsigned NOT NULL,
  `queue` mediumint(8) NOT NULL,
  `status` varchar(255) NOT NULL,
  `logs` text,
  `atTime` varchar(10) NOT NULL,
  `testtask` mediumint(8) unsigned NOT NULL,
  `tag` varchar(255) NOT NULL,
  `times` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `updateDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_config`;
CREATE TABLE IF NOT EXISTS `zt_config` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `owner` char(30) NOT NULL default '',
  `module` varchar(30) NOT NULL,
  `section` char(30) NOT NULL default '',
  `key` char(30) NOT NULL default '',
  `value` longtext NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `unique` (`owner`,`module`,`section`,`key`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_cron`;
CREATE TABLE IF NOT EXISTS `zt_cron` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `m` varchar(20) NOT NULL,
  `h` varchar(20) NOT NULL,
  `dom` varchar(20) NOT NULL,
  `mon` varchar(20) NOT NULL,
  `dow` varchar(20) NOT NULL,
  `command` text NOT NULL,
  `remark` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `buildin` tinyint(1) NOT NULL DEFAULT '0',
  `status` varchar(20) NOT NULL,
  `lastTime` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `lastTime` (`lastTime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_dept`;
CREATE TABLE IF NOT EXISTS `zt_dept` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` char(60) NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `path` char(255) NOT NULL default '',
  `grade` tinyint(3) unsigned NOT NULL default '0',
  `order` smallint(4) unsigned NOT NULL default '0',
  `position` char(30) NOT NULL default '',
  `function` char(255) NOT NULL default '',
  `manager` char(30) NOT NULL default '',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `path` (`path`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_doc`;
CREATE TABLE IF NOT EXISTS `zt_doc` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `lib` varchar(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `type` varchar(30) NOT NULL,
  `views` smallint(5) unsigned NOT NULL,
  `draft` longtext NOT NULL,
  `collector` text NOT NULL,
  `addedBy` varchar(30) NOT NULL,
  `addedDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `mailto` text,
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `groups` varchar(255) NOT NULL,
  `users` text NOT NULL,
  `version` smallint(5) unsigned NOT NULL DEFAULT '1',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`),
  KEY `lib` (`lib`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_doccontent`;
CREATE TABLE IF NOT EXISTS `zt_doccontent` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `doc` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `digest` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `files` text NOT NULL,
  `type` varchar(10) NOT NULL,
  `version` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `doc_version` (`doc`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_doclib`;
CREATE TABLE IF NOT EXISTS `zt_doclib` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `type` varchar(30) NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `project` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `name` varchar(60) NOT NULL,
  `baseUrl` varchar(255) NOT NULL DEFAULT '',
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `groups` varchar(255) NOT NULL,
  `users` text NOT NULL,
  `main` enum('0','1') NOT NULL default '0',
  `collector` text NOT NULL,
  `desc` text NOT NULL,
  `order` tinyint(5) unsigned NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_effort`;
CREATE TABLE IF NOT EXISTS `zt_effort` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `user` char(30) NOT NULL default '',
  `todo` enum('1','0') NOT NULL default '1',
  `date` date NOT NULL,
  `begin` datetime NOT NULL default '0000-00-00 00:00:00',
  `end` datetime NOT NULL default '0000-00-00 00:00:00',
  `type` enum('1','2','3') NOT NULL default '1',
  `idvalue` mediumint(8) unsigned NOT NULL default '0',
  `name` char(30) NOT NULL default '',
  `desc` char(255) NOT NULL default '',
  `status` enum('1','2','3') NOT NULL default '1',
  PRIMARY KEY  (`id`),
  KEY `user` (`user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_entry`;
CREATE TABLE IF NOT EXISTS `zt_entry` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `account` varchar(30) NOT NULL DEFAULT '',
  `code` varchar(20) NOT NULL,
  `key` varchar(32) NOT NULL,
  `freePasswd` enum('0','1') NOT NULL DEFAULT '0',
  `ip` varchar(100) NOT NULL,
  `desc` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `calledTime` int(10) unsigned NOT NULL DEFAULT '0',
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_expect`;
CREATE TABLE IF NOT EXISTS `zt_expect` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `userID` mediumint(8) NOT NULL,
  `project` mediumint(8) NOT NULL DEFAULT 0,
  `expect` text NOT NULL,
  `progress` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_extension`;
CREATE TABLE IF NOT EXISTS `zt_extension` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` varchar(150) NOT NULL,
  `code` varchar(30) NOT NULL,
  `version` varchar(50) NOT NULL,
  `author` varchar(100) NOT NULL,
  `desc` text NOT NULL,
  `license` text NOT NULL,
  `type` varchar(20) NOT NULL default 'extension',
  `site` varchar(150) NOT NULL,
  `zentaoCompatible` varchar(100) NOT NULL,
  `installedTime` datetime NOT NULL,
  `depends` varchar(100) NOT NULL,
  `dirs` mediumtext NOT NULL,
  `files` mediumtext NOT NULL,
  `status` varchar(20) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `name` (`name`),
  KEY `installedTime` (`installedTime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_file`;
CREATE TABLE IF NOT EXISTS `zt_file` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `pathname` char(50) NOT NULL,
  `title` char(255) NOT NULL,
  `extension` char(30) NOT NULL,
  `size` int(10) unsigned NOT NULL default '0',
  `objectType` char(30) NOT NULL,
  `objectID` mediumint(9) NOT NULL,
  `addedBy` char(30) NOT NULL default '',
  `addedDate` datetime NOT NULL,
  `downloads` mediumint(8) unsigned NOT NULL default '0',
  `extra` varchar(255) NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `objectType` (`objectType`),
  KEY `objectID` (`objectID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_group`;
CREATE TABLE IF NOT EXISTS `zt_group` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` char(30) NOT NULL,
  `role` char(30) NOT NULL default '',
  `desc` char(255) NOT NULL default '',
  `acl` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_grouppriv`;
CREATE TABLE IF NOT EXISTS `zt_grouppriv` (
  `group` mediumint(8) unsigned NOT NULL default '0',
  `module` char(30) NOT NULL default '',
  `method` char(30) NOT NULL default '',
  UNIQUE KEY `group` (`group`,`module`,`method`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_history`;
CREATE TABLE IF NOT EXISTS `zt_history` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `action` mediumint(8) unsigned NOT NULL default '0',
  `field` varchar(30) NOT NULL default '',
  `old` text NOT NULL,
  `new` text NOT NULL,
  `diff` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `action` (`action`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_job`;
CREATE TABLE IF NOT EXISTS `zt_job` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `repo` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `frame` varchar(20) NOT NULL,
  `engine` varchar(20) NOT NULL,
  `server` mediumint(8) unsigned NOT NULL,
  `pipeline` varchar(500) NOT NULL,
  `triggerType` varchar(255) NOT NULL,
  `svnDir` varchar(255) NOT NULL,
  `atDay` varchar(255) DEFAULT NULL,
  `atTime` varchar(10) DEFAULT NULL,
  `customParam` text NOT NULL,
  `comment` varchar(255) DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `lastExec` datetime DEFAULT NULL,
  `lastStatus` varchar(255) DEFAULT NULL,
  `lastTag` varchar(255) DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_lang`;
CREATE TABLE IF NOT EXISTS `zt_lang` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `lang` varchar(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `section` varchar(30) NOT NULL,
  `key` varchar(60) NOT NULL,
  `value` text NOT NULL,
  `system` enum('0','1') NOT NULL default '1',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `lang` (`lang`,`module`,`section`,`key`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_log`;
CREATE TABLE IF NOT EXISTS `zt_log` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL,
  `objectID` mediumint(8) unsigned NOT NULL,
  `action` mediumint(8) unsigned NOT NULL,
  `date` datetime NOT NULL,
  `url` varchar(255) NOT NULL,
  `contentType` varchar(30) NOT NULL,
  `data` text NOT NULL,
  `result` text  NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `objectType` (`objectType`),
  KEY `obejctID` (`objectID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_module`;
CREATE TABLE IF NOT EXISTS `zt_module` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `root` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `name` char(60) NOT NULL default '',
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `path` char(255) NOT NULL default '',
  `grade` tinyint(3) unsigned NOT NULL default '0',
  `order` smallint(5) unsigned NOT NULL default '0',
  `type` char(30) NOT NULL,
  `owner` varchar(30) NOT NULL,
  `collector` text NOT NULL,
  `short` varchar(30) NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `root` (`root`),
  KEY `type` (`type`),
  KEY `path` (`path`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_mr`;
CREATE TABLE IF NOT EXISTS `zt_mr` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gitlabID` mediumint(8) unsigned NOT NULL,
  `sourceProject` int unsigned NOT NULL,
  `sourceBranch` varchar(100) NOT NULL,
  `targetProject` int unsigned NOT NULL,
  `targetBranch` varchar(100) NOT NULL,
  `mriid` int unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `assignee` varchar(255) NOT NULL,
  `reviewer` varchar(255) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `status` char(30) NOT NULL,
  `mergeStatus` char(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_notify`;
CREATE TABLE IF NOT EXISTS `zt_notify` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(50) NOT NULL,
  `objectID` mediumint unsigned NOT NULL,
  `action` mediumint NOT NULL,
  `toList` varchar(255) NOT NULL,
  `ccList` text NOT NULL,
  `subject` varchar(255) NOT NULL,
  `data` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `sendTime` datetime NOT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `failReason` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `objectType_toList_status` (`objectType`,`toList`,`status`)
) ENGINE='MyISAM' COLLATE 'utf8_general_ci';
-- DROP TABLE IF EXISTS `zt_oauth`;
CREATE TABLE IF NOT EXISTS `zt_oauth` (
  `account` varchar(30) NOT NULL,
  `openID` varchar(255) NOT NULL,
  `providerType` varchar(30) NOT NULL,
  `providerID` mediumint(8) unsigned NOT NULL,
  KEY `account` (`account`),
  KEY `providerType` (`providerType`),
  KEY `providerID` (`providerID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_pipeline`;
CREATE TABLE IF NOT EXISTS `zt_pipeline` (
  `id` smallint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` char(30) NOT NULL,
  `name` varchar(50) NOT NULL,
  `url` varchar(255) DEFAULT NULL,
  `account` varchar(30) DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `token` varchar(255) DEFAULT NULL,
  `private` char(32) DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_planstory`;
CREATE TABLE IF NOT EXISTS `zt_planstory` (
  `plan` mediumint(8) unsigned NOT NULL,
  `story` mediumint(8) unsigned NOT NULL,
  `order` mediumint(9) NOT NULL,
  UNIQUE KEY `plan_story` (`plan`,`story`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_product`;
CREATE TABLE IF NOT EXISTS `zt_product` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `program` mediumint(8) unsigned NOT NULL,
  `name` varchar(90) NOT NULL,
  `code` varchar(45) NOT NULL,
  `bind` enum('0','1') NOT NULL DEFAULT '0',
  `line` mediumint(8) NOT NULL,
  `type` varchar(30) NOT NULL default 'normal',
  `status` varchar(30) NOT NULL default '',
  `subStatus` varchar(30) NOT NULL default '',
  `desc` text NOT NULL,
  `PO` varchar(30) NOT NULL,
  `QD` varchar(30) NOT NULL,
  `RD` varchar(30) NOT NULL,
  `acl` enum('open','private','custom') NOT NULL default 'open',
  `whitelist` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `createdVersion` varchar(20) NOT NULL,
  `order` mediumint(8) unsigned NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `acl` (`acl`),
  KEY `order` (`order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_productplan`;
CREATE TABLE IF NOT EXISTS `zt_productplan` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `product` mediumint(8) unsigned NOT NULL,
  `branch` mediumint(8) unsigned NOT NULL,
  `parent` mediumint(9) NOT NULL DEFAULT '0',
  `title` varchar(90) NOT NULL,
  `desc` text NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `order` text NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `end` (`end`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_project`;
CREATE TABLE IF NOT EXISTS `zt_project` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) NOT NULL DEFAULT 0,
  `model` char(30) NOT NULL,
  `type` char(30) NOT NULL DEFAULT 'sprint',
  `lifetime` char(30) NOT NULL DEFAULT '',
  `budget` varchar(30) NOT NULL DEFAULT '0',
  `budgetUnit` char(30) NOT NULL DEFAULT 'CNY',
  `attribute` varchar(30) NOT NULL DEFAULT '',
  `percent` float unsigned NOT NULL DEFAULT '0',
  `milestone` enum('0','1') NOT NULL DEFAULT '0',
  `output` text NOT NULL,
  `auth` char(30) NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL,
  `grade` tinyint(3) unsigned NOT NULL,
  `name` varchar(90) NOT NULL,
  `code` varchar(45) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `realBegan` date NOT NULL,
  `realEnd` date NOT NULL,
  `days` smallint(5) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `pri` enum('1','2','3','4') NOT NULL DEFAULT '1',
  `desc` text NOT NULL,
  `version` smallint(6) NOT NULL,
  `parentVersion` smallint(6) NOT NULL,
  `planDuration` int(11) NOT NULL,
  `realDuration` int(11) NOT NULL,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime NOT NULL,
  `openedVersion` varchar(20) NOT NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime NOT NULL,
  `canceledBy` varchar(30) NOT NULL DEFAULT '',
  `canceledDate` datetime NOT NULL,
  `PO` varchar(30) NOT NULL DEFAULT '',
  `PM` varchar(30) NOT NULL DEFAULT '',
  `QD` varchar(30) NOT NULL DEFAULT '',
  `RD` varchar(30) NOT NULL DEFAULT '',
  `team` varchar(90) NOT NULL,
  `acl` char(30) NOT NULL DEFAULT 'open',
  `whitelist` text NOT NULL,
  `order` mediumint(8) unsigned NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `begin` (`begin`),
  KEY `end` (`end`),
  KEY `status` (`status`),
  KEY `acl` (`acl`),
  KEY `order` (`order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_projectcase`;
CREATE TABLE IF NOT EXISTS `zt_projectcase` (
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `case` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `count` mediumint(8) unsigned NOT NULL DEFAULT '1',
  `version` smallint(6) NOT NULL DEFAULT '1',
  `order` smallint(6) unsigned NOT NULL,
  UNIQUE KEY `project` (`project`,`case`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_projectproduct`;
CREATE TABLE IF NOT EXISTS `zt_projectproduct` (
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `branch` mediumint(8) unsigned NOT NULL,
  `plan` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY  (`project`,`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_projectspec`;
CREATE TABLE IF NOT EXISTS `zt_projectspec` (
  `project` mediumint(8) NOT NULL,
  `version` smallint(6) NOT NULL,
  `name` varchar(255) NOT NULL,
  `milestone` enum('0','1') NOT NULL DEFAULT '0',
  `begin` date NOT NULL,
  `end` date NOT NULL,
  UNIQUE KEY `project` (`project`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_projectstory`;
CREATE TABLE IF NOT EXISTS `zt_projectstory` (
  `project` mediumint(8) unsigned NOT NULL default '0',
  `product` mediumint(8) unsigned NOT NULL,
  `story` mediumint(8) unsigned NOT NULL default '0',
  `version` smallint(6) NOT NULL default '1',
  `order` smallint(6) unsigned NOT NULL,
  UNIQUE KEY `project` (`project`,`story`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_relation`;
CREATE TABLE IF NOT EXISTS `zt_relation` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) NOT NULL,
  `product` mediumint(8) NOT NULL,
  `execution` mediumint(8) NOT NULL,
  `AType` char(30) NOT NULL,
  `AID` mediumint(8) NOT NULL,
  `AVersion` char(30) NOT NULL,
  `relation` char(30) NOT NULL,
  `BType` char(30) NOT NULL,
  `BID` mediumint(8) NOT NULL,
  `BVersion` char(30) NOT NULL,
  `extra` char(30) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `relation` (`product`,`relation`,`AType`,`BType`, `AID`, `BID`)
) ENGINE='MyISAM' DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_release`;
CREATE TABLE IF NOT EXISTS `zt_release` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `build` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL default '',
  `marker` enum('0','1') NOT NULL default '0',
  `date` date NOT NULL,
  `stories` text NOT NULL,
  `bugs` text NOT NULL,
  `leftBugs` text NOT NULL,
  `desc` text NOT NULL,
  `mailto` text,
  `notify` varchar(255),
  `status` varchar(20) NOT NULL default 'normal',
  `subStatus` varchar(30) NOT NULL default '',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `build` (`build`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_repo`;
CREATE TABLE IF NOT EXISTS `zt_repo` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `product` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `path` varchar(255) NOT NULL,
  `prefix` varchar(100) NOT NULL,
  `encoding` varchar(20) NOT NULL,
  `SCM` varchar(10) NOT NULL,
  `client` varchar(100) NOT NULL,
  `commits` mediumint(8) unsigned NOT NULL,
  `account` varchar(30) NOT NULL,
  `password` varchar(30) NOT NULL,
  `encrypt` varchar(30) NOT NULL DEFAULT 'plain',
  `acl` text NOT NULL,
  `synced` tinyint(1) NOT NULL DEFAULT '0',
  `lastSync` datetime NOT NULL,
  `desc` text NOT NULL,
  `extra` char(30) NOT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_repobranch`;
CREATE TABLE IF NOT EXISTS `zt_repobranch` (
  `repo` mediumint(8) unsigned NOT NULL,
  `revision` mediumint(8) unsigned NOT NULL,
  `branch` varchar(255) NOT NULL,
  UNIQUE KEY `repo_revision_branch` (`repo`,`revision`,`branch`),
  KEY `branch` (`branch`),
  KEY `revision` (`revision`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_repofiles`;
CREATE TABLE IF NOT EXISTS `zt_repofiles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `repo` mediumint(8) unsigned NOT NULL,
  `revision` mediumint(8) unsigned NOT NULL,
  `path` varchar(255) NOT NULL,
  `parent` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `action` char(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `path` (`path`),
  KEY `parent` (`parent`),
  KEY `repo` (`repo`),
  KEY `revision` (`revision`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_repohistory`;
CREATE TABLE IF NOT EXISTS `zt_repohistory` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `repo` mediumint(9) NOT NULL,
  `revision` varchar(40) NOT NULL,
  `commit` mediumint(8) unsigned NOT NULL,
  `comment` text NOT NULL,
  `committer` varchar(100) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `repo` (`repo`),
  KEY `revision` (`revision`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_score`;
CREATE TABLE IF NOT EXISTS `zt_score` (
  `id` bigint(12) unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(30) NOT NULL,
  `module` varchar(30) NOT NULL DEFAULT '',
  `method` varchar(30) NOT NULL,
  `desc` varchar(250) NOT NULL DEFAULT '',
  `before` int(11) NOT NULL DEFAULT '0',
  `score` int(11) NOT NULL DEFAULT '0',
  `after` int(11) NOT NULL DEFAULT '0',
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `model` (`module`),
  KEY `method` (`method`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_searchdict`;
CREATE TABLE IF NOT EXISTS `zt_searchdict` (
  `key` smallint(5) unsigned NOT NULL,
  `value` char(3) NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_searchindex`;
CREATE TABLE IF NOT EXISTS `zt_searchindex` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `objectType` char(20) NOT NULL,
  `objectID` mediumint(9) NOT NULL,
  `title` text NOT NULL,
  `content` text NOT NULL,
  `addedDate` datetime NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`objectType`,`objectID`),
  KEY `addedDate` (`addedDate`),
  FULLTEXT KEY `content` (`content`),
  FULLTEXT KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_stakeholder`;
CREATE TABLE IF NOT EXISTS `zt_stakeholder` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `objectID` mediumint(8) NOT NULL,
  `objectType` char(30) NOT NULL,
  `user` char(30) NOT NULL,
  `type` char(30) NOT NULL,
  `key` enum('0','1') NOT NULL,
  `from` char(30) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_story`;
CREATE TABLE IF NOT EXISTS `zt_story` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `parent` mediumint(9) NOT NULL default '0',
  `product` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `plan` text,
  `source` varchar(20) NOT NULL,
  `sourceNote` varchar(255) NOT NULL,
  `fromBug` mediumint(8) unsigned NOT NULL default '0',
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `type` varchar(30) NOT NULL default 'story',
  `category` varchar(30) NOT NULL default 'feature',
  `pri` tinyint(3) unsigned NOT NULL default '3',
  `estimate` float unsigned NOT NULL,
  `status` enum('','changed','active','draft','closed') NOT NULL default '',
  `subStatus` varchar(30) NOT NULL default '',
  `color` char(7) NOT NULL,
  `stage` enum('','wait','planned','projected','developing','developed','testing','tested','verified','released', 'closed') NOT NULL DEFAULT 'wait',
  `stagedBy` char(30) NOT NULL,
  `mailto` text,
  `openedBy` varchar(30) NOT NULL default '',
  `openedDate` datetime NOT NULL,
  `assignedTo` varchar(30) NOT NULL default '',
  `assignedDate` datetime NOT NULL,
  `lastEditedBy` varchar(30) NOT NULL default '',
  `lastEditedDate` datetime NOT NULL,
  `reviewedBy` varchar(255) NOT NULL,
  `reviewedDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `closedBy` varchar(30) NOT NULL default '',
  `closedDate` datetime NOT NULL,
  `closedReason` varchar(30) NOT NULL,
  `toBug` mediumint(8) unsigned NOT NULL,
  `childStories` varchar(255) NOT NULL,
  `linkStories` varchar(255) NOT NULL,
  `duplicateStory` mediumint(8) unsigned NOT NULL,
  `version` smallint(6) NOT NULL default '1',
  `URChanged` enum('0','1') NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `product` (`product`),
  KEY `status` (`status`),
  KEY `assignedTo` (`assignedTo`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_storyreview`;
CREATE TABLE IF NOT EXISTS `zt_storyreview` (
  `story` mediumint(9) NOT NULL,
  `version` smallint(6) NOT NULL,
  `reviewer` varchar(30) NOT NULL,
  `result` varchar(30) NOT NULL,
  `reviewDate` datetime NOT NULL,
  UNIQUE KEY `story` (`story`,`version`,`reviewer`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_storyestimate`;
CREATE TABLE IF NOT EXISTS `zt_storyestimate` (
  `story` mediumint(9) NOT NULL,
  `round` smallint(6) NOT NULL,
  `estimate` text NOT NULL,
  `average` float NOT NULL,
  `openedBy` varchar(30) NOT NULL,
  `openedDate` datetime NOT NULL,
  UNIQUE KEY `story` (`story`,`round`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_storyspec`;
CREATE TABLE IF NOT EXISTS `zt_storyspec` (
  `story` mediumint(9) NOT NULL,
  `version` smallint(6) NOT NULL,
  `title` varchar(255) NOT NULL,
  `spec` text NOT NULL,
  `verify` text NOT NULL,
  UNIQUE KEY `story` (`story`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_storystage`;
CREATE TABLE IF NOT EXISTS `zt_storystage` (
  `story` mediumint(8) unsigned NOT NULL,
  `branch` mediumint(8) unsigned NOT NULL,
  `stage` varchar(50) NOT NULL,
  `stagedBy` char(30) NOT NULL,
  UNIQUE KEY `story_branch` (`story`,`branch`),
  KEY `story` (`story`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_suitecase`;
CREATE TABLE IF NOT EXISTS `zt_suitecase` (
  `suite` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `case` mediumint(8) unsigned NOT NULL,
  `version` smallint(5) unsigned NOT NULL,
  UNIQUE KEY `suitecase` (`suite`,`case`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_task`;
CREATE TABLE IF NOT EXISTS `zt_task` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL,
  `parent` mediumint(8) NOT NULL DEFAULT '0',
  `execution` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `design` mediumint(8) unsigned NOT NULL,
  `story` mediumint(8) unsigned NOT NULL default '0',
  `storyVersion` smallint(6) NOT NULL default '1',
  `designVersion` smallint(6) unsigned NOT NULL,
  `fromBug` mediumint(8) unsigned NOT NULL default '0',
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `pri` tinyint(3) unsigned NOT NULL default '0',
  `estimate` float unsigned NOT NULL,
  `consumed` float unsigned NOT NULL,
  `left` float unsigned NOT NULL,
  `deadline` date NOT NULL,
  `status` enum('wait','doing','done','pause','cancel','closed') NOT NULL default 'wait',
  `subStatus` varchar(30) NOT NULL default '',
  `color` char(7) NOT NULL,
  `mailto` text,
  `desc` text NOT NULL,
  `version` smallint(6) NOT NULL,
  `openedBy` varchar(30) NOT NULL,
  `openedDate` datetime NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `estStarted` date NOT NULL,
  `realStarted` datetime NOT NULL,
  `finishedBy` varchar(30) NOT NULL,
  `finishedDate` datetime NOT NULL,
  `finishedList` text NOT NULL,
  `canceledBy` varchar(30) NOT NULL,
  `canceledDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL,
  `closedDate` datetime NOT NULL,
  `planDuration` int(11) NOT NULL,
  `realDuration` int(11) NOT NULL,
  `closedReason` varchar(30) NOT NULL,
  `lastEditedBy` varchar(30) NOT NULL,
  `lastEditedDate` datetime NOT NULL,
  `activatedDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
   PRIMARY KEY (`id`),
  KEY `execution` (`execution`),
  KEY `story` (`story`),
  KEY `parent` (`parent`),
  KEY `assignedTo` (`assignedTo`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_taskestimate`;
CREATE TABLE IF NOT EXISTS `zt_taskestimate` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `task` mediumint(8) unsigned NOT NULL default '0',
  `date` date NOT NULL,
  `left` float unsigned NOT NULL default '0',
  `consumed` float unsigned NOT NULL,
  `account` char(30) NOT NULL default '',
  `work` text,
  PRIMARY KEY (`id`),
  KEY `task` (`task`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_taskspec`;
CREATE TABLE IF NOT EXISTS `zt_taskspec` (
  `task` mediumint(8) NOT NULL,
  `version` smallint(6) NOT NULL,
  `name` varchar(255) NOT NULL,
  `estStarted` date NOT NULL,
  `deadline` date NOT NULL,
  UNIQUE KEY `task` (`task`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_team`;
CREATE TABLE IF NOT EXISTS `zt_team` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `root` mediumint(8) unsigned NOT NULL default '0',
  `type` enum('project','task','execution') NOT NULL DEFAULT 'project',
  `account` char(30) NOT NULL default '',
  `role` char(30) NOT NULL default '',
  `limited` char(8) NOT NULL default 'no',
  `join` date NOT NULL default '0000-00-00',
  `days` smallint(5) unsigned NOT NULL,
  `hours` float(3,1) unsigned NOT NULL default '0',
  `estimate` DECIMAL(12,2) UNSIGNED NOT NULL DEFAULT '0',
  `consumed` DECIMAL(12,2) UNSIGNED NOT NULL DEFAULT '0',
  `left` DECIMAL(12,2) UNSIGNED NOT NULL DEFAULT '0',
  `order` TINYINT(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `team` (`root`,`type`,`account`)
  ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testreport`;
CREATE TABLE IF NOT EXISTS `zt_testreport` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `tasks` varchar(255) NOT NULL,
  `builds` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `owner` char(30) NOT NULL,
  `members` text NOT NULL,
  `stories` text NOT NULL,
  `bugs` text NOT NULL,
  `cases` text NOT NULL,
  `report` text NOT NULL,
  `objectType` varchar(20) NOT NULL,
  `objectID` mediumint(8) unsigned NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testresult`;
CREATE TABLE IF NOT EXISTS `zt_testresult` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `run` mediumint(8) unsigned NOT NULL,
  `case` mediumint(8) unsigned NOT NULL,
  `version` smallint(5) unsigned NOT NULL,
  `job` mediumint(8) unsigned NOT NULL,
  `compile` mediumint(8) unsigned NOT NULL,
  `caseResult` char(30) NOT NULL,
  `stepResults` text NOT NULL,
  `lastRunner` varchar(30) NOT NULL,
  `date` datetime NOT NULL,
  `duration` float NOT NULL,
  `xml` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `case` (`case`),
  KEY `version` (`version`),
  KEY `run` (`run`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testrun`;
CREATE TABLE IF NOT EXISTS `zt_testrun` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `task` mediumint(8) unsigned NOT NULL default '0',
  `case` mediumint(8) unsigned NOT NULL default '0',
  `version` tinyint(3) unsigned NOT NULL default '0',
  `assignedTo` char(30) NOT NULL default '',
  `lastRunner` varchar(30) NOT NULL,
  `lastRunDate` datetime NOT NULL,
  `lastRunResult` char(30) NOT NULL,
  `status` char(30) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `task` (`task`,`case`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testsuite`;
CREATE TABLE IF NOT EXISTS `zt_testsuite` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `type` varchar(20) NOT NULL,
  `addedBy` char(30) NOT NULL,
  `addedDate` datetime NOT NULL,
  `lastEditedBy` char(30) NOT NULL,
  `lastEditedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product` (`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testtask`;
CREATE TABLE IF NOT EXISTS `zt_testtask` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `name` char(90) NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL default '0',
  `build` char(30) NOT NULL,
  `type` varchar(255) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL,
  `pri` tinyint(3) unsigned NOT NULL default '0',
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `realFinishedDate` datetime NOT NULL,
  `mailto` text,
  `desc` text NOT NULL,
  `report` text NOT NULL,
  `status` enum('blocked','doing','wait','done') NOT NULL DEFAULT 'wait',
  `testreport` mediumint(8) unsigned NOT NULL,
  `auto` varchar(10) NOT NULL DEFAULT 'no',
  `subStatus` varchar(30) NOT NULL default '',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `build` (`build`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_todo`;
CREATE TABLE IF NOT EXISTS `zt_todo` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `date` date NOT NULL,
  `begin` smallint(4) unsigned zerofill NOT NULL,
  `end` smallint(4) unsigned zerofill NOT NULL,
  `type` char(10) NOT NULL,
  `cycle` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `idvalue` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `pri` tinyint(3) unsigned NOT NULL,
  `name` char(150) NOT NULL,
  `desc` text NOT NULL,
  `status` enum('wait','doing','done','closed') NOT NULL DEFAULT 'wait',
  `private` tinyint(1) NOT NULL,
  `config` varchar(255) NOT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime NOT NULL,
  `finishedBy` varchar(30) NOT NULL DEFAULT '',
  `finishedDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `assignedTo` (`assignedTo`),
  KEY `finishedBy` (`finishedBy`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_user`;
CREATE TABLE IF NOT EXISTS `zt_user` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint unsigned NOT NULL,
  `type` char(30) NOT NULL default 'inside',
  `dept` mediumint(8) unsigned NOT NULL default '0',
  `account` char(30) NOT NULL default '',
  `password` char(32) NOT NULL default '',
  `role` char(10) NOT NULL default '',
  `realname` varchar(100) NOT NULL default '',
  `nickname` char(60) NOT NULL default '',
  `commiter` varchar(100) NOT NULL,
  `avatar` text NOT NULL,
  `birthday` date NOT NULL default '0000-00-00',
  `gender` enum('f','m') NOT NULL default 'f',
  `email` char(90) NOT NULL default '',
  `skype` char(90) NOT NULL default '',
  `qq` char(20) NOT NULL default '',
  `mobile` char(11) NOT NULL default '',
  `phone` char(20) NOT NULL default '',
  `weixin` varchar(90) NOT NULL default '',
  `dingding` varchar(90) NOT NULL default '',
  `slack` varchar(90) NOT NULL default '',
  `whatsapp` varchar(90) NOT NULL default '',
  `address` char(120) NOT NULL default '',
  `zipcode` char(10) NOT NULL default '',
  `nature` text NOT NULL,
  `analysis` text NOT NULL,
  `strategy` text NOT NULL,
  `join` date NOT NULL default '0000-00-00',
  `visits` mediumint(8) unsigned NOT NULL default '0',
  `ip` char(15) NOT NULL default '',
  `last` int(10) unsigned NOT NULL default '0',
  `fails` tinyint(5) NOT NULL default '0',
  `locked` datetime NOT NULL default '0000-00-00 00:00:00',
  `ranzhi` char(30) NOT NULL default '',
  `score` INT(11) NOT NULL DEFAULT '0',
  `scoreLevel` INT(11) NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `account` (`account`),
  KEY `dept` (`dept`),
  KEY `email` (`email`),
  KEY `commiter` (`commiter`),
  KEY `deleted` (`deleted`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_usercontact`;
CREATE TABLE IF NOT EXISTS `zt_usercontact` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `account` char(30) NOT NULL,
  `listName` varchar(60) NOT NULL,
  `userList` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_usergroup`;
CREATE TABLE IF NOT EXISTS `zt_usergroup` (
  `account` char(30) NOT NULL default '',
  `group` mediumint(8) unsigned NOT NULL default '0',
  `project` text NOT NULL,
  UNIQUE KEY `account` (`account`,`group`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_userquery`;
CREATE TABLE IF NOT EXISTS `zt_userquery` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `account` char(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `title` varchar(90) NOT NULL,
  `form` text NOT NULL,
  `sql` text NOT NULL,
  `shortcut` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY  (`id`),
  KEY `account` (`account`),
  KEY `module` (`module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_usertpl`;
CREATE TABLE IF NOT EXISTS `zt_usertpl` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `account` char(30) NOT NULL,
  `type` char(30) NOT NULL,
  `title` varchar(150) NOT NULL,
  `content` text NOT NULL,
  `public` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY  (`id`),
  KEY `account` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_userview`;
CREATE TABLE IF NOT EXISTS `zt_userview` (
  `account` char(30) NOT NULL,
  `programs` mediumtext NOT NULL,
  `products` mediumtext NOT NULL,
  `projects` mediumtext NOT NULL,
  `sprints` mediumtext NOT NULL,
  UNIQUE KEY `account` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_webhook`;
CREATE TABLE IF NOT EXISTS `zt_webhook` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(15) NOT NULL DEFAULT 'default',
  `name` varchar(50) NOT NULL,
  `url` varchar(255) NOT NULL,
  `domain` varchar(255) NOT NULL,
  `secret` varchar(255) NOT NULL,
  `contentType` varchar(30) NOT NULL DEFAULT 'application/json',
  `sendType` enum('sync','async') NOT NULL DEFAULT 'sync',
  `products` text NOT NULL,
  `executions` text NOT NULL,
  `params` varchar(100) NOT NULL,
  `actions` text NOT NULL,
  `desc` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `zt_cron` (`m`, `h`, `dom`, `mon`, `dow`, `command`, `remark`, `type`, `buildin`, `status`, `lastTime`) VALUES
('*',    '*',    '*',    '*',    '*',    '', '监控定时任务', 'zentao', 1, 'normal',   '0000-00-00 00:00:00'),
('30',   '23',   '*',    '*',    '*',    'moduleName=execution&methodName=computeburn', '更新燃尽图',      'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('0',    '8',    '*',    '*',    '*',    'moduleName=report&methodName=remind',       '每日任务提醒',    'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=svn&methodName=run',             '同步SVN',         'zentao', 1, 'stop',   '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=git&methodName=run',             '同步GIT',         'zentao', 1, 'stop',   '0000-00-00 00:00:00'),
('30',   '0',    '*',    '*',    '*',    'moduleName=backup&methodName=backup',       '备份数据和附件',  'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=mail&methodName=asyncSend',      '异步发信',        'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=webhook&methodName=asyncSend',   '异步发送Webhook', 'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=admin&methodName=deleteLog',     '删除过期日志',    'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('1',    '1',    '*',    '*',    '*',    'moduleName=todo&methodName=createCycle',    '生成周期性待办',  'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('1',    '0',    '*',    '*',    '*',    'moduleName=ci&methodName=initQueue', '创建周期性任务', 'zentao', 1, 'normal',   '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=ci&methodName=checkCompileStatus', '同步DevOps构建任务状态', 'zentao', 1, 'normal',   '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=ci&methodName=exec', '执行DevOps构建任务', 'zentao', 1, 'normal',   '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=mr&methodName=syncMR', '定时同步GitLab合并数据到禅道数据库', 'zentao', 1, 'normal', '0000-00-00 00:00:00');

INSERT INTO `zt_group` (`id`, `name`, `role`, `desc`) VALUES
(1, 'ADMIN', 'admin', 'for administrator'),
(2, 'DEV', 'dev', 'for developers.'),
(3, 'QA', 'qa', 'for testers.'),
(4, 'PM', 'pm', 'for project managers.'),
(5, 'PO', 'po', 'for product owners.'),
(6, 'TD', 'td', 'for technical director.'),
(7, 'PD', 'pd', 'for product director.'),
(8, 'QD', 'qd', 'for quality director.'),
(9, 'TOP', 'top', 'for top manager.'),
(10, 'OTHERS', 'others', 'for others.'),
(11, 'guest', 'guest', 'For guest'),
(12, 'LIMITED', 'limited', 'For limited user'),
(13, 'PROJECTADMIN', 'projectAdmin', 'Project Admins manage project privileges');

INSERT INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1,'action','comment'),
(1,'action','editComment'),
(1,'action','hideAll'),
(1,'action','hideOne'),
(1,'action','trash'),
(1,'action','undelete'),
(1,'admin','checkDB'),
(1,'admin','checkWeak'),
(1,'admin','index'),
(1,'admin','register'),
(1,'admin','safe'),
(1,'admin','sso'),
(1,'admin','ztCompany'),
(1,'api','debug'),
(1,'api','getModel'),
(1,'api','sql'),
(1,'automation','browse'),
(1,'backup','backup'),
(1,'backup','change'),
(1,'backup','delete'),
(1,'backup','index'),
(1,'backup','restore'),
(1,'backup','rmPHPHeader'),
(1,'backup','setting'),
(1,'branch','delete'),
(1,'branch','manage'),
(1,'branch','sort'),
(1,'bug','activate'),
(1,'bug','assignTo'),
(1,'bug','batchActivate'),
(1,'bug','batchAssignTo'),
(1,'bug','batchChangeBranch'),
(1,'bug','batchChangeModule'),
(1,'bug','batchClose'),
(1,'bug','batchConfirm'),
(1,'bug','batchCreate'),
(1,'bug','batchEdit'),
(1,'bug','batchResolve'),
(1,'bug','browse'),
(1,'bug','close'),
(1,'bug','confirmBug'),
(1,'bug','confirmStoryChange'),
(1,'bug','create'),
(1,'bug','delete'),
(1,'bug','edit'),
(1,'bug','export'),
(1,'bug','index'),
(1,'bug','linkBugs'),
(1,'bug','report'),
(1,'bug','resolve'),
(1,'bug','view'),
(1,'build','batchUnlinkBug'),
(1,'build','batchUnlinkStory'),
(1,'build','create'),
(1,'build','delete'),
(1,'build','edit'),
(1,'build','linkBug'),
(1,'build','linkStory'),
(1,'build','unlinkBug'),
(1,'build','unlinkStory'),
(1,'build','view'),
(1,'caselib','batchCreateCase'),
(1,'caselib','browse'),
(1,'caselib','create'),
(1,'caselib','createCase'),
(1,'caselib','delete'),
(1,'caselib','edit'),
(1,'caselib','exportTemplet'),
(1,'caselib','import'),
(1,'caselib','index'),
(1,'caselib','showImport'),
(1,'caselib','view'),
(1,'ci','checkCompileStatus'),
(1,'ci','commitResult'),
(1,'company','browse'),
(1,'company','dynamic'),
(1,'company','edit'),
(1,'company','index'),
(1,'company','view'),
(1,'compile','browse'),
(1,'compile','logs'),
(1,'convert','checkBugFree'),
(1,'convert','checkConfig'),
(1,'convert','checkRedmine'),
(1,'convert','convertBugFree'),
(1,'convert','convertRedmine'),
(1,'convert','execute'),
(1,'convert','index'),
(1,'convert','selectSource'),
(1,'convert','setBugfree'),
(1,'convert','setConfig'),
(1,'convert','setRedmine'),
(1,'cron','create'),
(1,'cron','delete'),
(1,'cron','edit'),
(1,'cron','index'),
(1,'cron','openProcess'),
(1,'cron','toggle'),
(1,'cron','turnon'),
(1,'custom','browseStoryConcept'),
(1,'custom','deleteStoryConcept'),
(1,'custom','editStoryConcept'),
(1,'custom','execution'),
(1,'custom','flow'),
(1,'custom','index'),
(1,'custom','product'),
(1,'custom','project'),
(1,'custom','restore'),
(1,'custom','set'),
(1,'custom','setDefaultConcept'),
(1,'custom','setPublic'),
(1,'custom','setStoryConcept'),
(1,'custom','timezone'),
(1,'custom','working'),
(1,'datatable','setGlobal'),
(1,'dept','browse'),
(1,'dept','delete'),
(1,'dept','edit'),
(1,'dept','manageChild'),
(1,'dept','updateOrder'),
(1,'dev','api'),
(1,'dev','db'),
(1,'dev','editor'),
(1,'dev','translate'),
(1,'doc','allLibs'),
(1,'doc','browse'),
(1,'doc','collect'),
(1,'doc','create'),
(1,'doc','createLib'),
(1,'doc','delete'),
(1,'doc','deleteFile'),
(1,'doc','deleteLib'),
(1,'doc','edit'),
(1,'doc','editLib'),
(1,'doc','index'),
(1,'doc','objectLibs'),
(1,'doc','showFiles'),
(1,'doc','tableContents'),
(1,'doc','view'),
(1,'execution','activate'),
(1,'execution','addWhitelist'),
(1,'execution','all'),
(1,'execution','batchedit'),
(1,'execution','batchUnlinkStory'),
(1,'execution','browse'),
(1,'execution','bug'),
(1,'execution','build'),
(1,'execution','burn'),
(1,'execution','burnData'),
(1,'execution','close'),
(1,'execution','computeBurn'),
(1,'execution','create'),
(1,'execution','delete'),
(1,'execution','doc'),
(1,'execution','dynamic'),
(1,'execution','edit'),
(1,'execution','executionkanban'),
(1,'execution','export'),
(1,'execution','fixFirst'),
(1,'execution','grouptask'),
(1,'execution','importBug'),
(1,'execution','importplanstories'),
(1,'execution','importtask'),
(1,'execution','index'),
(1,'execution','kanban'),
(1,'execution','kanbanColsColor'),
(1,'execution','kanbanHideCols'),
(1,'execution','linkStory'),
(1,'execution','manageMembers'),
(1,'execution','manageProducts'),
(1,'execution','printKanban'),
(1,'execution','putoff'),
(1,'execution','start'),
(1,'execution','story'),
(1,'execution','storyEstimate'),
(1,'execution','storyKanban'),
(1,'execution','storySort'),
(1,'execution','suspend'),
(1,'execution','task'),
(1,'execution','team'),
(1,'execution','testcase'),
(1,'execution','testreport'),
(1,'execution','testtask'),
(1,'execution','tree'),
(1,'execution','treeStory'),
(1,'execution','treeTask'),
(1,'execution','unbindWhitelist'),
(1,'execution','unlinkMember'),
(1,'execution','unlinkStory'),
(1,'execution','updateOrder'),
(1,'execution','view'),
(1,'execution','whitelist'),
(1,'extension','activate'),
(1,'extension','browse'),
(1,'extension','deactivate'),
(1,'extension','erase'),
(1,'extension','install'),
(1,'extension','obtain'),
(1,'extension','structure'),
(1,'extension','uninstall'),
(1,'extension','upgrade'),
(1,'extension','upload'),
(1,'file','delete'),
(1,'file','download'),
(1,'file','edit'),
(1,'file','setPublic'),
(1,'file','uploadImages'),
(1,'git','apiSync'),
(1,'git','cat'),
(1,'git','diff'),
(1,'gitlab','bindProduct'),
(1,'gitlab','bindUser'),
(1,'gitlab','browse'),
(1,'gitlab','create'),
(1,'gitlab','delete'),
(1,'gitlab','edit'),
(1,'gitlab','importIssue'),
(1,'group','browse'),
(1,'group','copy'),
(1,'group','create'),
(1,'group','delete'),
(1,'group','edit'),
(1,'group','manageMember'),
(1,'group','managePriv'),
(1,'group','manageProjectAdmin'),
(1,'group','manageView'),
(1,'index','index'),
(1,'jenkins','browse'),
(1,'jenkins','create'),
(1,'jenkins','delete'),
(1,'jenkins','edit'),
(1,'job','browse'),
(1,'job','create'),
(1,'job','delete'),
(1,'job','edit'),
(1,'job','exec'),
(1,'job','view'),
(1,'mail','batchDelete'),
(1,'mail','browse'),
(1,'mail','delete'),
(1,'mail','detect'),
(1,'mail','edit'),
(1,'mail','index'),
(1,'mail','resend'),
(1,'mail','reset'),
(1,'mail','save'),
(1,'mail','sendCloud'),
(1,'mail','sendcloudUser'),
(1,'mail','test'),
(1,'mail','ztCloud'),
(1,'message','browser'),
(1,'message','index'),
(1,'message','setting'),
(1,'misc','ping'),
(1,'my','bug'),
(1,'my','calendar'),
(1,'my','changePassword'),
(1,'my','contribute'),
(1,'my','deleteContacts'),
(1,'my','doc'),
(1,'my','dynamic'),
(1,'my','editProfile'),
(1,'my','execution'),
(1,'my','index'),
(1,'my','manageContacts'),
(1,'my','preference'),
(1,'my','profile'),
(1,'my','project'),
(1,'my','score'),
(1,'my','story'),
(1,'my','task'),
(1,'my','team'),
(1,'my','testcase'),
(1,'my','testtask'),
(1,'my','todo'),
(1,'my','unbind'),
(1,'my','uploadAvatar'),
(1,'my','work'),
(1,'personnel','accessible'),
(1,'personnel','addWhitelist'),
(1,'personnel','invest'),
(1,'personnel','unbindWhitelist'),
(1,'personnel','whitelist'),
(1,'product','addWhitelist'),
(1,'product','all'),
(1,'product','batchEdit'),
(1,'product','browse'),
(1,'product','build'),
(1,'product','close'),
(1,'product','create'),
(1,'product','dashboard'),
(1,'product','delete'),
(1,'product','doc'),
(1,'product','dynamic'),
(1,'product','edit'),
(1,'product','export'),
(1,'product','index'),
(1,'product','kanban'),
(1,'product','manageLine'),
(1,'product','project'),
(1,'product','roadmap'),
(1,'product','unbindWhitelist'),
(1,'product','updateOrder'),
(1,'product','view'),
(1,'product','whitelist'),
(1,'productplan','batchEdit'),
(1,'productplan','batchUnlinkBug'),
(1,'productplan','batchUnlinkStory'),
(1,'productplan','browse'),
(1,'productplan','create'),
(1,'productplan','delete'),
(1,'productplan','edit'),
(1,'productplan','linkBug'),
(1,'productplan','linkStory'),
(1,'productplan','unlinkBug'),
(1,'productplan','unlinkStory'),
(1,'productplan','view'),
(1,'program','index'),
(1,'program','activate'),
(1,'program','batchUnlinkStakeholders'),
(1,'program','browse'),
(1,'program','close'),
(1,'program','create'),
(1,'program','kanban'),
(1,'program','createStakeholder'),
(1,'program','delete'),
(1,'program','edit'),
(1,'program','export'),
(1,'program','product'),
(1,'program','project'),
(1,'program','stakeholder'),
(1,'program','start'),
(1,'program','suspend'),
(1,'program','unbindWhitelist'),
(1,'program','unlinkStakeholder'),
(1,'program','updateOrder'),
(1,'program','view'),
(1,'project','activate'),
(1,'project','addWhitelist'),
(1,'project','batchEdit'),
(1,'project','browse'),
(1,'project','bug'),
(1,'project','build'),
(1,'project','close'),
(1,'project','copyGroup'),
(1,'project','create'),
(1,'project','createGroup'),
(1,'project','createGuide'),
(1,'project','delete'),
(1,'project','dynamic'),
(1,'project','edit'),
(1,'project','editGroup'),
(1,'project','execution'),
(1,'project','export'),
(1,'project','group'),
(1,'project','index'),
(1,'project','kanban'),
(1,'project','createStakeholder'),
(1,'project','manageGroupMember'),
(1,'project','manageMembers'),
(1,'project','managePriv'),
(1,'project','manageProducts'),
(1,'project','manageView'),
(1,'project','programTitle'),
(1,'project','qa'),
(1,'project','start'),
(1,'project','suspend'),
(1,'project','team'),
(1,'project','testcase'),
(1,'project','testreport'),
(1,'project','testtask'),
(1,'project','unbindWhitelist'),
(1,'project','unlinkMember'),
(1,'project','updateOrder'),
(1,'project','view'),
(1,'project','whitelist'),
(1,'projectbuild','browse'),
(1,'projectrelease','batchUnlinkBug'),
(1,'projectrelease','batchUnlinkStory'),
(1,'projectrelease','browse'),
(1,'projectrelease','changeStatus'),
(1,'projectrelease','create'),
(1,'projectrelease','delete'),
(1,'projectrelease','edit'),
(1,'projectrelease','export'),
(1,'projectrelease','linkBug'),
(1,'projectrelease','linkStory'),
(1,'projectrelease','unlinkBug'),
(1,'projectrelease','unlinkStory'),
(1,'projectrelease','view'),
(1,'projectstory','batchUnlinkStory'),
(1,'projectstory','importplanstories'),
(1,'projectstory','linkStory'),
(1,'projectstory','story'),
(1,'projectstory','track'),
(1,'projectstory','unlinkStory'),
(1,'projectstory','view'),
(1,'qa','index'),
(1,'release','batchUnlinkBug'),
(1,'release','batchUnlinkStory'),
(1,'release','browse'),
(1,'release','changeStatus'),
(1,'release','create'),
(1,'release','delete'),
(1,'release','edit'),
(1,'release','export'),
(1,'release','linkBug'),
(1,'release','linkStory'),
(1,'release','unlinkBug'),
(1,'release','unlinkStory'),
(1,'release','view'),
(1,'repo','blame'),
(1,'repo','browse'),
(1,'repo','create'),
(1,'repo','delete'),
(1,'repo','diff'),
(1,'repo','download'),
(1,'repo','edit'),
(1,'repo','log'),
(1,'repo','maintain'),
(1,'repo','revision'),
(1,'repo','setRules'),
(1,'repo','showSyncCommit'),
(1,'repo','view'),
(1,'report','bugAssign'),
(1,'report','bugCreate'),
(1,'report','index'),
(1,'report','productSummary'),
(1,'report','projectDeviation'),
(1,'report','workload'),
(1,'search','buildForm'),
(1,'search','buildIndex'),
(1,'search','buildQuery'),
(1,'search','deleteQuery'),
(1,'search','index'),
(1,'search','saveQuery'),
(1,'search','select'),
(1,'stakeholder','batchCreate'),
(1,'stakeholder','browse'),
(1,'stakeholder','communicate'),
(1,'stakeholder','create'),
(1,'stakeholder','createExpect'),
(1,'stakeholder','delete'),
(1,'stakeholder','deleteExpect'),
(1,'stakeholder','edit'),
(1,'stakeholder','editExpect'),
(1,'stakeholder','expect'),
(1,'stakeholder','expectation'),
(1,'stakeholder','issue'),
(1,'stakeholder','plan'),
(1,'stakeholder','userIssue'),
(1,'stakeholder','view'),
(1,'stakeholder','viewExpect'),
(1,'stakeholder','viewIssue'),
(1,'story','activate'),
(1,'story','assignTo'),
(1,'story','batchAssignTo'),
(1,'story','batchChangeBranch'),
(1,'story','batchChangeModule'),
(1,'story','batchChangePlan'),
(1,'story','batchChangeStage'),
(1,'story','batchClose'),
(1,'story','batchCreate'),
(1,'story','batchEdit'),
(1,'story','batchReview'),
(1,'story','batchToTask'),
(1,'story','bugs'),
(1,'story','cases'),
(1,'story','change'),
(1,'story','close'),
(1,'story','create'),
(1,'story','delete'),
(1,'story','edit'),
(1,'story','export'),
(1,'story','linkStory'),
(1,'story','processStoryChange'),
(1,'story','recall'),
(1,'story','report'),
(1,'story','review'),
(1,'story','tasks'),
(1,'story','track'),
(1,'story','view'),
(1,'story','zeroCase'),
(1,'svn','apiSync'),
(1,'svn','cat'),
(1,'svn','diff'),
(1,'task','activate'),
(1,'task','assignTo'),
(1,'task','batchAssignTo'),
(1,'task','batchCancel'),
(1,'task','batchChangeModule'),
(1,'task','batchClose'),
(1,'task','batchCreate'),
(1,'task','batchEdit'),
(1,'task','cancel'),
(1,'task','close'),
(1,'task','confirmStoryChange'),
(1,'task','create'),
(1,'task','delete'),
(1,'task','deleteEstimate'),
(1,'task','edit'),
(1,'task','editEstimate'),
(1,'task','export'),
(1,'task','finish'),
(1,'task','pause'),
(1,'task','recordEstimate'),
(1,'task','report'),
(1,'task','restart'),
(1,'task','start'),
(1,'task','view'),
(1,'testcase','batchCaseTypeChange'),
(1,'testcase','batchChangeBranch'),
(1,'testcase','batchChangeModule'),
(1,'testcase','batchConfirmStoryChange'),
(1,'testcase','batchCreate'),
(1,'testcase','batchDelete'),
(1,'testcase','batchEdit'),
(1,'testcase','batchReview'),
(1,'testcase','browse'),
(1,'testcase','bugs'),
(1,'testcase','confirmChange'),
(1,'testcase','confirmLibcaseChange'),
(1,'testcase','confirmStoryChange'),
(1,'testcase','create'),
(1,'testcase','createBug'),
(1,'testcase','delete'),
(1,'testcase','edit'),
(1,'testcase','export'),
(1,'testcase','exportTemplet'),
(1,'testcase','groupCase'),
(1,'testcase','ignoreLibcaseChange'),
(1,'testcase','import'),
(1,'testcase','importFromLib'),
(1,'testcase','index'),
(1,'testcase','linkCases'),
(1,'testcase','review'),
(1,'testcase','showImport'),
(1,'testcase','view'),
(1,'testreport','browse'),
(1,'testreport','create'),
(1,'testreport','delete'),
(1,'testreport','edit'),
(1,'testreport','view'),
(1,'testsuite','batchUnlinkCases'),
(1,'testsuite','browse'),
(1,'testsuite','create'),
(1,'testsuite','delete'),
(1,'testsuite','edit'),
(1,'testsuite','index'),
(1,'testsuite','linkCase'),
(1,'testsuite','unlinkCase'),
(1,'testsuite','view'),
(1,'testtask','activate'),
(1,'testtask','batchAssign'),
(1,'testtask','batchRun'),
(1,'testtask','batchUnlinkCases'),
(1,'testtask','block'),
(1,'testtask','browse'),
(1,'testtask','browseUnits'),
(1,'testtask','cases'),
(1,'testtask','close'),
(1,'testtask','create'),
(1,'testtask','delete'),
(1,'testtask','edit'),
(1,'testtask','groupCase'),
(1,'testtask','index'),
(1,'testtask','importUnitResult'),
(1,'testtask','linkcase'),
(1,'testtask','report'),
(1,'testtask','results'),
(1,'testtask','runcase'),
(1,'testtask','start'),
(1,'testtask','unitCases'),
(1,'testtask','unlinkcase'),
(1,'testtask','view'),
(1,'todo','activate'),
(1,'todo','assignTo'),
(1,'todo','batchClose'),
(1,'todo','batchCreate'),
(1,'todo','batchEdit'),
(1,'todo','batchFinish'),
(1,'todo','close'),
(1,'todo','create'),
(1,'todo','createcycle'),
(1,'todo','delete'),
(1,'todo','edit'),
(1,'todo','export'),
(1,'todo','finish'),
(1,'todo','import2Today'),
(1,'todo','start'),
(1,'todo','view'),
(1,'tree','browse'),
(1,'tree','browseTask'),
(1,'tree','delete'),
(1,'tree','edit'),
(1,'tree','fix'),
(1,'tree','manageChild'),
(1,'tree','updateOrder'),
(1,'user','batchCreate'),
(1,'user','batchEdit'),
(1,'user','bug'),
(1,'user','create'),
(1,'user','cropAvatar'),
(1,'user','delete'),
(1,'user','dynamic'),
(1,'user','edit'),
(1,'user','execution'),
(1,'user','issue'),
(1,'user','profile'),
(1,'user','risk'),
(1,'user','setPublicTemplate'),
(1,'user','story'),
(1,'user','task'),
(1,'user','testCase'),
(1,'user','testTask'),
(1,'user','todo'),
(1,'user','unbind'),
(1,'user','unlock'),
(1,'user','view'),
(1,'webhook','bind'),
(1,'webhook','browse'),
(1,'webhook','chooseDept'),
(1,'webhook','create'),
(1,'webhook','delete'),
(1,'webhook','edit'),
(1,'webhook','log'),
(2,'action','comment'),
(2,'action','editComment'),
(2,'action','trash'),
(2,'action','undelete'),
(2,'admin','checkWeak'),
(2,'admin','index'),
(2,'admin','safe'),
(2,'api','debug'),
(2,'automation','browse'),
(2,'bug','activate'),
(2,'bug','assignTo'),
(2,'bug','batchActivate'),
(2,'bug','batchAssignTo'),
(2,'bug','batchChangeBranch'),
(2,'bug','batchChangeModule'),
(2,'bug','batchClose'),
(2,'bug','batchConfirm'),
(2,'bug','batchCreate'),
(2,'bug','batchEdit'),
(2,'bug','batchResolve'),
(2,'bug','browse'),
(2,'bug','close'),
(2,'bug','confirmBug'),
(2,'bug','confirmStoryChange'),
(2,'bug','create'),
(2,'bug','delete'),
(2,'bug','edit'),
(2,'bug','export'),
(2,'bug','index'),
(2,'bug','linkBugs'),
(2,'bug','report'),
(2,'bug','resolve'),
(2,'bug','view'),
(2,'build','batchUnlinkBug'),
(2,'build','batchUnlinkStory'),
(2,'build','create'),
(2,'build','delete'),
(2,'build','edit'),
(2,'build','linkBug'),
(2,'build','linkStory'),
(2,'build','unlinkBug'),
(2,'build','unlinkStory'),
(2,'build','view'),
(2,'caselib','browse'),
(2,'caselib','index'),
(2,'caselib','view'),
(2,'company','browse'),
(2,'company','dynamic'),
(2,'company','edit'),
(2,'company','index'),
(2,'company','view'),
(2,'custom','execution'),
(2,'custom','flow'),
(2,'custom','index'),
(2,'custom','product'),
(2,'custom','restore'),
(2,'custom','set'),
(2,'custom','setPublic'),
(2,'datatable','setGlobal'),
(2,'dept','browse'),
(2,'dept','delete'),
(2,'dept','edit'),
(2,'dept','manageChild'),
(2,'dept','updateOrder'),
(2,'dev','api'),
(2,'dev','db'),
(2,'dev','editor'),
(2,'doc','allLibs'),
(2,'doc','browse'),
(2,'doc','collect'),
(2,'doc','create'),
(2,'doc','createLib'),
(2,'doc','delete'),
(2,'doc','deleteFile'),
(2,'doc','deleteLib'),
(2,'doc','edit'),
(2,'doc','editLib'),
(2,'doc','index'),
(2,'doc','objectLibs'),
(2,'doc','showFiles'),
(2,'doc','tableContents'),
(2,'doc','view'),
(2,'execution','all'),
(2,'execution','browse'),
(2,'execution','bug'),
(2,'execution','build'),
(2,'execution','burn'),
(2,'execution','burnData'),
(2,'execution','computeBurn'),
(2,'execution','doc'),
(2,'execution','dynamic'),
(2,'execution','executionkanban'),
(2,'execution','fixFirst'),
(2,'execution','grouptask'),
(2,'execution','kanban'),
(2,'execution','manageMembers'),
(2,'execution','printKanban'),
(2,'execution','story'),
(2,'execution','storyEstimate'),
(2,'execution','storyKanban'),
(2,'execution','task'),
(2,'execution','team'),
(2,'execution','testcase'),
(2,'execution','testreport'),
(2,'execution','testtask'),
(2,'execution','tree'),
(2,'execution','treeStory'),
(2,'execution','treeTask'),
(2,'execution','view'),
(2,'execution','whitelist'),
(2,'file','delete'),
(2,'file','download'),
(2,'file','edit'),
(2,'file','setPublic'),
(2,'file','uploadImages'),
(2,'git','apiSync'),
(2,'git','cat'),
(2,'git','diff'),
(2,'group','browse'),
(2,'index','index'),
(2,'message','browser'),
(2,'message','index'),
(2,'message','setting'),
(2,'misc','ping'),
(2,'my','bug'),
(2,'my','calendar'),
(2,'my','changePassword'),
(2,'my','contribute'),
(2,'my','deleteContacts'),
(2,'my','doc'),
(2,'my','dynamic'),
(2,'my','editProfile'),
(2,'my','execution'),
(2,'my','index'),
(2,'my','manageContacts'),
(2,'my','preference'),
(2,'my','profile'),
(2,'my','project'),
(2,'my','score'),
(2,'my','story'),
(2,'my','task'),
(2,'my','team'),
(2,'my','testcase'),
(2,'my','testtask'),
(2,'my','todo'),
(2,'my','uploadAvatar'),
(2,'my','work'),
(2,'personnel','accessible'),
(2,'personnel','invest'),
(2,'personnel','whitelist'),
(2,'product','all'),
(2,'product','browse'),
(2,'product','build'),
(2,'product','dashboard'),
(2,'product','dynamic'),
(2,'product','index'),
(2,'product','kanban'),
(2,'product','project'),
(2,'product','roadmap'),
(2,'product','view'),
(2,'product','whitelist'),
(2,'productplan','browse'),
(2,'productplan','view'),
(2,'program','browse'),
(2,'program','kanban'),
(2,'program','product'),
(2,'program','project'),
(2,'program','stakeholder'),
(2,'program','view'),
(2,'project','browse'),
(2,'project','bug'),
(2,'project','build'),
(2,'project','create'),
(2,'project','dynamic'),
(2,'project','edit'),
(2,'project','execution'),
(2,'project','index'),
(2,'project','kanban'),
(2,'project','manageMembers'),
(2,'project','programTitle'),
(2,'project','qa'),
(2,'project','team'),
(2,'project','testcase'),
(2,'project','testreport'),
(2,'project','testtask'),
(2,'project','view'),
(2,'project','whitelist'),
(2,'projectbuild','browse'),
(2,'projectrelease','browse'),
(2,'projectrelease','view'),
(2,'projectstory','story'),
(2,'projectstory','track'),
(2,'projectstory','view'),
(2,'qa','index'),
(2,'release','browse'),
(2,'release','view'),
(2,'repo','blame'),
(2,'repo','browse'),
(2,'repo','create'),
(2,'repo','delete'),
(2,'repo','diff'),
(2,'repo','download'),
(2,'repo','edit'),
(2,'repo','log'),
(2,'repo','revision'),
(2,'repo','showSyncCommit'),
(2,'repo','view'),
(2,'report','bugAssign'),
(2,'report','bugCreate'),
(2,'report','index'),
(2,'report','productSummary'),
(2,'report','projectDeviation'),
(2,'report','workload'),
(2,'search','buildForm'),
(2,'search','buildIndex'),
(2,'search','buildQuery'),
(2,'search','deleteQuery'),
(2,'search','index'),
(2,'search','saveQuery'),
(2,'search','select'),
(2,'story','bugs'),
(2,'story','cases'),
(2,'story','report'),
(2,'story','tasks'),
(2,'story','track'),
(2,'story','view'),
(2,'svn','apiSync'),
(2,'svn','cat'),
(2,'svn','diff'),
(2,'task','activate'),
(2,'task','assignTo'),
(2,'task','batchAssignTo'),
(2,'task','batchCancel'),
(2,'task','batchChangeModule'),
(2,'task','batchClose'),
(2,'task','batchCreate'),
(2,'task','batchEdit'),
(2,'task','cancel'),
(2,'task','close'),
(2,'task','confirmStoryChange'),
(2,'task','create'),
(2,'task','delete'),
(2,'task','deleteEstimate'),
(2,'task','edit'),
(2,'task','editEstimate'),
(2,'task','export'),
(2,'task','finish'),
(2,'task','pause'),
(2,'task','recordEstimate'),
(2,'task','report'),
(2,'task','restart'),
(2,'task','start'),
(2,'task','view'),
(2,'testcase','browse'),
(2,'testcase','bugs'),
(2,'testcase','createBug'),
(2,'testcase','export'),
(2,'testcase','groupCase'),
(2,'testcase','view'),
(2,'testreport','browse'),
(2,'testreport','create'),
(2,'testreport','delete'),
(2,'testreport','edit'),
(2,'testreport','view'),
(2,'testsuite','browse'),
(2,'testsuite','index'),
(2,'testsuite','view'),
(2,'testtask','activate'),
(2,'testtask','batchAssign'),
(2,'testtask','batchRun'),
(2,'testtask','batchUnlinkCases'),
(2,'testtask','block'),
(2,'testtask','browse'),
(2,'testtask','browseUnits'),
(2,'testtask','cases'),
(2,'testtask','close'),
(2,'testtask','create'),
(2,'testtask','delete'),
(2,'testtask','edit'),
(2,'testtask','groupCase'),
(2,'testtask','index'),
(2,'testtask','importUnitResult'),
(2,'testtask','linkcase'),
(2,'testtask','report'),
(2,'testtask','results'),
(2,'testtask','runcase'),
(2,'testtask','start'),
(2,'testtask','unitCases'),
(2,'testtask','unlinkcase'),
(2,'testtask','view'),
(2,'todo','activate'),
(2,'todo','assignTo'),
(2,'todo','batchClose'),
(2,'todo','batchCreate'),
(2,'todo','batchEdit'),
(2,'todo','batchFinish'),
(2,'todo','close'),
(2,'todo','create'),
(2,'todo','createcycle'),
(2,'todo','delete'),
(2,'todo','edit'),
(2,'todo','export'),
(2,'todo','finish'),
(2,'todo','import2Today'),
(2,'todo','start'),
(2,'todo','view'),
(2,'tree','browse'),
(2,'tree','browseTask'),
(2,'tree','delete'),
(2,'tree','edit'),
(2,'tree','fix'),
(2,'tree','manageChild'),
(2,'tree','updateOrder'),
(2,'user','batchEdit'),
(2,'user','bug'),
(2,'user','cropAvatar'),
(2,'user','dynamic'),
(2,'user','execution'),
(2,'user','issue'),
(2,'user','profile'),
(2,'user','risk'),
(2,'user','story'),
(2,'user','task'),
(2,'user','testCase'),
(2,'user','testTask'),
(2,'user','todo'),
(2,'user','view'),
(3,'action','comment'),
(3,'action','editComment'),
(3,'admin','index'),
(3,'automation','browse'),
(3,'bug','activate'),
(3,'bug','assignTo'),
(3,'bug','batchActivate'),
(3,'bug','batchAssignTo'),
(3,'bug','batchChangeBranch'),
(3,'bug','batchChangeModule'),
(3,'bug','batchClose'),
(3,'bug','batchConfirm'),
(3,'bug','batchCreate'),
(3,'bug','batchEdit'),
(3,'bug','batchResolve'),
(3,'bug','browse'),
(3,'bug','close'),
(3,'bug','confirmBug'),
(3,'bug','confirmStoryChange'),
(3,'bug','create'),
(3,'bug','delete'),
(3,'bug','edit'),
(3,'bug','export'),
(3,'bug','index'),
(3,'bug','linkBugs'),
(3,'bug','report'),
(3,'bug','resolve'),
(3,'bug','view'),
(3,'build','create'),
(3,'build','edit'),
(3,'build','view'),
(3,'caselib','batchCreateCase'),
(3,'caselib','browse'),
(3,'caselib','createCase'),
(3,'caselib','exportTemplet'),
(3,'caselib','import'),
(3,'caselib','index'),
(3,'caselib','showImport'),
(3,'caselib','view'),
(3,'company','browse'),
(3,'company','dynamic'),
(3,'company','index'),
(3,'company','view'),
(3,'datatable','setGlobal'),
(3,'doc','allLibs'),
(3,'doc','browse'),
(3,'doc','collect'),
(3,'doc','create'),
(3,'doc','edit'),
(3,'doc','index'),
(3,'doc','objectLibs'),
(3,'doc','showFiles'),
(3,'doc','tableContents'),
(3,'doc','view'),
(3,'execution','all'),
(3,'execution','browse'),
(3,'execution','bug'),
(3,'execution','build'),
(3,'execution','burn'),
(3,'execution','computeBurn'),
(3,'execution','doc'),
(3,'execution','dynamic'),
(3,'execution','executionkanban'),
(3,'execution','grouptask'),
(3,'execution','importBug'),
(3,'execution','importtask'),
(3,'execution','index'),
(3,'execution','kanban'),
(3,'execution','story'),
(3,'execution','task'),
(3,'execution','team'),
(3,'execution','testcase'),
(3,'execution','testreport'),
(3,'execution','testtask'),
(3,'execution','tree'),
(3,'execution','treeStory'),
(3,'execution','treeTask'),
(3,'execution','view'),
(3,'execution','whitelist'),
(3,'file','delete'),
(3,'file','download'),
(3,'file','edit'),
(3,'file','setPublic'),
(3,'file','uploadImages'),
(3,'git','apiSync'),
(3,'git','cat'),
(3,'git','diff'),
(3,'group','browse'),
(3,'index','index'),
(3,'message','browser'),
(3,'misc','ping'),
(3,'my','bug'),
(3,'my','calendar'),
(3,'my','changePassword'),
(3,'my','contribute'),
(3,'my','deleteContacts'),
(3,'my','doc'),
(3,'my','dynamic'),
(3,'my','editProfile'),
(3,'my','execution'),
(3,'my','index'),
(3,'my','manageContacts'),
(3,'my','preference'),
(3,'my','profile'),
(3,'my','project'),
(3,'my','score'),
(3,'my','story'),
(3,'my','task'),
(3,'my','team'),
(3,'my','testcase'),
(3,'my','testtask'),
(3,'my','todo'),
(3,'my','unbind'),
(3,'my','uploadAvatar'),
(3,'my','work'),
(3,'personnel','accessible'),
(3,'personnel','invest'),
(3,'personnel','whitelist'),
(3,'product','all'),
(3,'product','browse'),
(3,'product','build'),
(3,'product','dashboard'),
(3,'product','doc'),
(3,'product','dynamic'),
(3,'product','index'),
(3,'product','kanban'),
(3,'product','manageLine'),
(3,'product','project'),
(3,'product','roadmap'),
(3,'product','view'),
(3,'product','whitelist'),
(3,'productplan','browse'),
(3,'productplan','view'),
(3,'program','browse'),
(3,'program','kanban'),
(3,'program','product'),
(3,'program','project'),
(3,'program','stakeholder'),
(3,'program','view'),
(3,'project','browse'),
(3,'project','bug'),
(3,'project','build'),
(3,'project','dynamic'),
(3,'project','execution'),
(3,'project','group'),
(3,'project','index'),
(3,'project','kanban'),
(3,'project','programTitle'),
(3,'project','qa'),
(3,'project','team'),
(3,'project','testcase'),
(3,'project','testreport'),
(3,'project','testtask'),
(3,'project','view'),
(3,'project','whitelist'),
(3,'projectbuild','browse'),
(3,'projectrelease','browse'),
(3,'projectrelease','view'),
(3,'projectstory','story'),
(3,'projectstory','track'),
(3,'projectstory','view'),
(3,'qa','index'),
(3,'release','browse'),
(3,'release','export'),
(3,'release','view'),
(3,'repo','blame'),
(3,'repo','browse'),
(3,'repo','diff'),
(3,'repo','download'),
(3,'repo','log'),
(3,'repo','revision'),
(3,'repo','showSyncCommit'),
(3,'repo','view'),
(3,'report','bugAssign'),
(3,'report','bugCreate'),
(3,'report','index'),
(3,'report','productSummary'),
(3,'report','projectDeviation'),
(3,'report','workload'),
(3,'search','buildForm'),
(3,'search','buildQuery'),
(3,'search','deleteQuery'),
(3,'search','index'),
(3,'search','saveQuery'),
(3,'search','select'),
(3,'story','batchToTask'),
(3,'story','bugs'),
(3,'story','cases'),
(3,'story','export'),
(3,'story','processStoryChange'),
(3,'story','report'),
(3,'story','tasks'),
(3,'story','track'),
(3,'story','view'),
(3,'story','zeroCase'),
(3,'svn','apiSync'),
(3,'svn','cat'),
(3,'svn','diff'),
(3,'task','activate'),
(3,'task','assignTo'),
(3,'task','batchAssignTo'),
(3,'task','batchChangeModule'),
(3,'task','batchClose'),
(3,'task','batchCreate'),
(3,'task','batchEdit'),
(3,'task','cancel'),
(3,'task','close'),
(3,'task','confirmStoryChange'),
(3,'task','create'),
(3,'task','deleteEstimate'),
(3,'task','edit'),
(3,'task','editEstimate'),
(3,'task','export'),
(3,'task','finish'),
(3,'task','pause'),
(3,'task','recordEstimate'),
(3,'task','report'),
(3,'task','restart'),
(3,'task','start'),
(3,'task','view'),
(3,'testcase','batchCaseTypeChange'),
(3,'testcase','batchChangeBranch'),
(3,'testcase','batchChangeModule'),
(3,'testcase','batchConfirmStoryChange'),
(3,'testcase','batchCreate'),
(3,'testcase','batchDelete'),
(3,'testcase','batchEdit'),
(3,'testcase','batchReview'),
(3,'testcase','browse'),
(3,'testcase','bugs'),
(3,'testcase','confirmChange'),
(3,'testcase','confirmLibcaseChange'),
(3,'testcase','confirmStoryChange'),
(3,'testcase','create'),
(3,'testcase','createBug'),
(3,'testcase','delete'),
(3,'testcase','edit'),
(3,'testcase','export'),
(3,'testcase','exportTemplet'),
(3,'testcase','groupCase'),
(3,'testcase','ignoreLibcaseChange'),
(3,'testcase','import'),
(3,'testcase','index'),
(3,'testcase','importFromLib'),
(3,'testcase','linkCases'),
(3,'testcase','review'),
(3,'testcase','showImport'),
(3,'testcase','view'),
(3,'testreport','browse'),
(3,'testreport','view'),
(3,'testsuite','batchUnlinkCases'),
(3,'testsuite','browse'),
(3,'testsuite','create'),
(3,'testsuite','delete'),
(3,'testsuite','edit'),
(3,'testsuite','index'),
(3,'testsuite','linkCase'),
(3,'testsuite','unlinkCase'),
(3,'testsuite','view'),
(3,'testtask','activate'),
(3,'testtask','batchAssign'),
(3,'testtask','batchRun'),
(3,'testtask','batchUnlinkCases'),
(3,'testtask','block'),
(3,'testtask','browse'),
(3,'testtask','browseUnits'),
(3,'testtask','cases'),
(3,'testtask','close'),
(3,'testtask','create'),
(3,'testtask','edit'),
(3,'testtask','groupCase'),
(3,'testtask','index'),
(3,'testtask','importUnitResult'),
(3,'testtask','linkcase'),
(3,'testtask','report'),
(3,'testtask','results'),
(3,'testtask','runcase'),
(3,'testtask','start'),
(3,'testtask','unitCases'),
(3,'testtask','unlinkcase'),
(3,'testtask','view'),
(3,'todo','activate'),
(3,'todo','assignTo'),
(3,'todo','batchClose'),
(3,'todo','batchCreate'),
(3,'todo','batchEdit'),
(3,'todo','batchFinish'),
(3,'todo','close'),
(3,'todo','create'),
(3,'todo','createcycle'),
(3,'todo','delete'),
(3,'todo','edit'),
(3,'todo','export'),
(3,'todo','finish'),
(3,'todo','import2Today'),
(3,'todo','start'),
(3,'todo','view'),
(3,'user','bug'),
(3,'user','cropAvatar'),
(3,'user','dynamic'),
(3,'user','execution'),
(3,'user','issue'),
(3,'user','profile'),
(3,'user','risk'),
(3,'user','story'),
(3,'user','task'),
(3,'user','testCase'),
(3,'user','testTask'),
(3,'user','todo'),
(3,'user','view'),
(4,'action','comment'),
(4,'action','editComment'),
(4,'action','hideAll'),
(4,'action','hideOne'),
(4,'action','trash'),
(4,'action','undelete'),
(4,'admin','index'),
(4,'admin','checkWeak'),
(4,'admin','safe'),
(4,'automation','browse'),
(4,'bug','activate'),
(4,'bug','assignTo'),
(4,'bug','batchActivate'),
(4,'bug','batchAssignTo'),
(4,'bug','batchChangeBranch'),
(4,'bug','batchChangeModule'),
(4,'bug','batchClose'),
(4,'bug','batchConfirm'),
(4,'bug','batchCreate'),
(4,'bug','batchEdit'),
(4,'bug','batchResolve'),
(4,'bug','browse'),
(4,'bug','close'),
(4,'bug','confirmBug'),
(4,'bug','confirmStoryChange'),
(4,'bug','create'),
(4,'bug','delete'),
(4,'bug','edit'),
(4,'bug','export'),
(4,'bug','index'),
(4,'bug','linkBugs'),
(4,'bug','report'),
(4,'bug','resolve'),
(4,'bug','view'),
(4,'build','batchUnlinkBug'),
(4,'build','batchUnlinkStory'),
(4,'build','create'),
(4,'build','delete'),
(4,'build','edit'),
(4,'build','linkBug'),
(4,'build','linkStory'),
(4,'build','unlinkBug'),
(4,'build','unlinkStory'),
(4,'build','view'),
(4,'caselib','batchCreateCase'),
(4,'caselib','browse'),
(4,'caselib','create'),
(4,'caselib','createCase'),
(4,'caselib','delete'),
(4,'caselib','edit'),
(4,'caselib','exportTemplet'),
(4,'caselib','import'),
(4,'caselib','index'),
(4,'caselib','showImport'),
(4,'caselib','view'),
(4,'ci','checkCompileStatus'),
(4,'ci','commitResult'),
(4,'company','browse'),
(4,'company','dynamic'),
(4,'company','edit'),
(4,'company','index'),
(4,'company','view'),
(4,'compile','browse'),
(4,'compile','logs'),
(4,'datatable','setGlobal'),
(4,'doc','allLibs'),
(4,'doc','browse'),
(4,'doc','collect'),
(4,'doc','create'),
(4,'doc','createLib'),
(4,'doc','delete'),
(4,'doc','deleteFile'),
(4,'doc','deleteLib'),
(4,'doc','edit'),
(4,'doc','editLib'),
(4,'doc','index'),
(4,'doc','objectLibs'),
(4,'doc','showFiles'),
(4,'doc','tableContents'),
(4,'doc','view'),
(4,'execution','activate'),
(4,'execution','addWhitelist'),
(4,'execution','all'),
(4,'execution','batchedit'),
(4,'execution','batchUnlinkStory'),
(4,'execution','browse'),
(4,'execution','bug'),
(4,'execution','build'),
(4,'execution','burn'),
(4,'execution','burnData'),
(4,'execution','close'),
(4,'execution','computeBurn'),
(4,'execution','create'),
(4,'execution','delete'),
(4,'execution','doc'),
(4,'execution','dynamic'),
(4,'execution','edit'),
(4,'execution','executionkanban'),
(4,'execution','export'),
(4,'execution','fixFirst'),
(4,'execution','grouptask'),
(4,'execution','importBug'),
(4,'execution','importplanstories'),
(4,'execution','importtask'),
(4,'execution','index'),
(4,'execution','kanban'),
(4,'execution','kanbanColsColor'),
(4,'execution','kanbanHideCols'),
(4,'execution','linkStory'),
(4,'execution','manageMembers'),
(4,'execution','manageProducts'),
(4,'execution','printKanban'),
(4,'execution','putoff'),
(4,'execution','start'),
(4,'execution','story'),
(4,'execution','storyEstimate'),
(4,'execution','storyKanban'),
(4,'execution','storySort'),
(4,'execution','suspend'),
(4,'execution','task'),
(4,'execution','team'),
(4,'execution','testcase'),
(4,'execution','testreport'),
(4,'execution','testtask'),
(4,'execution','tree'),
(4,'execution','treeStory'),
(4,'execution','treeTask'),
(4,'execution','unbindWhitelist'),
(4,'execution','unlinkMember'),
(4,'execution','unlinkStory'),
(4,'execution','updateOrder'),
(4,'execution','view'),
(4,'execution','whitelist'),
(4,'extension','browse'),
(4,'extension','obtain'),
(4,'extension','structure'),
(4,'file','delete'),
(4,'file','download'),
(4,'file','edit'),
(4,'file','setPublic'),
(4,'file','uploadImages'),
(4,'git','apiSync'),
(4,'git','cat'),
(4,'git','diff'),
(4,'group','browse'),
(4,'index','index'),
(4,'jenkins','browse'),
(4,'jenkins','create'),
(4,'jenkins','delete'),
(4,'jenkins','edit'),
(4,'job','browse'),
(4,'job','create'),
(4,'job','delete'),
(4,'job','edit'),
(4,'job','exec'),
(4,'job','view'),
(4,'misc','ping'),
(4,'my','bug'),
(4,'my','calendar'),
(4,'my','changePassword'),
(4,'my','contribute'),
(4,'my','deleteContacts'),
(4,'my','doc'),
(4,'my','dynamic'),
(4,'my','editProfile'),
(4,'my','execution'),
(4,'my','index'),
(4,'my','manageContacts'),
(4,'my','preference'),
(4,'my','profile'),
(4,'my','project'),
(4,'my','score'),
(4,'my','story'),
(4,'my','task'),
(4,'my','team'),
(4,'my','testcase'),
(4,'my','testtask'),
(4,'my','todo'),
(4,'my','unbind'),
(4,'my','uploadAvatar'),
(4,'my','work'),
(4,'personnel','accessible'),
(4,'personnel','addWhitelist'),
(4,'personnel','invest'),
(4,'personnel','unbindWhitelist'),
(4,'personnel','whitelist'),
(4,'product','all'),
(4,'product','batchEdit'),
(4,'product','browse'),
(4,'product','build'),
(4,'product','close'),
(4,'product','create'),
(4,'product','dashboard'),
(4,'product','doc'),
(4,'product','delete'),
(4,'product','dynamic'),
(4,'product','edit'),
(4,'product','index'),
(4,'product','kanban'),
(4,'product','manageLine'),
(4,'product','project'),
(4,'product','roadmap'),
(4,'product','view'),
(4,'product','whitelist'),
(4,'productplan','batchEdit'),
(4,'productplan','batchUnlinkBug'),
(4,'productplan','batchUnlinkStory'),
(4,'productplan','browse'),
(4,'productplan','create'),
(4,'productplan','delete'),
(4,'productplan','edit'),
(4,'productplan','linkBug'),
(4,'productplan','linkStory'),
(4,'productplan','unlinkBug'),
(4,'productplan','unlinkStory'),
(4,'productplan','view'),
(4,'program','index'),
(4,'program','activate'),
(4,'program','browse'),
(4,'program','close'),
(4,'program','create'),
(4,'program','createStakeholder'),
(4,'program','delete'),
(4,'program','edit'),
(4,'program','export'),
(4,'program','kanban'),
(4,'program','product'),
(4,'program','project'),
(4,'program','stakeholder'),
(4,'program','start'),
(4,'program','suspend'),
(4,'program','unbindWhitelist'),
(4,'program','unlinkStakeholder'),
(4,'program','updateOrder'),
(4,'program','view'),
(4,'project','activate'),
(4,'project','addWhitelist'),
(4,'project','batchEdit'),
(4,'project','browse'),
(4,'project','bug'),
(4,'project','build'),
(4,'project','close'),
(4,'project','copyGroup'),
(4,'project','create'),
(4,'project','createGroup'),
(4,'project','createStakeholder'),
(4,'project','createGuide'),
(4,'project','delete'),
(4,'project','dynamic'),
(4,'project','edit'),
(4,'project','editGroup'),
(4,'project','execution'),
(4,'project','export'),
(4,'project','group'),
(4,'project','index'),
(4,'project','kanban'),
(4,'project','manageGroupMember'),
(4,'project','manageMembers'),
(4,'project','managePriv'),
(4,'project','manageProducts'),
(4,'project','manageView'),
(4,'project','programTitle'),
(4,'project','qa'),
(4,'project','start'),
(4,'project','suspend'),
(4,'project','team'),
(4,'project','testcase'),
(4,'project','testreport'),
(4,'project','testtask'),
(4,'project','unbindWhitelist'),
(4,'project','unlinkMember'),
(4,'project','updateOrder'),
(4,'project','view'),
(4,'project','whitelist'),
(4,'projectbuild','browse'),
(4,'projectrelease','batchUnlinkBug'),
(4,'projectrelease','batchUnlinkStory'),
(4,'projectrelease','browse'),
(4,'projectrelease','changeStatus'),
(4,'projectrelease','create'),
(4,'projectrelease','delete'),
(4,'projectrelease','edit'),
(4,'projectrelease','export'),
(4,'projectrelease','linkBug'),
(4,'projectrelease','linkStory'),
(4,'projectrelease','unlinkBug'),
(4,'projectrelease','unlinkStory'),
(4,'projectrelease','view'),
(4,'projectstory','batchUnlinkStory'),
(4,'projectstory','importplanstories'),
(4,'projectstory','linkStory'),
(4,'projectstory','story'),
(4,'projectstory','track'),
(4,'projectstory','unlinkStory'),
(4,'projectstory','view'),
(4,'qa','index'),
(4,'release','batchUnlinkBug'),
(4,'release','batchUnlinkStory'),
(4,'release','browse'),
(4,'release','changeStatus'),
(4,'release','create'),
(4,'release','delete'),
(4,'release','edit'),
(4,'release','export'),
(4,'release','linkBug'),
(4,'release','linkStory'),
(4,'release','unlinkBug'),
(4,'release','unlinkStory'),
(4,'release','view'),
(4,'repo','blame'),
(4,'repo','browse'),
(4,'repo','create'),
(4,'repo','delete'),
(4,'repo','diff'),
(4,'repo','download'),
(4,'repo','edit'),
(4,'repo','log'),
(4,'repo','maintain'),
(4,'repo','revision'),
(4,'repo','setRules'),
(4,'repo','showSyncCommit'),
(4,'repo','view'),
(4,'report','bugAssign'),
(4,'report','bugCreate'),
(4,'report','index'),
(4,'report','productSummary'),
(4,'report','projectDeviation'),
(4,'report','workload'),
(4,'search','buildForm'),
(4,'search','buildQuery'),
(4,'search','deleteQuery'),
(4,'search','index'),
(4,'search','saveQuery'),
(4,'search','select'),
(4,'stakeholder','batchCreate'),
(4,'stakeholder','browse'),
(4,'stakeholder','communicate'),
(4,'stakeholder','create'),
(4,'stakeholder','createExpect'),
(4,'stakeholder','delete'),
(4,'stakeholder','deleteExpect'),
(4,'stakeholder','edit'),
(4,'stakeholder','editExpect'),
(4,'stakeholder','expect'),
(4,'stakeholder','expectation'),
(4,'stakeholder','issue'),
(4,'stakeholder','plan'),
(4,'stakeholder','userIssue'),
(4,'stakeholder','view'),
(4,'stakeholder','viewExpect'),
(4,'stakeholder','viewIssue'),
(4,'story','activate'),
(4,'story','assignTo'),
(4,'story','batchAssignTo'),
(4,'story','batchChangeBranch'),
(4,'story','batchChangeModule'),
(4,'story','batchChangePlan'),
(4,'story','batchChangeStage'),
(4,'story','batchClose'),
(4,'story','batchCreate'),
(4,'story','batchEdit'),
(4,'story','batchReview'),
(4,'story','batchToTask'),
(4,'story','bugs'),
(4,'story','cases'),
(4,'story','change'),
(4,'story','close'),
(4,'story','create'),
(4,'story','delete'),
(4,'story','edit'),
(4,'story','export'),
(4,'story','linkStory'),
(4,'story','processStoryChange'),
(4,'story','recall'),
(4,'story','report'),
(4,'story','review'),
(4,'story','tasks'),
(4,'story','track'),
(4,'story','view'),
(4,'story','zeroCase'),
(4,'svn','apiSync'),
(4,'svn','cat'),
(4,'svn','diff'),
(4,'task','activate'),
(4,'task','assignTo'),
(4,'task','batchAssignTo'),
(4,'task','batchCancel'),
(4,'task','batchChangeModule'),
(4,'task','batchClose'),
(4,'task','batchCreate'),
(4,'task','batchEdit'),
(4,'task','cancel'),
(4,'task','close'),
(4,'task','confirmStoryChange'),
(4,'task','create'),
(4,'task','delete'),
(4,'task','deleteEstimate'),
(4,'task','edit'),
(4,'task','editEstimate'),
(4,'task','export'),
(4,'task','finish'),
(4,'task','pause'),
(4,'task','recordEstimate'),
(4,'task','report'),
(4,'task','restart'),
(4,'task','start'),
(4,'task','view'),
(4,'testcase','batchCaseTypeChange'),
(4,'testcase','batchChangeBranch'),
(4,'testcase','batchChangeModule'),
(4,'testcase','batchConfirmStoryChange'),
(4,'testcase','batchCreate'),
(4,'testcase','batchDelete'),
(4,'testcase','batchEdit'),
(4,'testcase','batchReview'),
(4,'testcase','browse'),
(4,'testcase','bugs'),
(4,'testcase','confirmChange'),
(4,'testcase','confirmLibcaseChange'),
(4,'testcase','confirmStoryChange'),
(4,'testcase','create'),
(4,'testcase','createBug'),
(4,'testcase','delete'),
(4,'testcase','edit'),
(4,'testcase','export'),
(4,'testcase','exportTemplet'),
(4,'testcase','groupCase'),
(4,'testcase','index'),
(4,'testcase','ignoreLibcaseChange'),
(4,'testcase','import'),
(4,'testcase','importFromLib'),
(4,'testcase','linkCases'),
(4,'testcase','review'),
(4,'testcase','showImport'),
(4,'testcase','view'),
(4,'testreport','browse'),
(4,'testreport','create'),
(4,'testreport','delete'),
(4,'testreport','edit'),
(4,'testreport','view'),
(4,'testsuite','batchUnlinkCases'),
(4,'testsuite','browse'),
(4,'testsuite','create'),
(4,'testsuite','delete'),
(4,'testsuite','edit'),
(4,'testsuite','index'),
(4,'testsuite','linkCase'),
(4,'testsuite','unlinkCase'),
(4,'testsuite','view'),
(4,'testtask','activate'),
(4,'testtask','batchAssign'),
(4,'testtask','batchRun'),
(4,'testtask','batchUnlinkCases'),
(4,'testtask','block'),
(4,'testtask','browse'),
(4,'testtask','browseUnits'),
(4,'testtask','cases'),
(4,'testtask','close'),
(4,'testtask','create'),
(4,'testtask','delete'),
(4,'testtask','edit'),
(4,'testtask','groupCase'),
(4,'testtask','importUnitResult'),
(4,'testtask','index'),
(4,'testtask','linkcase'),
(4,'testtask','report'),
(4,'testtask','results'),
(4,'testtask','runcase'),
(4,'testtask','start'),
(4,'testtask','unitCases'),
(4,'testtask','unlinkcase'),
(4,'testtask','view'),
(4,'todo','activate'),
(4,'todo','assignTo'),
(4,'todo','batchClose'),
(4,'todo','batchCreate'),
(4,'todo','batchEdit'),
(4,'todo','batchFinish'),
(4,'todo','close'),
(4,'todo','create'),
(4,'todo','createcycle'),
(4,'todo','delete'),
(4,'todo','edit'),
(4,'todo','export'),
(4,'todo','finish'),
(4,'todo','import2Today'),
(4,'todo','start'),
(4,'todo','view'),
(4,'tree','browse'),
(4,'tree','browseTask'),
(4,'tree','delete'),
(4,'tree','edit'),
(4,'tree','fix'),
(4,'tree','manageChild'),
(4,'tree','updateOrder'),
(4,'user','bug'),
(4,'user','cropAvatar'),
(4,'user','dynamic'),
(4,'user','execution'),
(4,'user','issue'),
(4,'user','profile'),
(4,'user','risk'),
(4,'user','setPublicTemplate'),
(4,'user','story'),
(4,'user','task'),
(4,'user','testCase'),
(4,'user','testTask'),
(4,'user','todo'),
(4,'user','view'),
(5,'action','comment'),
(5,'action','editComment'),
(5,'action','hideAll'),
(5,'action','hideOne'),
(5,'action','trash'),
(5,'action','undelete'),
(5,'admin','index'),
(5,'admin','checkWeak'),
(5,'admin','safe'),
(5,'automation','browse'),
(5,'branch','delete'),
(5,'branch','manage'),
(5,'branch','sort'),
(5,'bug','activate'),
(5,'bug','assignTo'),
(5,'bug','batchActivate'),
(5,'bug','batchAssignTo'),
(5,'bug','batchChangeBranch'),
(5,'bug','batchChangeModule'),
(5,'bug','batchClose'),
(5,'bug','batchConfirm'),
(5,'bug','batchCreate'),
(5,'bug','batchEdit'),
(5,'bug','batchResolve'),
(5,'bug','browse'),
(5,'bug','close'),
(5,'bug','confirmBug'),
(5,'bug','confirmStoryChange'),
(5,'bug','create'),
(5,'bug','delete'),
(5,'bug','edit'),
(5,'bug','export'),
(5,'bug','index'),
(5,'bug','linkBugs'),
(5,'bug','report'),
(5,'bug','resolve'),
(5,'bug','view'),
(5,'build','batchUnlinkBug'),
(5,'build','batchUnlinkStory'),
(5,'build','create'),
(5,'build','delete'),
(5,'build','edit'),
(5,'build','linkBug'),
(5,'build','linkStory'),
(5,'build','unlinkBug'),
(5,'build','unlinkStory'),
(5,'build','view'),
(5,'company','browse'),
(5,'company','dynamic'),
(5,'company','index'),
(5,'company','view'),
(5,'compile','browse'),
(5,'compile','logs'),
(5,'datatable','setGlobal'),
(5,'doc','allLibs'),
(5,'doc','browse'),
(5,'doc','collect'),
(5,'doc','create'),
(5,'doc','createLib'),
(5,'doc','delete'),
(5,'doc','deleteFile'),
(5,'doc','deleteLib'),
(5,'doc','edit'),
(5,'doc','editLib'),
(5,'doc','index'),
(5,'doc','objectLibs'),
(5,'doc','showFiles'),
(5,'doc','tableContents'),
(5,'doc','view'),
(5,'execution','activate'),
(5,'execution','addWhitelist'),
(5,'execution','all'),
(5,'execution','batchedit'),
(5,'execution','batchUnlinkStory'),
(5,'execution','browse'),
(5,'execution','bug'),
(5,'execution','build'),
(5,'execution','burn'),
(5,'execution','burnData'),
(5,'execution','close'),
(5,'execution','computeBurn'),
(5,'execution','create'),
(5,'execution','delete'),
(5,'execution','doc'),
(5,'execution','dynamic'),
(5,'execution','edit'),
(5,'execution','executionkanban'),
(5,'execution','export'),
(5,'execution','fixFirst'),
(5,'execution','grouptask'),
(5,'execution','importBug'),
(5,'execution','importplanstories'),
(5,'execution','importtask'),
(5,'execution','index'),
(5,'execution','kanban'),
(5,'execution','kanbanColsColor'),
(5,'execution','kanbanHideCols'),
(5,'execution','linkStory'),
(5,'execution','manageMembers'),
(5,'execution','manageProducts'),
(5,'execution','printKanban'),
(5,'execution','putoff'),
(5,'execution','start'),
(5,'execution','story'),
(5,'execution','storyEstimate'),
(5,'execution','storyKanban'),
(5,'execution','storySort'),
(5,'execution','suspend'),
(5,'execution','task'),
(5,'execution','team'),
(5,'execution','testcase'),
(5,'execution','testreport'),
(5,'execution','testtask'),
(5,'execution','tree'),
(5,'execution','treeStory'),
(5,'execution','treeTask'),
(5,'execution','unbindWhitelist'),
(5,'execution','unlinkMember'),
(5,'execution','unlinkStory'),
(5,'execution','updateOrder'),
(5,'execution','view'),
(5,'execution','whitelist'),
(5,'extension','browse'),
(5,'extension','obtain'),
(5,'extension','structure'),
(5,'file','delete'),
(5,'file','download'),
(5,'file','edit'),
(5,'file','setPublic'),
(5,'file','uploadImages'),
(5,'git','apiSync'),
(5,'git','cat'),
(5,'git','diff'),
(5,'group','browse'),
(5,'index','index'),
(5,'jenkins','browse'),
(5,'jenkins','create'),
(5,'jenkins','delete'),
(5,'jenkins','edit'),
(5,'job','browse'),
(5,'job','create'),
(5,'job','delete'),
(5,'job','edit'),
(5,'job','exec'),
(5,'job','view'),
(5,'misc','ping'),
(5,'my','bug'),
(5,'my','calendar'),
(5,'my','changePassword'),
(5,'my','contribute'),
(5,'my','deleteContacts'),
(5,'my','doc'),
(5,'my','dynamic'),
(5,'my','editProfile'),
(5,'my','execution'),
(5,'my','index'),
(5,'my','manageContacts'),
(5,'my','preference'),
(5,'my','profile'),
(5,'my','project'),
(5,'my','score'),
(5,'my','story'),
(5,'my','task'),
(5,'my','team'),
(5,'my','testcase'),
(5,'my','testtask'),
(5,'my','todo'),
(5,'my','unbind'),
(5,'my','uploadAvatar'),
(5,'my','work'),
(5,'personnel','accessible'),
(5,'personnel','addWhitelist'),
(5,'personnel','invest'),
(5,'personnel','unbindWhitelist'),
(5,'personnel','whitelist'),
(5,'product','addWhitelist'),
(5,'product','all'),
(5,'product','batchEdit'),
(5,'product','browse'),
(5,'product','build'),
(5,'product','close'),
(5,'product','create'),
(5,'product','dashboard'),
(5,'product','delete'),
(5,'product','doc'),
(5,'product','dynamic'),
(5,'product','edit'),
(5,'product','export'),
(5,'product','index'),
(5,'product','kanban'),
(5,'product','manageLine'),
(5,'product','project'),
(5,'product','roadmap'),
(5,'product','unbindWhitelist'),
(5,'product','updateOrder'),
(5,'product','view'),
(5,'product','whitelist'),
(5,'productplan','batchEdit'),
(5,'productplan','batchUnlinkBug'),
(5,'productplan','batchUnlinkStory'),
(5,'productplan','browse'),
(5,'productplan','create'),
(5,'productplan','delete'),
(5,'productplan','edit'),
(5,'productplan','linkBug'),
(5,'productplan','linkStory'),
(5,'productplan','unlinkBug'),
(5,'productplan','unlinkStory'),
(5,'productplan','view'),
(5,'program','index'),
(5,'program','activate'),
(5,'program','batchUnlinkStakeholders'),
(5,'program','browse'),
(5,'program','close'),
(5,'program','create'),
(5,'program','createStakeholder'),
(5,'program','delete'),
(5,'program','edit'),
(5,'program','export'),
(5,'program','kanban'),
(5,'program','product'),
(5,'program','project'),
(5,'program','stakeholder'),
(5,'program','start'),
(5,'program','suspend'),
(5,'program','unbindWhitelist'),
(5,'program','unlinkStakeholder'),
(5,'program','updateOrder'),
(5,'program','view'),
(5,'project','activate'),
(5,'project','addWhitelist'),
(5,'project','batchEdit'),
(5,'project','browse'),
(5,'project','bug'),
(5,'project','build'),
(5,'project','close'),
(5,'project','copyGroup'),
(5,'project','create'),
(5,'project','createGroup'),
(5,'project','createGuide'),
(5,'project','delete'),
(5,'project','dynamic'),
(5,'project','edit'),
(5,'project','editGroup'),
(5,'project','execution'),
(5,'project','export'),
(5,'project','group'),
(5,'project','index'),
(5,'project','kanban'),
(5,'project','manageGroupMember'),
(5,'project','manageMembers'),
(5,'project','managePriv'),
(5,'project','manageProducts'),
(5,'project','programTitle'),
(5,'project','qa'),
(5,'project','start'),
(5,'project','suspend'),
(5,'project','team'),
(5,'project','testcase'),
(5,'project','testreport'),
(5,'project','testtask'),
(5,'project','unbindWhitelist'),
(5,'project','unlinkMember'),
(5,'project','updateOrder'),
(5,'project','view'),
(5,'project','whitelist'),
(5,'projectbuild','browse'),
(5,'projectrelease','batchUnlinkBug'),
(5,'projectrelease','batchUnlinkStory'),
(5,'projectrelease','browse'),
(5,'projectrelease','changeStatus'),
(5,'projectrelease','create'),
(5,'projectrelease','delete'),
(5,'projectrelease','edit'),
(5,'projectrelease','export'),
(5,'projectrelease','linkBug'),
(5,'projectrelease','linkStory'),
(5,'projectrelease','unlinkBug'),
(5,'projectrelease','unlinkStory'),
(5,'projectrelease','view'),
(5,'projectstory','batchUnlinkStory'),
(5,'projectstory','importplanstories'),
(5,'projectstory','linkStory'),
(5,'projectstory','story'),
(5,'projectstory','track'),
(5,'projectstory','unlinkStory'),
(5,'projectstory','view'),
(5,'qa','index'),
(5,'release','batchUnlinkBug'),
(5,'release','batchUnlinkStory'),
(5,'release','browse'),
(5,'release','changeStatus'),
(5,'release','create'),
(5,'release','delete'),
(5,'release','edit'),
(5,'release','export'),
(5,'release','linkBug'),
(5,'release','linkStory'),
(5,'release','unlinkBug'),
(5,'release','unlinkStory'),
(5,'release','view'),
(5,'repo','blame'),
(5,'repo','browse'),
(5,'repo','create'),
(5,'repo','delete'),
(5,'repo','diff'),
(5,'repo','download'),
(5,'repo','edit'),
(5,'repo','log'),
(5,'repo','maintain'),
(5,'repo','revision'),
(5,'repo','setRules'),
(5,'repo','showSyncCommit'),
(5,'repo','view'),
(5,'report','bugAssign'),
(5,'report','bugCreate'),
(5,'report','index'),
(5,'report','productSummary'),
(5,'report','projectDeviation'),
(5,'report','workload'),
(5,'search','buildForm'),
(5,'search','buildQuery'),
(5,'search','deleteQuery'),
(5,'search','index'),
(5,'search','saveQuery'),
(5,'search','select'),
(5,'stakeholder','browse'),
(5,'stakeholder','batchCreate'),
(5,'stakeholder','communicate'),
(5,'stakeholder','create'),
(5,'stakeholder','createExpect'),
(5,'stakeholder','delete'),
(5,'stakeholder','deleteExpect'),
(5,'stakeholder','edit'),
(5,'stakeholder','editExpect'),
(5,'stakeholder','expect'),
(5,'stakeholder','expectation'),
(5,'stakeholder','issue'),
(5,'stakeholder','plan'),
(5,'stakeholder','userIssue'),
(5,'stakeholder','view'),
(5,'stakeholder','viewExpect'),
(5,'stakeholder','viewIssue'),
(5,'story','activate'),
(5,'story','assignTo'),
(5,'story','batchAssignTo'),
(5,'story','batchChangeBranch'),
(5,'story','batchChangeModule'),
(5,'story','batchChangePlan'),
(5,'story','batchChangeStage'),
(5,'story','batchClose'),
(5,'story','batchCreate'),
(5,'story','batchEdit'),
(5,'story','batchReview'),
(5,'story','batchToTask'),
(5,'story','bugs'),
(5,'story','cases'),
(5,'story','change'),
(5,'story','close'),
(5,'story','create'),
(5,'story','delete'),
(5,'story','edit'),
(5,'story','export'),
(5,'story','linkStory'),
(5,'story','processStoryChange'),
(5,'story','recall'),
(5,'story','report'),
(5,'story','review'),
(5,'story','tasks'),
(5,'story','track'),
(5,'story','view'),
(5,'story','zeroCase'),
(5,'svn','apiSync'),
(5,'svn','cat'),
(5,'svn','diff'),
(5,'task','activate'),
(5,'task','assignTo'),
(5,'task','batchAssignTo'),
(5,'task','batchCancel'),
(5,'task','batchChangeModule'),
(5,'task','batchClose'),
(5,'task','batchCreate'),
(5,'task','batchEdit'),
(5,'task','cancel'),
(5,'task','close'),
(5,'task','confirmStoryChange'),
(5,'task','create'),
(5,'task','delete'),
(5,'task','deleteEstimate'),
(5,'task','edit'),
(5,'task','editEstimate'),
(5,'task','export'),
(5,'task','finish'),
(5,'task','pause'),
(5,'task','recordEstimate'),
(5,'task','report'),
(5,'task','restart'),
(5,'task','start'),
(5,'task','view'),
(5,'testcase','browse'),
(5,'testcase','bugs'),
(5,'testcase','createBug'),
(5,'testcase','export'),
(5,'testcase','groupCase'),
(5,'testcase','importFromLib'),
(5,'testcase','index'),
(5,'testcase','view'),
(5,'testreport','browse'),
(5,'testreport','create'),
(5,'testreport','delete'),
(5,'testreport','edit'),
(5,'testreport','view'),
(5,'testsuite','browse'),
(5,'testsuite','index'),
(5,'testsuite','view'),
(5,'testtask','browse'),
(5,'testtask','cases'),
(5,'testtask','create'),
(5,'testtask','edit'),
(5,'testtask','groupCase'),
(5,'testtask','index'),
(5,'testtask','results'),
(5,'testtask','view'),
(5,'todo','activate'),
(5,'todo','assignTo'),
(5,'todo','batchClose'),
(5,'todo','batchCreate'),
(5,'todo','batchEdit'),
(5,'todo','batchFinish'),
(5,'todo','close'),
(5,'todo','create'),
(5,'todo','createcycle'),
(5,'todo','delete'),
(5,'todo','edit'),
(5,'todo','export'),
(5,'todo','finish'),
(5,'todo','import2Today'),
(5,'todo','start'),
(5,'todo','view'),
(5,'tree','browse'),
(5,'tree','browseTask'),
(5,'tree','delete'),
(5,'tree','edit'),
(5,'tree','fix'),
(5,'tree','manageChild'),
(5,'tree','updateOrder'),
(5,'user','bug'),
(5,'user','cropAvatar'),
(5,'user','dynamic'),
(5,'user','execution'),
(5,'user','issue'),
(5,'user','profile'),
(5,'user','risk'),
(5,'user','story'),
(5,'user','task'),
(5,'user','testCase'),
(5,'user','testTask'),
(5,'user','todo'),
(5,'user','view'),
(6,'action','comment'),
(6,'action','editComment'),
(6,'action','hideAll'),
(6,'action','hideOne'),
(6,'action','trash'),
(6,'action','undelete'),
(6,'admin','index'),
(6,'automation','browse'),
(6,'bug','activate'),
(6,'bug','assignTo'),
(6,'bug','batchActivate'),
(6,'bug','batchAssignTo'),
(6,'bug','batchChangeModule'),
(6,'bug','batchClose'),
(6,'bug','batchConfirm'),
(6,'bug','batchCreate'),
(6,'bug','batchEdit'),
(6,'bug','batchResolve'),
(6,'bug','browse'),
(6,'bug','close'),
(6,'bug','confirmBug'),
(6,'bug','confirmStoryChange'),
(6,'bug','create'),
(6,'bug','delete'),
(6,'bug','edit'),
(6,'bug','export'),
(6,'bug','index'),
(6,'bug','linkBugs'),
(6,'bug','report'),
(6,'bug','resolve'),
(6,'bug','view'),
(6,'build','batchUnlinkBug'),
(6,'build','batchUnlinkStory'),
(6,'build','create'),
(6,'build','delete'),
(6,'build','edit'),
(6,'build','linkBug'),
(6,'build','linkStory'),
(6,'build','unlinkBug'),
(6,'build','unlinkStory'),
(6,'build','view'),
(6,'company','browse'),
(6,'company','dynamic'),
(6,'company','index'),
(6,'company','view'),
(6,'datatable','setGlobal'),
(6,'doc','allLibs'),
(6,'doc','browse'),
(6,'doc','collect'),
(6,'doc','create'),
(6,'doc','createLib'),
(6,'doc','delete'),
(6,'doc','deleteFile'),
(6,'doc','deleteLib'),
(6,'doc','edit'),
(6,'doc','editLib'),
(6,'doc','index'),
(6,'doc','objectLibs'),
(6,'doc','showFiles'),
(6,'doc','tableContents'),
(6,'doc','view'),
(6,'execution','activate'),
(6,'execution','addWhitelist'),
(6,'execution','all'),
(6,'execution','batchedit'),
(6,'execution','batchUnlinkStory'),
(6,'execution','browse'),
(6,'execution','bug'),
(6,'execution','build'),
(6,'execution','burn'),
(6,'execution','burnData'),
(6,'execution','close'),
(6,'execution','computeBurn'),
(6,'execution','create'),
(6,'execution','delete'),
(6,'execution','doc'),
(6,'execution','dynamic'),
(6,'execution','edit'),
(6,'execution','executionkanban'),
(6,'execution','export'),
(6,'execution','fixFirst'),
(6,'execution','grouptask'),
(6,'execution','importBug'),
(6,'execution','importplanstories'),
(6,'execution','importtask'),
(6,'execution','index'),
(6,'execution','kanban'),
(6,'execution','kanbanColsColor'),
(6,'execution','kanbanHideCols'),
(6,'execution','linkStory'),
(6,'execution','manageMembers'),
(6,'execution','manageProducts'),
(6,'execution','printKanban'),
(6,'execution','putoff'),
(6,'execution','start'),
(6,'execution','story'),
(6,'execution','storyEstimate'),
(6,'execution','storyKanban'),
(6,'execution','storySort'),
(6,'execution','suspend'),
(6,'execution','task'),
(6,'execution','team'),
(6,'execution','testcase'),
(6,'execution','testreport'),
(6,'execution','testtask'),
(6,'execution','tree'),
(6,'execution','treeStory'),
(6,'execution','treeTask'),
(6,'execution','unbindWhitelist'),
(6,'execution','unlinkMember'),
(6,'execution','unlinkStory'),
(6,'execution','updateOrder'),
(6,'execution','view'),
(6,'execution','whitelist'),
(6,'extension','browse'),
(6,'extension','obtain'),
(6,'extension','structure'),
(6,'file','delete'),
(6,'file','download'),
(6,'file','edit'),
(6,'file','setPublic'),
(6,'file','uploadImages'),
(6,'git','apiSync'),
(6,'git','cat'),
(6,'git','diff'),
(6,'group','browse'),
(6,'index','index'),
(6,'misc','ping'),
(6,'my','bug'),
(6,'my','calendar'),
(6,'my','changePassword'),
(6,'my','contribute'),
(6,'my','deleteContacts'),
(6,'my','doc'),
(6,'my','dynamic'),
(6,'my','editProfile'),
(6,'my','execution'),
(6,'my','index'),
(6,'my','manageContacts'),
(6,'my','preference'),
(6,'my','profile'),
(6,'my','project'),
(6,'my','score'),
(6,'my','story'),
(6,'my','task'),
(6,'my','team'),
(6,'my','testcase'),
(6,'my','testtask'),
(6,'my','todo'),
(6,'my','unbind'),
(6,'my','uploadAvatar'),
(6,'my','work'),
(6,'personnel','accessible'),
(6,'personnel','invest'),
(6,'personnel','whitelist'),
(6,'product','all'),
(6,'product','browse'),
(6,'product','build'),
(6,'product','dashboard'),
(6,'product','doc'),
(6,'product','dynamic'),
(6,'product','index'),
(6,'product','kanban'),
(6,'product','manageLine'),
(6,'product','project'),
(6,'product','roadmap'),
(6,'product','view'),
(6,'product','whitelist'),
(6,'productplan','browse'),
(6,'productplan','view'),
(6,'program','index'),
(6,'program','activate'),
(6,'program','browse'),
(6,'program','close'),
(6,'program','create'),
(6,'program','delete'),
(6,'program','edit'),
(6,'program','kanban'),
(6,'program','product'),
(6,'program','project'),
(6,'program','stakeholder'),
(6,'program','start'),
(6,'program','suspend'),
(6,'program','view'),
(6,'project','activate'),
(6,'project','addWhitelist'),
(6,'project','batchEdit'),
(6,'project','browse'),
(6,'project','bug'),
(6,'project','build'),
(6,'project','close'),
(6,'project','copyGroup'),
(6,'project','create'),
(6,'project','createGroup'),
(6,'project','createGuide'),
(6,'project','delete'),
(6,'project','dynamic'),
(6,'project','edit'),
(6,'project','editGroup'),
(6,'project','execution'),
(6,'project','export'),
(6,'project','group'),
(6,'project','index'),
(6,'project','kanban'),
(6,'project','manageGroupMember'),
(6,'project','manageMembers'),
(6,'project','managePriv'),
(6,'project','manageProducts'),
(6,'project','programTitle'),
(6,'project','qa'),
(6,'project','start'),
(6,'project','suspend'),
(6,'project','team'),
(6,'project','testcase'),
(6,'project','testreport'),
(6,'project','testtask'),
(6,'project','unbindWhitelist'),
(6,'project','unlinkMember'),
(6,'project','updateOrder'),
(6,'project','view'),
(6,'project','whitelist'),
(6,'projectbuild','browse'),
(6,'projectrelease','batchUnlinkBug'),
(6,'projectrelease','batchUnlinkStory'),
(6,'projectrelease','browse'),
(6,'projectrelease','changeStatus'),
(6,'projectrelease','create'),
(6,'projectrelease','delete'),
(6,'projectrelease','edit'),
(6,'projectrelease','export'),
(6,'projectrelease','linkBug'),
(6,'projectrelease','linkStory'),
(6,'projectrelease','unlinkBug'),
(6,'projectrelease','unlinkStory'),
(6,'projectrelease','view'),
(6,'projectstory','batchUnlinkStory'),
(6,'projectstory','importplanstories'),
(6,'projectstory','linkStory'),
(6,'projectstory','story'),
(6,'projectstory','track'),
(6,'projectstory','unlinkStory'),
(6,'projectstory','view'),
(6,'qa','index'),
(6,'release','browse'),
(6,'release','export'),
(6,'release','view'),
(6,'repo','blame'),
(6,'repo','browse'),
(6,'repo','diff'),
(6,'repo','download'),
(6,'repo','log'),
(6,'repo','revision'),
(6,'repo','showSyncCommit'),
(6,'repo','view'),
(6,'report','bugAssign'),
(6,'report','bugCreate'),
(6,'report','index'),
(6,'report','productSummary'),
(6,'report','projectDeviation'),
(6,'report','workload'),
(6,'search','buildForm'),
(6,'search','buildQuery'),
(6,'search','deleteQuery'),
(6,'search','index'),
(6,'search','saveQuery'),
(6,'search','select'),
(6,'stakeholder','browse'),
(6,'stakeholder','communicate'),
(6,'stakeholder','createExpect'),
(6,'stakeholder','deleteExpect'),
(6,'stakeholder','editExpect'),
(6,'stakeholder','expect'),
(6,'stakeholder','expectation'),
(6,'stakeholder','issue'),
(6,'stakeholder','userIssue'),
(6,'stakeholder','view'),
(6,'stakeholder','viewExpect'),
(6,'stakeholder','viewIssue'),
(6,'story','batchToTask'),
(6,'story','bugs'),
(6,'story','cases'),
(6,'story','export'),
(6,'story','processStoryChange'),
(6,'story','report'),
(6,'story','tasks'),
(6,'story','track'),
(6,'story','view'),
(6,'story','zeroCase'),
(6,'svn','apiSync'),
(6,'svn','cat'),
(6,'svn','diff'),
(6,'task','activate'),
(6,'task','assignTo'),
(6,'task','batchAssignTo'),
(6,'task','batchCancel'),
(6,'task','batchChangeModule'),
(6,'task','batchClose'),
(6,'task','batchCreate'),
(6,'task','batchEdit'),
(6,'task','cancel'),
(6,'task','close'),
(6,'task','confirmStoryChange'),
(6,'task','create'),
(6,'task','delete'),
(6,'task','deleteEstimate'),
(6,'task','edit'),
(6,'task','editEstimate'),
(6,'task','export'),
(6,'task','finish'),
(6,'task','pause'),
(6,'task','recordEstimate'),
(6,'task','report'),
(6,'task','restart'),
(6,'task','start'),
(6,'task','view'),
(6,'testcase','browse'),
(6,'testcase','bugs'),
(6,'testcase','export'),
(6,'testcase','groupCase'),
(6,'testcase','index'),
(6,'testcase','view'),
(6,'testreport','browse'),
(6,'testreport','create'),
(6,'testreport','delete'),
(6,'testreport','edit'),
(6,'testreport','view'),
(6,'testsuite','browse'),
(6,'testsuite','index'),
(6,'testsuite','view'),
(6,'testtask','activate'),
(6,'testtask','batchAssign'),
(6,'testtask','batchRun'),
(6,'testtask','batchUnlinkCases'),
(6,'testtask','block'),
(6,'testtask','browse'),
(6,'testtask','browseUnits'),
(6,'testtask','cases'),
(6,'testtask','close'),
(6,'testtask','create'),
(6,'testtask','delete'),
(6,'testtask','edit'),
(6,'testtask','groupCase'),
(6,'testtask','importUnitResult'),
(6,'testtask','index'),
(6,'testtask','linkcase'),
(6,'testtask','report'),
(6,'testtask','results'),
(6,'testtask','runcase'),
(6,'testtask','start'),
(6,'testtask','unitCases'),
(6,'testtask','unlinkcase'),
(6,'testtask','view'),
(6,'todo','activate'),
(6,'todo','assignTo'),
(6,'todo','batchClose'),
(6,'todo','batchCreate'),
(6,'todo','batchEdit'),
(6,'todo','batchFinish'),
(6,'todo','close'),
(6,'todo','create'),
(6,'todo','createcycle'),
(6,'todo','delete'),
(6,'todo','edit'),
(6,'todo','export'),
(6,'todo','finish'),
(6,'todo','import2Today'),
(6,'todo','start'),
(6,'todo','view'),
(6,'tree','browse'),
(6,'tree','browseTask'),
(6,'tree','delete'),
(6,'tree','edit'),
(6,'tree','fix'),
(6,'tree','manageChild'),
(6,'tree','updateOrder'),
(6,'user','bug'),
(6,'user','cropAvatar'),
(6,'user','dynamic'),
(6,'user','execution'),
(6,'user','issue'),
(6,'user','profile'),
(6,'user','risk'),
(6,'user','setPublicTemplate'),
(6,'user','story'),
(6,'user','task'),
(6,'user','testCase'),
(6,'user','testTask'),
(6,'user','todo'),
(6,'user','view'),
(7,'action','comment'),
(7,'action','editComment'),
(7,'action','hideAll'),
(7,'action','hideOne'),
(7,'action','trash'),
(7,'action','undelete'),
(7,'admin','index'),
(7,'admin','checkWeak'),
(7,'admin','safe'),
(7,'automation','browse'),
(7,'branch','delete'),
(7,'branch','manage'),
(7,'branch','sort'),
(7,'bug','activate'),
(7,'bug','assignTo'),
(7,'bug','batchActivate'),
(7,'bug','batchAssignTo'),
(7,'bug','batchChangeBranch'),
(7,'bug','batchChangeModule'),
(7,'bug','batchClose'),
(7,'bug','batchConfirm'),
(7,'bug','batchCreate'),
(7,'bug','batchEdit'),
(7,'bug','batchResolve'),
(7,'bug','browse'),
(7,'bug','close'),
(7,'bug','confirmBug'),
(7,'bug','confirmStoryChange'),
(7,'bug','create'),
(7,'bug','delete'),
(7,'bug','edit'),
(7,'bug','export'),
(7,'bug','index'),
(7,'bug','linkBugs'),
(7,'bug','report'),
(7,'bug','resolve'),
(7,'bug','view'),
(7,'build','create'),
(7,'build','delete'),
(7,'build','edit'),
(7,'build','view'),
(7,'company','browse'),
(7,'company','dynamic'),
(7,'company','index'),
(7,'company','view'),
(7,'datatable','setGlobal'),
(7,'doc','allLibs'),
(7,'doc','browse'),
(7,'doc','collect'),
(7,'doc','create'),
(7,'doc','createLib'),
(7,'doc','delete'),
(7,'doc','deleteFile'),
(7,'doc','deleteLib'),
(7,'doc','edit'),
(7,'doc','editLib'),
(7,'doc','index'),
(7,'doc','objectLibs'),
(7,'doc','showFiles'),
(7,'doc','tableContents'),
(7,'doc','view'),
(7,'execution','all'),
(7,'execution','browse'),
(7,'execution','bug'),
(7,'execution','build'),
(7,'execution','burn'),
(7,'execution','doc'),
(7,'execution','dynamic'),
(7,'execution','grouptask'),
(7,'execution','index'),
(7,'execution','kanban'),
(7,'execution','linkStory'),
(7,'execution','manageProducts'),
(7,'execution','story'),
(7,'execution','storyKanban'),
(7,'execution','storySort'),
(7,'execution','task'),
(7,'execution','team'),
(7,'execution','testtask'),
(7,'execution','tree'),
(7,'execution','treeStory'),
(7,'execution','treeTask'),
(7,'execution','unlinkStory'),
(7,'execution','view'),
(7,'extension','browse'),
(7,'extension','obtain'),
(7,'extension','structure'),
(7,'file','delete'),
(7,'file','download'),
(7,'file','edit'),
(7,'file','setPublic'),
(7,'file','uploadImages'),
(7,'git','apiSync'),
(7,'git','cat'),
(7,'git','diff'),
(7,'group','browse'),
(7,'index','index'),
(7,'misc','ping'),
(7,'my','bug'),
(7,'my','calendar'),
(7,'my','changePassword'),
(7,'my','contribute'),
(7,'my','deleteContacts'),
(7,'my','doc'),
(7,'my','dynamic'),
(7,'my','editProfile'),
(7,'my','execution'),
(7,'my','index'),
(7,'my','manageContacts'),
(7,'my','preference'),
(7,'my','profile'),
(7,'my','project'),
(7,'my','score'),
(7,'my','story'),
(7,'my','task'),
(7,'my','team'),
(7,'my','testcase'),
(7,'my','testtask'),
(7,'my','todo'),
(7,'my','unbind'),
(7,'my','uploadAvatar'),
(7,'my','work'),
(7,'personnel','accessible'),
(7,'personnel','addWhitelist'),
(7,'personnel','invest'),
(7,'personnel','unbindWhitelist'),
(7,'personnel','whitelist'),
(7,'product','addWhitelist'),
(7,'product','all'),
(7,'product','batchEdit'),
(7,'product','browse'),
(7,'product','build'),
(7,'product','close'),
(7,'product','create'),
(7,'product','dashboard'),
(7,'product','delete'),
(7,'product','doc'),
(7,'product','dynamic'),
(7,'product','edit'),
(7,'product','export'),
(7,'product','index'),
(7,'product','kanban'),
(7,'product','manageLine'),
(7,'product','project'),
(7,'product','roadmap'),
(7,'product','unbindWhitelist'),
(7,'product','updateOrder'),
(7,'product','view'),
(7,'product','whitelist'),
(7,'productplan','batchEdit'),
(7,'productplan','batchUnlinkBug'),
(7,'productplan','batchUnlinkStory'),
(7,'productplan','browse'),
(7,'productplan','create'),
(7,'productplan','delete'),
(7,'productplan','edit'),
(7,'productplan','linkBug'),
(7,'productplan','linkStory'),
(7,'productplan','unlinkBug'),
(7,'productplan','unlinkStory'),
(7,'productplan','view'),
(7,'program','index'),
(7,'program','activate'),
(7,'program','batchUnlinkStakeholders'),
(7,'program','browse'),
(7,'program','close'),
(7,'program','create'),
(7,'program','createStakeholder'),
(7,'program','delete'),
(7,'program','edit'),
(7,'program','export'),
(7,'program','kanban'),
(7,'program','product'),
(7,'program','project'),
(7,'program','stakeholder'),
(7,'program','start'),
(7,'program','suspend'),
(7,'program','unbindWhitelist'),
(7,'program','unlinkStakeholder'),
(7,'program','updateOrder'),
(7,'program','view'),
(7,'project','activate'),
(7,'project','addWhitelist'),
(7,'project','batchEdit'),
(7,'project','browse'),
(7,'project','bug'),
(7,'project','build'),
(7,'project','close'),
(7,'project','copyGroup'),
(7,'project','create'),
(7,'project','createGroup'),
(7,'project','createGuide'),
(7,'project','delete'),
(7,'project','dynamic'),
(7,'project','edit'),
(7,'project','editGroup'),
(7,'project','execution'),
(7,'project','export'),
(7,'project','group'),
(7,'project','index'),
(7,'project','kanban'),
(7,'project','manageGroupMember'),
(7,'project','manageMembers'),
(7,'project','managePriv'),
(7,'project','manageProducts'),
(7,'project','programTitle'),
(7,'project','qa'),
(7,'project','start'),
(7,'project','suspend'),
(7,'project','team'),
(7,'project','testcase'),
(7,'project','testreport'),
(7,'project','testtask'),
(7,'project','unbindWhitelist'),
(7,'project','updateOrder'),
(7,'project','view'),
(7,'project','whitelist'),
(7,'projectbuild','browse'),
(7,'projectrelease','browse'),
(7,'projectrelease','export'),
(7,'projectrelease','view'),
(7,'projectstory','linkStory'),
(7,'projectstory','story'),
(7,'projectstory','track'),
(7,'projectstory','view'),
(7,'qa','index'),
(7,'release','batchUnlinkBug'),
(7,'release','batchUnlinkStory'),
(7,'release','browse'),
(7,'release','changeStatus'),
(7,'release','create'),
(7,'release','delete'),
(7,'release','edit'),
(7,'release','export'),
(7,'release','linkBug'),
(7,'release','linkStory'),
(7,'release','unlinkBug'),
(7,'release','unlinkStory'),
(7,'release','view'),
(7,'repo','blame'),
(7,'repo','browse'),
(7,'repo','diff'),
(7,'repo','download'),
(7,'repo','log'),
(7,'repo','revision'),
(7,'repo','showSyncCommit'),
(7,'repo','view'),
(7,'report','bugAssign'),
(7,'report','bugCreate'),
(7,'report','index'),
(7,'report','productSummary'),
(7,'report','projectDeviation'),
(7,'report','workload'),
(7,'search','buildForm'),
(7,'search','buildQuery'),
(7,'search','deleteQuery'),
(7,'search','index'),
(7,'search','saveQuery'),
(7,'search','select'),
(7,'stakeholder','batchCreate'),
(7,'stakeholder','browse'),
(7,'stakeholder','communicate'),
(7,'stakeholder','create'),
(7,'stakeholder','createExpect'),
(7,'stakeholder','delete'),
(7,'stakeholder','deleteExpect'),
(7,'stakeholder','edit'),
(7,'stakeholder','editExpect'),
(7,'stakeholder','expect'),
(7,'stakeholder','expectation'),
(7,'stakeholder','issue'),
(7,'stakeholder','userIssue'),
(7,'stakeholder','view'),
(7,'stakeholder','viewExpect'),
(7,'stakeholder','viewIssue'),
(7,'story','activate'),
(7,'story','assignTo'),
(7,'story','batchAssignTo'),
(7,'story','batchChangeBranch'),
(7,'story','batchChangeModule'),
(7,'story','batchChangePlan'),
(7,'story','batchChangeStage'),
(7,'story','batchClose'),
(7,'story','batchCreate'),
(7,'story','batchEdit'),
(7,'story','batchReview'),
(7,'story','bugs'),
(7,'story','cases'),
(7,'story','change'),
(7,'story','close'),
(7,'story','create'),
(7,'story','delete'),
(7,'story','edit'),
(7,'story','export'),
(7,'story','linkStory'),
(7,'story','processStoryChange'),
(7,'story','recall'),
(7,'story','report'),
(7,'story','review'),
(7,'story','tasks'),
(7,'story','track'),
(7,'story','view'),
(7,'story','zeroCase'),
(7,'svn','apiSync'),
(7,'svn','cat'),
(7,'svn','diff'),
(7,'task','activate'),
(7,'task','assignTo'),
(7,'task','batchAssignTo'),
(7,'task','batchChangeModule'),
(7,'task','batchClose'),
(7,'task','batchCreate'),
(7,'task','batchEdit'),
(7,'task','cancel'),
(7,'task','close'),
(7,'task','create'),
(7,'task','confirmStoryChange'),
(7,'task','deleteEstimate'),
(7,'task','edit'),
(7,'task','editEstimate'),
(7,'task','export'),
(7,'task','finish'),
(7,'task','pause'),
(7,'task','recordEstimate'),
(7,'task','report'),
(7,'task','restart'),
(7,'task','start'),
(7,'task','view'),
(7,'testcase','browse'),
(7,'testcase','bugs'),
(7,'testcase','createBug'),
(7,'testcase','export'),
(7,'testcase','groupCase'),
(7,'testcase','importFromLib'),
(7,'testcase','index'),
(7,'testcase','view'),
(7,'testreport','browse'),
(7,'testreport','export'),
(7,'testreport','view'),
(7,'testsuite','browse'),
(7,'testsuite','index'),
(7,'testsuite','view'),
(7,'testtask','browse'),
(7,'testtask','cases'),
(7,'testtask','create'),
(7,'testtask','edit'),
(7,'testtask','groupCase'),
(7,'testtask','index'),
(7,'testtask','results'),
(7,'testtask','view'),
(7,'todo','activate'),
(7,'todo','assignTo'),
(7,'todo','batchClose'),
(7,'todo','batchCreate'),
(7,'todo','batchEdit'),
(7,'todo','batchFinish'),
(7,'todo','close'),
(7,'todo','create'),
(7,'todo','createcycle'),
(7,'todo','delete'),
(7,'todo','edit'),
(7,'todo','export'),
(7,'todo','finish'),
(7,'todo','import2Today'),
(7,'todo','start'),
(7,'todo','view'),
(7,'tree','browse'),
(7,'tree','browseTask'),
(7,'tree','delete'),
(7,'tree','edit'),
(7,'tree','fix'),
(7,'tree','manageChild'),
(7,'tree','updateOrder'),
(7,'user','bug'),
(7,'user','cropAvatar'),
(7,'user','dynamic'),
(7,'user','execution'),
(7,'user','issue'),
(7,'user','profile'),
(7,'user','risk'),
(7,'user','setPublicTemplate'),
(7,'user','story'),
(7,'user','task'),
(7,'user','testCase'),
(7,'user','testTask'),
(7,'user','todo'),
(7,'user','view'),
(8,'action','comment'),
(8,'action','editComment'),
(8,'action','hideAll'),
(8,'action','hideOne'),
(8,'action','trash'),
(8,'action','undelete'),
(8,'admin','index'),
(8,'admin','checkWeak'),
(8,'admin','safe'),
(8,'automation','browse'),
(8,'bug','activate'),
(8,'bug','assignTo'),
(8,'bug','batchActivate'),
(8,'bug','batchAssignTo'),
(8,'bug','batchChangeBranch'),
(8,'bug','batchChangeModule'),
(8,'bug','batchClose'),
(8,'bug','batchConfirm'),
(8,'bug','batchCreate'),
(8,'bug','batchEdit'),
(8,'bug','batchResolve'),
(8,'bug','browse'),
(8,'bug','close'),
(8,'bug','confirmBug'),
(8,'bug','confirmStoryChange'),
(8,'bug','create'),
(8,'bug','delete'),
(8,'bug','edit'),
(8,'bug','export'),
(8,'bug','index'),
(8,'bug','linkBugs'),
(8,'bug','report'),
(8,'bug','resolve'),
(8,'bug','view'),
(8,'build','create'),
(8,'build','delete'),
(8,'build','edit'),
(8,'build','view'),
(8,'caselib','batchCreateCase'),
(8,'caselib','browse'),
(8,'caselib','create'),
(8,'caselib','createCase'),
(8,'caselib','delete'),
(8,'caselib','edit'),
(8,'caselib','exportTemplet'),
(8,'caselib','import'),
(8,'caselib','index'),
(8,'caselib','showImport'),
(8,'caselib','view'),
(8,'ci','checkCompileStatus'),
(8,'ci','commitResult'),
(8,'company','browse'),
(8,'company','dynamic'),
(8,'company','index'),
(8,'company','view'),
(8,'compile','browse'),
(8,'compile','logs'),
(8,'custom','index'),
(8,'datatable','setGlobal'),
(8,'doc','allLibs'),
(8,'doc','browse'),
(8,'doc','collect'),
(8,'doc','create'),
(8,'doc','createLib'),
(8,'doc','delete'),
(8,'doc','deleteFile'),
(8,'doc','deleteLib'),
(8,'doc','edit'),
(8,'doc','editLib'),
(8,'doc','index'),
(8,'doc','objectLibs'),
(8,'doc','showFiles'),
(8,'doc','tableContents'),
(8,'doc','view'),
(8,'execution','all'),
(8,'execution','browse'),
(8,'execution','bug'),
(8,'execution','build'),
(8,'execution','burn'),
(8,'execution','burnData'),
(8,'execution','computeBurn'),
(8,'execution','doc'),
(8,'execution','dynamic'),
(8,'execution','executionkanban'),
(8,'execution','grouptask'),
(8,'execution','importBug'),
(8,'execution','importtask'),
(8,'execution','index'),
(8,'execution','kanban'),
(8,'execution','story'),
(8,'execution','storyKanban'),
(8,'execution','task'),
(8,'execution','team'),
(8,'execution','testcase'),
(8,'execution','testreport'),
(8,'execution','testtask'),
(8,'execution','tree'),
(8,'execution','treeStory'),
(8,'execution','treeTask'),
(8,'execution','view'),
(8,'execution','whitelist'),
(8,'extension','browse'),
(8,'extension','obtain'),
(8,'extension','structure'),
(8,'file','delete'),
(8,'file','download'),
(8,'file','edit'),
(8,'file','setPublic'),
(8,'file','uploadImages'),
(8,'git','apiSync'),
(8,'git','cat'),
(8,'git','diff'),
(8,'gitlab','bindProduct'),
(8,'gitlab','bindUser'),
(8,'gitlab','browse'),
(8,'gitlab','create'),
(8,'gitlab','delete'),
(8,'gitlab','edit'),
(8,'gitlab','importIssue'),
(8,'group','browse'),
(8,'index','index'),
(8,'jenkins','browse'),
(8,'jenkins','create'),
(8,'jenkins','delete'),
(8,'jenkins','edit'),
(8,'job','browse'),
(8,'job','create'),
(8,'job','delete'),
(8,'job','edit'),
(8,'job','exec'),
(8,'job','view'),
(8,'misc','ping'),
(8,'my','bug'),
(8,'my','calendar'),
(8,'my','changePassword'),
(8,'my','contribute'),
(8,'my','deleteContacts'),
(8,'my','doc'),
(8,'my','dynamic'),
(8,'my','editProfile'),
(8,'my','execution'),
(8,'my','index'),
(8,'my','manageContacts'),
(8,'my','preference'),
(8,'my','profile'),
(8,'my','project'),
(8,'my','score'),
(8,'my','story'),
(8,'my','task'),
(8,'my','team'),
(8,'my','testcase'),
(8,'my','testtask'),
(8,'my','todo'),
(8,'my','unbind'),
(8,'my','uploadAvatar'),
(8,'my','work'),
(8,'product','all'),
(8,'product','browse'),
(8,'product','build'),
(8,'product','dashboard'),
(8,'product','doc'),
(8,'product','dynamic'),
(8,'product','index'),
(8,'product','kanban'),
(8,'product','manageLine'),
(8,'product','project'),
(8,'product','roadmap'),
(8,'product','view'),
(8,'product','whitelist'),
(8,'productplan','browse'),
(8,'productplan','view'),
(8,'program','index'),
(8,'program','activate'),
(8,'program','browse'),
(8,'program','close'),
(8,'program','create'),
(8,'program','delete'),
(8,'program','edit'),
(8,'program','kanban'),
(8,'program','product'),
(8,'program','project'),
(8,'program','stakeholder'),
(8,'program','start'),
(8,'program','suspend'),
(8,'program','view'),
(8,'project','activate'),
(8,'project','addWhitelist'),
(8,'project','batchEdit'),
(8,'project','browse'),
(8,'project','bug'),
(8,'project','build'),
(8,'project','close'),
(8,'project','copyGroup'),
(8,'project','create'),
(8,'project','createGroup'),
(8,'project','createGuide'),
(8,'project','delete'),
(8,'project','dynamic'),
(8,'project','edit'),
(8,'project','editGroup'),
(8,'project','execution'),
(8,'project','export'),
(8,'project','group'),
(8,'project','index'),
(8,'project','kanban'),
(8,'project','manageGroupMember'),
(8,'project','manageMembers'),
(8,'project','managePriv'),
(8,'project','manageProducts'),
(8,'project','programTitle'),
(8,'project','qa'),
(8,'project','start'),
(8,'project','suspend'),
(8,'project','team'),
(8,'project','testcase'),
(8,'project','testreport'),
(8,'project','testtask'),
(8,'project','unbindWhitelist'),
(8,'project','updateOrder'),
(8,'project','view'),
(8,'project','whitelist'),
(8,'projectbuild','browse'),
(8,'projectrelease','browse'),
(8,'projectstory','story'),
(8,'projectstory','track'),
(8,'projectstory','view'),
(8,'qa','index'),
(8,'release','browse'),
(8,'release','export'),
(8,'release','view'),
(8,'repo','blame'),
(8,'repo','browse'),
(8,'repo','diff'),
(8,'repo','download'),
(8,'repo','log'),
(8,'repo','revision'),
(8,'repo','showSyncCommit'),
(8,'repo','view'),
(8,'report','bugAssign'),
(8,'report','bugCreate'),
(8,'report','index'),
(8,'report','productSummary'),
(8,'report','projectDeviation'),
(8,'report','workload'),
(8,'search','buildForm'),
(8,'search','buildQuery'),
(8,'search','deleteQuery'),
(8,'search','index'),
(8,'search','saveQuery'),
(8,'search','select'),
(8,'story','batchToTask'),
(8,'story','bugs'),
(8,'story','cases'),
(8,'story','export'),
(8,'story','processStoryChange'),
(8,'story','report'),
(8,'story','tasks'),
(8,'story','track'),
(8,'story','view'),
(8,'story','zeroCase'),
(8,'svn','apiSync'),
(8,'svn','cat'),
(8,'svn','diff'),
(8,'task','activate'),
(8,'task','assignTo'),
(8,'task','batchAssignTo'),
(8,'task','batchChangeModule'),
(8,'task','batchClose'),
(8,'task','batchCreate'),
(8,'task','batchEdit'),
(8,'task','cancel'),
(8,'task','close'),
(8,'task','confirmStoryChange'),
(8,'task','create'),
(8,'task','delete'),
(8,'task','deleteEstimate'),
(8,'task','edit'),
(8,'task','editEstimate'),
(8,'task','export'),
(8,'task','finish'),
(8,'task','pause'),
(8,'task','recordEstimate'),
(8,'task','report'),
(8,'task','restart'),
(8,'task','start'),
(8,'task','view'),
(8,'testcase','batchCaseTypeChange'),
(8,'testcase','batchChangeBranch'),
(8,'testcase','batchChangeModule'),
(8,'testcase','batchConfirmStoryChange'),
(8,'testcase','batchCreate'),
(8,'testcase','batchDelete'),
(8,'testcase','batchEdit'),
(8,'testcase','batchReview'),
(8,'testcase','browse'),
(8,'testcase','bugs'),
(8,'testcase','confirmChange'),
(8,'testcase','confirmLibcaseChange'),
(8,'testcase','confirmStoryChange'),
(8,'testcase','create'),
(8,'testcase','createBug'),
(8,'testcase','delete'),
(8,'testcase','edit'),
(8,'testcase','export'),
(8,'testcase','exportTemplet'),
(8,'testcase','groupCase'),
(8,'testcase','ignoreLibcaseChange'),
(8,'testcase','import'),
(8,'testcase','importFromLib'),
(8,'testcase','index'),
(8,'testcase','linkCases'),
(8,'testcase','review'),
(8,'testcase','showImport'),
(8,'testcase','view'),
(8,'testreport','browse'),
(8,'testreport','create'),
(8,'testreport','delete'),
(8,'testreport','edit'),
(8,'testreport','view'),
(8,'testsuite','batchUnlinkCases'),
(8,'testsuite','browse'),
(8,'testsuite','create'),
(8,'testsuite','delete'),
(8,'testsuite','edit'),
(8,'testsuite','index'),
(8,'testsuite','linkCase'),
(8,'testsuite','unlinkCase'),
(8,'testsuite','view'),
(8,'testtask','activate'),
(8,'testtask','batchAssign'),
(8,'testtask','batchRun'),
(8,'testtask','batchUnlinkCases'),
(8,'testtask','block'),
(8,'testtask','browse'),
(8,'testtask','browseUnits'),
(8,'testtask','cases'),
(8,'testtask','close'),
(8,'testtask','create'),
(8,'testtask','delete'),
(8,'testtask','edit'),
(8,'testtask','groupCase'),
(8,'testtask','importUnitResult'),
(8,'testtask','index'),
(8,'testtask','linkcase'),
(8,'testtask','report'),
(8,'testtask','results'),
(8,'testtask','runcase'),
(8,'testtask','start'),
(8,'testtask','unitCases'),
(8,'testtask','unlinkcase'),
(8,'testtask','view'),
(8,'todo','activate'),
(8,'todo','assignTo'),
(8,'todo','batchClose'),
(8,'todo','batchCreate'),
(8,'todo','batchEdit'),
(8,'todo','batchFinish'),
(8,'todo','close'),
(8,'todo','create'),
(8,'todo','createcycle'),
(8,'todo','delete'),
(8,'todo','edit'),
(8,'todo','export'),
(8,'todo','finish'),
(8,'todo','import2Today'),
(8,'todo','start'),
(8,'todo','view'),
(8,'tree','browse'),
(8,'tree','browseTask'),
(8,'tree','delete'),
(8,'tree','edit'),
(8,'tree','fix'),
(8,'tree','manageChild'),
(8,'tree','updateOrder'),
(8,'user','bug'),
(8,'user','cropAvatar'),
(8,'user','dynamic'),
(8,'user','execution'),
(8,'user','issue'),
(8,'user','profile'),
(8,'user','risk'),
(8,'user','setPublicTemplate'),
(8,'user','story'),
(8,'user','task'),
(8,'user','testCase'),
(8,'user','testTask'),
(8,'user','todo'),
(8,'user','view'),
(9,'action','comment'),
(9,'action','editComment'),
(9,'action','hideAll'),
(9,'action','hideOne'),
(9,'action','trash'),
(9,'action','undelete'),
(9,'admin','index'),
(9,'bug','activate'),
(9,'bug','assignTo'),
(9,'bug','batchActivate'),
(9,'bug','batchAssignTo'),
(9,'bug','batchChangeBranch'),
(9,'bug','batchChangeModule'),
(9,'bug','batchClose'),
(9,'bug','batchConfirm'),
(9,'bug','batchCreate'),
(9,'bug','batchEdit'),
(9,'bug','batchResolve'),
(9,'bug','browse'),
(9,'bug','close'),
(9,'bug','confirmBug'),
(9,'bug','confirmStoryChange'),
(9,'bug','create'),
(9,'bug','delete'),
(9,'bug','edit'),
(9,'bug','export'),
(9,'bug','index'),
(9,'bug','linkBugs'),
(9,'bug','report'),
(9,'bug','resolve'),
(9,'bug','view'),
(9,'build','create'),
(9,'build','delete'),
(9,'build','edit'),
(9,'build','view'),
(9,'company','browse'),
(9,'company','dynamic'),
(9,'company','edit'),
(9,'company','index'),
(9,'company','view'),
(9,'custom','index'),
(9,'custom','restore'),
(9,'custom','setPublic'),
(9,'datatable','setGlobal'),
(9,'dept','browse'),
(9,'dept','delete'),
(9,'dept','manageChild'),
(9,'dept','updateOrder'),
(9,'doc','allLibs'),
(9,'doc','browse'),
(9,'doc','collect'),
(9,'doc','create'),
(9,'doc','createLib'),
(9,'doc','delete'),
(9,'doc','deleteFile'),
(9,'doc','deleteLib'),
(9,'doc','edit'),
(9,'doc','editLib'),
(9,'doc','index'),
(9,'doc','objectLibs'),
(9,'doc','showFiles'),
(9,'doc','tableContents'),
(9,'doc','view'),
(9,'execution','all'),
(9,'execution','browse'),
(9,'execution','bug'),
(9,'execution','build'),
(9,'execution','burn'),
(9,'execution','burnData'),
(9,'execution','computeBurn'),
(9,'execution','doc'),
(9,'execution','dynamic'),
(9,'execution','executionkanban'),
(9,'execution','grouptask'),
(9,'execution','index'),
(9,'execution','importBug'),
(9,'execution','importtask'),
(9,'execution','kanban'),
(9,'execution','manageMembers'),
(9,'execution','story'),
(9,'execution','storyKanban'),
(9,'execution','storySort'),
(9,'execution','task'),
(9,'execution','team'),
(9,'execution','testcase'),
(9,'execution','testreport'),
(9,'execution','testtask'),
(9,'execution','tree'),
(9,'execution','treeStory'),
(9,'execution','treeTask'),
(9,'execution','updateOrder'),
(9,'execution','view'),
(9,'execution','whitelist'),
(9,'extension','browse'),
(9,'extension','obtain'),
(9,'extension','structure'),
(9,'file','delete'),
(9,'file','download'),
(9,'file','edit'),
(9,'file','setPublic'),
(9,'file','uploadImages'),
(9,'git','apiSync'),
(9,'git','cat'),
(9,'git','diff'),
(9,'group','browse'),
(9,'index','index'),
(9,'misc','ping'),
(9,'my','bug'),
(9,'my','calendar'),
(9,'my','changePassword'),
(9,'my','contribute'),
(9,'my','deleteContacts'),
(9,'my','doc'),
(9,'my','dynamic'),
(9,'my','editProfile'),
(9,'my','execution'),
(9,'my','index'),
(9,'my','manageContacts'),
(9,'my','preference'),
(9,'my','profile'),
(9,'my','project'),
(9,'my','score'),
(9,'my','story'),
(9,'my','task'),
(9,'my','team'),
(9,'my','testcase'),
(9,'my','testtask'),
(9,'my','todo'),
(9,'my','unbind'),
(9,'my','uploadAvatar'),
(9,'my','work'),
(9,'personnel','accessible'),
(9,'personnel','invest'),
(9,'personnel','whitelist'),
(9,'product','all'),
(9,'product','browse'),
(9,'product','build'),
(9,'product','dashboard'),
(9,'product','doc'),
(9,'product','dynamic'),
(9,'product','index'),
(9,'product','kanban'),
(9,'product','manageLine'),
(9,'product','project'),
(9,'product','roadmap'),
(9,'product','view'),
(9,'product','whitelist'),
(9,'productplan','browse'),
(9,'productplan','view'),
(9,'program','index'),
(9,'program','activate'),
(9,'program','browse'),
(9,'program','close'),
(9,'program','create'),
(9,'program','delete'),
(9,'program','edit'),
(9,'program','kanban'),
(9,'program','product'),
(9,'program','project'),
(9,'program','stakeholder'),
(9,'program','start'),
(9,'program','suspend'),
(9,'program','view'),
(9,'project','activate'),
(9,'project','addWhitelist'),
(9,'project','batchEdit'),
(9,'project','browse'),
(9,'project','bug'),
(9,'project','build'),
(9,'project','close'),
(9,'project','copyGroup'),
(9,'project','create'),
(9,'project','createGroup'),
(9,'project','createGuide'),
(9,'project','delete'),
(9,'project','dynamic'),
(9,'project','edit'),
(9,'project','editGroup'),
(9,'project','execution'),
(9,'project','export'),
(9,'project','group'),
(9,'project','index'),
(9,'project','kanban'),
(9,'project','manageGroupMember'),
(9,'project','manageMembers'),
(9,'project','managePriv'),
(9,'project','manageProducts'),
(9,'project','programTitle'),
(9,'project','qa'),
(9,'project','start'),
(9,'project','suspend'),
(9,'project','team'),
(9,'project','testcase'),
(9,'project','testreport'),
(9,'project','testtask'),
(9,'project','unbindWhitelist'),
(9,'project','unlinkMember'),
(9,'project','updateOrder'),
(9,'project','view'),
(9,'project','whitelist'),
(9,'projectbuild','browse'),
(9,'projectrelease','browse'),
(9,'projectrelease','view'),
(9,'projectstory','story'),
(9,'projectstory','track'),
(9,'projectstory','view'),
(9,'qa','index'),
(9,'release','browse'),
(9,'release','export'),
(9,'release','view'),
(9,'repo','blame'),
(9,'repo','browse'),
(9,'repo','diff'),
(9,'repo','download'),
(9,'repo','log'),
(9,'repo','revision'),
(9,'repo','showSyncCommit'),
(9,'repo','view'),
(9,'report','bugAssign'),
(9,'report','bugCreate'),
(9,'report','index'),
(9,'report','productSummary'),
(9,'report','projectDeviation'),
(9,'report','workload'),
(9,'search','buildForm'),
(9,'search','buildQuery'),
(9,'search','deleteQuery'),
(9,'search','index'),
(9,'search','saveQuery'),
(9,'search','select'),
(9,'stakeholder','batchCreate'),
(9,'stakeholder','browse'),
(9,'stakeholder','communicate'),
(9,'stakeholder','create'),
(9,'stakeholder','createExpect'),
(9,'stakeholder','delete'),
(9,'stakeholder','deleteExpect'),
(9,'stakeholder','edit'),
(9,'stakeholder','editExpect'),
(9,'stakeholder','expect'),
(9,'stakeholder','expectation'),
(9,'stakeholder','issue'),
(9,'stakeholder','plan'),
(9,'stakeholder','userIssue'),
(9,'stakeholder','view'),
(9,'stakeholder','viewExpect'),
(9,'stakeholder','viewIssue'),
(9,'story','bugs'),
(9,'story','cases'),
(9,'story','export'),
(9,'story','processStoryChange'),
(9,'story','report'),
(9,'story','review'),
(9,'story','tasks'),
(9,'story','track'),
(9,'story','view'),
(9,'story','zeroCase'),
(9,'svn','apiSync'),
(9,'svn','cat'),
(9,'svn','diff'),
(9,'task','activate'),
(9,'task','assignTo'),
(9,'task','batchAssignTo'),
(9,'task','batchCancel'),
(9,'task','batchChangeModule'),
(9,'task','batchClose'),
(9,'task','batchCreate'),
(9,'task','batchEdit'),
(9,'task','cancel'),
(9,'task','close'),
(9,'task','confirmStoryChange'),
(9,'task','create'),
(9,'task','delete'),
(9,'task','deleteEstimate'),
(9,'task','edit'),
(9,'task','editEstimate'),
(9,'task','export'),
(9,'task','finish'),
(9,'task','pause'),
(9,'task','recordEstimate'),
(9,'task','report'),
(9,'task','restart'),
(9,'task','start'),
(9,'task','view'),
(9,'testcase','browse'),
(9,'testcase','bugs'),
(9,'testcase','export'),
(9,'testcase','groupCase'),
(9,'testcase','index'),
(9,'testcase','view'),
(9,'testreport','browse'),
(9,'testreport','create'),
(9,'testreport','delete'),
(9,'testreport','edit'),
(9,'testreport','view'),
(9,'testsuite','browse'),
(9,'testsuite','index'),
(9,'testsuite','view'),
(9,'testtask','browse'),
(9,'testtask','cases'),
(9,'testtask','create'),
(9,'testtask','edit'),
(9,'testtask','groupCase'),
(9,'testtask','index'),
(9,'testtask','results'),
(9,'testtask','view'),
(9,'todo','activate'),
(9,'todo','assignTo'),
(9,'todo','batchClose'),
(9,'todo','batchCreate'),
(9,'todo','batchEdit'),
(9,'todo','batchFinish'),
(9,'todo','close'),
(9,'todo','create'),
(9,'todo','createcycle'),
(9,'todo','delete'),
(9,'todo','edit'),
(9,'todo','export'),
(9,'todo','finish'),
(9,'todo','import2Today'),
(9,'todo','start'),
(9,'todo','view'),
(9,'user','batchCreate'),
(9,'user','batchEdit'),
(9,'user','bug'),
(9,'user','create'),
(9,'user','cropAvatar'),
(9,'user','delete'),
(9,'user','dynamic'),
(9,'user','edit'),
(9,'user','execution'),
(9,'user','issue'),
(9,'user','profile'),
(9,'user','risk'),
(9,'user','story'),
(9,'user','task'),
(9,'user','testCase'),
(9,'user','testTask'),
(9,'user','todo'),
(9,'user','unbind'),
(9,'user','unlock'),
(9,'user','view'),
(10,'action','editComment'),
(10,'bug','activate'),
(10,'bug','assignTo'),
(10,'bug','batchActivate'),
(10,'bug','batchAssignTo'),
(10,'bug','batchChangeModule'),
(10,'bug','batchClose'),
(10,'bug','batchConfirm'),
(10,'bug','batchCreate'),
(10,'bug','batchEdit'),
(10,'bug','batchResolve'),
(10,'bug','browse'),
(10,'bug','close'),
(10,'bug','confirmBug'),
(10,'bug','confirmStoryChange'),
(10,'bug','create'),
(10,'bug','edit'),
(10,'bug','export'),
(10,'bug','index'),
(10,'bug','linkBugs'),
(10,'bug','report'),
(10,'bug','resolve'),
(10,'bug','view'),
(10,'build','create'),
(10,'build','delete'),
(10,'build','edit'),
(10,'build','view'),
(10,'company','browse'),
(10,'company','dynamic'),
(10,'company','index'),
(10,'company','view'),
(10,'doc','allLibs'),
(10,'doc','browse'),
(10,'doc','collect'),
(10,'doc','create'),
(10,'doc','edit'),
(10,'doc','index'),
(10,'doc','objectLibs'),
(10,'doc','showFiles'),
(10,'doc','tableContents'),
(10,'doc','view'),
(10,'execution','all'),
(10,'execution','browse'),
(10,'execution','bug'),
(10,'execution','build'),
(10,'execution','burn'),
(10,'execution','computeBurn'),
(10,'execution','doc'),
(10,'execution','dynamic'),
(10,'execution','grouptask'),
(10,'execution','importBug'),
(10,'execution','importtask'),
(10,'execution','index'),
(10,'execution','kanban'),
(10,'execution','story'),
(10,'execution','task'),
(10,'execution','team'),
(10,'execution','testtask'),
(10,'execution','tree'),
(10,'execution','view'),
(10,'file','download'),
(10,'file','edit'),
(10,'git','apiSync'),
(10,'git','cat'),
(10,'git','diff'),
(10,'group','browse'),
(10,'index','index'),
(10,'misc','ping'),
(10,'my','bug'),
(10,'my','calendar'),
(10,'my','changePassword'),
(10,'my','contribute'),
(10,'my','deleteContacts'),
(10,'my','doc'),
(10,'my','dynamic'),
(10,'my','editProfile'),
(10,'my','execution'),
(10,'my','index'),
(10,'my','manageContacts'),
(10,'my','preference'),
(10,'my','profile'),
(10,'my','project'),
(10,'my','score'),
(10,'my','story'),
(10,'my','task'),
(10,'my','team'),
(10,'my','testcase'),
(10,'my','testtask'),
(10,'my','todo'),
(10,'my','unbind'),
(10,'my','uploadAvatar'),
(10,'my','work'),
(10,'personnel','accessible'),
(10,'personnel','invest'),
(10,'personnel','whitelist'),
(10,'product','all'),
(10,'product','browse'),
(10,'product','build'),
(10,'product','dashboard'),
(10,'product','doc'),
(10,'product','dynamic'),
(10,'product','index'),
(10,'product','manageLine'),
(10,'product','roadmap'),
(10,'product','view'),
(10,'productplan','browse'),
(10,'productplan','view'),
(10,'program','browse'),
(10,'program','kanban'),
(10,'program','product'),
(10,'program','project'),
(10,'program','stakeholder'),
(10,'program','view'),
(10,'project','browse'),
(10,'project','bug'),
(10,'project','build'),
(10,'project','index'),
(10,'project','dynamic'),
(10,'project','kanban'),
(10,'project','team'),
(10,'project','testtask'),
(10,'project','view'),
(10,'projectbuild','browse'),
(10,'projectrelease','browse'),
(10,'projectrelease','view'),
(10,'projectstory','story'),
(10,'projectstory','track'),
(10,'projectstory','view'),
(10,'qa','index'),
(10,'release','browse'),
(10,'release','export'),
(10,'release','view'),
(10,'repo','blame'),
(10,'repo','browse'),
(10,'repo','diff'),
(10,'repo','download'),
(10,'repo','log'),
(10,'repo','revision'),
(10,'repo','showSyncCommit'),
(10,'repo','view'),
(10,'report','bugAssign'),
(10,'report','bugCreate'),
(10,'report','index'),
(10,'report','productSummary'),
(10,'report','projectDeviation'),
(10,'report','workload'),
(10,'search','buildForm'),
(10,'search','buildQuery'),
(10,'search','deleteQuery'),
(10,'search','index'),
(10,'search','saveQuery'),
(10,'search','select'),
(10,'stakeholder','browse'),
(10,'stakeholder','userIssue'),
(10,'stakeholder','view'),
(10,'stakeholder','viewIssue'),
(10,'story','bugs'),
(10,'story','cases'),
(10,'story','export'),
(10,'story','processStoryChange'),
(10,'story','report'),
(10,'story','tasks'),
(10,'story','track'),
(10,'story','view'),
(10,'svn','apiSync'),
(10,'svn','cat'),
(10,'svn','diff'),
(10,'task','activate'),
(10,'task','assignTo'),
(10,'task','batchAssignTo'),
(10,'task','batchChangeModule'),
(10,'task','batchClose'),
(10,'task','batchCreate'),
(10,'task','batchEdit'),
(10,'task','cancel'),
(10,'task','close'),
(10,'task','confirmStoryChange'),
(10,'task','create'),
(10,'task','deleteEstimate'),
(10,'task','edit'),
(10,'task','editEstimate'),
(10,'task','export'),
(10,'task','finish'),
(10,'task','pause'),
(10,'task','recordEstimate'),
(10,'task','report'),
(10,'task','restart'),
(10,'task','start'),
(10,'task','view'),
(10,'testcase','browse'),
(10,'testcase','bugs'),
(10,'testcase','export'),
(10,'testcase','groupCase'),
(10,'testcase','view'),
(10,'testreport','browse'),
(10,'testreport','view'),
(10,'testsuite','browse'),
(10,'testsuite','index'),
(10,'testsuite','view'),
(10,'testtask','browse'),
(10,'testtask','cases'),
(10,'testtask','create'),
(10,'testtask','edit'),
(10,'testtask','groupCase'),
(10,'testtask','results'),
(10,'testtask','view'),
(10,'todo','activate'),
(10,'todo','assignTo'),
(10,'todo','batchClose'),
(10,'todo','batchCreate'),
(10,'todo','batchEdit'),
(10,'todo','batchFinish'),
(10,'todo','close'),
(10,'todo','create'),
(10,'todo','delete'),
(10,'todo','edit'),
(10,'todo','export'),
(10,'todo','finish'),
(10,'todo','import2Today'),
(10,'todo','start'),
(10,'todo','view'),
(10,'user','bug'),
(10,'user','cropAvatar'),
(10,'user','dynamic'),
(10,'user','execution'),
(10,'user','issue'),
(10,'user','profile'),
(10,'user','risk'),
(10,'user','story'),
(10,'user','task'),
(10,'user','testCase'),
(10,'user','testTask'),
(10,'user','todo'),
(10,'user','view'),
(11,'action','comment'),
(11,'action','editComment'),
(11,'automation','browse'),
(11,'bug','activate'),
(11,'bug','assignTo'),
(11,'bug','batchActivate'),
(11,'bug','batchAssignTo'),
(11,'bug','batchChangeBranch'),
(11,'bug','batchChangeModule'),
(11,'bug','batchClose'),
(11,'bug','batchConfirm'),
(11,'bug','batchCreate'),
(11,'bug','batchEdit'),
(11,'bug','batchResolve'),
(11,'bug','browse'),
(11,'bug','index'),
(11,'bug','close'),
(11,'bug','confirmBug'),
(11,'bug','confirmStoryChange'),
(11,'bug','create'),
(11,'bug','edit'),
(11,'bug','export'),
(11,'bug','linkBugs'),
(11,'bug','report'),
(11,'bug','resolve'),
(11,'bug','view'),
(11,'build','create'),
(11,'build','delete'),
(11,'build','edit'),
(11,'build','view'),
(11,'company','browse'),
(11,'company','dynamic'),
(11,'company','index'),
(11,'company','view'),
(11,'doc','allLibs'),
(11,'doc','browse'),
(11,'doc','collect'),
(11,'doc','index'),
(11,'doc','objectLibs'),
(11,'doc','showFiles'),
(11,'doc','tableContents'),
(11,'doc','view'),
(11,'execution','all'),
(11,'execution','browse'),
(11,'execution','bug'),
(11,'execution','build'),
(11,'execution','burn'),
(11,'execution','doc'),
(11,'execution','dynamic'),
(11,'execution','executionkanban'),
(11,'execution','grouptask'),
(11,'execution','index'),
(11,'execution','kanban'),
(11,'execution','story'),
(11,'execution','task'),
(11,'execution','team'),
(11,'execution','testcase'),
(11,'execution','testreport'),
(11,'execution','testtask'),
(11,'execution','tree'),
(11,'execution','treestory'),
(11,'execution','treetask'),
(11,'execution','view'),
(11,'execution','whitelist'),
(11,'file','download'),
(11,'file','edit'),
(11,'git','apiSync'),
(11,'git','cat'),
(11,'git','diff'),
(11,'group','browse'),
(11,'index','index'),
(11,'misc','ping'),
(11,'my','bug'),
(11,'my','calendar'),
(11,'my','changePassword'),
(11,'my','contribute'),
(11,'my','deleteContacts'),
(11,'my','doc'),
(11,'my','dynamic'),
(11,'my','editProfile'),
(11,'my','execution'),
(11,'my','index'),
(11,'my','manageContacts'),
(11,'my','preference'),
(11,'my','profile'),
(11,'my','project'),
(11,'my','score'),
(11,'my','story'),
(11,'my','task'),
(11,'my','team'),
(11,'my','testcase'),
(11,'my','testtask'),
(11,'my','todo'),
(11,'my','uploadAvatar'),
(11,'my','work'),
(11,'personnel','accessible'),
(11,'personnel','invest'),
(11,'personnel','whitelist'),
(11,'product','all'),
(11,'product','browse'),
(11,'product','build'),
(11,'product','dashboard'),
(11,'product','doc'),
(11,'product','dynamic'),
(11,'product','index'),
(11,'product','kanban'),
(11,'product','project'),
(11,'product','roadmap'),
(11,'product','view'),
(11,'product','whitelist'),
(11,'productplan','browse'),
(11,'productplan','view'),
(11,'program','browse'),
(11,'program','kanban'),
(11,'program','product'),
(11,'program','project'),
(11,'program','stakeholder'),
(11,'program','view'),
(11,'project','browse'),
(11,'project','bug'),
(11,'project','build'),
(11,'project','dynamic'),
(11,'project','execution'),
(11,'project','group'),
(11,'project','index'),
(11,'project','kanban'),
(11,'project','programTitle'),
(11,'project','qa'),
(11,'project','team'),
(11,'project','testcase'),
(11,'project','testreport'),
(11,'project','testtask'),
(11,'project','view'),
(11,'project','whitelist'),
(11,'projectbuild','browse'),
(11,'projectrelease','browse'),
(11,'projectrelease','export'),
(11,'projectrelease','view'),
(11,'projectstory','story'),
(11,'projectstory','track'),
(11,'projectstory','view'),
(11,'qa','index'),
(11,'release','browse'),
(11,'release','export'),
(11,'release','view'),
(11,'repo','browse'),
(11,'repo','diff'),
(11,'repo','download'),
(11,'repo','log'),
(11,'repo','revision'),
(11,'repo','view'),
(11,'report','bugAssign'),
(11,'report','bugCreate'),
(11,'report','index'),
(11,'report','productSummary'),
(11,'report','projectDeviation'),
(11,'report','workload'),
(11,'search','buildForm'),
(11,'search','buildQuery'),
(11,'search','deleteQuery'),
(11,'search','index'),
(11,'search','saveQuery'),
(11,'search','select'),
(11,'stakeholder','browse'),
(11,'stakeholder','communicate'),
(11,'stakeholder','expect'),
(11,'stakeholder','expectation'),
(11,'stakeholder','issue'),
(11,'stakeholder','userIssue'),
(11,'stakeholder','view'),
(11,'stakeholder','viewExpect'),
(11,'stakeholder','viewIssue'),
(11,'story','bugs'),
(11,'story','cases'),
(11,'story','export'),
(11,'story','report'),
(11,'story','tasks'),
(11,'story','track'),
(11,'story','view'),
(11,'story','zeroCase'),
(11,'svn','apiSync'),
(11,'svn','cat'),
(11,'svn','diff'),
(11,'task','activate'),
(11,'task','assignTo'),
(11,'task','batchAssignTo'),
(11,'task','batchCancel'),
(11,'task','batchChangeModule'),
(11,'task','batchClose'),
(11,'task','batchCreate'),
(11,'task','batchEdit'),
(11,'task','cancel'),
(11,'task','close'),
(11,'task','confirmStoryChange'),
(11,'task','create'),
(11,'task','deleteEstimate'),
(11,'task','edit'),
(11,'task','editEstimate'),
(11,'task','export'),
(11,'task','finish'),
(11,'task','pause'),
(11,'task','recordEstimate'),
(11,'task','report'),
(11,'task','restart'),
(11,'task','start'),
(11,'task','view'),
(11,'testcase','browse'),
(11,'testcase','bugs'),
(11,'testcase','export'),
(11,'testcase','groupCase'),
(11,'testcase','index'),
(11,'testcase','view'),
(11,'testreport','browse'),
(11,'testreport','view'),
(11,'testsuite','browse'),
(11,'testsuite','index'),
(11,'testsuite','view'),
(11,'testtask','browse'),
(11,'testtask','cases'),
(11,'testtask','groupCase'),
(11,'testtask','index'),
(11,'testtask','report'),
(11,'testtask','results'),
(11,'testtask','view'),
(11,'todo','activate'),
(11,'todo','assignTo'),
(11,'todo','batchClose'),
(11,'todo','batchCreate'),
(11,'todo','batchEdit'),
(11,'todo','batchFinish'),
(11,'todo','close'),
(11,'todo','create'),
(11,'todo','delete'),
(11,'todo','edit'),
(11,'todo','export'),
(11,'todo','finish'),
(11,'todo','import2Today'),
(11,'todo','start'),
(11,'todo','view'),
(11,'user','bug'),
(11,'user','cropAvatar'),
(11,'user','dynamic'),
(11,'user','execution'),
(11,'user','issue'),
(11,'user','profile'),
(11,'user','project'),
(11,'user','risk'),
(11,'user','story'),
(11,'user','task'),
(11,'user','testCase'),
(11,'user','testTask'),
(11,'user','todo'),
(11,'user','view'),
(12,'my','limited');

REPLACE INTO `zt_lang` (`lang`, `module`, `section`, `key`, `value`, `system`) VALUES
('zh-cn', 'custom', 'URSRList', '1', '{\"SRName\":\"\\u8f6f\\u4ef6\\u9700\\u6c42\",\"URName\":\"\\u7528\\u6237\\u9700\\u6c42\"}', '1'),('zh-cn', 'custom', 'URSRList', '2', '{\"SRName\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"URName\":\"\\u7528\\u6237\\u9700\\u6c42\"}', '1'),
('zh-cn', 'custom', 'URSRList', '3', '{\"SRName\":\"\\u8f6f\\u9700\",\"URName\":\"\\u7528\\u9700\"}', '1'),('zh-cn', 'custom', 'URSRList', '4', '{\"SRName\":\"\\u6545\\u4e8b\",\"URName\":\"\\u53f2\\u8bd7\"}', '1'),
('zh-cn', 'custom', 'URSRList', '5', '{\"SRName\":\"\\u9700\\u6c42\",\"URName\":\"\\u7528\\u6237\\u9700\\u6c42\"}', '1'),
('en', 'custom', 'URSRList', '1', '{\"SRName\":\"Story\",\"URName\":\"Epic\"}', '0'),
('en', 'custom', 'URSRList', '2', '{\"SRName\":\"Software Requirement\",\"URName\":\"User Requirement\"}', '0');

INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'custom', '', 'hourPoint',   '0');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'common', '', 'CRProduct',   '1');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'common', '', 'CRExecution', '1');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'custom', '', 'URSR', '2');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'common', 'global', 'mode', 'new');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'project', '', 'unitList', 'CNY,USD');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'project', '', 'defaultCurrency', 'CNY');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'story', '', 'reviewRules', 'allpass');
-- DROP TABLE IF EXISTS `zt_im_chat`;
CREATE TABLE IF NOT EXISTS `zt_im_chat` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gid` char(40) NOT NULL DEFAULT '',
  `name` varchar(60) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT 'group',
  `admins` varchar(255) NOT NULL DEFAULT '',
  `committers` varchar(255) NOT NULL DEFAULT '',
  `subject` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `public` enum('0', '1') NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastActiveTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastMessage` int(11) unsigned NOT NULL DEFAULT 0,
  `dismissDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `pinnedMessages` text NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `gid` (`gid`),
  KEY `name` (`name`),
  KEY `type` (`type`),
  KEY `public` (`public`),
  KEY `createdBy` (`createdBy`),
  KEY `editedBy` (`editedBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_chatuser`;
CREATE TABLE IF NOT EXISTS `zt_im_chatuser` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `cgid` char(40) NOT NULL DEFAULT '',
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `order` smallint(5) NOT NULL DEFAULT 0,
  `star` enum('0', '1') NOT NULL DEFAULT '0',
  `hide` enum('0', '1') NOT NULL DEFAULT '0',
  `mute` enum('0', '1') NOT NULL DEFAULT '0',
  `freeze` enum('0', '1') NOT NULL DEFAULT '0',
  `join` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `quit` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `category` varchar(40) NOT NULL DEFAULT '',
  `lastReadMessage` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `cgid` (`cgid`),
  KEY `user` (`user`),
  KEY `order` (`order`),
  KEY `star` (`star`),
  KEY `hide` (`hide`),
  UNIQUE KEY `chatuser` (`cgid`, `user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_client`;
CREATE TABLE IF NOT EXISTS `zt_im_client` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` char(30) NOT NULL DEFAULT '',
  `desc` varchar(100) NOT NULL DEFAULT '',
  `changeLog` text NOT NULL,
  `strategy` varchar(10) NOT NULL DEFAULT '',
  `downloads` text NOT NULL,
  `createdDate` datetime NOT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `status` enum('released','wait') NOT NULL DEFAULT 'wait',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_message`;
CREATE TABLE IF NOT EXISTS `zt_im_message` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `gid` char(40) NOT NULL DEFAULT '',
  `cgid` char(40) NOT NULL DEFAULT '',
  `user` varchar(30) NOT NULL DEFAULT '',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `type` enum('normal', 'broadcast', 'notify', 'bulletin') NOT NULL DEFAULT 'normal',
  `content` text NOT NULL DEFAULT '',
  `contentType` enum('text', 'plain', 'emotion', 'image', 'file', 'object', 'code') NOT NULL DEFAULT 'text',
  `data` text NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mgid` (`gid`),
  KEY `mcgid` (`cgid`),
  KEY `muser` (`user`),
  KEY `mtype` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_message_backup`;
CREATE TABLE IF NOT EXISTS `zt_im_message_backup` (
  `id` int(11) unsigned NOT NULL,
  `gid` char(40) NOT NULL DEFAULT '',
  `cgid` char(40) NOT NULL DEFAULT '',
  `user` varchar(30) NOT NULL DEFAULT '',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `type` enum('normal', 'broadcast', 'notify') NOT NULL DEFAULT 'normal',
  `content` text NOT NULL DEFAULT '',
  `contentType` enum('text', 'plain', 'emotion', 'image', 'file', 'object', 'code') NOT NULL DEFAULT 'text',
  `data` text NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_message_index`;
CREATE TABLE IF NOT EXISTS `zt_im_message_index` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `tableName` char(64) NOT NULL,
  `start` int(11) unsigned NOT NULL,
  `end` int(11) unsigned NOT NULL,
  `startDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `endDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `chats` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `tableName` (`tableName`),
  KEY `start` (`start`),
  KEY `end` (`end`),
  KEY `startDate` (`startDate`),
  KEY `endDate` (`endDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_chat_message_index`;
CREATE TABLE IF NOT EXISTS `zt_im_chat_message_index` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gid` char(40) NOT NULL,
  `tableName` char(64) NOT NULL,
  `start` int(11) unsigned NOT NULL,
  `end` int(11) unsigned NOT NULL,
  `startDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `endDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `count` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `chattable` (`gid`,`tableName`),
  KEY `start` (`start`),
  KEY `end` (`end`),
  KEY `startDate` (`startDate`),
  KEY `endDate` (`endDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_messagestatus`;
CREATE TABLE IF NOT EXISTS `zt_im_messagestatus` (
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `message` int(11) unsigned NOT NULL,
  `status` enum('waiting','sent','readed','deleted') NOT NULL DEFAULT 'waiting',
  UNIQUE KEY `user` (`user`,`message`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_queue`;
CREATE TABLE IF NOT EXISTS `zt_im_queue` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `type` char(30) NOT NULL,
  `content` text NOT NULL,
  `addDate` datetime NOT NULL,
  `processDate` datetime NOT NULL,
  `result` text NOT NULL,
  `status` char(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_conference`;
CREATE TABLE IF NOT EXISTS `zt_im_conference` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `rid` char(24) NOT NULL DEFAULT '',
  `cgid` char(40) NOT NULL DEFAULT '',
  `status` enum('closed','open') NOT NULL DEFAULT 'closed',
  `participants` text NOT NULL,
  `invitee` text NOT NULL,
  `openedBy` mediumint(8) NOT NULL DEFAULT 0,
  `openedDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_conferenceaction`;
CREATE TABLE IF NOT EXISTS `zt_im_conferenceaction` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `rid` char(24) NOT NULL DEFAULT '',
  `type` enum('create','invite','join','leave','close') NOT NULL DEFAULT 'create',
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `device` char(40) NOT NULL DEFAULT 'default',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_userdevice`;
CREATE TABLE IF NOT EXISTS `zt_im_userdevice` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `device` char(40) NOT NULL DEFAULT 'default',
  `deviceID` char(40) NOT NULL DEFAULT '',
  `token` char(64) NOT NULL DEFAULT '',
  `validUntil` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastLogin` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastLogout` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `user` (`user`),
  KEY `lastLogin` (`lastLogin`),
  KEY `lastLogout` (`lastLogout`),
  UNIQUE KEY `userdevice` (`user`, `device`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

ALTER TABLE `zt_file` CHANGE `pathname` `pathname` char(100) NOT NULL;
ALTER TABLE `zt_user` ADD `clientStatus` enum('online', 'away', 'busy', 'offline', 'meeting') NOT NULL DEFAULT 'offline';
ALTER TABLE `zt_user` ADD `clientLang` varchar(10) NOT NULL DEFAULT 'zh-cn';
ALTER TABLE `zt_user` ADD `pinyin` varchar(255) NOT NULL DEFAULT '' AFTER `realname`;
