'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  // General
  data: _propTypes2.default.any,
  loading: _propTypes2.default.bool,
  showPagination: _propTypes2.default.bool,
  showPaginationTop: _propTypes2.default.bool,
  showPaginationBottom: _propTypes2.default.bool,
  showPageSizeOptions: _propTypes2.default.bool,
  pageSizeOptions: _propTypes2.default.array,
  defaultPageSize: _propTypes2.default.number,
  showPageJump: _propTypes2.default.bool,
  collapseOnSortingChange: _propTypes2.default.bool,
  collapseOnPageChange: _propTypes2.default.bool,
  collapseOnDataChange: _propTypes2.default.bool,
  freezeWhenExpanded: _propTypes2.default.bool,
  sortable: _propTypes2.default.bool,
  resizable: _propTypes2.default.bool,
  filterable: _propTypes2.default.bool,
  defaultSortDesc: _propTypes2.default.bool,
  defaultSorted: _propTypes2.default.array,
  defaultFiltered: _propTypes2.default.array,
  defaultResized: _propTypes2.default.array,
  defaultExpanded: _propTypes2.default.object,
  defaultFilterMethod: _propTypes2.default.func,
  defaultSortMethod: _propTypes2.default.func,

  // Controlled State Callbacks
  onPageChange: _propTypes2.default.func,
  onPageSizeChange: _propTypes2.default.func,
  onSortedChange: _propTypes2.default.func,
  onFilteredChange: _propTypes2.default.func,
  onResizedChange: _propTypes2.default.func,
  onExpandedChange: _propTypes2.default.func,

  // Pivoting
  pivotBy: _propTypes2.default.array,

  // Key Constants
  pivotValKey: _propTypes2.default.string,
  pivotIDKey: _propTypes2.default.string,
  subRowsKey: _propTypes2.default.string,
  aggregatedKey: _propTypes2.default.string,
  nestingLevelKey: _propTypes2.default.string,
  originalKey: _propTypes2.default.string,
  indexKey: _propTypes2.default.string,
  groupedByPivotKey: _propTypes2.default.string,

  // Server-side Callbacks
  onFetchData: _propTypes2.default.func,

  // Classes
  className: _propTypes2.default.string,
  style: _propTypes2.default.object,

  // Component decorators
  getProps: _propTypes2.default.func,
  getTableProps: _propTypes2.default.func,
  getTheadGroupProps: _propTypes2.default.func,
  getTheadGroupTrProps: _propTypes2.default.func,
  getTheadGroupThProps: _propTypes2.default.func,
  getTheadProps: _propTypes2.default.func,
  getTheadTrProps: _propTypes2.default.func,
  getTheadThProps: _propTypes2.default.func,
  getTheadFilterProps: _propTypes2.default.func,
  getTheadFilterTrProps: _propTypes2.default.func,
  getTheadFilterThProps: _propTypes2.default.func,
  getTbodyProps: _propTypes2.default.func,
  getTrGroupProps: _propTypes2.default.func,
  getTrProps: _propTypes2.default.func,
  getTdProps: _propTypes2.default.func,
  getTfootProps: _propTypes2.default.func,
  getTfootTrProps: _propTypes2.default.func,
  getTfootTdProps: _propTypes2.default.func,
  getPaginationProps: _propTypes2.default.func,
  getLoadingProps: _propTypes2.default.func,
  getNoDataProps: _propTypes2.default.func,
  getResizerProps: _propTypes2.default.func,

  // Global Column Defaults
  columns: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    // Renderers
    Cell: _propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.string, _propTypes2.default.func]),
    Header: _propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.string, _propTypes2.default.func]),
    Footer: _propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.string, _propTypes2.default.func]),
    Aggregated: _propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.string, _propTypes2.default.func]),
    Pivot: _propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.string, _propTypes2.default.func]),
    PivotValue: _propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.string, _propTypes2.default.func]),
    Expander: _propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.string, _propTypes2.default.func]),
    Filter: _propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.func]),

    // All Columns
    sortable: _propTypes2.default.bool, // use table default
    resizable: _propTypes2.default.bool, // use table default
    filterable: _propTypes2.default.bool, // use table default
    show: _propTypes2.default.bool,
    minWidth: _propTypes2.default.number,
    minResizeWidth: _propTypes2.default.number,

    // Cells only
    className: _propTypes2.default.string,
    style: _propTypes2.default.object,
    getProps: _propTypes2.default.func,

    // Pivot only
    aggregate: _propTypes2.default.func,

    // Headers only
    headerClassName: _propTypes2.default.string,
    headerStyle: _propTypes2.default.object,
    getHeaderProps: _propTypes2.default.func,

    // Footers only
    footerClassName: _propTypes2.default.string,
    footerStyle: _propTypes2.default.object,
    getFooterProps: _propTypes2.default.func,
    filterMethod: _propTypes2.default.func,
    filterAll: _propTypes2.default.bool,
    sortMethod: _propTypes2.default.func
  })),

  // Global Expander Column Defaults
  expanderDefaults: _propTypes2.default.shape({
    sortable: _propTypes2.default.bool,
    resizable: _propTypes2.default.bool,
    filterable: _propTypes2.default.bool,
    width: _propTypes2.default.number
  }),

  pivotDefaults: _propTypes2.default.object,

  // Text
  previousText: _propTypes2.default.node,
  nextText: _propTypes2.default.node,
  loadingText: _propTypes2.default.node,
  noDataText: _propTypes2.default.node,
  pageText: _propTypes2.default.node,
  ofText: _propTypes2.default.node,
  rowsText: _propTypes2.default.node,
  pageJumpText: _propTypes2.default.node,
  rowsSelectorText: _propTypes2.default.node,

  // Components
  TableComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  TheadComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  TbodyComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  TrGroupComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  TrComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  ThComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  TdComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  TfootComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  FilterComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  ExpanderComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  PivotValueComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  AggregatedComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  // this is a computed default generated using
  PivotComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  // the ExpanderComponent and PivotValueComponent at run-time in methods.js
  PaginationComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  PreviousComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  NextComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  LoadingComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  NoDataComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  ResizerComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  PadRowComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element])
};
//# sourceMappingURL=data:application/json;base64,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