'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _utils = require('./utils');

var _utils2 = _interopRequireDefault(_utils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

exports.default = function (Base) {
  return function (_Base) {
    _inherits(_class, _Base);

    function _class() {
      _classCallCheck(this, _class);

      return _possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).apply(this, arguments));
    }

    _createClass(_class, [{
      key: 'getResolvedState',
      value: function getResolvedState(props, state) {
        var resolvedState = _extends({}, _utils2.default.compactObject(this.state), _utils2.default.compactObject(this.props), _utils2.default.compactObject(state), _utils2.default.compactObject(props));
        return resolvedState;
      }
    }, {
      key: 'getDataModel',
      value: function getDataModel(newState, dataChanged) {
        var _this2 = this;

        var columns = newState.columns,
            _newState$pivotBy = newState.pivotBy,
            pivotBy = _newState$pivotBy === undefined ? [] : _newState$pivotBy,
            data = newState.data,
            resolveData = newState.resolveData,
            pivotIDKey = newState.pivotIDKey,
            pivotValKey = newState.pivotValKey,
            subRowsKey = newState.subRowsKey,
            aggregatedKey = newState.aggregatedKey,
            nestingLevelKey = newState.nestingLevelKey,
            originalKey = newState.originalKey,
            indexKey = newState.indexKey,
            groupedByPivotKey = newState.groupedByPivotKey,
            SubComponent = newState.SubComponent;

        // Determine if there are Header Groups

        var hasHeaderGroups = columns.some(function (column) {
          return column.columns;
        });

        // Find the expander column which could be deep in tree of columns
        var allColumns = _utils2.default.iterTree(columns, 'columns');
        var expanderColumn = _utils2.default.getFirstDefined(allColumns);

        // If we have SubComponent's we need to make sure we have an expander column
        var hasSubComponentAndNoExpanderColumn = SubComponent && !expanderColumn;
        var columnsWithExpander = hasSubComponentAndNoExpanderColumn ? [{ expander: true }].concat(_toConsumableArray(columns)) : [].concat(_toConsumableArray(columns));

        var makeDecoratedColumn = function makeDecoratedColumn(column, parentColumn) {
          var dcol = void 0;
          if (column.expander) {
            dcol = _extends({}, _this2.props.column, _this2.props.expanderDefaults, column);
          } else {
            dcol = _extends({}, _this2.props.column, _this2.props.column, column);
          }

          // Ensure minWidth is not greater than maxWidth if set
          if (dcol.maxWidth < dcol.minWidth) {
            dcol.minWidth = dcol.maxWidth;
          }

          if (parentColumn) {
            dcol.parentColumn = parentColumn;
          }

          // First check for string accessor
          if (typeof dcol.accessor === 'string') {
            dcol.id = dcol.id || dcol.accessor;
            var accessorString = dcol.accessor;
            dcol.accessor = function (row) {
              return _utils2.default.get(row, accessorString);
            };
            return dcol;
          }

          // Fall back to functional accessor (but require an ID)
          if (dcol.accessor && !dcol.id) {
            console.warn(dcol);
            throw new Error('A column id is required if using a non-string accessor for column above.');
          }

          // Fall back to an undefined accessor
          if (!dcol.accessor) {
            dcol.accessor = function () {
              return undefined;
            };
          }

          return dcol;
        };

        var allDecoratedColumns = [];

        // Decorate the columns
        var decorateAndAddToAll = function decorateAndAddToAll(columns, parentColumn) {
          return columns.map(function (column) {
            var decoratedColumn = makeDecoratedColumn(column, parentColumn);
            if (column.columns) {
              decoratedColumn.columns = decorateAndAddToAll(column.columns, column);
            }

            allDecoratedColumns.push(decoratedColumn);
            return decoratedColumn;
          });
        };

        var decoratedColumns = decorateAndAddToAll(columnsWithExpander);
        var mapVisibleColumns = function mapVisibleColumns(columns) {
          return columns.map(function (column) {
            if (column.columns) {
              var visibleSubColumns = column.columns.filter(function (d) {
                return pivotBy.indexOf(d.id) > -1 ? false : _utils2.default.getFirstDefined(d.show, true);
              });
              return _extends({}, column, {
                columns: mapVisibleColumns(visibleSubColumns)
              });
            }
            return column;
          });
        };

        var filterVisibleColumns = function filterVisibleColumns(columns) {
          return columns.filter(function (column) {
            return column.columns ? column.columns.length : pivotBy.indexOf(column.id) > -1 ? false : _utils2.default.getFirstDefined(column.show, true);
          });
        };

        // Build the full array of visible columns - this is an array that contains all columns that
        // are not hidden via pivoting
        var allVisibleColumns = filterVisibleColumns(mapVisibleColumns(decoratedColumns.slice()));

        // Find any custom pivot location
        var pivotIndex = allVisibleColumns.findIndex(function (col) {
          return col.pivot;
        });

        // Handle Pivot Columns
        if (pivotBy.length) {
          // Retrieve the pivot columns in the correct pivot order
          var pivotColumns = [];
          pivotBy.forEach(function (pivotID) {
            var found = allDecoratedColumns.find(function (d) {
              return d.id === pivotID;
            });
            if (found) {
              pivotColumns.push(found);
            }
          });

          var PivotParentColumn = pivotColumns.reduce(function (prev, current) {
            return prev && prev === current.parentColumn && current.parentColumn;
          }, pivotColumns[0].parentColumn);

          var PivotGroupHeader = hasHeaderGroups && PivotParentColumn.Header;
          PivotGroupHeader = PivotGroupHeader || function () {
            return _react2.default.createElement(
              'strong',
              null,
              'Pivoted'
            );
          };

          var pivotColumnGroup = {
            Header: PivotGroupHeader,
            columns: pivotColumns.map(function (col) {
              return _extends({}, _this2.props.pivotDefaults, col, {
                pivoted: true
              });
            })

            // Place the pivotColumns back into the visibleColumns
          };if (pivotIndex >= 0) {
            pivotColumnGroup = _extends({}, allVisibleColumns[pivotIndex], pivotColumnGroup);
            allVisibleColumns.splice(pivotIndex, 1, pivotColumnGroup);
          } else {
            allVisibleColumns.unshift(pivotColumnGroup);
          }
        }

        // Build Visible Columns and Header Groups
        var allColumnHeaders = [];

        var addHeader = function addHeader(column) {
          var level = 0;

          // If this column has children, push them first and add this column to the next level
          if (column.columns) {
            var childLevels = column.columns.map(addHeader);
            level = Math.max.apply(Math, _toConsumableArray(childLevels)) + 1;
          }

          // Add spans above columns without parents (orphans) to fill the space above them
          if (allColumnHeaders.length <= level) allColumnHeaders.push([]);
          if (level > 0) {
            // The spans need to contain the shifted headers as children. This finds all of the
            // columns in the lower level between the first child of this column and the last child
            // of the preceding column (if there is one)
            var lowerLevel = allColumnHeaders[level - 1];
            var precedingColumn = _utils2.default.last(allColumnHeaders[level]);

            var indexOfFirstChildInLowerLevel = lowerLevel.indexOf(column.columns[0]);
            var indexAfterLastChildInPrecedingColumn = precedingColumn ? lowerLevel.indexOf(_utils2.default.last(precedingColumn.columns)) + 1 : 0;

            // If there are ophans, add a span above them
            var orphans = lowerLevel.slice(indexAfterLastChildInPrecedingColumn, indexOfFirstChildInLowerLevel);

            if (orphans.length) {
              allColumnHeaders[level].push(_extends({}, _this2.props.column, {
                columns: orphans
              }));
            }
          }

          allColumnHeaders[level].push(column);

          return level;
        };

        allVisibleColumns.forEach(addHeader);

        // visibleColumns is an array containing column definitions for the bottom row of TH elements
        var visibleColumns = allColumnHeaders.shift();
        var headerGroups = allColumnHeaders.reverse();

        // Access the data
        var accessRow = function accessRow(d, i) {
          var _row;

          var level = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

          var row = (_row = {}, _defineProperty(_row, originalKey, d), _defineProperty(_row, indexKey, i), _defineProperty(_row, subRowsKey, d[subRowsKey]), _defineProperty(_row, nestingLevelKey, level), _row);
          allDecoratedColumns.forEach(function (column) {
            if (column.expander) return;
            row[column.id] = column.accessor(d);
          });
          if (row[subRowsKey]) {
            row[subRowsKey] = row[subRowsKey].map(function (d, i) {
              return accessRow(d, i, level + 1);
            });
          }
          return row;
        };

        // // If the data hasn't changed, just use the cached data
        var resolvedData = this.resolvedData;
        // If the data has changed, run the data resolver and cache the result
        if (!this.resolvedData || dataChanged) {
          resolvedData = resolveData(data);
          this.resolvedData = resolvedData;
        }
        // Use the resolved data
        resolvedData = resolvedData.map(function (d, i) {
          return accessRow(d, i);
        });

        // TODO: Make it possible to fabricate nested rows without pivoting
        var aggregatingColumns = visibleColumns.filter(function (d) {
          return !d.expander && d.aggregate;
        });

        // If pivoting, recursively group the data
        var aggregate = function aggregate(rows) {
          var aggregationValues = {};
          aggregatingColumns.forEach(function (column) {
            var values = rows.map(function (d) {
              return d[column.id];
            });
            aggregationValues[column.id] = column.aggregate(values, rows);
          });
          return aggregationValues;
        };
        if (pivotBy.length) {
          var groupRecursively = function groupRecursively(rows, keys) {
            var i = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

            // This is the last level, just return the rows
            if (i === keys.length) {
              return rows;
            }
            // Group the rows together for this level
            var groupedRows = Object.entries(_utils2.default.groupBy(rows, keys[i])).map(function (_ref) {
              var _ref3;

              var _ref2 = _slicedToArray(_ref, 2),
                  key = _ref2[0],
                  value = _ref2[1];

              return _ref3 = {}, _defineProperty(_ref3, pivotIDKey, keys[i]), _defineProperty(_ref3, pivotValKey, key), _defineProperty(_ref3, keys[i], key), _defineProperty(_ref3, subRowsKey, value), _defineProperty(_ref3, nestingLevelKey, i), _defineProperty(_ref3, groupedByPivotKey, true), _ref3;
            });
            // Recurse into the subRows
            groupedRows = groupedRows.map(function (rowGroup) {
              var _extends2;

              var subRows = groupRecursively(rowGroup[subRowsKey], keys, i + 1);
              return _extends({}, rowGroup, (_extends2 = {}, _defineProperty(_extends2, subRowsKey, subRows), _defineProperty(_extends2, aggregatedKey, true), _extends2), aggregate(subRows));
            });
            return groupedRows;
          };
          resolvedData = groupRecursively(resolvedData, pivotBy);
        }

        return _extends({}, newState, {
          resolvedData: resolvedData,
          visibleColumns: visibleColumns,
          headerGroups: headerGroups,
          allDecoratedColumns: allDecoratedColumns,
          hasHeaderGroups: hasHeaderGroups
        });
      }
    }, {
      key: 'getSortedData',
      value: function getSortedData(resolvedState) {
        var manual = resolvedState.manual,
            sorted = resolvedState.sorted,
            filtered = resolvedState.filtered,
            defaultFilterMethod = resolvedState.defaultFilterMethod,
            resolvedData = resolvedState.resolvedData,
            allDecoratedColumns = resolvedState.allDecoratedColumns;


        var sortMethodsByColumnID = {};

        allDecoratedColumns.filter(function (col) {
          return col.sortMethod;
        }).forEach(function (col) {
          sortMethodsByColumnID[col.id] = col.sortMethod;
        });

        // Resolve the data from either manual data or sorted data
        return {
          sortedData: manual ? resolvedData : this.sortData(this.filterData(resolvedData, filtered, defaultFilterMethod, allDecoratedColumns), sorted, sortMethodsByColumnID)
        };
      }
    }, {
      key: 'fireFetchData',
      value: function fireFetchData() {
        // determine the current state, preferring certain state values over props
        var currentState = _extends({}, this.getResolvedState(), {
          page: this.getStateOrProp('page'),
          pageSize: this.getStateOrProp('pageSize'),
          filter: this.getStateOrProp('filter')
        });

        this.props.onFetchData(currentState, this);
      }
    }, {
      key: 'getPropOrState',
      value: function getPropOrState(key) {
        return _utils2.default.getFirstDefined(this.props[key], this.state[key]);
      }
    }, {
      key: 'getStateOrProp',
      value: function getStateOrProp(key) {
        return _utils2.default.getFirstDefined(this.state[key], this.props[key]);
      }
    }, {
      key: 'filterData',
      value: function filterData(data, filtered, defaultFilterMethod, visibleColumns) {
        var _this3 = this;

        var filteredData = data;

        if (filtered.length) {
          filteredData = filtered.reduce(function (filteredSoFar, nextFilter) {
            var column = visibleColumns.find(function (x) {
              return x.id === nextFilter.id;
            });

            // Don't filter hidden columns or columns that have had their filters disabled
            if (!column || column.filterable === false) {
              return filteredSoFar;
            }

            var filterMethod = column.filterMethod || defaultFilterMethod;

            // If 'filterAll' is set to true, pass the entire dataset to the filter method
            if (column.filterAll) {
              return filterMethod(nextFilter, filteredSoFar, column);
            }
            return filteredSoFar.filter(function (row) {
              return filterMethod(nextFilter, row, column);
            });
          }, filteredData);

          // Apply the filter to the subrows if we are pivoting, and then
          // filter any rows without subcolumns because it would be strange to show
          filteredData = filteredData.map(function (row) {
            if (!row[_this3.props.subRowsKey]) {
              return row;
            }
            return _extends({}, row, _defineProperty({}, _this3.props.subRowsKey, _this3.filterData(row[_this3.props.subRowsKey], filtered, defaultFilterMethod, visibleColumns)));
          }).filter(function (row) {
            if (!row[_this3.props.subRowsKey]) {
              return true;
            }
            return row[_this3.props.subRowsKey].length > 0;
          });
        }

        return filteredData;
      }
    }, {
      key: 'sortData',
      value: function sortData(data, sorted) {
        var _this4 = this;

        var sortMethodsByColumnID = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

        if (!sorted.length) {
          return data;
        }

        var sortedData = (this.props.orderByMethod || _utils2.default.orderBy)(data, sorted.map(function (sort) {
          // Support custom sorting methods for each column
          if (sortMethodsByColumnID[sort.id]) {
            return function (a, b) {
              return sortMethodsByColumnID[sort.id](a[sort.id], b[sort.id], sort.desc);
            };
          }
          return function (a, b) {
            return _this4.props.defaultSortMethod(a[sort.id], b[sort.id], sort.desc);
          };
        }), sorted.map(function (d) {
          return !d.desc;
        }), this.props.indexKey);

        sortedData.forEach(function (row) {
          if (!row[_this4.props.subRowsKey]) {
            return;
          }
          row[_this4.props.subRowsKey] = _this4.sortData(row[_this4.props.subRowsKey], sorted, sortMethodsByColumnID);
        });

        return sortedData;
      }
    }, {
      key: 'getMinRows',
      value: function getMinRows() {
        return _utils2.default.getFirstDefined(this.props.minRows, this.getStateOrProp('pageSize'));
      }

      // User actions

    }, {
      key: 'onPageChange',
      value: function onPageChange(page) {
        var _props = this.props,
            onPageChange = _props.onPageChange,
            collapseOnPageChange = _props.collapseOnPageChange;


        var newState = { page: page };
        if (collapseOnPageChange) {
          newState.expanded = {};
        }
        this.setStateWithData(newState, function () {
          return onPageChange && onPageChange(page);
        });
      }
    }, {
      key: 'onPageSizeChange',
      value: function onPageSizeChange(newPageSize) {
        var onPageSizeChange = this.props.onPageSizeChange;

        var _getResolvedState = this.getResolvedState(),
            pageSize = _getResolvedState.pageSize,
            page = _getResolvedState.page;

        // Normalize the page to display


        var currentRow = pageSize * page;
        var newPage = Math.floor(currentRow / newPageSize);

        this.setStateWithData({
          pageSize: newPageSize,
          page: newPage
        }, function () {
          return onPageSizeChange && onPageSizeChange(newPageSize, newPage);
        });
      }
    }, {
      key: 'sortColumn',
      value: function sortColumn(column, additive) {
        var _getResolvedState2 = this.getResolvedState(),
            sorted = _getResolvedState2.sorted,
            skipNextSort = _getResolvedState2.skipNextSort,
            defaultSortDesc = _getResolvedState2.defaultSortDesc;

        var firstSortDirection = Object.prototype.hasOwnProperty.call(column, 'defaultSortDesc') ? column.defaultSortDesc : defaultSortDesc;
        var secondSortDirection = !firstSortDirection;

        // we can't stop event propagation from the column resize move handlers
        // attached to the document because of react's synthetic events
        // so we have to prevent the sort function from actually sorting
        // if we click on the column resize element within a header.
        if (skipNextSort) {
          this.setStateWithData({
            skipNextSort: false
          });
          return;
        }

        var onSortedChange = this.props.onSortedChange;


        var newSorted = _utils2.default.clone(sorted || []).map(function (d) {
          d.desc = _utils2.default.isSortingDesc(d);
          return d;
        });
        if (!_utils2.default.isArray(column)) {
          // Single-Sort
          var existingIndex = newSorted.findIndex(function (d) {
            return d.id === column.id;
          });
          if (existingIndex > -1) {
            var existing = newSorted[existingIndex];
            if (existing.desc === secondSortDirection) {
              if (additive) {
                newSorted.splice(existingIndex, 1);
              } else {
                existing.desc = firstSortDirection;
                newSorted = [existing];
              }
            } else {
              existing.desc = secondSortDirection;
              if (!additive) {
                newSorted = [existing];
              }
            }
          } else if (additive) {
            newSorted.push({
              id: column.id,
              desc: firstSortDirection
            });
          } else {
            newSorted = [{
              id: column.id,
              desc: firstSortDirection
            }];
          }
        } else {
          // Multi-Sort
          var _existingIndex = newSorted.findIndex(function (d) {
            return d.id === column[0].id;
          });
          // Existing Sorted Column
          if (_existingIndex > -1) {
            var _existing = newSorted[_existingIndex];
            if (_existing.desc === secondSortDirection) {
              if (additive) {
                newSorted.splice(_existingIndex, column.length);
              } else {
                column.forEach(function (d, i) {
                  newSorted[_existingIndex + i].desc = firstSortDirection;
                });
              }
            } else {
              column.forEach(function (d, i) {
                newSorted[_existingIndex + i].desc = secondSortDirection;
              });
            }
            if (!additive) {
              newSorted = newSorted.slice(_existingIndex, column.length);
            }
            // New Sort Column
          } else if (additive) {
            newSorted = newSorted.concat(column.map(function (d) {
              return {
                id: d.id,
                desc: firstSortDirection
              };
            }));
          } else {
            newSorted = column.map(function (d) {
              return {
                id: d.id,
                desc: firstSortDirection
              };
            });
          }
        }

        this.setStateWithData({
          page: !sorted.length && newSorted.length || !additive ? 0 : this.state.page,
          sorted: newSorted
        }, function () {
          return onSortedChange && onSortedChange(newSorted, column, additive);
        });
      }
    }, {
      key: 'filterColumn',
      value: function filterColumn(column, value) {
        var _getResolvedState3 = this.getResolvedState(),
            filtered = _getResolvedState3.filtered;

        var onFilteredChange = this.props.onFilteredChange;

        // Remove old filter first if it exists

        var newFiltering = (filtered || []).filter(function (x) {
          return x.id !== column.id;
        });

        if (value !== '') {
          newFiltering.push({
            id: column.id,
            value: value
          });
        }

        this.setStateWithData({
          filtered: newFiltering
        }, function () {
          return onFilteredChange && onFilteredChange(newFiltering, column, value);
        });
      }
    }, {
      key: 'resizeColumnStart',
      value: function resizeColumnStart(event, column, isTouch) {
        var _this5 = this;

        event.stopPropagation();
        var parentWidth = event.target.parentElement.getBoundingClientRect().width;

        var pageX = void 0;
        if (isTouch) {
          pageX = event.changedTouches[0].pageX;
        } else {
          pageX = event.pageX;
        }

        this.trapEvents = true;
        this.setStateWithData({
          currentlyResizing: {
            id: column.id,
            startX: pageX,
            parentWidth: parentWidth
          }
        }, function () {
          if (isTouch) {
            document.addEventListener('touchmove', _this5.resizeColumnMoving);
            document.addEventListener('touchcancel', _this5.resizeColumnEnd);
            document.addEventListener('touchend', _this5.resizeColumnEnd);
          } else {
            document.addEventListener('mousemove', _this5.resizeColumnMoving);
            document.addEventListener('mouseup', _this5.resizeColumnEnd);
            document.addEventListener('mouseleave', _this5.resizeColumnEnd);
          }
        });
      }
    }, {
      key: 'resizeColumnMoving',
      value: function resizeColumnMoving(event) {
        event.stopPropagation();
        var _props2 = this.props,
            onResizedChange = _props2.onResizedChange,
            column = _props2.column;

        var _getResolvedState4 = this.getResolvedState(),
            resized = _getResolvedState4.resized,
            currentlyResizing = _getResolvedState4.currentlyResizing,
            columns = _getResolvedState4.columns;

        var currentColumn = columns.find(function (c) {
          return c.accessor === currentlyResizing.id;
        });
        var minResizeWidth = currentColumn ? currentColumn.minResizeWidth : column.minResizeWidth;

        // Delete old value
        var newResized = resized.filter(function (x) {
          return x.id !== currentlyResizing.id;
        });

        var pageX = void 0;

        if (event.type === 'touchmove') {
          pageX = event.changedTouches[0].pageX;
        } else if (event.type === 'mousemove') {
          pageX = event.pageX;
        }

        var newWidth = Math.max(currentlyResizing.parentWidth + pageX - currentlyResizing.startX, minResizeWidth);

        newResized.push({
          id: currentlyResizing.id,
          value: newWidth
        });

        this.setStateWithData({
          resized: newResized
        }, function () {
          return onResizedChange && onResizedChange(newResized, event);
        });
      }
    }, {
      key: 'resizeColumnEnd',
      value: function resizeColumnEnd(event) {
        event.stopPropagation();
        var isTouch = event.type === 'touchend' || event.type === 'touchcancel';

        if (isTouch) {
          document.removeEventListener('touchmove', this.resizeColumnMoving);
          document.removeEventListener('touchcancel', this.resizeColumnEnd);
          document.removeEventListener('touchend', this.resizeColumnEnd);
        }

        // If its a touch event clear the mouse one's as well because sometimes
        // the mouseDown event gets called as well, but the mouseUp event doesn't
        document.removeEventListener('mousemove', this.resizeColumnMoving);
        document.removeEventListener('mouseup', this.resizeColumnEnd);
        document.removeEventListener('mouseleave', this.resizeColumnEnd);

        // The touch events don't propagate up to the sorting's onMouseDown event so
        // no need to prevent it from happening or else the first click after a touch
        // event resize will not sort the column.
        if (!isTouch) {
          this.setStateWithData({
            skipNextSort: true,
            currentlyResizing: false
          });
        }
      }
    }]);

    return _class;
  }(Base);
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9tZXRob2RzLmpzIl0sIm5hbWVzIjpbInByb3BzIiwic3RhdGUiLCJyZXNvbHZlZFN0YXRlIiwiXyIsImNvbXBhY3RPYmplY3QiLCJuZXdTdGF0ZSIsImRhdGFDaGFuZ2VkIiwiY29sdW1ucyIsInBpdm90QnkiLCJkYXRhIiwicmVzb2x2ZURhdGEiLCJwaXZvdElES2V5IiwicGl2b3RWYWxLZXkiLCJzdWJSb3dzS2V5IiwiYWdncmVnYXRlZEtleSIsIm5lc3RpbmdMZXZlbEtleSIsIm9yaWdpbmFsS2V5IiwiaW5kZXhLZXkiLCJncm91cGVkQnlQaXZvdEtleSIsIlN1YkNvbXBvbmVudCIsImhhc0hlYWRlckdyb3VwcyIsInNvbWUiLCJjb2x1bW4iLCJhbGxDb2x1bW5zIiwiaXRlclRyZWUiLCJleHBhbmRlckNvbHVtbiIsImdldEZpcnN0RGVmaW5lZCIsImhhc1N1YkNvbXBvbmVudEFuZE5vRXhwYW5kZXJDb2x1bW4iLCJjb2x1bW5zV2l0aEV4cGFuZGVyIiwiZXhwYW5kZXIiLCJtYWtlRGVjb3JhdGVkQ29sdW1uIiwicGFyZW50Q29sdW1uIiwiZGNvbCIsImV4cGFuZGVyRGVmYXVsdHMiLCJtYXhXaWR0aCIsIm1pbldpZHRoIiwiYWNjZXNzb3IiLCJpZCIsImFjY2Vzc29yU3RyaW5nIiwiZ2V0Iiwicm93IiwiY29uc29sZSIsIndhcm4iLCJFcnJvciIsInVuZGVmaW5lZCIsImFsbERlY29yYXRlZENvbHVtbnMiLCJkZWNvcmF0ZUFuZEFkZFRvQWxsIiwibWFwIiwiZGVjb3JhdGVkQ29sdW1uIiwicHVzaCIsImRlY29yYXRlZENvbHVtbnMiLCJtYXBWaXNpYmxlQ29sdW1ucyIsInZpc2libGVTdWJDb2x1bW5zIiwiZmlsdGVyIiwiaW5kZXhPZiIsImQiLCJzaG93IiwiZmlsdGVyVmlzaWJsZUNvbHVtbnMiLCJsZW5ndGgiLCJhbGxWaXNpYmxlQ29sdW1ucyIsInNsaWNlIiwicGl2b3RJbmRleCIsImZpbmRJbmRleCIsImNvbCIsInBpdm90IiwicGl2b3RDb2x1bW5zIiwiZm9yRWFjaCIsImZvdW5kIiwiZmluZCIsInBpdm90SUQiLCJQaXZvdFBhcmVudENvbHVtbiIsInJlZHVjZSIsInByZXYiLCJjdXJyZW50IiwiUGl2b3RHcm91cEhlYWRlciIsIkhlYWRlciIsInBpdm90Q29sdW1uR3JvdXAiLCJwaXZvdERlZmF1bHRzIiwicGl2b3RlZCIsInNwbGljZSIsInVuc2hpZnQiLCJhbGxDb2x1bW5IZWFkZXJzIiwiYWRkSGVhZGVyIiwibGV2ZWwiLCJjaGlsZExldmVscyIsIk1hdGgiLCJtYXgiLCJsb3dlckxldmVsIiwicHJlY2VkaW5nQ29sdW1uIiwibGFzdCIsImluZGV4T2ZGaXJzdENoaWxkSW5Mb3dlckxldmVsIiwiaW5kZXhBZnRlckxhc3RDaGlsZEluUHJlY2VkaW5nQ29sdW1uIiwib3JwaGFucyIsInZpc2libGVDb2x1bW5zIiwic2hpZnQiLCJoZWFkZXJHcm91cHMiLCJyZXZlcnNlIiwiYWNjZXNzUm93IiwiaSIsInJlc29sdmVkRGF0YSIsImFnZ3JlZ2F0aW5nQ29sdW1ucyIsImFnZ3JlZ2F0ZSIsImFnZ3JlZ2F0aW9uVmFsdWVzIiwidmFsdWVzIiwicm93cyIsImdyb3VwUmVjdXJzaXZlbHkiLCJrZXlzIiwiZ3JvdXBlZFJvd3MiLCJPYmplY3QiLCJlbnRyaWVzIiwiZ3JvdXBCeSIsImtleSIsInZhbHVlIiwic3ViUm93cyIsInJvd0dyb3VwIiwibWFudWFsIiwic29ydGVkIiwiZmlsdGVyZWQiLCJkZWZhdWx0RmlsdGVyTWV0aG9kIiwic29ydE1ldGhvZHNCeUNvbHVtbklEIiwic29ydE1ldGhvZCIsInNvcnRlZERhdGEiLCJzb3J0RGF0YSIsImZpbHRlckRhdGEiLCJjdXJyZW50U3RhdGUiLCJnZXRSZXNvbHZlZFN0YXRlIiwicGFnZSIsImdldFN0YXRlT3JQcm9wIiwicGFnZVNpemUiLCJvbkZldGNoRGF0YSIsImZpbHRlcmVkRGF0YSIsImZpbHRlcmVkU29GYXIiLCJuZXh0RmlsdGVyIiwieCIsImZpbHRlcmFibGUiLCJmaWx0ZXJNZXRob2QiLCJmaWx0ZXJBbGwiLCJvcmRlckJ5TWV0aG9kIiwib3JkZXJCeSIsInNvcnQiLCJhIiwiYiIsImRlc2MiLCJkZWZhdWx0U29ydE1ldGhvZCIsIm1pblJvd3MiLCJvblBhZ2VDaGFuZ2UiLCJjb2xsYXBzZU9uUGFnZUNoYW5nZSIsImV4cGFuZGVkIiwic2V0U3RhdGVXaXRoRGF0YSIsIm5ld1BhZ2VTaXplIiwib25QYWdlU2l6ZUNoYW5nZSIsImN1cnJlbnRSb3ciLCJuZXdQYWdlIiwiZmxvb3IiLCJhZGRpdGl2ZSIsInNraXBOZXh0U29ydCIsImRlZmF1bHRTb3J0RGVzYyIsImZpcnN0U29ydERpcmVjdGlvbiIsInByb3RvdHlwZSIsImhhc093blByb3BlcnR5IiwiY2FsbCIsInNlY29uZFNvcnREaXJlY3Rpb24iLCJvblNvcnRlZENoYW5nZSIsIm5ld1NvcnRlZCIsImNsb25lIiwiaXNTb3J0aW5nRGVzYyIsImlzQXJyYXkiLCJleGlzdGluZ0luZGV4IiwiZXhpc3RpbmciLCJjb25jYXQiLCJvbkZpbHRlcmVkQ2hhbmdlIiwibmV3RmlsdGVyaW5nIiwiZXZlbnQiLCJpc1RvdWNoIiwic3RvcFByb3BhZ2F0aW9uIiwicGFyZW50V2lkdGgiLCJ0YXJnZXQiLCJwYXJlbnRFbGVtZW50IiwiZ2V0Qm91bmRpbmdDbGllbnRSZWN0Iiwid2lkdGgiLCJwYWdlWCIsImNoYW5nZWRUb3VjaGVzIiwidHJhcEV2ZW50cyIsImN1cnJlbnRseVJlc2l6aW5nIiwic3RhcnRYIiwiZG9jdW1lbnQiLCJhZGRFdmVudExpc3RlbmVyIiwicmVzaXplQ29sdW1uTW92aW5nIiwicmVzaXplQ29sdW1uRW5kIiwib25SZXNpemVkQ2hhbmdlIiwicmVzaXplZCIsImN1cnJlbnRDb2x1bW4iLCJjIiwibWluUmVzaXplV2lkdGgiLCJuZXdSZXNpemVkIiwidHlwZSIsIm5ld1dpZHRoIiwicmVtb3ZlRXZlbnRMaXN0ZW5lciIsIkJhc2UiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7OztBQUFBOzs7O0FBQ0E7Ozs7Ozs7Ozs7Ozs7Ozs7a0JBRWU7QUFBQTtBQUFBOztBQUFBO0FBQUE7O0FBQUE7QUFBQTs7QUFBQTtBQUFBO0FBQUEsdUNBRU9BLEtBRlAsRUFFY0MsS0FGZCxFQUVxQjtBQUM5QixZQUFNQyw2QkFDREMsZ0JBQUVDLGFBQUYsQ0FBZ0IsS0FBS0gsS0FBckIsQ0FEQyxFQUVERSxnQkFBRUMsYUFBRixDQUFnQixLQUFLSixLQUFyQixDQUZDLEVBR0RHLGdCQUFFQyxhQUFGLENBQWdCSCxLQUFoQixDQUhDLEVBSURFLGdCQUFFQyxhQUFGLENBQWdCSixLQUFoQixDQUpDLENBQU47QUFNQSxlQUFPRSxhQUFQO0FBQ0Q7QUFWVTtBQUFBO0FBQUEsbUNBWUdHLFFBWkgsRUFZYUMsV0FaYixFQVkwQjtBQUFBOztBQUFBLFlBRWpDQyxPQUZpQyxHQWUvQkYsUUFmK0IsQ0FFakNFLE9BRmlDO0FBQUEsZ0NBZS9CRixRQWYrQixDQUdqQ0csT0FIaUM7QUFBQSxZQUdqQ0EsT0FIaUMscUNBR3ZCLEVBSHVCO0FBQUEsWUFJakNDLElBSmlDLEdBZS9CSixRQWYrQixDQUlqQ0ksSUFKaUM7QUFBQSxZQUtqQ0MsV0FMaUMsR0FlL0JMLFFBZitCLENBS2pDSyxXQUxpQztBQUFBLFlBTWpDQyxVQU5pQyxHQWUvQk4sUUFmK0IsQ0FNakNNLFVBTmlDO0FBQUEsWUFPakNDLFdBUGlDLEdBZS9CUCxRQWYrQixDQU9qQ08sV0FQaUM7QUFBQSxZQVFqQ0MsVUFSaUMsR0FlL0JSLFFBZitCLENBUWpDUSxVQVJpQztBQUFBLFlBU2pDQyxhQVRpQyxHQWUvQlQsUUFmK0IsQ0FTakNTLGFBVGlDO0FBQUEsWUFVakNDLGVBVmlDLEdBZS9CVixRQWYrQixDQVVqQ1UsZUFWaUM7QUFBQSxZQVdqQ0MsV0FYaUMsR0FlL0JYLFFBZitCLENBV2pDVyxXQVhpQztBQUFBLFlBWWpDQyxRQVppQyxHQWUvQlosUUFmK0IsQ0FZakNZLFFBWmlDO0FBQUEsWUFhakNDLGlCQWJpQyxHQWUvQmIsUUFmK0IsQ0FhakNhLGlCQWJpQztBQUFBLFlBY2pDQyxZQWRpQyxHQWUvQmQsUUFmK0IsQ0FjakNjLFlBZGlDOztBQWlCbkM7O0FBQ0EsWUFBTUMsa0JBQWtCYixRQUFRYyxJQUFSLENBQWE7QUFBQSxpQkFBVUMsT0FBT2YsT0FBakI7QUFBQSxTQUFiLENBQXhCOztBQUVBO0FBQ0EsWUFBTWdCLGFBQWFwQixnQkFBRXFCLFFBQUYsQ0FBV2pCLE9BQVgsRUFBb0IsU0FBcEIsQ0FBbkI7QUFDQSxZQUFNa0IsaUJBQWlCdEIsZ0JBQUV1QixlQUFGLENBQWtCSCxVQUFsQixDQUF2Qjs7QUFFQTtBQUNBLFlBQU1JLHFDQUFxQ1IsZ0JBQWdCLENBQUNNLGNBQTVEO0FBQ0EsWUFBTUcsc0JBQXNCRCxzQ0FDdkIsRUFBRUUsVUFBVSxJQUFaLEVBRHVCLDRCQUNBdEIsT0FEQSxrQ0FFcEJBLE9BRm9CLEVBQTVCOztBQUlBLFlBQU11QixzQkFBc0IsU0FBdEJBLG1CQUFzQixDQUFDUixNQUFELEVBQVNTLFlBQVQsRUFBMEI7QUFDcEQsY0FBSUMsYUFBSjtBQUNBLGNBQUlWLE9BQU9PLFFBQVgsRUFBcUI7QUFDbkJHLGdDQUNLLE9BQUtoQyxLQUFMLENBQVdzQixNQURoQixFQUVLLE9BQUt0QixLQUFMLENBQVdpQyxnQkFGaEIsRUFHS1gsTUFITDtBQUtELFdBTkQsTUFNTztBQUNMVSxnQ0FDSyxPQUFLaEMsS0FBTCxDQUFXc0IsTUFEaEIsRUFFSyxPQUFLdEIsS0FBTCxDQUFXc0IsTUFGaEIsRUFHS0EsTUFITDtBQUtEOztBQUVEO0FBQ0EsY0FBSVUsS0FBS0UsUUFBTCxHQUFnQkYsS0FBS0csUUFBekIsRUFBbUM7QUFDakNILGlCQUFLRyxRQUFMLEdBQWdCSCxLQUFLRSxRQUFyQjtBQUNEOztBQUVELGNBQUlILFlBQUosRUFBa0I7QUFDaEJDLGlCQUFLRCxZQUFMLEdBQW9CQSxZQUFwQjtBQUNEOztBQUVEO0FBQ0EsY0FBSSxPQUFPQyxLQUFLSSxRQUFaLEtBQXlCLFFBQTdCLEVBQXVDO0FBQ3JDSixpQkFBS0ssRUFBTCxHQUFVTCxLQUFLSyxFQUFMLElBQVdMLEtBQUtJLFFBQTFCO0FBQ0EsZ0JBQU1FLGlCQUFpQk4sS0FBS0ksUUFBNUI7QUFDQUosaUJBQUtJLFFBQUwsR0FBZ0I7QUFBQSxxQkFBT2pDLGdCQUFFb0MsR0FBRixDQUFNQyxHQUFOLEVBQVdGLGNBQVgsQ0FBUDtBQUFBLGFBQWhCO0FBQ0EsbUJBQU9OLElBQVA7QUFDRDs7QUFFRDtBQUNBLGNBQUlBLEtBQUtJLFFBQUwsSUFBaUIsQ0FBQ0osS0FBS0ssRUFBM0IsRUFBK0I7QUFDN0JJLG9CQUFRQyxJQUFSLENBQWFWLElBQWI7QUFDQSxrQkFBTSxJQUFJVyxLQUFKLENBQ0osMEVBREksQ0FBTjtBQUdEOztBQUVEO0FBQ0EsY0FBSSxDQUFDWCxLQUFLSSxRQUFWLEVBQW9CO0FBQ2xCSixpQkFBS0ksUUFBTCxHQUFnQjtBQUFBLHFCQUFNUSxTQUFOO0FBQUEsYUFBaEI7QUFDRDs7QUFFRCxpQkFBT1osSUFBUDtBQUNELFNBL0NEOztBQWlEQSxZQUFNYSxzQkFBc0IsRUFBNUI7O0FBRUE7QUFDQSxZQUFNQyxzQkFBc0IsU0FBdEJBLG1CQUFzQixDQUFDdkMsT0FBRCxFQUFVd0IsWUFBVjtBQUFBLGlCQUEyQnhCLFFBQVF3QyxHQUFSLENBQVksa0JBQVU7QUFDM0UsZ0JBQU1DLGtCQUFrQmxCLG9CQUFvQlIsTUFBcEIsRUFBNEJTLFlBQTVCLENBQXhCO0FBQ0EsZ0JBQUlULE9BQU9mLE9BQVgsRUFBb0I7QUFDbEJ5Qyw4QkFBZ0J6QyxPQUFoQixHQUEwQnVDLG9CQUFvQnhCLE9BQU9mLE9BQTNCLEVBQW9DZSxNQUFwQyxDQUExQjtBQUNEOztBQUVEdUIsZ0NBQW9CSSxJQUFwQixDQUF5QkQsZUFBekI7QUFDQSxtQkFBT0EsZUFBUDtBQUNELFdBUnNELENBQTNCO0FBQUEsU0FBNUI7O0FBVUEsWUFBTUUsbUJBQW1CSixvQkFBb0JsQixtQkFBcEIsQ0FBekI7QUFDQSxZQUFNdUIsb0JBQW9CLFNBQXBCQSxpQkFBb0I7QUFBQSxpQkFBVzVDLFFBQVF3QyxHQUFSLENBQVksa0JBQVU7QUFDekQsZ0JBQUl6QixPQUFPZixPQUFYLEVBQW9CO0FBQ2xCLGtCQUFNNkMsb0JBQW9COUIsT0FBT2YsT0FBUCxDQUFlOEMsTUFBZixDQUN4QjtBQUFBLHVCQUFNN0MsUUFBUThDLE9BQVIsQ0FBZ0JDLEVBQUVsQixFQUFsQixJQUF3QixDQUFDLENBQXpCLEdBQTZCLEtBQTdCLEdBQXFDbEMsZ0JBQUV1QixlQUFGLENBQWtCNkIsRUFBRUMsSUFBcEIsRUFBMEIsSUFBMUIsQ0FBM0M7QUFBQSxlQUR3QixDQUExQjtBQUdBLGtDQUNLbEMsTUFETDtBQUVFZix5QkFBUzRDLGtCQUFrQkMsaUJBQWxCO0FBRlg7QUFJRDtBQUNELG1CQUFPOUIsTUFBUDtBQUNELFdBWG9DLENBQVg7QUFBQSxTQUExQjs7QUFhQSxZQUFNbUMsdUJBQXVCLFNBQXZCQSxvQkFBdUI7QUFBQSxpQkFBV2xELFFBQVE4QyxNQUFSLENBQ3RDO0FBQUEsbUJBQ0UvQixPQUFPZixPQUFQLEdBQ0llLE9BQU9mLE9BQVAsQ0FBZW1ELE1BRG5CLEdBRUlsRCxRQUFROEMsT0FBUixDQUFnQmhDLE9BQU9lLEVBQXZCLElBQTZCLENBQUMsQ0FBOUIsR0FDRSxLQURGLEdBRUVsQyxnQkFBRXVCLGVBQUYsQ0FBa0JKLE9BQU9rQyxJQUF6QixFQUErQixJQUEvQixDQUxSO0FBQUEsV0FEc0MsQ0FBWDtBQUFBLFNBQTdCOztBQVNBO0FBQ0E7QUFDQSxZQUFNRyxvQkFBb0JGLHFCQUFxQk4sa0JBQWtCRCxpQkFBaUJVLEtBQWpCLEVBQWxCLENBQXJCLENBQTFCOztBQUVBO0FBQ0EsWUFBTUMsYUFBYUYsa0JBQWtCRyxTQUFsQixDQUE0QjtBQUFBLGlCQUFPQyxJQUFJQyxLQUFYO0FBQUEsU0FBNUIsQ0FBbkI7O0FBRUE7QUFDQSxZQUFJeEQsUUFBUWtELE1BQVosRUFBb0I7QUFDbEI7QUFDQSxjQUFNTyxlQUFlLEVBQXJCO0FBQ0F6RCxrQkFBUTBELE9BQVIsQ0FBZ0IsbUJBQVc7QUFDekIsZ0JBQU1DLFFBQVF0QixvQkFBb0J1QixJQUFwQixDQUF5QjtBQUFBLHFCQUFLYixFQUFFbEIsRUFBRixLQUFTZ0MsT0FBZDtBQUFBLGFBQXpCLENBQWQ7QUFDQSxnQkFBSUYsS0FBSixFQUFXO0FBQ1RGLDJCQUFhaEIsSUFBYixDQUFrQmtCLEtBQWxCO0FBQ0Q7QUFDRixXQUxEOztBQU9BLGNBQU1HLG9CQUFvQkwsYUFBYU0sTUFBYixDQUN4QixVQUFDQyxJQUFELEVBQU9DLE9BQVA7QUFBQSxtQkFBbUJELFFBQVFBLFNBQVNDLFFBQVExQyxZQUF6QixJQUF5QzBDLFFBQVExQyxZQUFwRTtBQUFBLFdBRHdCLEVBRXhCa0MsYUFBYSxDQUFiLEVBQWdCbEMsWUFGUSxDQUExQjs7QUFLQSxjQUFJMkMsbUJBQW1CdEQsbUJBQW1Ca0Qsa0JBQWtCSyxNQUE1RDtBQUNBRCw2QkFBbUJBLG9CQUFxQjtBQUFBLG1CQUFNO0FBQUE7QUFBQTtBQUFBO0FBQUEsYUFBTjtBQUFBLFdBQXhDOztBQUVBLGNBQUlFLG1CQUFtQjtBQUNyQkQsb0JBQVFELGdCQURhO0FBRXJCbkUscUJBQVMwRCxhQUFhbEIsR0FBYixDQUFpQjtBQUFBLGtDQUNyQixPQUFLL0MsS0FBTCxDQUFXNkUsYUFEVSxFQUVyQmQsR0FGcUI7QUFHeEJlLHlCQUFTO0FBSGU7QUFBQSxhQUFqQjs7QUFPWDtBQVR1QixXQUF2QixDQVVBLElBQUlqQixjQUFjLENBQWxCLEVBQXFCO0FBQ25CZSw0Q0FDS2pCLGtCQUFrQkUsVUFBbEIsQ0FETCxFQUVLZSxnQkFGTDtBQUlBakIsOEJBQWtCb0IsTUFBbEIsQ0FBeUJsQixVQUF6QixFQUFxQyxDQUFyQyxFQUF3Q2UsZ0JBQXhDO0FBQ0QsV0FORCxNQU1PO0FBQ0xqQiw4QkFBa0JxQixPQUFsQixDQUEwQkosZ0JBQTFCO0FBQ0Q7QUFDRjs7QUFFRDtBQUNBLFlBQU1LLG1CQUFtQixFQUF6Qjs7QUFFQSxZQUFNQyxZQUFZLFNBQVpBLFNBQVksU0FBVTtBQUMxQixjQUFJQyxRQUFRLENBQVo7O0FBRUE7QUFDQSxjQUFJN0QsT0FBT2YsT0FBWCxFQUFvQjtBQUNsQixnQkFBTTZFLGNBQWM5RCxPQUFPZixPQUFQLENBQWV3QyxHQUFmLENBQW1CbUMsU0FBbkIsQ0FBcEI7QUFDQUMsb0JBQVFFLEtBQUtDLEdBQUwsZ0NBQVlGLFdBQVosS0FBMkIsQ0FBbkM7QUFDRDs7QUFFRDtBQUNBLGNBQUlILGlCQUFpQnZCLE1BQWpCLElBQTJCeUIsS0FBL0IsRUFBc0NGLGlCQUFpQmhDLElBQWpCLENBQXNCLEVBQXRCO0FBQ3RDLGNBQUlrQyxRQUFRLENBQVosRUFBZTtBQUNiO0FBQ0E7QUFDQTtBQUNBLGdCQUFNSSxhQUFhTixpQkFBaUJFLFFBQVEsQ0FBekIsQ0FBbkI7QUFDQSxnQkFBTUssa0JBQWtCckYsZ0JBQUVzRixJQUFGLENBQU9SLGlCQUFpQkUsS0FBakIsQ0FBUCxDQUF4Qjs7QUFFQSxnQkFBTU8sZ0NBQWdDSCxXQUFXakMsT0FBWCxDQUFtQmhDLE9BQU9mLE9BQVAsQ0FBZSxDQUFmLENBQW5CLENBQXRDO0FBQ0EsZ0JBQU1vRix1Q0FBdUNILGtCQUN6Q0QsV0FBV2pDLE9BQVgsQ0FBbUJuRCxnQkFBRXNGLElBQUYsQ0FBT0QsZ0JBQWdCakYsT0FBdkIsQ0FBbkIsSUFBc0QsQ0FEYixHQUV6QyxDQUZKOztBQUlBO0FBQ0EsZ0JBQU1xRixVQUFVTCxXQUFXM0IsS0FBWCxDQUNkK0Isb0NBRGMsRUFFZEQsNkJBRmMsQ0FBaEI7O0FBS0EsZ0JBQUlFLFFBQVFsQyxNQUFaLEVBQW9CO0FBQ2xCdUIsK0JBQWlCRSxLQUFqQixFQUF3QmxDLElBQXhCLGNBQ0ssT0FBS2pELEtBQUwsQ0FBV3NCLE1BRGhCO0FBRUVmLHlCQUFTcUY7QUFGWDtBQUlEO0FBQ0Y7O0FBRURYLDJCQUFpQkUsS0FBakIsRUFBd0JsQyxJQUF4QixDQUE2QjNCLE1BQTdCOztBQUVBLGlCQUFPNkQsS0FBUDtBQUNELFNBeENEOztBQTBDQXhCLDBCQUFrQk8sT0FBbEIsQ0FBMEJnQixTQUExQjs7QUFFQTtBQUNBLFlBQU1XLGlCQUFpQlosaUJBQWlCYSxLQUFqQixFQUF2QjtBQUNBLFlBQU1DLGVBQWVkLGlCQUFpQmUsT0FBakIsRUFBckI7O0FBRUE7QUFDQSxZQUFNQyxZQUFZLFNBQVpBLFNBQVksQ0FBQzFDLENBQUQsRUFBSTJDLENBQUosRUFBcUI7QUFBQTs7QUFBQSxjQUFkZixLQUFjLHVFQUFOLENBQU07O0FBQ3JDLGNBQU0zQyx3Q0FDSHhCLFdBREcsRUFDV3VDLENBRFgseUJBRUh0QyxRQUZHLEVBRVFpRixDQUZSLHlCQUdIckYsVUFIRyxFQUdVMEMsRUFBRTFDLFVBQUYsQ0FIVix5QkFJSEUsZUFKRyxFQUllb0UsS0FKZixRQUFOO0FBTUF0Qyw4QkFBb0JxQixPQUFwQixDQUE0QixrQkFBVTtBQUNwQyxnQkFBSTVDLE9BQU9PLFFBQVgsRUFBcUI7QUFDckJXLGdCQUFJbEIsT0FBT2UsRUFBWCxJQUFpQmYsT0FBT2MsUUFBUCxDQUFnQm1CLENBQWhCLENBQWpCO0FBQ0QsV0FIRDtBQUlBLGNBQUlmLElBQUkzQixVQUFKLENBQUosRUFBcUI7QUFDbkIyQixnQkFBSTNCLFVBQUosSUFBa0IyQixJQUFJM0IsVUFBSixFQUFnQmtDLEdBQWhCLENBQW9CLFVBQUNRLENBQUQsRUFBSTJDLENBQUo7QUFBQSxxQkFBVUQsVUFBVTFDLENBQVYsRUFBYTJDLENBQWIsRUFBZ0JmLFFBQVEsQ0FBeEIsQ0FBVjtBQUFBLGFBQXBCLENBQWxCO0FBQ0Q7QUFDRCxpQkFBTzNDLEdBQVA7QUFDRCxTQWZEOztBQWlCQTtBQUNBLFlBQUkyRCxlQUFlLEtBQUtBLFlBQXhCO0FBQ0E7QUFDQSxZQUFJLENBQUMsS0FBS0EsWUFBTixJQUFzQjdGLFdBQTFCLEVBQXVDO0FBQ3JDNkYseUJBQWV6RixZQUFZRCxJQUFaLENBQWY7QUFDQSxlQUFLMEYsWUFBTCxHQUFvQkEsWUFBcEI7QUFDRDtBQUNEO0FBQ0FBLHVCQUFlQSxhQUFhcEQsR0FBYixDQUFpQixVQUFDUSxDQUFELEVBQUkyQyxDQUFKO0FBQUEsaUJBQVVELFVBQVUxQyxDQUFWLEVBQWEyQyxDQUFiLENBQVY7QUFBQSxTQUFqQixDQUFmOztBQUVBO0FBQ0EsWUFBTUUscUJBQXFCUCxlQUFleEMsTUFBZixDQUFzQjtBQUFBLGlCQUFLLENBQUNFLEVBQUUxQixRQUFILElBQWUwQixFQUFFOEMsU0FBdEI7QUFBQSxTQUF0QixDQUEzQjs7QUFFQTtBQUNBLFlBQU1BLFlBQVksU0FBWkEsU0FBWSxPQUFRO0FBQ3hCLGNBQU1DLG9CQUFvQixFQUExQjtBQUNBRiw2QkFBbUJsQyxPQUFuQixDQUEyQixrQkFBVTtBQUNuQyxnQkFBTXFDLFNBQVNDLEtBQUt6RCxHQUFMLENBQVM7QUFBQSxxQkFBS1EsRUFBRWpDLE9BQU9lLEVBQVQsQ0FBTDtBQUFBLGFBQVQsQ0FBZjtBQUNBaUUsOEJBQWtCaEYsT0FBT2UsRUFBekIsSUFBK0JmLE9BQU8rRSxTQUFQLENBQWlCRSxNQUFqQixFQUF5QkMsSUFBekIsQ0FBL0I7QUFDRCxXQUhEO0FBSUEsaUJBQU9GLGlCQUFQO0FBQ0QsU0FQRDtBQVFBLFlBQUk5RixRQUFRa0QsTUFBWixFQUFvQjtBQUNsQixjQUFNK0MsbUJBQW1CLFNBQW5CQSxnQkFBbUIsQ0FBQ0QsSUFBRCxFQUFPRSxJQUFQLEVBQXVCO0FBQUEsZ0JBQVZSLENBQVUsdUVBQU4sQ0FBTTs7QUFDOUM7QUFDQSxnQkFBSUEsTUFBTVEsS0FBS2hELE1BQWYsRUFBdUI7QUFDckIscUJBQU84QyxJQUFQO0FBQ0Q7QUFDRDtBQUNBLGdCQUFJRyxjQUFjQyxPQUFPQyxPQUFQLENBQWUxRyxnQkFBRTJHLE9BQUYsQ0FBVU4sSUFBVixFQUFnQkUsS0FBS1IsQ0FBTCxDQUFoQixDQUFmLEVBQXlDbkQsR0FBekMsQ0FBNkM7QUFBQTs7QUFBQTtBQUFBLGtCQUFFZ0UsR0FBRjtBQUFBLGtCQUFPQyxLQUFQOztBQUFBLHdEQUM1RHJHLFVBRDRELEVBQy9DK0YsS0FBS1IsQ0FBTCxDQUQrQywwQkFFNUR0RixXQUY0RCxFQUU5Q21HLEdBRjhDLDBCQUc1REwsS0FBS1IsQ0FBTCxDQUg0RCxFQUdsRGEsR0FIa0QsMEJBSTVEbEcsVUFKNEQsRUFJL0NtRyxLQUorQywwQkFLNURqRyxlQUw0RCxFQUsxQ21GLENBTDBDLDBCQU01RGhGLGlCQU40RCxFQU14QyxJQU53QztBQUFBLGFBQTdDLENBQWxCO0FBUUE7QUFDQXlGLDBCQUFjQSxZQUFZNUQsR0FBWixDQUFnQixvQkFBWTtBQUFBOztBQUN4QyxrQkFBTWtFLFVBQVVSLGlCQUFpQlMsU0FBU3JHLFVBQVQsQ0FBakIsRUFBdUM2RixJQUF2QyxFQUE2Q1IsSUFBSSxDQUFqRCxDQUFoQjtBQUNBLGtDQUNLZ0IsUUFETCw4Q0FFR3JHLFVBRkgsRUFFZ0JvRyxPQUZoQiw4QkFHR25HLGFBSEgsRUFHbUIsSUFIbkIsZUFJS3VGLFVBQVVZLE9BQVYsQ0FKTDtBQU1ELGFBUmEsQ0FBZDtBQVNBLG1CQUFPTixXQUFQO0FBQ0QsV0F6QkQ7QUEwQkFSLHlCQUFlTSxpQkFBaUJOLFlBQWpCLEVBQStCM0YsT0FBL0IsQ0FBZjtBQUNEOztBQUVELDRCQUNLSCxRQURMO0FBRUU4RixvQ0FGRjtBQUdFTix3Q0FIRjtBQUlFRSxvQ0FKRjtBQUtFbEQsa0RBTEY7QUFNRXpCO0FBTkY7QUFRRDtBQS9TVTtBQUFBO0FBQUEsb0NBaVRJbEIsYUFqVEosRUFpVG1CO0FBQUEsWUFFMUJpSCxNQUYwQixHQVF4QmpILGFBUndCLENBRTFCaUgsTUFGMEI7QUFBQSxZQUcxQkMsTUFIMEIsR0FReEJsSCxhQVJ3QixDQUcxQmtILE1BSDBCO0FBQUEsWUFJMUJDLFFBSjBCLEdBUXhCbkgsYUFSd0IsQ0FJMUJtSCxRQUowQjtBQUFBLFlBSzFCQyxtQkFMMEIsR0FReEJwSCxhQVJ3QixDQUsxQm9ILG1CQUwwQjtBQUFBLFlBTTFCbkIsWUFOMEIsR0FReEJqRyxhQVJ3QixDQU0xQmlHLFlBTjBCO0FBQUEsWUFPMUJ0RCxtQkFQMEIsR0FReEIzQyxhQVJ3QixDQU8xQjJDLG1CQVAwQjs7O0FBVTVCLFlBQU0wRSx3QkFBd0IsRUFBOUI7O0FBRUExRSw0QkFBb0JRLE1BQXBCLENBQTJCO0FBQUEsaUJBQU9VLElBQUl5RCxVQUFYO0FBQUEsU0FBM0IsRUFBa0R0RCxPQUFsRCxDQUEwRCxlQUFPO0FBQy9EcUQsZ0NBQXNCeEQsSUFBSTFCLEVBQTFCLElBQWdDMEIsSUFBSXlELFVBQXBDO0FBQ0QsU0FGRDs7QUFJQTtBQUNBLGVBQU87QUFDTEMsc0JBQVlOLFNBQ1JoQixZQURRLEdBRVIsS0FBS3VCLFFBQUwsQ0FDQSxLQUFLQyxVQUFMLENBQWdCeEIsWUFBaEIsRUFBOEJrQixRQUE5QixFQUF3Q0MsbUJBQXhDLEVBQTZEekUsbUJBQTdELENBREEsRUFFQXVFLE1BRkEsRUFHQUcscUJBSEE7QUFIQyxTQUFQO0FBU0Q7QUEzVVU7QUFBQTtBQUFBLHNDQTZVTTtBQUNmO0FBQ0EsWUFBTUssNEJBQ0QsS0FBS0MsZ0JBQUwsRUFEQztBQUVKQyxnQkFBTSxLQUFLQyxjQUFMLENBQW9CLE1BQXBCLENBRkY7QUFHSkMsb0JBQVUsS0FBS0QsY0FBTCxDQUFvQixVQUFwQixDQUhOO0FBSUoxRSxrQkFBUSxLQUFLMEUsY0FBTCxDQUFvQixRQUFwQjtBQUpKLFVBQU47O0FBT0EsYUFBSy9ILEtBQUwsQ0FBV2lJLFdBQVgsQ0FBdUJMLFlBQXZCLEVBQXFDLElBQXJDO0FBQ0Q7QUF2VlU7QUFBQTtBQUFBLHFDQXlWS2IsR0F6VkwsRUF5VlU7QUFDbkIsZUFBTzVHLGdCQUFFdUIsZUFBRixDQUFrQixLQUFLMUIsS0FBTCxDQUFXK0csR0FBWCxDQUFsQixFQUFtQyxLQUFLOUcsS0FBTCxDQUFXOEcsR0FBWCxDQUFuQyxDQUFQO0FBQ0Q7QUEzVlU7QUFBQTtBQUFBLHFDQTZWS0EsR0E3VkwsRUE2VlU7QUFDbkIsZUFBTzVHLGdCQUFFdUIsZUFBRixDQUFrQixLQUFLekIsS0FBTCxDQUFXOEcsR0FBWCxDQUFsQixFQUFtQyxLQUFLL0csS0FBTCxDQUFXK0csR0FBWCxDQUFuQyxDQUFQO0FBQ0Q7QUEvVlU7QUFBQTtBQUFBLGlDQWlXQ3RHLElBaldELEVBaVdPNEcsUUFqV1AsRUFpV2lCQyxtQkFqV2pCLEVBaVdzQ3pCLGNBald0QyxFQWlXc0Q7QUFBQTs7QUFDL0QsWUFBSXFDLGVBQWV6SCxJQUFuQjs7QUFFQSxZQUFJNEcsU0FBUzNELE1BQWIsRUFBcUI7QUFDbkJ3RSx5QkFBZWIsU0FBUzlDLE1BQVQsQ0FBZ0IsVUFBQzRELGFBQUQsRUFBZ0JDLFVBQWhCLEVBQStCO0FBQzVELGdCQUFNOUcsU0FBU3VFLGVBQWV6QixJQUFmLENBQW9CO0FBQUEscUJBQUtpRSxFQUFFaEcsRUFBRixLQUFTK0YsV0FBVy9GLEVBQXpCO0FBQUEsYUFBcEIsQ0FBZjs7QUFFQTtBQUNBLGdCQUFJLENBQUNmLE1BQUQsSUFBV0EsT0FBT2dILFVBQVAsS0FBc0IsS0FBckMsRUFBNEM7QUFDMUMscUJBQU9ILGFBQVA7QUFDRDs7QUFFRCxnQkFBTUksZUFBZWpILE9BQU9pSCxZQUFQLElBQXVCakIsbUJBQTVDOztBQUVBO0FBQ0EsZ0JBQUloRyxPQUFPa0gsU0FBWCxFQUFzQjtBQUNwQixxQkFBT0QsYUFBYUgsVUFBYixFQUF5QkQsYUFBekIsRUFBd0M3RyxNQUF4QyxDQUFQO0FBQ0Q7QUFDRCxtQkFBTzZHLGNBQWM5RSxNQUFkLENBQXFCO0FBQUEscUJBQU9rRixhQUFhSCxVQUFiLEVBQXlCNUYsR0FBekIsRUFBOEJsQixNQUE5QixDQUFQO0FBQUEsYUFBckIsQ0FBUDtBQUNELFdBZmMsRUFlWjRHLFlBZlksQ0FBZjs7QUFpQkE7QUFDQTtBQUNBQSx5QkFBZUEsYUFDWm5GLEdBRFksQ0FDUixlQUFPO0FBQ1YsZ0JBQUksQ0FBQ1AsSUFBSSxPQUFLeEMsS0FBTCxDQUFXYSxVQUFmLENBQUwsRUFBaUM7QUFDL0IscUJBQU8yQixHQUFQO0FBQ0Q7QUFDRCxnQ0FDS0EsR0FETCxzQkFFRyxPQUFLeEMsS0FBTCxDQUFXYSxVQUZkLEVBRTJCLE9BQUs4RyxVQUFMLENBQ3ZCbkYsSUFBSSxPQUFLeEMsS0FBTCxDQUFXYSxVQUFmLENBRHVCLEVBRXZCd0csUUFGdUIsRUFHdkJDLG1CQUh1QixFQUl2QnpCLGNBSnVCLENBRjNCO0FBU0QsV0FkWSxFQWVaeEMsTUFmWSxDQWVMLGVBQU87QUFDYixnQkFBSSxDQUFDYixJQUFJLE9BQUt4QyxLQUFMLENBQVdhLFVBQWYsQ0FBTCxFQUFpQztBQUMvQixxQkFBTyxJQUFQO0FBQ0Q7QUFDRCxtQkFBTzJCLElBQUksT0FBS3hDLEtBQUwsQ0FBV2EsVUFBZixFQUEyQjZDLE1BQTNCLEdBQW9DLENBQTNDO0FBQ0QsV0FwQlksQ0FBZjtBQXFCRDs7QUFFRCxlQUFPd0UsWUFBUDtBQUNEO0FBaFpVO0FBQUE7QUFBQSwrQkFrWkR6SCxJQWxaQyxFQWtaSzJHLE1BbFpMLEVBa1p5QztBQUFBOztBQUFBLFlBQTVCRyxxQkFBNEIsdUVBQUosRUFBSTs7QUFDbEQsWUFBSSxDQUFDSCxPQUFPMUQsTUFBWixFQUFvQjtBQUNsQixpQkFBT2pELElBQVA7QUFDRDs7QUFFRCxZQUFNZ0gsYUFBYSxDQUFDLEtBQUt6SCxLQUFMLENBQVd5SSxhQUFYLElBQTRCdEksZ0JBQUV1SSxPQUEvQixFQUNqQmpJLElBRGlCLEVBRWpCMkcsT0FBT3JFLEdBQVAsQ0FBVyxnQkFBUTtBQUNqQjtBQUNBLGNBQUl3RSxzQkFBc0JvQixLQUFLdEcsRUFBM0IsQ0FBSixFQUFvQztBQUNsQyxtQkFBTyxVQUFDdUcsQ0FBRCxFQUFJQyxDQUFKO0FBQUEscUJBQVV0QixzQkFBc0JvQixLQUFLdEcsRUFBM0IsRUFBK0J1RyxFQUFFRCxLQUFLdEcsRUFBUCxDQUEvQixFQUEyQ3dHLEVBQUVGLEtBQUt0RyxFQUFQLENBQTNDLEVBQXVEc0csS0FBS0csSUFBNUQsQ0FBVjtBQUFBLGFBQVA7QUFDRDtBQUNELGlCQUFPLFVBQUNGLENBQUQsRUFBSUMsQ0FBSjtBQUFBLG1CQUFVLE9BQUs3SSxLQUFMLENBQVcrSSxpQkFBWCxDQUE2QkgsRUFBRUQsS0FBS3RHLEVBQVAsQ0FBN0IsRUFBeUN3RyxFQUFFRixLQUFLdEcsRUFBUCxDQUF6QyxFQUFxRHNHLEtBQUtHLElBQTFELENBQVY7QUFBQSxXQUFQO0FBQ0QsU0FORCxDQUZpQixFQVNqQjFCLE9BQU9yRSxHQUFQLENBQVc7QUFBQSxpQkFBSyxDQUFDUSxFQUFFdUYsSUFBUjtBQUFBLFNBQVgsQ0FUaUIsRUFVakIsS0FBSzlJLEtBQUwsQ0FBV2lCLFFBVk0sQ0FBbkI7O0FBYUF3RyxtQkFBV3ZELE9BQVgsQ0FBbUIsZUFBTztBQUN4QixjQUFJLENBQUMxQixJQUFJLE9BQUt4QyxLQUFMLENBQVdhLFVBQWYsQ0FBTCxFQUFpQztBQUMvQjtBQUNEO0FBQ0QyQixjQUFJLE9BQUt4QyxLQUFMLENBQVdhLFVBQWYsSUFBNkIsT0FBSzZHLFFBQUwsQ0FDM0JsRixJQUFJLE9BQUt4QyxLQUFMLENBQVdhLFVBQWYsQ0FEMkIsRUFFM0J1RyxNQUYyQixFQUczQkcscUJBSDJCLENBQTdCO0FBS0QsU0FURDs7QUFXQSxlQUFPRSxVQUFQO0FBQ0Q7QUFoYlU7QUFBQTtBQUFBLG1DQWtiRztBQUNaLGVBQU90SCxnQkFBRXVCLGVBQUYsQ0FBa0IsS0FBSzFCLEtBQUwsQ0FBV2dKLE9BQTdCLEVBQXNDLEtBQUtqQixjQUFMLENBQW9CLFVBQXBCLENBQXRDLENBQVA7QUFDRDs7QUFFRDs7QUF0Ylc7QUFBQTtBQUFBLG1DQXViR0QsSUF2YkgsRUF1YlM7QUFBQSxxQkFDNkIsS0FBSzlILEtBRGxDO0FBQUEsWUFDVmlKLFlBRFUsVUFDVkEsWUFEVTtBQUFBLFlBQ0lDLG9CQURKLFVBQ0lBLG9CQURKOzs7QUFHbEIsWUFBTTdJLFdBQVcsRUFBRXlILFVBQUYsRUFBakI7QUFDQSxZQUFJb0Isb0JBQUosRUFBMEI7QUFDeEI3SSxtQkFBUzhJLFFBQVQsR0FBb0IsRUFBcEI7QUFDRDtBQUNELGFBQUtDLGdCQUFMLENBQXNCL0ksUUFBdEIsRUFBZ0M7QUFBQSxpQkFBTTRJLGdCQUFnQkEsYUFBYW5CLElBQWIsQ0FBdEI7QUFBQSxTQUFoQztBQUNEO0FBL2JVO0FBQUE7QUFBQSx1Q0FpY091QixXQWpjUCxFQWljb0I7QUFBQSxZQUNyQkMsZ0JBRHFCLEdBQ0EsS0FBS3RKLEtBREwsQ0FDckJzSixnQkFEcUI7O0FBQUEsZ0NBRUYsS0FBS3pCLGdCQUFMLEVBRkU7QUFBQSxZQUVyQkcsUUFGcUIscUJBRXJCQSxRQUZxQjtBQUFBLFlBRVhGLElBRlcscUJBRVhBLElBRlc7O0FBSTdCOzs7QUFDQSxZQUFNeUIsYUFBYXZCLFdBQVdGLElBQTlCO0FBQ0EsWUFBTTBCLFVBQVVuRSxLQUFLb0UsS0FBTCxDQUFXRixhQUFhRixXQUF4QixDQUFoQjs7QUFFQSxhQUFLRCxnQkFBTCxDQUNFO0FBQ0VwQixvQkFBVXFCLFdBRFo7QUFFRXZCLGdCQUFNMEI7QUFGUixTQURGLEVBS0U7QUFBQSxpQkFBTUYsb0JBQW9CQSxpQkFBaUJELFdBQWpCLEVBQThCRyxPQUE5QixDQUExQjtBQUFBLFNBTEY7QUFPRDtBQWhkVTtBQUFBO0FBQUEsaUNBa2RDbEksTUFsZEQsRUFrZFNvSSxRQWxkVCxFQWtkbUI7QUFBQSxpQ0FDc0IsS0FBSzdCLGdCQUFMLEVBRHRCO0FBQUEsWUFDcEJULE1BRG9CLHNCQUNwQkEsTUFEb0I7QUFBQSxZQUNadUMsWUFEWSxzQkFDWkEsWUFEWTtBQUFBLFlBQ0VDLGVBREYsc0JBQ0VBLGVBREY7O0FBRzVCLFlBQU1DLHFCQUFxQmpELE9BQU9rRCxTQUFQLENBQWlCQyxjQUFqQixDQUFnQ0MsSUFBaEMsQ0FBcUMxSSxNQUFyQyxFQUE2QyxpQkFBN0MsSUFDdkJBLE9BQU9zSSxlQURnQixHQUV2QkEsZUFGSjtBQUdBLFlBQU1LLHNCQUFzQixDQUFDSixrQkFBN0I7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQSxZQUFJRixZQUFKLEVBQWtCO0FBQ2hCLGVBQUtQLGdCQUFMLENBQXNCO0FBQ3BCTywwQkFBYztBQURNLFdBQXRCO0FBR0E7QUFDRDs7QUFqQjJCLFlBbUJwQk8sY0FuQm9CLEdBbUJELEtBQUtsSyxLQW5CSixDQW1CcEJrSyxjQW5Cb0I7OztBQXFCNUIsWUFBSUMsWUFBWWhLLGdCQUFFaUssS0FBRixDQUFRaEQsVUFBVSxFQUFsQixFQUFzQnJFLEdBQXRCLENBQTBCLGFBQUs7QUFDN0NRLFlBQUV1RixJQUFGLEdBQVMzSSxnQkFBRWtLLGFBQUYsQ0FBZ0I5RyxDQUFoQixDQUFUO0FBQ0EsaUJBQU9BLENBQVA7QUFDRCxTQUhlLENBQWhCO0FBSUEsWUFBSSxDQUFDcEQsZ0JBQUVtSyxPQUFGLENBQVVoSixNQUFWLENBQUwsRUFBd0I7QUFDdEI7QUFDQSxjQUFNaUosZ0JBQWdCSixVQUFVckcsU0FBVixDQUFvQjtBQUFBLG1CQUFLUCxFQUFFbEIsRUFBRixLQUFTZixPQUFPZSxFQUFyQjtBQUFBLFdBQXBCLENBQXRCO0FBQ0EsY0FBSWtJLGdCQUFnQixDQUFDLENBQXJCLEVBQXdCO0FBQ3RCLGdCQUFNQyxXQUFXTCxVQUFVSSxhQUFWLENBQWpCO0FBQ0EsZ0JBQUlDLFNBQVMxQixJQUFULEtBQWtCbUIsbUJBQXRCLEVBQTJDO0FBQ3pDLGtCQUFJUCxRQUFKLEVBQWM7QUFDWlMsMEJBQVVwRixNQUFWLENBQWlCd0YsYUFBakIsRUFBZ0MsQ0FBaEM7QUFDRCxlQUZELE1BRU87QUFDTEMseUJBQVMxQixJQUFULEdBQWdCZSxrQkFBaEI7QUFDQU0sNEJBQVksQ0FBQ0ssUUFBRCxDQUFaO0FBQ0Q7QUFDRixhQVBELE1BT087QUFDTEEsdUJBQVMxQixJQUFULEdBQWdCbUIsbUJBQWhCO0FBQ0Esa0JBQUksQ0FBQ1AsUUFBTCxFQUFlO0FBQ2JTLDRCQUFZLENBQUNLLFFBQUQsQ0FBWjtBQUNEO0FBQ0Y7QUFDRixXQWZELE1BZU8sSUFBSWQsUUFBSixFQUFjO0FBQ25CUyxzQkFBVWxILElBQVYsQ0FBZTtBQUNiWixrQkFBSWYsT0FBT2UsRUFERTtBQUVieUcsb0JBQU1lO0FBRk8sYUFBZjtBQUlELFdBTE0sTUFLQTtBQUNMTSx3QkFBWSxDQUNWO0FBQ0U5SCxrQkFBSWYsT0FBT2UsRUFEYjtBQUVFeUcsb0JBQU1lO0FBRlIsYUFEVSxDQUFaO0FBTUQ7QUFDRixTQS9CRCxNQStCTztBQUNMO0FBQ0EsY0FBTVUsaUJBQWdCSixVQUFVckcsU0FBVixDQUFvQjtBQUFBLG1CQUFLUCxFQUFFbEIsRUFBRixLQUFTZixPQUFPLENBQVAsRUFBVWUsRUFBeEI7QUFBQSxXQUFwQixDQUF0QjtBQUNBO0FBQ0EsY0FBSWtJLGlCQUFnQixDQUFDLENBQXJCLEVBQXdCO0FBQ3RCLGdCQUFNQyxZQUFXTCxVQUFVSSxjQUFWLENBQWpCO0FBQ0EsZ0JBQUlDLFVBQVMxQixJQUFULEtBQWtCbUIsbUJBQXRCLEVBQTJDO0FBQ3pDLGtCQUFJUCxRQUFKLEVBQWM7QUFDWlMsMEJBQVVwRixNQUFWLENBQWlCd0YsY0FBakIsRUFBZ0NqSixPQUFPb0MsTUFBdkM7QUFDRCxlQUZELE1BRU87QUFDTHBDLHVCQUFPNEMsT0FBUCxDQUFlLFVBQUNYLENBQUQsRUFBSTJDLENBQUosRUFBVTtBQUN2QmlFLDRCQUFVSSxpQkFBZ0JyRSxDQUExQixFQUE2QjRDLElBQTdCLEdBQW9DZSxrQkFBcEM7QUFDRCxpQkFGRDtBQUdEO0FBQ0YsYUFSRCxNQVFPO0FBQ0x2SSxxQkFBTzRDLE9BQVAsQ0FBZSxVQUFDWCxDQUFELEVBQUkyQyxDQUFKLEVBQVU7QUFDdkJpRSwwQkFBVUksaUJBQWdCckUsQ0FBMUIsRUFBNkI0QyxJQUE3QixHQUFvQ21CLG1CQUFwQztBQUNELGVBRkQ7QUFHRDtBQUNELGdCQUFJLENBQUNQLFFBQUwsRUFBZTtBQUNiUywwQkFBWUEsVUFBVXZHLEtBQVYsQ0FBZ0IyRyxjQUFoQixFQUErQmpKLE9BQU9vQyxNQUF0QyxDQUFaO0FBQ0Q7QUFDRDtBQUNELFdBbkJELE1BbUJPLElBQUlnRyxRQUFKLEVBQWM7QUFDbkJTLHdCQUFZQSxVQUFVTSxNQUFWLENBQ1ZuSixPQUFPeUIsR0FBUCxDQUFXO0FBQUEscUJBQU07QUFDZlYsb0JBQUlrQixFQUFFbEIsRUFEUztBQUVmeUcsc0JBQU1lO0FBRlMsZUFBTjtBQUFBLGFBQVgsQ0FEVSxDQUFaO0FBTUQsV0FQTSxNQU9BO0FBQ0xNLHdCQUFZN0ksT0FBT3lCLEdBQVAsQ0FBVztBQUFBLHFCQUFNO0FBQzNCVixvQkFBSWtCLEVBQUVsQixFQURxQjtBQUUzQnlHLHNCQUFNZTtBQUZxQixlQUFOO0FBQUEsYUFBWCxDQUFaO0FBSUQ7QUFDRjs7QUFFRCxhQUFLVCxnQkFBTCxDQUNFO0FBQ0V0QixnQkFBTyxDQUFDVixPQUFPMUQsTUFBUixJQUFrQnlHLFVBQVV6RyxNQUE3QixJQUF3QyxDQUFDZ0csUUFBekMsR0FBb0QsQ0FBcEQsR0FBd0QsS0FBS3pKLEtBQUwsQ0FBVzZILElBRDNFO0FBRUVWLGtCQUFRK0M7QUFGVixTQURGLEVBS0U7QUFBQSxpQkFBTUQsa0JBQWtCQSxlQUFlQyxTQUFmLEVBQTBCN0ksTUFBMUIsRUFBa0NvSSxRQUFsQyxDQUF4QjtBQUFBLFNBTEY7QUFPRDtBQXZqQlU7QUFBQTtBQUFBLG1DQXlqQkdwSSxNQXpqQkgsRUF5akJXMEYsS0F6akJYLEVBeWpCa0I7QUFBQSxpQ0FDTixLQUFLYSxnQkFBTCxFQURNO0FBQUEsWUFDbkJSLFFBRG1CLHNCQUNuQkEsUUFEbUI7O0FBQUEsWUFFbkJxRCxnQkFGbUIsR0FFRSxLQUFLMUssS0FGUCxDQUVuQjBLLGdCQUZtQjs7QUFJM0I7O0FBQ0EsWUFBTUMsZUFBZSxDQUFDdEQsWUFBWSxFQUFiLEVBQWlCaEUsTUFBakIsQ0FBd0I7QUFBQSxpQkFBS2dGLEVBQUVoRyxFQUFGLEtBQVNmLE9BQU9lLEVBQXJCO0FBQUEsU0FBeEIsQ0FBckI7O0FBRUEsWUFBSTJFLFVBQVUsRUFBZCxFQUFrQjtBQUNoQjJELHVCQUFhMUgsSUFBYixDQUFrQjtBQUNoQlosZ0JBQUlmLE9BQU9lLEVBREs7QUFFaEIyRTtBQUZnQixXQUFsQjtBQUlEOztBQUVELGFBQUtvQyxnQkFBTCxDQUNFO0FBQ0UvQixvQkFBVXNEO0FBRFosU0FERixFQUlFO0FBQUEsaUJBQU1ELG9CQUFvQkEsaUJBQWlCQyxZQUFqQixFQUErQnJKLE1BQS9CLEVBQXVDMEYsS0FBdkMsQ0FBMUI7QUFBQSxTQUpGO0FBTUQ7QUE3a0JVO0FBQUE7QUFBQSx3Q0Era0JRNEQsS0Eva0JSLEVBK2tCZXRKLE1BL2tCZixFQStrQnVCdUosT0Eva0J2QixFQStrQmdDO0FBQUE7O0FBQ3pDRCxjQUFNRSxlQUFOO0FBQ0EsWUFBTUMsY0FBY0gsTUFBTUksTUFBTixDQUFhQyxhQUFiLENBQTJCQyxxQkFBM0IsR0FBbURDLEtBQXZFOztBQUVBLFlBQUlDLGNBQUo7QUFDQSxZQUFJUCxPQUFKLEVBQWE7QUFDWE8sa0JBQVFSLE1BQU1TLGNBQU4sQ0FBcUIsQ0FBckIsRUFBd0JELEtBQWhDO0FBQ0QsU0FGRCxNQUVPO0FBQ0xBLGtCQUFRUixNQUFNUSxLQUFkO0FBQ0Q7O0FBRUQsYUFBS0UsVUFBTCxHQUFrQixJQUFsQjtBQUNBLGFBQUtsQyxnQkFBTCxDQUNFO0FBQ0VtQyw2QkFBbUI7QUFDakJsSixnQkFBSWYsT0FBT2UsRUFETTtBQUVqQm1KLG9CQUFRSixLQUZTO0FBR2pCTDtBQUhpQjtBQURyQixTQURGLEVBUUUsWUFBTTtBQUNKLGNBQUlGLE9BQUosRUFBYTtBQUNYWSxxQkFBU0MsZ0JBQVQsQ0FBMEIsV0FBMUIsRUFBdUMsT0FBS0Msa0JBQTVDO0FBQ0FGLHFCQUFTQyxnQkFBVCxDQUEwQixhQUExQixFQUF5QyxPQUFLRSxlQUE5QztBQUNBSCxxQkFBU0MsZ0JBQVQsQ0FBMEIsVUFBMUIsRUFBc0MsT0FBS0UsZUFBM0M7QUFDRCxXQUpELE1BSU87QUFDTEgscUJBQVNDLGdCQUFULENBQTBCLFdBQTFCLEVBQXVDLE9BQUtDLGtCQUE1QztBQUNBRixxQkFBU0MsZ0JBQVQsQ0FBMEIsU0FBMUIsRUFBcUMsT0FBS0UsZUFBMUM7QUFDQUgscUJBQVNDLGdCQUFULENBQTBCLFlBQTFCLEVBQXdDLE9BQUtFLGVBQTdDO0FBQ0Q7QUFDRixTQWxCSDtBQW9CRDtBQS9tQlU7QUFBQTtBQUFBLHlDQWluQlNoQixLQWpuQlQsRUFpbkJnQjtBQUN6QkEsY0FBTUUsZUFBTjtBQUR5QixzQkFFVyxLQUFLOUssS0FGaEI7QUFBQSxZQUVqQjZMLGVBRmlCLFdBRWpCQSxlQUZpQjtBQUFBLFlBRUF2SyxNQUZBLFdBRUFBLE1BRkE7O0FBQUEsaUNBR3VCLEtBQUt1RyxnQkFBTCxFQUh2QjtBQUFBLFlBR2pCaUUsT0FIaUIsc0JBR2pCQSxPQUhpQjtBQUFBLFlBR1JQLGlCQUhRLHNCQUdSQSxpQkFIUTtBQUFBLFlBR1doTCxPQUhYLHNCQUdXQSxPQUhYOztBQUl6QixZQUFNd0wsZ0JBQWdCeEwsUUFBUTZELElBQVIsQ0FBYTtBQUFBLGlCQUFLNEgsRUFBRTVKLFFBQUYsS0FBZW1KLGtCQUFrQmxKLEVBQXRDO0FBQUEsU0FBYixDQUF0QjtBQUNBLFlBQU00SixpQkFBaUJGLGdCQUFnQkEsY0FBY0UsY0FBOUIsR0FBK0MzSyxPQUFPMkssY0FBN0U7O0FBRUE7QUFDQSxZQUFNQyxhQUFhSixRQUFRekksTUFBUixDQUFlO0FBQUEsaUJBQUtnRixFQUFFaEcsRUFBRixLQUFTa0osa0JBQWtCbEosRUFBaEM7QUFBQSxTQUFmLENBQW5COztBQUVBLFlBQUkrSSxjQUFKOztBQUVBLFlBQUlSLE1BQU11QixJQUFOLEtBQWUsV0FBbkIsRUFBZ0M7QUFDOUJmLGtCQUFRUixNQUFNUyxjQUFOLENBQXFCLENBQXJCLEVBQXdCRCxLQUFoQztBQUNELFNBRkQsTUFFTyxJQUFJUixNQUFNdUIsSUFBTixLQUFlLFdBQW5CLEVBQWdDO0FBQ3JDZixrQkFBUVIsTUFBTVEsS0FBZDtBQUNEOztBQUVELFlBQU1nQixXQUFXL0csS0FBS0MsR0FBTCxDQUNmaUcsa0JBQWtCUixXQUFsQixHQUFnQ0ssS0FBaEMsR0FBd0NHLGtCQUFrQkMsTUFEM0MsRUFFZlMsY0FGZSxDQUFqQjs7QUFLQUMsbUJBQVdqSixJQUFYLENBQWdCO0FBQ2RaLGNBQUlrSixrQkFBa0JsSixFQURSO0FBRWQyRSxpQkFBT29GO0FBRk8sU0FBaEI7O0FBS0EsYUFBS2hELGdCQUFMLENBQ0U7QUFDRTBDLG1CQUFTSTtBQURYLFNBREYsRUFJRTtBQUFBLGlCQUFNTCxtQkFBbUJBLGdCQUFnQkssVUFBaEIsRUFBNEJ0QixLQUE1QixDQUF6QjtBQUFBLFNBSkY7QUFNRDtBQW5wQlU7QUFBQTtBQUFBLHNDQXFwQk1BLEtBcnBCTixFQXFwQmE7QUFDdEJBLGNBQU1FLGVBQU47QUFDQSxZQUFNRCxVQUFVRCxNQUFNdUIsSUFBTixLQUFlLFVBQWYsSUFBNkJ2QixNQUFNdUIsSUFBTixLQUFlLGFBQTVEOztBQUVBLFlBQUl0QixPQUFKLEVBQWE7QUFDWFksbUJBQVNZLG1CQUFULENBQTZCLFdBQTdCLEVBQTBDLEtBQUtWLGtCQUEvQztBQUNBRixtQkFBU1ksbUJBQVQsQ0FBNkIsYUFBN0IsRUFBNEMsS0FBS1QsZUFBakQ7QUFDQUgsbUJBQVNZLG1CQUFULENBQTZCLFVBQTdCLEVBQXlDLEtBQUtULGVBQTlDO0FBQ0Q7O0FBRUQ7QUFDQTtBQUNBSCxpQkFBU1ksbUJBQVQsQ0FBNkIsV0FBN0IsRUFBMEMsS0FBS1Ysa0JBQS9DO0FBQ0FGLGlCQUFTWSxtQkFBVCxDQUE2QixTQUE3QixFQUF3QyxLQUFLVCxlQUE3QztBQUNBSCxpQkFBU1ksbUJBQVQsQ0FBNkIsWUFBN0IsRUFBMkMsS0FBS1QsZUFBaEQ7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsWUFBSSxDQUFDZixPQUFMLEVBQWM7QUFDWixlQUFLekIsZ0JBQUwsQ0FBc0I7QUFDcEJPLDBCQUFjLElBRE07QUFFcEI0QiwrQkFBbUI7QUFGQyxXQUF0QjtBQUlEO0FBQ0Y7QUE5cUJVOztBQUFBO0FBQUEsSUFDQ2UsSUFERDtBQUFBLEMiLCJmaWxlIjoibWV0aG9kcy5qcyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCdcbmltcG9ydCBfIGZyb20gJy4vdXRpbHMnXG5cbmV4cG9ydCBkZWZhdWx0IEJhc2UgPT5cbiAgY2xhc3MgZXh0ZW5kcyBCYXNlIHtcbiAgICBnZXRSZXNvbHZlZFN0YXRlIChwcm9wcywgc3RhdGUpIHtcbiAgICAgIGNvbnN0IHJlc29sdmVkU3RhdGUgPSB7XG4gICAgICAgIC4uLl8uY29tcGFjdE9iamVjdCh0aGlzLnN0YXRlKSxcbiAgICAgICAgLi4uXy5jb21wYWN0T2JqZWN0KHRoaXMucHJvcHMpLFxuICAgICAgICAuLi5fLmNvbXBhY3RPYmplY3Qoc3RhdGUpLFxuICAgICAgICAuLi5fLmNvbXBhY3RPYmplY3QocHJvcHMpLFxuICAgICAgfVxuICAgICAgcmV0dXJuIHJlc29sdmVkU3RhdGVcbiAgICB9XG5cbiAgICBnZXREYXRhTW9kZWwgKG5ld1N0YXRlLCBkYXRhQ2hhbmdlZCkge1xuICAgICAgY29uc3Qge1xuICAgICAgICBjb2x1bW5zLFxuICAgICAgICBwaXZvdEJ5ID0gW10sXG4gICAgICAgIGRhdGEsXG4gICAgICAgIHJlc29sdmVEYXRhLFxuICAgICAgICBwaXZvdElES2V5LFxuICAgICAgICBwaXZvdFZhbEtleSxcbiAgICAgICAgc3ViUm93c0tleSxcbiAgICAgICAgYWdncmVnYXRlZEtleSxcbiAgICAgICAgbmVzdGluZ0xldmVsS2V5LFxuICAgICAgICBvcmlnaW5hbEtleSxcbiAgICAgICAgaW5kZXhLZXksXG4gICAgICAgIGdyb3VwZWRCeVBpdm90S2V5LFxuICAgICAgICBTdWJDb21wb25lbnQsXG4gICAgICB9ID0gbmV3U3RhdGVcblxuICAgICAgLy8gRGV0ZXJtaW5lIGlmIHRoZXJlIGFyZSBIZWFkZXIgR3JvdXBzXG4gICAgICBjb25zdCBoYXNIZWFkZXJHcm91cHMgPSBjb2x1bW5zLnNvbWUoY29sdW1uID0+IGNvbHVtbi5jb2x1bW5zKVxuXG4gICAgICAvLyBGaW5kIHRoZSBleHBhbmRlciBjb2x1bW4gd2hpY2ggY291bGQgYmUgZGVlcCBpbiB0cmVlIG9mIGNvbHVtbnNcbiAgICAgIGNvbnN0IGFsbENvbHVtbnMgPSBfLml0ZXJUcmVlKGNvbHVtbnMsICdjb2x1bW5zJylcbiAgICAgIGNvbnN0IGV4cGFuZGVyQ29sdW1uID0gXy5nZXRGaXJzdERlZmluZWQoYWxsQ29sdW1ucylcblxuICAgICAgLy8gSWYgd2UgaGF2ZSBTdWJDb21wb25lbnQncyB3ZSBuZWVkIHRvIG1ha2Ugc3VyZSB3ZSBoYXZlIGFuIGV4cGFuZGVyIGNvbHVtblxuICAgICAgY29uc3QgaGFzU3ViQ29tcG9uZW50QW5kTm9FeHBhbmRlckNvbHVtbiA9IFN1YkNvbXBvbmVudCAmJiAhZXhwYW5kZXJDb2x1bW5cbiAgICAgIGNvbnN0IGNvbHVtbnNXaXRoRXhwYW5kZXIgPSBoYXNTdWJDb21wb25lbnRBbmROb0V4cGFuZGVyQ29sdW1uXG4gICAgICAgID8gW3sgZXhwYW5kZXI6IHRydWUgfSwgLi4uY29sdW1uc11cbiAgICAgICAgOiBbLi4uY29sdW1uc11cblxuICAgICAgY29uc3QgbWFrZURlY29yYXRlZENvbHVtbiA9IChjb2x1bW4sIHBhcmVudENvbHVtbikgPT4ge1xuICAgICAgICBsZXQgZGNvbFxuICAgICAgICBpZiAoY29sdW1uLmV4cGFuZGVyKSB7XG4gICAgICAgICAgZGNvbCA9IHtcbiAgICAgICAgICAgIC4uLnRoaXMucHJvcHMuY29sdW1uLFxuICAgICAgICAgICAgLi4udGhpcy5wcm9wcy5leHBhbmRlckRlZmF1bHRzLFxuICAgICAgICAgICAgLi4uY29sdW1uLFxuICAgICAgICAgIH1cbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICBkY29sID0ge1xuICAgICAgICAgICAgLi4udGhpcy5wcm9wcy5jb2x1bW4sXG4gICAgICAgICAgICAuLi50aGlzLnByb3BzLmNvbHVtbixcbiAgICAgICAgICAgIC4uLmNvbHVtbixcbiAgICAgICAgICB9XG4gICAgICAgIH1cblxuICAgICAgICAvLyBFbnN1cmUgbWluV2lkdGggaXMgbm90IGdyZWF0ZXIgdGhhbiBtYXhXaWR0aCBpZiBzZXRcbiAgICAgICAgaWYgKGRjb2wubWF4V2lkdGggPCBkY29sLm1pbldpZHRoKSB7XG4gICAgICAgICAgZGNvbC5taW5XaWR0aCA9IGRjb2wubWF4V2lkdGhcbiAgICAgICAgfVxuXG4gICAgICAgIGlmIChwYXJlbnRDb2x1bW4pIHtcbiAgICAgICAgICBkY29sLnBhcmVudENvbHVtbiA9IHBhcmVudENvbHVtblxuICAgICAgICB9XG5cbiAgICAgICAgLy8gRmlyc3QgY2hlY2sgZm9yIHN0cmluZyBhY2Nlc3NvclxuICAgICAgICBpZiAodHlwZW9mIGRjb2wuYWNjZXNzb3IgPT09ICdzdHJpbmcnKSB7XG4gICAgICAgICAgZGNvbC5pZCA9IGRjb2wuaWQgfHwgZGNvbC5hY2Nlc3NvclxuICAgICAgICAgIGNvbnN0IGFjY2Vzc29yU3RyaW5nID0gZGNvbC5hY2Nlc3NvclxuICAgICAgICAgIGRjb2wuYWNjZXNzb3IgPSByb3cgPT4gXy5nZXQocm93LCBhY2Nlc3NvclN0cmluZylcbiAgICAgICAgICByZXR1cm4gZGNvbFxuICAgICAgICB9XG5cbiAgICAgICAgLy8gRmFsbCBiYWNrIHRvIGZ1bmN0aW9uYWwgYWNjZXNzb3IgKGJ1dCByZXF1aXJlIGFuIElEKVxuICAgICAgICBpZiAoZGNvbC5hY2Nlc3NvciAmJiAhZGNvbC5pZCkge1xuICAgICAgICAgIGNvbnNvbGUud2FybihkY29sKVxuICAgICAgICAgIHRocm93IG5ldyBFcnJvcihcbiAgICAgICAgICAgICdBIGNvbHVtbiBpZCBpcyByZXF1aXJlZCBpZiB1c2luZyBhIG5vbi1zdHJpbmcgYWNjZXNzb3IgZm9yIGNvbHVtbiBhYm92ZS4nXG4gICAgICAgICAgKVxuICAgICAgICB9XG5cbiAgICAgICAgLy8gRmFsbCBiYWNrIHRvIGFuIHVuZGVmaW5lZCBhY2Nlc3NvclxuICAgICAgICBpZiAoIWRjb2wuYWNjZXNzb3IpIHtcbiAgICAgICAgICBkY29sLmFjY2Vzc29yID0gKCkgPT4gdW5kZWZpbmVkXG4gICAgICAgIH1cblxuICAgICAgICByZXR1cm4gZGNvbFxuICAgICAgfVxuXG4gICAgICBjb25zdCBhbGxEZWNvcmF0ZWRDb2x1bW5zID0gW11cblxuICAgICAgLy8gRGVjb3JhdGUgdGhlIGNvbHVtbnNcbiAgICAgIGNvbnN0IGRlY29yYXRlQW5kQWRkVG9BbGwgPSAoY29sdW1ucywgcGFyZW50Q29sdW1uKSA9PiBjb2x1bW5zLm1hcChjb2x1bW4gPT4ge1xuICAgICAgICBjb25zdCBkZWNvcmF0ZWRDb2x1bW4gPSBtYWtlRGVjb3JhdGVkQ29sdW1uKGNvbHVtbiwgcGFyZW50Q29sdW1uKVxuICAgICAgICBpZiAoY29sdW1uLmNvbHVtbnMpIHtcbiAgICAgICAgICBkZWNvcmF0ZWRDb2x1bW4uY29sdW1ucyA9IGRlY29yYXRlQW5kQWRkVG9BbGwoY29sdW1uLmNvbHVtbnMsIGNvbHVtbilcbiAgICAgICAgfVxuXG4gICAgICAgIGFsbERlY29yYXRlZENvbHVtbnMucHVzaChkZWNvcmF0ZWRDb2x1bW4pXG4gICAgICAgIHJldHVybiBkZWNvcmF0ZWRDb2x1bW5cbiAgICAgIH0pXG5cbiAgICAgIGNvbnN0IGRlY29yYXRlZENvbHVtbnMgPSBkZWNvcmF0ZUFuZEFkZFRvQWxsKGNvbHVtbnNXaXRoRXhwYW5kZXIpXG4gICAgICBjb25zdCBtYXBWaXNpYmxlQ29sdW1ucyA9IGNvbHVtbnMgPT4gY29sdW1ucy5tYXAoY29sdW1uID0+IHtcbiAgICAgICAgaWYgKGNvbHVtbi5jb2x1bW5zKSB7XG4gICAgICAgICAgY29uc3QgdmlzaWJsZVN1YkNvbHVtbnMgPSBjb2x1bW4uY29sdW1ucy5maWx0ZXIoXG4gICAgICAgICAgICBkID0+IChwaXZvdEJ5LmluZGV4T2YoZC5pZCkgPiAtMSA/IGZhbHNlIDogXy5nZXRGaXJzdERlZmluZWQoZC5zaG93LCB0cnVlKSlcbiAgICAgICAgICApXG4gICAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIC4uLmNvbHVtbixcbiAgICAgICAgICAgIGNvbHVtbnM6IG1hcFZpc2libGVDb2x1bW5zKHZpc2libGVTdWJDb2x1bW5zKSxcbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIGNvbHVtblxuICAgICAgfSlcblxuICAgICAgY29uc3QgZmlsdGVyVmlzaWJsZUNvbHVtbnMgPSBjb2x1bW5zID0+IGNvbHVtbnMuZmlsdGVyKFxuICAgICAgICBjb2x1bW4gPT5cbiAgICAgICAgICBjb2x1bW4uY29sdW1uc1xuICAgICAgICAgICAgPyBjb2x1bW4uY29sdW1ucy5sZW5ndGhcbiAgICAgICAgICAgIDogcGl2b3RCeS5pbmRleE9mKGNvbHVtbi5pZCkgPiAtMVxuICAgICAgICAgICAgICA/IGZhbHNlXG4gICAgICAgICAgICAgIDogXy5nZXRGaXJzdERlZmluZWQoY29sdW1uLnNob3csIHRydWUpXG4gICAgICApXG5cbiAgICAgIC8vIEJ1aWxkIHRoZSBmdWxsIGFycmF5IG9mIHZpc2libGUgY29sdW1ucyAtIHRoaXMgaXMgYW4gYXJyYXkgdGhhdCBjb250YWlucyBhbGwgY29sdW1ucyB0aGF0XG4gICAgICAvLyBhcmUgbm90IGhpZGRlbiB2aWEgcGl2b3RpbmdcbiAgICAgIGNvbnN0IGFsbFZpc2libGVDb2x1bW5zID0gZmlsdGVyVmlzaWJsZUNvbHVtbnMobWFwVmlzaWJsZUNvbHVtbnMoZGVjb3JhdGVkQ29sdW1ucy5zbGljZSgpKSlcblxuICAgICAgLy8gRmluZCBhbnkgY3VzdG9tIHBpdm90IGxvY2F0aW9uXG4gICAgICBjb25zdCBwaXZvdEluZGV4ID0gYWxsVmlzaWJsZUNvbHVtbnMuZmluZEluZGV4KGNvbCA9PiBjb2wucGl2b3QpXG5cbiAgICAgIC8vIEhhbmRsZSBQaXZvdCBDb2x1bW5zXG4gICAgICBpZiAocGl2b3RCeS5sZW5ndGgpIHtcbiAgICAgICAgLy8gUmV0cmlldmUgdGhlIHBpdm90IGNvbHVtbnMgaW4gdGhlIGNvcnJlY3QgcGl2b3Qgb3JkZXJcbiAgICAgICAgY29uc3QgcGl2b3RDb2x1bW5zID0gW11cbiAgICAgICAgcGl2b3RCeS5mb3JFYWNoKHBpdm90SUQgPT4ge1xuICAgICAgICAgIGNvbnN0IGZvdW5kID0gYWxsRGVjb3JhdGVkQ29sdW1ucy5maW5kKGQgPT4gZC5pZCA9PT0gcGl2b3RJRClcbiAgICAgICAgICBpZiAoZm91bmQpIHtcbiAgICAgICAgICAgIHBpdm90Q29sdW1ucy5wdXNoKGZvdW5kKVxuICAgICAgICAgIH1cbiAgICAgICAgfSlcblxuICAgICAgICBjb25zdCBQaXZvdFBhcmVudENvbHVtbiA9IHBpdm90Q29sdW1ucy5yZWR1Y2UoXG4gICAgICAgICAgKHByZXYsIGN1cnJlbnQpID0+IHByZXYgJiYgcHJldiA9PT0gY3VycmVudC5wYXJlbnRDb2x1bW4gJiYgY3VycmVudC5wYXJlbnRDb2x1bW4sXG4gICAgICAgICAgcGl2b3RDb2x1bW5zWzBdLnBhcmVudENvbHVtblxuICAgICAgICApXG5cbiAgICAgICAgbGV0IFBpdm90R3JvdXBIZWFkZXIgPSBoYXNIZWFkZXJHcm91cHMgJiYgUGl2b3RQYXJlbnRDb2x1bW4uSGVhZGVyXG4gICAgICAgIFBpdm90R3JvdXBIZWFkZXIgPSBQaXZvdEdyb3VwSGVhZGVyIHx8ICgoKSA9PiA8c3Ryb25nPlBpdm90ZWQ8L3N0cm9uZz4pXG5cbiAgICAgICAgbGV0IHBpdm90Q29sdW1uR3JvdXAgPSB7XG4gICAgICAgICAgSGVhZGVyOiBQaXZvdEdyb3VwSGVhZGVyLFxuICAgICAgICAgIGNvbHVtbnM6IHBpdm90Q29sdW1ucy5tYXAoY29sID0+ICh7XG4gICAgICAgICAgICAuLi50aGlzLnByb3BzLnBpdm90RGVmYXVsdHMsXG4gICAgICAgICAgICAuLi5jb2wsXG4gICAgICAgICAgICBwaXZvdGVkOiB0cnVlLFxuICAgICAgICAgIH0pKSxcbiAgICAgICAgfVxuXG4gICAgICAgIC8vIFBsYWNlIHRoZSBwaXZvdENvbHVtbnMgYmFjayBpbnRvIHRoZSB2aXNpYmxlQ29sdW1uc1xuICAgICAgICBpZiAocGl2b3RJbmRleCA+PSAwKSB7XG4gICAgICAgICAgcGl2b3RDb2x1bW5Hcm91cCA9IHtcbiAgICAgICAgICAgIC4uLmFsbFZpc2libGVDb2x1bW5zW3Bpdm90SW5kZXhdLFxuICAgICAgICAgICAgLi4ucGl2b3RDb2x1bW5Hcm91cCxcbiAgICAgICAgICB9XG4gICAgICAgICAgYWxsVmlzaWJsZUNvbHVtbnMuc3BsaWNlKHBpdm90SW5kZXgsIDEsIHBpdm90Q29sdW1uR3JvdXApXG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgYWxsVmlzaWJsZUNvbHVtbnMudW5zaGlmdChwaXZvdENvbHVtbkdyb3VwKVxuICAgICAgICB9XG4gICAgICB9XG5cbiAgICAgIC8vIEJ1aWxkIFZpc2libGUgQ29sdW1ucyBhbmQgSGVhZGVyIEdyb3Vwc1xuICAgICAgY29uc3QgYWxsQ29sdW1uSGVhZGVycyA9IFtdXG5cbiAgICAgIGNvbnN0IGFkZEhlYWRlciA9IGNvbHVtbiA9PiB7XG4gICAgICAgIGxldCBsZXZlbCA9IDBcblxuICAgICAgICAvLyBJZiB0aGlzIGNvbHVtbiBoYXMgY2hpbGRyZW4sIHB1c2ggdGhlbSBmaXJzdCBhbmQgYWRkIHRoaXMgY29sdW1uIHRvIHRoZSBuZXh0IGxldmVsXG4gICAgICAgIGlmIChjb2x1bW4uY29sdW1ucykge1xuICAgICAgICAgIGNvbnN0IGNoaWxkTGV2ZWxzID0gY29sdW1uLmNvbHVtbnMubWFwKGFkZEhlYWRlcilcbiAgICAgICAgICBsZXZlbCA9IE1hdGgubWF4KC4uLmNoaWxkTGV2ZWxzKSArIDFcbiAgICAgICAgfVxuXG4gICAgICAgIC8vIEFkZCBzcGFucyBhYm92ZSBjb2x1bW5zIHdpdGhvdXQgcGFyZW50cyAob3JwaGFucykgdG8gZmlsbCB0aGUgc3BhY2UgYWJvdmUgdGhlbVxuICAgICAgICBpZiAoYWxsQ29sdW1uSGVhZGVycy5sZW5ndGggPD0gbGV2ZWwpIGFsbENvbHVtbkhlYWRlcnMucHVzaChbXSlcbiAgICAgICAgaWYgKGxldmVsID4gMCkge1xuICAgICAgICAgIC8vIFRoZSBzcGFucyBuZWVkIHRvIGNvbnRhaW4gdGhlIHNoaWZ0ZWQgaGVhZGVycyBhcyBjaGlsZHJlbi4gVGhpcyBmaW5kcyBhbGwgb2YgdGhlXG4gICAgICAgICAgLy8gY29sdW1ucyBpbiB0aGUgbG93ZXIgbGV2ZWwgYmV0d2VlbiB0aGUgZmlyc3QgY2hpbGQgb2YgdGhpcyBjb2x1bW4gYW5kIHRoZSBsYXN0IGNoaWxkXG4gICAgICAgICAgLy8gb2YgdGhlIHByZWNlZGluZyBjb2x1bW4gKGlmIHRoZXJlIGlzIG9uZSlcbiAgICAgICAgICBjb25zdCBsb3dlckxldmVsID0gYWxsQ29sdW1uSGVhZGVyc1tsZXZlbCAtIDFdXG4gICAgICAgICAgY29uc3QgcHJlY2VkaW5nQ29sdW1uID0gXy5sYXN0KGFsbENvbHVtbkhlYWRlcnNbbGV2ZWxdKVxuXG4gICAgICAgICAgY29uc3QgaW5kZXhPZkZpcnN0Q2hpbGRJbkxvd2VyTGV2ZWwgPSBsb3dlckxldmVsLmluZGV4T2YoY29sdW1uLmNvbHVtbnNbMF0pXG4gICAgICAgICAgY29uc3QgaW5kZXhBZnRlckxhc3RDaGlsZEluUHJlY2VkaW5nQ29sdW1uID0gcHJlY2VkaW5nQ29sdW1uXG4gICAgICAgICAgICA/IGxvd2VyTGV2ZWwuaW5kZXhPZihfLmxhc3QocHJlY2VkaW5nQ29sdW1uLmNvbHVtbnMpKSArIDFcbiAgICAgICAgICAgIDogMFxuXG4gICAgICAgICAgLy8gSWYgdGhlcmUgYXJlIG9waGFucywgYWRkIGEgc3BhbiBhYm92ZSB0aGVtXG4gICAgICAgICAgY29uc3Qgb3JwaGFucyA9IGxvd2VyTGV2ZWwuc2xpY2UoXG4gICAgICAgICAgICBpbmRleEFmdGVyTGFzdENoaWxkSW5QcmVjZWRpbmdDb2x1bW4sXG4gICAgICAgICAgICBpbmRleE9mRmlyc3RDaGlsZEluTG93ZXJMZXZlbFxuICAgICAgICAgIClcblxuICAgICAgICAgIGlmIChvcnBoYW5zLmxlbmd0aCkge1xuICAgICAgICAgICAgYWxsQ29sdW1uSGVhZGVyc1tsZXZlbF0ucHVzaCh7XG4gICAgICAgICAgICAgIC4uLnRoaXMucHJvcHMuY29sdW1uLFxuICAgICAgICAgICAgICBjb2x1bW5zOiBvcnBoYW5zLFxuICAgICAgICAgICAgfSlcbiAgICAgICAgICB9XG4gICAgICAgIH1cblxuICAgICAgICBhbGxDb2x1bW5IZWFkZXJzW2xldmVsXS5wdXNoKGNvbHVtbilcblxuICAgICAgICByZXR1cm4gbGV2ZWxcbiAgICAgIH1cblxuICAgICAgYWxsVmlzaWJsZUNvbHVtbnMuZm9yRWFjaChhZGRIZWFkZXIpXG5cbiAgICAgIC8vIHZpc2libGVDb2x1bW5zIGlzIGFuIGFycmF5IGNvbnRhaW5pbmcgY29sdW1uIGRlZmluaXRpb25zIGZvciB0aGUgYm90dG9tIHJvdyBvZiBUSCBlbGVtZW50c1xuICAgICAgY29uc3QgdmlzaWJsZUNvbHVtbnMgPSBhbGxDb2x1bW5IZWFkZXJzLnNoaWZ0KClcbiAgICAgIGNvbnN0IGhlYWRlckdyb3VwcyA9IGFsbENvbHVtbkhlYWRlcnMucmV2ZXJzZSgpXG5cbiAgICAgIC8vIEFjY2VzcyB0aGUgZGF0YVxuICAgICAgY29uc3QgYWNjZXNzUm93ID0gKGQsIGksIGxldmVsID0gMCkgPT4ge1xuICAgICAgICBjb25zdCByb3cgPSB7XG4gICAgICAgICAgW29yaWdpbmFsS2V5XTogZCxcbiAgICAgICAgICBbaW5kZXhLZXldOiBpLFxuICAgICAgICAgIFtzdWJSb3dzS2V5XTogZFtzdWJSb3dzS2V5XSxcbiAgICAgICAgICBbbmVzdGluZ0xldmVsS2V5XTogbGV2ZWwsXG4gICAgICAgIH1cbiAgICAgICAgYWxsRGVjb3JhdGVkQ29sdW1ucy5mb3JFYWNoKGNvbHVtbiA9PiB7XG4gICAgICAgICAgaWYgKGNvbHVtbi5leHBhbmRlcikgcmV0dXJuXG4gICAgICAgICAgcm93W2NvbHVtbi5pZF0gPSBjb2x1bW4uYWNjZXNzb3IoZClcbiAgICAgICAgfSlcbiAgICAgICAgaWYgKHJvd1tzdWJSb3dzS2V5XSkge1xuICAgICAgICAgIHJvd1tzdWJSb3dzS2V5XSA9IHJvd1tzdWJSb3dzS2V5XS5tYXAoKGQsIGkpID0+IGFjY2Vzc1JvdyhkLCBpLCBsZXZlbCArIDEpKVxuICAgICAgICB9XG4gICAgICAgIHJldHVybiByb3dcbiAgICAgIH1cblxuICAgICAgLy8gLy8gSWYgdGhlIGRhdGEgaGFzbid0IGNoYW5nZWQsIGp1c3QgdXNlIHRoZSBjYWNoZWQgZGF0YVxuICAgICAgbGV0IHJlc29sdmVkRGF0YSA9IHRoaXMucmVzb2x2ZWREYXRhXG4gICAgICAvLyBJZiB0aGUgZGF0YSBoYXMgY2hhbmdlZCwgcnVuIHRoZSBkYXRhIHJlc29sdmVyIGFuZCBjYWNoZSB0aGUgcmVzdWx0XG4gICAgICBpZiAoIXRoaXMucmVzb2x2ZWREYXRhIHx8IGRhdGFDaGFuZ2VkKSB7XG4gICAgICAgIHJlc29sdmVkRGF0YSA9IHJlc29sdmVEYXRhKGRhdGEpXG4gICAgICAgIHRoaXMucmVzb2x2ZWREYXRhID0gcmVzb2x2ZWREYXRhXG4gICAgICB9XG4gICAgICAvLyBVc2UgdGhlIHJlc29sdmVkIGRhdGFcbiAgICAgIHJlc29sdmVkRGF0YSA9IHJlc29sdmVkRGF0YS5tYXAoKGQsIGkpID0+IGFjY2Vzc1JvdyhkLCBpKSlcblxuICAgICAgLy8gVE9ETzogTWFrZSBpdCBwb3NzaWJsZSB0byBmYWJyaWNhdGUgbmVzdGVkIHJvd3Mgd2l0aG91dCBwaXZvdGluZ1xuICAgICAgY29uc3QgYWdncmVnYXRpbmdDb2x1bW5zID0gdmlzaWJsZUNvbHVtbnMuZmlsdGVyKGQgPT4gIWQuZXhwYW5kZXIgJiYgZC5hZ2dyZWdhdGUpXG5cbiAgICAgIC8vIElmIHBpdm90aW5nLCByZWN1cnNpdmVseSBncm91cCB0aGUgZGF0YVxuICAgICAgY29uc3QgYWdncmVnYXRlID0gcm93cyA9PiB7XG4gICAgICAgIGNvbnN0IGFnZ3JlZ2F0aW9uVmFsdWVzID0ge31cbiAgICAgICAgYWdncmVnYXRpbmdDb2x1bW5zLmZvckVhY2goY29sdW1uID0+IHtcbiAgICAgICAgICBjb25zdCB2YWx1ZXMgPSByb3dzLm1hcChkID0+IGRbY29sdW1uLmlkXSlcbiAgICAgICAgICBhZ2dyZWdhdGlvblZhbHVlc1tjb2x1bW4uaWRdID0gY29sdW1uLmFnZ3JlZ2F0ZSh2YWx1ZXMsIHJvd3MpXG4gICAgICAgIH0pXG4gICAgICAgIHJldHVybiBhZ2dyZWdhdGlvblZhbHVlc1xuICAgICAgfVxuICAgICAgaWYgKHBpdm90QnkubGVuZ3RoKSB7XG4gICAgICAgIGNvbnN0IGdyb3VwUmVjdXJzaXZlbHkgPSAocm93cywga2V5cywgaSA9IDApID0+IHtcbiAgICAgICAgICAvLyBUaGlzIGlzIHRoZSBsYXN0IGxldmVsLCBqdXN0IHJldHVybiB0aGUgcm93c1xuICAgICAgICAgIGlmIChpID09PSBrZXlzLmxlbmd0aCkge1xuICAgICAgICAgICAgcmV0dXJuIHJvd3NcbiAgICAgICAgICB9XG4gICAgICAgICAgLy8gR3JvdXAgdGhlIHJvd3MgdG9nZXRoZXIgZm9yIHRoaXMgbGV2ZWxcbiAgICAgICAgICBsZXQgZ3JvdXBlZFJvd3MgPSBPYmplY3QuZW50cmllcyhfLmdyb3VwQnkocm93cywga2V5c1tpXSkpLm1hcCgoW2tleSwgdmFsdWVdKSA9PiAoe1xuICAgICAgICAgICAgW3Bpdm90SURLZXldOiBrZXlzW2ldLFxuICAgICAgICAgICAgW3Bpdm90VmFsS2V5XToga2V5LFxuICAgICAgICAgICAgW2tleXNbaV1dOiBrZXksXG4gICAgICAgICAgICBbc3ViUm93c0tleV06IHZhbHVlLFxuICAgICAgICAgICAgW25lc3RpbmdMZXZlbEtleV06IGksXG4gICAgICAgICAgICBbZ3JvdXBlZEJ5UGl2b3RLZXldOiB0cnVlLFxuICAgICAgICAgIH0pKVxuICAgICAgICAgIC8vIFJlY3Vyc2UgaW50byB0aGUgc3ViUm93c1xuICAgICAgICAgIGdyb3VwZWRSb3dzID0gZ3JvdXBlZFJvd3MubWFwKHJvd0dyb3VwID0+IHtcbiAgICAgICAgICAgIGNvbnN0IHN1YlJvd3MgPSBncm91cFJlY3Vyc2l2ZWx5KHJvd0dyb3VwW3N1YlJvd3NLZXldLCBrZXlzLCBpICsgMSlcbiAgICAgICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICAgIC4uLnJvd0dyb3VwLFxuICAgICAgICAgICAgICBbc3ViUm93c0tleV06IHN1YlJvd3MsXG4gICAgICAgICAgICAgIFthZ2dyZWdhdGVkS2V5XTogdHJ1ZSxcbiAgICAgICAgICAgICAgLi4uYWdncmVnYXRlKHN1YlJvd3MpLFxuICAgICAgICAgICAgfVxuICAgICAgICAgIH0pXG4gICAgICAgICAgcmV0dXJuIGdyb3VwZWRSb3dzXG4gICAgICAgIH1cbiAgICAgICAgcmVzb2x2ZWREYXRhID0gZ3JvdXBSZWN1cnNpdmVseShyZXNvbHZlZERhdGEsIHBpdm90QnkpXG4gICAgICB9XG5cbiAgICAgIHJldHVybiB7XG4gICAgICAgIC4uLm5ld1N0YXRlLFxuICAgICAgICByZXNvbHZlZERhdGEsXG4gICAgICAgIHZpc2libGVDb2x1bW5zLFxuICAgICAgICBoZWFkZXJHcm91cHMsXG4gICAgICAgIGFsbERlY29yYXRlZENvbHVtbnMsXG4gICAgICAgIGhhc0hlYWRlckdyb3VwcyxcbiAgICAgIH1cbiAgICB9XG5cbiAgICBnZXRTb3J0ZWREYXRhIChyZXNvbHZlZFN0YXRlKSB7XG4gICAgICBjb25zdCB7XG4gICAgICAgIG1hbnVhbCxcbiAgICAgICAgc29ydGVkLFxuICAgICAgICBmaWx0ZXJlZCxcbiAgICAgICAgZGVmYXVsdEZpbHRlck1ldGhvZCxcbiAgICAgICAgcmVzb2x2ZWREYXRhLFxuICAgICAgICBhbGxEZWNvcmF0ZWRDb2x1bW5zLFxuICAgICAgfSA9IHJlc29sdmVkU3RhdGVcblxuICAgICAgY29uc3Qgc29ydE1ldGhvZHNCeUNvbHVtbklEID0ge31cblxuICAgICAgYWxsRGVjb3JhdGVkQ29sdW1ucy5maWx0ZXIoY29sID0+IGNvbC5zb3J0TWV0aG9kKS5mb3JFYWNoKGNvbCA9PiB7XG4gICAgICAgIHNvcnRNZXRob2RzQnlDb2x1bW5JRFtjb2wuaWRdID0gY29sLnNvcnRNZXRob2RcbiAgICAgIH0pXG5cbiAgICAgIC8vIFJlc29sdmUgdGhlIGRhdGEgZnJvbSBlaXRoZXIgbWFudWFsIGRhdGEgb3Igc29ydGVkIGRhdGFcbiAgICAgIHJldHVybiB7XG4gICAgICAgIHNvcnRlZERhdGE6IG1hbnVhbFxuICAgICAgICAgID8gcmVzb2x2ZWREYXRhXG4gICAgICAgICAgOiB0aGlzLnNvcnREYXRhKFxuICAgICAgICAgICAgdGhpcy5maWx0ZXJEYXRhKHJlc29sdmVkRGF0YSwgZmlsdGVyZWQsIGRlZmF1bHRGaWx0ZXJNZXRob2QsIGFsbERlY29yYXRlZENvbHVtbnMpLFxuICAgICAgICAgICAgc29ydGVkLFxuICAgICAgICAgICAgc29ydE1ldGhvZHNCeUNvbHVtbklEXG4gICAgICAgICAgKSxcbiAgICAgIH1cbiAgICB9XG5cbiAgICBmaXJlRmV0Y2hEYXRhICgpIHtcbiAgICAgIC8vIGRldGVybWluZSB0aGUgY3VycmVudCBzdGF0ZSwgcHJlZmVycmluZyBjZXJ0YWluIHN0YXRlIHZhbHVlcyBvdmVyIHByb3BzXG4gICAgICBjb25zdCBjdXJyZW50U3RhdGUgPSB7XG4gICAgICAgIC4uLnRoaXMuZ2V0UmVzb2x2ZWRTdGF0ZSgpLFxuICAgICAgICBwYWdlOiB0aGlzLmdldFN0YXRlT3JQcm9wKCdwYWdlJyksXG4gICAgICAgIHBhZ2VTaXplOiB0aGlzLmdldFN0YXRlT3JQcm9wKCdwYWdlU2l6ZScpLFxuICAgICAgICBmaWx0ZXI6IHRoaXMuZ2V0U3RhdGVPclByb3AoJ2ZpbHRlcicpLFxuICAgICAgfVxuXG4gICAgICB0aGlzLnByb3BzLm9uRmV0Y2hEYXRhKGN1cnJlbnRTdGF0ZSwgdGhpcylcbiAgICB9XG5cbiAgICBnZXRQcm9wT3JTdGF0ZSAoa2V5KSB7XG4gICAgICByZXR1cm4gXy5nZXRGaXJzdERlZmluZWQodGhpcy5wcm9wc1trZXldLCB0aGlzLnN0YXRlW2tleV0pXG4gICAgfVxuXG4gICAgZ2V0U3RhdGVPclByb3AgKGtleSkge1xuICAgICAgcmV0dXJuIF8uZ2V0Rmlyc3REZWZpbmVkKHRoaXMuc3RhdGVba2V5XSwgdGhpcy5wcm9wc1trZXldKVxuICAgIH1cblxuICAgIGZpbHRlckRhdGEgKGRhdGEsIGZpbHRlcmVkLCBkZWZhdWx0RmlsdGVyTWV0aG9kLCB2aXNpYmxlQ29sdW1ucykge1xuICAgICAgbGV0IGZpbHRlcmVkRGF0YSA9IGRhdGFcblxuICAgICAgaWYgKGZpbHRlcmVkLmxlbmd0aCkge1xuICAgICAgICBmaWx0ZXJlZERhdGEgPSBmaWx0ZXJlZC5yZWR1Y2UoKGZpbHRlcmVkU29GYXIsIG5leHRGaWx0ZXIpID0+IHtcbiAgICAgICAgICBjb25zdCBjb2x1bW4gPSB2aXNpYmxlQ29sdW1ucy5maW5kKHggPT4geC5pZCA9PT0gbmV4dEZpbHRlci5pZClcblxuICAgICAgICAgIC8vIERvbid0IGZpbHRlciBoaWRkZW4gY29sdW1ucyBvciBjb2x1bW5zIHRoYXQgaGF2ZSBoYWQgdGhlaXIgZmlsdGVycyBkaXNhYmxlZFxuICAgICAgICAgIGlmICghY29sdW1uIHx8IGNvbHVtbi5maWx0ZXJhYmxlID09PSBmYWxzZSkge1xuICAgICAgICAgICAgcmV0dXJuIGZpbHRlcmVkU29GYXJcbiAgICAgICAgICB9XG5cbiAgICAgICAgICBjb25zdCBmaWx0ZXJNZXRob2QgPSBjb2x1bW4uZmlsdGVyTWV0aG9kIHx8IGRlZmF1bHRGaWx0ZXJNZXRob2RcblxuICAgICAgICAgIC8vIElmICdmaWx0ZXJBbGwnIGlzIHNldCB0byB0cnVlLCBwYXNzIHRoZSBlbnRpcmUgZGF0YXNldCB0byB0aGUgZmlsdGVyIG1ldGhvZFxuICAgICAgICAgIGlmIChjb2x1bW4uZmlsdGVyQWxsKSB7XG4gICAgICAgICAgICByZXR1cm4gZmlsdGVyTWV0aG9kKG5leHRGaWx0ZXIsIGZpbHRlcmVkU29GYXIsIGNvbHVtbilcbiAgICAgICAgICB9XG4gICAgICAgICAgcmV0dXJuIGZpbHRlcmVkU29GYXIuZmlsdGVyKHJvdyA9PiBmaWx0ZXJNZXRob2QobmV4dEZpbHRlciwgcm93LCBjb2x1bW4pKVxuICAgICAgICB9LCBmaWx0ZXJlZERhdGEpXG5cbiAgICAgICAgLy8gQXBwbHkgdGhlIGZpbHRlciB0byB0aGUgc3Vicm93cyBpZiB3ZSBhcmUgcGl2b3RpbmcsIGFuZCB0aGVuXG4gICAgICAgIC8vIGZpbHRlciBhbnkgcm93cyB3aXRob3V0IHN1YmNvbHVtbnMgYmVjYXVzZSBpdCB3b3VsZCBiZSBzdHJhbmdlIHRvIHNob3dcbiAgICAgICAgZmlsdGVyZWREYXRhID0gZmlsdGVyZWREYXRhXG4gICAgICAgICAgLm1hcChyb3cgPT4ge1xuICAgICAgICAgICAgaWYgKCFyb3dbdGhpcy5wcm9wcy5zdWJSb3dzS2V5XSkge1xuICAgICAgICAgICAgICByZXR1cm4gcm93XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgICAuLi5yb3csXG4gICAgICAgICAgICAgIFt0aGlzLnByb3BzLnN1YlJvd3NLZXldOiB0aGlzLmZpbHRlckRhdGEoXG4gICAgICAgICAgICAgICAgcm93W3RoaXMucHJvcHMuc3ViUm93c0tleV0sXG4gICAgICAgICAgICAgICAgZmlsdGVyZWQsXG4gICAgICAgICAgICAgICAgZGVmYXVsdEZpbHRlck1ldGhvZCxcbiAgICAgICAgICAgICAgICB2aXNpYmxlQ29sdW1uc1xuICAgICAgICAgICAgICApLFxuICAgICAgICAgICAgfVxuICAgICAgICAgIH0pXG4gICAgICAgICAgLmZpbHRlcihyb3cgPT4ge1xuICAgICAgICAgICAgaWYgKCFyb3dbdGhpcy5wcm9wcy5zdWJSb3dzS2V5XSkge1xuICAgICAgICAgICAgICByZXR1cm4gdHJ1ZVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuIHJvd1t0aGlzLnByb3BzLnN1YlJvd3NLZXldLmxlbmd0aCA+IDBcbiAgICAgICAgICB9KVxuICAgICAgfVxuXG4gICAgICByZXR1cm4gZmlsdGVyZWREYXRhXG4gICAgfVxuXG4gICAgc29ydERhdGEgKGRhdGEsIHNvcnRlZCwgc29ydE1ldGhvZHNCeUNvbHVtbklEID0ge30pIHtcbiAgICAgIGlmICghc29ydGVkLmxlbmd0aCkge1xuICAgICAgICByZXR1cm4gZGF0YVxuICAgICAgfVxuXG4gICAgICBjb25zdCBzb3J0ZWREYXRhID0gKHRoaXMucHJvcHMub3JkZXJCeU1ldGhvZCB8fCBfLm9yZGVyQnkpKFxuICAgICAgICBkYXRhLFxuICAgICAgICBzb3J0ZWQubWFwKHNvcnQgPT4ge1xuICAgICAgICAgIC8vIFN1cHBvcnQgY3VzdG9tIHNvcnRpbmcgbWV0aG9kcyBmb3IgZWFjaCBjb2x1bW5cbiAgICAgICAgICBpZiAoc29ydE1ldGhvZHNCeUNvbHVtbklEW3NvcnQuaWRdKSB7XG4gICAgICAgICAgICByZXR1cm4gKGEsIGIpID0+IHNvcnRNZXRob2RzQnlDb2x1bW5JRFtzb3J0LmlkXShhW3NvcnQuaWRdLCBiW3NvcnQuaWRdLCBzb3J0LmRlc2MpXG4gICAgICAgICAgfVxuICAgICAgICAgIHJldHVybiAoYSwgYikgPT4gdGhpcy5wcm9wcy5kZWZhdWx0U29ydE1ldGhvZChhW3NvcnQuaWRdLCBiW3NvcnQuaWRdLCBzb3J0LmRlc2MpXG4gICAgICAgIH0pLFxuICAgICAgICBzb3J0ZWQubWFwKGQgPT4gIWQuZGVzYyksXG4gICAgICAgIHRoaXMucHJvcHMuaW5kZXhLZXlcbiAgICAgIClcblxuICAgICAgc29ydGVkRGF0YS5mb3JFYWNoKHJvdyA9PiB7XG4gICAgICAgIGlmICghcm93W3RoaXMucHJvcHMuc3ViUm93c0tleV0pIHtcbiAgICAgICAgICByZXR1cm5cbiAgICAgICAgfVxuICAgICAgICByb3dbdGhpcy5wcm9wcy5zdWJSb3dzS2V5XSA9IHRoaXMuc29ydERhdGEoXG4gICAgICAgICAgcm93W3RoaXMucHJvcHMuc3ViUm93c0tleV0sXG4gICAgICAgICAgc29ydGVkLFxuICAgICAgICAgIHNvcnRNZXRob2RzQnlDb2x1bW5JRFxuICAgICAgICApXG4gICAgICB9KVxuXG4gICAgICByZXR1cm4gc29ydGVkRGF0YVxuICAgIH1cblxuICAgIGdldE1pblJvd3MgKCkge1xuICAgICAgcmV0dXJuIF8uZ2V0Rmlyc3REZWZpbmVkKHRoaXMucHJvcHMubWluUm93cywgdGhpcy5nZXRTdGF0ZU9yUHJvcCgncGFnZVNpemUnKSlcbiAgICB9XG5cbiAgICAvLyBVc2VyIGFjdGlvbnNcbiAgICBvblBhZ2VDaGFuZ2UgKHBhZ2UpIHtcbiAgICAgIGNvbnN0IHsgb25QYWdlQ2hhbmdlLCBjb2xsYXBzZU9uUGFnZUNoYW5nZSB9ID0gdGhpcy5wcm9wc1xuXG4gICAgICBjb25zdCBuZXdTdGF0ZSA9IHsgcGFnZSB9XG4gICAgICBpZiAoY29sbGFwc2VPblBhZ2VDaGFuZ2UpIHtcbiAgICAgICAgbmV3U3RhdGUuZXhwYW5kZWQgPSB7fVxuICAgICAgfVxuICAgICAgdGhpcy5zZXRTdGF0ZVdpdGhEYXRhKG5ld1N0YXRlLCAoKSA9PiBvblBhZ2VDaGFuZ2UgJiYgb25QYWdlQ2hhbmdlKHBhZ2UpKVxuICAgIH1cblxuICAgIG9uUGFnZVNpemVDaGFuZ2UgKG5ld1BhZ2VTaXplKSB7XG4gICAgICBjb25zdCB7IG9uUGFnZVNpemVDaGFuZ2UgfSA9IHRoaXMucHJvcHNcbiAgICAgIGNvbnN0IHsgcGFnZVNpemUsIHBhZ2UgfSA9IHRoaXMuZ2V0UmVzb2x2ZWRTdGF0ZSgpXG5cbiAgICAgIC8vIE5vcm1hbGl6ZSB0aGUgcGFnZSB0byBkaXNwbGF5XG4gICAgICBjb25zdCBjdXJyZW50Um93ID0gcGFnZVNpemUgKiBwYWdlXG4gICAgICBjb25zdCBuZXdQYWdlID0gTWF0aC5mbG9vcihjdXJyZW50Um93IC8gbmV3UGFnZVNpemUpXG5cbiAgICAgIHRoaXMuc2V0U3RhdGVXaXRoRGF0YShcbiAgICAgICAge1xuICAgICAgICAgIHBhZ2VTaXplOiBuZXdQYWdlU2l6ZSxcbiAgICAgICAgICBwYWdlOiBuZXdQYWdlLFxuICAgICAgICB9LFxuICAgICAgICAoKSA9PiBvblBhZ2VTaXplQ2hhbmdlICYmIG9uUGFnZVNpemVDaGFuZ2UobmV3UGFnZVNpemUsIG5ld1BhZ2UpXG4gICAgICApXG4gICAgfVxuXG4gICAgc29ydENvbHVtbiAoY29sdW1uLCBhZGRpdGl2ZSkge1xuICAgICAgY29uc3QgeyBzb3J0ZWQsIHNraXBOZXh0U29ydCwgZGVmYXVsdFNvcnREZXNjIH0gPSB0aGlzLmdldFJlc29sdmVkU3RhdGUoKVxuXG4gICAgICBjb25zdCBmaXJzdFNvcnREaXJlY3Rpb24gPSBPYmplY3QucHJvdG90eXBlLmhhc093blByb3BlcnR5LmNhbGwoY29sdW1uLCAnZGVmYXVsdFNvcnREZXNjJylcbiAgICAgICAgPyBjb2x1bW4uZGVmYXVsdFNvcnREZXNjXG4gICAgICAgIDogZGVmYXVsdFNvcnREZXNjXG4gICAgICBjb25zdCBzZWNvbmRTb3J0RGlyZWN0aW9uID0gIWZpcnN0U29ydERpcmVjdGlvblxuXG4gICAgICAvLyB3ZSBjYW4ndCBzdG9wIGV2ZW50IHByb3BhZ2F0aW9uIGZyb20gdGhlIGNvbHVtbiByZXNpemUgbW92ZSBoYW5kbGVyc1xuICAgICAgLy8gYXR0YWNoZWQgdG8gdGhlIGRvY3VtZW50IGJlY2F1c2Ugb2YgcmVhY3QncyBzeW50aGV0aWMgZXZlbnRzXG4gICAgICAvLyBzbyB3ZSBoYXZlIHRvIHByZXZlbnQgdGhlIHNvcnQgZnVuY3Rpb24gZnJvbSBhY3R1YWxseSBzb3J0aW5nXG4gICAgICAvLyBpZiB3ZSBjbGljayBvbiB0aGUgY29sdW1uIHJlc2l6ZSBlbGVtZW50IHdpdGhpbiBhIGhlYWRlci5cbiAgICAgIGlmIChza2lwTmV4dFNvcnQpIHtcbiAgICAgICAgdGhpcy5zZXRTdGF0ZVdpdGhEYXRhKHtcbiAgICAgICAgICBza2lwTmV4dFNvcnQ6IGZhbHNlLFxuICAgICAgICB9KVxuICAgICAgICByZXR1cm5cbiAgICAgIH1cblxuICAgICAgY29uc3QgeyBvblNvcnRlZENoYW5nZSB9ID0gdGhpcy5wcm9wc1xuXG4gICAgICBsZXQgbmV3U29ydGVkID0gXy5jbG9uZShzb3J0ZWQgfHwgW10pLm1hcChkID0+IHtcbiAgICAgICAgZC5kZXNjID0gXy5pc1NvcnRpbmdEZXNjKGQpXG4gICAgICAgIHJldHVybiBkXG4gICAgICB9KVxuICAgICAgaWYgKCFfLmlzQXJyYXkoY29sdW1uKSkge1xuICAgICAgICAvLyBTaW5nbGUtU29ydFxuICAgICAgICBjb25zdCBleGlzdGluZ0luZGV4ID0gbmV3U29ydGVkLmZpbmRJbmRleChkID0+IGQuaWQgPT09IGNvbHVtbi5pZClcbiAgICAgICAgaWYgKGV4aXN0aW5nSW5kZXggPiAtMSkge1xuICAgICAgICAgIGNvbnN0IGV4aXN0aW5nID0gbmV3U29ydGVkW2V4aXN0aW5nSW5kZXhdXG4gICAgICAgICAgaWYgKGV4aXN0aW5nLmRlc2MgPT09IHNlY29uZFNvcnREaXJlY3Rpb24pIHtcbiAgICAgICAgICAgIGlmIChhZGRpdGl2ZSkge1xuICAgICAgICAgICAgICBuZXdTb3J0ZWQuc3BsaWNlKGV4aXN0aW5nSW5kZXgsIDEpXG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICBleGlzdGluZy5kZXNjID0gZmlyc3RTb3J0RGlyZWN0aW9uXG4gICAgICAgICAgICAgIG5ld1NvcnRlZCA9IFtleGlzdGluZ11cbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgZXhpc3RpbmcuZGVzYyA9IHNlY29uZFNvcnREaXJlY3Rpb25cbiAgICAgICAgICAgIGlmICghYWRkaXRpdmUpIHtcbiAgICAgICAgICAgICAgbmV3U29ydGVkID0gW2V4aXN0aW5nXVxuICAgICAgICAgICAgfVxuICAgICAgICAgIH1cbiAgICAgICAgfSBlbHNlIGlmIChhZGRpdGl2ZSkge1xuICAgICAgICAgIG5ld1NvcnRlZC5wdXNoKHtcbiAgICAgICAgICAgIGlkOiBjb2x1bW4uaWQsXG4gICAgICAgICAgICBkZXNjOiBmaXJzdFNvcnREaXJlY3Rpb24sXG4gICAgICAgICAgfSlcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICBuZXdTb3J0ZWQgPSBbXG4gICAgICAgICAgICB7XG4gICAgICAgICAgICAgIGlkOiBjb2x1bW4uaWQsXG4gICAgICAgICAgICAgIGRlc2M6IGZpcnN0U29ydERpcmVjdGlvbixcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgXVxuICAgICAgICB9XG4gICAgICB9IGVsc2Uge1xuICAgICAgICAvLyBNdWx0aS1Tb3J0XG4gICAgICAgIGNvbnN0IGV4aXN0aW5nSW5kZXggPSBuZXdTb3J0ZWQuZmluZEluZGV4KGQgPT4gZC5pZCA9PT0gY29sdW1uWzBdLmlkKVxuICAgICAgICAvLyBFeGlzdGluZyBTb3J0ZWQgQ29sdW1uXG4gICAgICAgIGlmIChleGlzdGluZ0luZGV4ID4gLTEpIHtcbiAgICAgICAgICBjb25zdCBleGlzdGluZyA9IG5ld1NvcnRlZFtleGlzdGluZ0luZGV4XVxuICAgICAgICAgIGlmIChleGlzdGluZy5kZXNjID09PSBzZWNvbmRTb3J0RGlyZWN0aW9uKSB7XG4gICAgICAgICAgICBpZiAoYWRkaXRpdmUpIHtcbiAgICAgICAgICAgICAgbmV3U29ydGVkLnNwbGljZShleGlzdGluZ0luZGV4LCBjb2x1bW4ubGVuZ3RoKVxuICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgY29sdW1uLmZvckVhY2goKGQsIGkpID0+IHtcbiAgICAgICAgICAgICAgICBuZXdTb3J0ZWRbZXhpc3RpbmdJbmRleCArIGldLmRlc2MgPSBmaXJzdFNvcnREaXJlY3Rpb25cbiAgICAgICAgICAgICAgfSlcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgY29sdW1uLmZvckVhY2goKGQsIGkpID0+IHtcbiAgICAgICAgICAgICAgbmV3U29ydGVkW2V4aXN0aW5nSW5kZXggKyBpXS5kZXNjID0gc2Vjb25kU29ydERpcmVjdGlvblxuICAgICAgICAgICAgfSlcbiAgICAgICAgICB9XG4gICAgICAgICAgaWYgKCFhZGRpdGl2ZSkge1xuICAgICAgICAgICAgbmV3U29ydGVkID0gbmV3U29ydGVkLnNsaWNlKGV4aXN0aW5nSW5kZXgsIGNvbHVtbi5sZW5ndGgpXG4gICAgICAgICAgfVxuICAgICAgICAgIC8vIE5ldyBTb3J0IENvbHVtblxuICAgICAgICB9IGVsc2UgaWYgKGFkZGl0aXZlKSB7XG4gICAgICAgICAgbmV3U29ydGVkID0gbmV3U29ydGVkLmNvbmNhdChcbiAgICAgICAgICAgIGNvbHVtbi5tYXAoZCA9PiAoe1xuICAgICAgICAgICAgICBpZDogZC5pZCxcbiAgICAgICAgICAgICAgZGVzYzogZmlyc3RTb3J0RGlyZWN0aW9uLFxuICAgICAgICAgICAgfSkpXG4gICAgICAgICAgKVxuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIG5ld1NvcnRlZCA9IGNvbHVtbi5tYXAoZCA9PiAoe1xuICAgICAgICAgICAgaWQ6IGQuaWQsXG4gICAgICAgICAgICBkZXNjOiBmaXJzdFNvcnREaXJlY3Rpb24sXG4gICAgICAgICAgfSkpXG4gICAgICAgIH1cbiAgICAgIH1cblxuICAgICAgdGhpcy5zZXRTdGF0ZVdpdGhEYXRhKFxuICAgICAgICB7XG4gICAgICAgICAgcGFnZTogKCFzb3J0ZWQubGVuZ3RoICYmIG5ld1NvcnRlZC5sZW5ndGgpIHx8ICFhZGRpdGl2ZSA/IDAgOiB0aGlzLnN0YXRlLnBhZ2UsXG4gICAgICAgICAgc29ydGVkOiBuZXdTb3J0ZWQsXG4gICAgICAgIH0sXG4gICAgICAgICgpID0+IG9uU29ydGVkQ2hhbmdlICYmIG9uU29ydGVkQ2hhbmdlKG5ld1NvcnRlZCwgY29sdW1uLCBhZGRpdGl2ZSlcbiAgICAgIClcbiAgICB9XG5cbiAgICBmaWx0ZXJDb2x1bW4gKGNvbHVtbiwgdmFsdWUpIHtcbiAgICAgIGNvbnN0IHsgZmlsdGVyZWQgfSA9IHRoaXMuZ2V0UmVzb2x2ZWRTdGF0ZSgpXG4gICAgICBjb25zdCB7IG9uRmlsdGVyZWRDaGFuZ2UgfSA9IHRoaXMucHJvcHNcblxuICAgICAgLy8gUmVtb3ZlIG9sZCBmaWx0ZXIgZmlyc3QgaWYgaXQgZXhpc3RzXG4gICAgICBjb25zdCBuZXdGaWx0ZXJpbmcgPSAoZmlsdGVyZWQgfHwgW10pLmZpbHRlcih4ID0+IHguaWQgIT09IGNvbHVtbi5pZClcblxuICAgICAgaWYgKHZhbHVlICE9PSAnJykge1xuICAgICAgICBuZXdGaWx0ZXJpbmcucHVzaCh7XG4gICAgICAgICAgaWQ6IGNvbHVtbi5pZCxcbiAgICAgICAgICB2YWx1ZSxcbiAgICAgICAgfSlcbiAgICAgIH1cblxuICAgICAgdGhpcy5zZXRTdGF0ZVdpdGhEYXRhKFxuICAgICAgICB7XG4gICAgICAgICAgZmlsdGVyZWQ6IG5ld0ZpbHRlcmluZyxcbiAgICAgICAgfSxcbiAgICAgICAgKCkgPT4gb25GaWx0ZXJlZENoYW5nZSAmJiBvbkZpbHRlcmVkQ2hhbmdlKG5ld0ZpbHRlcmluZywgY29sdW1uLCB2YWx1ZSlcbiAgICAgIClcbiAgICB9XG5cbiAgICByZXNpemVDb2x1bW5TdGFydCAoZXZlbnQsIGNvbHVtbiwgaXNUb3VjaCkge1xuICAgICAgZXZlbnQuc3RvcFByb3BhZ2F0aW9uKClcbiAgICAgIGNvbnN0IHBhcmVudFdpZHRoID0gZXZlbnQudGFyZ2V0LnBhcmVudEVsZW1lbnQuZ2V0Qm91bmRpbmdDbGllbnRSZWN0KCkud2lkdGhcblxuICAgICAgbGV0IHBhZ2VYXG4gICAgICBpZiAoaXNUb3VjaCkge1xuICAgICAgICBwYWdlWCA9IGV2ZW50LmNoYW5nZWRUb3VjaGVzWzBdLnBhZ2VYXG4gICAgICB9IGVsc2Uge1xuICAgICAgICBwYWdlWCA9IGV2ZW50LnBhZ2VYXG4gICAgICB9XG5cbiAgICAgIHRoaXMudHJhcEV2ZW50cyA9IHRydWVcbiAgICAgIHRoaXMuc2V0U3RhdGVXaXRoRGF0YShcbiAgICAgICAge1xuICAgICAgICAgIGN1cnJlbnRseVJlc2l6aW5nOiB7XG4gICAgICAgICAgICBpZDogY29sdW1uLmlkLFxuICAgICAgICAgICAgc3RhcnRYOiBwYWdlWCxcbiAgICAgICAgICAgIHBhcmVudFdpZHRoLFxuICAgICAgICAgIH0sXG4gICAgICAgIH0sXG4gICAgICAgICgpID0+IHtcbiAgICAgICAgICBpZiAoaXNUb3VjaCkge1xuICAgICAgICAgICAgZG9jdW1lbnQuYWRkRXZlbnRMaXN0ZW5lcigndG91Y2htb3ZlJywgdGhpcy5yZXNpemVDb2x1bW5Nb3ZpbmcpXG4gICAgICAgICAgICBkb2N1bWVudC5hZGRFdmVudExpc3RlbmVyKCd0b3VjaGNhbmNlbCcsIHRoaXMucmVzaXplQ29sdW1uRW5kKVxuICAgICAgICAgICAgZG9jdW1lbnQuYWRkRXZlbnRMaXN0ZW5lcigndG91Y2hlbmQnLCB0aGlzLnJlc2l6ZUNvbHVtbkVuZClcbiAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgZG9jdW1lbnQuYWRkRXZlbnRMaXN0ZW5lcignbW91c2Vtb3ZlJywgdGhpcy5yZXNpemVDb2x1bW5Nb3ZpbmcpXG4gICAgICAgICAgICBkb2N1bWVudC5hZGRFdmVudExpc3RlbmVyKCdtb3VzZXVwJywgdGhpcy5yZXNpemVDb2x1bW5FbmQpXG4gICAgICAgICAgICBkb2N1bWVudC5hZGRFdmVudExpc3RlbmVyKCdtb3VzZWxlYXZlJywgdGhpcy5yZXNpemVDb2x1bW5FbmQpXG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICApXG4gICAgfVxuXG4gICAgcmVzaXplQ29sdW1uTW92aW5nIChldmVudCkge1xuICAgICAgZXZlbnQuc3RvcFByb3BhZ2F0aW9uKClcbiAgICAgIGNvbnN0IHsgb25SZXNpemVkQ2hhbmdlLCBjb2x1bW4gfSA9IHRoaXMucHJvcHNcbiAgICAgIGNvbnN0IHsgcmVzaXplZCwgY3VycmVudGx5UmVzaXppbmcsIGNvbHVtbnMgfSA9IHRoaXMuZ2V0UmVzb2x2ZWRTdGF0ZSgpXG4gICAgICBjb25zdCBjdXJyZW50Q29sdW1uID0gY29sdW1ucy5maW5kKGMgPT4gYy5hY2Nlc3NvciA9PT0gY3VycmVudGx5UmVzaXppbmcuaWQpXG4gICAgICBjb25zdCBtaW5SZXNpemVXaWR0aCA9IGN1cnJlbnRDb2x1bW4gPyBjdXJyZW50Q29sdW1uLm1pblJlc2l6ZVdpZHRoIDogY29sdW1uLm1pblJlc2l6ZVdpZHRoXG5cbiAgICAgIC8vIERlbGV0ZSBvbGQgdmFsdWVcbiAgICAgIGNvbnN0IG5ld1Jlc2l6ZWQgPSByZXNpemVkLmZpbHRlcih4ID0+IHguaWQgIT09IGN1cnJlbnRseVJlc2l6aW5nLmlkKVxuXG4gICAgICBsZXQgcGFnZVhcblxuICAgICAgaWYgKGV2ZW50LnR5cGUgPT09ICd0b3VjaG1vdmUnKSB7XG4gICAgICAgIHBhZ2VYID0gZXZlbnQuY2hhbmdlZFRvdWNoZXNbMF0ucGFnZVhcbiAgICAgIH0gZWxzZSBpZiAoZXZlbnQudHlwZSA9PT0gJ21vdXNlbW92ZScpIHtcbiAgICAgICAgcGFnZVggPSBldmVudC5wYWdlWFxuICAgICAgfVxuXG4gICAgICBjb25zdCBuZXdXaWR0aCA9IE1hdGgubWF4KFxuICAgICAgICBjdXJyZW50bHlSZXNpemluZy5wYXJlbnRXaWR0aCArIHBhZ2VYIC0gY3VycmVudGx5UmVzaXppbmcuc3RhcnRYLFxuICAgICAgICBtaW5SZXNpemVXaWR0aFxuICAgICAgKVxuXG4gICAgICBuZXdSZXNpemVkLnB1c2goe1xuICAgICAgICBpZDogY3VycmVudGx5UmVzaXppbmcuaWQsXG4gICAgICAgIHZhbHVlOiBuZXdXaWR0aCxcbiAgICAgIH0pXG5cbiAgICAgIHRoaXMuc2V0U3RhdGVXaXRoRGF0YShcbiAgICAgICAge1xuICAgICAgICAgIHJlc2l6ZWQ6IG5ld1Jlc2l6ZWQsXG4gICAgICAgIH0sXG4gICAgICAgICgpID0+IG9uUmVzaXplZENoYW5nZSAmJiBvblJlc2l6ZWRDaGFuZ2UobmV3UmVzaXplZCwgZXZlbnQpXG4gICAgICApXG4gICAgfVxuXG4gICAgcmVzaXplQ29sdW1uRW5kIChldmVudCkge1xuICAgICAgZXZlbnQuc3RvcFByb3BhZ2F0aW9uKClcbiAgICAgIGNvbnN0IGlzVG91Y2ggPSBldmVudC50eXBlID09PSAndG91Y2hlbmQnIHx8IGV2ZW50LnR5cGUgPT09ICd0b3VjaGNhbmNlbCdcblxuICAgICAgaWYgKGlzVG91Y2gpIHtcbiAgICAgICAgZG9jdW1lbnQucmVtb3ZlRXZlbnRMaXN0ZW5lcigndG91Y2htb3ZlJywgdGhpcy5yZXNpemVDb2x1bW5Nb3ZpbmcpXG4gICAgICAgIGRvY3VtZW50LnJlbW92ZUV2ZW50TGlzdGVuZXIoJ3RvdWNoY2FuY2VsJywgdGhpcy5yZXNpemVDb2x1bW5FbmQpXG4gICAgICAgIGRvY3VtZW50LnJlbW92ZUV2ZW50TGlzdGVuZXIoJ3RvdWNoZW5kJywgdGhpcy5yZXNpemVDb2x1bW5FbmQpXG4gICAgICB9XG5cbiAgICAgIC8vIElmIGl0cyBhIHRvdWNoIGV2ZW50IGNsZWFyIHRoZSBtb3VzZSBvbmUncyBhcyB3ZWxsIGJlY2F1c2Ugc29tZXRpbWVzXG4gICAgICAvLyB0aGUgbW91c2VEb3duIGV2ZW50IGdldHMgY2FsbGVkIGFzIHdlbGwsIGJ1dCB0aGUgbW91c2VVcCBldmVudCBkb2Vzbid0XG4gICAgICBkb2N1bWVudC5yZW1vdmVFdmVudExpc3RlbmVyKCdtb3VzZW1vdmUnLCB0aGlzLnJlc2l6ZUNvbHVtbk1vdmluZylcbiAgICAgIGRvY3VtZW50LnJlbW92ZUV2ZW50TGlzdGVuZXIoJ21vdXNldXAnLCB0aGlzLnJlc2l6ZUNvbHVtbkVuZClcbiAgICAgIGRvY3VtZW50LnJlbW92ZUV2ZW50TGlzdGVuZXIoJ21vdXNlbGVhdmUnLCB0aGlzLnJlc2l6ZUNvbHVtbkVuZClcblxuICAgICAgLy8gVGhlIHRvdWNoIGV2ZW50cyBkb24ndCBwcm9wYWdhdGUgdXAgdG8gdGhlIHNvcnRpbmcncyBvbk1vdXNlRG93biBldmVudCBzb1xuICAgICAgLy8gbm8gbmVlZCB0byBwcmV2ZW50IGl0IGZyb20gaGFwcGVuaW5nIG9yIGVsc2UgdGhlIGZpcnN0IGNsaWNrIGFmdGVyIGEgdG91Y2hcbiAgICAgIC8vIGV2ZW50IHJlc2l6ZSB3aWxsIG5vdCBzb3J0IHRoZSBjb2x1bW4uXG4gICAgICBpZiAoIWlzVG91Y2gpIHtcbiAgICAgICAgdGhpcy5zZXRTdGF0ZVdpdGhEYXRhKHtcbiAgICAgICAgICBza2lwTmV4dFNvcnQ6IHRydWUsXG4gICAgICAgICAgY3VycmVudGx5UmVzaXppbmc6IGZhbHNlLFxuICAgICAgICB9KVxuICAgICAgfVxuICAgIH1cbiAgfVxuIl19