'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _utils = require('./utils');

var _utils2 = _interopRequireDefault(_utils);

var _pagination = require('./pagination');

var _pagination2 = _interopRequireDefault(_pagination);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }
//


var emptyObj = function emptyObj() {
  return {};
};

exports.default = {
  // General
  data: [],
  resolveData: function resolveData(data) {
    return data;
  },
  loading: false,
  showPagination: true,
  showPaginationTop: false,
  showPaginationBottom: true,
  showPageSizeOptions: true,
  pageSizeOptions: [5, 10, 20, 25, 50, 100],
  defaultPage: 0,
  defaultPageSize: 20,
  showPageJump: true,
  collapseOnSortingChange: true,
  collapseOnPageChange: true,
  collapseOnDataChange: true,
  freezeWhenExpanded: false,
  sortable: true,
  multiSort: true,
  resizable: true,
  filterable: false,
  defaultSortDesc: false,
  defaultSorted: [],
  defaultFiltered: [],
  defaultResized: [],
  defaultExpanded: {},
  // eslint-disable-next-line no-unused-vars
  defaultFilterMethod: function defaultFilterMethod(filter, row, column) {
    var id = filter.pivotId || filter.id;
    return row[id] !== undefined ? String(row[id]).startsWith(filter.value) : true;
  },
  // eslint-disable-next-line no-unused-vars
  defaultSortMethod: function defaultSortMethod(a, b, desc) {
    // force null and undefined to the bottom
    a = a === null || a === undefined ? '' : a;
    b = b === null || b === undefined ? '' : b;
    // force any string values to lowercase
    a = typeof a === 'string' ? a.toLowerCase() : a;
    b = typeof b === 'string' ? b.toLowerCase() : b;
    // Return either 1 or -1 to indicate a sort priority
    if (a > b) {
      return 1;
    }
    if (a < b) {
      return -1;
    }
    // returning 0, undefined or any falsey value will use subsequent sorts or
    // the index as a tiebreaker
    return 0;
  },

  // Controlled State Props
  // page: undefined,
  // pageSize: undefined,
  // sorted: [],
  // filtered: [],
  // resized: [],
  // expanded: {},

  // Controlled State Callbacks
  onPageChange: undefined,
  onPageSizeChange: undefined,
  onSortedChange: undefined,
  onFilteredChange: undefined,
  onResizedChange: undefined,
  onExpandedChange: undefined,

  // Pivoting
  pivotBy: undefined,

  // Key Constants
  pivotValKey: '_pivotVal',
  pivotIDKey: '_pivotID',
  subRowsKey: '_subRows',
  aggregatedKey: '_aggregated',
  nestingLevelKey: '_nestingLevel',
  originalKey: '_original',
  indexKey: '_index',
  groupedByPivotKey: '_groupedByPivot',

  // Server-side Callbacks
  onFetchData: function onFetchData() {
    return null;
  },

  // Classes
  className: '',
  style: {},

  // Component decorators
  getProps: emptyObj,
  getTableProps: emptyObj,
  getTheadGroupProps: emptyObj,
  getTheadGroupTrProps: emptyObj,
  getTheadGroupThProps: emptyObj,
  getTheadProps: emptyObj,
  getTheadTrProps: emptyObj,
  getTheadThProps: emptyObj,
  getTheadFilterProps: emptyObj,
  getTheadFilterTrProps: emptyObj,
  getTheadFilterThProps: emptyObj,
  getTbodyProps: emptyObj,
  getTrGroupProps: emptyObj,
  getTrProps: emptyObj,
  getTdProps: emptyObj,
  getTfootProps: emptyObj,
  getTfootTrProps: emptyObj,
  getTfootTdProps: emptyObj,
  getPaginationProps: emptyObj,
  getLoadingProps: emptyObj,
  getNoDataProps: emptyObj,
  getResizerProps: emptyObj,

  // Global Column Defaults
  column: {
    // Renderers
    Cell: undefined,
    Header: undefined,
    Footer: undefined,
    Aggregated: undefined,
    Pivot: undefined,
    PivotValue: undefined,
    Expander: undefined,
    Filter: undefined,
    Placeholder: undefined,
    // All Columns
    sortable: undefined, // use table default
    resizable: undefined, // use table default
    filterable: undefined, // use table default
    show: true,
    minWidth: 100,
    minResizeWidth: 11,
    // Cells only
    className: '',
    style: {},
    getProps: emptyObj,
    // Pivot only
    aggregate: undefined,
    // Headers only
    headerClassName: '',
    headerStyle: {},
    getHeaderProps: emptyObj,
    // Footers only
    footerClassName: '',
    footerStyle: {},
    getFooterProps: emptyObj,
    filterMethod: undefined,
    filterAll: false,
    sortMethod: undefined
  },

  // Global Expander Column Defaults
  expanderDefaults: {
    sortable: false,
    resizable: false,
    filterable: false,
    width: 35
  },

  pivotDefaults: {
    // extend the defaults for pivoted columns here
  },

  // Text
  previousText: 'Previous',
  nextText: 'Next',
  loadingText: 'Loading...',
  noDataText: 'No rows found',
  pageText: 'Page',
  ofText: 'of',
  rowsText: 'rows',
  pageJumpText: 'jump to page',
  rowsSelectorText: 'rows per page',

  // Components
  TableComponent: function TableComponent(_ref) {
    var children = _ref.children,
        className = _ref.className,
        rest = _objectWithoutProperties(_ref, ['children', 'className']);

    return _react2.default.createElement(
      'div',
      _extends({
        className: (0, _classnames2.default)('rt-table', className),
        role: 'grid'
        // tabIndex='0'
      }, rest),
      children
    );
  },
  TheadComponent: _utils2.default.makeTemplateComponent('rt-thead', 'Thead'),
  TbodyComponent: _utils2.default.makeTemplateComponent('rt-tbody', 'Tbody'),
  TrGroupComponent: function TrGroupComponent(_ref2) {
    var children = _ref2.children,
        className = _ref2.className,
        rest = _objectWithoutProperties(_ref2, ['children', 'className']);

    return _react2.default.createElement(
      'div',
      _extends({ className: (0, _classnames2.default)('rt-tr-group', className), role: 'rowgroup' }, rest),
      children
    );
  },
  TrComponent: function TrComponent(_ref3) {
    var children = _ref3.children,
        className = _ref3.className,
        rest = _objectWithoutProperties(_ref3, ['children', 'className']);

    return _react2.default.createElement(
      'div',
      _extends({ className: (0, _classnames2.default)('rt-tr', className), role: 'row' }, rest),
      children
    );
  },
  ThComponent: function ThComponent(_ref4) {
    var toggleSort = _ref4.toggleSort,
        className = _ref4.className,
        children = _ref4.children,
        rest = _objectWithoutProperties(_ref4, ['toggleSort', 'className', 'children']);

    return (
      // eslint-disable-next-line jsx-a11y/click-events-have-key-events
      _react2.default.createElement(
        'div',
        _extends({
          className: (0, _classnames2.default)('rt-th', className),
          onClick: function onClick(e) {
            return toggleSort && toggleSort(e);
          },
          role: 'columnheader',
          tabIndex: '-1' // Resolves eslint issues without implementing keyboard navigation incorrectly
        }, rest),
        children
      )
    );
  },
  TdComponent: function TdComponent(_ref5) {
    var toggleSort = _ref5.toggleSort,
        className = _ref5.className,
        children = _ref5.children,
        rest = _objectWithoutProperties(_ref5, ['toggleSort', 'className', 'children']);

    return _react2.default.createElement(
      'div',
      _extends({ className: (0, _classnames2.default)('rt-td', className), role: 'gridcell' }, rest),
      children
    );
  },
  TfootComponent: _utils2.default.makeTemplateComponent('rt-tfoot', 'Tfoot'),
  FilterComponent: function FilterComponent(_ref6) {
    var filter = _ref6.filter,
        _onChange = _ref6.onChange,
        column = _ref6.column;
    return _react2.default.createElement('input', {
      type: 'text',
      style: {
        width: '100%'
      },
      placeholder: column.Placeholder,
      value: filter ? filter.value : '',
      onChange: function onChange(event) {
        return _onChange(event.target.value);
      }
    });
  },
  ExpanderComponent: function ExpanderComponent(_ref7) {
    var isExpanded = _ref7.isExpanded;
    return _react2.default.createElement(
      'div',
      { className: (0, _classnames2.default)('rt-expander', isExpanded && '-open') },
      '\u2022'
    );
  },
  PivotValueComponent: function PivotValueComponent(_ref8) {
    var subRows = _ref8.subRows,
        value = _ref8.value;
    return _react2.default.createElement(
      'span',
      null,
      value,
      ' ',
      subRows && '(' + subRows.length + ')'
    );
  },
  AggregatedComponent: function AggregatedComponent(_ref9) {
    var subRows = _ref9.subRows,
        column = _ref9.column;

    var previewValues = subRows.filter(function (d) {
      return typeof d[column.id] !== 'undefined';
    }).map(function (row, i) {
      return (
        // eslint-disable-next-line react/no-array-index-key
        _react2.default.createElement(
          'span',
          { key: i },
          row[column.id],
          i < subRows.length - 1 ? ', ' : ''
        )
      );
    });
    return _react2.default.createElement(
      'span',
      null,
      previewValues
    );
  },
  PivotComponent: undefined, // this is a computed default generated using
  // the ExpanderComponent and PivotValueComponent at run-time in methods.js
  PaginationComponent: _pagination2.default,
  PreviousComponent: undefined,
  NextComponent: undefined,
  LoadingComponent: function LoadingComponent(_ref10) {
    var className = _ref10.className,
        loading = _ref10.loading,
        loadingText = _ref10.loadingText,
        rest = _objectWithoutProperties(_ref10, ['className', 'loading', 'loadingText']);

    return _react2.default.createElement(
      'div',
      _extends({ className: (0, _classnames2.default)('-loading', { '-active': loading }, className) }, rest),
      _react2.default.createElement(
        'div',
        { className: '-loading-inner' },
        loadingText
      )
    );
  },
  NoDataComponent: _utils2.default.makeTemplateComponent('rt-noData', 'NoData'),
  ResizerComponent: _utils2.default.makeTemplateComponent('rt-resizer', 'Resizer'),
  PadRowComponent: function PadRowComponent() {
    return _react2.default.createElement(
      'span',
      null,
      '\xA0'
    );
  }
};
//# sourceMappingURL=data:application/json;base64,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