var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import React from 'react';
import _ from './utils';

export default (function (Base) {
  return function (_Base) {
    _inherits(_class, _Base);

    function _class() {
      _classCallCheck(this, _class);

      return _possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).apply(this, arguments));
    }

    _createClass(_class, [{
      key: 'getResolvedState',
      value: function getResolvedState(props, state) {
        var resolvedState = _extends({}, _.compactObject(this.state), _.compactObject(this.props), _.compactObject(state), _.compactObject(props));
        return resolvedState;
      }
    }, {
      key: 'getDataModel',
      value: function getDataModel(newState, dataChanged) {
        var _this2 = this;

        var columns = newState.columns,
            _newState$pivotBy = newState.pivotBy,
            pivotBy = _newState$pivotBy === undefined ? [] : _newState$pivotBy,
            data = newState.data,
            resolveData = newState.resolveData,
            pivotIDKey = newState.pivotIDKey,
            pivotValKey = newState.pivotValKey,
            subRowsKey = newState.subRowsKey,
            aggregatedKey = newState.aggregatedKey,
            nestingLevelKey = newState.nestingLevelKey,
            originalKey = newState.originalKey,
            indexKey = newState.indexKey,
            groupedByPivotKey = newState.groupedByPivotKey,
            SubComponent = newState.SubComponent;

        // Determine if there are Header Groups

        var hasHeaderGroups = columns.some(function (column) {
          return column.columns;
        });

        // Find the expander column which could be deep in tree of columns
        var allColumns = _.iterTree(columns, 'columns');
        var expanderColumn = _.getFirstDefined(allColumns);

        // If we have SubComponent's we need to make sure we have an expander column
        var hasSubComponentAndNoExpanderColumn = SubComponent && !expanderColumn;
        var columnsWithExpander = hasSubComponentAndNoExpanderColumn ? [{ expander: true }].concat(_toConsumableArray(columns)) : [].concat(_toConsumableArray(columns));

        var makeDecoratedColumn = function makeDecoratedColumn(column, parentColumn) {
          var dcol = void 0;
          if (column.expander) {
            dcol = _extends({}, _this2.props.column, _this2.props.expanderDefaults, column);
          } else {
            dcol = _extends({}, _this2.props.column, _this2.props.column, column);
          }

          // Ensure minWidth is not greater than maxWidth if set
          if (dcol.maxWidth < dcol.minWidth) {
            dcol.minWidth = dcol.maxWidth;
          }

          if (parentColumn) {
            dcol.parentColumn = parentColumn;
          }

          // First check for string accessor
          if (typeof dcol.accessor === 'string') {
            dcol.id = dcol.id || dcol.accessor;
            var accessorString = dcol.accessor;
            dcol.accessor = function (row) {
              return _.get(row, accessorString);
            };
            return dcol;
          }

          // Fall back to functional accessor (but require an ID)
          if (dcol.accessor && !dcol.id) {
            console.warn(dcol);
            throw new Error('A column id is required if using a non-string accessor for column above.');
          }

          // Fall back to an undefined accessor
          if (!dcol.accessor) {
            dcol.accessor = function () {
              return undefined;
            };
          }

          return dcol;
        };

        var allDecoratedColumns = [];

        // Decorate the columns
        var decorateAndAddToAll = function decorateAndAddToAll(columns, parentColumn) {
          return columns.map(function (column) {
            var decoratedColumn = makeDecoratedColumn(column, parentColumn);
            if (column.columns) {
              decoratedColumn.columns = decorateAndAddToAll(column.columns, column);
            }

            allDecoratedColumns.push(decoratedColumn);
            return decoratedColumn;
          });
        };

        var decoratedColumns = decorateAndAddToAll(columnsWithExpander);
        var mapVisibleColumns = function mapVisibleColumns(columns) {
          return columns.map(function (column) {
            if (column.columns) {
              var visibleSubColumns = column.columns.filter(function (d) {
                return pivotBy.indexOf(d.id) > -1 ? false : _.getFirstDefined(d.show, true);
              });
              return _extends({}, column, {
                columns: mapVisibleColumns(visibleSubColumns)
              });
            }
            return column;
          });
        };

        var filterVisibleColumns = function filterVisibleColumns(columns) {
          return columns.filter(function (column) {
            return column.columns ? column.columns.length : pivotBy.indexOf(column.id) > -1 ? false : _.getFirstDefined(column.show, true);
          });
        };

        // Build the full array of visible columns - this is an array that contains all columns that
        // are not hidden via pivoting
        var allVisibleColumns = filterVisibleColumns(mapVisibleColumns(decoratedColumns.slice()));

        // Find any custom pivot location
        var pivotIndex = allVisibleColumns.findIndex(function (col) {
          return col.pivot;
        });

        // Handle Pivot Columns
        if (pivotBy.length) {
          // Retrieve the pivot columns in the correct pivot order
          var pivotColumns = [];
          pivotBy.forEach(function (pivotID) {
            var found = allDecoratedColumns.find(function (d) {
              return d.id === pivotID;
            });
            if (found) {
              pivotColumns.push(found);
            }
          });

          var PivotParentColumn = pivotColumns.reduce(function (prev, current) {
            return prev && prev === current.parentColumn && current.parentColumn;
          }, pivotColumns[0].parentColumn);

          var PivotGroupHeader = hasHeaderGroups && PivotParentColumn.Header;
          PivotGroupHeader = PivotGroupHeader || function () {
            return React.createElement(
              'strong',
              null,
              'Pivoted'
            );
          };

          var pivotColumnGroup = {
            Header: PivotGroupHeader,
            columns: pivotColumns.map(function (col) {
              return _extends({}, _this2.props.pivotDefaults, col, {
                pivoted: true
              });
            })

            // Place the pivotColumns back into the visibleColumns
          };if (pivotIndex >= 0) {
            pivotColumnGroup = _extends({}, allVisibleColumns[pivotIndex], pivotColumnGroup);
            allVisibleColumns.splice(pivotIndex, 1, pivotColumnGroup);
          } else {
            allVisibleColumns.unshift(pivotColumnGroup);
          }
        }

        // Build Visible Columns and Header Groups
        var allColumnHeaders = [];

        var addHeader = function addHeader(column) {
          var level = 0;

          // If this column has children, push them first and add this column to the next level
          if (column.columns) {
            var childLevels = column.columns.map(addHeader);
            level = Math.max.apply(Math, _toConsumableArray(childLevels)) + 1;
          }

          // Add spans above columns without parents (orphans) to fill the space above them
          if (allColumnHeaders.length <= level) allColumnHeaders.push([]);
          if (level > 0) {
            // The spans need to contain the shifted headers as children. This finds all of the
            // columns in the lower level between the first child of this column and the last child
            // of the preceding column (if there is one)
            var lowerLevel = allColumnHeaders[level - 1];
            var precedingColumn = _.last(allColumnHeaders[level]);

            var indexOfFirstChildInLowerLevel = lowerLevel.indexOf(column.columns[0]);
            var indexAfterLastChildInPrecedingColumn = precedingColumn ? lowerLevel.indexOf(_.last(precedingColumn.columns)) + 1 : 0;

            // If there are ophans, add a span above them
            var orphans = lowerLevel.slice(indexAfterLastChildInPrecedingColumn, indexOfFirstChildInLowerLevel);

            if (orphans.length) {
              allColumnHeaders[level].push(_extends({}, _this2.props.column, {
                columns: orphans
              }));
            }
          }

          allColumnHeaders[level].push(column);

          return level;
        };

        allVisibleColumns.forEach(addHeader);

        // visibleColumns is an array containing column definitions for the bottom row of TH elements
        var visibleColumns = allColumnHeaders.shift();
        var headerGroups = allColumnHeaders.reverse();

        // Access the data
        var accessRow = function accessRow(d, i) {
          var _row;

          var level = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

          var row = (_row = {}, _defineProperty(_row, originalKey, d), _defineProperty(_row, indexKey, i), _defineProperty(_row, subRowsKey, d[subRowsKey]), _defineProperty(_row, nestingLevelKey, level), _row);
          allDecoratedColumns.forEach(function (column) {
            if (column.expander) return;
            row[column.id] = column.accessor(d);
          });
          if (row[subRowsKey]) {
            row[subRowsKey] = row[subRowsKey].map(function (d, i) {
              return accessRow(d, i, level + 1);
            });
          }
          return row;
        };

        // // If the data hasn't changed, just use the cached data
        var resolvedData = this.resolvedData;
        // If the data has changed, run the data resolver and cache the result
        if (!this.resolvedData || dataChanged) {
          resolvedData = resolveData(data);
          this.resolvedData = resolvedData;
        }
        // Use the resolved data
        resolvedData = resolvedData.map(function (d, i) {
          return accessRow(d, i);
        });

        // TODO: Make it possible to fabricate nested rows without pivoting
        var aggregatingColumns = visibleColumns.filter(function (d) {
          return !d.expander && d.aggregate;
        });

        // If pivoting, recursively group the data
        var aggregate = function aggregate(rows) {
          var aggregationValues = {};
          aggregatingColumns.forEach(function (column) {
            var values = rows.map(function (d) {
              return d[column.id];
            });
            aggregationValues[column.id] = column.aggregate(values, rows);
          });
          return aggregationValues;
        };
        if (pivotBy.length) {
          var groupRecursively = function groupRecursively(rows, keys) {
            var i = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

            // This is the last level, just return the rows
            if (i === keys.length) {
              return rows;
            }
            // Group the rows together for this level
            var groupedRows = Object.entries(_.groupBy(rows, keys[i])).map(function (_ref) {
              var _ref3;

              var _ref2 = _slicedToArray(_ref, 2),
                  key = _ref2[0],
                  value = _ref2[1];

              return _ref3 = {}, _defineProperty(_ref3, pivotIDKey, keys[i]), _defineProperty(_ref3, pivotValKey, key), _defineProperty(_ref3, keys[i], key), _defineProperty(_ref3, subRowsKey, value), _defineProperty(_ref3, nestingLevelKey, i), _defineProperty(_ref3, groupedByPivotKey, true), _ref3;
            });
            // Recurse into the subRows
            groupedRows = groupedRows.map(function (rowGroup) {
              var _extends2;

              var subRows = groupRecursively(rowGroup[subRowsKey], keys, i + 1);
              return _extends({}, rowGroup, (_extends2 = {}, _defineProperty(_extends2, subRowsKey, subRows), _defineProperty(_extends2, aggregatedKey, true), _extends2), aggregate(subRows));
            });
            return groupedRows;
          };
          resolvedData = groupRecursively(resolvedData, pivotBy);
        }

        return _extends({}, newState, {
          resolvedData: resolvedData,
          visibleColumns: visibleColumns,
          headerGroups: headerGroups,
          allDecoratedColumns: allDecoratedColumns,
          hasHeaderGroups: hasHeaderGroups
        });
      }
    }, {
      key: 'getSortedData',
      value: function getSortedData(resolvedState) {
        var manual = resolvedState.manual,
            sorted = resolvedState.sorted,
            filtered = resolvedState.filtered,
            defaultFilterMethod = resolvedState.defaultFilterMethod,
            resolvedData = resolvedState.resolvedData,
            allDecoratedColumns = resolvedState.allDecoratedColumns;


        var sortMethodsByColumnID = {};

        allDecoratedColumns.filter(function (col) {
          return col.sortMethod;
        }).forEach(function (col) {
          sortMethodsByColumnID[col.id] = col.sortMethod;
        });

        // Resolve the data from either manual data or sorted data
        return {
          sortedData: manual ? resolvedData : this.sortData(this.filterData(resolvedData, filtered, defaultFilterMethod, allDecoratedColumns), sorted, sortMethodsByColumnID)
        };
      }
    }, {
      key: 'fireFetchData',
      value: function fireFetchData() {
        // determine the current state, preferring certain state values over props
        var currentState = _extends({}, this.getResolvedState(), {
          page: this.getStateOrProp('page'),
          pageSize: this.getStateOrProp('pageSize'),
          filter: this.getStateOrProp('filter')
        });

        this.props.onFetchData(currentState, this);
      }
    }, {
      key: 'getPropOrState',
      value: function getPropOrState(key) {
        return _.getFirstDefined(this.props[key], this.state[key]);
      }
    }, {
      key: 'getStateOrProp',
      value: function getStateOrProp(key) {
        return _.getFirstDefined(this.state[key], this.props[key]);
      }
    }, {
      key: 'filterData',
      value: function filterData(data, filtered, defaultFilterMethod, visibleColumns) {
        var _this3 = this;

        var filteredData = data;

        if (filtered.length) {
          filteredData = filtered.reduce(function (filteredSoFar, nextFilter) {
            var column = visibleColumns.find(function (x) {
              return x.id === nextFilter.id;
            });

            // Don't filter hidden columns or columns that have had their filters disabled
            if (!column || column.filterable === false) {
              return filteredSoFar;
            }

            var filterMethod = column.filterMethod || defaultFilterMethod;

            // If 'filterAll' is set to true, pass the entire dataset to the filter method
            if (column.filterAll) {
              return filterMethod(nextFilter, filteredSoFar, column);
            }
            return filteredSoFar.filter(function (row) {
              return filterMethod(nextFilter, row, column);
            });
          }, filteredData);

          // Apply the filter to the subrows if we are pivoting, and then
          // filter any rows without subcolumns because it would be strange to show
          filteredData = filteredData.map(function (row) {
            if (!row[_this3.props.subRowsKey]) {
              return row;
            }
            return _extends({}, row, _defineProperty({}, _this3.props.subRowsKey, _this3.filterData(row[_this3.props.subRowsKey], filtered, defaultFilterMethod, visibleColumns)));
          }).filter(function (row) {
            if (!row[_this3.props.subRowsKey]) {
              return true;
            }
            return row[_this3.props.subRowsKey].length > 0;
          });
        }

        return filteredData;
      }
    }, {
      key: 'sortData',
      value: function sortData(data, sorted) {
        var _this4 = this;

        var sortMethodsByColumnID = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

        if (!sorted.length) {
          return data;
        }

        var sortedData = (this.props.orderByMethod || _.orderBy)(data, sorted.map(function (sort) {
          // Support custom sorting methods for each column
          if (sortMethodsByColumnID[sort.id]) {
            return function (a, b) {
              return sortMethodsByColumnID[sort.id](a[sort.id], b[sort.id], sort.desc);
            };
          }
          return function (a, b) {
            return _this4.props.defaultSortMethod(a[sort.id], b[sort.id], sort.desc);
          };
        }), sorted.map(function (d) {
          return !d.desc;
        }), this.props.indexKey);

        sortedData.forEach(function (row) {
          if (!row[_this4.props.subRowsKey]) {
            return;
          }
          row[_this4.props.subRowsKey] = _this4.sortData(row[_this4.props.subRowsKey], sorted, sortMethodsByColumnID);
        });

        return sortedData;
      }
    }, {
      key: 'getMinRows',
      value: function getMinRows() {
        return _.getFirstDefined(this.props.minRows, this.getStateOrProp('pageSize'));
      }

      // User actions

    }, {
      key: 'onPageChange',
      value: function onPageChange(page) {
        var _props = this.props,
            onPageChange = _props.onPageChange,
            collapseOnPageChange = _props.collapseOnPageChange;


        var newState = { page: page };
        if (collapseOnPageChange) {
          newState.expanded = {};
        }
        this.setStateWithData(newState, function () {
          return onPageChange && onPageChange(page);
        });
      }
    }, {
      key: 'onPageSizeChange',
      value: function onPageSizeChange(newPageSize) {
        var onPageSizeChange = this.props.onPageSizeChange;

        var _getResolvedState = this.getResolvedState(),
            pageSize = _getResolvedState.pageSize,
            page = _getResolvedState.page;

        // Normalize the page to display


        var currentRow = pageSize * page;
        var newPage = Math.floor(currentRow / newPageSize);

        this.setStateWithData({
          pageSize: newPageSize,
          page: newPage
        }, function () {
          return onPageSizeChange && onPageSizeChange(newPageSize, newPage);
        });
      }
    }, {
      key: 'sortColumn',
      value: function sortColumn(column, additive) {
        var _getResolvedState2 = this.getResolvedState(),
            sorted = _getResolvedState2.sorted,
            skipNextSort = _getResolvedState2.skipNextSort,
            defaultSortDesc = _getResolvedState2.defaultSortDesc;

        var firstSortDirection = Object.prototype.hasOwnProperty.call(column, 'defaultSortDesc') ? column.defaultSortDesc : defaultSortDesc;
        var secondSortDirection = !firstSortDirection;

        // we can't stop event propagation from the column resize move handlers
        // attached to the document because of react's synthetic events
        // so we have to prevent the sort function from actually sorting
        // if we click on the column resize element within a header.
        if (skipNextSort) {
          this.setStateWithData({
            skipNextSort: false
          });
          return;
        }

        var onSortedChange = this.props.onSortedChange;


        var newSorted = _.clone(sorted || []).map(function (d) {
          d.desc = _.isSortingDesc(d);
          return d;
        });
        if (!_.isArray(column)) {
          // Single-Sort
          var existingIndex = newSorted.findIndex(function (d) {
            return d.id === column.id;
          });
          if (existingIndex > -1) {
            var existing = newSorted[existingIndex];
            if (existing.desc === secondSortDirection) {
              if (additive) {
                newSorted.splice(existingIndex, 1);
              } else {
                existing.desc = firstSortDirection;
                newSorted = [existing];
              }
            } else {
              existing.desc = secondSortDirection;
              if (!additive) {
                newSorted = [existing];
              }
            }
          } else if (additive) {
            newSorted.push({
              id: column.id,
              desc: firstSortDirection
            });
          } else {
            newSorted = [{
              id: column.id,
              desc: firstSortDirection
            }];
          }
        } else {
          // Multi-Sort
          var _existingIndex = newSorted.findIndex(function (d) {
            return d.id === column[0].id;
          });
          // Existing Sorted Column
          if (_existingIndex > -1) {
            var _existing = newSorted[_existingIndex];
            if (_existing.desc === secondSortDirection) {
              if (additive) {
                newSorted.splice(_existingIndex, column.length);
              } else {
                column.forEach(function (d, i) {
                  newSorted[_existingIndex + i].desc = firstSortDirection;
                });
              }
            } else {
              column.forEach(function (d, i) {
                newSorted[_existingIndex + i].desc = secondSortDirection;
              });
            }
            if (!additive) {
              newSorted = newSorted.slice(_existingIndex, column.length);
            }
            // New Sort Column
          } else if (additive) {
            newSorted = newSorted.concat(column.map(function (d) {
              return {
                id: d.id,
                desc: firstSortDirection
              };
            }));
          } else {
            newSorted = column.map(function (d) {
              return {
                id: d.id,
                desc: firstSortDirection
              };
            });
          }
        }

        this.setStateWithData({
          page: !sorted.length && newSorted.length || !additive ? 0 : this.state.page,
          sorted: newSorted
        }, function () {
          return onSortedChange && onSortedChange(newSorted, column, additive);
        });
      }
    }, {
      key: 'filterColumn',
      value: function filterColumn(column, value) {
        var _getResolvedState3 = this.getResolvedState(),
            filtered = _getResolvedState3.filtered;

        var onFilteredChange = this.props.onFilteredChange;

        // Remove old filter first if it exists

        var newFiltering = (filtered || []).filter(function (x) {
          return x.id !== column.id;
        });

        if (value !== '') {
          newFiltering.push({
            id: column.id,
            value: value
          });
        }

        this.setStateWithData({
          filtered: newFiltering
        }, function () {
          return onFilteredChange && onFilteredChange(newFiltering, column, value);
        });
      }
    }, {
      key: 'resizeColumnStart',
      value: function resizeColumnStart(event, column, isTouch) {
        var _this5 = this;

        event.stopPropagation();
        var parentWidth = event.target.parentElement.getBoundingClientRect().width;

        var pageX = void 0;
        if (isTouch) {
          pageX = event.changedTouches[0].pageX;
        } else {
          pageX = event.pageX;
        }

        this.trapEvents = true;
        this.setStateWithData({
          currentlyResizing: {
            id: column.id,
            startX: pageX,
            parentWidth: parentWidth
          }
        }, function () {
          if (isTouch) {
            document.addEventListener('touchmove', _this5.resizeColumnMoving);
            document.addEventListener('touchcancel', _this5.resizeColumnEnd);
            document.addEventListener('touchend', _this5.resizeColumnEnd);
          } else {
            document.addEventListener('mousemove', _this5.resizeColumnMoving);
            document.addEventListener('mouseup', _this5.resizeColumnEnd);
            document.addEventListener('mouseleave', _this5.resizeColumnEnd);
          }
        });
      }
    }, {
      key: 'resizeColumnMoving',
      value: function resizeColumnMoving(event) {
        event.stopPropagation();
        var _props2 = this.props,
            onResizedChange = _props2.onResizedChange,
            column = _props2.column;

        var _getResolvedState4 = this.getResolvedState(),
            resized = _getResolvedState4.resized,
            currentlyResizing = _getResolvedState4.currentlyResizing,
            columns = _getResolvedState4.columns;

        var currentColumn = columns.find(function (c) {
          return c.accessor === currentlyResizing.id;
        });
        var minResizeWidth = currentColumn ? currentColumn.minResizeWidth : column.minResizeWidth;

        // Delete old value
        var newResized = resized.filter(function (x) {
          return x.id !== currentlyResizing.id;
        });

        var pageX = void 0;

        if (event.type === 'touchmove') {
          pageX = event.changedTouches[0].pageX;
        } else if (event.type === 'mousemove') {
          pageX = event.pageX;
        }

        var newWidth = Math.max(currentlyResizing.parentWidth + pageX - currentlyResizing.startX, minResizeWidth);

        newResized.push({
          id: currentlyResizing.id,
          value: newWidth
        });

        this.setStateWithData({
          resized: newResized
        }, function () {
          return onResizedChange && onResizedChange(newResized, event);
        });
      }
    }, {
      key: 'resizeColumnEnd',
      value: function resizeColumnEnd(event) {
        event.stopPropagation();
        var isTouch = event.type === 'touchend' || event.type === 'touchcancel';

        if (isTouch) {
          document.removeEventListener('touchmove', this.resizeColumnMoving);
          document.removeEventListener('touchcancel', this.resizeColumnEnd);
          document.removeEventListener('touchend', this.resizeColumnEnd);
        }

        // If its a touch event clear the mouse one's as well because sometimes
        // the mouseDown event gets called as well, but the mouseUp event doesn't
        document.removeEventListener('mousemove', this.resizeColumnMoving);
        document.removeEventListener('mouseup', this.resizeColumnEnd);
        document.removeEventListener('mouseleave', this.resizeColumnEnd);

        // The touch events don't propagate up to the sorting's onMouseDown event so
        // no need to prevent it from happening or else the first click after a touch
        // event resize will not sort the column.
        if (!isTouch) {
          this.setStateWithData({
            skipNextSort: true,
            currentlyResizing: false
          });
        }
      }
    }]);

    return _class;
  }(Base);
});
//# sourceMappingURL=data:application/json;base64,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