<?php
class push extends control
{
    public function __construct()
    {
        parent::__construct();
        $this->loadModel('setting');
    }

    /**
     * push admin.
     *
     * @param  int    $type android|ios|all
     * @access public
     * @return void
     */
    public function admin($type = 'all')
    {
        if(!empty($_POST))
        {
            if($type == 'all')
            {
                $result = $this->push->setPushSetting($_POST);
                $result['locate'] = inlink('admin', "type=$type");
            }
            else
            {
                $result = $this->push->setPushConfig($type);
            }
            $this->send($result);
        }

        $enable	       = $this->setting->getItem("owner=system&module=push&section=common&key=enable");
        $privacyLevel  = $this->setting->getItem("owner=system&module=push&section=common&key=privacyLevel");
        $iosConfig     = $this->setting->getItem("owner=system&module=push&section=ios&key=xuan_im");
        $androidConfig = $this->setting->getItem("owner=system&module=push&section=android&key=xinge");
        if(!isset($privacyLevel) || empty($enable)) $this->push->setPushSetting();

        $this->view->title         = $this->lang->push->admin;
        $this->view->type          = $type;
        $this->view->iosConfig     = empty($iosConfig)     ? '' : json_decode($iosConfig);
        $this->view->androidConfig = empty($androidConfig) ? '' : json_decode($androidConfig);
        $this->view->enable 	   = !empty($enable) ? $enable : $this->setting->getItem("owner=system&module=push&section=common&key=enable");
        $this->view->privacyLevel  = !empty($privacyLevel) ? $privacyLevel : $this->setting->getItem("owner=system&module=push&section=common&key=privacyLevel");
        $this->display();
    }

    /**
     * push edit.
     *
     * @param  int    $type android|ios|all
     * @access public
     * @return void
     */
    public function edit($type = 'android')
    {
        if(!empty($_POST))
        {
            $result = $this->push->setPushConfig($type);
            if(!empty($result)) $this->send($result);
        }

        $iosConfig     = $this->setting->getItem("owner=system&module=push&section=ios&key=xuan_im");
        $iosConfig     = empty($iosConfig) ? '' : json_decode($iosConfig);
        $androidConfig = $this->setting->getItem("owner=system&module=push&section=android&key=xinge");
        $androidConfig = empty($androidConfig) ? '' : json_decode($androidConfig);

        $this->view->title         = $this->lang->push->admin;
        $this->view->type          = $type;
        $this->view->currentConfig = $type == 'android' ? $androidConfig : $iosConfig;
        $this->display();
    }

    /**
     * push message.
     *
     * @access public
     * @return void
     */
    public function pushMessage()
    {
        // check is push
        $enable = $this->setting->getItem("owner=system&module=push&section=common&key=enable");
        if($enable == 'close') return;

        $pushList = $this->loadModel('push')->getPushList();
        if(empty($pushList)) return;

        foreach($pushList as $pushItem)
        {
            // check queue addDate < $this->config->push->timeOut
            $differenceTime = strtotime(helper::now()) - strtotime($pushItem->addDate);
            if($differenceTime > $this->config->push->TIMEOUT)
            {
                $this->push->changeQueueStatus($pushItem->id, 'outdated');
                continue;
            }

            $queueContent = json_decode($pushItem->content);
            $receivers    = explode(',', $queueContent->receivers);

            // check user is offline.
            foreach($receivers as $key => $userID)
            {
                $userInfo = $this->loadModel('user')->getDeviceInfo($userID);
                if(reset($userInfo)->clientStatus != 'offline') unset($receivers[$key]);
            }
            if(empty($receivers)) continue;

            $this->push->pushMessage($queueContent->sender, $receivers, $queueContent->cgid);
            $this->push->changeQueueStatus($pushItem->id, 'done');
        }
    }
}
