ALTER TABLE `im_message` ADD `legacy` tinyint(1) NOT NULL DEFAULT 1 AFTER `deleted`;
ALTER TABLE `im_message` MODIFY `legacy` tinyint(1) NOT NULL DEFAULT 0;
ALTER TABLE `im_message` ADD `uniqueIndex` int(11) GENERATED ALWAYS AS (CASE WHEN `legacy` = 1 THEN NULL WHEN `cgid` = 'notification' THEN NULL ELSE `index` END) STORED AFTER `legacy`;
ALTER TABLE `im_message` ADD CONSTRAINT uniqueIndexInChat UNIQUE (`cgid`, `uniqueIndex`);

ALTER TABLE `im_conference` ADD `moderators` text NOT NULL AFTER `reminderTime`;
ALTER TABLE `im_conference` ADD `isPrivate` enum ('0', '1') NOT NULL DEFAULT '0' AFTER `moderators`;
ALTER TABLE `im_conference` ADD `isInner` enum('0', '1') NOT NULL DEFAULT '1' AFTER `isPrivate`;
ALTER TABLE `im_conference` ALTER COLUMN `status` SET DEFAULT 'notStarted';

-- DROP TABLE IF EXISTS `im_conferenceinvite`;
CREATE TABLE IF NOT EXISTS `im_conferenceinvite` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `conferenceID` mediumint(8) unsigned NOT NULL,
  `inviteeID` mediumint(8) unsigned NOT NULL,
  `status` enum('pending', 'accepted', 'rejected') NOT NULL DEFAULT 'pending',
  `createdDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updatedDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `conference_user` (`conferenceID`, `inviteeID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
