<?php
/**
 * The view file of groupsetting module of XXB.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd., www.zentao.net)
 * @license     ZOSL (https://zpl.pub/page/zoslv1.html)
 * @author      Deqing Chai <chaideqing@cnezsoft.com>
 * @package     groupsetting
 * @version     $Id$
 * @link        https://xuanim.com
 */
?>
<?php include '../../common/view/header.html.php';?>
<?php $this->app->loadLang('client')?>
<div class='panel'>
  <div class='panel-heading'>
    <strong><?php echo $lang->setting->param;?></strong>
  </div>
  <form method='post' id='ajaxForm' class='form-ajax'>
    <table class='table table-form'>
      <tbody>
        <tr>
          <th class="w-150px"><?php echo $lang->enableSystemChatGroup; ?></th>
          <td class='w-200px'>
            <?php $disableSystemGroupChat = zget($config->xuanxuan, 'disableSystemGroupChat', 'off');?>
            <?php echo $type == 'edit' ? html::radio('disableSystemGroupChat', $lang->systemGroupChatOptions, $disableSystemGroupChat, "class='checkbox'") : zget($lang->systemGroupChatOptions, $disableSystemGroupChat);?>
          </td>
        </tr>
        <?php if($enableConference): ?>
        <tr>
          <th class="w-150px"><?php echo $lang->enableSystemConference; ?></th>
          <td class="w-200px">
            <?php
              $enableSystemConference = zget($config->xuanxuan, 'enableSystemConference', 1);
              echo $type == 'edit'
                ? html::radio('enableSystemConference', $lang->enableSystemConferenceOptions, $enableSystemConference, "class='checkbox'")
                : zget($lang->enableSystemConferenceOptions, $enableSystemConference);
            ?>
          </td>
        </tr>
        <?php endif; ?>
        <tr>
          <th></th>
          <td class='text-muted w-200px'><?php if($type == 'edit') echo $lang->disableSystemGroupChatTip;?></td>
        </tr>
        <?php /* TODO: revive this in 6.3.
        <tr>
          <th><?php echo $lang->cleanDismissGroup?></th>
          <td class='w-150px'>
            <?php $cleanDismissGroupState = zget($config->xuanxuan, 'enableCleanDismissGroup', 'off');?>
            <?php echo $type == 'edit' ? html::radio('enableCleanDismissGroup', $lang->cleanDismissGroupOptions, $cleanDismissGroupState, "class='checkbox'") : zget($lang->cleanDismissGroupOptions, $cleanDismissGroupState);?>
          </td>
          <td class='text-muted'><?php if($type == 'edit') echo $lang->cleanDismissGroupTip;?></td>
        </tr>
        */ ?>

        <tr>
          <th></th>
          <td colspan='2'>
            <?php if($type == 'edit'):?>
              <?php echo html::submitButton();?>
              <?php echo html::a(helper::createLink('groupsetting', 'admin'), $lang->goback, 'class="btn"');?>
            <?php else:?>
              <?php echo html::a(helper::createLink('groupsetting', 'admin', 'type=edit'), $lang->im->changeSetting, "class='btn'");?>
            <?php endif;?>
          </td>
        </tr>
      </tbody>
    </table>
  </form>
</div>
<?php include '../../common/view/footer.html.php';?>
