<?php
/**
 * The control file of ldap of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2023 ZenTao Software (Qingdao) Co., Ltd. (www.zentao.net)
 * @license     LGPL (http://www.gnu.org/licenses/lgpl.html)
 * @author      Yidong Wang <yidong@cnezsoft.com>
 * @package     ldap
 * @version     $Id$
 * @link        http://www.zentao.net
 */
class ldap extends control
{
    public function index($type = 'view')
    {
        if(!empty($_POST))
        {
            $result = $this->ldap->setConfiguration($_POST);
            $this->send($result);
        }

        $ldap = $this->ldap->getConfiguration();

        $this->view->type        = $type;
        $this->view->enabled     = isset($ldap->enabled) ? $ldap->enabled : false;
        $this->view->host        = isset($ldap->host) ? $ldap->host : '';
        $this->view->port        = isset($ldap->port) ? $ldap->port : '389';
        $this->view->version     = isset($ldap->version) ? $ldap->version : '3';
        $this->view->admin       = isset($ldap->admin) ? $ldap->admin : '';
        $this->view->password    = isset($ldap->password) ? $ldap->password : '';
        $this->view->baseDN      = isset($ldap->baseDN) ? $ldap->baseDN : '';
        $this->view->charset     = isset($ldap->charset) ? $ldap->charset : 'UTF-8';
        $this->view->account     = isset($ldap->account) ? $ldap->account : 'samaccountname';
        $this->view->displayName = isset($ldap->displayName) ? $ldap->displayName : 'displayname';
        $this->view->autoCreate  = isset($ldap->autoCreate) ? $ldap->autoCreate : '0';

        $this->display();
    }
}
