<?php
/**
 * The create view of entry module of XXB.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd., www.zentao.net)
 * @license     ZOSL (https://zpl.pub/page/zoslv1.html)
 * @author      Chunsheng Wang <chunsheng@cnezsoft.com>
 * @package     entry
 * @version     $Id: create.html.php 4091 2016-09-30 07:16:50Z daitingting $
 * @link        https://xuanim.com
 */
include '../../common/view/header.html.php';
include '../../common/view/chosen.html.php';
js::set('loginUrl', $lang->entry->login);
js::set('loginPlaceholder', $lang->entry->note->login);
js::set('chanzhiURL', $lang->entry->chanzhiURL);
js::set('chanzhiPlaceholder', $lang->entry->chanzhiPlaceholder);
js::set('zentaoURL', $lang->entry->zentaoURL);
js::set('zentaoPlaceholder', $lang->entry->zentaoPlaceholder);
js::set('zentaoName', $lang->entry->zentao);
?>
<div class='panel'>
  <div class='panel-heading'>
    <strong><i class='icon-cube'></i> <?php echo $lang->entry->create;?></strong>
  </div>
  <div class='panel-body'>
    <form method='post' class='form' id='entryForm'>
      <table class='table table-form'>
        <tr>
          <th class='w-100px'><?php echo $lang->entry->name;?></th>
          <td class='w-p50'>
            <div class='input-group'>
              <?php echo html::input('name', '', "class='form-control' placeholder='{$lang->entry->note->name}'");?>
              <div class='input-group-addon'>
                <label class="checkbox-inline"><input type="checkbox" id="visible" name="visible" value="1" checked="checked"> <?php echo $lang->entry->note->visible;?></label>
              </div>
            </div>
          </td>
          <td></td>
        </tr>
        <tr>
          <th><?php echo $lang->entry->code;?></th>
          <td><?php echo html::input('code', '', "class='form-control' placeholder='{$lang->entry->note->code}'");?></td>
          <td></td>
        </tr>
        <tr>
          <th><?php echo $lang->entry->login;?></th>
          <td><?php echo html::input('login', '', "class='form-control' placeholder='{$lang->entry->note->login}'");?></td>
          <?php if($this->server->request_scheme == 'https'):?>
          <td class='text-danger'><?php echo $lang->entry->note->scheme;?></td>
          <?php else:?>
          <td></td>
          <?php endif;?>
        </tr>
        <tr class='hide'>
          <th><?php echo $lang->entry->zentaoAdmin;?></th>
          <td>
            <div class='required required-wrapper'></div>
            <div class='input-group'>
              <label class='input-group-addon fix-border'><?php echo $lang->account;?></label>
              <?php echo html::input('adminAccount', '', "class='form-control' placeholder='{$lang->entry->adminAccount}'");?>
              <label class='input-group-addon fix-border'><?php echo $lang->password;?></label>
              <?php echo html::password('adminPassword', '', "class='form-control' placeholder='{$lang->entry->adminPassword}'");?>
            </div>
          </td>
          <td></td>
        </tr>
        <tr class="entry-files hide">
          <th><?php echo $lang->entry->extend;?></th>
          <td><?php echo $this->fetch('file', 'buildform', 'fileCount=1');?></td>
          <td></td>
        </tr>
        <tr>
          <th class='w-100px'><?php echo $lang->entry->integration; ?></th>
          <td class='w-p50'><?php echo html::radio('integration', $lang->entry->integrationList, false);?></td>
          <td><span class="text-muted"><?php echo $lang->entry->ssoPS; ?></span></td>
        </tr>
        <tbody class="integration hide">
        <tr>
          <th><?php echo $lang->entry->logout;?></th>
          <td><?php echo html::input('logout', '', "class='form-control' placeholder='{$lang->entry->note->logout}'");?></td>
          <td></td>
        </tr>
        <tr>
          <th><?php echo $lang->entry->key;?></th>
          <td><?php echo html::input('key', '', "class='form-control' readonly='readonly'");?></td>
          <td><?php echo html::a('javascript:void(0)', $lang->entry->createKey, 'class="btn btn-link" onclick="createKey()"')?></td>
        </tr>
        <tr>
          <th><?php echo $lang->entry->ip;?></th>
          <td>
            <?php echo html::input('ip', '*', "class='form-control' title='{$lang->entry->note->ip}' placeholder='{$lang->entry->note->ip}'");?>
          </td>
          <td><button type='button' id='allip' name='allip' class='btn btn-link'> <?php echo $lang->entry->note->allip;?></button></td>
        </tr>
        </tbody>
        <tr>
          <th class='w-100px'><?php echo $lang->entry->optional;?></th>
          <td class='w-p50'><?php echo html::radio('optional', $lang->entry->optionalList, false);?></td>
        </tr>
        <tbody class="optional hide">
        <tr>
          <th class='w-100px'><?php echo $lang->entry->enable;?></th>
          <td class='w-p50'><?php echo html::radio('enable', $lang->entry->enableList, false);?></td>
        </tr>
        </tbody>
        <tr>
          <th></th><td><?php echo html::submitButton() . ' ' . html::backButton();?></td><td></td>
        </tr>

      </table>
    </form>
  </div>
</div>
<?php include '../../common/view/footer.html.php';?>
