<?php
/**
 * The sys app router file of XXB.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd., www.zentao.net)
 * @license     ZOSL (https://zpl.pub/page/zoslv1.html)
 * @author      Chunsheng Wang <chunsheng@cnezsoft.com>
 * @package     XXB
 * @version     $Id: index.php 3138 2015-11-09 07:32:18Z chujilu $
 * @link        https://xuanim.com
 */
/* Set the error reporting. */
error_reporting(E_ALL);

/* Start output buffer. */
ob_start();

/* Define the run mode as front by default. */
$runMode = 'front';

/* Check if the request is from xxd and switch to xuanxuan run mode. */
if(strpos($_SERVER['HTTP_USER_AGENT'], 'easysoft/xuan.im') !== false) $runMode = 'xuanxuan';

define('RUN_MODE', $runMode);

/* Instance the app. */
global $app;
$app = router::createApp('xxb', dirname(dirname(__FILE__)));

/* Reset the config params to make sure the help/license will be lauched. */
$app->config->requestType     = 'GET';
$app->config->default->module = 'help';
$app->config->default->method = 'license';
$app->licenseData             = $licenseData;
// $app->URL = helper::createLink('help', 'license', "errCode=$err_code");

$app->setDebug();

/* Run it. */
$app->parseRequest();
$app->loadModule();

/* Flush the buffer. */
echo helper::removeUTF8Bom(ob_get_clean());
